/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency;

import com.openindex.openestate.impl.OpenEstateUtils;
import com.openindex.openestate.impl.SimpleAdressImpl;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.agency.AgencyEstate;
import java.util.Currency;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.table.DefaultTableModel;
import org.jdesktop.application.ResourceMap;

public class AgencyEstateTableModel
extends DefaultTableModel {
    public static final int COLUMN_ID = 0;
    public static final int COLUMN_NR = 1;
    public static final int COLUMN_TYPE = 2;
    public static final int COLUMN_ACTION = 3;
    public static final int COLUMN_PRICE = 4;
    public static final int COLUMN_AREA = 5;
    public static final int COLUMN_ROOMS = 6;
    public static final int COLUMN_TITLE = 7;
    public static final int COLUMN_STREET = 8;
    public static final int COLUMN_POSTALCODE = 9;
    public static final int COLUMN_CITY = 10;
    public static final int COLUMN_CITYPART = 11;
    public static final int COLUMN_COUNTRY = 12;
    public static final int COLUMN_STATUS = 13;
    public static final int COLUMN_KONVENTIONIERT = 14;
    public static final int COLUMN_CURRENCY = 15;
    public static final int COLUMN_CHANGE_TIME = 16;
    private static final Map<Integer, String> COLUMN_NAMES = new HashMap<Integer, String>();
    private static final Map<Integer, Class> COLUMN_CLASSES;
    private ResourceMap resourceMap;

    public AgencyEstateTableModel() {
        this.setColumnCount(COLUMN_NAMES.size());
        this.resourceMap = ImmoToolUtils.getResourceMap(AgencyEstateTableModel.class);
    }

    public void addEstate(AgencyEstate.Row row) {
        this.addRow(this.buildRow(row));
    }

    private Object[] buildRow(AgencyEstate.Row row) {
        TreeMap<Integer, Object> treeMap = new TreeMap<Integer, Object>();
        treeMap.put(0, row.id);
        treeMap.put(1, row.publicId);
        treeMap.put(10, row.adressCity);
        treeMap.put(11, row.adressCityPart);
        treeMap.put(12, SimpleAdressImpl.writeCountry((String)row.adressCountry));
        treeMap.put(9, row.adressPostalCode);
        treeMap.put(8, row.adressStreet + " " + row.adressStreetNr);
        treeMap.put(7, row.title);
        String string = AgencyEstate.writeStatus(row.status);
        treeMap.put(13, string != null && string.length() > 0 ? string : row.status);
        String string2 = OpenEstateUtils.translateEstate((String)row.type);
        treeMap.put(2, string2 != null && string2.length() > 0 ? string2 : row.type);
        String string3 = OpenEstateUtils.translateAction((String)row.action);
        treeMap.put(3, string3 != null && string3.length() > 0 ? string3 : row.action);
        treeMap.put(16, row.changeTime);
        treeMap.put(5, row.attribArea != null ? Float.valueOf(row.attribArea.floatValue()) : null);
        treeMap.put(4, row.attribPrice != null ? Float.valueOf(row.attribPrice.floatValue()) : null);
        treeMap.put(6, row.attribRooms != null ? Float.valueOf(row.attribRooms.floatValue()) : null);
        treeMap.put(14, row.attribKonventioniert != null && row.attribKonventioniert.trim().length() > 0 ? OpenEstateUtils.translateAttribute((String)"PREISE", (String)"KONVENTIONIERT", (String)row.attribKonventioniert) : null);
        treeMap.put(15, row.currency);
        return treeMap.values().toArray(new Object[treeMap.size()]);
    }

    public void clear() {
        while (this.getRowCount() > 0) {
            this.removeRow(0);
        }
    }

    public Class getColumnClass(int n) {
        return COLUMN_CLASSES.containsKey(n) ? COLUMN_CLASSES.get(n) : null;
    }

    @Override
    public String getColumnName(int n) {
        return COLUMN_NAMES.containsKey(n) ? this.resourceMap.getString(COLUMN_NAMES.get(n), new Object[0]) : null;
    }

    public Long getEstateIdAt(int n) {
        int n2 = n;
        return (Long)this.getValueAt(n2, 0);
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return false;
    }

    static {
        COLUMN_NAMES.put(0, "col.id");
        COLUMN_NAMES.put(1, "col.nr");
        COLUMN_NAMES.put(2, "col.type");
        COLUMN_NAMES.put(3, "col.action");
        COLUMN_NAMES.put(4, "col.price");
        COLUMN_NAMES.put(5, "col.area");
        COLUMN_NAMES.put(6, "col.rooms");
        COLUMN_NAMES.put(7, "col.title");
        COLUMN_NAMES.put(8, "col.street");
        COLUMN_NAMES.put(9, "col.postalCode");
        COLUMN_NAMES.put(10, "col.city");
        COLUMN_NAMES.put(11, "col.citypart");
        COLUMN_NAMES.put(12, "col.country");
        COLUMN_NAMES.put(13, "col.status");
        COLUMN_NAMES.put(14, "col.konventioniert");
        COLUMN_NAMES.put(15, "col.currency");
        COLUMN_NAMES.put(16, "col.changeTime");
        COLUMN_CLASSES = new HashMap<Integer, Class>();
        COLUMN_CLASSES.put(0, Long.class);
        COLUMN_CLASSES.put(1, String.class);
        COLUMN_CLASSES.put(2, String.class);
        COLUMN_CLASSES.put(3, String.class);
        COLUMN_CLASSES.put(4, Float.class);
        COLUMN_CLASSES.put(5, Float.class);
        COLUMN_CLASSES.put(6, Float.class);
        COLUMN_CLASSES.put(7, String.class);
        COLUMN_CLASSES.put(8, String.class);
        COLUMN_CLASSES.put(9, String.class);
        COLUMN_CLASSES.put(10, String.class);
        COLUMN_CLASSES.put(11, String.class);
        COLUMN_CLASSES.put(12, String.class);
        COLUMN_CLASSES.put(13, String.class);
        COLUMN_CLASSES.put(14, String.class);
        COLUMN_CLASSES.put(15, Currency.class);
        COLUMN_CLASSES.put(16, Date.class);
    }
}

