/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.openindex.openestate.impl.EstateAttachmentImpl;
import com.openindex.openestate.impl.OpenEstateType;
import com.openindex.openestate.impl.OpenEstateUtils;
import com.openindex.openestate.tool.ImmoToolApp;
import com.openindex.openestate.tool.ImmoToolDbException;
import com.openindex.openestate.tool.ImmoToolTabPanel;
import com.openindex.openestate.tool.ImmoToolTask;
import com.openindex.openestate.tool.ImmoToolTaskDialog;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.agency.AgencyContactDialog;
import com.openindex.openestate.tool.agency.AgencyEstate;
import com.openindex.openestate.tool.agency.AgencyEstateContactTask;
import com.openindex.openestate.tool.agency.AgencyEstateStatusTask;
import com.openindex.openestate.tool.agency.AgencyEstateTableAddon;
import com.openindex.openestate.tool.agency.AgencyEstateTableModel;
import com.openindex.openestate.tool.agency.AgencyEstateViewPanel;
import com.openindex.openestate.tool.agency.AgencyEstateViewTask;
import com.openindex.openestate.tool.agency.AgencyExportInterface;
import com.openindex.openestate.tool.agency.AgencyExportList;
import com.openindex.openestate.tool.agency.AgencyExportSummary;
import com.openindex.openestate.tool.agency.AgencyExportSummaryDialog;
import com.openindex.openestate.tool.agency.AgencyExportTask;
import com.openindex.openestate.tool.agency.AgencyExposeTask;
import com.openindex.openestate.tool.agency.AgencyPluginUtils;
import com.openindex.openestate.tool.agency.export.LocalTransport;
import com.openindex.openestate.tool.utils.QuickTableExport;
import com.openindex.openestate.tool.utils.TabComponent;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Currency;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.AbstractButton;
import javax.swing.ActionMap;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.log4j.Logger;
import org.jdesktop.application.Action;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.application.Task;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.JXTitledSeparator;

public class AgencyEstateTablePanel
extends ImmoToolTabPanel {
    private static final Logger LOGGER = Logger.getLogger(AgencyEstateTablePanel.class);
    private ActionMap actionMap;
    private ResourceMap resourceMap;
    private AgencyEstateTableModel resultTableModel;
    private JFormattedTextField estateIdField;
    private JTextField estateNrField;
    private JTextField estatePostalCodeField;
    private JTextField estateCityField;
    private JComboBox estateTypeField;
    private JComboBox estateActionField;
    private JComboBox estateFilterField;
    private JComboBox estateStatusField;
    private JMenuItem estateActionModifyItem;
    private JMenuItem estateActionCopyItem;
    private JMenuItem estateActionRemoveItem;
    private JMenuItem estateActionContactItem;
    private JMenuItem estateActionPdfItem;
    private JMenu estateActionExportMenu;
    private JMenu estateActionSaveMenu;
    private JMenu estateActionStatusMenu;
    private Map<Class, AgencyEstateTableAddon> tableAddons;
    private boolean isSearching = false;
    private JButton closeButton;
    private JButton estateAddButton;
    private JPanel formPanel;
    private JButton helpButton;
    private JXTitledSeparator resultLabel;
    private JScrollPane resultScrollPane;
    private JXTable resultTable;
    private JButton searchButton;
    private JButton showActionsButton;
    private JXTitledSeparator titleLabel;

    public AgencyEstateTablePanel() {
        this.build();
    }

    private void build() {
        this.actionMap = ImmoToolUtils.getActionMap(AgencyEstateTablePanel.class, (Object)((Object)this));
        this.resourceMap = ImmoToolUtils.getResourceMap(AgencyEstateTablePanel.class);
        this.initComponents();
        this.buildFormPanel();
        this.resourceMap.injectComponents((Component)((Object)this));
        this.tableAddons = new HashMap<Class, AgencyEstateTableAddon>();
        try {
            for (AgencyEstateTableAddon object : AgencyEstateTableAddon.listAddons()) {
                if (!object.isUsable()) continue;
                this.tableAddons.put(object.getClass(), object);
            }
        }
        catch (Exception exception) {
            LOGGER.warn((Object)"Can't load table addons!");
            LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
        }
        this.estateActionModifyItem = new JMenuItem(this.actionMap.get("doEstateModify"));
        this.estateActionCopyItem = new JMenuItem(this.actionMap.get("doEstateCopy"));
        this.estateActionRemoveItem = new JMenuItem(this.actionMap.get("doEstateRemove"));
        this.estateActionPdfItem = new JMenuItem(this.actionMap.get("doCreateExpose"));
        this.estateActionExportMenu = new JMenu();
        this.estateActionExportMenu.setName("estateActionExportMenu");
        this.resourceMap.injectComponent((Component)this.estateActionExportMenu);
        this.estateActionSaveMenu = new JMenu();
        this.estateActionSaveMenu.setName("estateActionSaveMenu");
        this.resourceMap.injectComponent((Component)this.estateActionSaveMenu);
        this.estateActionContactItem = new JMenuItem(this.actionMap.get("doEstateModifyContact"));
        this.estateActionContactItem.setName("estateActionContactItem");
        this.estateActionStatusMenu = new JMenu(this.resourceMap.getString("label.changeStatus", new Object[0]));
        this.estateActionStatusMenu.setName("estateActionStatusMenu");
        for (final String string : AgencyEstate.getStatusList()) {
            JMenuItem jMenuItem = new JMenuItem(AgencyEstate.writeStatus(string));
            jMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    AgencyEstateTablePanel.this.doEstateModifyStatus(string);
                }
            });
            this.estateActionStatusMenu.add(jMenuItem);
        }
        this.resourceMap.injectComponent((Component)this.estateActionStatusMenu);
        this.resultTableModel = new AgencyEstateTableModel();
        this.resultTable.setModel((TableModel)this.resultTableModel);
        this.resultTable.getColumnExt(16).setVisible(false);
        this.resultTable.getColumnExt(15).setVisible(false);
        this.resultTable.getColumnExt(14).setVisible(false);
        this.resultTable.getColumnExt(12).setVisible(false);
        this.resultTable.getColumnExt(11).setVisible(false);
        this.resultTable.setSortable(true);
        this.resultTable.setColumnControl((JComponent)QuickTableExport.createColumnControl((JXTable)this.resultTable));
        ImmoToolUtils.configureTable((JXTable)this.resultTable);
        this.resultTable.setDefaultRenderer(Date.class, (TableCellRenderer)new DateRenderer());
        this.resultTable.getColumn(5).setCellRenderer(new AreaRenderer());
        this.resultTable.getColumn(4).setCellRenderer(new PriceRenderer());
        this.resultTable.getColumn(6).setCellRenderer(new RoomsRenderer());
        this.resultTable.getSelectionModel().setSelectionMode(2);
        this.resultTable.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getButton() == 1 && mouseEvent.getClickCount() == 2) {
                    AgencyEstateTablePanel.this.doEstateModify();
                } else if (mouseEvent.getButton() == 3 && mouseEvent.getClickCount() == 1) {
                    if (AgencyEstateTablePanel.this.resultTable.getSelectedRow() < 0) {
                        int n = AgencyEstateTablePanel.this.resultTable.rowAtPoint(mouseEvent.getPoint());
                        if (n < 0) {
                            return;
                        }
                        AgencyEstateTablePanel.this.resultTable.getSelectionModel().setSelectionInterval(n, n);
                    }
                    AgencyEstateTablePanel.this.showActionMenu((Component)AgencyEstateTablePanel.this.resultTable, ((AgencyEstateTablePanel)AgencyEstateTablePanel.this).resultTable.getMousePosition().x, ((AgencyEstateTablePanel)AgencyEstateTablePanel.this).resultTable.getMousePosition().y);
                }
            }
        });
        this.resultTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                AgencyEstateTablePanel.this.showActionsButton.setEnabled(AgencyEstateTablePanel.this.resultTable.getSelectedRow() >= 0);
            }
        });
        this.closeButton.setAction(this.actionMap.get(this.closeButton.getText()));
        this.estateAddButton.setAction(this.actionMap.get(this.estateAddButton.getText()));
        this.searchButton.setAction(this.actionMap.get(this.searchButton.getText()));
        this.helpButton.setAction(this.actionMap.get(this.helpButton.getText()));
        this.showActionsButton.setAction(this.actionMap.get(this.showActionsButton.getText()));
        this.showActionsButton.setEnabled(false);
    }

    private void buildFormPanel() {
        KeyAdapter keyAdapter = new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10 && !AgencyEstateTablePanel.this.isSearching) {
                    ImmoToolUtils.executeTask((Task)AgencyEstateTablePanel.this.doSearch());
                }
            }
        };
        this.estateIdField = new JFormattedTextField(NumberFormat.getIntegerInstance());
        this.estateIdField.setName("estateIdField");
        this.estateIdField.addKeyListener(keyAdapter);
        this.estateIdField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                if (!AgencyEstateTablePanel.this.estateIdField.isEditValid()) {
                    AgencyEstateTablePanel.this.estateIdField.setValue(null);
                }
            }
        });
        this.estateNrField = new JTextField();
        this.estateNrField.setName("estateNrField");
        this.estateNrField.addKeyListener(keyAdapter);
        this.estatePostalCodeField = new JTextField();
        this.estatePostalCodeField.setName("estatePostalCodeField");
        this.estatePostalCodeField.addKeyListener(keyAdapter);
        this.estateCityField = new JTextField();
        this.estateCityField.setName("estateCityField");
        this.estateCityField.addKeyListener(keyAdapter);
        this.estateTypeField = new JComboBox();
        this.estateTypeField.setRenderer(new EstateTypeRenderer());
        this.estateTypeField.setName("estateTypeField");
        this.estateActionField = new JComboBox();
        this.estateActionField.setRenderer(new EstateActionRenderer());
        this.estateActionField.setName("estateActionField");
        this.estateFilterField = new JComboBox();
        this.estateFilterField.setName("estateFilterField");
        this.estateFilterField.setEnabled(false);
        this.estateStatusField = new JComboBox();
        this.estateStatusField.setRenderer(new EstateStatusRenderer());
        this.estateStatusField.setName("estateStatusField");
        DefaultFormBuilder defaultFormBuilder = ImmoToolUtils.createFormBuilder((String)"right:pref, 3dlu, 20dlu, 3dlu, right:pref, 3dlu, 50dlu, 3dlu, right:pref, 3dlu, 30dlu:grow, 3dlu, right:pref, 3dlu, 30dlu:grow, 3dlu", (JPanel)this.formPanel);
        defaultFormBuilder.append(this.resourceMap.getString("label.estateIdField", new Object[0]), (Component)this.estateIdField);
        defaultFormBuilder.append(this.resourceMap.getString("label.estatePostalCodeField", new Object[0]), (Component)this.estatePostalCodeField);
        defaultFormBuilder.append(this.resourceMap.getString("label.estateTypeField", new Object[0]), (Component)this.estateTypeField);
        defaultFormBuilder.append(this.resourceMap.getString("label.estateStatusField", new Object[0]), (Component)this.estateStatusField);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(this.resourceMap.getString("label.estateNrField", new Object[0]), (Component)this.estateNrField);
        defaultFormBuilder.append(this.resourceMap.getString("label.estateCityField", new Object[0]), (Component)this.estateCityField);
        defaultFormBuilder.append(this.resourceMap.getString("label.estateActionField", new Object[0]), (Component)this.estateActionField);
        defaultFormBuilder.append(this.resourceMap.getString("label.estateFilterField", new Object[0]), (Component)this.estateFilterField);
        defaultFormBuilder.nextLine();
        this.formPanel.revalidate();
        this.formPanel.repaint();
    }

    @Action
    public void doClose() {
        ImmoToolUtils.removePanel((String)this.getTabTitle());
    }

    @Action
    public Task doCreateExpose() {
        if (this.resultTable.getSelectedRowCount() < 1) {
            return null;
        }
        ArrayList<Long> arrayList = new ArrayList<Long>();
        for (int n : this.resultTable.getSelectedRows()) {
            int n2 = this.resultTable.convertRowIndexToModel(n);
            arrayList.add(this.resultTableModel.getEstateIdAt(n2));
        }
        final AgencyEstateTablePanel agencyEstateTablePanel = this;
        return new AgencyExposeTask(arrayList.toArray(new Long[arrayList.size()]), ImmoToolApp.getApplication().getMainFrame()){
            {
                super(longArray, frame);
                this.setTitle(AgencyEstateTablePanel.this.resourceMap.getString("doCreateExpose.Action.text", new Object[0]));
            }

            protected void failed(Throwable throwable) {
                super.failed(throwable);
                ImmoToolUtils.showMessageErrorDialog((String)AgencyEstateTablePanel.this.resourceMap.getString("doCreateExpose.Message.error", new Object[0]), (Throwable)throwable);
            }

            protected void succeeded(Boolean bl) {
                super.succeeded((Object)bl);
                if (!Boolean.TRUE.equals(bl)) {
                    return;
                }
                if (this.isSavedToFile()) {
                    ImmoToolUtils.showMessageInfoDialog((String)AgencyEstateTablePanel.this.resourceMap.getString("doCreateExpose.Message.success", new Object[0]), (Component)((Object)agencyEstateTablePanel));
                }
            }
        };
    }

    @Action
    public Task doEstateAdd() {
        String string = AgencyEstateViewPanel.getInstanceTabTitle(null, null);
        if (ImmoToolUtils.selectPanel((String)string)) {
            return null;
        }
        this.setButtonsEnabled(false);
        return new ImmoToolTask<AgencyEstateViewPanel>(){

            protected AgencyEstateViewPanel executeTask() throws Exception {
                return new AgencyEstateViewPanel();
            }

            protected void failed(Throwable throwable) {
                super.failed(throwable);
                ImmoToolUtils.showMessageErrorDialog((String)AgencyEstateTablePanel.this.resourceMap.getString("error.cantLoadEstateForm", new Object[0]), (Throwable)throwable);
            }

            protected void finished() {
                super.finished();
                AgencyEstateTablePanel.this.setButtonsEnabled(true);
            }

            protected void succeeded(AgencyEstateViewPanel agencyEstateViewPanel) {
                super.succeeded((Object)agencyEstateViewPanel);
                ImmoToolUtils.showPanel((TabComponent)agencyEstateViewPanel);
                agencyEstateViewPanel.executeFormTasks();
            }
        };
    }

    @Action
    public void doEstateCopy() {
        if (this.resultTable.getSelectedRowCount() < 1) {
            return;
        }
        final ArrayList<Long> arrayList = new ArrayList<Long>();
        for (int n : this.resultTable.getSelectedRows()) {
            int n2 = this.resultTable.convertRowIndexToModel(n);
            arrayList.add(this.resultTableModel.getEstateIdAt(n2));
        }
        boolean bl = ImmoToolUtils.showQuestionDialog((String)this.resourceMap.getString("question.reallyCopyEstates", new Object[0]), (Component)((Object)this));
        if (!bl) {
            return;
        }
        this.setButtonsEnabled(false);
        ImmoToolTask<Boolean> immoToolTask = new ImmoToolTask<Boolean>(this.resourceMap.getString("doEstateCopy.Action.text", new Object[0])){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected Boolean executeTask() throws Exception {
                for (Long l : arrayList) {
                    AgencyEstate agencyEstate = AgencyEstate.loadEstate(l);
                    if (agencyEstate == null) {
                        LOGGER.warn((Object)("estate #" + l + " not found!"));
                        continue;
                    }
                    this.setMessage("#" + agencyEstate.getIdNr());
                    agencyEstate.setId(null);
                    agencyEstate.setPublicId(null);
                    agencyEstate.setNrIntern(null);
                    Long l2 = AgencyEstate.storeEstate(agencyEstate);
                    if (l2 == null || l2 <= 0L) {
                        throw new Exception(AgencyEstateTablePanel.this.resourceMap.getString("error.cantSaveEstate", new Object[0]));
                    }
                    boolean bl = false;
                    for (EstateAttachmentImpl estateAttachmentImpl : agencyEstate.getAttachments()) {
                        Object object;
                        Object object2;
                        Object object3;
                        if (estateAttachmentImpl.isUrl()) {
                            object3 = estateAttachmentImpl.getFileAsUrl();
                            object2 = null;
                            object = null;
                            try {
                                object2 = ((URL)object3).openStream();
                                object = AgencyEstate.storeAttachment(l2, (InputStream)object2, new File(((URL)object3).getFile()).getName(), estateAttachmentImpl.getMimeType());
                            }
                            finally {
                                if (object2 != null) {
                                    ((InputStream)object2).close();
                                }
                            }
                            if (object == null) {
                                LOGGER.warn((Object)"Anhang konnte nicht gespeichert werden!");
                                LOGGER.warn((Object)("> Immobilie #" + l2));
                                LOGGER.warn((Object)("> URL: " + ((URL)object3).toString()));
                                continue;
                            }
                            estateAttachmentImpl.setFile((String)object);
                            bl = true;
                            continue;
                        }
                        if (!estateAttachmentImpl.isName()) continue;
                        object3 = estateAttachmentImpl.getFileAsName();
                        object2 = AgencyEstate.loadAttachmentAsTempFile(l, (String)object3);
                        if (object2 == null) {
                            LOGGER.warn((Object)"Anhang nicht gefunden!");
                            LOGGER.warn((Object)("> Immobilie #" + l));
                            LOGGER.warn((Object)("> Datei: " + (String)object3));
                            continue;
                        }
                        object = null;
                        try {
                            object = new FileInputStream((File)object2);
                            String string = AgencyEstate.storeAttachment(l2, (InputStream)object, estateAttachmentImpl.getFileAsName(), estateAttachmentImpl.getMimeType());
                            estateAttachmentImpl.setFile(string);
                            bl = true;
                        }
                        catch (Throwable throwable) {
                            IOUtils.closeQuietly(object);
                            FileUtils.deleteQuietly((File)object2);
                            throw throwable;
                        }
                        IOUtils.closeQuietly((InputStream)object);
                        FileUtils.deleteQuietly((File)object2);
                    }
                    if (bl) {
                        AgencyEstate.storeEstate(agencyEstate);
                    }
                    AgencyEstate.removeUnusedAttachments(agencyEstate);
                    if (!agencyEstate.isExportEnabled() || !"VERMITTLUNG".equalsIgnoreCase(agencyEstate.getStatus())) continue;
                    AgencyExportList.registerChanges(agencyEstate, "update");
                }
                return true;
            }

            protected void failed(Throwable throwable) {
                super.failed(throwable);
                ImmoToolUtils.showMessageErrorDialog((String)AgencyEstateTablePanel.this.resourceMap.getString("error.cantCopyEstate", new Object[0]), (Throwable)throwable);
            }

            protected void finished() {
                super.finished();
                AgencyEstateTablePanel.this.setButtonsEnabled(true);
            }

            protected void succeeded(Boolean bl) {
                super.succeeded((Object)bl);
                ImmoToolUtils.executeTask((Task)AgencyEstateTablePanel.this.doSearch());
                ImmoToolUtils.showMessageInfoDialog((String)AgencyEstateTablePanel.this.resourceMap.getString("message.estateCopied", new Object[0]), (Component)this.getTaskDialog());
            }
        };
        ImmoToolTaskDialog.execute((ImmoToolTask)immoToolTask);
    }

    private void doEstateExport(long l, boolean bl) {
        if (this.resultTable.getSelectedRowCount() < 1) {
            return;
        }
        AgencyExportTask agencyExportTask = null;
        try {
            AgencyExportInterface agencyExportInterface = AgencyExportInterface.loadExportInterface(l);
            if (agencyExportInterface == null) {
                throw new Exception(this.resourceMap.getString("error.cantLoadExportSetup", new Object[]{l}));
            }
            ArrayList<AgencyEstate> arrayList = new ArrayList<AgencyEstate>();
            for (int n : this.resultTable.getSelectedRows()) {
                int n2 = this.resultTable.convertRowIndexToModel(n);
                long l2 = this.resultTableModel.getEstateIdAt(n2);
                AgencyEstate agencyEstate = AgencyEstate.loadEstate(l2);
                if (agencyEstate == null) continue;
                arrayList.add(agencyEstate);
            }
            Object object = AgencyExportSummary.buildSummary(agencyExportInterface, arrayList);
            if (((AgencyExportSummary)object).getUpdatedEstateIds().isEmpty() && ((AgencyExportSummary)object).getRemovedEstateIds().isEmpty()) {
                if (agencyExportInterface.getLimit() > 0L) {
                    ImmoToolUtils.showMessageInfoDialog((String)this.resourceMap.getString("message.noExportableEstatesFound.limited", new Object[]{agencyExportInterface.getLimit()}));
                } else {
                    ImmoToolUtils.showMessageInfoDialog((String)this.resourceMap.getString("message.noExportableEstatesFound", new Object[0]));
                }
                return;
            }
            if (bl) {
                JFileChooser jFileChooser = new JFileChooser();
                jFileChooser.setDialogTitle(this.resourceMap.getString("message.selectExportDir", new Object[0]));
                jFileChooser.setFileSelectionMode(1);
                int n = jFileChooser.showSaveDialog((Component)((Object)this));
                if (n != 0) {
                    return;
                }
                LocalTransport localTransport = new LocalTransport();
                localTransport.setLocalDirectory(jFileChooser.getSelectedFile());
                agencyExportInterface.setTransport(localTransport);
                agencyExportInterface.setLimit(0L);
            } else {
                AgencyExportSummaryDialog agencyExportSummaryDialog = new AgencyExportSummaryDialog();
                agencyExportSummaryDialog.addExport((AgencyExportSummary)object, agencyExportInterface);
                agencyExportSummaryDialog.finishTable();
                agencyExportSummaryDialog.setVisible(true);
                if (agencyExportSummaryDialog.getStatus() != 2) {
                    return;
                }
                object = agencyExportSummaryDialog.getSummary(agencyExportInterface.getId());
            }
            agencyExportTask = new AgencyExportTask(agencyExportInterface, (AgencyExportSummary)object, !bl){

                @Override
                protected void failed(Throwable throwable) {
                    super.failed(throwable);
                    ImmoToolUtils.showMessageErrorDialog((String)AgencyEstateTablePanel.this.resourceMap.getString("error.cantExportEstates", new Object[0]), (Throwable)throwable);
                }

                protected void finished() {
                    super.finished();
                    AgencyEstateTablePanel.this.setButtonsEnabled(true);
                }

                @Override
                protected void succeeded(AgencyExportSummary agencyExportSummary) {
                    super.succeeded(agencyExportSummary);
                    if (agencyExportSummary.isSuccessful()) {
                        ImmoToolUtils.showMessageInfoDialog((String)AgencyEstateTablePanel.this.resourceMap.getString("message.estatesExported", new Object[0]), (Component)this.getTaskDialog());
                    } else {
                        ImmoToolUtils.showMessageInfoDialog((String)AgencyEstateTablePanel.this.resourceMap.getString("error.cantExportEstates", new Object[0]), (Component)this.getTaskDialog());
                    }
                }
            };
        }
        catch (Exception exception) {
            LOGGER.error((Object)"estate-export-error!");
            LOGGER.error((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
            ImmoToolUtils.showMessageErrorDialog((String)this.resourceMap.getString("error.cantExportEstates", new Object[0]), (Throwable)exception);
            return;
        }
        this.setButtonsEnabled(false);
        ImmoToolTaskDialog.execute((ImmoToolTask)agencyExportTask);
    }

    @Action
    public void doEstateModify() {
        int n;
        int n2;
        if (this.resultTable.getSelectedRowCount() < 1) {
            return;
        }
        int n3 = n2 = this.resultTable.getSelectedRowCount() < 10 ? this.resultTable.getSelectedRowCount() : 10;
        if (n2 > 1 && (n = ImmoToolUtils.showQuestionDialog((String)this.resourceMap.getString("question.openMultipleObjects", new Object[]{n2}), (Component)((Object)this))) == 0) {
            return;
        }
        n = 0;
        for (int n4 : this.resultTable.getSelectedRows()) {
            int n5 = this.resultTable.convertRowIndexToModel(n4);
            long l = this.resultTableModel.getEstateIdAt(n5);
            ImmoToolUtils.executeTask((Task)new AgencyEstateViewTask(l, n2 == 1));
            if (++n >= 10) break;
        }
    }

    @Action
    public void doEstateModifyContact() {
        if (this.resultTable.getSelectedRowCount() < 1) {
            return;
        }
        final ArrayList<Long> arrayList = new ArrayList<Long>();
        for (int n : this.resultTable.getSelectedRows()) {
            int n2 = this.resultTable.convertRowIndexToModel(n);
            long l = this.resultTableModel.getEstateIdAt(n2);
            arrayList.add(l);
        }
        this.setButtonsEnabled(false);
        ImmoToolTaskDialog.execute((ImmoToolTask)new AgencyEstateContactTask(arrayList.toArray(new Long[arrayList.size()]), 0L){
            {
                super(longArray, l);
                this.setTitle(AgencyEstateTablePanel.this.resourceMap.getString("doEstateModifyContact.Action.text", new Object[0]));
            }

            @Override
            protected Boolean executeTask() throws Exception {
                AgencyContactDialog agencyContactDialog = new AgencyContactDialog(ImmoToolApp.getApplication().getMainFrame());
                agencyContactDialog.setMessage(AgencyEstateTablePanel.this.resourceMap.getString("question.selectAgencyContact", new Object[]{arrayList.size()}));
                agencyContactDialog.load();
                agencyContactDialog.setVisible(true);
                if (agencyContactDialog.getStatus() != 2) {
                    return false;
                }
                this.setContactId(agencyContactDialog.getContactId());
                return super.executeTask();
            }

            protected void failed(Throwable throwable) {
                super.failed(throwable);
                ImmoToolUtils.showMessageErrorDialog((String)AgencyEstateTablePanel.this.resourceMap.getString("error.cantChangeStatus", new Object[0]), (Throwable)throwable);
            }

            protected void finished() {
                super.finished();
                AgencyEstateTablePanel.this.setButtonsEnabled(true);
            }

            protected void succeeded(Boolean bl) {
                super.succeeded((Object)bl);
                if (Boolean.TRUE.equals(bl)) {
                    ImmoToolUtils.executeTask((Task)AgencyEstateTablePanel.this.doSearch());
                }
            }
        });
    }

    private void doEstateModifyStatus(String string) {
        if (this.resultTable.getSelectedRowCount() < 1) {
            return;
        }
        ArrayList<Long> arrayList = new ArrayList<Long>();
        for (int n : this.resultTable.getSelectedRows()) {
            int n2 = this.resultTable.convertRowIndexToModel(n);
            arrayList.add(this.resultTableModel.getEstateIdAt(n2));
        }
        boolean bl = ImmoToolUtils.showQuestionDialog((String)this.resourceMap.getString("question.reallyChangeStatus", new Object[]{AgencyEstate.writeStatus(string)}), (Component)((Object)this));
        if (!bl) {
            return;
        }
        this.setButtonsEnabled(false);
        ImmoToolTaskDialog.execute((ImmoToolTask)new AgencyEstateStatusTask(arrayList.toArray(new Long[arrayList.size()]), string){
            {
                this.setTitle(AgencyEstateTablePanel.this.resourceMap.getString("estateActionStatusMenu.text", new Object[0]));
            }

            protected void failed(Throwable throwable) {
                super.failed(throwable);
                ImmoToolUtils.showMessageErrorDialog((String)AgencyEstateTablePanel.this.resourceMap.getString("error.cantChangeStatus", new Object[0]), (Throwable)throwable);
            }

            protected void finished() {
                super.finished();
                AgencyEstateTablePanel.this.setButtonsEnabled(true);
            }

            protected void succeeded(Boolean bl) {
                super.succeeded((Object)bl);
                ImmoToolUtils.executeTask((Task)AgencyEstateTablePanel.this.doSearch());
            }
        });
    }

    @Action
    public void doEstateRemove() {
        if (this.resultTable.getSelectedRowCount() < 1) {
            return;
        }
        final ArrayList<Long> arrayList = new ArrayList<Long>();
        for (int n : this.resultTable.getSelectedRows()) {
            int n2 = this.resultTable.convertRowIndexToModel(n);
            arrayList.add(this.resultTableModel.getEstateIdAt(n2));
        }
        boolean bl = ImmoToolUtils.showQuestionDialog((String)this.resourceMap.getString("question.reallyDeleteEstate", new Object[0]), (Component)((Object)this));
        if (!bl) {
            return;
        }
        this.setButtonsEnabled(false);
        ImmoToolTask<Boolean> immoToolTask = new ImmoToolTask<Boolean>(this.resourceMap.getString("doEstateRemove.Action.text", new Object[0])){

            protected Boolean executeTask() throws Exception {
                for (Long l : arrayList) {
                    AgencyEstate agencyEstate = AgencyEstate.loadEstate(l);
                    if (agencyEstate == null) {
                        LOGGER.warn((Object)("estate #" + l + " not found!"));
                        continue;
                    }
                    this.setMessage("#" + agencyEstate.getIdNr());
                    if (agencyEstate.isExportEnabled() && "VERMITTLUNG".equalsIgnoreCase(agencyEstate.getStatus())) {
                        AgencyExportList.registerChanges(agencyEstate, "delete");
                    }
                    AgencyEstate.removeEstate(l);
                }
                return true;
            }

            protected void failed(Throwable throwable) {
                super.failed(throwable);
                ImmoToolUtils.showMessageErrorDialog((String)AgencyEstateTablePanel.this.resourceMap.getString("error.cantDeleteEstate", new Object[0]), (Throwable)throwable);
            }

            protected void finished() {
                super.finished();
                AgencyEstateTablePanel.this.setButtonsEnabled(true);
            }

            protected void succeeded(Boolean bl) {
                super.succeeded((Object)bl);
                ImmoToolUtils.executeTask((Task)AgencyEstateTablePanel.this.doSearch());
                ImmoToolUtils.showMessageInfoDialog((String)AgencyEstateTablePanel.this.resourceMap.getString("message.estateDeleted", new Object[0]), (Component)this.getTaskDialog());
            }
        };
        ImmoToolTaskDialog.execute((ImmoToolTask)immoToolTask);
    }

    @Action
    public void doHelp() {
        ImmoToolUtils.showHelpDialog((String)"agency.estates");
    }

    @Action
    public Task doSearch() {
        this.isSearching = true;
        this.resultTable.setEnabled(false);
        this.resultTableModel.clear();
        this.setButtonsEnabled(false);
        return new ImmoToolTask<Integer>(){

            protected Integer executeTask() throws Exception {
                AgencyEstate.Row[] rowArray;
                Object object;
                String string;
                String string2;
                String string3;
                ArrayList<String> arrayList = new ArrayList<String>();
                String string4 = AgencyEstateTablePanel.this.estateIdField.getText().trim();
                if (string4.trim().length() > 0) {
                    arrayList.add("$x/@Id='Estate." + StringEscapeUtils.escapeSql((String)string4) + "'");
                }
                if ((string3 = AgencyEstateTablePanel.this.estateNrField.getText().trim()).trim().length() > 0) {
                    arrayList.add("starts-with( upper-case($x/@PublicId), upper-case('" + StringEscapeUtils.escapeSql((String)string3) + "') ) " + "");
                }
                if ((string2 = AgencyEstateTablePanel.this.estatePostalCodeField.getText().trim()).trim().length() > 0) {
                    arrayList.add("contains(upper-case($x/openestate:Adress/@PostalCode),upper-case('" + StringEscapeUtils.escapeSql((String)string2) + "'))");
                }
                if ((string = AgencyEstateTablePanel.this.estateCityField.getText().trim()).trim().length() > 0) {
                    arrayList.add("contains(upper-case($x/openestate:Adress/@City),upper-case('" + StringEscapeUtils.escapeSql((String)string) + "'))");
                }
                if (AgencyEstateTablePanel.this.estateTypeField.getSelectedIndex() > 0) {
                    object = (OpenEstateType)AgencyEstateTablePanel.this.estateTypeField.getSelectedItem();
                    rowArray = new StringBuilder();
                    rowArray.append("[").append(OpenEstateUtils.makeCamelCase((String)object.getName())).append("]");
                    for (String object2 : OpenEstateUtils.getAllEstateSubtypes((OpenEstateType)object)) {
                        rowArray.append("[").append(OpenEstateUtils.makeCamelCase((String)object2)).append("]");
                    }
                    arrayList.add("contains( '" + rowArray.toString() + "', concat('[',local-name($x/*[3]),']') )");
                }
                if (AgencyEstateTablePanel.this.estateActionField.getSelectedIndex() > 0) {
                    object = (String)AgencyEstateTablePanel.this.estateActionField.getSelectedItem();
                    arrayList.add("local-name($x/*[3]/*[1]/*[1])='" + OpenEstateUtils.makeCamelCase((String)object) + "' ");
                }
                if (AgencyEstateTablePanel.this.estateStatusField.getSelectedIndex() > 0) {
                    object = (String)AgencyEstateTablePanel.this.estateStatusField.getSelectedItem();
                    arrayList.add("$x/openestate:CustomValues/openestate:CustomValue[@Key='status']/openestate:String/text()='" + StringEscapeUtils.escapeSql((String)object) + "'");
                }
                object = new StringBuilder();
                if (!arrayList.isEmpty()) {
                    for (int i = 0; i < arrayList.size(); ++i) {
                        if (i > 0) {
                            ((StringBuilder)object).append(" and ");
                        }
                        ((StringBuilder)object).append("(").append((String)arrayList.get(i)).append(")");
                    }
                }
                if ((rowArray = AgencyEstate.loadEstateRows(null, ((StringBuilder)object).toString(), null)) != null && rowArray.length > 0) {
                    for (AgencyEstate.Row row : rowArray) {
                        AgencyEstateTablePanel.this.resultTableModel.addEstate(row);
                    }
                }
                return AgencyEstateTablePanel.this.resultTableModel.getRowCount();
            }

            protected void finished() {
                super.finished();
                AgencyEstateTablePanel.this.isSearching = false;
                AgencyEstateTablePanel.this.resultTable.setEnabled(true);
                AgencyEstateTablePanel.this.setButtonsEnabled(true);
            }

            protected void succeeded(Integer n) {
                super.succeeded((Object)n);
                AgencyEstateTablePanel.this.resultLabel.setTitle(AgencyEstateTablePanel.this.resourceMap.getString("resultLabel.title", new Object[0]) + " / " + AgencyEstateTablePanel.this.resourceMap.getString("message.resultCount", new Object[]{NumberFormat.getIntegerInstance().format(n)}));
                AgencyEstateTablePanel.this.resultTable.packAll();
            }
        };
    }

    @Action
    public void doShowActions() {
        if (this.resultTable.getSelectedRowCount() < 1) {
            return;
        }
        this.showActionMenu(this.showActionsButton, 0, this.showActionsButton.getSize().height);
    }

    public static String getInstanceTabTitle() {
        return ImmoToolUtils.getResourceMap(AgencyEstateTablePanel.class).getString("tabTitle", new Object[0]);
    }

    public String getTabInfo() {
        return this.resourceMap.getString("tabInfo", new Object[0]);
    }

    public String getTabTitle() {
        return AgencyEstateTablePanel.getInstanceTabTitle();
    }

    private static void loadEstateTypeChildren(OpenEstateType openEstateType, JComboBox jComboBox, Map<String, OpenEstateType> map) {
        if (openEstateType == null) {
            return;
        }
        for (String string : openEstateType.getChildren()) {
            if (!map.containsKey(string)) continue;
            jComboBox.addItem(map.get(string));
            AgencyEstateTablePanel.loadEstateTypeChildren(map.get(string), jComboBox, map);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void loadPanel() throws ImmoToolDbException {
        void var5_15;
        void var5_13;
        Object object;
        HashMap<String, OpenEstateType> hashMap = new HashMap<String, OpenEstateType>();
        for (String string : AgencyPluginUtils.listAvailableEstateTypes()) {
            if (hashMap.containsKey(string)) continue;
            try {
                OpenEstateType openEstateType = OpenEstateType.newInstance((String)string);
                hashMap.put(string, openEstateType);
                object = OpenEstateUtils.getEstateTypePath((OpenEstateType)openEstateType);
                for (String string2 : object) {
                    OpenEstateType openEstateType2 = OpenEstateType.newInstance((String)string2);
                    if (hashMap.containsKey(string2)) continue;
                    hashMap.put(string2, openEstateType2);
                }
            }
            catch (Exception exception) {
                LOGGER.warn((Object)("Can't load estate-type: " + string));
                LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
            }
        }
        try {
            this.estateTypeField.removeAllItems();
            this.estateTypeField.addItem(null);
            for (String string : OpenEstateUtils.getEstateTypesOnRoot()) {
                if (!hashMap.containsKey(string.getName())) continue;
                this.estateTypeField.addItem(string);
                AgencyEstateTablePanel.loadEstateTypeChildren((OpenEstateType)string, this.estateTypeField, hashMap);
            }
            this.estateTypeField.setSelectedIndex(0);
        }
        catch (Exception exception) {
            LOGGER.warn((Object)"Can't load type-tree!");
            LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
        }
        this.estateActionField.removeAllItems();
        this.estateActionField.addItem(null);
        this.estateActionField.setSelectedIndex(0);
        TreeMap treeMap = new TreeMap();
        Object object2 = AgencyPluginUtils.listAvailableEstateActions();
        int n = ((String[])object2).length;
        boolean bl = false;
        while (var5_13 < n) {
            String string = object2[var5_13];
            object = OpenEstateUtils.translateAction((String)string);
            if (object == null || ((String)object).trim().length() == 0) {
                object = string;
            }
            treeMap.put(object, string);
            ++var5_13;
        }
        for (String string : treeMap.values()) {
            this.estateActionField.addItem(string);
        }
        treeMap.clear();
        this.estateStatusField.removeAllItems();
        this.estateStatusField.addItem(null);
        object2 = AgencyEstate.getStatusList();
        int n2 = ((Object)object2).length;
        boolean bl2 = false;
        while (var5_15 < n2) {
            Object object3 = object2[var5_15];
            this.estateStatusField.addItem(object3);
            ++var5_15;
        }
        this.estateStatusField.setSelectedItem("VERMITTLUNG");
        this.refreshActionExportMenu();
    }

    private void refreshActionExportMenu() throws ImmoToolDbException {
        Object object;
        Object object2;
        this.estateActionExportMenu.removeAll();
        this.estateActionSaveMenu.removeAll();
        TreeMap<String, AgencyExportInterface> treeMap = new TreeMap<String, AgencyExportInterface>();
        for (AgencyExportInterface agencyExportInterface : AgencyExportInterface.loadExportInterfaces()) {
            object = object2 = agencyExportInterface.getTitle().toLowerCase().trim();
            int n = 0;
            while (treeMap.containsKey(object)) {
                object = (String)object2 + "_" + ++n;
            }
            treeMap.put((String)object, agencyExportInterface);
        }
        for (AgencyExportInterface agencyExportInterface : treeMap.values()) {
            if (!agencyExportInterface.isActive()) continue;
            final long l = agencyExportInterface.getId();
            object2 = new JMenuItem(agencyExportInterface.getTitle());
            ((Component)object2).setName("exportItem");
            ((AbstractButton)object2).addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    AgencyEstateTablePanel.this.doEstateExport(l, false);
                }
            });
            this.estateActionExportMenu.add((JMenuItem)object2);
            object = new JMenuItem(agencyExportInterface.getTitle());
            ((Component)object).setName("saveItem");
            ((AbstractButton)object).addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    AgencyEstateTablePanel.this.doEstateExport(l, true);
                }
            });
            this.estateActionSaveMenu.add((JMenuItem)object);
        }
        this.estateActionExportMenu.setEnabled(this.estateActionExportMenu.getItemCount() > 0);
        this.estateActionSaveMenu.setEnabled(this.estateActionSaveMenu.getItemCount() > 0);
    }

    public void refreshTab() {
        this.estateActionExportMenu.setEnabled(false);
        this.estateActionSaveMenu.setEnabled(false);
        ImmoToolUtils.executeTask((Task)new ImmoToolTask<Boolean>(){

            protected Boolean executeTask() throws Exception {
                AgencyEstateTablePanel.this.refreshActionExportMenu();
                return true;
            }
        });
        ImmoToolUtils.executeTask((Task)this.doSearch());
    }

    private void setButtonsEnabled(boolean bl) {
        this.estateAddButton.setEnabled(bl);
        this.searchButton.setEnabled(bl);
        if (!bl) {
            this.showActionsButton.setEnabled(false);
        } else {
            this.showActionsButton.setEnabled(this.resultTable.getSelectedRow() >= 0);
        }
    }

    private void showActionMenu(Component component, int n, int n2) {
        if (this.resultTable.getSelectedRowCount() < 1) {
            return;
        }
        JPopupMenu jPopupMenu = new JPopupMenu();
        jPopupMenu.setName("estateActionMenu");
        jPopupMenu.add(this.estateActionModifyItem);
        jPopupMenu.add(this.estateActionStatusMenu);
        jPopupMenu.add(this.estateActionCopyItem);
        jPopupMenu.add(this.estateActionRemoveItem);
        jPopupMenu.addSeparator();
        jPopupMenu.add(this.estateActionPdfItem);
        jPopupMenu.add(this.estateActionExportMenu);
        jPopupMenu.add(this.estateActionSaveMenu);
        jPopupMenu.addSeparator();
        jPopupMenu.add(this.estateActionContactItem);
        this.resourceMap.injectComponent((Component)jPopupMenu);
        ArrayList<Long> arrayList = new ArrayList<Long>();
        for (int actionArray : this.resultTable.getSelectedRows()) {
            int n3 = this.resultTable.convertRowIndexToModel(actionArray);
            arrayList.add(this.resultTableModel.getEstateIdAt(n3));
        }
        Long[] longArray = arrayList.toArray(new Long[arrayList.size()]);
        for (AgencyEstateTableAddon agencyEstateTableAddon : this.tableAddons.values()) {
            javax.swing.Action[] actionArray = agencyEstateTableAddon.getActions(longArray);
            if (actionArray == null || actionArray.length == 0) continue;
            for (javax.swing.Action action : actionArray) {
                jPopupMenu.add(new JMenuItem(action));
            }
        }
        jPopupMenu.show(component, n, n2);
    }

    private void initComponents() {
        this.titleLabel = ImmoToolUtils.createHead1Separator((String)"");
        this.searchButton = new JButton();
        this.estateAddButton = new JButton();
        this.showActionsButton = new JButton();
        this.helpButton = new JButton();
        this.closeButton = new JButton();
        this.formPanel = new JPanel();
        this.resultLabel = new JXTitledSeparator();
        this.resultScrollPane = new JScrollPane();
        this.resultTable = new JXTable();
        this.titleLabel.setName("titleLabel");
        this.titleLabel.setTitle("titleLabel");
        this.searchButton.setText("doSearch");
        this.searchButton.setEnabled(false);
        this.searchButton.setName("searchButton");
        this.estateAddButton.setText("doEstateAdd");
        this.estateAddButton.setEnabled(false);
        this.estateAddButton.setName("estateAddButton");
        this.showActionsButton.setText("doShowActions");
        this.showActionsButton.setEnabled(false);
        this.showActionsButton.setName("showActionsButton");
        this.helpButton.setText("doHelp");
        this.helpButton.setEnabled(false);
        this.helpButton.setName("helpButton");
        this.closeButton.setText("doClose");
        this.closeButton.setEnabled(false);
        this.closeButton.setName("closeButton");
        this.formPanel.setName("formPanel");
        GroupLayout groupLayout = new GroupLayout(this.formPanel);
        this.formPanel.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 920, Short.MAX_VALUE));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 45, Short.MAX_VALUE));
        this.resultLabel.setName("resultLabel");
        this.resultLabel.setTitle("resultLabel");
        this.resultScrollPane.setName("resultScrollPane");
        this.resultTable.setColumnControlVisible(true);
        this.resultTable.setName("resultTable");
        this.resultScrollPane.setViewportView((Component)this.resultTable);
        GroupLayout groupLayout2 = new GroupLayout((Container)((Object)this));
        this.setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout2.createSequentialGroup().addContainerGap().addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.resultScrollPane, GroupLayout.Alignment.LEADING, -1, 920, Short.MAX_VALUE).addComponent(this.formPanel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addGroup(groupLayout2.createSequentialGroup().addComponent((Component)this.titleLabel, -1, 340, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.searchButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.estateAddButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.showActionsButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.helpButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.closeButton)).addComponent((Component)this.resultLabel, GroupLayout.Alignment.LEADING, -1, 920, Short.MAX_VALUE)).addContainerGap()));
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.closeButton).addComponent(this.helpButton).addComponent(this.showActionsButton).addComponent(this.estateAddButton).addComponent(this.searchButton)).addComponent((Component)this.titleLabel, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.formPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent((Component)this.resultLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.resultScrollPane, -1, 303, Short.MAX_VALUE).addContainerGap()));
    }

    private static class DateRenderer
    extends JLabel
    implements TableCellRenderer {
        private DateFormat format;

        public DateRenderer() {
            this.setOpaque(true);
            this.format = DateFormat.getDateTimeInstance(3, 2, Locale.getDefault());
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.setBackground(bl ? jTable.getSelectionBackground() : jTable.getBackground());
            this.setForeground(bl ? jTable.getSelectionForeground() : jTable.getForeground());
            if (object instanceof Date) {
                this.setText(this.format.format((Date)object));
            } else {
                this.setText("");
            }
            return this;
        }
    }

    private static class RoomsRenderer
    extends JLabel
    implements TableCellRenderer {
        private NumberFormat formatter;

        public RoomsRenderer() {
            this.setOpaque(true);
            this.setHorizontalAlignment(0);
            this.formatter = NumberFormat.getNumberInstance(Locale.getDefault());
            this.formatter.setMaximumFractionDigits(1);
            this.formatter.setMinimumFractionDigits(0);
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.setBackground(bl ? jTable.getSelectionBackground() : jTable.getBackground());
            this.setForeground(bl ? jTable.getSelectionForeground() : jTable.getForeground());
            if (object instanceof Number) {
                this.setText(this.formatter.format(object));
            } else {
                this.setText("");
            }
            return this;
        }
    }

    private static class PriceRenderer
    extends JLabel
    implements TableCellRenderer {
        private NumberFormat formatter;

        public PriceRenderer() {
            this.setOpaque(true);
            this.setHorizontalAlignment(4);
            this.formatter = NumberFormat.getNumberInstance(Locale.getDefault());
            this.formatter.setMaximumFractionDigits(2);
            this.formatter.setMinimumFractionDigits(0);
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.setBackground(bl ? jTable.getSelectionBackground() : jTable.getBackground());
            this.setForeground(bl ? jTable.getSelectionForeground() : jTable.getForeground());
            if (object instanceof Number) {
                int n3 = jTable.convertRowIndexToModel(n);
                Currency currency = (Currency)jTable.getModel().getValueAt(n3, 15);
                if (currency != null) {
                    this.setText(this.formatter.format(object) + " " + currency.getSymbol(Locale.getDefault()));
                } else {
                    this.setText(this.formatter.format(object) + " ???");
                }
            } else {
                this.setText("");
            }
            return this;
        }
    }

    private static class AreaRenderer
    extends JLabel
    implements TableCellRenderer {
        private NumberFormat formatter;

        public AreaRenderer() {
            this.setOpaque(true);
            this.setHorizontalAlignment(4);
            this.formatter = NumberFormat.getNumberInstance(Locale.getDefault());
            this.formatter.setMaximumFractionDigits(2);
            this.formatter.setMinimumFractionDigits(0);
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.setBackground(bl ? jTable.getSelectionBackground() : jTable.getBackground());
            this.setForeground(bl ? jTable.getSelectionForeground() : jTable.getForeground());
            if (object instanceof Number) {
                this.setText(this.formatter.format(object) + " m\u00b2");
            } else {
                this.setText("");
            }
            return this;
        }
    }

    private final class EstateTypeRenderer
    extends JLabel
    implements ListCellRenderer {
        private Map<String, Integer> typeLevels;

        public EstateTypeRenderer() {
            this.setOpaque(true);
            this.typeLevels = new HashMap<String, Integer>();
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            this.setBackground(bl ? jList.getSelectionBackground() : jList.getBackground());
            this.setForeground(bl ? jList.getSelectionForeground() : jList.getForeground());
            if (object instanceof OpenEstateType) {
                OpenEstateType openEstateType = (OpenEstateType)object;
                int n2 = 0;
                if (this.typeLevels.containsKey(openEstateType.getName())) {
                    n2 = this.typeLevels.get(openEstateType.getName());
                } else {
                    try {
                        n2 = OpenEstateUtils.getEstateTypePath((OpenEstateType)openEstateType).length - 1;
                        this.typeLevels.put(openEstateType.getName(), n2);
                    }
                    catch (Exception exception) {
                        n2 = 0;
                        LOGGER.warn((Object)"Can't load recursion-level for estate-type!");
                        LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
                    }
                }
                String string = OpenEstateUtils.translateEstate((String)openEstateType.getName());
                if (n2 == 0) {
                    string = "<b>" + string + "</b>";
                }
                int n3 = n2 > 1 ? (n2 - 1) * 10 : 0;
                this.setText("<html><div style=\"padding-left:" + n3 + "px;\">" + "&nbsp;" + string + "</div></html>");
            } else {
                this.setText(" [ " + AgencyEstateTablePanel.this.resourceMap.getString("label.estateTypeField.all", new Object[0]) + " ]");
            }
            return this;
        }
    }

    private final class EstateStatusRenderer
    extends JLabel
    implements ListCellRenderer {
        public EstateStatusRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            this.setBackground(bl ? jList.getSelectionBackground() : jList.getBackground());
            this.setForeground(bl ? jList.getSelectionForeground() : jList.getForeground());
            if (object instanceof String) {
                this.setText(" " + AgencyEstate.writeStatus((String)object));
            } else {
                this.setText(" [ " + AgencyEstateTablePanel.this.resourceMap.getString("label.estateStatusField.all", new Object[0]) + " ]");
            }
            return this;
        }
    }

    private final class EstateActionRenderer
    extends JLabel
    implements ListCellRenderer {
        public EstateActionRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            this.setBackground(bl ? jList.getSelectionBackground() : jList.getBackground());
            this.setForeground(bl ? jList.getSelectionForeground() : jList.getForeground());
            if (object instanceof String) {
                this.setText(" " + OpenEstateUtils.translateAction((String)((String)object)));
            } else {
                this.setText(" [ " + AgencyEstateTablePanel.this.resourceMap.getString("label.estateActionField.all", new Object[0]) + " ]");
            }
            return this;
        }
    }
}

