/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency;

import com.jgoodies.forms.factories.Borders;
import com.openindex.openestate.impl.EstateImpl;
import com.openindex.openestate.impl.OpenEstateAttrib;
import com.openindex.openestate.impl.OpenEstateType;
import com.openindex.openestate.impl.OpenEstateUtils;
import com.openindex.openestate.impl.ValueImpl;
import com.openindex.openestate.impl.attribs.ComplexEnumAttrib;
import com.openindex.openestate.impl.attribs.SimpleBooleanAttrib;
import com.openindex.openestate.impl.attribs.SimpleEnumAttrib;
import com.openindex.openestate.impl.attribs.SimpleNumericAttrib;
import com.openindex.openestate.impl.attribs.SimpleStringAttrib;
import com.openindex.openestate.impl.attribs.SimpleTimeAttrib;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.utils.JSelectButton;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.swingx.JXDatePicker;
import org.jdesktop.swingx.JXTreeTable;
import org.jdesktop.swingx.treetable.AbstractMutableTreeTableNode;
import org.jdesktop.swingx.treetable.AbstractTreeTableModel;
import org.jdesktop.swingx.treetable.MutableTreeTableNode;
import org.jdesktop.swingx.treetable.TreeTableModel;

public class AgencyEstateValueTable
extends JXTreeTable {
    private static final Logger LOGGER = Logger.getLogger(AgencyEstateValueTable.class);
    private static final DateFormat DATE_FORMAT = DateFormat.getDateInstance(2);
    private static final DateFormat DATETIME_FORMAT = DateFormat.getDateTimeInstance(2, 2);
    private static final DateFormat TIME_FORMAT = DateFormat.getTimeInstance(2);
    private TableModel model = null;
    private String loadedEstateAction = null;
    private String loadedEstateType = null;
    private String loadedEstateCountry = null;
    private boolean isModified = false;
    private ResourceMap resourceMap = ImmoToolUtils.getResourceMap(AgencyEstateValueTable.class);

    public AgencyEstateValueTable() {
        this.model = new TableModel();
        this.setTreeTableModel((TreeTableModel)this.model);
        this.setRootVisible(false);
        this.setDefaultRenderer(ValueImpl.class, new TableNodeValueRenderer());
        this.setDefaultRenderer(ValueInfo.class, new ValueInfoRenderer());
        this.setDefaultEditor(ValueImpl.class, new TableNodeValueEditor());
        this.getSelectionModel().setSelectionMode(0);
        this.setToggleClickCount(2);
        this.setTerminateEditOnFocusLost(true);
        this.setShowGrid(true);
        this.setRowMargin(1);
        this.setColumnMargin(1);
        this.setFocusCycleRoot(false);
        this.getActionMap().put("moveToNextRow", this.moveToNextRow());
        this.getActionMap().put("moveToLastRow", this.moveToLastRow());
        this.getInputMap(1).put(KeyStroke.getKeyStroke(9, 0), "moveToNextRow");
        this.getInputMap(1).put(KeyStroke.getKeyStroke(10, 0), "moveToNextRow");
        this.getInputMap(1).put(KeyStroke.getKeyStroke(40, 0), "moveToNextRow");
        this.getInputMap(1).put(KeyStroke.getKeyStroke(39, 0), "moveToNextRow");
        this.getInputMap(1).put(KeyStroke.getKeyStroke(9, 1), "moveToLastRow");
        this.getInputMap(1).put(KeyStroke.getKeyStroke(10, 1), "moveToLastRow");
        this.getInputMap(1).put(KeyStroke.getKeyStroke(38, 0), "moveToLastRow");
        this.getInputMap(1).put(KeyStroke.getKeyStroke(37, 0), "moveToLastRow");
    }

    public TableModel getEstateValueTableModel() {
        return this.model;
    }

    public void loadEstate(EstateImpl estateImpl, String string) {
        this.setEnabled(false);
        if (estateImpl == null) {
            throw new NullPointerException("invalid estate!");
        }
        if (estateImpl.getType() == null) {
            return;
        }
        if (estateImpl.getAction() == null) {
            return;
        }
        if (!estateImpl.getType().getName().equals(this.loadedEstateType) || !estateImpl.getAction().equals(this.loadedEstateAction)) {
            this.loadEstateType(estateImpl.getType(), estateImpl.getAction(), string, false);
        }
        TableNode tableNode = this.model.getRootNode();
        for (int i = 0; i < tableNode.getChildCount(); ++i) {
            TableNode tableNode2 = (TableNode)tableNode.getChildAt(i);
            for (int j = 0; j < tableNode2.getChildCount(); ++j) {
                TableNode tableNode3 = (TableNode)tableNode2.getChildAt(j);
                ValueImpl valueImpl = (ValueImpl)tableNode3.getValueAt(1);
                String string2 = valueImpl.getGroupName() + "." + valueImpl.getAttribName();
                if (estateImpl.hasAttribute(string2)) {
                    valueImpl.setValue(estateImpl.getAttribute(string2).getValueObject());
                    continue;
                }
                valueImpl.setValue(null);
            }
        }
        if (this.getRowCount() > 0) {
            this.setRowSelectionInterval(0, 1);
        }
        this.setEnabled(true);
        this.isModified = false;
    }

    public void loadEstateType(OpenEstateType openEstateType, String string, String string2, boolean bl) {
        Object object;
        String string3 = this.resourceMap.getString("label.required", new Object[0]);
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        if (this.model != null) {
            object = this.model.getRootNode();
            if (bl) {
                for (int i = 0; i < object.getChildCount(); ++i) {
                    OpenEstateAttrib[] openEstateAttribArray = (OpenEstateAttrib[])object.getChildAt(i);
                    for (int j = 0; j < openEstateAttribArray.getChildCount(); ++j) {
                        TableNode tableNode = (TableNode)openEstateAttribArray.getChildAt(j);
                        ValueImpl valueImpl = (ValueImpl)tableNode.getValueAt(1);
                        String string4 = valueImpl.getGroupName() + "." + valueImpl.getAttribName();
                        if (valueImpl.getValueObject() == null) continue;
                        hashMap.put(string4, valueImpl.getValueObject());
                    }
                }
            }
        }
        this.loadedEstateAction = null;
        this.loadedEstateType = null;
        this.loadedEstateCountry = null;
        this.model = new TableModel();
        object = new HashMap();
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string3);
        for (OpenEstateAttrib openEstateAttrib : openEstateType.getAttribs(string)) {
            String string5;
            if ("FREITEXTE".equalsIgnoreCase(openEstateAttrib.getGroup()) || "ENERGIEPASS".equalsIgnoreCase(openEstateAttrib.getGroup()) || openEstateAttrib.isManuallyTranslated() || !StringUtils.isEmpty((String)string2) && !openEstateAttrib.isCountrySupported(string2)) continue;
            boolean bl2 = openEstateType.isAttribRequired(openEstateAttrib, string);
            String string6 = string5 = bl2 ? string3 : openEstateAttrib.getGroup();
            if (!object.containsKey(string5)) {
                object.put(string5, new TableNode(string5));
            }
            if (!arrayList.contains(string5)) {
                arrayList.add(string5);
            }
            TableNode tableNode = (TableNode)((Object)object.get(string5));
            String string7 = openEstateAttrib.getKey();
            Object object2 = null;
            if (hashMap.containsKey(string7)) {
                object2 = hashMap.get(string7);
            } else if (bl2) {
                object2 = openEstateAttrib.getDefaultValue();
            }
            tableNode.add((MutableTreeTableNode)new TableNode(openEstateAttrib.createValue(object2), bl2));
        }
        for (String string8 : arrayList) {
            this.model.getRootNode().add((MutableTreeTableNode)object.get(string8));
        }
        this.setTreeTableModel((TreeTableModel)this.model);
        this.loadedEstateAction = string;
        this.loadedEstateType = openEstateType.getName();
        this.loadedEstateCountry = string2;
        this.packColumn(0, 5);
        this.packColumn(2, 5);
    }

    public boolean hasModifications() {
        return this.isModified;
    }

    public boolean hasRequiredInputs() {
        String string = this.resourceMap.getString("label.required", new Object[0]);
        TableNode tableNode = this.model.getRootNode();
        for (int i = 0; i < tableNode.getChildCount(); ++i) {
            TableNode tableNode2 = (TableNode)tableNode.getChildAt(i);
            if (!tableNode2.getValueAt(0).toString().contains(string)) continue;
            for (int j = 0; j < tableNode2.getChildCount(); ++j) {
                TableNode tableNode3 = (TableNode)tableNode2.getChildAt(j);
                ValueImpl valueImpl = (ValueImpl)tableNode3.getValueAt(1);
                if (valueImpl.getValueObject() != null) continue;
                return false;
            }
        }
        return true;
    }

    private AbstractAction moveToLastRow() {
        return new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = AgencyEstateValueTable.this.getSelectedRow() - 1;
                if (n < 0) {
                    return;
                }
                AgencyEstateValueTable.this.editingStopped(new ChangeEvent(this));
                AgencyEstateValueTable.this.setRowSelectionInterval(n, n);
                AgencyEstateValueTable.this.editCellAt(n, 1);
                AgencyEstateValueTable.this.scrollRowToVisible(n);
                AgencyEstateValueTable.this.repaint();
            }
        };
    }

    private AbstractAction moveToNextRow() {
        return new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = AgencyEstateValueTable.this.getSelectedRow() + 1;
                if (n >= AgencyEstateValueTable.this.getRowCount()) {
                    return;
                }
                AgencyEstateValueTable.this.editingStopped(new ChangeEvent(this));
                AgencyEstateValueTable.this.setRowSelectionInterval(n, n);
                AgencyEstateValueTable.this.editCellAt(n, 1);
                AgencyEstateValueTable.this.scrollRowToVisible(n);
                AgencyEstateValueTable.this.repaint();
            }
        };
    }

    public void saveEstate(EstateImpl estateImpl) {
        if (estateImpl == null) {
            throw new NullPointerException("invalid estate!");
        }
        TableNode tableNode = this.model.getRootNode();
        for (int i = 0; i < tableNode.getChildCount(); ++i) {
            TableNode tableNode2 = (TableNode)tableNode.getChildAt(i);
            for (int j = 0; j < tableNode2.getChildCount(); ++j) {
                TableNode tableNode3 = (TableNode)tableNode2.getChildAt(j);
                ValueImpl valueImpl = (ValueImpl)tableNode3.getValueAt(1);
                String string = valueImpl.getGroupName() + "." + valueImpl.getAttribName();
                if (valueImpl.getValueObject() != null) {
                    estateImpl.putAttribute(string, valueImpl);
                    continue;
                }
                if (!estateImpl.hasAttribute(string)) continue;
                estateImpl.putAttribute(string, null);
            }
        }
    }

    private final class ValueInfoRenderer
    extends JLabel
    implements TableCellRenderer {
        private String lastCountryCode = null;
        private ImageIcon lastCountryIcon = null;

        public ValueInfoRenderer() {
            this.setHorizontalTextPosition(10);
            this.setOpaque(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (object instanceof ValueInfo) {
                ValueInfo valueInfo = (ValueInfo)object;
                this.setText(valueInfo.infoText);
                this.setIcon(null);
                if (valueInfo.infoCountrySpecific) {
                    if (AgencyEstateValueTable.this.loadedEstateCountry == null) {
                        LOGGER.warn((Object)"can't load flag-icon, no country was selected!");
                    } else if (this.lastCountryCode != null && this.lastCountryCode.equalsIgnoreCase(AgencyEstateValueTable.this.loadedEstateCountry)) {
                        this.setIcon(this.lastCountryIcon);
                    } else {
                        this.lastCountryCode = AgencyEstateValueTable.this.loadedEstateCountry;
                        this.lastCountryIcon = OpenEstateUtils.getFlagIcon((String)AgencyEstateValueTable.this.loadedEstateCountry);
                        if (this.lastCountryIcon == null) {
                            LOGGER.warn((Object)("can't load flag-icon, icon is null: " + AgencyEstateValueTable.this.loadedEstateCountry));
                        } else {
                            this.setIcon(this.lastCountryIcon);
                        }
                    }
                }
            } else {
                this.setText("");
                this.setIcon(null);
            }
            this.setBackground(bl ? jTable.getSelectionBackground() : jTable.getBackground());
            this.setForeground(bl ? jTable.getSelectionForeground() : jTable.getForeground());
            return this;
        }
    }

    private static final class ValueInfo {
        private String infoText;
        private boolean infoCountrySpecific;

        public ValueInfo(String string, boolean bl) {
            this.infoText = string;
            this.infoCountrySpecific = bl;
        }
    }

    private final class TableNodeValueRenderer
    extends JLabel
    implements TableCellRenderer {
        private TableNodeValueRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            ValueImpl valueImpl = (ValueImpl)object;
            if (valueImpl == null || valueImpl.getAttrib() == null || valueImpl.getValueObject() == null) {
                this.setText("");
                this.setIcon(null);
            } else {
                Object object2;
                this.setText("");
                this.setIcon(null);
                if (valueImpl.getAttrib() instanceof ComplexEnumAttrib) {
                    object2 = new StringBuilder();
                    String[] stringArray = (String[])valueImpl.getValueObject();
                    if (stringArray != null) {
                        for (String string : stringArray) {
                            if (string.trim().length() <= 0) continue;
                            if (((StringBuilder)object2).length() > 0) {
                                ((StringBuilder)object2).append(", ");
                            }
                            ((StringBuilder)object2).append(OpenEstateUtils.translateAttributeByCountry((String)valueImpl.getGroupName(), (String)valueImpl.getAttribName(), (String)string, (Locale)Locale.getDefault(), (String)AgencyEstateValueTable.this.loadedEstateCountry));
                        }
                    }
                    this.setText(((StringBuilder)object2).toString());
                } else if (valueImpl.getAttrib() instanceof SimpleBooleanAttrib) {
                    object2 = (Boolean)valueImpl.getValueObject();
                    if (Boolean.TRUE.equals(object2)) {
                        this.setText(AgencyEstateValueTable.this.resourceMap.getString("label.yes", new Object[0]));
                    } else if (Boolean.FALSE.equals(object2)) {
                        this.setText(AgencyEstateValueTable.this.resourceMap.getString("label.no", new Object[0]));
                    } else {
                        this.setText("");
                    }
                } else if (valueImpl.getAttrib() instanceof SimpleEnumAttrib) {
                    object2 = (String)valueImpl.getValueObject();
                    this.setText(object2 != null ? OpenEstateUtils.translateAttributeByCountry((String)valueImpl.getGroupName(), (String)valueImpl.getAttribName(), (String)object2, (Locale)Locale.getDefault(), (String)AgencyEstateValueTable.this.loadedEstateCountry) : "");
                } else if (valueImpl.getAttrib() instanceof SimpleNumericAttrib) {
                    object2 = (SimpleNumericAttrib)valueImpl.getAttrib();
                    NumberFormat numberFormat = object2.getNumberFormat();
                    this.setText(numberFormat.format(valueImpl.getValueObject()));
                } else if (valueImpl.getAttrib() instanceof SimpleStringAttrib) {
                    this.setText((String)valueImpl.getValueObject());
                } else if (valueImpl.getAttrib() instanceof SimpleTimeAttrib) {
                    object2 = (SimpleTimeAttrib)valueImpl.getAttrib();
                    if (object2.isDate()) {
                        this.setText(DATE_FORMAT.format((Date)valueImpl.getValueObject()));
                    } else if (object2.isTime()) {
                        this.setText(TIME_FORMAT.format((Date)valueImpl.getValueObject()));
                    } else {
                        this.setText(DATETIME_FORMAT.format((Date)valueImpl.getValueObject()));
                    }
                }
                if (AgencyEstateValueTable.this.loadedEstateCountry != null && valueImpl.getAttrib().isCountrySpecific() && valueImpl.getAttrib().isCountrySupported(AgencyEstateValueTable.this.loadedEstateCountry)) {
                    object2 = new Locale(AgencyEstateValueTable.this.loadedEstateCountry.toLowerCase(), AgencyEstateValueTable.this.loadedEstateCountry.toUpperCase());
                    this.setIcon(OpenEstateUtils.getFlagIcon((Locale)object2));
                }
            }
            this.setBackground(bl ? jTable.getSelectionBackground() : jTable.getBackground());
            this.setForeground(bl ? jTable.getSelectionForeground() : jTable.getForeground());
            this.setOpaque(true);
            return this;
        }
    }

    private final class TableNodeValueEditor
    implements TableCellEditor {
        private List<CellEditorListener> listeners = new ArrayList<CellEditorListener>();
        private JComponent component = null;
        private ValueImpl value = null;

        private TableNodeValueEditor() {
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            this.component = null;
            this.value = (ValueImpl)object;
            if (this.value == null || this.value.getAttrib() == null) {
                this.component = new JLabel("");
            } else if (this.value.getAttrib() instanceof ComplexEnumAttrib) {
                ComplexEnumAttrib complexEnumAttrib = (ComplexEnumAttrib)this.value.getAttrib();
                String[] stringArray = (String[])this.value.getValueObject();
                ArrayList<String> arrayList = new ArrayList<String>();
                if (stringArray != null) {
                    arrayList.addAll(Arrays.asList(stringArray));
                }
                JSelectButton jSelectButton = new JSelectButton(1);
                TreeMap<String, String> treeMap = new TreeMap<String, String>();
                for (String string : complexEnumAttrib.getOptions()) {
                    String string2 = OpenEstateUtils.translateAttributeByCountry((String)this.value.getGroupName(), (String)this.value.getAttribName(), (String)string, (Locale)Locale.getDefault(), (String)AgencyEstateValueTable.this.loadedEstateCountry);
                    if (string2 == null) {
                        string2 = string;
                    }
                    if (treeMap.containsKey(string2)) continue;
                    treeMap.put(string2, string);
                }
                for (Map.Entry entry : treeMap.entrySet()) {
                    String string = (String)entry.getValue();
                    jSelectButton.addOption(string, (String)entry.getKey());
                    if (!arrayList.contains(string)) continue;
                    jSelectButton.setSelected(string, true);
                }
                jSelectButton.updateText();
                this.component = jSelectButton;
            } else if (this.value.getAttrib() instanceof SimpleBooleanAttrib) {
                JSelectButton jSelectButton = new JSelectButton(0);
                jSelectButton.addOption("", " - ");
                jSelectButton.addOption(Boolean.FALSE.toString(), " " + AgencyEstateValueTable.this.resourceMap.getString("label.no", new Object[0]) + " ");
                jSelectButton.addOption(Boolean.TRUE.toString(), " " + AgencyEstateValueTable.this.resourceMap.getString("label.yes", new Object[0]) + " ");
                if (this.value.getValueObject() != null) {
                    Boolean bl2 = (Boolean)this.value.getValueObject();
                    jSelectButton.setSelected(bl2.toString(), true);
                } else {
                    jSelectButton.setSelected("", true);
                }
                jSelectButton.updateText();
                this.component = jSelectButton;
            } else if (this.value.getAttrib() instanceof SimpleEnumAttrib) {
                SimpleEnumAttrib simpleEnumAttrib = (SimpleEnumAttrib)this.value.getAttrib();
                JSelectButton jSelectButton = new JSelectButton(0);
                jSelectButton.addOption("", " - ");
                TreeMap<String, String> treeMap = new TreeMap<String, String>();
                for (String string : simpleEnumAttrib.getOptions()) {
                    String string3 = OpenEstateUtils.translateAttributeByCountry((String)this.value.getGroupName(), (String)this.value.getAttribName(), (String)string, (Locale)Locale.getDefault(), (String)AgencyEstateValueTable.this.loadedEstateCountry);
                    if (string3 == null) {
                        string3 = string;
                    }
                    if (treeMap.containsKey(string3)) continue;
                    treeMap.put(string3, string);
                }
                for (Map.Entry entry : treeMap.entrySet()) {
                    String string4 = (String)entry.getKey();
                    String string = (String)entry.getValue();
                    jSelectButton.addOption(string, string4);
                    if (!string.equals(this.value.getValueObject())) continue;
                    jSelectButton.setSelected(string, true);
                }
                jSelectButton.updateText();
                this.component = jSelectButton;
            } else if (this.value.getAttrib() instanceof SimpleNumericAttrib) {
                SimpleNumericAttrib simpleNumericAttrib = (SimpleNumericAttrib)this.value.getAttrib();
                JFormattedTextField jFormattedTextField = null;
                NumberFormat numberFormat = simpleNumericAttrib.getNumberFormat();
                jFormattedTextField = new JFormattedTextField(numberFormat);
                jFormattedTextField.setFocusLostBehavior(0);
                if (this.value.getValueObject() != null) {
                    jFormattedTextField.setValue(this.value.getValueObject());
                    jFormattedTextField.selectAll();
                }
                this.component = jFormattedTextField;
            } else if (this.value.getAttrib() instanceof SimpleStringAttrib) {
                JTextField jTextField = new JTextField();
                if (this.value.getValueObject() != null) {
                    jTextField.setText((String)this.value.getValueObject());
                    jTextField.selectAll();
                }
                this.component = jTextField;
            } else if (this.value.getAttrib() instanceof SimpleTimeAttrib) {
                SimpleTimeAttrib simpleTimeAttrib = (SimpleTimeAttrib)this.value.getAttrib();
                JXDatePicker jXDatePicker = new JXDatePicker();
                if (simpleTimeAttrib.isDate()) {
                    jXDatePicker.setFormats(new DateFormat[]{DATE_FORMAT});
                } else if (simpleTimeAttrib.isTime()) {
                    jXDatePicker.setFormats(new DateFormat[]{TIME_FORMAT});
                } else {
                    jXDatePicker.setFormats(new DateFormat[]{DATETIME_FORMAT});
                }
                if (this.value.getValueObject() != null) {
                    jXDatePicker.setDate((Date)this.value.getValueObject());
                }
                jXDatePicker.getEditor().setFocusLostBehavior(0);
                this.component = jXDatePicker;
            }
            if (this.component != null) {
                this.component.setBackground(Color.WHITE);
                this.component.setOpaque(true);
                if (this.component instanceof JSelectButton) {
                    this.component.setBorder(BorderFactory.createRaisedBevelBorder());
                } else {
                    this.component.setBorder(Borders.EMPTY);
                }
            }
            return this.component;
        }

        @Override
        public Object getCellEditorValue() {
            if (this.component == null || this.value == null) {
                return null;
            }
            if (this.value.getAttrib() instanceof ComplexEnumAttrib) {
                JSelectButton jSelectButton = (JSelectButton)this.component;
                String[] stringArray = jSelectButton.getSelectedKeys();
                this.value.setValue(stringArray.length > 0 ? stringArray : null);
            } else if (this.value.getAttrib() instanceof SimpleBooleanAttrib) {
                JSelectButton jSelectButton = (JSelectButton)this.component;
                if (Boolean.TRUE.toString().equals(jSelectButton.getSelectedKey())) {
                    this.value.setValue((Object)Boolean.TRUE);
                } else if (Boolean.FALSE.toString().equals(jSelectButton.getSelectedKey())) {
                    this.value.setValue((Object)Boolean.FALSE);
                } else {
                    this.value.setValue(null);
                }
            } else if (this.value.getAttrib() instanceof SimpleEnumAttrib) {
                JSelectButton jSelectButton = (JSelectButton)this.component;
                String string = jSelectButton.getSelectedKey();
                this.value.setValue(string != null && string.trim().length() > 0 ? string : null);
            } else if (this.value.getAttrib() instanceof SimpleNumericAttrib) {
                JFormattedTextField jFormattedTextField = (JFormattedTextField)this.component;
                try {
                    jFormattedTextField.commitEdit();
                    if (jFormattedTextField.isEditValid()) {
                        this.value.setValue(jFormattedTextField.getValue());
                    }
                }
                catch (Exception exception) {
                    this.value.setValue(null);
                }
            } else if (this.value.getAttrib() instanceof SimpleStringAttrib) {
                this.value.setValue((Object)((JTextField)this.component).getText().trim());
            } else if (this.value.getAttrib() instanceof SimpleTimeAttrib) {
                JXDatePicker jXDatePicker = (JXDatePicker)this.component;
                try {
                    jXDatePicker.commitEdit();
                    if (jXDatePicker.isEditValid()) {
                        this.value.setValue((Object)jXDatePicker.getDate());
                    }
                }
                catch (Exception exception) {
                    this.value.setValue(null);
                }
            }
            AgencyEstateValueTable.this.isModified = true;
            return this.value;
        }

        @Override
        public boolean isCellEditable(EventObject eventObject) {
            return true;
        }

        @Override
        public boolean shouldSelectCell(EventObject eventObject) {
            return false;
        }

        @Override
        public boolean stopCellEditing() {
            for (CellEditorListener cellEditorListener : this.listeners.toArray(new CellEditorListener[this.listeners.size()])) {
                cellEditorListener.editingStopped(new ChangeEvent(this));
            }
            return true;
        }

        @Override
        public void cancelCellEditing() {
            for (CellEditorListener cellEditorListener : this.listeners.toArray(new CellEditorListener[this.listeners.size()])) {
                cellEditorListener.editingStopped(new ChangeEvent(this));
            }
        }

        @Override
        public void addCellEditorListener(CellEditorListener cellEditorListener) {
            this.listeners.add(cellEditorListener);
        }

        @Override
        public void removeCellEditorListener(CellEditorListener cellEditorListener) {
            this.listeners.remove(cellEditorListener);
        }
    }

    public class TableNode
    extends AbstractMutableTreeTableNode {
        public static final int ROOT = 0;
        public static final int GROUP = 1;
        public static final int VALUE = 2;
        private int nodeType = 0;
        private Object nodeValue = null;
        private boolean nodeValueRequired = false;
        private ResourceMap resourceMap = ImmoToolUtils.getResourceMap(AgencyEstateValueTable.class);

        public TableNode() {
            this.nodeType = 0;
            this.nodeValue = null;
        }

        public TableNode(String string) {
            this.nodeType = 1;
            this.nodeValue = string;
        }

        public TableNode(ValueImpl valueImpl, boolean bl) {
            this.nodeType = 2;
            this.nodeValue = valueImpl;
            this.nodeValueRequired = bl;
        }

        public Object getValueAt(int n) {
            String string = this.resourceMap.getString("label.required", new Object[0]);
            if (this.nodeType == 0) {
                switch (n) {
                    case 0: {
                        return "";
                    }
                    case 1: {
                        return null;
                    }
                    case 2: {
                        return null;
                    }
                }
                return null;
            }
            if (this.nodeType == 1) {
                switch (n) {
                    case 0: {
                        String string2 = null;
                        string2 = string.equals(this.nodeValue) ? string : OpenEstateUtils.translateAttributeByCountry((String)((String)this.nodeValue), (Locale)Locale.getDefault(), (String)AgencyEstateValueTable.this.loadedEstateCountry);
                        return "<html><b>" + (string2 != null ? string2 : this.nodeValue.toString()) + "</b></html>";
                    }
                    case 1: {
                        return null;
                    }
                    case 2: {
                        return null;
                    }
                }
                return null;
            }
            if (this.nodeType == 2) {
                ValueImpl valueImpl = (ValueImpl)this.nodeValue;
                switch (n) {
                    case 0: {
                        String string3 = OpenEstateUtils.translateAttributeByCountry((String)valueImpl.getGroupName(), (String)valueImpl.getAttribName(), (Locale)Locale.getDefault(), (String)AgencyEstateValueTable.this.loadedEstateCountry);
                        if (this.nodeValueRequired) {
                            return "<html><u>" + (string3 != null ? string3 : valueImpl.getAttribName()) + "</u></html>";
                        }
                        return "<html>" + (string3 != null ? string3 : valueImpl.getAttribName()) + "</html>";
                    }
                    case 1: {
                        return valueImpl;
                    }
                    case 2: {
                        String string4 = null;
                        if (valueImpl.getAttrib() == null) {
                            string4 = "[" + this.resourceMap.getString("label.type.invalid", new Object[0]) + "]";
                        } else if (valueImpl.getAttrib() instanceof ComplexEnumAttrib) {
                            string4 = this.resourceMap.getString("label.type.multipleSelection", new Object[0]);
                        } else if (valueImpl.getAttrib() instanceof SimpleBooleanAttrib) {
                            string4 = this.resourceMap.getString("label.type.booleanSelection", new Object[0]);
                        } else if (valueImpl.getAttrib() instanceof SimpleEnumAttrib) {
                            string4 = this.resourceMap.getString("label.type.singleSelection", new Object[0]);
                        } else if (valueImpl.getAttrib() instanceof SimpleNumericAttrib) {
                            SimpleNumericAttrib simpleNumericAttrib = (SimpleNumericAttrib)valueImpl.getAttrib();
                            string4 = simpleNumericAttrib.isAreaUnit() ? this.resourceMap.getString("label.type.area", new Object[0]) : (simpleNumericAttrib.isLengthUnit() ? this.resourceMap.getString("label.type.length", new Object[0]) : (simpleNumericAttrib.isVolumeUnit() ? this.resourceMap.getString("label.type.volume", new Object[0]) : (simpleNumericAttrib.isCurrencyUnit() ? this.resourceMap.getString("label.type.price", new Object[0]) : (simpleNumericAttrib.getPrecision() > 0 ? this.resourceMap.getString("label.type.numeric", new Object[0]) : this.resourceMap.getString("label.type.integer", new Object[0])))));
                        } else if (valueImpl.getAttrib() instanceof SimpleStringAttrib) {
                            string4 = this.resourceMap.getString("label.type.text", new Object[0]);
                        } else if (valueImpl.getAttrib() instanceof SimpleTimeAttrib) {
                            SimpleTimeAttrib simpleTimeAttrib = (SimpleTimeAttrib)valueImpl.getAttrib();
                            string4 = simpleTimeAttrib.isDate() ? this.resourceMap.getString("label.type.date", new Object[0]) : (simpleTimeAttrib.isTime() ? this.resourceMap.getString("label.type.time", new Object[0]) : this.resourceMap.getString("label.type.dateTime", new Object[0]));
                        }
                        if (string4 == null) {
                            string4 = "[" + this.resourceMap.getString("label.type.unknown", new Object[0]) + "]";
                        }
                        return new ValueInfo("<html><i>" + string4 + "</i></html>", valueImpl.getAttrib().isCountrySpecific());
                    }
                }
                return null;
            }
            return null;
        }

        public int getColumnCount() {
            return 3;
        }

        public boolean isEditable(int n) {
            return this.nodeType == 2 && n == 1;
        }
    }

    public class TableModel
    extends AbstractTreeTableModel {
        public static final int COL_NAME = 0;
        public static final int COL_VALUE = 1;
        public static final int COL_TYPE = 2;
        private Map<Integer, Class> CLASSES;
        private Map<Integer, String> TITLES;
        private TableNode rootNode;
        private ResourceMap resourceMap;

        public TableModel() {
            super((Object)new TableNode());
            this.rootNode = null;
            this.resourceMap = ImmoToolUtils.getResourceMap(AgencyEstateValueTable.class);
            this.CLASSES = new HashMap<Integer, Class>();
            this.CLASSES.put(0, String.class);
            this.CLASSES.put(1, ValueImpl.class);
            this.CLASSES.put(2, ValueInfo.class);
            this.TITLES = new HashMap<Integer, String>();
            this.TITLES.put(0, "col.attribute");
            this.TITLES.put(1, "col.value");
            this.TITLES.put(2, "col.type");
            this.rootNode = (TableNode)((Object)this.getRoot());
        }

        public Class getColumnClass(int n) {
            return this.CLASSES.get(n);
        }

        public int getColumnCount() {
            return this.CLASSES.size();
        }

        public String getColumnName(int n) {
            return this.TITLES.size() > n ? this.resourceMap.getString(this.TITLES.get(n), new Object[0]) : null;
        }

        public TableNode getRootNode() {
            return this.rootNode;
        }

        public Object getValueAt(Object object, int n) {
            TableNode tableNode = (TableNode)((Object)object);
            return tableNode.getValueAt(n);
        }

        public Object getChild(Object object, int n) {
            TableNode tableNode = (TableNode)((Object)object);
            return tableNode.getChildAt(n);
        }

        public int getChildCount(Object object) {
            TableNode tableNode = (TableNode)((Object)object);
            return tableNode.getChildCount();
        }

        public int getIndexOfChild(Object object, Object object2) {
            TableNode tableNode = (TableNode)((Object)object);
            for (int i = 0; i < tableNode.getChildCount(); ++i) {
                if (tableNode.getChildAt(i) != object2) continue;
                return i;
            }
            return -1;
        }

        public boolean isCellEditable(Object object, int n) {
            TableNode tableNode = (TableNode)((Object)object);
            return tableNode.isEditable(n);
        }
    }
}

