/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.factories.Borders;
import com.openindex.openestate.impl.OpenEstateUtils;
import com.openindex.openestate.impl.SimpleAdressImpl;
import com.openindex.openestate.tool.ImmoToolDbException;
import com.openindex.openestate.tool.ImmoToolDbUtils;
import com.openindex.openestate.tool.ImmoToolException;
import com.openindex.openestate.tool.ImmoToolTask;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.agency.AgencyContact;
import com.openindex.openestate.tool.agency.AgencyEstate;
import com.openindex.openestate.tool.agency.AgencyEstateViewAddonPanel;
import com.openindex.openestate.tool.agency.AgencyPluginUtils;
import com.openindex.openestate.tool.utils.JAdressPanel;
import com.openindex.openestate.tool.utils.ModificationHandler;
import com.openindex.openestate.tool.utils.ValidationRule;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import org.dom4j.Document;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.application.Task;
import org.xmldb.api.base.Collection;
import org.xmldb.api.modules.XMLResource;

public class AgencyEstateViewContactPanel
extends AgencyEstateViewAddonPanel {
    private ResourceMap resourceMap;
    private ModificationHandler modifications = null;
    private AgencyEstate contactEstate = null;
    private JComboBox listContactsBox = null;
    private JAdressPanel adressPanel = null;
    private JRadioButton noContactButton = null;
    private JRadioButton newContactButton = null;
    private JRadioButton useContactButton = null;
    private ButtonGroup contactButtons = null;

    public AgencyEstateViewContactPanel() {
        this.build();
    }

    private void build() {
        this.modifications = ImmoToolUtils.createModificationHandler();
        this.resourceMap = ImmoToolUtils.getResourceMap(AgencyEstateViewContactPanel.class);
        this.buildPanel();
        this.resourceMap.injectComponents((Component)((Object)this));
        this.listContactsBox.setRenderer(new AgentContactRenderer());
        this.noContactButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!AgencyEstateViewContactPanel.this.noContactButton.isSelected()) {
                    return;
                }
                AgencyEstateViewContactPanel.this.listContactsBox.setSelectedIndex(0);
                AgencyEstateViewContactPanel.this.listContactsBox.setEnabled(false);
                AgencyEstateViewContactPanel.this.adressPanel.setEnabled(false);
                AgencyEstateViewContactPanel.this.adressPanel.setEditable(false);
                AgencyEstateViewContactPanel.this.adressPanel.initInputs();
            }
        });
        this.newContactButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!AgencyEstateViewContactPanel.this.newContactButton.isSelected()) {
                    return;
                }
                AgencyEstateViewContactPanel.this.listContactsBox.setSelectedIndex(0);
                AgencyEstateViewContactPanel.this.listContactsBox.setEnabled(false);
                AgencyEstateViewContactPanel.this.adressPanel.setEnabled(true);
                AgencyEstateViewContactPanel.this.adressPanel.setEditable(true);
                AgencyEstateViewContactPanel.this.adressPanel.initInputs();
            }
        });
        this.useContactButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!AgencyEstateViewContactPanel.this.useContactButton.isSelected()) {
                    return;
                }
                AgencyEstateViewContactPanel.this.listContactsBox.setSelectedIndex(0);
                AgencyEstateViewContactPanel.this.listContactsBox.setEnabled(true);
                AgencyEstateViewContactPanel.this.adressPanel.setEnabled(true);
                AgencyEstateViewContactPanel.this.adressPanel.setEditable(false);
                AgencyEstateViewContactPanel.this.adressPanel.initInputs();
            }
        });
        this.listContactsBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = AgencyEstateViewContactPanel.this.listContactsBox.getSelectedIndex();
                if (n < 0) {
                    return;
                }
                if (n == 0) {
                    AgencyEstateViewContactPanel.this.adressPanel.loadAdress((SimpleAdressImpl)new AgencyContact());
                } else {
                    AgentContactItem agentContactItem = (AgentContactItem)AgencyEstateViewContactPanel.this.listContactsBox.getItemAt(n);
                    AgencyEstateViewContactPanel.this.adressPanel.loadAdress((SimpleAdressImpl)agentContactItem.getContact());
                }
            }
        });
    }

    private void buildPanel() {
        this.listContactsBox = new JComboBox();
        this.listContactsBox.setName("listContactsBox");
        this.listContactsBox.setSelectedIndex(-1);
        this.adressPanel = new JAdressPanel((SimpleAdressImpl)new AgencyContact()){

            protected void init() {
                this.registerValidation(this.personFirstNameField);
                this.registerValidation(this.personLastNameField);
                this.registerValidation(this.personMailField);
                this.registerValidation(this.personPhoneField);
            }
        };
        this.adressPanel.setEnabled(false);
        this.adressPanel.setEditable(false);
        this.noContactButton = new JRadioButton();
        this.noContactButton.setName("noContactButton");
        this.newContactButton = new JRadioButton();
        this.newContactButton.setName("newContactButton");
        this.useContactButton = new JRadioButton();
        this.useContactButton.setName("useContactButton");
        this.contactButtons = new ButtonGroup();
        this.contactButtons.add(this.noContactButton);
        this.contactButtons.add(this.newContactButton);
        this.contactButtons.add(this.useContactButton);
        this.useContactButton.setSelected(true);
        this.getValidationHandler().putRule((JComponent)this.listContactsBox, new ValidationRule(){

            public boolean isValid(Object object) {
                return object != null;
            }
        });
        DefaultFormBuilder defaultFormBuilder = ImmoToolUtils.createFormBuilder((String)"left:pref, 3dlu, pref:grow");
        defaultFormBuilder.border(Borders.DIALOG);
        defaultFormBuilder.append((Component)ImmoToolUtils.createHead2Separator((String)this.resourceMap.getString("formTitle", new Object[0])), 3);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append((Component)this.useContactButton, (Component)this.listContactsBox);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append((Component)this.newContactButton);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append((Component)this.noContactButton);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append((Component)new JLabel(" "));
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append((Component)ImmoToolUtils.createHead2Separator((String)this.resourceMap.getString("contactTitle", new Object[0])), 3);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append((Component)this.adressPanel, 3);
        defaultFormBuilder.nextLine();
        JScrollPane jScrollPane = new JScrollPane(defaultFormBuilder.getPanel());
        jScrollPane.setBorder(Borders.EMPTY);
        jScrollPane.getVerticalScrollBar().setUnitIncrement(20);
        this.setLayout(new BorderLayout());
        this.add(jScrollPane, "Center");
        this.revalidate();
        this.repaint();
    }

    public AgencyContact getAgentContact() {
        int n;
        AgencyContact agencyContact = null;
        if (this.newContactButton.isSelected()) {
            agencyContact = new AgencyContact();
            this.adressPanel.saveAdress((SimpleAdressImpl)agencyContact);
        } else if (this.useContactButton.isSelected() && (n = this.listContactsBox.getSelectedIndex()) > 0) {
            agencyContact = ((AgentContactItem)this.listContactsBox.getSelectedItem()).getContact();
            this.adressPanel.saveAdress((SimpleAdressImpl)agencyContact);
        }
        return agencyContact;
    }

    @Override
    public String getTitle() {
        return this.resourceMap.getString("title", new Object[0]);
    }

    @Override
    public Task doLoadInBackground() {
        this.listContactsBox.removeAllItems();
        return new ImmoToolTask<DefaultComboBoxModel>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected DefaultComboBoxModel executeTask() throws Exception {
                DefaultComboBoxModel<AgentContactItem> defaultComboBoxModel;
                Collection collection = null;
                try {
                    DefaultComboBoxModel<AgentContactItem> defaultComboBoxModel2 = new DefaultComboBoxModel<AgentContactItem>();
                    defaultComboBoxModel2.addElement(null);
                    collection = AgencyPluginUtils.openPluginCollection("/contacts");
                    TreeMap treeMap = new TreeMap();
                    for (String string : collection.listResources()) {
                        XMLResource xMLResource = ImmoToolDbUtils.loadXMLResource((Collection)collection, (String)string);
                        Document document = OpenEstateUtils.loadDocument((Reader)new StringReader((String)xMLResource.getContent()));
                        AgentContactItem agentContactItem = new AgentContactItem(new AgencyContact(document));
                        if (!treeMap.containsKey(agentContactItem.toString())) {
                            treeMap.put(agentContactItem.toString(), new ArrayList());
                        }
                        ((List)treeMap.get(agentContactItem.toString())).add(agentContactItem);
                        defaultComboBoxModel2.addElement(agentContactItem);
                    }
                    defaultComboBoxModel = defaultComboBoxModel2;
                }
                catch (Throwable throwable) {
                    ImmoToolDbUtils.close(collection);
                    throw throwable;
                }
                ImmoToolDbUtils.close((Collection)collection);
                return defaultComboBoxModel;
            }

            protected void failed(Throwable throwable) {
                super.failed(throwable);
            }

            protected void succeeded(DefaultComboBoxModel defaultComboBoxModel) {
                super.succeeded((Object)defaultComboBoxModel);
                AgencyEstateViewContactPanel.this.listContactsBox.setModel(defaultComboBoxModel);
                AgencyEstateViewContactPanel.this.adressPanel.setEnabled(false);
                AgencyEstateViewContactPanel.this.adressPanel.setEditable(false);
                AgencyEstateViewContactPanel.this.listContactsBox.setSelectedIndex(0);
                AgencyEstateViewContactPanel.this.useContactButton.setSelected(true);
                if (AgencyEstateViewContactPanel.this.contactEstate.getContactId() == null || AgencyEstateViewContactPanel.this.contactEstate.getContactId().trim().length() == 0) {
                    AgencyEstateViewContactPanel.this.noContactButton.setSelected(true);
                    AgencyEstateViewContactPanel.this.listContactsBox.setEnabled(false);
                    AgencyEstateViewContactPanel.this.adressPanel.loadAdress((SimpleAdressImpl)new AgencyContact());
                } else {
                    for (int i = 1; i < AgencyEstateViewContactPanel.this.listContactsBox.getItemCount(); ++i) {
                        AgentContactItem agentContactItem = (AgentContactItem)AgencyEstateViewContactPanel.this.listContactsBox.getItemAt(i);
                        if (!agentContactItem.getContactId().equals(AgencyEstateViewContactPanel.this.contactEstate.getContactId())) continue;
                        AgencyEstateViewContactPanel.this.listContactsBox.setSelectedIndex(i);
                        AgencyEstateViewContactPanel.this.adressPanel.loadAdress((SimpleAdressImpl)agentContactItem.getContact());
                        AgencyEstateViewContactPanel.this.adressPanel.setEnabled(true);
                        AgencyEstateViewContactPanel.this.adressPanel.setEditable(false);
                        break;
                    }
                    AgencyEstateViewContactPanel.this.listContactsBox.setEnabled(true);
                }
                AgencyEstateViewContactPanel.this.adressPanel.initInputs();
                AgencyEstateViewContactPanel.this.getValidationHandler().validate();
                AgencyEstateViewContactPanel.this.modifications.clear();
                AgencyEstateViewContactPanel.this.modifications.putValue((JComponent)AgencyEstateViewContactPanel.this.useContactButton);
                AgencyEstateViewContactPanel.this.modifications.putValue((JComponent)AgencyEstateViewContactPanel.this.newContactButton);
                AgencyEstateViewContactPanel.this.modifications.putValue((JComponent)AgencyEstateViewContactPanel.this.noContactButton);
                if (AgencyEstateViewContactPanel.this.useContactButton.isSelected()) {
                    AgencyEstateViewContactPanel.this.modifications.putValue((JComponent)AgencyEstateViewContactPanel.this.listContactsBox);
                }
            }
        };
    }

    public boolean isAgentContactSelected() {
        return this.useContactButton.isSelected() || this.newContactButton.isSelected();
    }

    @Override
    public boolean isLoadedInBackground() {
        return true;
    }

    public boolean isFormEnabled() {
        return true;
    }

    @Override
    public boolean isFormModified() {
        if (this.modifications.isModified()) {
            return true;
        }
        return this.useContactButton.isSelected() && this.adressPanel.isModifiedInput();
    }

    public boolean isFormUsable() {
        return true;
    }

    public boolean isFormValid() {
        return super.isFormValid() && this.adressPanel.isValidInput() && (this.noContactButton.isSelected() || this.isAgentContactSelected());
    }

    @Override
    public void load(AgencyEstate agencyEstate) throws ImmoToolDbException {
        this.contactEstate = agencyEstate;
    }

    @Override
    public void save(AgencyEstate agencyEstate) {
        if (this.noContactButton.isSelected()) {
            agencyEstate.setContactId(null);
        } else if (this.useContactButton.isSelected() && this.listContactsBox.getSelectedIndex() > 0) {
            AgentContactItem agentContactItem = (AgentContactItem)this.listContactsBox.getSelectedItem();
            agencyEstate.setContactId(agentContactItem.getContactId());
        } else if (this.newContactButton.isSelected()) {
            agencyEstate.setContactId(null);
        }
    }

    @Override
    public void saveFinished(AgencyEstate agencyEstate) throws ImmoToolException {
    }

    public void validateForm() {
        super.validateForm();
        this.adressPanel.validateInputs();
    }

    private static final class AgentContactRenderer
    extends JLabel
    implements ListCellRenderer {
        private AgentContactRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            AgencyContact.Row row = object != null ? ((AgentContactItem)object).getContact().createRow() : null;
            AgencyPluginUtils.prepareListCellRenderer((JLabel)this, jList, row, n, bl, bl2);
            return this;
        }
    }

    private static final class AgentContactItem {
        private AgencyContact agentContact;

        private AgentContactItem(AgencyContact agencyContact) {
            this.agentContact = agencyContact;
        }

        public AgencyContact getContact() {
            return this.agentContact;
        }

        public String getContactId() {
            return this.agentContact.getId();
        }
    }
}

