/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.layout.RowSpec;
import com.openindex.openestate.tool.ImmoToolDbUtils;
import com.openindex.openestate.tool.ImmoToolException;
import com.openindex.openestate.tool.ImmoToolTask;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.agency.AgencyEstate;
import com.openindex.openestate.tool.agency.AgencyEstateViewAddonPanel;
import com.openindex.openestate.tool.agency.AgencyExportInterface;
import com.openindex.openestate.tool.agency.AgencyPluginUtils;
import com.openindex.openestate.tool.utils.ModificationHandler;
import com.openindex.openestate.tool.utils.QuickTableExport;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.LayoutStyle;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import org.apache.log4j.Logger;
import org.jdesktop.application.Action;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.application.Task;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.JXTitledSeparator;
import org.w3c.dom.Node;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.ResourceSet;
import org.xmldb.api.base.XMLDBException;
import org.xmldb.api.modules.XMLResource;

public class AgencyEstateViewExportsPanel
extends AgencyEstateViewAddonPanel {
    private static final Logger LOGGER = Logger.getLogger(AgencyEstateViewExportsPanel.class);
    private static final int EXPORT_ALWAYS = 0;
    private static final int EXPORT_EXPLICIT = 1;
    private static final int EXPORT_DISABLED = 2;
    private ActionMap actionMap = null;
    private ResourceMap resourceMap = null;
    private ModificationHandler modifications = null;
    private DefaultTableModel exportTableModel;
    private AgencyEstate viewEstate = null;
    private long viewEstateId = 0L;
    private JComboBox estateExportField = null;
    private JPanel estateExportInterfacePanel = null;
    private Map<Long, JCheckBox> estateExportBoxes = null;
    private JPanel exportHistoryPanel;
    private JButton exportHistoryRefreshButton;
    private JXTable exportHistoryTable;
    private JScrollPane exportHistoryTableScroller;
    private JXTitledSeparator exportHistoryTitleLabel;
    private JPanel exportInterfaceFormPanel;
    private JPanel exportInterfacePanel;
    private JXTitledSeparator exportInterfaceTitleLabel;
    private JTabbedPane tabPanel;
    private JXTitledSeparator titleLabel;

    public AgencyEstateViewExportsPanel() {
        this.build();
    }

    private void build() {
        this.modifications = ImmoToolUtils.createModificationHandler();
        this.actionMap = ImmoToolUtils.getActionMap(AgencyEstateViewExportsPanel.class, (Object)((Object)this));
        this.resourceMap = ImmoToolUtils.getResourceMap(AgencyEstateViewExportsPanel.class);
        this.initComponents();
        this.buildExportInterfaceForm();
        this.resourceMap.injectComponents((Component)((Object)this));
        this.tabPanel.setTitleAt(0, this.resourceMap.getString("tab.interfaces", new Object[0]));
        this.tabPanel.setTitleAt(1, this.resourceMap.getString("tab.exportHistory", new Object[0]));
        this.exportTableModel = (DefaultTableModel)this.exportHistoryTable.getModel();
        this.exportHistoryTable.setSortable(true);
        this.exportHistoryTable.getColumn(0).setHeaderValue(this.resourceMap.getString("exportHistoryCol.timestamp", new Object[0]));
        this.exportHistoryTable.getColumn(1).setHeaderValue(this.resourceMap.getString("exportHistoryCol.interface", new Object[0]));
        this.exportHistoryTable.getTableHeader().setReorderingAllowed(false);
        this.exportHistoryTable.setColumnControlVisible(true);
        this.exportHistoryTable.setColumnControl((JComponent)QuickTableExport.createColumnControl((JXTable)this.exportHistoryTable));
        ImmoToolUtils.configureTable((JXTable)this.exportHistoryTable);
        this.exportHistoryRefreshButton.setAction(this.actionMap.get(this.exportHistoryRefreshButton.getText()));
        this.estateExportField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = AgencyEstateViewExportsPanel.this.estateExportField.getSelectedIndex();
                for (JCheckBox jCheckBox : AgencyEstateViewExportsPanel.this.estateExportBoxes.values()) {
                    jCheckBox.setEnabled(n == 1);
                    jCheckBox.setForeground(jCheckBox.isEnabled() ? Color.BLACK : Color.GRAY);
                }
            }
        });
    }

    private void buildExportInterfaceForm() {
        this.estateExportField = new JComboBox<String>(new String[]{this.resourceMap.getString("label.exportMode.always", new Object[0]), this.resourceMap.getString("label.exportMode.withSelectedInterfaces", new Object[0]), this.resourceMap.getString("label.exportMode.never", new Object[0])});
        this.estateExportField.setName("estateExportField");
        this.estateExportField.setSelectedIndex(0);
        this.estateExportInterfacePanel = new JPanel(new GridLayout());
        this.estateExportBoxes = new HashMap<Long, JCheckBox>();
        DefaultFormBuilder defaultFormBuilder = ImmoToolUtils.createFormBuilder((String)"right:[40dlu,pref], 3dlu, 30dlu:grow");
        defaultFormBuilder.defaultRowSpec(RowSpec.decode((String)"top:pref"));
        defaultFormBuilder.append(this.resourceMap.getString("label.exportMode", new Object[0]), (Component)this.estateExportField);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append("", (Component)this.estateExportInterfacePanel);
        defaultFormBuilder.nextLine();
        JScrollPane jScrollPane = new JScrollPane(defaultFormBuilder.getPanel());
        jScrollPane.setBorder(Borders.EMPTY);
        jScrollPane.getVerticalScrollBar().setUnitIncrement(20);
        this.exportInterfaceFormPanel.setLayout(new BorderLayout());
        this.exportInterfaceFormPanel.add((Component)jScrollPane, "Center");
        this.exportInterfaceFormPanel.revalidate();
        this.exportInterfaceFormPanel.repaint();
    }

    @Override
    public Task doLoadInBackground() {
        final int n = this.estateExportField.getSelectedIndex();
        this.estateExportBoxes.clear();
        this.estateExportInterfacePanel.removeAll();
        this.exportHistoryRefreshButton.setEnabled(false);
        while (this.exportHistoryTable.getRowCount() > 0) {
            this.exportTableModel.removeRow(0);
        }
        final MouseAdapter mouseAdapter = new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                if (((JCheckBox)mouseEvent.getSource()).isEnabled()) {
                    ((JCheckBox)mouseEvent.getSource()).setOpaque(true);
                    ((JCheckBox)mouseEvent.getSource()).setBackground(Color.WHITE);
                }
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                ((JCheckBox)mouseEvent.getSource()).setOpaque(false);
                ((JCheckBox)mouseEvent.getSource()).setBackground(null);
            }
        };
        return new ImmoToolTask<AgencyExportInterface[]>(){

            protected AgencyExportInterface[] executeTask() throws Exception {
                return AgencyExportInterface.loadExportInterfaces();
            }

            protected void finished() {
                super.finished();
                AgencyEstateViewExportsPanel.this.exportHistoryRefreshButton.setEnabled(true);
            }

            protected void succeeded(AgencyExportInterface[] agencyExportInterfaceArray) {
                super.succeeded((Object)agencyExportInterfaceArray);
                DefaultFormBuilder defaultFormBuilder = ImmoToolUtils.createFormBuilder((String)"30dlu:grow", (JPanel)AgencyEstateViewExportsPanel.this.estateExportInterfacePanel);
                defaultFormBuilder.defaultRowSpec(RowSpec.decode((String)"top:pref"));
                TreeMap<String, AgencyExportInterface> treeMap = new TreeMap<String, AgencyExportInterface>();
                for (AgencyExportInterface object : agencyExportInterfaceArray) {
                    String string = object.getTitle().toLowerCase();
                    int n2 = 1;
                    while (treeMap.containsKey(string)) {
                        string = string + "_" + n2;
                        ++n2;
                    }
                    treeMap.put(string, object);
                }
                for (AgencyExportInterface agencyExportInterface : treeMap.values()) {
                    String string = agencyExportInterface.getTitle();
                    if (string.length() > 75) {
                        string = string.substring(0, 75);
                    }
                    JCheckBox jCheckBox = new JCheckBox("<html><b>" + string + "</b>" + "<br>" + AgencyEstateViewExportsPanel.this.resourceMap.getString("label.interface", new Object[0]) + " #" + agencyExportInterface.getId() + "</html>");
                    jCheckBox.setOpaque(false);
                    jCheckBox.addMouseListener(mouseAdapter);
                    jCheckBox.setVerticalTextPosition(1);
                    jCheckBox.setEnabled(n == 1);
                    jCheckBox.setForeground(jCheckBox.isEnabled() ? Color.BLACK : Color.GRAY);
                    jCheckBox.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
                    jCheckBox.setSelected(!AgencyEstateViewExportsPanel.this.viewEstate.isExportAlways() && AgencyEstateViewExportsPanel.this.viewEstate.hasExportInteface(agencyExportInterface.getId()));
                    defaultFormBuilder.append((Component)jCheckBox);
                    defaultFormBuilder.nextLine();
                    AgencyEstateViewExportsPanel.this.estateExportBoxes.put(agencyExportInterface.getId(), jCheckBox);
                }
                int n3 = AgencyEstateViewExportsPanel.this.estateExportField.getSelectedIndex();
                if (n3 == 1) {
                    for (JCheckBox jCheckBox : AgencyEstateViewExportsPanel.this.estateExportBoxes.values()) {
                        AgencyEstateViewExportsPanel.this.modifications.putValue((JComponent)jCheckBox);
                    }
                }
                AgencyEstateViewExportsPanel.this.estateExportInterfacePanel.revalidate();
                AgencyEstateViewExportsPanel.this.estateExportInterfacePanel.repaint();
            }
        };
    }

    @Action
    public Task doRefresh() {
        if (this.viewEstateId <= 0L) {
            return null;
        }
        this.exportHistoryRefreshButton.setEnabled(false);
        while (this.exportHistoryTable.getRowCount() > 0) {
            this.exportTableModel.removeRow(0);
        }
        return new ImmoToolTask<Boolean>(){

            protected Boolean executeTask() throws Exception {
                AgencyEstateViewExportsPanel.this.reloadHistory();
                return true;
            }

            protected void failed(Throwable throwable) {
                super.failed(throwable);
                ImmoToolUtils.showMessageErrorDialog((String)AgencyEstateViewExportsPanel.this.resourceMap.getString("error.cantLoadExportHistory", new Object[0]), (Throwable)throwable);
            }

            protected void finished() {
                super.finished();
                AgencyEstateViewExportsPanel.this.exportHistoryRefreshButton.setEnabled(true);
            }
        };
    }

    @Override
    public String getTitle() {
        return this.resourceMap.getString("title", new Object[0]);
    }

    @Override
    public boolean isLoadedInBackground() {
        return true;
    }

    public boolean isFormEnabled() {
        return true;
    }

    @Override
    public boolean isFormModified() {
        return this.modifications.isModified();
    }

    public boolean isFormUsable() {
        return true;
    }

    @Override
    public void load(AgencyEstate agencyEstate) throws ImmoToolException {
        this.viewEstate = agencyEstate;
        this.viewEstateId = this.viewEstate == null || this.viewEstate.getId() == null ? 0L : this.viewEstate.getIdNr();
        this.exportHistoryRefreshButton.setEnabled(this.viewEstateId > 0L);
        this.tabPanel.setEnabledAt(1, this.viewEstateId > 0L);
        if (this.viewEstateId == 0L) {
            this.tabPanel.setSelectedIndex(0);
        }
        if (this.viewEstate != null && !this.viewEstate.isExportEnabled()) {
            this.estateExportField.setSelectedIndex(2);
        } else if (this.viewEstate != null && this.viewEstate.isExportAlways()) {
            this.estateExportField.setSelectedIndex(0);
        } else {
            this.estateExportField.setSelectedIndex(1);
        }
        this.modifications.clear();
        this.modifications.putValue((JComponent)this.estateExportField);
    }

    @Override
    public void save(AgencyEstate agencyEstate) {
        int n = this.estateExportField.getSelectedIndex();
        agencyEstate.setExportAlways(n == 0);
        agencyEstate.setExportEnabled(n != 2);
        ArrayList<Long> arrayList = new ArrayList<Long>();
        if (n == 1) {
            for (Long l : this.estateExportBoxes.keySet()) {
                if (!this.estateExportBoxes.get(l).isSelected()) continue;
                arrayList.add(l);
            }
        }
        agencyEstate.setExportInterfaces(arrayList);
    }

    @Override
    public void saveFinished(AgencyEstate agencyEstate) throws ImmoToolException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reloadHistory() throws ImmoToolException, XMLDBException {
        if (this.viewEstateId <= 0L) {
            return;
        }
        Collection collection = null;
        try {
            String string;
            Node node;
            XMLResource xMLResource;
            long l;
            collection = AgencyPluginUtils.openPluginCollection("/exports/summaries");
            String string2 = "declare namespace util=\"http://exist-db.org/xquery/util\";\nfor $x in collection('ImmoTool/OpenEstate-Agency/exports/summaries')/*/entry\n  let $key:=$x/@key\n  let $doc:=util:document-name($x)\n  where ( ($x/text()='" + this.viewEstateId + "') and ( " + "starts-with($key, '" + "estate.updated" + ".') " + "or starts-with($key, '" + "estate.removed" + ".') " + "or starts-with($key, '" + "estate.error" + ".') ) " + ")\n" + "  return <result doc=\"{$doc}\" />";
            ResourceSet resourceSet = ImmoToolDbUtils.executeXQuery((Collection)collection, (String)string2);
            if (resourceSet.getSize() == 0L) {
                this.exportHistoryTable.packAll();
                return;
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            StringBuilder stringBuilder = new StringBuilder();
            for (l = 0L; l < resourceSet.getSize(); ++l) {
                xMLResource = (XMLResource)resourceSet.getResource(l);
                node = xMLResource.getContentAsDOM();
                string = node.getAttributes().getNamedItem("doc").getNodeValue();
                if (arrayList.contains(string)) continue;
                arrayList.add(string);
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append("'").append("ImmoTool/OpenEstate-Agency").append("/exports/summaries").append("/").append(string).append("'");
            }
            string2 = "for $x in document(" + stringBuilder.toString() + ")/properties\n" + "  let $interfaceId:=$x/entry[@key='" + "interface.id" + "']/text()\n" + "  let $interfaceName:=$x/entry[@key='" + "interface.name" + "']/text()\n" + "  let $time:=$x/entry[@key='" + "time" + "']/text()\n" + "  return <result interfaceId=\"{$interfaceId}\" interfaceName=\"{$interfaceName}\" time=\"{$time}\" />";
            resourceSet = ImmoToolDbUtils.executeXQuery((Collection)collection, (String)string2);
            for (l = 0L; l < resourceSet.getSize(); ++l) {
                xMLResource = (XMLResource)resourceSet.getResource(l);
                node = xMLResource.getContentAsDOM();
                string = node.getAttributes().getNamedItem("interfaceName").getNodeValue();
                Date date = new Date();
                date.setTime(Long.valueOf(node.getAttributes().getNamedItem("time").getNodeValue()));
                this.exportTableModel.addRow(new Object[]{date, string});
            }
            this.exportHistoryTable.packAll();
            return;
        }
        finally {
            if (collection != null) {
                ImmoToolDbUtils.close((Collection)collection);
            }
        }
    }

    private void initComponents() {
        this.titleLabel = ImmoToolUtils.createHead2Separator((String)"");
        this.tabPanel = new JTabbedPane();
        this.exportInterfacePanel = new JPanel();
        this.exportInterfaceTitleLabel = ImmoToolUtils.createHead2Separator((String)"");
        this.exportInterfaceFormPanel = new JPanel();
        this.exportHistoryPanel = new JPanel();
        this.exportHistoryTitleLabel = ImmoToolUtils.createHead2Separator((String)"");
        this.exportHistoryRefreshButton = new JButton();
        this.exportHistoryTableScroller = new JScrollPane();
        this.exportHistoryTable = new JXTable();
        this.setName("Form");
        this.titleLabel.setName("titleLabel");
        this.titleLabel.setTitle("titleLabel");
        this.tabPanel.setName("tabPanel");
        this.exportInterfacePanel.setName("exportInterfacePanel");
        this.exportInterfaceTitleLabel.setName("exportInterfaceTitleLabel");
        this.exportInterfaceTitleLabel.setTitle("exportInterfaceTitleLabel");
        this.exportInterfaceFormPanel.setName("exportInterfaceFormPanel");
        GroupLayout groupLayout = new GroupLayout(this.exportInterfaceFormPanel);
        this.exportInterfaceFormPanel.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 741, Short.MAX_VALUE));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 412, Short.MAX_VALUE));
        GroupLayout groupLayout2 = new GroupLayout(this.exportInterfacePanel);
        this.exportInterfacePanel.setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout2.createSequentialGroup().addContainerGap().addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.exportInterfaceFormPanel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent((Component)this.exportInterfaceTitleLabel, GroupLayout.Alignment.LEADING, -1, 741, Short.MAX_VALUE)).addContainerGap()));
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addComponent((Component)this.exportInterfaceTitleLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.exportInterfaceFormPanel, -1, -1, Short.MAX_VALUE).addContainerGap()));
        this.tabPanel.addTab("interfaces", this.exportInterfacePanel);
        this.exportHistoryPanel.setName("exportHistoryPanel");
        this.exportHistoryTitleLabel.setName("exportHistoryTitleLabel");
        this.exportHistoryTitleLabel.setTitle("exportHistoryTitleLabel");
        this.exportHistoryRefreshButton.setText("doRefresh");
        this.exportHistoryRefreshButton.setName("exportHistoryRefreshButton");
        this.exportHistoryTableScroller.setName("exportHistoryTableScroller");
        this.exportHistoryTable.setModel((TableModel)new DefaultTableModel(new Object[0][], new String[]{"timestamp", "interface"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{Object.class, String.class};
                this.canEdit = new boolean[]{false, false};
            }

            public Class getColumnClass(int n) {
                return this.types[n];
            }

            @Override
            public boolean isCellEditable(int n, int n2) {
                return this.canEdit[n2];
            }
        });
        this.exportHistoryTable.setName("exportHistoryTable");
        this.exportHistoryTableScroller.setViewportView((Component)this.exportHistoryTable);
        GroupLayout groupLayout3 = new GroupLayout(this.exportHistoryPanel);
        this.exportHistoryPanel.setLayout(groupLayout3);
        groupLayout3.setHorizontalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout3.createSequentialGroup().addContainerGap().addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.exportHistoryTableScroller, GroupLayout.Alignment.LEADING, -1, 741, Short.MAX_VALUE).addGroup(groupLayout3.createSequentialGroup().addComponent((Component)this.exportHistoryTitleLabel, -1, 628, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.exportHistoryRefreshButton))).addContainerGap()));
        groupLayout3.setVerticalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout3.createSequentialGroup().addContainerGap().addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.exportHistoryRefreshButton).addComponent((Component)this.exportHistoryTitleLabel, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.exportHistoryTableScroller, -1, 402, Short.MAX_VALUE).addContainerGap()));
        this.tabPanel.addTab("exportHistory", this.exportHistoryPanel);
        GroupLayout groupLayout4 = new GroupLayout((Container)((Object)this));
        this.setLayout(groupLayout4);
        groupLayout4.setHorizontalGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout4.createSequentialGroup().addContainerGap().addGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.tabPanel, GroupLayout.Alignment.LEADING, -1, 770, Short.MAX_VALUE).addComponent((Component)this.titleLabel, GroupLayout.Alignment.LEADING, -1, 770, Short.MAX_VALUE)).addContainerGap()));
        groupLayout4.setVerticalGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout4.createSequentialGroup().addContainerGap().addComponent((Component)this.titleLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.tabPanel, -1, 484, Short.MAX_VALUE).addContainerGap()));
    }
}

