/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.factories.Borders;
import com.openindex.openestate.impl.EstateAttachmentImpl;
import com.openindex.openestate.impl.OpenEstateUtils;
import com.openindex.openestate.tool.ImmoToolApp;
import com.openindex.openestate.tool.ImmoToolException;
import com.openindex.openestate.tool.ImmoToolTask;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.agency.AgencyEstate;
import com.openindex.openestate.tool.agency.AgencyEstateViewAddonPanel;
import com.openindex.openestate.tool.agency.AgencyPlugin;
import com.openindex.openestate.tool.utils.JImageFileChooser;
import com.openindex.openestate.tool.utils.JImageList;
import eu.medsea.mimeutil.MimeType;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import javax.imageio.ImageIO;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.jdesktop.application.Action;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.application.Task;
import org.jdesktop.swingx.JXImageView;
import org.jdesktop.swingx.JXTable;
import org.xmldb.api.base.XMLDBException;

public class AgencyEstateViewMediaPanel
extends AgencyEstateViewAddonPanel {
    private static final Logger LOGGER = Logger.getLogger(AgencyEstateViewMediaPanel.class);
    private ActionMap actionMap = null;
    private ResourceMap resourceMap = null;
    private boolean isModified = false;
    private int tabPosition = 0;
    private AgencyEstate galleryEstate = null;
    private JTabbedPane tabPanel;
    private JButton importFileButton;
    private JButton exportFileButton;
    private int rotation = 0;
    private boolean flippedH = false;
    private boolean flippedV = false;
    private EstateImageItem selectedImage = null;
    private ArrayList<EstateImageItem> availableImages;
    private JPanel imageFormPanel;
    private JButton savePhotoButton;
    private JButton removePhotoButton;
    private JButton moveUpPhotoButton;
    private JButton moveDownPhotoButton;
    private JButton imageRotateLeftButton;
    private JButton imageRotateRightButton;
    private JButton imageFlipHorizontalButton;
    private JButton imageFlipVerticalButton;
    private Map<Locale, JTextField> imageTextFields;
    private Map<Locale, JLabel> imageTextLabels;
    private JComboBox imageFormatBox;
    private JComboBox imageTypeBox;
    private JCheckBox imagePublishedBox;
    private JXImageView imageView;
    private JImageList galleryList;
    private DefaultListModel galleryListModel;
    private DragSource galleryListDragSource;
    private DragGestureRecognizer galleryListDragGestureRecognizer;
    private EstateAttachmentImpl selectedFile = null;
    private ArrayList<EstateAttachmentImpl> availableFiles;
    private JPanel fileFormPanel;
    private JButton saveFileButton;
    private JButton removeFileButton;
    private JButton moveUpFileButton;
    private JButton moveDownFileButton;
    private Map<Locale, JTextField> fileTextFields;
    private Map<Locale, JLabel> fileTextLabels;
    private JComboBox fileTypeBox;
    private JCheckBox filePublishedBox;
    private JXTable fileTable;
    private FileTableModel fileTableModel;

    public AgencyEstateViewMediaPanel() {
        this.build();
    }

    private void build() {
        this.actionMap = ImmoToolUtils.getActionMap(AgencyEstateViewMediaPanel.class, (Object)((Object)this));
        this.resourceMap = ImmoToolUtils.getResourceMap(AgencyEstateViewMediaPanel.class);
        this.availableImages = new ArrayList();
        this.availableFiles = new ArrayList();
        this.buildPanel();
        this.galleryList.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 127) {
                    AgencyEstateViewMediaPanel.this.doRemovePhoto();
                }
            }
        });
        this.galleryList.setDragEnabled(false);
        this.galleryList.setDropTarget(new DropTarget((Component)this.galleryList, new GalleryListDropListener()));
        this.galleryListDragSource = new DragSource();
        this.galleryListDragGestureRecognizer = this.galleryListDragSource.createDefaultDragGestureRecognizer((Component)this.galleryList, 3, new GalleryListDragListener());
        this.galleryList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (listSelectionEvent.getValueIsAdjusting()) {
                    return;
                }
                if (AgencyEstateViewMediaPanel.this.selectedImage != null) {
                    AgencyEstateViewMediaPanel.this.saveImage();
                }
                AgencyEstateViewMediaPanel.this.selectImage(AgencyEstateViewMediaPanel.this.galleryList.getSelectedIndex());
            }
        });
        for (final JTextField jTextField : this.imageTextFields.values()) {
            jTextField.addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent focusEvent) {
                    if (AgencyEstateViewMediaPanel.this.selectedImage != null) {
                        for (Locale locale : AgencyEstateViewMediaPanel.this.imageTextFields.keySet()) {
                            if (AgencyEstateViewMediaPanel.this.imageTextFields.get(locale) != jTextField) continue;
                            AgencyEstateViewMediaPanel.this.selectedImage.getImageTexts().put(locale, ((JTextField)AgencyEstateViewMediaPanel.this.imageTextFields.get(locale)).getText().trim());
                            break;
                        }
                    }
                }
            });
            jTextField.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (AgencyEstateViewMediaPanel.this.selectedImage != null) {
                        AgencyEstateViewMediaPanel.this.doSavePhoto();
                    }
                }
            });
        }
        this.fileTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!AgencyEstateViewMediaPanel.this.fileTable.isEnabled() || listSelectionEvent.getValueIsAdjusting() || AgencyEstateViewMediaPanel.this.fileTable.getSelectedRowCount() < 1) {
                    return;
                }
                int n = AgencyEstateViewMediaPanel.this.fileTable.getSelectedRow();
                AgencyEstateViewMediaPanel.this.selectFile(AgencyEstateViewMediaPanel.this.fileTable.convertRowIndexToModel(n));
            }
        });
        this.tabPanel.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                int n = AgencyEstateViewMediaPanel.this.tabPanel.getSelectedIndex();
                if (AgencyEstateViewMediaPanel.this.tabPosition == n) {
                    return;
                }
                if (n == 0) {
                    AgencyEstateViewMediaPanel.this.exportFileButton.setEnabled(AgencyEstateViewMediaPanel.this.selectedImage != null);
                } else if (n == 1) {
                    AgencyEstateViewMediaPanel.this.exportFileButton.setEnabled(AgencyEstateViewMediaPanel.this.selectedFile != null);
                } else {
                    AgencyEstateViewMediaPanel.this.exportFileButton.setEnabled(false);
                }
                AgencyEstateViewMediaPanel.this.tabPosition = n;
            }
        });
        this.resourceMap.injectComponents((Component)((Object)this));
        this.removePhotoButton.setEnabled(false);
        this.moveUpPhotoButton.setEnabled(false);
        this.moveDownPhotoButton.setEnabled(false);
        this.exportFileButton.setEnabled(false);
        this.imageFormPanel.setVisible(false);
        this.selectImage(-1);
    }

    private void buildPanel() {
        this.importFileButton = new JButton(this.actionMap.get("doImportFiles"));
        this.importFileButton.setName("importFileButton");
        this.exportFileButton = new JButton(this.actionMap.get("doExportFiles"));
        this.exportFileButton.setName("exportFileButton");
        this.tabPanel = new JTabbedPane();
        this.tabPanel.add(this.resourceMap.getString("tab.images", new Object[0]), this.buildGalleryTab());
        this.tabPanel.add(this.resourceMap.getString("tab.files", new Object[0]), this.buildFilesTab());
        this.tabPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, 15, 10, 15), this.tabPanel.getBorder()));
        DefaultFormBuilder defaultFormBuilder = ImmoToolUtils.createFormBuilder((String)"30dlu:grow, 3dlu, pref, 3dlu, pref");
        defaultFormBuilder.border(Borders.DIALOG);
        defaultFormBuilder.append((Component)ImmoToolUtils.createHead2Separator((String)this.resourceMap.getString("title.media", new Object[0])));
        defaultFormBuilder.append((Component)this.importFileButton);
        defaultFormBuilder.append((Component)this.exportFileButton);
        defaultFormBuilder.nextLine();
        this.setLayout(new BorderLayout());
        this.add(defaultFormBuilder.getPanel(), "North");
        this.add(this.tabPanel, "Center");
        this.revalidate();
        this.repaint();
    }

    private JPanel buildFilesTab() {
        Serializable serializable2;
        this.filePublishedBox = new JCheckBox();
        this.filePublishedBox.setName("filePublishedBox");
        this.filePublishedBox.setEnabled(false);
        this.fileTypeBox = new JComboBox();
        this.fileTypeBox.setName("fileTypeBox");
        this.fileTypeBox.setRenderer(new FileTypeRenderer(this.resourceMap.getString("label.fileType.empty", new Object[0])));
        this.fileTypeBox.addItem(null);
        this.fileTypeBox.setEnabled(false);
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        for (String string : EstateAttachmentImpl.getTypes()) {
            treeMap.put(OpenEstateUtils.translateAttachment((String)string), string);
        }
        for (String string : treeMap.values()) {
            this.fileTypeBox.addItem(string);
        }
        this.fileTextFields = new HashMap<Locale, JTextField>();
        this.fileTextLabels = new HashMap<Locale, JLabel>();
        TreeMap treeMap2 = new TreeMap();
        for (Locale object2 : AgencyPlugin.getLocales()) {
            treeMap2.put(object2.getDisplayLanguage(), object2);
        }
        for (Locale locale : treeMap2.values()) {
            JTextField jTextField = new JTextField();
            jTextField.setName("fileTextField");
            jTextField.setEnabled(false);
            this.fileTextFields.put(locale, jTextField);
            JLabel jLabel = new JLabel(this.resourceMap.getString("label.selectedFile.title", new Object[0]));
            jLabel.setHorizontalTextPosition(10);
            jLabel.setIcon(OpenEstateUtils.getFlagIcon((Locale)locale));
            this.fileTextLabels.put(locale, jLabel);
        }
        this.fileTableModel = new FileTableModel();
        this.fileTable = new JXTable((TableModel)this.fileTableModel);
        this.fileTable.setSelectionMode(0);
        this.fileTable.setSortable(true);
        ImmoToolUtils.configureTable((JXTable)this.fileTable);
        this.saveFileButton = new JButton(this.actionMap.get("doSaveFile"));
        this.saveFileButton.setName("saveFileButton");
        this.removeFileButton = new JButton(this.actionMap.get("doRemoveFile"));
        this.removeFileButton.setName("removeFileButton");
        this.moveUpFileButton = new JButton(this.actionMap.get("doMoveUpFile"));
        this.moveUpFileButton.setName("moveUpFileButton");
        this.moveDownFileButton = new JButton(this.actionMap.get("doMoveDownFile"));
        this.moveDownFileButton.setName("moveDownFileButton");
        JPanel jPanel = new JPanel(new FlowLayout());
        jPanel.add(this.saveFileButton);
        jPanel.add(this.moveUpFileButton);
        jPanel.add(this.moveDownFileButton);
        jPanel.add(this.removeFileButton);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)ImmoToolUtils.createHead2Separator((String)this.resourceMap.getString("label.selectedFile", new Object[0])), "Center");
        jPanel2.add((Component)jPanel, "East");
        DefaultFormBuilder defaultFormBuilder = ImmoToolUtils.createFormBuilder((String)"right:[40dlu,pref], 3dlu, 30dlu:grow, 3dlu, pref");
        defaultFormBuilder.append((Component)jPanel2, 5);
        defaultFormBuilder.nextLine();
        for (Serializable serializable2 : treeMap2.values()) {
            defaultFormBuilder.append((Component)this.fileTextLabels.get(serializable2));
            defaultFormBuilder.append((Component)this.fileTextFields.get(serializable2), 3);
            defaultFormBuilder.nextLine();
        }
        defaultFormBuilder.append(this.resourceMap.getString("label.fileType", new Object[0]), (Component)this.fileTypeBox);
        defaultFormBuilder.append((Component)this.filePublishedBox);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append((Component)new JLabel(" "), 5);
        defaultFormBuilder.nextLine();
        JScrollPane jScrollPane = new JScrollPane((Component)this.fileTable);
        jScrollPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(10, 0, 0, 0), jScrollPane.getBorder()));
        serializable2 = new JPanel(new BorderLayout());
        ((Container)serializable2).add((Component)ImmoToolUtils.createHead2Separator((String)this.resourceMap.getString("label.availableFiles", new Object[0])), "North");
        ((Container)serializable2).add(jScrollPane, "Center");
        this.fileFormPanel = defaultFormBuilder.getPanel();
        JPanel jPanel3 = new JPanel();
        jPanel3.setBorder(BorderFactory.createEmptyBorder(5, 15, 10, 15));
        jPanel3.setLayout(new BorderLayout());
        jPanel3.add((Component)this.fileFormPanel, "North");
        jPanel3.add((Component)serializable2, "Center");
        jPanel3.revalidate();
        jPanel3.repaint();
        return jPanel3;
    }

    private JPanel buildGalleryTab() {
        Serializable serializable2;
        this.savePhotoButton = new JButton(this.actionMap.get("doSavePhoto"));
        this.savePhotoButton.setName("savePhotoButton");
        this.removePhotoButton = new JButton(this.actionMap.get("doRemovePhoto"));
        this.removePhotoButton.setName("removePhotoButton");
        this.moveUpPhotoButton = new JButton(this.actionMap.get("doMoveUpPhoto"));
        this.moveUpPhotoButton.setName("moveUpPhotoButton");
        this.moveDownPhotoButton = new JButton(this.actionMap.get("doMoveDownPhoto"));
        this.moveDownPhotoButton.setName("moveDownPhotoButton");
        this.imageView = new JXImageView();
        this.imageView.setName("imageView");
        this.imageRotateLeftButton = new JButton(this.actionMap.get("doRotateLeft"));
        this.imageRotateLeftButton.setName("imageRotateLeftButton");
        this.imageRotateRightButton = new JButton(this.actionMap.get("doRotateRight"));
        this.imageRotateRightButton.setName("imageRotateRightButton");
        this.imageFlipHorizontalButton = new JButton(this.actionMap.get("doFlipHorizontal"));
        this.imageFlipHorizontalButton.setName("imageFlipHorizontalButton");
        this.imageFlipVerticalButton = new JButton(this.actionMap.get("doFlipVertical"));
        this.imageFlipVerticalButton.setName("imageFlipVerticalButton");
        this.imagePublishedBox = new JCheckBox();
        this.imagePublishedBox.setName("imagePublishedBox");
        this.imageFormatBox = new JComboBox();
        this.imageFormatBox.setName("imageFormatBox");
        this.imageFormatBox.setRenderer(new ImageFormatRenderer());
        this.imageFormatBox.addItem("JPG");
        this.imageFormatBox.addItem("PNG");
        this.imageTypeBox = new JComboBox();
        this.imageTypeBox.setName("imageTypeBox");
        this.imageTypeBox.setRenderer(new FileTypeRenderer(this.resourceMap.getString("label.imageType.empty", new Object[0])));
        this.imageTypeBox.addItem(null);
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        for (String string : EstateAttachmentImpl.getTypes()) {
            treeMap.put(OpenEstateUtils.translateAttachment((String)string), string);
        }
        for (String string : treeMap.values()) {
            this.imageTypeBox.addItem(string);
        }
        this.imageTextFields = new HashMap<Locale, JTextField>();
        this.imageTextLabels = new HashMap<Locale, JLabel>();
        TreeMap treeMap2 = new TreeMap();
        for (Locale serializable22 : AgencyPlugin.getLocales()) {
            treeMap2.put(serializable22.getDisplayLanguage(), serializable22);
        }
        for (Locale locale : treeMap2.values()) {
            JTextField jTextField = new JTextField();
            jTextField.setName("imageTextField");
            this.imageTextFields.put(locale, jTextField);
            JLabel jLabel = new JLabel(this.resourceMap.getString("label.selectedImage.title", new Object[0]));
            jLabel.setHorizontalTextPosition(10);
            jLabel.setIcon(OpenEstateUtils.getFlagIcon((Locale)locale));
            this.imageTextLabels.put(locale, jLabel);
        }
        this.galleryListModel = new DefaultListModel();
        this.galleryList = new JImageList();
        this.galleryList.setModel((ListModel)this.galleryListModel);
        this.galleryList.setName("galleryList");
        this.galleryList.setOpaque(false);
        this.galleryList.setSelectionMode(0);
        this.galleryList.setAutoscrolls(false);
        JPanel jPanel = new JPanel(new FlowLayout());
        jPanel.add(this.savePhotoButton);
        jPanel.add(this.removePhotoButton);
        jPanel.add(this.moveUpPhotoButton);
        jPanel.add(this.moveDownPhotoButton);
        JPanel jPanel2 = new JPanel(new FlowLayout());
        jPanel2.add(this.imageFlipHorizontalButton);
        jPanel2.add(this.imageFlipVerticalButton);
        jPanel2.add(this.imageRotateLeftButton);
        jPanel2.add(this.imageRotateRightButton);
        DefaultFormBuilder defaultFormBuilder = ImmoToolUtils.createFormBuilder((String)"30dlu:grow, 3dlu, pref");
        defaultFormBuilder.append((Component)ImmoToolUtils.createHead2Separator((String)this.resourceMap.getString("label.imageViewer", new Object[0])));
        defaultFormBuilder.append((Component)jPanel2);
        defaultFormBuilder.nextLine();
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.add((Component)ImmoToolUtils.createHead2Separator((String)this.resourceMap.getString("label.selectedImage", new Object[0])), "Center");
        jPanel3.add((Component)jPanel, "East");
        DefaultFormBuilder defaultFormBuilder2 = ImmoToolUtils.createFormBuilder((String)"right:[40dlu,pref], 3dlu, 30dlu:grow, 3dlu, right:pref, 3dlu, pref, 3dlu, pref");
        defaultFormBuilder2.append((Component)jPanel3, 9);
        defaultFormBuilder2.nextLine();
        for (Serializable serializable2 : treeMap2.values()) {
            defaultFormBuilder2.append((Component)this.imageTextLabels.get(serializable2));
            defaultFormBuilder2.append((Component)this.imageTextFields.get(serializable2), 7);
            defaultFormBuilder2.nextLine();
        }
        defaultFormBuilder2.append(this.resourceMap.getString("label.imageType", new Object[0]), (Component)this.imageTypeBox);
        defaultFormBuilder2.append(this.resourceMap.getString("label.imageFormat", new Object[0]), (Component)this.imageFormatBox);
        defaultFormBuilder2.append((Component)this.imagePublishedBox);
        defaultFormBuilder2.nextLine();
        JPanel jPanel4 = new JPanel(new BorderLayout());
        jPanel4.add((Component)defaultFormBuilder.getPanel(), "North");
        serializable2 = new JScrollPane((Component)this.imageView);
        jPanel4.add((Component)serializable2, "Center");
        jPanel4.setBorder(BorderFactory.createEmptyBorder(0, 15, 10, 15));
        JPanel jPanel5 = defaultFormBuilder2.getPanel();
        jPanel5.setBorder(BorderFactory.createEmptyBorder(5, 15, 10, 15));
        this.imageFormPanel = new JPanel(new BorderLayout());
        this.imageFormPanel.setBorder(Borders.EMPTY);
        this.imageFormPanel.add((Component)jPanel5, "North");
        this.imageFormPanel.add((Component)jPanel4, "Center");
        JScrollPane jScrollPane = new JScrollPane((Component)this.galleryList);
        jScrollPane.setBorder(Borders.EMPTY);
        jScrollPane.setPreferredSize(new Dimension(130, 130));
        jScrollPane.getVerticalScrollBar().setUnitIncrement(20);
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new BorderLayout());
        jPanel6.add((Component)this.imageFormPanel, "Center");
        jPanel6.add((Component)jScrollPane, "East");
        jPanel6.revalidate();
        jPanel6.repaint();
        return jPanel6;
    }

    @Action
    public Task doExportFiles() {
        boolean bl;
        File file = AgencyPlugin.getLastImageLocation();
        Object object = null;
        String string = ".";
        boolean bl2 = bl = this.tabPanel.getSelectedIndex() == 0;
        if (bl) {
            if (this.selectedImage == null) {
                return null;
            }
            object = new JImageFileChooser();
            ((JFileChooser)object).setDialogTitle(this.resourceMap.getString("message.exportImages", new Object[0]));
            ((JFileChooser)object).setApproveButtonText(this.resourceMap.getString("message.exportImages", new Object[0]));
            ((JImageFileChooser)object).setImageWritingFilter();
            string = this.selectedImage.getImageResourceName();
        } else {
            String string2;
            int n;
            if (this.selectedFile == null) {
                return null;
            }
            object = new JFileChooser();
            ((JFileChooser)object).setDialogTitle(this.resourceMap.getString("message.exportFiles", new Object[0]));
            ((JFileChooser)object).setApproveButtonText(this.resourceMap.getString("message.exportFiles", new Object[0]));
            if (this.selectedFile.isName()) {
                string = this.selectedFile.getFileAsName();
            } else if (this.selectedFile.isUrl() && (n = (string2 = this.selectedFile.getFileAsUrl().getPath()).lastIndexOf("/")) > 0 && n < string2.length()) {
                string = string2.substring(n + 1);
            }
        }
        if (file != null) {
            ((JFileChooser)object).setSelectedFile(new File(file.getAbsolutePath() + File.separator + string));
        } else {
            ((JFileChooser)object).setSelectedFile(new File(string));
        }
        int n = ((JFileChooser)object).showSaveDialog((Component)((Object)this));
        if (n != 0) {
            return null;
        }
        final File file2 = ((JFileChooser)object).getSelectedFile();
        return new ImmoToolTask<Boolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            protected Boolean executeTask() throws Exception {
                File file;
                InputStream inputStream;
                block4: {
                    String[] stringArray = file2.getName().split("\\.");
                    if (bl) {
                        ImageIO.write((RenderedImage)((Object)AgencyEstateViewMediaPanel.this.imageView.getImage()), stringArray[stringArray.length - 1], file2);
                        return true;
                    }
                    inputStream = null;
                    file = null;
                    try {
                        if (AgencyEstateViewMediaPanel.this.selectedFile.isUrl()) {
                            inputStream = AgencyEstateViewMediaPanel.this.selectedFile.getFileAsUrl().openStream();
                            ImmoToolUtils.writeStreamToFile((InputStream)inputStream, (File)file2);
                            break block4;
                        }
                        if (!AgencyEstateViewMediaPanel.this.selectedFile.isName()) break block4;
                        AgencyEstate.loadAttachmentIntoFile(file2, AgencyEstateViewMediaPanel.this.galleryEstate.getIdNr(), AgencyEstateViewMediaPanel.this.selectedFile.getFileAsName());
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(inputStream);
                        FileUtils.deleteQuietly(file);
                        throw throwable;
                    }
                }
                IOUtils.closeQuietly((InputStream)inputStream);
                FileUtils.deleteQuietly(file);
                return true;
            }

            protected void failed(Throwable throwable) {
                super.failed(throwable);
                ImmoToolUtils.showMessageErrorDialog((String)AgencyEstateViewMediaPanel.this.resourceMap.getString("error.cantExportFiles", new Object[0]), (Throwable)throwable);
            }

            protected void succeeded(Boolean bl2) {
                super.succeeded((Object)bl2);
                ImmoToolUtils.showMessageInfoDialog((String)AgencyEstateViewMediaPanel.this.resourceMap.getString("message.exportWasSuccessful", new Object[]{file2.getAbsolutePath()}));
            }
        };
    }

    @Action
    public void doFlipHorizontal() {
        this.isModified = true;
        this.flippedH = !this.flippedH;
        this.imageView.setVisible(false);
        BufferedImage bufferedImage = (BufferedImage)this.imageView.getImage();
        BufferedImage bufferedImage2 = ImmoToolUtils.flipImageHorizontal((BufferedImage)bufferedImage, (int)2);
        this.imageView.setImage((Image)bufferedImage2);
        bufferedImage.flush();
        this.imageView.setVisible(true);
    }

    @Action
    public void doFlipVertical() {
        this.isModified = true;
        this.flippedV = !this.flippedV;
        this.imageView.setVisible(false);
        BufferedImage bufferedImage = (BufferedImage)this.imageView.getImage();
        BufferedImage bufferedImage2 = ImmoToolUtils.flipImageVertical((BufferedImage)bufferedImage, (int)2);
        this.imageView.setImage((Image)bufferedImage2);
        bufferedImage.flush();
        this.imageView.setVisible(true);
    }

    @Action
    public Task doImportFiles() {
        int n;
        File file = AgencyPlugin.getLastImageLocation();
        ExtendedJImageFileChooser extendedJImageFileChooser = new ExtendedJImageFileChooser();
        extendedJImageFileChooser.setDialogTitle(this.resourceMap.getString("message.importFiles", new Object[0]));
        extendedJImageFileChooser.setApproveButtonText(this.resourceMap.getString("message.importFiles", new Object[0]));
        extendedJImageFileChooser.setMultiSelectionEnabled(true);
        if (file != null) {
            extendedJImageFileChooser.setSelectedFile(new File(file.getAbsolutePath() + File.separator + "."));
        }
        if ((n = extendedJImageFileChooser.showOpenDialog((Component)((Object)this))) != 0) {
            return null;
        }
        AgencyPlugin.setLastImageLocation(extendedJImageFileChooser.getSelectedFile().getParentFile());
        final File[] fileArray = extendedJImageFileChooser.getSelectedFiles();
        final boolean bl = extendedJImageFileChooser.isImportWithNames();
        this.importFileButton.setEnabled(false);
        return new ImmoToolTask<Boolean>(){
            private EstateImageItem[] importedImages;
            private EstateAttachmentImpl[] importedFiles;

            protected Boolean executeTask() throws Exception {
                ArrayList<EstateImageItem> arrayList = new ArrayList<EstateImageItem>();
                ArrayList<Object> arrayList2 = new ArrayList<Object>();
                for (File file : fileArray) {
                    if (!file.isFile()) continue;
                    try {
                        Object object;
                        boolean bl2 = false;
                        EstateImageItem estateImageItem = null;
                        MimeType mimeType = ImmoToolUtils.getMimeType((File)file);
                        try {
                            if (AgencyEstateViewMediaPanel.this.isImageMimeType(mimeType) && (estateImageItem = new EstateImageItem(AgencyEstateViewMediaPanel.this.availableImages.size(), file)) != null) {
                                bl2 = true;
                            }
                        }
                        catch (Exception exception) {
                            bl2 = false;
                            LOGGER.warn((Object)"Can't load attachment as image!");
                            LOGGER.warn((Object)("> " + file.getName()));
                            LOGGER.warn((Object)("> " + exception.getLocalizedMessage()));
                        }
                        if (bl2) {
                            this.setMessage(AgencyEstateViewMediaPanel.this.resourceMap.getString("message.doOpenImage", new Object[]{file.getName()}));
                            estateImageItem.setImagePublished(true);
                            if (bl) {
                                object = file.getName();
                                int n = ((String)object).lastIndexOf(".");
                                if (n > 0) {
                                    object = ((String)object).substring(0, n);
                                }
                                for (Object object2 : AgencyEstateViewMediaPanel.this.imageTextFields.keySet()) {
                                    estateImageItem.getImageTexts().put((Locale)object2, ((String)object).trim());
                                }
                            }
                            arrayList.add(estateImageItem);
                            continue;
                        }
                        this.setMessage(AgencyEstateViewMediaPanel.this.resourceMap.getString("message.doOpenFile", new Object[]{file.getName()}));
                        object = new EstateAttachmentImpl();
                        object.setFile(file.toURI().toURL());
                        object.setPublished(Boolean.valueOf(false));
                        object.setMimeType(mimeType.toString());
                        if (bl) {
                            Object object2;
                            String string = file.getName();
                            int n = string.lastIndexOf(".");
                            if (n > 0) {
                                string = string.substring(0, n);
                            }
                            object2 = AgencyEstateViewMediaPanel.this.fileTextFields.keySet().iterator();
                            while (object2.hasNext()) {
                                Locale locale = (Locale)object2.next();
                                object.setTitle(string.trim(), locale);
                            }
                        }
                        arrayList2.add(object);
                    }
                    catch (Exception exception) {
                        LOGGER.warn((Object)"could not load attachment!");
                        LOGGER.warn((Object)("> " + file.getAbsolutePath()));
                        LOGGER.warn((Object)("> " + exception.getLocalizedMessage()));
                    }
                }
                this.importedImages = arrayList.toArray(new EstateImageItem[arrayList.size()]);
                this.importedFiles = arrayList2.toArray(new EstateAttachmentImpl[arrayList2.size()]);
                return true;
            }

            protected void failed(Throwable throwable) {
                super.failed(throwable);
                LOGGER.error((Object)"could not import images!");
                LOGGER.error((Object)("> " + throwable.getLocalizedMessage()), throwable);
                ImmoToolUtils.showMessageErrorDialog((String)AgencyEstateViewMediaPanel.this.resourceMap.getString("error.cantImportFiles", new Object[0]), (Throwable)throwable);
            }

            protected void finished() {
                super.finished();
                AgencyEstateViewMediaPanel.this.importFileButton.setEnabled(true);
            }

            protected void succeeded(Boolean bl2) {
                super.succeeded((Object)bl2);
                if (bl2 == null || Boolean.FALSE.equals(bl2)) {
                    ImmoToolUtils.showMessageInfoDialog((String)AgencyEstateViewMediaPanel.this.resourceMap.getString("message.noFilesImported", new Object[0]));
                    return;
                }
                for (EstateImageItem estateImageItem : this.importedImages) {
                    AgencyEstateViewMediaPanel.this.galleryListModel.addElement(estateImageItem.getImageListIcon());
                    AgencyEstateViewMediaPanel.this.availableImages.add(estateImageItem);
                }
                for (int i = 0; i < AgencyEstateViewMediaPanel.this.availableImages.size(); ++i) {
                    ((EstateImageItem)AgencyEstateViewMediaPanel.this.availableImages.get(i)).setImageIndex(i);
                }
                AgencyEstateViewMediaPanel.this.galleryList.setSelectedIndex(AgencyEstateViewMediaPanel.this.galleryListModel.getSize() - this.importedImages.length);
                for (EstateAttachmentImpl estateAttachmentImpl : this.importedFiles) {
                    AgencyEstateViewMediaPanel.this.fileTableModel.addFile(estateAttachmentImpl);
                    AgencyEstateViewMediaPanel.this.availableFiles.add(estateAttachmentImpl);
                }
                AgencyEstateViewMediaPanel.this.fileTable.packAll();
                AgencyEstateViewMediaPanel.this.isModified = true;
                ImmoToolUtils.showMessageInfoDialog((String)AgencyEstateViewMediaPanel.this.resourceMap.getString("message.filesImported", new Object[]{this.importedImages.length, this.importedFiles.length}));
            }
        };
    }

    @Override
    public Task doLoadInBackground() {
        this.availableImages.clear();
        this.availableFiles.clear();
        this.galleryListModel.clear();
        this.fileTableModel.clear();
        return new ImmoToolTask<Boolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected Boolean executeTask() throws Exception {
                Long l = AgencyEstateViewMediaPanel.this.galleryEstate.getIdNr();
                if (l == null) {
                    return null;
                }
                for (EstateAttachmentImpl estateAttachmentImpl : AgencyEstateViewMediaPanel.this.galleryEstate.getAttachments()) {
                    String string = estateAttachmentImpl.getMimeType();
                    if (string == null) continue;
                    String string2 = null;
                    if ("image/jpeg".equalsIgnoreCase(string)) {
                        string2 = "JPG";
                    } else if ("image/png".equalsIgnoreCase(string)) {
                        string2 = "PNG";
                    }
                    boolean bl = false;
                    MimeType mimeType = new MimeType(string);
                    if (AgencyEstateViewMediaPanel.this.isImageMimeType(mimeType)) {
                        File file;
                        block12: {
                            file = null;
                            file = AgencyEstate.loadAttachmentAsTempFile(l, estateAttachmentImpl.getFileAsName());
                            if (file != null) break block12;
                            FileUtils.deleteQuietly((File)file);
                            continue;
                        }
                        try {
                            BufferedImage bufferedImage = ImageIO.read(file);
                            EstateImageItem estateImageItem = new EstateImageItem(AgencyEstateViewMediaPanel.this.availableImages.size(), bufferedImage, estateAttachmentImpl.getFileAsName(), estateAttachmentImpl.getType(), string2, estateAttachmentImpl.isPublished());
                            for (Locale locale : AgencyEstateViewMediaPanel.this.imageTextFields.keySet()) {
                                String string3 = estateAttachmentImpl.getTitle(locale.getLanguage());
                                if (string3 == null || string3.trim().length() <= 0) continue;
                                estateImageItem.getImageTexts().put(locale, string3.trim());
                            }
                            AgencyEstateViewMediaPanel.this.availableImages.add(estateImageItem);
                            AgencyEstateViewMediaPanel.this.galleryListModel.addElement(estateImageItem.getImageListIcon());
                            bl = true;
                        }
                        catch (Exception exception) {
                            try {
                                bl = false;
                                LOGGER.warn((Object)"could not load attachment as image!");
                                LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
                            }
                            catch (Throwable throwable) {
                                FileUtils.deleteQuietly(file);
                                throw throwable;
                            }
                            FileUtils.deleteQuietly((File)file);
                        }
                        FileUtils.deleteQuietly((File)file);
                    }
                    if (bl) continue;
                    AgencyEstateViewMediaPanel.this.availableFiles.add(estateAttachmentImpl);
                    AgencyEstateViewMediaPanel.this.fileTableModel.addFile(estateAttachmentImpl);
                }
                return true;
            }

            protected void failed(Throwable throwable) {
                super.failed(throwable);
            }

            protected void succeeded(Boolean bl) {
                super.succeeded((Object)bl);
                AgencyEstateViewMediaPanel.this.fileTable.packAll();
            }
        };
    }

    @Action
    public void doMoveDownFile() {
        if (this.selectedFile == null) {
            return;
        }
        int n = this.availableFiles.indexOf(this.selectedFile);
        if (n < 0 || n + 1 >= this.availableFiles.size()) {
            return;
        }
        this.fileTable.setEnabled(false);
        this.fileTable.clearSelection();
        this.fileTableModel.moveRow(n, n, n + 1);
        this.fileTable.scrollRowToVisible(n + 1);
        this.fileTable.getSelectionModel().setSelectionInterval(n + 1, n + 1);
        this.fileTable.setEnabled(true);
        EstateAttachmentImpl estateAttachmentImpl = this.availableFiles.get(n);
        EstateAttachmentImpl estateAttachmentImpl2 = this.availableFiles.get(n + 1);
        this.availableFiles.set(n + 1, estateAttachmentImpl);
        this.availableFiles.set(n, estateAttachmentImpl2);
        this.availableFiles.trimToSize();
        this.moveUpFileButton.setEnabled(true);
        this.moveDownFileButton.setEnabled(n + 2 < this.availableFiles.size());
        this.isModified = true;
    }

    @Action
    public void doMoveDownPhoto() {
        if (this.selectedImage == null) {
            return;
        }
        int n = this.availableImages.indexOf(this.selectedImage);
        if (n < 0 || n + 1 >= this.availableImages.size()) {
            return;
        }
        EstateImageItem estateImageItem = this.availableImages.get(n);
        EstateImageItem estateImageItem2 = this.availableImages.get(n + 1);
        estateImageItem.setImageIndex(n + 1);
        estateImageItem2.setImageIndex(n);
        this.availableImages.set(n + 1, estateImageItem);
        this.availableImages.set(n, estateImageItem2);
        this.availableImages.trimToSize();
        Object e = this.galleryListModel.getElementAt(n);
        Object e2 = this.galleryListModel.getElementAt(n + 1);
        this.galleryListModel.setElementAt(e, n + 1);
        this.galleryListModel.setElementAt(e2, n);
        this.galleryList.setSelectedIndex(n + 1);
        int n2 = this.galleryList.getSelectedIndex();
        if (n2 + 1 < this.galleryList.getModel().getSize()) {
            ++n2;
        }
        this.galleryList.ensureIndexIsVisible(n2);
        this.moveUpPhotoButton.setEnabled(true);
        this.moveDownPhotoButton.setEnabled(n + 1 < this.availableImages.size());
        this.isModified = true;
    }

    @Action
    public void doMoveUpFile() {
        if (this.selectedFile == null) {
            return;
        }
        int n = this.availableFiles.indexOf(this.selectedFile);
        if (n <= 0) {
            return;
        }
        this.fileTable.setEnabled(false);
        this.fileTable.clearSelection();
        this.fileTableModel.moveRow(n, n, n - 1);
        this.fileTable.scrollRowToVisible(n - 1);
        this.fileTable.getSelectionModel().setSelectionInterval(n - 1, n - 1);
        this.fileTable.setEnabled(true);
        EstateAttachmentImpl estateAttachmentImpl = this.availableFiles.get(n);
        EstateAttachmentImpl estateAttachmentImpl2 = this.availableFiles.get(n - 1);
        this.availableFiles.set(n - 1, estateAttachmentImpl);
        this.availableFiles.set(n, estateAttachmentImpl2);
        this.availableFiles.trimToSize();
        this.moveUpFileButton.setEnabled(n > 1);
        this.moveDownFileButton.setEnabled(true);
        this.isModified = true;
    }

    @Action
    public void doMoveUpPhoto() {
        if (this.selectedImage == null) {
            return;
        }
        int n = this.availableImages.indexOf(this.selectedImage);
        if (n <= 0) {
            return;
        }
        EstateImageItem estateImageItem = this.availableImages.get(n);
        EstateImageItem estateImageItem2 = this.availableImages.get(n - 1);
        estateImageItem.setImageIndex(n - 1);
        estateImageItem2.setImageIndex(n);
        this.availableImages.set(n - 1, estateImageItem);
        this.availableImages.set(n, estateImageItem2);
        this.availableImages.trimToSize();
        Object e = this.galleryListModel.getElementAt(n);
        Object e2 = this.galleryListModel.getElementAt(n - 1);
        this.galleryListModel.setElementAt(e, n - 1);
        this.galleryListModel.setElementAt(e2, n);
        this.galleryList.setSelectedIndex(n - 1);
        int n2 = this.galleryList.getSelectedIndex();
        if (n2 > 0) {
            --n2;
        }
        this.galleryList.ensureIndexIsVisible(n2);
        this.moveUpPhotoButton.setEnabled(n - 1 > 0);
        this.moveDownPhotoButton.setEnabled(true);
        this.isModified = true;
    }

    @Action
    public void doRemoveFile() {
        int n;
        if (this.selectedFile == null) {
            return;
        }
        int n2 = this.availableFiles.indexOf(this.selectedFile);
        if (n2 < 0) {
            return;
        }
        this.availableFiles.remove(n2);
        this.availableFiles.trimToSize();
        this.fileTable.setEnabled(false);
        int n3 = this.fileTable.getSelectedRow();
        if (n3 >= 0) {
            n = this.fileTable.convertRowIndexToModel(n3);
            this.fileTable.clearSelection();
            this.fileTableModel.removeRow(n);
        }
        this.fileTable.setEnabled(true);
        if (this.fileTableModel.getRowCount() > n3) {
            n = this.fileTable.convertRowIndexToModel(n3);
            this.fileTable.getSelectionModel().setSelectionInterval(n, n);
        } else if (this.fileTableModel.getRowCount() > 0) {
            this.fileTable.getSelectionModel().setSelectionInterval(this.fileTableModel.getRowCount() - 1, this.fileTableModel.getRowCount() - 1);
        } else {
            this.selectFile(-1);
        }
        this.isModified = true;
    }

    @Action
    public void doRemovePhoto() {
        if (this.selectedImage == null) {
            return;
        }
        int n = this.availableImages.indexOf(this.selectedImage);
        if (n < 0) {
            return;
        }
        this.availableImages.remove(n);
        this.availableImages.trimToSize();
        this.galleryListModel.removeElementAt(n);
        if (this.galleryListModel.getSize() > n) {
            this.galleryList.setSelectedIndex(n);
        } else if (this.galleryListModel.getSize() > 0) {
            this.galleryList.setSelectedIndex(this.galleryListModel.getSize() - 1);
        } else {
            this.selectImage(-1);
        }
        this.isModified = true;
    }

    @Action
    public void doRotateLeft() {
        this.isModified = true;
        this.imageView.setVisible(false);
        BufferedImage bufferedImage = (BufferedImage)this.imageView.getImage();
        BufferedImage bufferedImage2 = ImmoToolUtils.rotateImageToLeft((BufferedImage)bufferedImage, (int)2);
        this.imageView.setImage((Image)bufferedImage2);
        bufferedImage.flush();
        this.imageView.setVisible(true);
        --this.rotation;
    }

    @Action
    public void doRotateRight() {
        this.isModified = true;
        this.imageView.setVisible(false);
        BufferedImage bufferedImage = (BufferedImage)this.imageView.getImage();
        BufferedImage bufferedImage2 = ImmoToolUtils.rotateImageToRight((BufferedImage)bufferedImage, (int)2);
        this.imageView.setImage((Image)bufferedImage2);
        bufferedImage.flush();
        this.imageView.setVisible(true);
        ++this.rotation;
    }

    @Action
    public void doSaveFile() {
        if (this.selectedFile == null) {
            return;
        }
        this.saveFile();
        this.isModified = true;
    }

    @Action
    public void doSavePhoto() {
        if (this.selectedImage == null) {
            return;
        }
        this.saveImage();
        int n = this.galleryList.getSelectedIndex() + 1;
        if (n < this.galleryListModel.getSize()) {
            this.selectedImage = null;
            this.galleryList.setSelectedIndex(n);
        }
        this.isModified = true;
    }

    @Override
    public String getTitle() {
        return this.resourceMap.getString("title", new Object[0]);
    }

    @Override
    public boolean isLoadedInBackground() {
        return true;
    }

    public boolean isFormEnabled() {
        return true;
    }

    @Override
    public boolean isFormModified() {
        return this.isModified;
    }

    public boolean isFormUsable() {
        return true;
    }

    private boolean isImageMimeType(MimeType mimeType) {
        return !ImmoToolUtils.UNKNOWN_MIME_TYPE.equals((Object)mimeType) && "image".equalsIgnoreCase(mimeType.getMediaType());
    }

    @Override
    public void load(AgencyEstate agencyEstate) {
        boolean bl = agencyEstate.getId() == null || agencyEstate.getId().trim().length() == 0;
        this.selectImage(-1);
        this.galleryEstate = agencyEstate;
        for (Locale locale : this.imageTextFields.keySet()) {
            boolean bl2 = bl || agencyEstate.getLanguages().isEmpty() || agencyEstate.getLanguages().contains(locale.getLanguage());
            this.imageTextFields.get(locale).setVisible(bl2);
            this.imageTextLabels.get(locale).setVisible(bl2);
            this.fileTextFields.get(locale).setVisible(bl2);
            this.fileTextLabels.get(locale).setVisible(bl2);
        }
        this.fileTable.clearSelection();
        this.isModified = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save(AgencyEstate agencyEstate) {
        this.saveImage();
        ImmoToolApp immoToolApp = ImmoToolApp.getApplication();
        agencyEstate.getAttachments().clear();
        for (EstateImageItem estateImageItem : this.availableImages) {
            EstateAttachmentImpl estateAttachmentImpl;
            block19: {
                String exception;
                estateAttachmentImpl = new EstateAttachmentImpl();
                estateAttachmentImpl.setPublished(Boolean.valueOf(estateImageItem.isImagePublished()));
                estateAttachmentImpl.setType(estateImageItem.getImageType());
                String string = estateImageItem.getImageFormat();
                if (string == null || string.trim().length() == 0) {
                    string = AgencyPlugin.getImgDefaultFormat();
                }
                if ("PNG".equalsIgnoreCase(string)) {
                    estateAttachmentImpl.setMimeType("image/png");
                } else {
                    estateAttachmentImpl.setMimeType("image/jpeg");
                }
                for (Serializable serializable : this.imageTextFields.keySet()) {
                    exception = estateImageItem.getImageTexts().get(serializable);
                    estateAttachmentImpl.setTitle(exception, serializable.getLanguage());
                }
                if (estateImageItem.getImageResourceName() == null || estateImageItem.getImageFormat() == null || estateImageItem.isImageModified()) {
                    Serializable serializable;
                    Object object = null;
                    serializable = null;
                    try {
                        exception = string.toLowerCase();
                        while (serializable == null || ((File)serializable).exists()) {
                            serializable = new File(immoToolApp.getProject().getTempDirectory() + File.separator + System.currentTimeMillis() + "." + exception);
                        }
                        object = new FileOutputStream((File)serializable);
                        ImageIO.write((RenderedImage)((Object)estateImageItem.getImageIcon().getImage()), exception, (OutputStream)object);
                        ((OutputStream)object).flush();
                        estateAttachmentImpl.setFile(((File)serializable).toURI().toURL());
                        break block19;
                    }
                    catch (Exception exception2) {
                        LOGGER.warn((Object)"could not save temp-image!");
                        LOGGER.warn((Object)("> " + (serializable != null ? ((File)serializable).getAbsolutePath() : "NULL")));
                        LOGGER.warn((Object)("> " + exception2.getLocalizedMessage()), (Throwable)exception2);
                        continue;
                    }
                    finally {
                        try {
                            if (object == null) continue;
                            ((FileOutputStream)object).close();
                        }
                        catch (Exception exception3) {
                            LOGGER.error((Object)exception3.getLocalizedMessage(), (Throwable)exception3);
                        }
                        continue;
                    }
                }
                estateAttachmentImpl.setFile(estateImageItem.getImageResourceName());
            }
            agencyEstate.getAttachments().add(estateAttachmentImpl);
        }
        for (EstateAttachmentImpl estateAttachmentImpl : this.availableFiles) {
            agencyEstate.getAttachments().add(estateAttachmentImpl);
        }
    }

    private void saveFile() {
        if (this.selectedFile == null) {
            return;
        }
        this.selectedFile.setPublished(Boolean.valueOf(this.filePublishedBox.isSelected()));
        this.selectedFile.setType((String)this.fileTypeBox.getSelectedItem());
        for (Locale locale : this.fileTextFields.keySet()) {
            this.selectedFile.setTitle(this.fileTextFields.get(locale).getText().trim(), locale);
        }
        this.fileTable.setEnabled(false);
        int n = this.fileTable.getSelectedRow();
        if (n >= 0) {
            int n2 = this.fileTable.convertRowIndexToModel(n);
            this.fileTableModel.setFileAt(this.selectedFile, n2);
        }
        this.fileTable.setEnabled(true);
    }

    @Override
    public void saveFinished(AgencyEstate agencyEstate) throws ImmoToolException {
    }

    private void saveImage() {
        if (this.selectedImage == null) {
            return;
        }
        this.selectedImage.setImagePublished(this.imagePublishedBox.isSelected());
        this.selectedImage.setImageFormat((String)this.imageFormatBox.getSelectedItem());
        this.selectedImage.setImageType((String)this.imageTypeBox.getSelectedItem());
        for (Locale locale : this.imageTextFields.keySet()) {
            this.selectedImage.getImageTexts().put(locale, this.imageTextFields.get(locale).getText().trim());
        }
        if (this.flippedH || this.flippedV || this.rotation % 4 != 0) {
            this.selectedImage.setImage(this.imageView.getImage());
        }
    }

    private void selectFile(int n) {
        this.fileTable.setEnabled(false);
        if (n < 0) {
            this.selectedFile = null;
            this.exportFileButton.setEnabled(false);
            this.saveFileButton.setEnabled(false);
            this.removeFileButton.setEnabled(false);
            this.moveUpFileButton.setEnabled(false);
            this.moveDownFileButton.setEnabled(false);
            this.fileTypeBox.setEnabled(false);
            this.filePublishedBox.setEnabled(false);
            for (Locale locale : this.imageTextFields.keySet()) {
                this.fileTextFields.get(locale).setText("");
                this.fileTextFields.get(locale).setEnabled(false);
            }
        } else {
            this.selectedFile = this.availableFiles.get(n);
            this.exportFileButton.setEnabled(true);
            this.saveFileButton.setEnabled(true);
            this.removeFileButton.setEnabled(true);
            this.moveUpFileButton.setEnabled(n > 0);
            this.moveDownFileButton.setEnabled(n >= 0 && n + 1 < this.availableFiles.size());
            this.fileTypeBox.setSelectedItem(this.selectedFile.getType());
            this.fileTypeBox.setEnabled(true);
            this.filePublishedBox.setSelected(this.selectedFile.isPublished());
            this.filePublishedBox.setEnabled(true);
            Iterator<Locale> iterator = this.fileTextFields.keySet().iterator();
            while (iterator.hasNext()) {
                String string;
                Locale locale;
                this.fileTextFields.get(locale).setText((string = this.selectedFile.getTitle(locale = iterator.next())) != null ? string.trim() : "");
                this.fileTextFields.get(locale).setEnabled(true);
            }
        }
        this.fileTable.setEnabled(true);
    }

    private void selectImage(int n) {
        this.rotation = 0;
        this.flippedH = false;
        this.flippedV = false;
        if (n < 0) {
            this.imageFormPanel.setVisible(false);
            this.selectedImage = null;
            this.exportFileButton.setEnabled(false);
            this.imageView.setVisible(false);
            this.savePhotoButton.setEnabled(false);
            this.removePhotoButton.setEnabled(false);
            this.moveUpPhotoButton.setEnabled(false);
            this.moveDownPhotoButton.setEnabled(false);
            this.imageTypeBox.setEnabled(false);
            this.imageFormatBox.setEnabled(false);
            this.imagePublishedBox.setEnabled(false);
            for (Locale locale : this.imageTextFields.keySet()) {
                this.imageTextFields.get(locale).setText("");
                this.imageTextFields.get(locale).setEnabled(false);
            }
        } else {
            this.selectedImage = this.availableImages.get(n);
            this.exportFileButton.setEnabled(true);
            this.savePhotoButton.setEnabled(true);
            this.removePhotoButton.setEnabled(true);
            this.moveUpPhotoButton.setEnabled(n > 0);
            this.moveDownPhotoButton.setEnabled(n >= 0 && n + 1 < this.availableImages.size());
            this.imageTypeBox.setSelectedItem(this.selectedImage.getImageType());
            this.imageTypeBox.setEnabled(true);
            this.imagePublishedBox.setSelected(this.selectedImage.isImagePublished());
            this.imagePublishedBox.setEnabled(true);
            if (AgencyPlugin.isImgFormatForced()) {
                this.imageFormatBox.setSelectedItem(AgencyPlugin.getImgDefaultFormat());
                this.imageFormatBox.setEnabled(false);
            } else {
                this.imageFormatBox.setSelectedItem(this.selectedImage.getImageFormat() != null ? this.selectedImage.getImageFormat() : AgencyPlugin.getImgDefaultFormat());
                this.imageFormatBox.setEnabled(true);
            }
            for (Locale locale : this.imageTextFields.keySet()) {
                String string;
                this.imageTextFields.get(locale).setText((string = this.selectedImage.getImageTexts().get(locale)) != null ? string.trim() : "");
                this.imageTextFields.get(locale).setEnabled(true);
            }
            this.imageView.setVisible(false);
            this.imageView.setImage(this.selectedImage.getImageIcon().getImage());
            this.imageView.setVisible(true);
            this.imageFormPanel.setVisible(true);
        }
    }

    @Override
    public void selectLanguage(Locale locale, boolean bl) {
        if (this.fileTextFields.containsKey(locale)) {
            this.fileTextFields.get(locale).setVisible(bl);
        }
        if (this.fileTextLabels.containsKey(locale)) {
            this.fileTextLabels.get(locale).setVisible(bl);
        }
        if (this.imageTextFields.containsKey(locale)) {
            this.imageTextFields.get(locale).setVisible(bl);
        }
        if (this.imageTextLabels.containsKey(locale)) {
            this.imageTextLabels.get(locale).setVisible(bl);
        }
    }

    private static class FileTableModel
    extends DefaultTableModel {
        public static final int COLUMN_NAME = 0;
        public static final int COLUMN_TEXT = 1;
        public static final int COLUMN_FORMAT = 2;
        public static final int COLUMN_TYPE = 3;
        public static final int COLUMN_PUBLISHED = 4;
        private static final Map<Integer, String> COLUMN_NAMES = new HashMap<Integer, String>();
        private static final Map<Integer, Class> COLUMN_CLASSES;
        private ResourceMap resourceMap;

        public FileTableModel() {
            this.setColumnCount(COLUMN_NAMES.size());
            this.resourceMap = ImmoToolUtils.getResourceMap(AgencyEstateViewMediaPanel.class);
        }

        public void addFile(EstateAttachmentImpl estateAttachmentImpl) {
            this.addRow(this.buildRow(estateAttachmentImpl));
        }

        private Object[] buildRow(EstateAttachmentImpl estateAttachmentImpl) {
            TreeMap<Integer, Object> treeMap = new TreeMap<Integer, Object>();
            if (estateAttachmentImpl.isName()) {
                treeMap.put(0, estateAttachmentImpl.getFileAsName());
            } else if (estateAttachmentImpl.isUrl()) {
                treeMap.put(0, estateAttachmentImpl.getFileAsUrl().getFile());
            } else {
                treeMap.put(0, null);
            }
            treeMap.put(2, estateAttachmentImpl.getMimeType());
            treeMap.put(4, estateAttachmentImpl.isPublished());
            treeMap.put(1, estateAttachmentImpl.getTitle(Locale.getDefault()));
            treeMap.put(3, estateAttachmentImpl.getType() != null ? OpenEstateUtils.translateAttachment((String)estateAttachmentImpl.getType(), (Locale)Locale.getDefault()) : null);
            return treeMap.values().toArray(new Object[treeMap.size()]);
        }

        public void clear() {
            while (this.getRowCount() > 0) {
                this.removeRow(0);
            }
        }

        public Class getColumnClass(int n) {
            return COLUMN_CLASSES.containsKey(n) ? COLUMN_CLASSES.get(n) : null;
        }

        @Override
        public String getColumnName(int n) {
            return COLUMN_NAMES.containsKey(n) ? this.resourceMap.getString(COLUMN_NAMES.get(n), new Object[0]) : null;
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public void setFileAt(EstateAttachmentImpl estateAttachmentImpl, int n) {
            Object[] objectArray = this.buildRow(estateAttachmentImpl);
            for (int i = 0; i < objectArray.length; ++i) {
                this.setValueAt(objectArray[i], n, i);
            }
        }

        static {
            COLUMN_NAMES.put(0, "col.file.name");
            COLUMN_NAMES.put(1, "col.file.text");
            COLUMN_NAMES.put(2, "col.file.format");
            COLUMN_NAMES.put(3, "col.file.type");
            COLUMN_NAMES.put(4, "col.file.published");
            COLUMN_CLASSES = new HashMap<Integer, Class>();
            COLUMN_CLASSES.put(0, String.class);
            COLUMN_CLASSES.put(1, String.class);
            COLUMN_CLASSES.put(2, String.class);
            COLUMN_CLASSES.put(3, String.class);
            COLUMN_CLASSES.put(4, Boolean.class);
        }
    }

    private static class FileTypeRenderer
    extends JLabel
    implements ListCellRenderer {
        private String emptyValue;

        public FileTypeRenderer(String string) {
            this.emptyValue = string;
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            this.setBackground(bl ? jList.getSelectionBackground() : jList.getBackground());
            this.setForeground(bl ? jList.getSelectionForeground() : jList.getForeground());
            if (object instanceof String) {
                String string = (String)object;
                this.setText(" " + OpenEstateUtils.translateAttachment((String)string));
            } else {
                this.setText(" [ " + this.emptyValue + " ]");
            }
            return this;
        }
    }

    private final class ImageFormatRenderer
    extends JLabel
    implements ListCellRenderer {
        public ImageFormatRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            this.setBackground(bl ? jList.getSelectionBackground() : jList.getBackground());
            this.setForeground(bl ? jList.getSelectionForeground() : jList.getForeground());
            if (object instanceof String) {
                String string = (String)object;
                this.setText(" " + string);
            } else {
                this.setText(" [ " + AgencyEstateViewMediaPanel.this.resourceMap.getString("label.imageFormat.empty", new Object[0]) + " ]");
            }
            return this;
        }
    }

    private final class ExtendedJImageFileChooser
    extends JImageFileChooser {
        private JCheckBox importWithNamesBox = new JCheckBox();

        protected JDialog createDialog(Component component) throws HeadlessException {
            JDialog jDialog = super.createDialog(component);
            this.importWithNamesBox.setSelected(false);
            this.importWithNamesBox.setBorder(BorderFactory.createEmptyBorder(5, 5, 0, 0));
            this.importWithNamesBox.setText(AgencyEstateViewMediaPanel.this.resourceMap.getString("label.importOptions.titleFromFile", new Object[0]));
            JPanel jPanel = new JPanel();
            jPanel.setBorder(BorderFactory.createEmptyBorder(0, 10, 10, 10));
            jPanel.setLayout(new GridLayout(2, 1));
            jPanel.add((Component)ImmoToolUtils.createHead2Separator((String)AgencyEstateViewMediaPanel.this.resourceMap.getString("label.importOptions", new Object[0])));
            jPanel.add(this.importWithNamesBox);
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout(new BorderLayout());
            jPanel2.add((Component)jDialog.getRootPane().getContentPane(), "Center");
            jPanel2.add((Component)jPanel, "South");
            jDialog.getRootPane().setContentPane(jPanel2);
            jDialog.getRootPane().revalidate();
            jDialog.getRootPane().repaint();
            jDialog.setSize(jDialog.getSize().width, jDialog.getSize().height + 50);
            return jDialog;
        }

        public boolean isImportWithNames() {
            return this.importWithNamesBox.isSelected();
        }
    }

    private final class GalleryListDropListener
    implements DropTargetListener {
        @Override
        public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        }

        @Override
        public void dragExit(DropTargetEvent dropTargetEvent) {
        }

        @Override
        public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        }

        @Override
        public void drop(DropTargetDropEvent dropTargetDropEvent) {
            try {
                Integer n = AgencyEstateViewMediaPanel.this.galleryList.locationToIndex(dropTargetDropEvent.getLocation());
                if (n == null) {
                    throw new Exception("empty destination-index!");
                }
                if (n < 0) {
                    throw new Exception("invalid destination-index!");
                }
                Transferable transferable = dropTargetDropEvent.getTransferable();
                DataFlavor[] dataFlavorArray = transferable.getTransferDataFlavors();
                for (int i = 0; i < dataFlavorArray.length; ++i) {
                    Object object;
                    if (!dataFlavorArray[i].isFlavorSerializedObjectType() || !((object = transferable.getTransferData(dataFlavorArray[i])) instanceof Integer)) continue;
                    Integer n2 = null;
                    try {
                        n2 = (Integer)transferable.getTransferData(dataFlavorArray[i]);
                        if (n2 == null) {
                            throw new Exception("unknown index!");
                        }
                        if (n2 < 0) {
                            throw new Exception("invalid index: " + n2);
                        }
                    }
                    catch (Exception exception) {
                        LOGGER.warn((Object)"COULD NOT LOAD DROPPED TRANSFERABLE!");
                        LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
                        continue;
                    }
                    if (n2.intValue() == n.intValue()) {
                        dropTargetDropEvent.dropComplete(false);
                        return;
                    }
                    dropTargetDropEvent.acceptDrop(dropTargetDropEvent.getDropAction());
                    EstateImageItem estateImageItem = (EstateImageItem)AgencyEstateViewMediaPanel.this.availableImages.get(n2);
                    if (!AgencyEstateViewMediaPanel.this.availableImages.remove(estateImageItem)) {
                        throw new Exception("could not remove source-object!");
                    }
                    AgencyEstateViewMediaPanel.this.availableImages.add(n, estateImageItem);
                    AgencyEstateViewMediaPanel.this.availableImages.trimToSize();
                    int n3 = 0;
                    AgencyEstateViewMediaPanel.this.galleryListModel.clear();
                    for (EstateImageItem estateImageItem2 : AgencyEstateViewMediaPanel.this.availableImages) {
                        estateImageItem2.setImageIndex(n3++);
                        AgencyEstateViewMediaPanel.this.galleryListModel.addElement(estateImageItem2.getImageListIcon());
                    }
                    dropTargetDropEvent.dropComplete(true);
                    AgencyEstateViewMediaPanel.this.galleryList.setSelectedIndex(n.intValue());
                    AgencyEstateViewMediaPanel.this.isModified = true;
                    return;
                }
            }
            catch (Throwable throwable) {
                LOGGER.error((Object)"TARGET-DROP-ERROR!");
                LOGGER.error((Object)("> " + throwable.getLocalizedMessage()), throwable);
            }
            dropTargetDropEvent.dropComplete(false);
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
        }
    }

    private final class GalleryListDragListener
    implements DragGestureListener {
        private GalleryListDragListener() {
        }

        @Override
        public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
            int n = AgencyEstateViewMediaPanel.this.galleryList.locationToIndex(dragGestureEvent.getDragOrigin());
            if (n < 0) {
                return;
            }
            Transferable transferable = (Transferable)AgencyEstateViewMediaPanel.this.availableImages.get(n);
            dragGestureEvent.startDrag(null, transferable);
        }
    }

    private static class EstateImageItem
    implements JImageList.Item,
    Transferable {
        private int imageIndex = 0;
        private String imageResourceName = null;
        private String imageFormat = null;
        private Map<Locale, String> imageTexts = null;
        private boolean imageModified = false;
        private boolean imagePublished = false;
        private String imageType = null;
        private ImageIcon imageIcon = null;
        private ImageIcon previewIcon = null;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public EstateImageItem(int n, BufferedImage bufferedImage, String string, String string2, String string3, boolean bl) throws IOException, XMLDBException {
            ByteArrayInputStream byteArrayInputStream = null;
            Object var8_8 = null;
            try {
                if (bufferedImage == null) {
                    throw new RuntimeException("Can't load image!");
                }
                this.imageIcon = new ImageIcon(bufferedImage);
                this.imageIndex = n;
                this.imageResourceName = string;
                this.imageTexts = new HashMap<Locale, String>();
                this.imagePublished = bl;
                this.imageType = string2;
                this.imageFormat = string3;
                this.imageModified = false;
            }
            finally {
                if (byteArrayInputStream != null) {
                    byteArrayInputStream.close();
                }
            }
        }

        public EstateImageItem(int n, File file) throws IOException {
            BufferedImage bufferedImage = ImageIO.read(file);
            int n2 = AgencyPlugin.getImgMaxWidth();
            int n3 = AgencyPlugin.getImgMaxHeight();
            if (bufferedImage.getHeight(null) > n3 || bufferedImage.getWidth(null) > n2) {
                BufferedImage bufferedImage2 = ImmoToolUtils.scaleImageAndKeepRatio((BufferedImage)bufferedImage, (int)n2, (int)n3);
                bufferedImage.flush();
                bufferedImage = bufferedImage2;
            }
            this.imageIcon = new ImageIcon(bufferedImage);
            this.imageIndex = n;
            this.imageResourceName = null;
            this.imageTexts = new HashMap<Locale, String>();
            this.imageModified = true;
        }

        public String getImageFormat() {
            return this.imageFormat;
        }

        public ImageIcon getImageIcon() {
            return this.imageIcon;
        }

        public int getImageIndex() {
            return this.imageIndex;
        }

        public ImageIcon getImageListIcon() {
            if (this.previewIcon == null) {
                this.previewIcon = new ImageIcon(ImmoToolUtils.scaleImageAndKeepRatio((BufferedImage)((BufferedImage)this.imageIcon.getImage()), (int)100, (int)75));
            }
            return this.previewIcon;
        }

        public String getImageResourceName() {
            return this.imageResourceName;
        }

        public String getImageText(Locale locale) {
            return this.imageTexts.containsKey(locale) ? this.imageTexts.get(locale) : "";
        }

        public Map<Locale, String> getImageTexts() {
            return this.imageTexts;
        }

        public String getImageType() {
            return this.imageType;
        }

        @Override
        public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
            return this.imageIndex;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[]{DataFlavor.stringFlavor};
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
            return DataFlavor.stringFlavor.equals(dataFlavor);
        }

        public boolean isImageModified() {
            return this.imageModified;
        }

        public boolean isImagePublished() {
            return this.imagePublished;
        }

        public void setImage(Image image) {
            this.imageModified = true;
            this.imageIcon.setImage(image);
            this.getImageListIcon().setImage(ImmoToolUtils.scaleImageAndKeepRatio((BufferedImage)((BufferedImage)this.imageIcon.getImage()), (int)100, (int)75));
        }

        public void setImageIndex(int n) {
            this.imageIndex = n;
        }

        public void setImageFormat(String string) {
            this.imageModified = this.imageModified || this.imageFormat == null || !this.imageFormat.equalsIgnoreCase(string);
            this.imageFormat = string;
        }

        public void setImagePublished(boolean bl) {
            this.imagePublished = bl;
        }

        public void setImageType(String string) {
            this.imageType = string;
        }
    }
}

