/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency;

import com.openindex.openestate.impl.OpenEstateUtils;
import com.openindex.openestate.tool.ImmoToolApp;
import com.openindex.openestate.tool.ImmoToolDbException;
import com.openindex.openestate.tool.ImmoToolDbUtils;
import com.openindex.openestate.tool.ImmoToolTabPanel;
import com.openindex.openestate.tool.ImmoToolTask;
import com.openindex.openestate.tool.ImmoToolTaskDialog;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.agency.AgencyContact;
import com.openindex.openestate.tool.agency.AgencyEstate;
import com.openindex.openestate.tool.agency.AgencyEstateViewAddonPanel;
import com.openindex.openestate.tool.agency.AgencyEstateViewContactPanel;
import com.openindex.openestate.tool.agency.AgencyEstateViewExportsPanel;
import com.openindex.openestate.tool.agency.AgencyEstateViewMediaPanel;
import com.openindex.openestate.tool.agency.AgencyEstateViewSetupPanel;
import com.openindex.openestate.tool.agency.AgencyEstateViewValuesPanel;
import com.openindex.openestate.tool.agency.AgencyExportInterface;
import com.openindex.openestate.tool.agency.AgencyExportList;
import com.openindex.openestate.tool.agency.AgencyExportSummary;
import com.openindex.openestate.tool.agency.AgencyExportSummaryDialog;
import com.openindex.openestate.tool.agency.AgencyExportTask;
import com.openindex.openestate.tool.agency.AgencyExposeTask;
import com.openindex.openestate.tool.agency.AgencyPluginUtils;
import com.openindex.openestate.tool.agency.export.LocalTransport;
import com.openindex.openestate.tool.utils.ModificationHandler;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.print.Printable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.TreeMap;
import javax.swing.AbstractButton;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.SystemUtils;
import org.apache.log4j.Logger;
import org.fife.ui.rtextarea.RTextArea;
import org.jdesktop.application.Action;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationActionMap;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.application.Task;
import org.jdesktop.application.TaskEvent;
import org.jdesktop.application.TaskListener;
import org.jdesktop.swingx.JXTitledSeparator;
import org.w3c.dom.Node;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.ResourceSet;
import org.xmldb.api.modules.XMLResource;

public class AgencyEstateViewPanel
extends ImmoToolTabPanel {
    private static final Logger LOGGER = Logger.getLogger(AgencyEstateViewPanel.class);
    private ActionMap actionMap;
    private ResourceMap resourceMap;
    private AgencyEstate modifiedEstate = null;
    private boolean newEstate = false;
    private long nextEstateId = 0L;
    private long prevEstateId = 0L;
    private int tabPosition = 0;
    private ModificationHandler modifications = null;
    private int runningBackgroundTaskCount = 0;
    private JPopupMenu estateActionMenu;
    private RTextArea estateNotesField;
    private AgencyEstateViewSetupPanel estateSetupPanel;
    private AgencyEstateViewValuesPanel estateValuesPanel;
    private AgencyEstateViewMediaPanel estateGalleryPanel;
    private AgencyEstateViewContactPanel estateContactPanel;
    private AgencyEstateViewExportsPanel estateExportsPanel;
    private List<AgencyEstateViewAddonPanel> estateAddonPanels;
    private JMenuItem estateActionPdfItem;
    private JMenu estateActionExportMenu;
    private JMenu estateActionSaveMenu;
    private JButton actionButton;
    private JButton closeButton;
    private JButton helpButton;
    private JButton nextButton;
    private JButton prevButton;
    private JButton submitButton;
    private JTabbedPane tabPanel;
    private JXTitledSeparator titleLabel;

    public AgencyEstateViewPanel() {
        this(null);
    }

    public AgencyEstateViewPanel(AgencyEstate agencyEstate) {
        this.build();
        this.newEstate = agencyEstate == null;
        this.setEstate(this.newEstate ? new AgencyEstate() : agencyEstate);
    }

    private void build() {
        this.modifications = ImmoToolUtils.createModificationHandler();
        this.actionMap = ImmoToolUtils.getActionMap(AgencyEstateViewPanel.class, (Object)((Object)this));
        this.resourceMap = ImmoToolUtils.getResourceMap(AgencyEstateViewPanel.class);
        this.initComponents();
        this.resourceMap.injectComponents((Component)((Object)this));
        this.estateSetupPanel = new AgencyEstateViewSetupPanel(this);
        this.estateValuesPanel = new AgencyEstateViewValuesPanel();
        this.estateGalleryPanel = new AgencyEstateViewMediaPanel();
        this.estateContactPanel = new AgencyEstateViewContactPanel();
        this.estateExportsPanel = new AgencyEstateViewExportsPanel();
        this.tabPanel.addTab(this.estateSetupPanel.getTitle(), (Component)((Object)this.estateSetupPanel));
        this.tabPanel.addTab(this.estateValuesPanel.getTitle(), (Component)((Object)this.estateValuesPanel));
        this.tabPanel.addTab(this.estateGalleryPanel.getTitle(), (Component)((Object)this.estateGalleryPanel));
        this.tabPanel.addTab(this.estateContactPanel.getTitle(), (Component)((Object)this.estateContactPanel));
        this.tabPanel.addTab(this.estateExportsPanel.getTitle(), (Component)((Object)this.estateExportsPanel));
        this.estateAddonPanels = new ArrayList<AgencyEstateViewAddonPanel>();
        try {
            for (AgencyEstateViewAddonPanel agencyEstateViewAddonPanel : AgencyEstateViewAddonPanel.getUsablePanels()) {
                this.estateAddonPanels.add(agencyEstateViewAddonPanel);
                this.tabPanel.addTab(agencyEstateViewAddonPanel.getTitle(), (Component)((Object)agencyEstateViewAddonPanel));
            }
        }
        catch (Exception exception) {
            LOGGER.warn((Object)"could not load addon-panels!");
            LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
        }
        this.tabPanel.add(this.resourceMap.getString("notesTab", new Object[0]), this.buildDescriptionPanel());
        for (int i = 0; i < this.tabPanel.getTabCount(); ++i) {
            if (!(this.tabPanel.getComponentAt(i) instanceof AgencyEstateViewAddonPanel)) continue;
            this.tabPanel.setEnabledAt(i, false);
        }
        this.estateActionMenu = new JPopupMenu();
        this.estateActionMenu.setName("estateActionMenu");
        this.estateActionMenu.add(new JMenuItem(this.actionMap.get("doCopy")));
        this.estateActionMenu.add(new JMenuItem(this.actionMap.get("doRemove")));
        this.estateActionMenu.addSeparator();
        this.estateActionPdfItem = new JMenuItem(this.actionMap.get("doCreateExpose"));
        this.estateActionExportMenu = new JMenu();
        this.estateActionExportMenu.setName("estateActionExportMenu");
        this.estateActionSaveMenu = new JMenu();
        this.estateActionSaveMenu.setName("estateActionSaveMenu");
        this.estateActionMenu.add(this.estateActionPdfItem);
        this.estateActionMenu.add(this.estateActionExportMenu);
        this.estateActionMenu.add(this.estateActionSaveMenu);
        this.estateActionMenu.addSeparator();
        this.estateActionMenu.add(new JMenuItem(this.actionMap.get("doPrintNotes")));
        this.resourceMap.injectComponents((Component)this.estateActionMenu);
        this.getActionMap().put("doViewNext", this.actionMap.get("doViewNext"));
        this.getInputMap().put(KeyStroke.getKeyStroke("alt pressed PAGE_UP"), "doViewNext");
        this.getInputMap().put(KeyStroke.getKeyStroke("ctrl pressed RIGHT"), "doViewNext");
        this.getActionMap().put("doViewPrevious", this.actionMap.get("doViewPrevious"));
        this.getInputMap().put(KeyStroke.getKeyStroke("alt pressed PAGE_DOWN"), "doViewPrevious");
        this.getInputMap().put(KeyStroke.getKeyStroke("ctrl pressed LEFT"), "doViewPrevious");
        this.tabPanel.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                int n = AgencyEstateViewPanel.this.tabPanel.getSelectedIndex();
                if (AgencyEstateViewPanel.this.tabPosition == n) {
                    return;
                }
                boolean bl = false;
                if (AgencyEstateViewPanel.this.tabPosition == 0) {
                    AgencyEstateViewPanel.this.estateSetupPanel.validateForm();
                    bl = AgencyEstateViewPanel.this.estateSetupPanel.isFormValid();
                } else if (AgencyEstateViewPanel.this.tabPosition == 1) {
                    AgencyEstateViewPanel.this.estateValuesPanel.validateForm();
                    bl = AgencyEstateViewPanel.this.estateValuesPanel.isFormValid();
                } else if (AgencyEstateViewPanel.this.tabPosition == 2) {
                    AgencyEstateViewPanel.this.estateGalleryPanel.validateForm();
                    bl = AgencyEstateViewPanel.this.estateGalleryPanel.isFormValid();
                } else if (AgencyEstateViewPanel.this.tabPosition == 3) {
                    AgencyEstateViewPanel.this.estateContactPanel.validateForm();
                    bl = AgencyEstateViewPanel.this.estateContactPanel.isFormValid();
                } else if (AgencyEstateViewPanel.this.tabPosition == 4) {
                    bl = true;
                } else if (AgencyEstateViewPanel.this.tabPosition == AgencyEstateViewPanel.this.tabPanel.getTabCount() - 1) {
                    bl = true;
                } else if (AgencyEstateViewPanel.this.tabPosition > 4) {
                    int n2 = AgencyEstateViewPanel.this.tabPosition - 5;
                    if (AgencyEstateViewPanel.this.estateAddonPanels.size() > n2) {
                        ((AgencyEstateViewAddonPanel)((Object)AgencyEstateViewPanel.this.estateAddonPanels.get(n2))).validateForm();
                        bl = ((AgencyEstateViewAddonPanel)((Object)AgencyEstateViewPanel.this.estateAddonPanels.get(n2))).isFormValid();
                    }
                }
                if (!bl) {
                    AgencyEstateViewPanel.this.tabPanel.setSelectedIndex(AgencyEstateViewPanel.this.tabPosition);
                    ImmoToolUtils.showMessageErrorDialog((String)AgencyEstateViewPanel.this.resourceMap.getString("error.activeTabIsInvalid", new Object[0]), (Component)AgencyEstateViewPanel.this.tabPanel);
                    return;
                }
                AgencyEstateViewPanel.this.tabPosition = n;
            }
        });
        if (SystemUtils.IS_OS_MAC_OSX) {
            this.tabPanel.setTabPlacement(1);
        }
    }

    private JPanel buildDescriptionPanel() {
        JXTitledSeparator jXTitledSeparator = ImmoToolUtils.createHead2Separator((String)this.resourceMap.getString("notesTitle", new Object[0]));
        jXTitledSeparator.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0));
        this.estateNotesField = new RTextArea();
        this.estateNotesField.setName("estateNotesField");
        this.estateNotesField.setLineWrap(true);
        this.estateNotesField.setWrapStyleWord(true);
        if (this.estateNotesField.getPopupMenu() != null) {
            this.estateNotesField.getPopupMenu().add(new JMenuItem(this.actionMap.get("doPrintNotes")));
        }
        JScrollPane jScrollPane = new JScrollPane((Component)this.estateNotesField);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(11, 13, 11, 13));
        jPanel.add((Component)jXTitledSeparator, "North");
        jPanel.add((Component)jScrollPane, "Center");
        jPanel.revalidate();
        jPanel.repaint();
        return jPanel;
    }

    private void doExport(long l, boolean bl) {
        AgencyExportInterface agencyExportInterface;
        if (this.modifiedEstate == null || this.newEstate) {
            return;
        }
        AgencyExportTask agencyExportTask = null;
        try {
            agencyExportInterface = AgencyExportInterface.loadExportInterface(l);
            if (agencyExportInterface == null) {
                throw new Exception(this.resourceMap.getString("error.cantLoadExportSetup", new Object[]{l}));
            }
            ArrayList<AgencyEstate> arrayList = new ArrayList<AgencyEstate>();
            arrayList.add(this.modifiedEstate);
            AgencyExportSummary agencyExportSummary = AgencyExportSummary.buildSummary(agencyExportInterface, arrayList);
            if (agencyExportSummary.getUpdatedEstateIds().isEmpty() && agencyExportSummary.getRemovedEstateIds().isEmpty()) {
                if (agencyExportInterface.getLimit() > 0L) {
                    ImmoToolUtils.showMessageInfoDialog((String)this.resourceMap.getString("message.noExportableEstatesFound.limited", new Object[]{agencyExportInterface.getLimit()}));
                } else {
                    ImmoToolUtils.showMessageInfoDialog((String)this.resourceMap.getString("message.noExportableEstatesFound", new Object[0]));
                }
                return;
            }
            if (bl) {
                JFileChooser jFileChooser = new JFileChooser();
                jFileChooser.setDialogTitle(this.resourceMap.getString("message.selectExportDir", new Object[0]));
                jFileChooser.setFileSelectionMode(1);
                int n = jFileChooser.showSaveDialog((Component)((Object)this));
                if (n != 0) {
                    return;
                }
                LocalTransport localTransport = new LocalTransport();
                localTransport.setLocalDirectory(jFileChooser.getSelectedFile());
                agencyExportInterface.setTransport(localTransport);
                agencyExportInterface.setLimit(0L);
            } else {
                AgencyExportSummaryDialog agencyExportSummaryDialog = new AgencyExportSummaryDialog();
                agencyExportSummaryDialog.addExport(agencyExportSummary, agencyExportInterface);
                agencyExportSummaryDialog.finishTable();
                agencyExportSummaryDialog.setVisible(true);
                if (agencyExportSummaryDialog.getStatus() != 2) {
                    return;
                }
                agencyExportSummary = agencyExportSummaryDialog.getSummary(agencyExportInterface.getId());
            }
            agencyExportTask = new AgencyExportTask(agencyExportInterface, agencyExportSummary, !bl){

                @Override
                protected void failed(Throwable throwable) {
                    super.failed(throwable);
                    ImmoToolUtils.showMessageErrorDialog((String)AgencyEstateViewPanel.this.resourceMap.getString("error.cantExportEstates", new Object[0]), (Throwable)throwable);
                }

                protected void finished() {
                    super.finished();
                    AgencyEstateViewPanel.this.setButtonsEnabled(true);
                }

                @Override
                protected void succeeded(AgencyExportSummary agencyExportSummary) {
                    super.succeeded(agencyExportSummary);
                    if (agencyExportSummary.isSuccessful()) {
                        ImmoToolUtils.showMessageInfoDialog((String)AgencyEstateViewPanel.this.resourceMap.getString("message.estatesExported", new Object[0]));
                    } else {
                        ImmoToolUtils.showMessageInfoDialog((String)AgencyEstateViewPanel.this.resourceMap.getString("error.cantExportEstates", new Object[0]));
                    }
                }
            };
        }
        catch (Exception exception) {
            LOGGER.error((Object)"estate-export-error!");
            LOGGER.error((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
            ImmoToolUtils.showMessageErrorDialog((String)this.resourceMap.getString("error.cantExportEstates", new Object[0]), (Throwable)exception);
            return;
        }
        this.setButtonsEnabled(false);
        agencyExportInterface = new ImmoToolTaskDialog();
        agencyExportInterface.addTask(agencyExportTask);
        agencyExportInterface.execute();
    }

    public void executeFormTasks() {
        final AgencyEstateViewPanel agencyEstateViewPanel = this;
        this.runningBackgroundTaskCount = 0;
        for (int i = 0; i < this.tabPanel.getTabCount(); ++i) {
            AgencyEstateViewAddonPanel agencyEstateViewAddonPanel;
            if (!(this.tabPanel.getComponentAt(i) instanceof AgencyEstateViewAddonPanel) || !(agencyEstateViewAddonPanel = (AgencyEstateViewAddonPanel)((Object)this.tabPanel.getComponentAt(i))).isLoadedInBackground()) continue;
            Task task = agencyEstateViewAddonPanel.doLoadInBackground();
            if (task == null) {
                this.tabPanel.setEnabledAt(i, agencyEstateViewAddonPanel.isFormEnabled());
                continue;
            }
            final int n = i;
            task.addTaskListener(new TaskListener(){

                public void doInBackground(TaskEvent taskEvent) {
                }

                public void process(TaskEvent taskEvent) {
                }

                public void succeeded(TaskEvent taskEvent) {
                    AgencyEstateViewPanel.this.tabPanel.setEnabledAt(n, agencyEstateViewAddonPanel.isFormEnabled());
                }

                public void failed(TaskEvent taskEvent) {
                }

                public void cancelled(TaskEvent taskEvent) {
                }

                public void interrupted(TaskEvent taskEvent) {
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void finished(TaskEvent taskEvent) {
                    AgencyEstateViewPanel agencyEstateViewPanel2 = agencyEstateViewPanel;
                    synchronized (agencyEstateViewPanel2) {
                        agencyEstateViewPanel.runningBackgroundTaskCount--;
                        if (agencyEstateViewPanel.runningBackgroundTaskCount <= 0) {
                            AgencyEstateViewPanel.this.setButtonsEnabled(true);
                        }
                    }
                }
            });
            this.setButtonsEnabled(false);
            ++agencyEstateViewPanel.runningBackgroundTaskCount;
            ImmoToolUtils.executeTask((Task)task);
        }
        if (this.runningBackgroundTaskCount <= 0) {
            this.setButtonsEnabled(true);
        }
    }

    public static String getInstanceTabTitle(Long l, String string) {
        if (l == null || l <= 0L) {
            return ImmoToolUtils.getResourceMap(AgencyEstateViewPanel.class).getString("tabTitle.new", new Object[0]);
        }
        if (string != null && string.trim().length() > 0) {
            return ImmoToolUtils.getResourceMap(AgencyEstateViewPanel.class).getString("tabTitle.editNr", new Object[]{string.trim()});
        }
        return ImmoToolUtils.getResourceMap(AgencyEstateViewPanel.class).getString("tabTitle.edit", new Object[]{l});
    }

    public String getTabInfo() {
        if (this.newEstate || this.modifiedEstate == null) {
            return this.resourceMap.getString("tabInfo.new", new Object[0]);
        }
        String string = "";
        string = string + "<i>" + OpenEstateUtils.translateEstate((String)this.modifiedEstate.getType().getName()) + " / " + OpenEstateUtils.translateAction((String)this.modifiedEstate.getAction()) + "</i>";
        string = string + "<br><i>" + this.modifiedEstate.writeStatus() + "</i>";
        string = string + "<hr>" + this.modifiedEstate.getAdress().writeFullAdress("<br>");
        return string;
    }

    public boolean isTabModified() {
        if (this.modifications.isModified()) {
            return true;
        }
        for (int i = 0; i < this.tabPanel.getTabCount(); ++i) {
            AgencyEstateViewAddonPanel agencyEstateViewAddonPanel;
            if (!(this.tabPanel.getComponentAt(i) instanceof AgencyEstateViewAddonPanel) || !(agencyEstateViewAddonPanel = (AgencyEstateViewAddonPanel)((Object)this.tabPanel.getComponentAt(i))).isFormModified()) continue;
            return true;
        }
        return false;
    }

    public String getTabTitle() {
        return !this.newEstate && this.modifiedEstate != null ? AgencyEstateViewPanel.getInstanceTabTitle(this.modifiedEstate.getIdNr(), this.modifiedEstate.getPublicId()) : AgencyEstateViewPanel.getInstanceTabTitle(null, null);
    }

    private void refreshActionExportMenu() throws ImmoToolDbException {
        Object object;
        Object object2;
        this.estateActionExportMenu.removeAll();
        this.estateActionSaveMenu.removeAll();
        TreeMap<String, AgencyExportInterface> treeMap = new TreeMap<String, AgencyExportInterface>();
        for (AgencyExportInterface agencyExportInterface : AgencyExportInterface.loadExportInterfaces()) {
            object = object2 = agencyExportInterface.getTitle().toLowerCase().trim();
            int n = 0;
            while (treeMap.containsKey(object)) {
                object = (String)object2 + "_" + ++n;
            }
            treeMap.put((String)object, agencyExportInterface);
        }
        for (AgencyExportInterface agencyExportInterface : treeMap.values()) {
            if (!agencyExportInterface.isActive()) continue;
            final long l = agencyExportInterface.getId();
            object2 = new JMenuItem(agencyExportInterface.getTitle());
            ((Component)object2).setName("exportItem");
            ((AbstractButton)object2).addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    AgencyEstateViewPanel.this.doExport(l, false);
                }
            });
            this.estateActionExportMenu.add((JMenuItem)object2);
            object = new JMenuItem(agencyExportInterface.getTitle());
            ((Component)object).setName("saveItem");
            ((AbstractButton)object).addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    AgencyEstateViewPanel.this.doExport(l, true);
                }
            });
            this.estateActionSaveMenu.add((JMenuItem)object);
        }
        this.estateActionExportMenu.setEnabled(this.estateActionExportMenu.getItemCount() > 0);
        this.estateActionSaveMenu.setEnabled(this.estateActionSaveMenu.getItemCount() > 0);
    }

    public void refreshTab() {
        this.estateActionExportMenu.setEnabled(false);
        this.estateActionSaveMenu.setEnabled(false);
        ImmoToolUtils.executeTask((Task)new ImmoToolTask<Boolean>(){

            protected Boolean executeTask() throws Exception {
                AgencyEstateViewPanel.this.refreshActionExportMenu();
                return true;
            }
        });
        if (this.newEstate || this.modifiedEstate == null) {
            ImmoToolTask<Boolean> immoToolTask = new ImmoToolTask<Boolean>(){

                protected Boolean executeTask() throws Exception {
                    AgencyEstate agencyEstate = AgencyEstate.loadEstate(AgencyEstateViewPanel.this.modifiedEstate.getIdNr());
                    if (agencyEstate == null) {
                        throw new Exception(AgencyEstateViewPanel.this.resourceMap.getString("error.cantFindEstate", new Object[]{AgencyEstateViewPanel.this.modifiedEstate.getIdNr()}));
                    }
                    AgencyEstateViewPanel.this.setEstate(agencyEstate);
                    return true;
                }

                protected void failed(Throwable throwable) {
                    super.failed(throwable);
                    AgencyEstateViewPanel.this.setButtonsEnabled(true);
                    ImmoToolUtils.showMessageErrorDialog((String)AgencyEstateViewPanel.this.resourceMap.getString("error.cantRefreshTab", new Object[0]), (Throwable)throwable);
                }

                protected void finished() {
                }

                protected void succeeded(Boolean bl) {
                    super.succeeded((Object)bl);
                    AgencyEstateViewPanel.this.executeFormTasks();
                }
            };
            this.setButtonsEnabled(false);
            ImmoToolUtils.executeTask((Task)immoToolTask);
        }
    }

    public ImmoToolTask saveModifications() {
        return (ImmoToolTask)this.doSubmit();
    }

    private void setButtonsEnabled(boolean bl) {
        this.submitButton.setEnabled(bl);
        this.closeButton.setEnabled(bl);
        this.actionButton.setEnabled(bl);
        this.nextButton.setEnabled(bl && this.nextEstateId > 0L);
        this.prevButton.setEnabled(bl && this.prevEstateId > 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setEstate(AgencyEstate agencyEstate) {
        AgencyEstateViewAddonPanel agencyEstateViewAddonPanel;
        this.nextEstateId = 0L;
        this.prevEstateId = 0L;
        this.modifiedEstate = agencyEstate;
        if (this.modifiedEstate == null || this.modifiedEstate.getId() == null || this.modifiedEstate.getId().trim().length() == 0) {
            this.actionButton.setEnabled(false);
            this.estateNotesField.setText("");
            this.estateActionExportMenu.removeAll();
        } else {
            this.actionButton.setEnabled(true);
            this.estateNotesField.setText(this.modifiedEstate.getNotes());
            this.estateNotesField.setCaretPosition(0);
            try {
                this.refreshActionExportMenu();
            }
            catch (Exception exception) {
                LOGGER.error((Object)"could not load export-interfaces!");
                LOGGER.error((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
            }
            Long l = this.modifiedEstate.getIdNr();
            agencyEstateViewAddonPanel = null;
            try {
                agencyEstateViewAddonPanel = AgencyPluginUtils.openPluginCollection("/estates");
                String string = "declare namespace xmldb=\"http://exist-db.org/xquery/xmldb\";\ndeclare namespace openestate=\"http://www.openestate.org/1.0/\";\nfor $x in xmldb:xcollection('ImmoTool/OpenEstate-Agency/estates')/openestate:Estate\nreturn <row id=\"{$x/@Id}\" />";
                ResourceSet resourceSet = ImmoToolDbUtils.executeXQuery((Collection)agencyEstateViewAddonPanel, (String)string);
                for (long i = 0L; i < resourceSet.getSize(); ++i) {
                    try {
                        XMLResource xMLResource = (XMLResource)resourceSet.getResource(i);
                        Node node = xMLResource.getContentAsDOM();
                        String[] stringArray = node.getAttributes().getNamedItem("id").getNodeValue().split("\\.");
                        Long l2 = Long.valueOf(stringArray[1]);
                        if (l2 > l && (l2 < this.nextEstateId || this.nextEstateId <= 0L)) {
                            this.nextEstateId = l2;
                        }
                        if (l2 >= l || l2 <= this.prevEstateId && this.prevEstateId > 0L) continue;
                        this.prevEstateId = l2;
                        continue;
                    }
                    catch (Exception exception) {
                        LOGGER.warn((Object)"Can't extract id!");
                        LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
                    }
                }
            }
            catch (Exception exception) {
                this.nextEstateId = 0L;
                this.prevEstateId = 0L;
                LOGGER.warn((Object)"Can't load previous and next entry!");
                LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
            }
            finally {
                ImmoToolDbUtils.close((Collection)agencyEstateViewAddonPanel);
            }
        }
        for (int i = 0; i < this.tabPanel.getTabCount(); ++i) {
            if (!(this.tabPanel.getComponentAt(i) instanceof AgencyEstateViewAddonPanel)) continue;
            agencyEstateViewAddonPanel = (AgencyEstateViewAddonPanel)((Object)this.tabPanel.getComponentAt(i));
            try {
                agencyEstateViewAddonPanel.load(agencyEstate);
                agencyEstateViewAddonPanel.getValidationHandler().init();
                this.tabPanel.setEnabledAt(i, agencyEstateViewAddonPanel.isFormEnabled() && !agencyEstateViewAddonPanel.isLoadedInBackground());
                continue;
            }
            catch (Exception exception) {
                LOGGER.error((Object)"could not load estate-form!");
                LOGGER.error((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
                this.tabPanel.setEnabledAt(i, false);
            }
        }
        ImmoToolUtils.updateTabs();
        this.titleLabel.setTitle(this.getTabTitle());
        this.modifications.putValue((JComponent)this.estateNotesField);
    }

    public void setEstateCountry(String string) {
        this.estateValuesPanel.selectEstateCountry(string);
        this.estateGalleryPanel.selectEstateCountry(string);
        this.estateContactPanel.selectEstateCountry(string);
        this.estateExportsPanel.selectEstateCountry(string);
        for (AgencyEstateViewAddonPanel agencyEstateViewAddonPanel : this.estateAddonPanels) {
            agencyEstateViewAddonPanel.selectEstateCountry(string);
        }
    }

    public void setLanguageEnabled(Locale locale, boolean bl) {
        this.estateValuesPanel.selectLanguage(locale, bl);
        this.estateGalleryPanel.selectLanguage(locale, bl);
        this.estateContactPanel.selectLanguage(locale, bl);
        this.estateExportsPanel.selectLanguage(locale, bl);
        for (AgencyEstateViewAddonPanel agencyEstateViewAddonPanel : this.estateAddonPanels) {
            agencyEstateViewAddonPanel.selectLanguage(locale, bl);
        }
    }

    private void initComponents() {
        this.titleLabel = ImmoToolUtils.createHead1Separator((String)"");
        this.prevButton = new JButton();
        this.nextButton = new JButton();
        this.submitButton = new JButton();
        this.actionButton = new JButton();
        this.helpButton = new JButton();
        this.closeButton = new JButton();
        this.tabPanel = new JTabbedPane();
        this.setName("Form");
        this.titleLabel.setName("titleLabel");
        ApplicationActionMap applicationActionMap = Application.getInstance().getContext().getActionMap(AgencyEstateViewPanel.class, (Object)this);
        this.prevButton.setAction(applicationActionMap.get("doViewPrevious"));
        this.prevButton.setName("prevButton");
        this.nextButton.setAction(applicationActionMap.get("doViewNext"));
        this.nextButton.setName("nextButton");
        this.submitButton.setAction(applicationActionMap.get("doSubmit"));
        this.submitButton.setName("submitButton");
        this.actionButton.setAction(applicationActionMap.get("doAction"));
        this.actionButton.setName("actionButton");
        this.helpButton.setAction(applicationActionMap.get("doHelp"));
        this.helpButton.setName("helpButton");
        this.closeButton.setAction(applicationActionMap.get("doClose"));
        this.closeButton.setName("closeButton");
        this.tabPanel.setTabPlacement(2);
        this.tabPanel.setName("tabPanel");
        GroupLayout groupLayout = new GroupLayout((Container)((Object)this));
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.tabPanel, -1, 692, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addComponent((Component)this.titleLabel, -1, 348, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.prevButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.nextButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.submitButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.actionButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.helpButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.closeButton))).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.closeButton).addComponent(this.helpButton).addComponent(this.actionButton)).addComponent(this.submitButton).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.nextButton).addComponent(this.prevButton)).addComponent((Component)this.titleLabel, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.tabPanel, -1, 440, Short.MAX_VALUE).addContainerGap()));
        ResourceMap resourceMap = Application.getInstance().getContext().getResourceMap(AgencyEstateViewPanel.class);
        resourceMap.injectComponents((Component)((Object)this));
    }

    @Action
    public void doAction() {
        this.estateActionMenu.show(this.actionButton, 0, this.actionButton.getSize().height);
    }

    @Action
    public void doClose() {
        ImmoToolUtils.removePanel((String)this.getTabTitle());
    }

    @Action
    public Task doCopy() {
        if (this.modifiedEstate == null) {
            ImmoToolUtils.showMessageErrorDialog((String)this.resourceMap.getString("error.noDuplicatableEstateFound", new Object[0]), (Component)((Object)this));
            return null;
        }
        this.estateSetupPanel.validateForm();
        this.estateValuesPanel.validateForm();
        this.estateGalleryPanel.validateForm();
        this.estateContactPanel.validateForm();
        ArrayList<String> arrayList = new ArrayList<String>();
        if (!this.estateSetupPanel.isFormValid()) {
            arrayList.add(this.resourceMap.getString("error.generalTabIsInvalid", new Object[0]));
        }
        if (!this.estateValuesPanel.isFormValid()) {
            arrayList.add(this.resourceMap.getString("error.valueTabIsInvalid", new Object[0]));
        }
        if (!this.estateGalleryPanel.isFormValid()) {
            arrayList.add(this.resourceMap.getString("error.galleryTabIsInvalid", new Object[0]));
        }
        if (!this.estateContactPanel.isFormValid()) {
            arrayList.add(this.resourceMap.getString("error.contactTabIsInvalid", new Object[0]));
        }
        for (int i = 0; i < this.tabPanel.getTabCount(); ++i) {
            if (!(this.tabPanel.getComponentAt(i) instanceof AgencyEstateViewAddonPanel)) continue;
            AgencyEstateViewAddonPanel agencyEstateViewAddonPanel = (AgencyEstateViewAddonPanel)((Object)this.tabPanel.getComponentAt(i));
            agencyEstateViewAddonPanel.validateForm();
            if (agencyEstateViewAddonPanel.isFormValid()) continue;
            arrayList.add(this.resourceMap.getString("error.addonTabIsInvalid", new Object[]{agencyEstateViewAddonPanel.getTitle()}));
        }
        if (!arrayList.isEmpty()) {
            ImmoToolUtils.showMessageErrorDialog((String)this.resourceMap.getString("error.cantCopyInvalidEstate", new Object[0]), arrayList);
            return null;
        }
        if (!ImmoToolUtils.showQuestionDialog((String)this.resourceMap.getString("question.reallyCopyEstate", new Object[]{this.modifiedEstate.getIdNr()}))) {
            return null;
        }
        return new ImmoToolTask<Boolean>(this.resourceMap.getString("doCopy.Action.text", new Object[0])){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected Boolean executeTask() throws Exception {
                Object object;
                int n;
                Long l = AgencyEstateViewPanel.this.modifiedEstate.getIdNr();
                if (l == null || l <= 0L) {
                    throw new Exception("no source-estate found!");
                }
                for (n = 0; n < AgencyEstateViewPanel.this.tabPanel.getTabCount(); ++n) {
                    if (!(AgencyEstateViewPanel.this.tabPanel.getComponentAt(n) instanceof AgencyEstateViewAddonPanel)) continue;
                    object = (AgencyEstateViewAddonPanel)((Object)AgencyEstateViewPanel.this.tabPanel.getComponentAt(n));
                    ((AgencyEstateViewAddonPanel)((Object)object)).save(AgencyEstateViewPanel.this.modifiedEstate);
                }
                for (n = 0; n < AgencyEstateViewPanel.this.tabPanel.getTabCount(); ++n) {
                    if (!(AgencyEstateViewPanel.this.tabPanel.getComponentAt(n) instanceof AgencyEstateViewAddonPanel)) continue;
                    object = (AgencyEstateViewAddonPanel)((Object)AgencyEstateViewPanel.this.tabPanel.getComponentAt(n));
                    ((AgencyEstateViewAddonPanel)((Object)object)).save(AgencyEstateViewPanel.this.modifiedEstate);
                }
                AgencyEstateViewPanel.this.modifiedEstate.setId(null);
                AgencyEstateViewPanel.this.modifiedEstate.setPublicId(null);
                AgencyEstateViewPanel.this.modifiedEstate.setNrIntern(null);
                AgencyContact agencyContact = AgencyEstateViewPanel.this.estateContactPanel.getAgentContact();
                if (agencyContact != null && AgencyEstateViewPanel.this.estateContactPanel.isAgentContactSelected()) {
                    if (agencyContact.getId() == null) {
                        object = AgencyContact.storeContact(agencyContact);
                        if (object == null) {
                            throw new Exception(AgencyEstateViewPanel.this.resourceMap.getString("error.cantSaveContact", new Object[0]));
                        }
                        AgencyEstateViewPanel.this.modifiedEstate.setContactId((String)object);
                    } else {
                        AgencyEstateViewPanel.this.modifiedEstate.setContactId(agencyContact.getId());
                    }
                }
                if ((object = AgencyEstate.storeEstate(AgencyEstateViewPanel.this.modifiedEstate)) == null || (Long)object <= 0L) {
                    throw new Exception(AgencyEstateViewPanel.this.resourceMap.getString("error.cantSaveEstate", new Object[0]));
                }
                boolean bl = false;
                for (Object object2 : AgencyEstateViewPanel.this.modifiedEstate.getAttachments()) {
                    Object object3;
                    Object object4;
                    Object object5;
                    if (object2.isUrl()) {
                        object5 = object2.getFileAsUrl();
                        object4 = null;
                        object3 = null;
                        try {
                            object4 = ((URL)object5).openStream();
                            object3 = AgencyEstate.storeAttachment((Long)object, (InputStream)object4, new File(((URL)object5).getFile()).getName(), object2.getMimeType());
                        }
                        finally {
                            if (object4 != null) {
                                ((InputStream)object4).close();
                            }
                        }
                        if (object3 == null) {
                            LOGGER.warn((Object)"Anhang konnte nicht gespeichert werden!");
                            LOGGER.warn((Object)("> Immobilie #" + object));
                            LOGGER.warn((Object)("> URL: " + ((URL)object5).toString()));
                            continue;
                        }
                        object2.setFile((String)object3);
                        bl = true;
                        continue;
                    }
                    if (!object2.isName()) continue;
                    object5 = object2.getFileAsName();
                    object4 = AgencyEstate.loadAttachmentAsTempFile(l, (String)object5);
                    if (object4 == null) {
                        LOGGER.warn((Object)"Anhang nicht gefunden!");
                        LOGGER.warn((Object)("> Immobilie #" + l));
                        LOGGER.warn((Object)("> Datei: " + (String)object5));
                        continue;
                    }
                    object3 = null;
                    try {
                        object3 = new FileInputStream((File)object4);
                        String string = AgencyEstate.storeAttachment((Long)object, (InputStream)object3, (String)object5, object2.getMimeType());
                        object2.setFile(string);
                        bl = true;
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(object3);
                        FileUtils.deleteQuietly((File)object4);
                        throw throwable;
                    }
                    IOUtils.closeQuietly((InputStream)object3);
                    FileUtils.deleteQuietly((File)object4);
                }
                if (bl) {
                    AgencyEstate.storeEstate(AgencyEstateViewPanel.this.modifiedEstate);
                }
                AgencyEstate.removeUnusedAttachments(AgencyEstateViewPanel.this.modifiedEstate);
                if (AgencyEstateViewPanel.this.modifiedEstate.isExportEnabled() && "VERMITTLUNG".equalsIgnoreCase(AgencyEstateViewPanel.this.modifiedEstate.getStatus())) {
                    AgencyExportList.registerChanges(AgencyEstateViewPanel.this.modifiedEstate, "update");
                }
                for (int i = 0; i < AgencyEstateViewPanel.this.tabPanel.getTabCount(); ++i) {
                    Object object2;
                    if (!(AgencyEstateViewPanel.this.tabPanel.getComponentAt(i) instanceof AgencyEstateViewAddonPanel)) continue;
                    object2 = (AgencyEstateViewAddonPanel)((Object)AgencyEstateViewPanel.this.tabPanel.getComponentAt(i));
                    ((AgencyEstateViewAddonPanel)((Object)object2)).saveFinished(AgencyEstateViewPanel.this.modifiedEstate);
                }
                return true;
            }

            protected void failed(Throwable throwable) {
                super.failed(throwable);
                ImmoToolUtils.showMessageErrorDialog((String)AgencyEstateViewPanel.this.resourceMap.getString("error.cantCopyEstate", new Object[0]), (Throwable)throwable);
            }

            protected void succeeded(Boolean bl) {
                super.succeeded((Object)bl);
                AgencyEstateViewPanel.this.newEstate = false;
                AgencyEstateViewPanel.this.setEstate(AgencyEstateViewPanel.this.modifiedEstate);
                AgencyEstateViewPanel.this.executeFormTasks();
                AgencyEstateViewPanel.this.titleLabel.setTitle(AgencyEstateViewPanel.this.getTabTitle());
                ImmoToolUtils.updateTabs();
            }
        };
    }

    @Action
    public Task doCreateExpose() {
        if (this.modifiedEstate == null || this.modifiedEstate.getIdNr() < 1L) {
            return null;
        }
        final AgencyEstateViewPanel agencyEstateViewPanel = this;
        return new AgencyExposeTask(new AgencyEstate[]{this.modifiedEstate}, ImmoToolApp.getApplication().getMainFrame()){
            {
                super(agencyEstateArray, frame);
                this.setTitle(AgencyEstateViewPanel.this.resourceMap.getString("doCreateExpose.Action.text", new Object[0]));
            }

            protected void failed(Throwable throwable) {
                super.failed(throwable);
                ImmoToolUtils.showMessageErrorDialog((String)AgencyEstateViewPanel.this.resourceMap.getString("doCreateExpose.Message.error", new Object[0]), (Throwable)throwable);
            }

            protected void succeeded(Boolean bl) {
                super.succeeded((Object)bl);
                if (!Boolean.TRUE.equals(bl)) {
                    return;
                }
                if (this.isSavedToFile()) {
                    ImmoToolUtils.showMessageInfoDialog((String)AgencyEstateViewPanel.this.resourceMap.getString("doCreateExpose.Message.success", new Object[0]), (Component)((Object)agencyEstateViewPanel));
                }
            }
        };
    }

    @Action
    public void doHelp() {
        ImmoToolUtils.showHelpDialog((String)"agency.estates.form");
    }

    @Action
    public void doPrintNotes() {
        try {
            ImmoToolUtils.print((Printable)this.estateNotesField);
        }
        catch (Exception exception) {
            LOGGER.error((Object)"Printing failed!");
            LOGGER.error((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
            ImmoToolUtils.showMessageErrorDialog((String)"Printing failed!", (Throwable)exception);
        }
    }

    @Action
    public Task doRemove() {
        if (this.modifiedEstate == null || this.newEstate) {
            ImmoToolUtils.showQuestionDialog((String)this.resourceMap.getString("error.noRemovableEstateFound", new Object[0]));
            return null;
        }
        boolean bl = ImmoToolUtils.showQuestionDialog((String)this.resourceMap.getString("question.reallyRemoveEstate", new Object[]{this.modifiedEstate.getIdNr()}));
        if (!bl) {
            return null;
        }
        return new ImmoToolTask<Boolean>(this.resourceMap.getString("doRemove.Action.text", new Object[0])){

            protected Boolean executeTask() throws Exception {
                Long l = AgencyEstateViewPanel.this.modifiedEstate.getIdNr();
                if (l == null) {
                    throw new NullPointerException("unknown id!");
                }
                AgencyEstate.removeEstate(l);
                if (AgencyEstateViewPanel.this.modifiedEstate.isExportEnabled() && "VERMITTLUNG".equalsIgnoreCase(AgencyEstateViewPanel.this.modifiedEstate.getStatus())) {
                    AgencyExportList.registerChanges(AgencyEstateViewPanel.this.modifiedEstate, "delete");
                }
                return true;
            }

            protected void failed(Throwable throwable) {
                super.failed(throwable);
                ImmoToolUtils.showMessageErrorDialog((String)AgencyEstateViewPanel.this.resourceMap.getString("error.cantRemoveEstate", new Object[0]), (Throwable)throwable);
            }

            protected void succeeded(Boolean bl) {
                super.succeeded((Object)bl);
                ImmoToolUtils.showMessageInfoDialog((String)AgencyEstateViewPanel.this.resourceMap.getString("message.estateWasRemoved", new Object[0]));
                ImmoToolUtils.removePanel((String)AgencyEstateViewPanel.this.getTabTitle(), (boolean)true);
            }
        };
    }

    @Action
    public Task doSubmit() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < this.tabPanel.getTabCount(); ++i) {
            if (!(this.tabPanel.getComponentAt(i) instanceof AgencyEstateViewAddonPanel)) continue;
            AgencyEstateViewAddonPanel agencyEstateViewAddonPanel = (AgencyEstateViewAddonPanel)((Object)this.tabPanel.getComponentAt(i));
            agencyEstateViewAddonPanel.validateForm();
            if (agencyEstateViewAddonPanel.isFormValid()) continue;
            arrayList.add(this.resourceMap.getString("error.addonTabIsInvalid", new Object[]{agencyEstateViewAddonPanel.getTitle()}));
        }
        if (!arrayList.isEmpty()) {
            ImmoToolUtils.showMessageErrorDialog((String)this.resourceMap.getString("error.cantSaveInvalidEstate", new Object[0]), arrayList);
            return null;
        }
        return new ImmoToolTask<Boolean>(this.resourceMap.getString("doSubmit.Action.text", new Object[0])){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected Boolean executeTask() throws Exception {
                Boolean bl;
                Collection collection = null;
                try {
                    Object object;
                    Object object2;
                    if (AgencyEstateViewPanel.this.modifiedEstate == null) {
                        AgencyEstateViewPanel.this.newEstate = true;
                        AgencyEstateViewPanel.this.modifiedEstate = new AgencyEstate();
                    }
                    Long[] longArray = !AgencyEstateViewPanel.this.modifiedEstate.isExportAlways() ? AgencyEstateViewPanel.this.modifiedEstate.getExportIntefaces() : null;
                    boolean bl2 = !AgencyEstateViewPanel.this.newEstate && AgencyEstateViewPanel.this.modifiedEstate.isExportEnabled();
                    boolean bl3 = !AgencyEstateViewPanel.this.newEstate && "VERMITTLUNG".equalsIgnoreCase(AgencyEstateViewPanel.this.modifiedEstate.getStatus());
                    AgencyEstateViewPanel.this.modifiedEstate.setNotes(AgencyEstateViewPanel.this.estateNotesField.getText().trim());
                    for (int i = 0; i < AgencyEstateViewPanel.this.tabPanel.getTabCount(); ++i) {
                        if (!(AgencyEstateViewPanel.this.tabPanel.getComponentAt(i) instanceof AgencyEstateViewAddonPanel)) continue;
                        object2 = (AgencyEstateViewAddonPanel)((Object)AgencyEstateViewPanel.this.tabPanel.getComponentAt(i));
                        ((AgencyEstateViewAddonPanel)((Object)object2)).save(AgencyEstateViewPanel.this.modifiedEstate);
                    }
                    collection = AgencyPluginUtils.openPluginCollection("");
                    AgencyContact agencyContact = AgencyEstateViewPanel.this.estateContactPanel.getAgentContact();
                    if (agencyContact != null && AgencyEstateViewPanel.this.estateContactPanel.isAgentContactSelected()) {
                        if (agencyContact.getId() == null) {
                            object2 = AgencyContact.storeContact(agencyContact);
                            if (object2 == null) {
                                throw new Exception(AgencyEstateViewPanel.this.resourceMap.getString("error.cantSaveContact", new Object[0]));
                            }
                            AgencyEstateViewPanel.this.modifiedEstate.setContactId((String)object2);
                        } else {
                            AgencyEstateViewPanel.this.modifiedEstate.setContactId(agencyContact.getId());
                        }
                    }
                    if ((object2 = AgencyEstate.storeEstate(AgencyEstateViewPanel.this.modifiedEstate)) == null || (Long)object2 <= 0L) {
                        throw new Exception(AgencyEstateViewPanel.this.resourceMap.getString("error.cantSaveEstate", new Object[0]));
                    }
                    boolean bl4 = false;
                    for (Object object3 : AgencyEstateViewPanel.this.modifiedEstate.getAttachments()) {
                        if (!object3.isUrl()) continue;
                        object = object3.getFileAsUrl();
                        InputStream inputStream = null;
                        String string = null;
                        try {
                            inputStream = ((URL)object).openStream();
                            string = AgencyEstate.storeAttachment((Long)object2, inputStream, new File(((URL)object).getFile()).getName(), object3.getMimeType());
                        }
                        finally {
                            if (inputStream != null) {
                                inputStream.close();
                            }
                        }
                        if (string == null) {
                            LOGGER.warn((Object)"could not save attachment!");
                            LOGGER.warn((Object)("> estate #" + object2));
                            LOGGER.warn((Object)("> " + ((URL)object).toString()));
                            continue;
                        }
                        object3.setFile(string);
                        bl4 = true;
                    }
                    if (bl4) {
                        AgencyEstate.storeEstate(AgencyEstateViewPanel.this.modifiedEstate);
                    }
                    AgencyEstate.removeUnusedAttachments(AgencyEstateViewPanel.this.modifiedEstate);
                    if (AgencyEstateViewPanel.this.modifiedEstate.isExportEnabled() && "VERMITTLUNG".equalsIgnoreCase(AgencyEstateViewPanel.this.modifiedEstate.getStatus())) {
                        AgencyExportList.registerChanges(AgencyEstateViewPanel.this.modifiedEstate, "update");
                    } else if (bl2 && bl3) {
                        AgencyExportList.registerChanges(AgencyEstateViewPanel.this.modifiedEstate, "delete", longArray);
                    }
                    Collection collection2 = null;
                    try {
                        Object object3;
                        object3 = Arrays.asList(AgencyEstateViewPanel.this.modifiedEstate.getExportIntefaces());
                        if (longArray != null && longArray.length > 0) {
                            for (Long l : longArray) {
                                if (object3.contains(l)) continue;
                                if (collection2 == null) {
                                    collection2 = AgencyPluginUtils.openPluginCollection("/exports");
                                }
                                AgencyExportList.registerChange(AgencyEstateViewPanel.this.modifiedEstate.getIdNr(), AgencyEstateViewPanel.this.modifiedEstate.getPublicId(), "delete", l, collection2);
                            }
                        }
                    }
                    finally {
                        if (collection2 != null) {
                            ImmoToolDbUtils.close(collection2);
                        }
                    }
                    for (int i = 0; i < AgencyEstateViewPanel.this.tabPanel.getTabCount(); ++i) {
                        if (!(AgencyEstateViewPanel.this.tabPanel.getComponentAt(i) instanceof AgencyEstateViewAddonPanel)) continue;
                        object = (AgencyEstateViewAddonPanel)((Object)AgencyEstateViewPanel.this.tabPanel.getComponentAt(i));
                        ((AgencyEstateViewAddonPanel)((Object)object)).saveFinished(AgencyEstateViewPanel.this.modifiedEstate);
                    }
                    bl = true;
                }
                catch (Throwable throwable) {
                    ImmoToolDbUtils.close(collection);
                    throw throwable;
                }
                ImmoToolDbUtils.close((Collection)collection);
                return bl;
            }

            protected void failed(Throwable throwable) {
                super.failed(throwable);
                ImmoToolUtils.showMessageErrorDialog((String)AgencyEstateViewPanel.this.resourceMap.getString("error.cantSaveEstate", new Object[0]), (Throwable)throwable);
            }

            protected void succeeded(Boolean bl) {
                super.succeeded((Object)bl);
                AgencyEstateViewPanel.this.newEstate = false;
                AgencyEstateViewPanel.this.setEstate(AgencyEstateViewPanel.this.modifiedEstate);
                AgencyEstateViewPanel.this.executeFormTasks();
                AgencyEstateViewPanel.this.titleLabel.setTitle(AgencyEstateViewPanel.this.getTabTitle());
                ImmoToolUtils.updateTabs();
            }
        };
    }

    @Action
    public Task doViewNext() {
        if (this.nextEstateId <= 0L) {
            return null;
        }
        if (!this.checkForModifications()) {
            return null;
        }
        this.setButtonsEnabled(false);
        return new ImmoToolTask<AgencyEstate>(){

            protected AgencyEstate executeTask() throws Exception {
                AgencyEstate agencyEstate = AgencyEstate.loadEstate(AgencyEstateViewPanel.this.nextEstateId);
                if (agencyEstate == null) {
                    throw new Exception("Estate #" + AgencyEstateViewPanel.this.nextEstateId + " not found!");
                }
                return agencyEstate;
            }

            protected void failed(Throwable throwable) {
                super.failed(throwable);
                AgencyEstateViewPanel.this.setButtonsEnabled(true);
            }

            protected void succeeded(AgencyEstate agencyEstate) {
                super.succeeded((Object)agencyEstate);
                AgencyEstateViewPanel.this.newEstate = false;
                AgencyEstateViewPanel.this.setEstate(agencyEstate);
                AgencyEstateViewPanel.this.executeFormTasks();
                AgencyEstateViewPanel.this.titleLabel.setTitle(AgencyEstateViewPanel.this.getTabTitle());
                ImmoToolUtils.updateTabs();
                AgencyEstateViewPanel.this.requestFocus();
            }
        };
    }

    @Action
    public Task doViewPrevious() {
        if (this.prevEstateId <= 0L) {
            return null;
        }
        if (!this.checkForModifications()) {
            return null;
        }
        this.setButtonsEnabled(false);
        return new ImmoToolTask<AgencyEstate>(){

            protected AgencyEstate executeTask() throws Exception {
                AgencyEstate agencyEstate = AgencyEstate.loadEstate(AgencyEstateViewPanel.this.prevEstateId);
                if (agencyEstate == null) {
                    throw new Exception("Estate #" + AgencyEstateViewPanel.this.prevEstateId + " not found!");
                }
                return agencyEstate;
            }

            protected void failed(Throwable throwable) {
                super.failed(throwable);
                AgencyEstateViewPanel.this.setButtonsEnabled(true);
            }

            protected void succeeded(AgencyEstate agencyEstate) {
                super.succeeded((Object)agencyEstate);
                AgencyEstateViewPanel.this.newEstate = false;
                AgencyEstateViewPanel.this.setEstate(agencyEstate);
                AgencyEstateViewPanel.this.executeFormTasks();
                AgencyEstateViewPanel.this.titleLabel.setTitle(AgencyEstateViewPanel.this.getTabTitle());
                ImmoToolUtils.updateTabs();
                AgencyEstateViewPanel.this.requestFocus();
            }
        };
    }
}

