/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.layout.RowSpec;
import com.openindex.openestate.impl.EstateAdressImpl;
import com.openindex.openestate.impl.OpenEstateUtils;
import com.openindex.openestate.impl.SimpleAdressImpl;
import com.openindex.openestate.tool.ImmoToolException;
import com.openindex.openestate.tool.ImmoToolTask;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.agency.AgencyEstate;
import com.openindex.openestate.tool.agency.AgencyEstateViewAddonPanel;
import com.openindex.openestate.tool.agency.AgencyEstateViewPanel;
import com.openindex.openestate.tool.agency.AgencyPlugin;
import com.openindex.openestate.tool.agency.utils.GeoDb;
import com.openindex.openestate.tool.agency.utils.GeoDbPanel;
import com.openindex.openestate.tool.utils.FormatterRule;
import com.openindex.openestate.tool.utils.JAdressPanel;
import com.openindex.openestate.tool.utils.ModificationHandler;
import com.openindex.openestate.tool.utils.NonEmptyComboBoxRule;
import com.openindex.openestate.tool.utils.ValidationHandler;
import com.openindex.openestate.tool.utils.ValidationRule;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.text.DecimalFormatSymbols;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.Currency;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import org.apache.commons.lang.SystemUtils;
import org.apache.log4j.Logger;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.application.Task;
import org.jdesktop.swingx.JXDatePicker;
import org.jdesktop.swingx.JXTitledSeparator;

public class AgencyEstateViewSetupPanel
extends AgencyEstateViewAddonPanel {
    private static final Logger LOGGER = Logger.getLogger(AgencyEstateViewSetupPanel.class);
    private ResourceMap resourceMap = null;
    private ModificationHandler modifications = null;
    private AgencyEstateViewPanel viewPanel = null;
    private AgencyEstate modifiedEstate = null;
    private Map<Locale, JTextField> estateTitleFields = null;
    private Map<Locale, JCheckBox> estateLanguageBoxes = null;
    private JFormattedTextField estateGroupField = null;
    private JTextField estateIdField = null;
    private JTextField estateNrField = null;
    private JTextField estateNrInternField = null;
    private JXDatePicker estatePublishBeginField = null;
    private JXDatePicker estatePublishEndField = null;
    private JComboBox estateCurrencyField = null;
    private JComboBox estateStatusField = null;
    private JComboBox estateAdressBox = null;
    private JPanel estateAdressPanel = null;
    private JAdressPanel estateAdressMainPanel = null;
    private JXTitledSeparator estateAdressTitle = null;
    private JCheckBox estateAdressPublishBox = null;
    private Map<String, GeoDbPanel> estateAdressGeoPanels = null;
    private JCheckBox estateGeoBox = null;
    private JFormattedTextField estateGeoLatitudeField = null;
    private JFormattedTextField estateGeoLongitudeField = null;

    public AgencyEstateViewSetupPanel(AgencyEstateViewPanel agencyEstateViewPanel) {
        this.viewPanel = agencyEstateViewPanel;
        this.build();
    }

    private void build() {
        Serializable serializable;
        this.modifications = ImmoToolUtils.createModificationHandler();
        this.resourceMap = ImmoToolUtils.getResourceMap(AgencyEstateViewSetupPanel.class);
        this.estateAdressGeoPanels = new HashMap<String, GeoDbPanel>();
        this.buildPanel();
        this.resourceMap.injectComponents((Component)((Object)this));
        Currency currency = null;
        try {
            serializable = new Locale(SystemUtils.USER_LANGUAGE, SystemUtils.USER_COUNTRY);
            currency = Currency.getInstance((Locale)serializable);
        }
        catch (Exception exception) {
            currency = SystemUtils.USER_COUNTRY.equalsIgnoreCase("us") ? Currency.getInstance("USD") : (SystemUtils.USER_COUNTRY.equalsIgnoreCase("gb") ? Currency.getInstance("GBP") : Currency.getInstance("EUR"));
        }
        serializable = new DefaultComboBoxModel();
        int n = -1;
        int n2 = -1;
        for (String string : ImmoToolUtils.getCurrencyCodes()) {
            ++n;
            ((DefaultComboBoxModel)serializable).addElement(Currency.getInstance(string));
            if (!currency.getCurrencyCode().equals(string)) continue;
            n2 = n;
        }
        this.estateCurrencyField.setRenderer(new CurrencyRenderer());
        this.estateCurrencyField.setModel(serializable);
        if (n2 > -1) {
            this.estateCurrencyField.setSelectedIndex(n2);
        }
        this.estateStatusField.setRenderer(new StatusRenderer());
        this.estateStatusField.addItem(null);
        for (String string : AgencyEstate.getStatusList()) {
            this.estateStatusField.addItem(string);
        }
        this.estateGeoBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AgencyEstateViewSetupPanel.this.estateGeoLatitudeField.setEnabled(AgencyEstateViewSetupPanel.this.estateGeoBox.isSelected());
                AgencyEstateViewSetupPanel.this.estateGeoLongitudeField.setEnabled(AgencyEstateViewSetupPanel.this.estateGeoBox.isSelected());
                AgencyEstateViewSetupPanel.this.getValidationHandler().validate((JComponent)AgencyEstateViewSetupPanel.this.estateGeoLatitudeField);
                AgencyEstateViewSetupPanel.this.getValidationHandler().validate((JComponent)AgencyEstateViewSetupPanel.this.estateGeoLongitudeField);
            }
        });
    }

    private void buildPanel() {
        this.estateIdField = new JTextField();
        this.estateIdField.setName("estateIdField");
        this.estateIdField.setEditable(false);
        this.estateIdField.setColumns(10);
        this.estateNrField = new JTextField();
        this.estateNrField.setName("estateNrField");
        this.estateNrField.setColumns(10);
        this.estateNrInternField = new JTextField();
        this.estateNrInternField.setName("estateNrInternField");
        this.estateNrInternField.setEditable(false);
        this.estateNrInternField.setColumns(10);
        this.estatePublishBeginField = new JXDatePicker();
        this.estatePublishBeginField.setName("estatePublishBeginField");
        this.estatePublishEndField = new JXDatePicker();
        this.estatePublishEndField.setName("estatePublishEndField");
        this.estateCurrencyField = new JComboBox();
        this.estateCurrencyField.setName("estateCurrencyField");
        this.estateStatusField = new JComboBox();
        this.estateLanguageBoxes = new HashMap<Locale, JCheckBox>();
        this.estateTitleFields = new HashMap<Locale, JTextField>();
        TreeMap<String, Locale> treeMap = new TreeMap<String, Locale>();
        for (Locale serializable2 : AgencyPlugin.getLocales()) {
            treeMap.put(serializable2.getDisplayLanguage(), serializable2);
        }
        for (final Locale locale : treeMap.values()) {
            final JTextField jTextField = new JTextField();
            jTextField.setName("estateTitleField");
            jTextField.setColumns(20);
            final JCheckBox jCheckBox = new JCheckBox();
            jCheckBox.setName("estateLanguageBox");
            jCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    AgencyEstateViewSetupPanel.this.viewPanel.setLanguageEnabled(locale, jCheckBox.isSelected());
                    jTextField.setEnabled(jCheckBox.isSelected());
                    AgencyEstateViewSetupPanel.this.getValidationHandler().validate((JComponent)jTextField);
                }
            });
            this.estateLanguageBoxes.put(locale, jCheckBox);
            this.estateTitleFields.put(locale, jTextField);
            this.getValidationHandler().putRule((JComponent)jTextField, ValidationHandler.NOT_BLANK);
        }
        NumberFormat numberFormat = NumberFormat.getNumberInstance();
        numberFormat.setGroupingUsed(false);
        numberFormat.setMaximumFractionDigits(0);
        numberFormat.setMaximumIntegerDigits(10);
        this.estateGroupField = new JFormattedTextField(numberFormat);
        this.estateGroupField.setName("estateGroupField");
        GeoFormat geoFormat = new GeoFormat();
        this.estateGeoBox = new JCheckBox();
        this.estateGeoBox.setName("estateGeoBox");
        this.estateGeoLatitudeField = new JFormattedTextField(geoFormat);
        this.estateGeoLatitudeField.setName("estateLatitudeField");
        this.estateGeoLatitudeField.setColumns(10);
        this.estateGeoLongitudeField = new JFormattedTextField(geoFormat);
        this.estateGeoLongitudeField.setName("estateLongitudeField");
        this.estateGeoLongitudeField.setColumns(10);
        this.estateAdressPublishBox = new JCheckBox();
        this.estateAdressPublishBox.setName("estateAdressPublishBox");
        this.estateAdressPublishBox.setVerticalAlignment(1);
        this.estateAdressPublishBox.setVerticalTextPosition(1);
        this.estateAdressMainPanel = new JAdressPanel(null, 1, 50){

            protected DefaultFormBuilder buildAdressPanel(String string) {
                DefaultFormBuilder defaultFormBuilder = super.buildAdressPanel(string);
                defaultFormBuilder.append("", (Component)AgencyEstateViewSetupPanel.this.estateAdressPublishBox, defaultFormBuilder.getColumnCount() - 2);
                defaultFormBuilder.nextLine();
                return defaultFormBuilder;
            }

            protected JComponent buildAdressPanelTitle() {
                return null;
            }

            protected void init() {
                this.registerValidation(this.adressCityField);
                this.registerValidation(this.adressPostalCodeField);
                this.adressCountryField.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        AgencyEstateViewSetupPanel.this.viewPanel.setEstateCountry(AgencyEstateViewSetupPanel.this.estateAdressMainPanel.getSelectedCountry());
                    }
                });
            }
        };
        this.estateAdressMainPanel.setName("estateAdressPanel");
        this.estateAdressMainPanel.setBorder(Borders.EMPTY);
        this.estateAdressPanel = new JPanel(new BorderLayout());
        this.estateAdressPanel.add((Component)this.estateAdressMainPanel, "Center");
        this.estateAdressBox = new JComboBox();
        this.estateAdressBox.setName("estateAdressBox");
        this.estateAdressBox.setRenderer(new AddressTypeRenderer());
        this.estateAdressBox.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, 10, 0, 0), this.estateAdressBox.getBorder()));
        this.estateAdressBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = AgencyEstateViewSetupPanel.this.estateAdressBox.getSelectedIndex();
                if (n < 0) {
                    n = 0;
                }
                Object object = null;
                String string = null;
                Object e = AgencyEstateViewSetupPanel.this.estateAdressBox.getItemAt(n);
                if (e instanceof GeoDb) {
                    GeoDb geoDb = (GeoDb)e;
                    string = AgencyEstateViewSetupPanel.this.resourceMap.getString("label.geoDbAddress", new Object[]{geoDb.getName()});
                    object = AgencyEstateViewSetupPanel.this.estateAdressGeoPanels.containsKey(geoDb.getName()) ? (JPanel)AgencyEstateViewSetupPanel.this.estateAdressGeoPanels.get(geoDb.getName()) : new JPanel();
                } else {
                    string = AgencyEstateViewSetupPanel.this.resourceMap.getString("label.mainAddress", new Object[0]);
                    object = AgencyEstateViewSetupPanel.this.estateAdressMainPanel;
                }
                AgencyEstateViewSetupPanel.this.estateAdressTitle.setTitle(AgencyEstateViewSetupPanel.this.resourceMap.getString("addressForm", new Object[]{string}));
                AgencyEstateViewSetupPanel.this.estateAdressPanel.removeAll();
                AgencyEstateViewSetupPanel.this.estateAdressPanel.add((Component)object, "Center");
                AgencyEstateViewSetupPanel.this.estateAdressPanel.revalidate();
                AgencyEstateViewSetupPanel.this.estateAdressPanel.repaint();
            }
        });
        this.estateAdressTitle = ImmoToolUtils.createHead2Separator((String)this.resourceMap.getString("addressForm", new Object[]{this.resourceMap.getString("label.mainAddress", new Object[0])}));
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)this.estateAdressTitle, "Center");
        jPanel.add((Component)this.estateAdressBox, "East");
        this.getValidationHandler().putRule((JComponent)this.estateCurrencyField, ValidationHandler.NOT_BLANK);
        this.getValidationHandler().putRule((JComponent)this.estateStatusField, (ValidationRule)new NonEmptyComboBoxRule(this.estateStatusField));
        this.getValidationHandler().putRule((JComponent)this.estateGeoLatitudeField, (ValidationRule)new FormatterRule(this.estateGeoLatitudeField));
        this.getValidationHandler().putRule((JComponent)this.estateGeoLongitudeField, (ValidationRule)new FormatterRule(this.estateGeoLongitudeField));
        this.getValidationHandler().putRule((JComponent)this.estateGroupField, (ValidationRule)new FormatterRule(this.estateGroupField));
        DefaultFormBuilder defaultFormBuilder = ImmoToolUtils.createFormBuilder((String)"right:[50dlu,pref], 3dlu, 30dlu:grow, 3dlu,right:[40dlu,pref], 3dlu, 30dlu:grow");
        defaultFormBuilder.border(Borders.DIALOG);
        defaultFormBuilder.defaultRowSpec(RowSpec.decode((String)"top:pref"));
        defaultFormBuilder.append((Component)ImmoToolUtils.createHead2Separator((String)this.resourceMap.getString("estateForm", new Object[0])), 7);
        defaultFormBuilder.nextLine();
        for (Locale locale : treeMap.values()) {
            JLabel jLabel = new JLabel(" ");
            jLabel.setIcon(OpenEstateUtils.getFlagIcon((Locale)locale));
            jLabel.setHorizontalAlignment(4);
            JCheckBox jCheckBox = this.estateLanguageBoxes.get(locale);
            jCheckBox.setText(this.resourceMap.getString("label.estateTitle", new Object[0]));
            JPanel jPanel2 = new JPanel(new GridLayout(1, 2));
            jPanel2.add(jLabel);
            jPanel2.add(jCheckBox);
            defaultFormBuilder.append((Component)jPanel2);
            defaultFormBuilder.append((Component)this.estateTitleFields.get(locale), 5);
            defaultFormBuilder.nextLine();
        }
        defaultFormBuilder.append(this.resourceMap.getString("label.estateNr", new Object[0]), (Component)this.estateNrField);
        defaultFormBuilder.append(this.resourceMap.getString("label.estateCurrency", new Object[0]), (Component)this.estateCurrencyField);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(this.resourceMap.getString("label.estateId", new Object[0]), (Component)this.estateIdField);
        defaultFormBuilder.append(this.resourceMap.getString("label.estateStatus", new Object[0]), (Component)this.estateStatusField);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(this.resourceMap.getString("label.estateNrIntern", new Object[0]), (Component)this.estateNrInternField);
        defaultFormBuilder.append(this.resourceMap.getString("label.estatePublishBegin", new Object[0]), (Component)this.estatePublishBeginField);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(this.resourceMap.getString("label.estateGroup", new Object[0]), (Component)this.estateGroupField);
        defaultFormBuilder.append(this.resourceMap.getString("label.estatePublishEnd", new Object[0]), (Component)this.estatePublishEndField);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append((Component)new JLabel(""), 7);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append((Component)jPanel, 7);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append((Component)this.estateAdressPanel, 7);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append((Component)new JLabel(""), 7);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append((Component)ImmoToolUtils.createHead2Separator((String)this.resourceMap.getString("geoForm", new Object[0])), 7);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(this.resourceMap.getString("label.estateGeoLongitude", new Object[0]), (Component)this.estateGeoLongitudeField);
        defaultFormBuilder.append(this.resourceMap.getString("label.estateGeoLatitude", new Object[0]), (Component)this.estateGeoLatitudeField);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(" ", (Component)this.estateGeoBox, 5);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append((Component)new JLabel(""), 7);
        defaultFormBuilder.nextLine();
        JScrollPane jScrollPane = new JScrollPane(defaultFormBuilder.getPanel());
        jScrollPane.setBorder(Borders.EMPTY);
        jScrollPane.getVerticalScrollBar().setUnitIncrement(20);
        this.setLayout(new BorderLayout());
        this.add(jScrollPane, "Center");
        this.revalidate();
        this.repaint();
    }

    @Override
    public Task doLoadInBackground() {
        this.estateAdressBox.setEnabled(false);
        this.estateAdressBox.removeAllItems();
        this.estateAdressBox.addItem(null);
        this.estateAdressGeoPanels.clear();
        return new ImmoToolTask<Boolean>(){

            protected Boolean executeTask() throws Exception {
                DefaultComboBoxModel<GeoDb> defaultComboBoxModel = new DefaultComboBoxModel<GeoDb>();
                defaultComboBoxModel.addElement(null);
                try {
                    for (GeoDb geoDb : GeoDb.loadGeoDbs()) {
                        GeoDbPanel geoDbPanel = new GeoDbPanel(geoDb, 50);
                        geoDbPanel.load(AgencyEstateViewSetupPanel.this.modifiedEstate);
                        AgencyEstateViewSetupPanel.this.estateAdressGeoPanels.put(geoDb.getName(), geoDbPanel);
                        defaultComboBoxModel.addElement(geoDb);
                    }
                }
                catch (Exception exception) {
                    LOGGER.error((Object)"Can't load geo databases!");
                    LOGGER.error((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
                }
                AgencyEstateViewSetupPanel.this.estateAdressBox.setModel(defaultComboBoxModel);
                AgencyEstateViewSetupPanel.this.estateAdressBox.setSelectedIndex(0);
                return true;
            }

            protected void finished() {
                super.finished();
                AgencyEstateViewSetupPanel.this.estateAdressBox.setEnabled(true);
            }
        };
    }

    @Override
    public String getTitle() {
        return this.resourceMap.getString("title", new Object[0]);
    }

    public boolean isFormEnabled() {
        return true;
    }

    @Override
    public boolean isFormModified() {
        return this.modifications.isModified() || this.estateAdressMainPanel.isModifiedInput();
    }

    public boolean isFormUsable() {
        return true;
    }

    public boolean isFormValid() {
        boolean bl = false;
        for (Locale locale : this.estateLanguageBoxes.keySet()) {
            if (!this.estateLanguageBoxes.get(locale).isSelected()) continue;
            bl = true;
            break;
        }
        return bl && this.estateAdressMainPanel.isValidInput() && super.isFormValid();
    }

    @Override
    public boolean isLoadedInBackground() {
        return true;
    }

    @Override
    public void load(AgencyEstate agencyEstate) {
        int n;
        Object object;
        Object object2;
        boolean bl;
        this.modifications.clear();
        this.modifiedEstate = agencyEstate;
        String string = agencyEstate.getId();
        boolean bl2 = bl = string == null || string.trim().length() == 0;
        if (!bl) {
            object2 = string.split("\\.");
            this.estateIdField.setText(object2[((String[])object2).length - 1]);
            this.estateIdField.setForeground(this.estateNrField.getForeground());
        } else {
            this.estateIdField.setForeground(Color.GRAY);
            this.estateIdField.setText(this.resourceMap.getString("label.estateId.generatedOnSave", new Object[0]));
        }
        string = agencyEstate.getNrIntern();
        if (string != null && string.trim().length() > 0) {
            this.estateNrInternField.setText(string.trim());
            this.estateNrInternField.setForeground(this.estateNrField.getForeground());
        } else {
            this.estateNrInternField.setForeground(Color.GRAY);
            this.estateNrInternField.setText(this.resourceMap.getString("label.estateNrIntern.generatedOnImport", new Object[0]));
        }
        this.estateNrField.setText(agencyEstate.getPublicId() != null ? agencyEstate.getPublicId().trim() : "");
        this.estateGroupField.setValue(agencyEstate.getGroupNr() != null ? agencyEstate.getGroupNr() : 0L);
        this.estatePublishBeginField.setDate(agencyEstate.getPublishBegin());
        this.estatePublishEndField.setDate(agencyEstate.getPublishEnd());
        this.estateAdressPublishBox.setSelected(agencyEstate.getAdress() != null ? agencyEstate.getAdress().isAdressPublished() : false);
        this.estateAdressMainPanel.loadAdress((SimpleAdressImpl)(agencyEstate.getAdress() != null ? agencyEstate.getAdress() : new EstateAdressImpl()));
        for (Locale locale : this.estateLanguageBoxes.keySet()) {
            this.estateLanguageBoxes.get(locale).setSelected(bl || agencyEstate.getLanguages().isEmpty() || agencyEstate.getLanguages().contains(locale.getLanguage().toLowerCase()));
            this.modifications.putValue((JComponent)this.estateLanguageBoxes.get(locale));
        }
        object2 = this.estateTitleFields.keySet().iterator();
        while (object2.hasNext()) {
            Locale locale;
            this.estateTitleFields.get(locale).setText((object = agencyEstate.getTitle((locale = (Locale)object2.next()).getLanguage())) != null ? ((String)object).trim() : "");
            this.estateTitleFields.get(locale).setEnabled(this.estateLanguageBoxes.get(locale).isSelected());
            this.modifications.putValue((JComponent)this.estateTitleFields.get(locale));
        }
        this.estateCurrencyField.setSelectedIndex(-1);
        object2 = agencyEstate.getCurrency() == null ? Currency.getInstance(new Locale(SystemUtils.USER_LANGUAGE, SystemUtils.USER_COUNTRY)) : agencyEstate.getCurrency();
        for (n = 0; n < this.estateCurrencyField.getItemCount(); ++n) {
            object = ((Currency)this.estateCurrencyField.getItemAt(n)).getCurrencyCode();
            if (!((Currency)object2).getCurrencyCode().equals(object)) continue;
            this.estateCurrencyField.setSelectedIndex(n);
            break;
        }
        this.estateStatusField.setSelectedIndex(0);
        for (n = 1; n < this.estateStatusField.getItemCount(); ++n) {
            object = (String)this.estateStatusField.getItemAt(n);
            if (!((String)object).equals(agencyEstate.getStatus())) continue;
            this.estateStatusField.setSelectedIndex(n);
            break;
        }
        Double d = agencyEstate.getAdress().getLatitude();
        object = agencyEstate.getAdress().getLongitude();
        this.estateGeoBox.setSelected(d != null && object != null);
        this.estateGeoLatitudeField.setEnabled(this.estateGeoBox.isSelected());
        this.estateGeoLatitudeField.setValue(d != null ? d : 0.0);
        this.estateGeoLongitudeField.setEnabled(this.estateGeoBox.isSelected());
        this.estateGeoLongitudeField.setValue(object != null ? (Double)object : 0.0);
        this.modifications.putValue((JComponent)this.estateAdressPublishBox);
        this.modifications.putValue((JComponent)this.estateGroupField);
        this.modifications.putValue((JComponent)this.estateIdField);
        this.modifications.putValue((JComponent)this.estateNrField);
        this.modifications.putValue((JComponent)this.estateNrInternField);
        this.modifications.putValue((JComponent)this.estatePublishBeginField);
        this.modifications.putValue((JComponent)this.estatePublishEndField);
        this.modifications.putValue((JComponent)this.estateCurrencyField);
        this.modifications.putValue((JComponent)this.estateStatusField);
        this.modifications.putValue((JComponent)this.estateGeoBox);
        this.modifications.putValue((JComponent)this.estateGeoLatitudeField);
        this.modifications.putValue((JComponent)this.estateGeoLongitudeField);
    }

    @Override
    public void save(AgencyEstate agencyEstate) {
        agencyEstate.setPublicId(this.estateNrField.getText().trim());
        agencyEstate.setPublishBegin(this.estatePublishBeginField.isEditValid() ? this.estatePublishBeginField.getDate() : null);
        agencyEstate.setPublishEnd(this.estatePublishEndField.isEditValid() ? this.estatePublishEndField.getDate() : null);
        agencyEstate.getAdress().setAdressPublished(this.estateAdressPublishBox.isSelected());
        agencyEstate.setCurrency((Currency)this.estateCurrencyField.getSelectedItem());
        agencyEstate.setStatus((String)this.estateStatusField.getSelectedItem());
        try {
            this.estateGroupField.commitEdit();
        }
        catch (Exception exception) {
            LOGGER.warn((Object)"Can't commit modified group-nr!");
            LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
        }
        Number number = (Number)this.estateGroupField.getValue();
        agencyEstate.setGroupNr(number != null && number.longValue() > 0L ? Long.valueOf(number.longValue()) : null);
        agencyEstate.getLanguages().clear();
        for (Locale serializable : this.estateLanguageBoxes.keySet()) {
            if (!this.estateLanguageBoxes.get(serializable).isSelected()) continue;
            agencyEstate.getLanguages().add(serializable.getLanguage());
        }
        for (Locale locale : this.estateTitleFields.keySet()) {
            if (!agencyEstate.getLanguages().contains(locale.getLanguage())) continue;
            String string = this.estateTitleFields.get(locale).getText().trim();
            agencyEstate.setTitle(string != null && string.length() > 0 ? string : null, locale.getLanguage());
        }
        this.estateAdressMainPanel.saveAdress((SimpleAdressImpl)agencyEstate.getAdress());
        if (!this.estateGeoBox.isSelected()) {
            agencyEstate.getAdress().setLatitude(null);
            agencyEstate.getAdress().setLongitude(null);
        } else {
            try {
                this.estateGeoLatitudeField.commitEdit();
            }
            catch (Exception exception) {
                LOGGER.warn((Object)"Can't commit modified latitude!");
                LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
            }
            try {
                this.estateGeoLongitudeField.commitEdit();
            }
            catch (Exception exception) {
                LOGGER.warn((Object)"Can't commit modified longitude!");
                LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
            }
            Number number2 = (Number)this.estateGeoLatitudeField.getValue();
            Number number3 = (Number)this.estateGeoLongitudeField.getValue();
            agencyEstate.getAdress().setLatitude(number2 != null && number3 != null ? Double.valueOf(number2.doubleValue()) : null);
            agencyEstate.getAdress().setLongitude(number2 != null && number3 != null ? Double.valueOf(number3.doubleValue()) : null);
        }
        for (GeoDbPanel geoDbPanel : this.estateAdressGeoPanels.values()) {
            geoDbPanel.save(agencyEstate);
        }
    }

    @Override
    public void saveFinished(AgencyEstate agencyEstate) throws ImmoToolException {
    }

    public void validateForm() {
        super.validateForm();
        this.estateAdressMainPanel.validateInputs();
    }

    private static class GeoFormat
    extends NumberFormat {
        private final NumberFormat defaultFormat = NumberFormat.getNumberInstance(Locale.getDefault());
        private final NumberFormat alternativeFormat;
        private final char defaultSeparator;
        private final char alternativeSeparator;

        public GeoFormat() {
            this.defaultFormat.setGroupingUsed(false);
            this.defaultFormat.setMinimumFractionDigits(1);
            this.defaultFormat.setMaximumFractionDigits(10);
            this.defaultFormat.setMaximumIntegerDigits(3);
            this.defaultSeparator = new DecimalFormatSymbols(Locale.getDefault()).getDecimalSeparator();
            this.alternativeSeparator = new DecimalFormatSymbols(Locale.ENGLISH).getDecimalSeparator();
            if (this.defaultSeparator == this.alternativeSeparator) {
                this.alternativeFormat = null;
            } else {
                this.alternativeFormat = NumberFormat.getNumberInstance(Locale.ENGLISH);
                this.alternativeFormat.setGroupingUsed(false);
                this.alternativeFormat.setMinimumFractionDigits(1);
                this.alternativeFormat.setMaximumFractionDigits(10);
                this.alternativeFormat.setMaximumIntegerDigits(3);
            }
        }

        @Override
        public StringBuffer format(double d, StringBuffer stringBuffer, FieldPosition fieldPosition) {
            return this.defaultFormat.format(d, stringBuffer, fieldPosition);
        }

        @Override
        public StringBuffer format(long l, StringBuffer stringBuffer, FieldPosition fieldPosition) {
            return this.defaultFormat.format(l, stringBuffer, fieldPosition);
        }

        @Override
        public Number parse(String string, ParsePosition parsePosition) {
            if (this.alternativeFormat != null && string.indexOf(this.alternativeSeparator) > -1) {
                return this.alternativeFormat.parse(string, parsePosition);
            }
            return this.defaultFormat.parse(string, parsePosition);
        }
    }

    private class AddressTypeRenderer
    extends JLabel
    implements ListCellRenderer {
        public AddressTypeRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            this.setBackground(bl ? jList.getSelectionBackground() : jList.getBackground());
            this.setForeground(bl ? jList.getSelectionForeground() : jList.getForeground());
            if (object instanceof GeoDb) {
                GeoDb geoDb = (GeoDb)object;
                this.setText(" " + AgencyEstateViewSetupPanel.this.resourceMap.getString("label.geoDbAddress", new Object[]{geoDb.getName()}));
            } else {
                this.setText(" " + AgencyEstateViewSetupPanel.this.resourceMap.getString("label.mainAddress", new Object[0]));
            }
            return this;
        }
    }

    private class StatusRenderer
    extends JLabel
    implements ListCellRenderer {
        public StatusRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            this.setBackground(bl ? jList.getSelectionBackground() : jList.getBackground());
            this.setForeground(bl ? jList.getSelectionForeground() : jList.getForeground());
            if (object instanceof String) {
                this.setText(" " + AgencyEstate.writeStatus((String)object));
            } else {
                this.setText(" [ " + AgencyEstateViewSetupPanel.this.resourceMap.getString("label.estateStatus.empty", new Object[0]) + " ]");
            }
            return this;
        }
    }

    private static class CurrencyRenderer
    extends JLabel
    implements ListCellRenderer {
        public CurrencyRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            this.setBackground(bl ? jList.getSelectionBackground() : jList.getBackground());
            this.setForeground(bl ? jList.getSelectionForeground() : jList.getForeground());
            if (object instanceof Currency) {
                this.setText(" " + ((Currency)object).getSymbol());
            } else {
                this.setText("");
            }
            return this;
        }
    }
}

