/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency;

import com.openindex.openestate.tool.ImmoToolTask;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.agency.AgencyEstate;
import com.openindex.openestate.tool.agency.AgencyEstateViewPanel;
import com.openindex.openestate.tool.utils.TabComponent;
import org.jdesktop.application.ResourceMap;

public class AgencyEstateViewTask
extends ImmoToolTask<AgencyEstateViewPanel> {
    private ResourceMap resourceMap = null;
    private long estateId = 0L;
    private boolean selectTab = false;

    public AgencyEstateViewTask(long l) {
        this(l, true);
    }

    public AgencyEstateViewTask(long l, boolean bl) {
        this.estateId = l;
        this.selectTab = bl;
        this.resourceMap = ImmoToolUtils.getResourceMap(AgencyEstateViewTask.class);
        this.setTitle(this.resourceMap.getString("title", new Object[]{l}));
    }

    protected AgencyEstateViewPanel executeTask() throws Exception {
        if (this.estateId <= 0L) {
            throw new Exception("invalid estate-id!");
        }
        AgencyEstate agencyEstate = AgencyEstate.loadEstate(this.estateId);
        if (agencyEstate == null) {
            throw new Exception("Can't find estate #" + this.estateId);
        }
        String string = AgencyEstateViewPanel.getInstanceTabTitle(this.estateId, agencyEstate.getPublicId());
        if (ImmoToolUtils.hasPanel((String)string)) {
            if (this.selectTab) {
                ImmoToolUtils.selectPanel((String)string);
            }
            return null;
        }
        AgencyEstateViewPanel agencyEstateViewPanel = new AgencyEstateViewPanel(agencyEstate);
        return agencyEstateViewPanel;
    }

    protected void failed(Throwable throwable) {
        super.failed(throwable);
        ImmoToolUtils.showMessageErrorDialog((String)this.resourceMap.getString("error.cantLoadEstate", new Object[]{this.estateId}), (Throwable)throwable);
    }

    protected void succeeded(AgencyEstateViewPanel agencyEstateViewPanel) {
        super.succeeded((Object)agencyEstateViewPanel);
        if (agencyEstateViewPanel != null) {
            ImmoToolUtils.showPanel((TabComponent)agencyEstateViewPanel, (boolean)this.selectTab);
            agencyEstateViewPanel.executeFormTasks();
        }
    }
}

