/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.factories.Borders;
import com.openindex.openestate.impl.OpenEstateAttrib;
import com.openindex.openestate.impl.OpenEstateAttribsEnergiepass;
import com.openindex.openestate.impl.OpenEstateException;
import com.openindex.openestate.impl.OpenEstateType;
import com.openindex.openestate.impl.OpenEstateUtils;
import com.openindex.openestate.impl.ValueImpl;
import com.openindex.openestate.impl.attribs.SimpleStringAttrib;
import com.openindex.openestate.tool.ImmoToolException;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.agency.AgencyEstate;
import com.openindex.openestate.tool.agency.AgencyEstateValueTable;
import com.openindex.openestate.tool.agency.AgencyEstateViewAddonPanel;
import com.openindex.openestate.tool.agency.AgencyPlugin;
import com.openindex.openestate.tool.utils.LimitedPlainDocument;
import com.openindex.openestate.tool.utils.ModificationHandler;
import com.openindex.openestate.tool.utils.NonEmptyComboBoxRule;
import com.openindex.openestate.tool.utils.NullableFormattedTextField;
import com.openindex.openestate.tool.utils.ValidationRule;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.print.Printable;
import java.text.Format;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import javax.imageio.ImageIO;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.MenuElement;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.MenuKeyEvent;
import javax.swing.event.MenuKeyListener;
import javax.swing.text.AbstractDocument;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.SystemUtils;
import org.apache.log4j.Logger;
import org.fife.ui.rtextarea.RTextArea;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.swingx.JXDatePicker;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.JXTitledSeparator;

public class AgencyEstateViewValuesPanel
extends AgencyEstateViewAddonPanel {
    private static final Logger LOGGER = Logger.getLogger(AgencyEstateViewValuesPanel.class);
    private static ImageIcon selectIcon = null;
    private ResourceMap resourceMap;
    private ModificationHandler modifications = null;
    private JButton estateTypeButton = null;
    private JPopupMenu estateTypeMenu = null;
    private JComboBox estateActionField = null;
    private JCheckBox estateHidePricesBox = null;
    private JTabbedPane estateValueTabPanel = null;
    private AgencyEstateValueTable estateValueTable = null;
    private EnergyCertificatePanel estateEnergyPanel = null;
    private List<TextPanel> estateTextPanels = null;
    private String selectedEstateAction = null;
    private OpenEstateType selectedEstateType = null;
    private String selectedEstateCountry = null;
    private ImageIcon selectedEstateCountryIcon = null;
    private boolean isActionRunning = false;
    private ImageIcon minIcon = null;
    private ImageIcon maxIcon = null;

    public AgencyEstateViewValuesPanel() {
        this.build();
    }

    private void build() {
        this.modifications = ImmoToolUtils.createModificationHandler();
        this.resourceMap = ImmoToolUtils.getResourceMap(AgencyEstateViewValuesPanel.class);
        try {
            this.minIcon = new ImageIcon(ImageIO.read(((Object)((Object)this)).getClass().getResourceAsStream("/com/openindex/openestate/tool/resources/icons/16x16/arrow_1_up.png")));
            this.maxIcon = new ImageIcon(ImageIO.read(((Object)((Object)this)).getClass().getResourceAsStream("/com/openindex/openestate/tool/resources/icons/16x16/arrow_1_down.png")));
            selectIcon = new ImageIcon(ImageIO.read(((Object)((Object)this)).getClass().getResourceAsStream("/com/openindex/openestate/tool/resources/icons/16x16/button_ok.png")));
        }
        catch (Exception exception) {
            LOGGER.error((Object)"could not load icons!");
            LOGGER.error((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
        }
        this.buildPanel();
        this.resourceMap.injectComponents((Component)((Object)this));
        this.estateTypeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AgencyEstateViewValuesPanel.this.estateTypeMenu.show(AgencyEstateViewValuesPanel.this.estateTypeButton, 0, ((AgencyEstateViewValuesPanel)AgencyEstateViewValuesPanel.this).estateTypeButton.getSize().height);
            }
        });
        this.estateActionField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (AgencyEstateViewValuesPanel.this.isActionRunning) {
                    return;
                }
                AgencyEstateViewValuesPanel.this.isActionRunning = true;
                int n = AgencyEstateViewValuesPanel.this.estateActionField.getSelectedIndex();
                if (n <= 0) {
                    AgencyEstateViewValuesPanel.this.setEstateType(AgencyEstateViewValuesPanel.this.selectedEstateType, null);
                } else {
                    String string = (String)AgencyEstateViewValuesPanel.this.estateActionField.getSelectedItem();
                    AgencyEstateViewValuesPanel.this.setEstateType(AgencyEstateViewValuesPanel.this.selectedEstateType, string);
                }
                AgencyEstateViewValuesPanel.this.updateTabSelection();
                AgencyEstateViewValuesPanel.this.isActionRunning = false;
            }
        });
    }

    private void buildPanel() {
        Object object22;
        this.estateTypeButton = new JButton();
        this.estateTypeButton.setName("estateTypeButton");
        this.estateTypeButton.setOpaque(true);
        this.estateTypeButton.setHorizontalAlignment(2);
        this.estateTypeButton.setText(" [ " + this.resourceMap.getString("message.pleaseSelect", new Object[0]) + " ]");
        this.estateTypeMenu = new JPopupMenu();
        this.estateTypeMenu.setName("estateTypeMenu");
        this.estateActionField = new JComboBox(new DefaultComboBoxModel());
        this.estateActionField.setName("estateActionField");
        this.estateActionField.setRenderer(new EstateActionRenderer());
        this.estateActionField.setEnabled(false);
        this.estateHidePricesBox = new JCheckBox();
        this.estateHidePricesBox.setName("estateHidePricesBox");
        this.estateHidePricesBox.setEnabled(false);
        try {
            for (Object object22 : OpenEstateUtils.getEstateTypesOnRoot()) {
                this.estateTypeMenu.add(new EstateTypeMenu((OpenEstateType)object22));
            }
        }
        catch (Exception exception) {
            LOGGER.error((Object)"Can't load estate-types!");
            LOGGER.error((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
        }
        DefaultFormBuilder defaultFormBuilder = ImmoToolUtils.createFormBuilder((String)"right:[40dlu,pref], 3dlu, 30dlu:grow, 3dlu,right:[40dlu,pref], 3dlu, pref");
        defaultFormBuilder.border(Borders.DIALOG);
        defaultFormBuilder.append((Component)ImmoToolUtils.createHead2Separator((String)this.resourceMap.getString("spcecificationFormTitle", new Object[0])), 7);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(this.resourceMap.getString("label.estateType", new Object[0]), (Component)this.estateTypeButton);
        defaultFormBuilder.append(this.resourceMap.getString("label.estateAction", new Object[0]), (Component)this.estateActionField);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append("", (Component)this.estateHidePricesBox, 5);
        defaultFormBuilder.nextLine();
        this.getValidationHandler().putRule((JComponent)this.estateActionField, (ValidationRule)new NonEmptyComboBoxRule(this.estateActionField));
        this.estateValueTabPanel = new JTabbedPane();
        this.estateValueTabPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, 15, 10, 15), this.estateValueTabPanel.getBorder()));
        this.estateValueTable = new AgencyEstateValueTable();
        this.estateValueTable.setName("estateValueTable");
        ImmoToolUtils.configureTable((JXTable)this.estateValueTable);
        this.estateValueTable.setEnabled(false);
        this.estateValueTable.setBorder(BorderFactory.createLineBorder(ImmoToolUtils.TABLE_HIGHLIGHT_COLOR));
        JScrollPane jScrollPane = new JScrollPane((Component)((Object)this.estateValueTable));
        jScrollPane.setBorder(Borders.EMPTY);
        jScrollPane.getVerticalScrollBar().setUnitIncrement(20);
        this.estateValueTabPanel.addTab(this.resourceMap.getString("attributeTableTitle", new Object[0]), jScrollPane);
        this.estateEnergyPanel = new EnergyCertificatePanel();
        JScrollPane jScrollPane2 = new JScrollPane(this.estateEnergyPanel);
        jScrollPane2.setBorder(Borders.EMPTY);
        jScrollPane2.getVerticalScrollBar().setUnitIncrement(20);
        this.estateValueTabPanel.addTab(OpenEstateUtils.translateAttribute((String)"ENERGIEPASS"), jScrollPane2);
        this.estateTextPanels = new ArrayList<TextPanel>();
        object22 = new TreeMap();
        for (Locale serializable : AgencyPlugin.getLocales()) {
            object22.put(serializable.getDisplayLanguage(), serializable);
        }
        for (Locale locale : object22.values()) {
            TextPanel textPanel = new TextPanel(locale);
            JScrollPane jScrollPane3 = new JScrollPane(textPanel);
            jScrollPane3.setBorder(Borders.EMPTY);
            jScrollPane3.getVerticalScrollBar().setUnitIncrement(20);
            this.estateValueTabPanel.addTab(locale.getDisplayLanguage(), OpenEstateUtils.getFlagIcon((Locale)locale), jScrollPane3);
            this.estateTextPanels.add(textPanel);
        }
        this.setLayout(new BorderLayout());
        this.add(defaultFormBuilder.getPanel(), "North");
        this.add(this.estateValueTabPanel, "Center");
        this.revalidate();
        this.repaint();
    }

    private void doSelectEstateAction(JComboBox jComboBox, String string) {
        for (int i = 1; i < jComboBox.getItemCount(); ++i) {
            String string2 = (String)jComboBox.getItemAt(i);
            if (!string2.equals(string)) continue;
            jComboBox.setSelectedIndex(i);
            return;
        }
        jComboBox.setSelectedIndex(0);
    }

    @Override
    public String getTitle() {
        return this.resourceMap.getString("title", new Object[0]);
    }

    public boolean isFormEnabled() {
        return true;
    }

    @Override
    public boolean isFormModified() {
        for (TextPanel textPanel : this.estateTextPanels) {
            if (!textPanel.getModifications().isModified()) continue;
            return true;
        }
        return this.modifications.isModified() || this.estateValueTable.hasModifications();
    }

    public boolean isFormUsable() {
        return true;
    }

    public boolean isFormValid() {
        return super.isFormValid() && this.selectedEstateAction != null && this.selectedEstateType != null && this.estateValueTable.hasRequiredInputs();
    }

    @Override
    public void load(AgencyEstate agencyEstate) {
        if (agencyEstate == null) {
            agencyEstate = new AgencyEstate();
        }
        boolean bl = StringUtils.isEmpty((String)agencyEstate.getId());
        this.isActionRunning = true;
        String string = agencyEstate.getAdress() != null && agencyEstate.getAdress().getCountry() != null ? agencyEstate.getAdress().getCountry() : null;
        this.selectedEstateCountry = string != null && string.trim().length() > 0 ? string : SystemUtils.USER_COUNTRY;
        this.selectedEstateCountryIcon = this.selectedEstateCountry != null && this.selectedEstateCountry.trim().length() > 0 ? OpenEstateUtils.getFlagIcon((String)this.selectedEstateCountry) : null;
        this.setEstateType(agencyEstate.getType(), agencyEstate.getAction());
        this.selectEstateType(!bl ? agencyEstate.getType() : null);
        this.estateActionField.setSelectedIndex(-1);
        if (agencyEstate.getAction() != null) {
            this.doSelectEstateAction(this.estateActionField, agencyEstate.getAction());
        }
        this.estateHidePricesBox.setEnabled(true);
        this.estateHidePricesBox.setSelected(agencyEstate.isHiddenPrices());
        this.estateValueTable.loadEstate(agencyEstate, this.selectedEstateCountry);
        this.estateEnergyPanel.load(agencyEstate);
        for (int i = 0; i < this.estateTextPanels.size(); ++i) {
            TextPanel textPanel = this.estateTextPanels.get(i);
            textPanel.load(agencyEstate, this.selectedEstateCountry);
            this.estateValueTabPanel.setEnabledAt(i + 2, bl || agencyEstate.getLanguages().isEmpty() || agencyEstate.getLanguages().contains(textPanel.getPanelLocale().getLanguage()));
        }
        this.getValidationHandler().validate();
        this.isActionRunning = false;
        this.modifications.clear();
        this.modifications.putValue((JComponent)this.estateActionField);
        this.updateTabSelection();
    }

    @Override
    public void save(AgencyEstate agencyEstate) {
        agencyEstate.setType(this.selectedEstateType, this.selectedEstateAction);
        agencyEstate.setHiddenPrices(this.estateHidePricesBox.isSelected());
        this.estateValueTable.saveEstate(agencyEstate);
        this.estateEnergyPanel.save(agencyEstate);
        for (TextPanel textPanel : this.estateTextPanels) {
            textPanel.save(agencyEstate);
        }
    }

    @Override
    public void saveFinished(AgencyEstate agencyEstate) throws ImmoToolException {
    }

    @Override
    public void selectEstateCountry(String string) {
        this.isActionRunning = true;
        this.selectedEstateCountry = string;
        this.selectedEstateCountryIcon = string != null && string.trim().length() > 0 ? OpenEstateUtils.getFlagIcon((String)string) : null;
        this.setEstateType(this.selectedEstateType, this.selectedEstateAction);
        this.estateEnergyPanel.setCountry(string);
        this.isActionRunning = false;
        this.updateTabSelection();
    }

    private void selectEstateType(OpenEstateType openEstateType) {
        if (openEstateType == null) {
            this.estateTypeButton.setText(" [ " + this.resourceMap.getString("message.pleaseSelect", new Object[0]) + " ]");
            this.estateTypeButton.setBackground(this.getValidationHandler().getRequirdedInputColor());
        } else {
            this.estateTypeButton.setText(OpenEstateUtils.translateEstate((String)openEstateType.getName()));
            this.estateTypeButton.setBackground(this.getValidationHandler().getValidInputColor());
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            if (openEstateType != null) {
                arrayList.addAll(Arrays.asList(OpenEstateUtils.getEstateTypePath((OpenEstateType)openEstateType)));
            }
        }
        catch (Exception exception) {
            LOGGER.error((Object)"estate-type-error!");
            LOGGER.error((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
        }
        for (MenuElement menuElement : this.estateTypeMenu.getSubElements()) {
            EstateTypeMenu estateTypeMenu = (EstateTypeMenu)menuElement;
            estateTypeMenu.setSelection(arrayList);
        }
    }

    @Override
    public void selectLanguage(Locale locale, boolean bl) {
        int n = -1;
        for (int i = 0; i < this.estateTextPanels.size(); ++i) {
            TextPanel textPanel = this.estateTextPanels.get(i);
            if (!textPanel.getPanelLocale().getLanguage().equals(locale.getLanguage())) continue;
            n = i + 2;
            textPanel.setEnabled(this.selectedEstateType != null && this.selectedEstateAction != null && bl);
            break;
        }
        if (n > -1) {
            this.estateValueTabPanel.setEnabledAt(n, this.selectedEstateType != null && this.selectedEstateAction != null && bl);
            if (n == this.estateValueTabPanel.getSelectedIndex()) {
                this.estateValueTabPanel.setSelectedIndex(0);
            }
        }
        this.updateTabSelection();
    }

    private void setEstateType(OpenEstateType openEstateType, String string) {
        this.selectedEstateType = openEstateType;
        this.selectedEstateAction = string;
        this.estateActionField.setEnabled(false);
        this.estateActionField.removeAllItems();
        if (this.selectedEstateType != null) {
            this.estateActionField.addItem(null);
            for (String string2 : openEstateType.getActions()) {
                this.estateActionField.addItem(string2);
                if (!string2.equals(this.selectedEstateAction)) continue;
                this.estateActionField.setSelectedItem(string2);
            }
            this.estateActionField.setEnabled(true);
        }
        this.getValidationHandler().validate((JComponent)this.estateActionField);
        this.estateValueTable.setEnabled(false);
        this.estateValueTable.setVisible(false);
        if (this.selectedEstateType != null && this.selectedEstateAction != null) {
            this.estateValueTable.loadEstateType(this.selectedEstateType, this.selectedEstateAction, this.selectedEstateCountry, true);
            this.estateValueTable.packAll();
            this.estateValueTable.expandAll();
            this.estateValueTable.setVisible(true);
            this.estateValueTable.setEnabled(true);
            this.estateValueTabPanel.setEnabledAt(0, true);
            this.estateValueTabPanel.setEnabledAt(1, openEstateType.hasAttribGroup("ENERGIEPASS"));
            for (int i = 0; i < this.estateTextPanels.size(); ++i) {
                TextPanel textPanel = this.estateTextPanels.get(i);
                textPanel.init(this.selectedEstateType, this.selectedEstateAction, this.selectedEstateCountry, true);
                this.estateValueTabPanel.setEnabledAt(i + 2, textPanel.isEnabled());
            }
        } else {
            this.estateValueTabPanel.setSelectedIndex(0);
            for (int i = 0; i < this.estateValueTabPanel.getTabCount(); ++i) {
                this.estateValueTabPanel.setEnabledAt(i, false);
            }
        }
    }

    private void updateTabSelection() {
        int n = this.estateValueTabPanel.getSelectedIndex();
        if (n > 0 && !this.estateValueTabPanel.isEnabledAt(n)) {
            this.estateValueTabPanel.setSelectedIndex(0);
        }
    }

    private class EnumAttribOptionRenderer
    extends JLabel
    implements ListCellRenderer {
        private final String groupName;
        private final String attribName;

        public EnumAttribOptionRenderer(String string, String string2) {
            this.groupName = string;
            this.attribName = string2;
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            this.setBackground(bl ? jList.getSelectionBackground() : jList.getBackground());
            this.setForeground(bl ? jList.getSelectionForeground() : jList.getForeground());
            if (object instanceof String) {
                String string = OpenEstateUtils.translateAttribute((String)this.groupName, (String)this.attribName, (String)((String)object));
                this.setText(" " + StringUtils.defaultIfBlank((String)StringUtils.trimToNull((String)string), (String)((String)object)));
            } else if (object == null) {
                this.setText("[ " + AgencyEstateViewValuesPanel.this.resourceMap.getString("message.pleaseSelect", new Object[0]) + " ]");
            } else {
                this.setText("");
            }
            return this;
        }
    }

    private class EstateTypeMenuItem
    extends JMenuItem
    implements ActionListener {
        private OpenEstateType estateType;
        private boolean typeSelected;

        public EstateTypeMenuItem(OpenEstateType openEstateType) {
            this.estateType = openEstateType;
            this.setOpaque(true);
            this.setTypeSelected(false);
            this.setText(OpenEstateUtils.translateEstate((String)openEstateType.getName()));
            this.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            AgencyEstateViewValuesPanel.this.isActionRunning = true;
            AgencyEstateViewValuesPanel.this.setEstateType(this.estateType, AgencyEstateViewValuesPanel.this.selectedEstateAction);
            AgencyEstateViewValuesPanel.this.selectEstateType(this.estateType);
            AgencyEstateViewValuesPanel.this.updateTabSelection();
            AgencyEstateViewValuesPanel.this.isActionRunning = false;
        }

        public OpenEstateType getEstateType() {
            return this.estateType;
        }

        public boolean isTypeSelected() {
            return this.typeSelected;
        }

        public void setTypeSelected(boolean bl) {
            this.typeSelected = bl;
            if (this.typeSelected) {
                this.setFont(this.getFont().deriveFont(1));
                this.setIcon(selectIcon);
            } else {
                this.setFont(this.getFont().deriveFont(0));
                this.setIcon(null);
            }
        }
    }

    private class EstateTypeMenu
    extends JMenu {
        private OpenEstateType estateType;
        private boolean typeSelected;

        public EstateTypeMenu(OpenEstateType openEstateType) throws OpenEstateException {
            this.estateType = openEstateType;
            this.setOpaque(true);
            this.setText(OpenEstateUtils.translateEstate((String)openEstateType.getName()));
            this.setTypeSelected(false);
            for (String string : openEstateType.getChildren()) {
                OpenEstateType openEstateType2 = OpenEstateType.newInstance((String)string);
                if (openEstateType2.getChildren().length > 0) {
                    this.add(new EstateTypeMenu(openEstateType2));
                    continue;
                }
                this.add(new EstateTypeMenuItem(openEstateType2));
            }
            this.addMenuKeyListener(new MenuKeyListener(){

                @Override
                public void menuKeyTyped(MenuKeyEvent menuKeyEvent) {
                }

                @Override
                public void menuKeyPressed(MenuKeyEvent menuKeyEvent) {
                }

                @Override
                public void menuKeyReleased(MenuKeyEvent menuKeyEvent) {
                    if (!EstateTypeMenu.this.isSelected()) {
                        return;
                    }
                    if (10 == menuKeyEvent.getKeyCode() || 32 == menuKeyEvent.getKeyCode()) {
                        EstateTypeMenu.this.actionPerformed();
                        AgencyEstateViewValuesPanel.this.estateTypeMenu.setVisible(false);
                    }
                }
            });
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    if (mouseEvent.getClickCount() == 1) {
                        EstateTypeMenu.this.actionPerformed();
                    }
                }
            });
        }

        public void actionPerformed() {
            AgencyEstateViewValuesPanel.this.isActionRunning = true;
            AgencyEstateViewValuesPanel.this.setEstateType(this.estateType, AgencyEstateViewValuesPanel.this.selectedEstateAction);
            AgencyEstateViewValuesPanel.this.selectEstateType(this.estateType);
            AgencyEstateViewValuesPanel.this.updateTabSelection();
            AgencyEstateViewValuesPanel.this.isActionRunning = false;
        }

        public OpenEstateType getEstateType() {
            return this.estateType;
        }

        public boolean isTypeSelected() {
            return this.typeSelected;
        }

        public void setSelection(List<String> list) {
            int n = list.indexOf(this.estateType.getName());
            if (n >= 0 && n + 1 == list.size()) {
                this.setTypeSelectedExplicitly();
            } else {
                this.setTypeSelected(n >= 0);
            }
            for (int i = 0; i < this.getItemCount(); ++i) {
                JMenuItem jMenuItem = this.getItem(i);
                if (jMenuItem instanceof EstateTypeMenu) {
                    ((EstateTypeMenu)jMenuItem).setSelection(list);
                    continue;
                }
                if (!(jMenuItem instanceof EstateTypeMenuItem)) continue;
                EstateTypeMenuItem estateTypeMenuItem = (EstateTypeMenuItem)jMenuItem;
                estateTypeMenuItem.setTypeSelected(list.contains(estateTypeMenuItem.getEstateType().getName()));
            }
        }

        public void setTypeSelected(boolean bl) {
            if (bl && !this.typeSelected) {
                this.setFont(this.getFont().deriveFont(1));
            } else if (!bl && this.typeSelected) {
                this.setFont(this.getFont().deriveFont(0));
                this.setIcon(null);
            }
            this.typeSelected = bl;
        }

        public void setTypeSelectedExplicitly() {
            this.setTypeSelected(true);
            this.setIcon(selectIcon);
        }
    }

    private class PanelMaximizer
    implements ActionListener {
        private JButton button;
        private JPanel panel;
        private boolean maximized;
        private int defaultHeight;

        private PanelMaximizer(JButton jButton, JPanel jPanel) {
            this.button = jButton;
            this.panel = jPanel;
            this.maximized = true;
            this.defaultHeight = jPanel.getPreferredSize().height;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!this.maximized) {
                this.maximized = true;
                if (AgencyEstateViewValuesPanel.this.minIcon != null) {
                    this.button.setIcon(AgencyEstateViewValuesPanel.this.minIcon);
                } else {
                    this.button.setText("-");
                }
                this.panel.setPreferredSize(new Dimension(100, this.defaultHeight));
                this.panel.setSize(new Dimension(this.panel.getSize().width, this.defaultHeight));
            } else {
                this.maximized = false;
                if (AgencyEstateViewValuesPanel.this.maxIcon != null) {
                    this.button.setIcon(AgencyEstateViewValuesPanel.this.maxIcon);
                } else {
                    this.button.setText("+");
                }
                this.panel.setPreferredSize(new Dimension(100, 0));
                this.panel.setSize(new Dimension(this.panel.getSize().width, 0));
            }
            ((JComponent)this.panel.getParent()).revalidate();
            ((JComponent)this.panel.getParent()).repaint();
        }
    }

    private class TextMaximizer
    implements ActionListener {
        private JButton button;
        private JScrollPane scroller;
        private boolean maximized;
        private int defaultHeight;

        private TextMaximizer(JButton jButton, JScrollPane jScrollPane) {
            this.button = jButton;
            this.scroller = jScrollPane;
            this.maximized = false;
            this.defaultHeight = jScrollPane.getPreferredSize().height;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!this.maximized) {
                this.maximized = true;
                if (AgencyEstateViewValuesPanel.this.minIcon != null) {
                    this.button.setIcon(AgencyEstateViewValuesPanel.this.minIcon);
                } else {
                    this.button.setText("-");
                }
                this.scroller.setPreferredSize(new Dimension(100, 300));
                this.scroller.setSize(new Dimension(this.scroller.getSize().width, 300));
            } else {
                this.maximized = false;
                if (AgencyEstateViewValuesPanel.this.maxIcon != null) {
                    this.button.setIcon(AgencyEstateViewValuesPanel.this.maxIcon);
                } else {
                    this.button.setText("+");
                }
                this.scroller.setPreferredSize(new Dimension(100, 75));
                this.scroller.setSize(new Dimension(this.scroller.getSize().width, this.defaultHeight));
            }
            ((JComponent)this.scroller.getParent()).revalidate();
            ((JComponent)this.scroller.getParent()).repaint();
        }
    }

    private class TextPanel
    extends JPanel {
        private ModificationHandler textModifications = null;
        private Map<String, OpenEstateAttrib> textAttribs = null;
        private Map<String, JTextField> textFields = null;
        private Map<String, RTextArea> textAreas = null;
        private Locale locale;
        private String lastType = null;
        private String lastAction = null;
        private String lastCountry = null;
        private NumberFormat intFormatter = null;

        private TextPanel(Locale locale) {
            this.locale = locale;
            this.textAttribs = new HashMap<String, OpenEstateAttrib>();
            this.textFields = new HashMap<String, JTextField>();
            this.textAreas = new HashMap<String, RTextArea>();
            this.textModifications = ImmoToolUtils.createModificationHandler();
            this.intFormatter = NumberFormat.getIntegerInstance();
        }

        private void buildPanel(List<OpenEstateAttrib> list, List<OpenEstateAttrib> list2) {
            JLabel jLabel;
            Object object;
            Object object2;
            Object object3;
            Object object4;
            String string;
            Map.Entry entry2;
            Object object5;
            this.removeAll();
            this.textAttribs.clear();
            this.textFields.clear();
            ArrayList<String> arrayList = new ArrayList<String>();
            TreeMap treeMap = new TreeMap();
            for (OpenEstateAttrib object72 : list) {
                OpenEstateAttrib openEstateAttrib;
                if (object72.isCountrySpecific()) {
                    arrayList.add(object72.getKey());
                }
                if ((object5 = OpenEstateUtils.translateAttribute((String)object72.getGroup())) == null) {
                    object5 = object72.getName();
                }
                if ((openEstateAttrib = OpenEstateUtils.translateAttribute((String)object72.getGroup(), (String)object72.getName())) == null) {
                    openEstateAttrib = object72.getName();
                }
                if (!treeMap.containsKey(object5)) {
                    treeMap.put(object5, new TreeMap());
                }
                ((Map)treeMap.get(object5)).put(openEstateAttrib, object72.getKey());
                entry2 = new JTextField();
                this.textFields.put(object72.getKey(), (JTextField)((Object)entry2));
                this.textAttribs.put(object72.getKey(), object72);
            }
            this.textAreas.clear();
            TreeMap treeMap2 = new TreeMap();
            HashMap hashMap = new HashMap();
            for (OpenEstateAttrib openEstateAttrib : list2) {
                if (openEstateAttrib.isCountrySpecific()) {
                    arrayList.add(openEstateAttrib.getKey());
                }
                if ((entry2 = OpenEstateUtils.translateAttribute((String)openEstateAttrib.getGroup(), (String)openEstateAttrib.getName())) == null) {
                    entry2 = openEstateAttrib.getName();
                }
                treeMap2.put(entry2, openEstateAttrib.getKey());
                hashMap.put(openEstateAttrib.getKey(), openEstateAttrib);
                string = (SimpleStringAttrib)openEstateAttrib;
                object4 = string.getMaxLength() < 1 ? new RTextArea() : new RTextArea((AbstractDocument)new LimitedPlainDocument(string.getMaxLength()));
                object4.setLineWrap(true);
                object4.setWrapStyleWord(true);
                this.textAreas.put(openEstateAttrib.getKey(), (RTextArea)object4);
                this.textAttribs.put(openEstateAttrib.getKey(), openEstateAttrib);
                if (object4.getPopupMenu() == null) continue;
                object3 = new JMenuItem("Print");
                ((Component)object3).setName("printItem");
                ((AbstractButton)object3).addActionListener(new ActionListener((RTextArea)object4){
                    final /* synthetic */ RTextArea val$textEditor;
                    {
                        this.val$textEditor = rTextArea;
                    }

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        try {
                            ImmoToolUtils.print((Printable)this.val$textEditor);
                        }
                        catch (Exception exception) {
                            LOGGER.error((Object)"Printing failed!");
                            LOGGER.error((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
                            ImmoToolUtils.showMessageErrorDialog((String)"Printing failed!", (Throwable)exception);
                        }
                    }
                });
                AgencyEstateViewValuesPanel.this.resourceMap.injectComponent((Component)object3);
                object4.getPopupMenu().add((JMenuItem)object3);
            }
            object5 = ImmoToolUtils.createFormBuilder((String)"[40dlu,pref], 3dlu, 30dlu:grow, 3dlu, pref");
            object5.border(Borders.DIALOG);
            for (Map.Entry entry2 : treeMap.entrySet()) {
                string = (String)entry2.getKey();
                object4 = ImmoToolUtils.createFormBuilder((String)"right:[150dlu,pref], 3dlu, 30dlu:grow");
                for (Map.Entry entry3 : ((Map)entry2.getValue()).entrySet()) {
                    object2 = (String)entry3.getKey();
                    object = (String)entry3.getValue();
                    jLabel = new JLabel((String)object2 + ":");
                    jLabel.setHorizontalTextPosition(10);
                    if (arrayList.contains(object)) {
                        jLabel.setIcon(AgencyEstateViewValuesPanel.this.selectedEstateCountryIcon);
                    }
                    object4.append((Component)jLabel, (Component)this.textFields.get(object));
                    object4.nextLine();
                }
                object3 = object4.getPanel();
                JButton jButton = new JButton(AgencyEstateViewValuesPanel.this.minIcon);
                jButton.addActionListener(new PanelMaximizer(jButton, (JPanel)object3));
                object5.append((Component)ImmoToolUtils.createHead2Separator((String)this.getTextGroupTitle(string)), 3);
                object5.append((Component)jButton);
                object5.nextLine();
                object5.append((Component)object3, 5);
                object5.nextLine();
            }
            for (Map.Entry entry2 : treeMap2.entrySet()) {
                string = (String)entry2.getKey();
                object4 = (String)entry2.getValue();
                object3 = (SimpleStringAttrib)hashMap.get(object4);
                RTextArea rTextArea = this.textAreas.get(object4);
                object2 = new JScrollPane((Component)rTextArea);
                ((JComponent)object2).setPreferredSize(new Dimension(100, 65));
                object = new JButton(AgencyEstateViewValuesPanel.this.maxIcon);
                ((AbstractButton)object).addActionListener(new TextMaximizer((JButton)object, (JScrollPane)object2));
                jLabel = ImmoToolUtils.createHead2Separator((String)this.getTextAreaTitle(string, (SimpleStringAttrib)object3, rTextArea));
                jLabel.setHorizontalTextPosition(10);
                if (arrayList.contains(object4)) {
                    jLabel.setIcon(AgencyEstateViewValuesPanel.this.selectedEstateCountryIcon);
                }
                object5.append((Component)jLabel, 3);
                object5.append((Component)object);
                object5.nextLine();
                object5.append((Component)object2, 5);
                object5.nextLine();
                rTextArea.addCaretListener(new CaretListener((SimpleStringAttrib)object3, rTextArea, (JXTitledSeparator)jLabel){
                    final /* synthetic */ SimpleStringAttrib val$attrib;
                    final /* synthetic */ RTextArea val$editor;
                    final /* synthetic */ JXTitledSeparator val$label;
                    {
                        this.val$attrib = simpleStringAttrib;
                        this.val$editor = rTextArea;
                        this.val$label = jXTitledSeparator;
                    }

                    @Override
                    public void caretUpdate(CaretEvent caretEvent) {
                        String string2 = TextPanel.this.getTextAreaTitle(string, this.val$attrib, this.val$editor);
                        if (!this.val$label.getTitle().equalsIgnoreCase(string2)) {
                            this.val$label.setTitle(string2);
                        }
                    }
                });
            }
            this.setLayout(new BorderLayout());
            this.add((Component)object5.getPanel(), "Center");
            this.revalidate();
            this.repaint();
        }

        private String getTextAreaTitle(String string, SimpleStringAttrib simpleStringAttrib, RTextArea rTextArea) {
            int n = simpleStringAttrib.getMaxLength() - rTextArea.getText().length();
            if (n < 0) {
                n = 0;
            }
            String string2 = n > 0 ? "font-weight:normal;" : "font-weight:bold;color:red;";
            return "<html>" + string + " (" + this.getPanelLocale().getDisplayLanguage() + ", " + "<span style=\"" + string2 + "\">" + AgencyEstateViewValuesPanel.this.resourceMap.getString("message.availableChars", new Object[]{this.intFormatter.format(n)}) + "</span>" + ")</html>";
        }

        private String getTextGroupTitle(String string) {
            return "<html>" + string + "<span style=\"font-weight:normal;\">" + " (" + this.getPanelLocale().getDisplayLanguage() + ")" + "</span>" + "</html>";
        }

        public ModificationHandler getModifications() {
            return this.textModifications;
        }

        public Locale getPanelLocale() {
            return this.locale;
        }

        public void init(OpenEstateType openEstateType, String string, String string2, boolean bl) {
            if (openEstateType == null || string == null) {
                return;
            }
            if (this.lastType != null && this.lastAction != null && this.lastCountry != null && this.lastType.equals(openEstateType.getName()) && this.lastAction.equals(string) && this.lastCountry.equals(string2)) {
                return;
            }
            this.lastAction = string;
            this.lastCountry = string2;
            this.lastType = openEstateType != null ? openEstateType.getName() : null;
            HashMap<String, String> hashMap = new HashMap<String, String>();
            if (bl) {
                for (String object2 : this.textAreas.keySet()) {
                    hashMap.put(object2, this.textAreas.get(object2).getText().trim());
                }
                for (String string3 : this.textFields.keySet()) {
                    hashMap.put(string3, this.textFields.get(string3).getText().trim());
                }
            }
            Iterator<String> iterator = new ArrayList();
            ArrayList<OpenEstateAttrib> arrayList = new ArrayList<OpenEstateAttrib>();
            for (OpenEstateAttrib openEstateAttrib : openEstateType.getAttribs(string)) {
                if (string2 != null && !openEstateAttrib.isCountrySupported(string2)) continue;
                if ("FREITEXTE".equals(openEstateAttrib.getGroup())) {
                    iterator.add((String)openEstateAttrib);
                    continue;
                }
                if (!openEstateAttrib.isManuallyTranslated()) continue;
                arrayList.add(openEstateAttrib);
            }
            this.buildPanel((List<OpenEstateAttrib>)arrayList, (List<OpenEstateAttrib>)((Object)iterator));
            if (bl) {
                Object object = this.textAreas.keySet().iterator();
                while (object.hasNext()) {
                    String string4;
                    this.textAreas.get(string4).setText(hashMap.containsKey(string4 = (String)object.next()) ? (String)hashMap.get(string4) : "");
                    this.textAreas.get(string4).setCaretPosition(0);
                }
                object = this.textFields.keySet().iterator();
                while (object.hasNext()) {
                    String string5;
                    this.textFields.get(string5).setText(hashMap.containsKey(string5 = (String)object.next()) ? (String)hashMap.get(string5) : "");
                    this.textFields.get(string5).setCaretPosition(0);
                }
            }
        }

        public void load(AgencyEstate agencyEstate, String string) {
            int n;
            String string2;
            ValueImpl valueImpl;
            this.init(agencyEstate.getType(), agencyEstate.getAction(), string, false);
            for (String string3 : this.textFields.keySet()) {
                if (!agencyEstate.hasAttribute(string3)) {
                    this.textFields.get(string3).setText("");
                    continue;
                }
                valueImpl = agencyEstate.getAttribute(string3);
                string2 = valueImpl.writeValue(this.getPanelLocale());
                string2 = string2 == null ? "" : string2.trim();
                n = ((SimpleStringAttrib)valueImpl.getAttrib()).getMaxLength();
                if (n <= 0) {
                    n = 255;
                }
                if (string2.length() > n) {
                    string2 = string2.substring(0, n);
                }
                this.textFields.get(string3).setText(string2);
                this.textFields.get(string3).setCaretPosition(0);
            }
            for (String string3 : this.textAreas.keySet()) {
                if (!agencyEstate.hasAttribute(string3)) {
                    this.textAreas.get(string3).setText("");
                    continue;
                }
                valueImpl = agencyEstate.getAttribute(string3);
                string2 = valueImpl.writeValue(this.getPanelLocale());
                string2 = string2 == null ? "" : string2.trim();
                n = ((SimpleStringAttrib)valueImpl.getAttrib()).getMaxLength();
                if (n <= 0) {
                    n = 255;
                }
                if (string2.length() > n) {
                    string2 = string2.substring(0, n);
                }
                this.textAreas.get(string3).setText(string2);
                this.textAreas.get(string3).setCaretPosition(0);
            }
            this.textModifications.clear();
            for (String string3 : this.textAreas.keySet()) {
                this.textModifications.putValue((JComponent)this.textAreas.get(string3));
            }
            for (String string3 : this.textFields.keySet()) {
                this.textModifications.putValue((JComponent)this.textFields.get(string3));
            }
        }

        public void save(AgencyEstate agencyEstate) {
            ValueImpl valueImpl;
            int n;
            OpenEstateAttrib openEstateAttrib;
            String string;
            for (String string2 : this.textFields.keySet()) {
                string = this.textFields.get(string2).getText().trim();
                openEstateAttrib = this.textAttribs.get(string2);
                n = ((SimpleStringAttrib)openEstateAttrib).getMaxLength();
                if (n <= 0) {
                    n = 255;
                }
                if (string.length() > n) {
                    string = string.substring(0, n);
                }
                if (string.trim().length() > 0) {
                    valueImpl = agencyEstate.hasAttribute(string2) ? agencyEstate.getAttribute(string2) : this.textAttribs.get(string2).createValue();
                    valueImpl.setValue((Object)string, this.getPanelLocale().getLanguage());
                    agencyEstate.putAttribute(string2, valueImpl);
                    continue;
                }
                if (!agencyEstate.hasAttribute(string2)) continue;
                valueImpl = agencyEstate.hasAttribute(string2) ? agencyEstate.getAttribute(string2) : this.textAttribs.get(string2).createValue();
                valueImpl.setValue(null, this.getPanelLocale().getLanguage());
                agencyEstate.putAttribute(string2, valueImpl);
            }
            for (String string2 : this.textAreas.keySet()) {
                string = this.textAreas.get(string2).getText().trim();
                openEstateAttrib = this.textAttribs.get(string2);
                n = ((SimpleStringAttrib)openEstateAttrib).getMaxLength();
                if (n <= 0) {
                    n = 255;
                }
                if (string.length() > n) {
                    string = string.substring(0, n);
                }
                if (string.trim().length() > 0) {
                    valueImpl = agencyEstate.hasAttribute(string2) ? agencyEstate.getAttribute(string2) : this.textAttribs.get(string2).createValue();
                    valueImpl.setValue((Object)string, this.getPanelLocale().getLanguage());
                    agencyEstate.putAttribute(string2, valueImpl);
                    continue;
                }
                if (!agencyEstate.hasAttribute(string2)) continue;
                valueImpl = agencyEstate.hasAttribute(string2) ? agencyEstate.getAttribute(string2) : this.textAttribs.get(string2).createValue();
                valueImpl.setValue(null, this.getPanelLocale().getLanguage());
                agencyEstate.putAttribute(string2, valueImpl);
            }
        }
    }

    private class EnergyCertificatePanel
    extends JPanel {
        private final Map<String, Object> values = new HashMap<String, Object>();
        private String country = null;
        private JCheckBox certAvailableField = null;
        private JComboBox certClassField = null;
        private JXDatePicker certCreateTimeField = null;
        private JXDatePicker certExpireTimeField = null;
        private JComboBox certTypeField = null;
        private JFormattedTextField certConsumptionTotalField = null;
        private JFormattedTextField certConsumptionElectricityField = null;
        private JFormattedTextField certConsumptionHeatingField = null;
        private JCheckBox certConsumptionIncludesHotWaterField = null;
        private JFormattedTextField certDemandTotalField = null;
        private JFormattedTextField certDemandElectricityField = null;
        private JFormattedTextField certDemandHeatingField = null;
        private JFormattedTextField austriaHwbField = null;
        private JFormattedTextField austriaFgeeField = null;

        private EnergyCertificatePanel() {
            this.build();
        }

        private void build() {
            boolean bl = Boolean.TRUE.equals(this.values.get("VORHANDEN"));
            String string = (String)this.values.get("ART");
            NumberFormat numberFormat = NumberFormat.getNumberInstance();
            numberFormat.setGroupingUsed(false);
            numberFormat.setMaximumFractionDigits(2);
            this.removeAll();
            DefaultFormBuilder defaultFormBuilder = ImmoToolUtils.createFormBuilder((String)"right:[40dlu,pref], 3dlu, 30dlu:grow, 3dlu, right:pref, 3dlu, 30dlu:grow");
            defaultFormBuilder.border(Borders.DIALOG);
            defaultFormBuilder.append((Component)new JXTitledSeparator(AgencyEstateViewValuesPanel.this.resourceMap.getString("energyCertificateTitle", new Object[0])), 7);
            defaultFormBuilder.nextLine();
            this.certAvailableField = new JCheckBox();
            this.certAvailableField.setText(this.getAttribLabel("VORHANDEN"));
            this.certAvailableField.setSelected(bl);
            this.certAvailableField.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    EnergyCertificatePanel.this.rebuild();
                }
            });
            defaultFormBuilder.append((Component)new JLabel(""));
            defaultFormBuilder.append((Component)this.certAvailableField, 5);
            defaultFormBuilder.nextLine();
            this.certTypeField = new JComboBox();
            this.certTypeField.addItem(null);
            this.certTypeField.addItem("BEDARF");
            this.certTypeField.addItem("VERBRAUCH");
            this.certTypeField.setRenderer(new EnumAttribOptionRenderer("ENERGIEPASS", "ART"));
            this.certTypeField.setSelectedItem(this.values.get("ART"));
            this.certTypeField.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (EnergyCertificatePanel.this.certTypeField.isEnabled()) {
                        EnergyCertificatePanel.this.rebuild();
                    }
                }
            });
            this.certTypeField.setEnabled(bl);
            defaultFormBuilder.append((Component)new JLabel(this.getAttribLabel("ART") + ":"));
            defaultFormBuilder.append((Component)this.certTypeField);
            this.certCreateTimeField = new JXDatePicker();
            this.certCreateTimeField.setDate((Date)this.values.get("ERSTELLUNG_DATUM"));
            this.certCreateTimeField.setEnabled(bl);
            defaultFormBuilder.append((Component)new JLabel(this.getAttribLabel("ERSTELLUNG_DATUM") + ":"));
            defaultFormBuilder.append((Component)this.certCreateTimeField);
            defaultFormBuilder.nextLine();
            this.certClassField = new JComboBox();
            this.certClassField.addItem(null);
            this.certClassField.addItem("A_PLUS");
            this.certClassField.addItem("A");
            this.certClassField.addItem("B");
            this.certClassField.addItem("C");
            this.certClassField.addItem("D");
            this.certClassField.addItem("E");
            this.certClassField.addItem("F");
            this.certClassField.addItem("G");
            this.certClassField.addItem("H");
            this.certClassField.setRenderer(new EnumAttribOptionRenderer("ENERGIEPASS", "KLASSE"));
            this.certClassField.setSelectedItem(this.values.get("KLASSE"));
            this.certClassField.setEnabled(bl);
            defaultFormBuilder.append((Component)new JLabel(this.getAttribLabel("KLASSE") + ":"));
            defaultFormBuilder.append((Component)this.certClassField);
            this.certExpireTimeField = new JXDatePicker();
            this.certExpireTimeField.setDate((Date)this.values.get("ABLAUF_DATUM"));
            this.certExpireTimeField.setEnabled(bl);
            defaultFormBuilder.append((Component)new JLabel(this.getAttribLabel("ABLAUF_DATUM") + ":"));
            defaultFormBuilder.append((Component)this.certExpireTimeField);
            defaultFormBuilder.nextLine();
            if ("VERBRAUCH".equalsIgnoreCase(string)) {
                defaultFormBuilder.append((Component)new JLabel(""), 7);
                defaultFormBuilder.nextLine();
                defaultFormBuilder.append((Component)new JXTitledSeparator(AgencyEstateViewValuesPanel.this.resourceMap.getString("energyCertificateConsumptionTitle", new Object[0])), 7);
                defaultFormBuilder.nextLine();
                this.certConsumptionTotalField = new NullableFormattedTextField((Format)numberFormat);
                this.certConsumptionTotalField.setValue(this.values.get("VERBRAUCH_GESAMT"));
                this.certConsumptionTotalField.setEnabled(bl);
                defaultFormBuilder.append((Component)new JLabel(this.getAttribLabel("VERBRAUCH_GESAMT") + ":"));
                defaultFormBuilder.append((Component)this.certConsumptionTotalField);
                defaultFormBuilder.append((Component)new JLabel("kWh/m\u00b2a", 2), 3);
                defaultFormBuilder.nextLine();
                this.certConsumptionElectricityField = new NullableFormattedTextField((Format)numberFormat);
                this.certConsumptionElectricityField.setValue(this.values.get("VERBRAUCH_STROM"));
                this.certConsumptionElectricityField.setEnabled(bl);
                defaultFormBuilder.append((Component)new JLabel(this.getAttribLabel("VERBRAUCH_STROM") + ":"));
                defaultFormBuilder.append((Component)this.certConsumptionElectricityField);
                defaultFormBuilder.append((Component)new JLabel("kWh/m\u00b2a", 2), 3);
                defaultFormBuilder.nextLine();
                this.certConsumptionHeatingField = new NullableFormattedTextField((Format)numberFormat);
                this.certConsumptionHeatingField.setValue(this.values.get("VERBRAUCH_HEIZUNG"));
                this.certConsumptionHeatingField.setEnabled(bl);
                defaultFormBuilder.append((Component)new JLabel(this.getAttribLabel("VERBRAUCH_HEIZUNG") + ":"));
                defaultFormBuilder.append((Component)this.certConsumptionHeatingField);
                defaultFormBuilder.append((Component)new JLabel("kWh/m\u00b2a", 2), 3);
                defaultFormBuilder.nextLine();
                this.certConsumptionIncludesHotWaterField = new JCheckBox();
                this.certConsumptionIncludesHotWaterField.setText(this.getAttribLabel("VERBRAUCH_INKL_WARMWASSER"));
                this.certConsumptionIncludesHotWaterField.setSelected(Boolean.TRUE.equals(this.values.get("VERBRAUCH_INKL_WARMWASSER")));
                this.certConsumptionIncludesHotWaterField.setEnabled(bl);
                defaultFormBuilder.append((Component)new JLabel(""));
                defaultFormBuilder.append((Component)this.certConsumptionIncludesHotWaterField, 5);
                defaultFormBuilder.nextLine();
            }
            if ("BEDARF".equalsIgnoreCase(string)) {
                defaultFormBuilder.append((Component)new JLabel(""), 7);
                defaultFormBuilder.nextLine();
                defaultFormBuilder.append((Component)new JXTitledSeparator(AgencyEstateViewValuesPanel.this.resourceMap.getString("energyCertificateDemandTitle", new Object[0])), 7);
                defaultFormBuilder.nextLine();
                this.certDemandTotalField = new NullableFormattedTextField((Format)numberFormat);
                this.certDemandTotalField.setValue(this.values.get("BEDARF_GESAMT"));
                this.certDemandTotalField.setEnabled(bl);
                defaultFormBuilder.append((Component)new JLabel(this.getAttribLabel("BEDARF_GESAMT") + ":"));
                defaultFormBuilder.append((Component)this.certDemandTotalField);
                defaultFormBuilder.append((Component)new JLabel("kWh/m\u00b2a", 2), 3);
                defaultFormBuilder.nextLine();
                this.certDemandElectricityField = new NullableFormattedTextField((Format)numberFormat);
                this.certDemandElectricityField.setValue(this.values.get("BEDARF_STROM"));
                this.certDemandElectricityField.setEnabled(bl);
                defaultFormBuilder.append((Component)new JLabel(this.getAttribLabel("BEDARF_STROM") + ":"));
                defaultFormBuilder.append((Component)this.certDemandElectricityField);
                defaultFormBuilder.append((Component)new JLabel("kWh/m\u00b2a", 2), 3);
                defaultFormBuilder.nextLine();
                this.certDemandHeatingField = new NullableFormattedTextField((Format)numberFormat);
                this.certDemandHeatingField.setValue(this.values.get("BEDARF_HEIZUNG"));
                this.certDemandHeatingField.setEnabled(bl);
                defaultFormBuilder.append((Component)new JLabel(this.getAttribLabel("BEDARF_HEIZUNG") + ":"));
                defaultFormBuilder.append((Component)this.certDemandHeatingField);
                defaultFormBuilder.append((Component)new JLabel("kWh/m\u00b2a", 2), 3);
                defaultFormBuilder.nextLine();
            }
            if ("at".equalsIgnoreCase(this.country)) {
                defaultFormBuilder.append((Component)new JLabel(""), 7);
                defaultFormBuilder.nextLine();
                defaultFormBuilder.append((Component)new JXTitledSeparator(AgencyEstateViewValuesPanel.this.resourceMap.getString("energyCertificateAustriaTitle", new Object[0])), 7);
                defaultFormBuilder.nextLine();
                this.austriaHwbField = new NullableFormattedTextField((Format)numberFormat);
                this.austriaHwbField.setValue(this.values.get("AUSTRIA_HWB"));
                this.austriaHwbField.setEnabled(bl);
                defaultFormBuilder.append((Component)new JLabel(this.getAttribLabel("AUSTRIA_HWB") + ":"));
                defaultFormBuilder.append((Component)this.austriaHwbField);
                defaultFormBuilder.append((Component)new JLabel("kWh/m\u00b2a", 2), 3);
                defaultFormBuilder.nextLine();
                this.austriaFgeeField = new NullableFormattedTextField((Format)numberFormat);
                this.austriaFgeeField.setValue(this.values.get("AUSTRIA_FGEE"));
                this.austriaFgeeField.setEnabled(bl);
                defaultFormBuilder.append((Component)new JLabel(this.getAttribLabel("AUSTRIA_FGEE") + ":"));
                defaultFormBuilder.append((Component)this.austriaFgeeField);
                defaultFormBuilder.nextLine();
            }
            this.setLayout(new BorderLayout());
            this.add((Component)defaultFormBuilder.getPanel(), "Center");
            this.revalidate();
            this.repaint();
        }

        private String getAttribLabel(String string) {
            return this.getAttribLabel("ENERGIEPASS", string);
        }

        private String getAttribLabel(String string, String string2) {
            String string3 = OpenEstateUtils.translateAttribute((String)string, (String)string2);
            if (StringUtils.isBlank((String)string3)) {
                string3 = string2;
            }
            return StringUtils.trim((String)(string3.contains("(") ? StringUtils.substringBefore((String)string3, (String)"(") : string3));
        }

        public void load(AgencyEstate agencyEstate) {
            this.values.clear();
            this.country = null;
            if (agencyEstate != null) {
                this.country = agencyEstate.getAdress() != null ? StringUtils.trimToNull((String)agencyEstate.getAdress().getCountry()) : null;
                for (String string : OpenEstateAttribsEnergiepass.getValues()) {
                    ValueImpl valueImpl = agencyEstate.getAttribute("ENERGIEPASS", string);
                    if (valueImpl == null) continue;
                    this.values.put(string, valueImpl.getValueObject());
                }
                String string = (String)this.values.get("ART");
                if (string != null) {
                    this.values.put("VORHANDEN", Boolean.TRUE);
                }
            }
            this.certAvailableField = null;
            this.certClassField = null;
            this.certCreateTimeField = null;
            this.certExpireTimeField = null;
            this.certTypeField = null;
            this.certConsumptionTotalField = null;
            this.certConsumptionElectricityField = null;
            this.certConsumptionHeatingField = null;
            this.certConsumptionIncludesHotWaterField = null;
            this.certDemandTotalField = null;
            this.certDemandElectricityField = null;
            this.certDemandHeatingField = null;
            this.austriaHwbField = null;
            this.austriaFgeeField = null;
            this.removeAll();
            this.build();
        }

        private void rebuild() {
            this.removeAll();
            if (this.certAvailableField != null) {
                this.values.put("VORHANDEN", this.certAvailableField.isSelected());
            }
            this.certAvailableField = null;
            if (this.certClassField != null) {
                this.values.put("KLASSE", this.certClassField.getSelectedItem());
            }
            this.certClassField = null;
            if (this.certCreateTimeField != null) {
                this.values.put("ERSTELLUNG_DATUM", this.certCreateTimeField.getDate());
            }
            this.certCreateTimeField = null;
            if (this.certExpireTimeField != null) {
                this.values.put("ABLAUF_DATUM", this.certExpireTimeField.getDate());
            }
            this.certExpireTimeField = null;
            if (this.certTypeField != null) {
                this.values.put("ART", this.certTypeField.getSelectedItem());
            }
            this.certTypeField = null;
            if (this.certConsumptionTotalField != null) {
                this.values.put("VERBRAUCH_GESAMT", this.certConsumptionTotalField.getValue());
            }
            this.certConsumptionTotalField = null;
            if (this.certConsumptionElectricityField != null) {
                this.values.put("VERBRAUCH_STROM", this.certConsumptionElectricityField.getValue());
            }
            this.certConsumptionElectricityField = null;
            if (this.certConsumptionHeatingField != null) {
                this.values.put("VERBRAUCH_HEIZUNG", this.certConsumptionHeatingField.getValue());
            }
            this.certConsumptionHeatingField = null;
            if (this.certConsumptionIncludesHotWaterField != null) {
                this.values.put("VERBRAUCH_INKL_WARMWASSER", this.certConsumptionIncludesHotWaterField.isSelected());
            }
            this.certConsumptionIncludesHotWaterField = null;
            if (this.certDemandTotalField != null) {
                this.values.put("BEDARF_GESAMT", this.certDemandTotalField.getValue());
            }
            this.certDemandTotalField = null;
            if (this.certDemandElectricityField != null) {
                this.values.put("BEDARF_STROM", this.certDemandElectricityField.getValue());
            }
            this.certDemandElectricityField = null;
            if (this.certDemandHeatingField != null) {
                this.values.put("BEDARF_HEIZUNG", this.certDemandHeatingField.getValue());
            }
            this.certDemandHeatingField = null;
            if (this.austriaHwbField != null) {
                this.values.put("AUSTRIA_HWB", this.austriaHwbField.getValue());
            }
            this.austriaHwbField = null;
            if (this.austriaFgeeField != null) {
                this.values.put("AUSTRIA_FGEE", this.austriaFgeeField.getValue());
            }
            this.austriaFgeeField = null;
            this.build();
        }

        public void save(AgencyEstate agencyEstate) {
            if (agencyEstate == null) {
                return;
            }
            OpenEstateType openEstateType = agencyEstate.getType();
            ArrayList arrayList = new ArrayList();
            arrayList.addAll(agencyEstate.getAttributes());
            for (ValueImpl valueImpl : arrayList) {
                if (!"ENERGIEPASS".equals(valueImpl.getGroupName())) continue;
                agencyEstate.putAttribute(valueImpl.getAttrib(), null);
            }
            if (openEstateType == null || !openEstateType.hasAttribGroup("ENERGIEPASS")) {
                return;
            }
            if (this.certAvailableField != null) {
                this.saveValue(agencyEstate, "VORHANDEN", this.certAvailableField.isSelected());
            }
            if (this.certClassField != null && this.certClassField.isEnabled()) {
                this.saveValue(agencyEstate, "KLASSE", this.certClassField.getSelectedItem());
            }
            if (this.certCreateTimeField != null && this.certCreateTimeField.isEnabled()) {
                this.saveValue(agencyEstate, "ERSTELLUNG_DATUM", this.certCreateTimeField.getDate());
            }
            if (this.certExpireTimeField != null && this.certExpireTimeField.isEnabled()) {
                this.saveValue(agencyEstate, "ABLAUF_DATUM", this.certExpireTimeField.getDate());
            }
            if (this.certTypeField != null && this.certTypeField.isEnabled()) {
                this.saveValue(agencyEstate, "ART", this.certTypeField.getSelectedItem());
            }
            if (this.certConsumptionTotalField != null && this.certConsumptionTotalField.isEnabled()) {
                this.saveValue(agencyEstate, "VERBRAUCH_GESAMT", this.certConsumptionTotalField.getValue());
            }
            if (this.certConsumptionElectricityField != null && this.certConsumptionElectricityField.isEnabled()) {
                this.saveValue(agencyEstate, "VERBRAUCH_STROM", this.certConsumptionElectricityField.getValue());
            }
            if (this.certConsumptionHeatingField != null && this.certConsumptionHeatingField.isEnabled()) {
                this.saveValue(agencyEstate, "VERBRAUCH_HEIZUNG", this.certConsumptionHeatingField.getValue());
            }
            if (this.certConsumptionIncludesHotWaterField != null && this.certConsumptionIncludesHotWaterField.isEnabled()) {
                this.saveValue(agencyEstate, "VERBRAUCH_INKL_WARMWASSER", this.certConsumptionIncludesHotWaterField.isSelected());
            }
            if (this.certDemandTotalField != null && this.certDemandTotalField.isEnabled()) {
                this.saveValue(agencyEstate, "BEDARF_GESAMT", this.certDemandTotalField.getValue());
            }
            if (this.certDemandElectricityField != null && this.certDemandElectricityField.isEnabled()) {
                this.saveValue(agencyEstate, "BEDARF_STROM", this.certDemandElectricityField.getValue());
            }
            if (this.certDemandHeatingField != null && this.certDemandHeatingField.isEnabled()) {
                this.saveValue(agencyEstate, "BEDARF_HEIZUNG", this.certDemandHeatingField.getValue());
            }
            if (this.austriaHwbField != null && this.austriaHwbField.isEnabled()) {
                this.saveValue(agencyEstate, "AUSTRIA_HWB", this.austriaHwbField.getValue());
            }
            if (this.austriaFgeeField != null && this.austriaFgeeField.isEnabled()) {
                this.saveValue(agencyEstate, "AUSTRIA_FGEE", this.austriaFgeeField.getValue());
            }
        }

        private void saveValue(AgencyEstate agencyEstate, String string, Object object) {
            if (!agencyEstate.getType().hasAttrib("ENERGIEPASS", string)) {
                return;
            }
            OpenEstateAttrib openEstateAttrib = agencyEstate.getType().getAttrib("ENERGIEPASS", string);
            agencyEstate.putAttribute(openEstateAttrib, openEstateAttrib.createValue(object));
        }

        public void setCountry(String string) {
            if (this.country == null && string != null) {
                this.country = string;
                this.rebuild();
            } else if (!this.country.equalsIgnoreCase(string)) {
                this.country = string;
                this.rebuild();
            }
        }
    }

    private class EstateActionRenderer
    extends JLabel
    implements ListCellRenderer {
        public EstateActionRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            this.setBackground(bl ? jList.getSelectionBackground() : jList.getBackground());
            this.setForeground(bl ? jList.getSelectionForeground() : jList.getForeground());
            if (object instanceof String) {
                String string = (String)object;
                String string2 = OpenEstateUtils.translateAction((String)string);
                this.setText(string2 != null ? " " + string2 : " " + string);
            } else {
                this.setText(" [ " + AgencyEstateViewValuesPanel.this.resourceMap.getString("message.pleaseSelect", new Object[0]) + " ]");
            }
            return this;
        }
    }
}

