/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency;

import com.openindex.openestate.tool.ImmoToolApp;
import com.openindex.openestate.tool.ImmoToolDbException;
import com.openindex.openestate.tool.ImmoToolDbUtils;
import com.openindex.openestate.tool.ImmoToolException;
import com.openindex.openestate.tool.agency.AgencyExportSummary;
import com.openindex.openestate.tool.agency.AgencyExportTask;
import com.openindex.openestate.tool.agency.AgencyPluginUtils;
import com.openindex.openestate.tool.agency.export.AbstractExport;
import com.openindex.openestate.tool.agency.export.AbstractTransport;
import java.util.ArrayList;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.Resource;
import org.xmldb.api.base.ResourceSet;
import org.xmldb.api.modules.XMLResource;

public class AgencyExportInterface {
    private static final Logger LOGGER = Logger.getLogger(AgencyExportInterface.class);
    public static final String PUBLISH_DEFAULT = "default";
    public static final String PUBLISH_NEVER = "never";
    public static final String PUBLISH_ALWAYS = "always";
    public static final String KEY_ACTIVE = "active";
    public static final String KEY_ADDRESS_PUBLISHING = "addressPublishing";
    public static final String KEY_ID = "id";
    public static final String KEY_EXPORT = "export";
    public static final String KEY_LIMIT = "limit";
    public static final String KEY_TITLE = "title";
    public static final String KEY_TRANSPORT = "transport";
    private boolean active = true;
    private long id = 0L;
    private long limit = 0L;
    private String title = "";
    private String addressPublishing = "default";
    private AbstractExport export = null;
    private AbstractTransport transport = null;

    public AgencyExportTask createExportTask(AgencyExportSummary agencyExportSummary) {
        return new AgencyExportTask(this, agencyExportSummary);
    }

    public String getAddressPublishing() {
        return this.addressPublishing;
    }

    public AbstractExport getExport() {
        return this.export;
    }

    public long getId() {
        return this.id;
    }

    public long getLimit() {
        return this.limit;
    }

    public String getTitle() {
        return this.title;
    }

    public AbstractTransport getTransport() {
        return this.transport;
    }

    public String getZipFileName() {
        return this.getExport() != null ? this.getExport().getZipFileName() : null;
    }

    public boolean isActive() {
        return this.active;
    }

    public boolean isZippedExport() {
        return this.getExport() != null && this.getExport().isZipped();
    }

    public void load(Properties properties) throws ImmoToolException {
        String string;
        this.setActive(Boolean.valueOf(properties.getProperty(KEY_ACTIVE, "true")));
        this.setAddressPublishing(properties.getProperty(KEY_ADDRESS_PUBLISHING, PUBLISH_DEFAULT));
        this.setId(Long.valueOf(properties.getProperty(KEY_ID, "0")));
        this.setTitle(properties.getProperty(KEY_TITLE, ""));
        this.setLimit(Long.valueOf(properties.getProperty(KEY_LIMIT, "0")));
        try {
            string = properties.getProperty(KEY_TRANSPORT, "").trim();
            if (string.trim().length() > 0) {
                this.transport = (AbstractTransport)AgencyPluginUtils.getTransport(string).getClass().newInstance();
                this.transport.load(properties);
            }
        }
        catch (Exception exception) {
            throw new ImmoToolException("could not load transport:" + exception.getLocalizedMessage(), (Throwable)exception);
        }
        try {
            string = properties.getProperty(KEY_EXPORT, "").trim();
            if (string.trim().length() > 0) {
                AbstractExport abstractExport = AgencyPluginUtils.getExport(string);
                if (abstractExport == null) {
                    throw new Exception("export-interface '" + string + "' not found!");
                }
                this.export = (AbstractExport)abstractExport.getClass().newInstance();
                this.export.load(properties);
                this.export.setAddressPublishing(this.getAddressPublishing());
            }
        }
        catch (Exception exception) {
            throw new ImmoToolException("could not load export:" + exception.getLocalizedMessage(), (Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AgencyExportInterface loadExportInterface(long l) throws ImmoToolDbException {
        Collection collection = null;
        try {
            collection = AgencyPluginUtils.openPluginCollection("/exports");
            AgencyExportInterface agencyExportInterface = AgencyExportInterface.loadExportInterface(l, collection);
            return agencyExportInterface;
        }
        finally {
            ImmoToolDbUtils.close((Collection)collection);
        }
    }

    public static AgencyExportInterface loadExportInterface(long l, Collection collection) throws ImmoToolDbException {
        try {
            AgencyExportInterface agencyExportInterface = new AgencyExportInterface();
            String string = "ExportInterface." + l + ".xml";
            Properties properties = null;
            try {
                properties = ImmoToolDbUtils.loadProperties((Collection)collection, (String)string);
            }
            catch (Exception exception) {
                LOGGER.warn((Object)("Can't find export-interface #" + l));
                LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
                return null;
            }
            if (properties == null) {
                LOGGER.warn((Object)("Can't find export-interface #" + l));
                return null;
            }
            agencyExportInterface.load(properties);
            return agencyExportInterface;
        }
        catch (ImmoToolDbException immoToolDbException) {
            throw immoToolDbException;
        }
        catch (Exception exception) {
            throw new ImmoToolDbException(exception.getLocalizedMessage(), (Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AgencyExportInterface[] loadExportInterfaces() throws ImmoToolDbException {
        Collection collection = null;
        try {
            collection = AgencyPluginUtils.openPluginCollection("/exports");
            AgencyExportInterface[] agencyExportInterfaceArray = AgencyExportInterface.loadExportInterfaces(collection);
            return agencyExportInterfaceArray;
        }
        finally {
            ImmoToolDbUtils.close((Collection)collection);
        }
    }

    public static AgencyExportInterface[] loadExportInterfaces(Collection collection) throws ImmoToolDbException {
        try {
            String string = "declare namespace util=\"http://exist-db.org/xquery/util\";\nfor $x in xmldb:xcollection( 'ImmoTool/OpenEstate-Agency/exports' )\n  let $file := util:document-name($x)\n  where starts-with( $file, 'ExportInterface.' ) and ends-with( $file, '.xml' ) and not(ends-with( $file, '.changed.xml' )) and not(ends-with( $file, '.published.xml' ))\n  return $x";
            ResourceSet resourceSet = ImmoToolDbUtils.executeXQuery((Collection)collection, (String)string);
            ArrayList<AgencyExportInterface> arrayList = new ArrayList<AgencyExportInterface>();
            for (long i = 0L; i < resourceSet.getSize(); ++i) {
                try {
                    Properties properties = ImmoToolDbUtils.loadProperties((XMLResource)((XMLResource)resourceSet.getResource(i)));
                    AgencyExportInterface agencyExportInterface = new AgencyExportInterface();
                    agencyExportInterface.load(properties);
                    arrayList.add(agencyExportInterface);
                    continue;
                }
                catch (Exception exception) {
                    LOGGER.warn((Object)"could not load export-interface!");
                    LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
                }
            }
            return arrayList.toArray(new AgencyExportInterface[arrayList.size()]);
        }
        catch (ImmoToolDbException immoToolDbException) {
            throw immoToolDbException;
        }
        catch (Exception exception) {
            throw new ImmoToolDbException(exception.getLocalizedMessage(), (Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeExportInterface(long l) throws ImmoToolDbException {
        Collection collection = null;
        try {
            collection = AgencyPluginUtils.openPluginCollection("/exports");
            AgencyExportInterface.removeExportInterface(l, collection);
        }
        finally {
            ImmoToolDbUtils.close((Collection)collection);
        }
    }

    public static void removeExportInterface(long l, Collection collection) throws ImmoToolDbException {
        try {
            String string = "ExportInterface." + l + ".xml";
            XMLResource xMLResource = ImmoToolDbUtils.loadXMLResource((Collection)collection, (String)string);
            if (xMLResource == null) {
                throw new ImmoToolDbException("no deletable resource found!");
            }
            ImmoToolDbUtils.removeResource((Collection)collection, (Resource)xMLResource);
            string = "ExportInterface." + l + "." + "changed" + ".xml";
            xMLResource = ImmoToolDbUtils.loadXMLResource((Collection)collection, (String)string);
            if (xMLResource != null) {
                ImmoToolDbUtils.removeResource((Collection)collection, (Resource)xMLResource);
            }
            if ((xMLResource = ImmoToolDbUtils.loadXMLResource((Collection)collection, (String)(string = "ExportInterface." + l + "." + "published" + ".xml"))) != null) {
                ImmoToolDbUtils.removeResource((Collection)collection, (Resource)xMLResource);
            }
        }
        catch (ImmoToolDbException immoToolDbException) {
            throw immoToolDbException;
        }
        catch (Exception exception) {
            throw new ImmoToolDbException(exception.getLocalizedMessage(), (Throwable)exception);
        }
    }

    public void save(Properties properties) {
        properties.setProperty(KEY_ACTIVE, String.valueOf(this.isActive()));
        properties.setProperty(KEY_ADDRESS_PUBLISHING, this.getAddressPublishing());
        properties.setProperty(KEY_ID, String.valueOf(this.getId()));
        properties.setProperty(KEY_TITLE, this.getTitle());
        properties.setProperty(KEY_LIMIT, String.valueOf(this.getLimit()));
        properties.setProperty(KEY_EXPORT, this.export != null ? this.export.getName() : "");
        if (this.export != null) {
            this.export.save(properties);
        }
        properties.setProperty(KEY_TRANSPORT, this.transport != null ? this.transport.getName() : "");
        if (this.transport != null) {
            this.transport.save(properties);
        }
    }

    public void setActive(boolean bl) {
        this.active = bl;
    }

    public void setAddressPublishing(String string) {
        this.addressPublishing = PUBLISH_ALWAYS.equals(string) ? PUBLISH_ALWAYS : (PUBLISH_NEVER.equals(string) ? PUBLISH_NEVER : PUBLISH_DEFAULT);
    }

    public void setExport(AbstractExport abstractExport) {
        this.export = abstractExport;
    }

    public void setId(long l) {
        this.id = l > 0L ? l : 0L;
    }

    public void setLimit(long l) {
        this.limit = l > 0L ? l : 0L;
    }

    public void setTitle(String string) {
        this.title = string != null ? string.trim() : "";
    }

    public void setTransport(AbstractTransport abstractTransport) {
        this.transport = abstractTransport;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void storeExportInterface(AgencyExportInterface agencyExportInterface) throws ImmoToolDbException {
        Collection collection = null;
        try {
            collection = AgencyPluginUtils.openPluginCollection("/exports");
            AgencyExportInterface.storeExportInterface(agencyExportInterface, collection);
        }
        finally {
            ImmoToolDbUtils.close((Collection)collection);
        }
    }

    public static void storeExportInterface(AgencyExportInterface agencyExportInterface, Collection collection) throws ImmoToolDbException {
        try {
            if (agencyExportInterface.getId() <= 0L) {
                long l = ImmoToolApp.getApplication().getDatabase().getNextSequence("OpenEstate-Agency.ExportInterface");
                agencyExportInterface.setId(l);
            }
            String string = "ExportInterface." + agencyExportInterface.getId() + ".xml";
            Properties properties = new Properties();
            agencyExportInterface.save(properties);
            ImmoToolDbUtils.storeProperties((Collection)collection, (Properties)properties, (String)string);
        }
        catch (ImmoToolDbException immoToolDbException) {
            throw immoToolDbException;
        }
        catch (Exception exception) {
            throw new ImmoToolDbException(exception.getLocalizedMessage(), (Throwable)exception);
        }
    }
}

