/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.factories.Borders;
import com.openindex.openestate.tool.ImmoToolApp;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.agency.AgencyEstate;
import com.openindex.openestate.tool.agency.AgencyExportInterface;
import com.openindex.openestate.tool.agency.AgencyExportList;
import com.openindex.openestate.tool.agency.AgencyPluginUtils;
import com.openindex.openestate.tool.agency.export.AbstractExport;
import com.openindex.openestate.tool.agency.export.AbstractExportPanel;
import com.openindex.openestate.tool.agency.export.AbstractTransport;
import com.openindex.openestate.tool.agency.export.AbstractTransportPanel;
import com.openindex.openestate.tool.agency.export.ImageExportPanel;
import com.openindex.openestate.tool.utils.FormatterRule;
import com.openindex.openestate.tool.utils.NonEmptyComboBoxRule;
import com.openindex.openestate.tool.utils.ValidationHandler;
import com.openindex.openestate.tool.utils.ValidationRule;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.LayoutStyle;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import org.apache.commons.lang.SystemUtils;
import org.apache.log4j.Logger;
import org.jdesktop.application.Action;
import org.jdesktop.application.Application;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.swingx.JXLabel;
import org.jdesktop.swingx.JXPanel;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.JXTitledSeparator;

public class AgencyExportInterfaceDialog
extends JDialog {
    private static final Logger LOGGER = Logger.getLogger(AgencyExportInterfaceDialog.class);
    public static final int OPENED = 0;
    public static final int CANCELLED = 1;
    public static final int APPROVED = 2;
    private ActionMap actionMap;
    private ResourceMap resourceMap;
    private ValidationHandler validationHandler;
    private JCheckBox interfaceActiveBox;
    private JTextField interfaceNameField;
    private JComboBox interfaceTransportField;
    private JComboBox interfaceStandardField;
    private JComboBox interfacePublishAdressField;
    private JFormattedTextField interfaceLimitField;
    private JCheckBox interfaceLimitBox;
    private Map<String, AbstractExportPanel> exportPanels;
    private Map<String, AbstractTransportPanel> transportPanels;
    private JXTitledSeparator publishTableHeader;
    private JXTable publishTable;
    private PublishTableModel publishTableModel;
    private JButton publishRemoveButton;
    private List<Long> removedPublishings;
    private int status = 0;
    private AbstractExport selectedExport = null;
    private AbstractExportPanel selectedExportPanel = null;
    private ImageExportPanel selectedExportImagePanel = null;
    private AbstractTransport selectedTransport = null;
    private AbstractTransportPanel selectedTransportPanel = null;
    private JXPanel bgPanel;
    private JButton closeButton;
    private JXPanel formPanel;
    private JXTitledSeparator formTitle;
    private JButton helpButton;
    private JXLabel infoLabel;
    private JXTitledSeparator infoTitle;
    private JPanel publishTablePanel;
    private JPanel setupImagePanel;
    private JPanel setupStandardPanel;
    private JPanel setupTransportPanel;
    private JButton submitButton;
    private JTabbedPane tabPanel;
    private JCheckBox warningAcceptBox;
    private JPanel warningPanel;
    private JScrollPane warningScroller;
    private JTextPane warningText;

    public AgencyExportInterfaceDialog() {
        this((AgencyExportInterface)null);
    }

    public AgencyExportInterfaceDialog(AgencyExportInterface agencyExportInterface) {
        super((Frame)ImmoToolApp.getApplication().getMainFrame(), true);
        this.build();
        this.load(agencyExportInterface);
    }

    private void build() {
        this.actionMap = ImmoToolUtils.getActionMap(AgencyExportInterfaceDialog.class, (Object)this);
        this.resourceMap = ImmoToolUtils.getResourceMap(AgencyExportInterfaceDialog.class);
        this.validationHandler = ImmoToolUtils.createValidationHandler();
        this.removedPublishings = new ArrayList<Long>();
        this.initComponents();
        this.buildFormPanel();
        this.buildPublishingPanel();
        this.printWarnings(null);
        this.warningPanel.setOpaque(false);
        this.warningAcceptBox.setOpaque(false);
        this.exportPanels = new HashMap<String, AbstractExportPanel>();
        this.interfaceStandardField.removeAllItems();
        this.interfaceStandardField.addItem(" [ " + this.resourceMap.getString("label.interfaceStandard.select", new Object[0]) + " ] ");
        TreeMap<String, AbstractExport> treeMap = new TreeMap<String, AbstractExport>();
        for (String object : AgencyPluginUtils.getExportNames()) {
            AbstractExport abstractExport = AgencyPluginUtils.getExport(object);
            if (abstractExport == null || abstractExport.getTitle() == null) {
                LOGGER.warn((Object)("cant load export: " + object));
                continue;
            }
            treeMap.put(abstractExport.getTitle(), abstractExport);
        }
        for (AbstractExport abstractExport : treeMap.values()) {
            this.interfaceStandardField.addItem(new ExportItem(abstractExport));
            this.exportPanels.put(abstractExport.getName(), abstractExport.createSetupPanel());
        }
        this.selectExport(null);
        this.transportPanels = new HashMap<String, AbstractTransportPanel>();
        this.interfaceTransportField.removeAllItems();
        this.interfaceTransportField.addItem(" [ " + this.resourceMap.getString("label.interfaceTransport.select", new Object[0]) + " ] ");
        TreeMap treeMap2 = new TreeMap();
        for (String string : AgencyPluginUtils.getTransportNames()) {
            AbstractTransport abstractTransport = AgencyPluginUtils.getTransport(string);
            if (abstractTransport == null || abstractTransport.getTitle() == null) {
                LOGGER.warn((Object)("cant load transport: " + string));
                continue;
            }
            treeMap2.put(abstractTransport.getTitle(), abstractTransport);
        }
        for (AbstractTransport abstractTransport : treeMap2.values()) {
            this.interfaceTransportField.addItem(new TransportItem(abstractTransport));
            this.transportPanels.put(abstractTransport.getName(), abstractTransport.createSetupPanel());
        }
        this.selectTransport(null);
        this.resourceMap.injectComponents((Component)this);
        this.tabPanel.setTitleAt(0, this.resourceMap.getString("label.interfaceTransport.tabTitle", new Object[0]));
        this.tabPanel.setTitleAt(1, this.resourceMap.getString("label.interfaceStandard.tabTitle", new Object[0]));
        this.tabPanel.setTitleAt(2, this.resourceMap.getString("label.interfaceImages.tabTitle", new Object[0]));
        this.tabPanel.setTitleAt(3, this.resourceMap.getString("label.interfacePublishings.tabTitle", new Object[0]));
        ImmoToolUtils.configureDialog((JDialog)this, (JXPanel)this.bgPanel);
        this.setLocationRelativeTo(ImmoToolApp.getApplication().getMainFrame());
        this.validationHandler.init();
        this.closeButton.setAction(this.actionMap.get(this.closeButton.getText()));
        this.submitButton.setAction(this.actionMap.get(this.submitButton.getText()));
        this.helpButton.setAction(this.actionMap.get(this.helpButton.getText()));
        this.interfaceLimitBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AgencyExportInterfaceDialog.this.setLimitEnabled(!AgencyExportInterfaceDialog.this.interfaceLimitBox.isSelected());
            }
        });
        this.interfaceTransportField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = AgencyExportInterfaceDialog.this.interfaceTransportField.getSelectedIndex();
                if (n < 1) {
                    AgencyExportInterfaceDialog.this.selectTransport(null);
                } else {
                    AbstractTransport abstractTransport = ((TransportItem)AgencyExportInterfaceDialog.this.interfaceTransportField.getItemAt(n)).getItem();
                    if (AgencyExportInterfaceDialog.this.selectedTransport == null || !AgencyExportInterfaceDialog.this.selectedTransport.getName().equals(abstractTransport.getName())) {
                        AgencyExportInterfaceDialog.this.selectTransport(abstractTransport);
                    }
                }
            }
        });
        this.interfaceStandardField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = AgencyExportInterfaceDialog.this.interfaceStandardField.getSelectedIndex();
                if (n < 1) {
                    AgencyExportInterfaceDialog.this.selectExport(null);
                } else {
                    AbstractExport abstractExport = ((ExportItem)AgencyExportInterfaceDialog.this.interfaceStandardField.getItemAt(n)).getItem();
                    if (AgencyExportInterfaceDialog.this.selectedExport == null || !AgencyExportInterfaceDialog.this.selectedExport.getName().equals(abstractExport.getName())) {
                        AgencyExportInterfaceDialog.this.selectExport(abstractExport);
                    }
                }
            }
        });
        this.publishTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (listSelectionEvent.getValueIsAdjusting()) {
                    return;
                }
                AgencyExportInterfaceDialog.this.publishRemoveButton.setEnabled(AgencyExportInterfaceDialog.this.publishTable.getSelectedRowCount() > 0);
            }
        });
        if (SystemUtils.IS_OS_MAC_OSX) {
            this.closeButton.setOpaque(false);
            this.submitButton.setOpaque(false);
            this.helpButton.setOpaque(false);
            this.tabPanel.setOpaque(true);
            this.tabPanel.setBorder(BorderFactory.createRaisedBevelBorder());
        }
    }

    private void buildFormPanel() {
        this.interfaceActiveBox = new JCheckBox();
        this.interfaceActiveBox.setName("interfaceActiveBox");
        this.interfaceActiveBox.setContentAreaFilled(false);
        this.interfaceNameField = new JTextField();
        this.interfaceNameField.setName("interfaceNameField");
        this.interfaceTransportField = new JComboBox();
        this.interfaceTransportField.setName("interfaceTransportField");
        this.interfaceStandardField = new JComboBox();
        this.interfaceStandardField.setName("interfaceStandardField");
        this.interfaceLimitField = new JFormattedTextField(NumberFormat.getIntegerInstance());
        this.interfaceLimitField.setName("interfaceLimitField");
        this.interfaceLimitBox = new JCheckBox();
        this.interfaceLimitBox.setContentAreaFilled(false);
        this.interfaceLimitBox.setName("interfaceLimitBox");
        this.interfacePublishAdressField = new JComboBox();
        this.interfacePublishAdressField.setName("interfaceStandardField");
        this.interfacePublishAdressField.addItem(this.resourceMap.getString("label.adress.default", new Object[0]));
        this.interfacePublishAdressField.addItem(this.resourceMap.getString("label.adress.never", new Object[0]));
        this.interfacePublishAdressField.addItem(this.resourceMap.getString("label.adress.always", new Object[0]));
        this.validationHandler.putRule((JComponent)this.interfaceNameField, ValidationHandler.NOT_BLANK);
        this.validationHandler.putRule((JComponent)this.interfaceLimitField, (ValidationRule)new FormatterRule(this.interfaceLimitField));
        this.validationHandler.putRule((JComponent)this.interfaceTransportField, (ValidationRule)new NonEmptyComboBoxRule(this.interfaceTransportField));
        this.validationHandler.putRule((JComponent)this.interfaceStandardField, (ValidationRule)new NonEmptyComboBoxRule(this.interfaceStandardField));
        DefaultFormBuilder defaultFormBuilder = ImmoToolUtils.createFormBuilder((String)"right:pref, 3dlu, 30dlu:grow, 3dlu, right:pref, 3dlu, 30dlu:grow");
        defaultFormBuilder.opaque(false);
        defaultFormBuilder.append(this.resourceMap.getString("label.interfaceName", new Object[0]), (Component)this.interfaceNameField, 5);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(this.resourceMap.getString("label.interfaceTransport", new Object[0]), (Component)this.interfaceTransportField);
        defaultFormBuilder.append(this.resourceMap.getString("label.adress", new Object[0]), (Component)this.interfacePublishAdressField);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(this.resourceMap.getString("label.interfaceStandard", new Object[0]), (Component)this.interfaceStandardField);
        defaultFormBuilder.append(this.resourceMap.getString("label.interfaceLimit", new Object[0]), (Component)this.interfaceLimitField);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(" ", (Component)this.interfaceActiveBox);
        defaultFormBuilder.append(" ", (Component)this.interfaceLimitBox);
        defaultFormBuilder.nextLine();
        this.formPanel.setLayout((LayoutManager)new BorderLayout());
        this.formPanel.add((Component)defaultFormBuilder.getPanel(), (Object)"Center");
        this.formPanel.revalidate();
        this.formPanel.repaint();
    }

    private void buildPublishingPanel() {
        this.publishTableHeader = ImmoToolUtils.createHead2Separator((String)this.resourceMap.getString("label.interfacePublishings", new Object[0]));
        this.publishTableHeader.setBorder(BorderFactory.createEmptyBorder(0, 0, 10, 0));
        this.publishRemoveButton = new JButton(this.actionMap.get("doRemovePublishing"));
        this.publishRemoveButton.setName("publishRemoveButton");
        this.publishRemoveButton.setEnabled(false);
        JPanel jPanel = ImmoToolUtils.buildButtonBar((JButton[])new JButton[]{this.publishRemoveButton});
        jPanel.setBorder(BorderFactory.createEmptyBorder(0, 5, 5, 0));
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)this.publishTableHeader, "Center");
        jPanel2.add((Component)jPanel, "East");
        this.publishTableModel = new PublishTableModel();
        this.publishTable = new JXTable();
        this.publishTable.setModel((TableModel)this.publishTableModel);
        ImmoToolUtils.configureTable((JXTable)this.publishTable);
        JScrollPane jScrollPane = new JScrollPane((Component)this.publishTable);
        jScrollPane.setBorder(Borders.EMPTY);
        this.publishTablePanel.setLayout(new BorderLayout());
        this.publishTablePanel.add((Component)jPanel2, "North");
        this.publishTablePanel.add((Component)jScrollPane, "Center");
        this.publishTablePanel.revalidate();
        this.publishTablePanel.repaint();
    }

    @Action
    public void doClose() {
        this.status = 1;
        this.setVisible(false);
    }

    @Action
    public void doHelp() {
        ImmoToolUtils.showHelpDialog((String)"agency.export.form", (boolean)true);
    }

    @Action
    public void doRemovePublishing() {
        if (this.publishTable.getSelectedRowCount() <= 0) {
            return;
        }
        boolean bl = ImmoToolUtils.showQuestionDialog((String)this.resourceMap.getString("question.reallyDeletePublishings", new Object[0]), (Component)this);
        if (!bl) {
            return;
        }
        ArrayList<Long> arrayList = new ArrayList<Long>();
        for (int n : this.publishTable.getSelectedRows()) {
            int n2 = this.publishTable.convertRowIndexToModel(n);
            Long l = (Long)this.publishTableModel.getValueAt(n2, 0);
            this.removedPublishings.add(l);
            arrayList.add(l);
        }
        for (int i = this.publishTable.getRowCount() - 1; i >= 0; --i) {
            int n = this.publishTable.convertRowIndexToModel(i);
            Long l = (Long)this.publishTableModel.getValueAt(n, 0);
            if (!arrayList.contains(l)) continue;
            this.publishTableModel.removeRow(n);
        }
    }

    @Action
    public void doSubmit() {
        this.validationHandler.validate();
        ArrayList<String> arrayList = new ArrayList<String>();
        if (!this.validationHandler.isValid() || this.selectedExport == null || this.selectedTransport == null) {
            arrayList.add(this.resourceMap.getString("error.generalFormIsInvalid", new Object[0]));
        }
        if (this.selectedExportPanel == null || !this.selectedExportPanel.isValidInput()) {
            arrayList.add(this.resourceMap.getString("error.standardFormlIsInvalid", new Object[0]));
        }
        if (this.selectedExportImagePanel == null || !this.selectedExportImagePanel.isValidInput()) {
            arrayList.add(this.resourceMap.getString("error.imageFormlIsInvalid", new Object[0]));
        }
        if (this.selectedTransportPanel == null || !this.selectedTransportPanel.isValidInput()) {
            arrayList.add(this.resourceMap.getString("error.transportFormlIsInvalid", new Object[0]));
        }
        if (!arrayList.isEmpty()) {
            this.printWarnings(null);
            this.warningAcceptBox.setSelected(false);
            ImmoToolUtils.showMessageErrorDialog((String)this.resourceMap.getString("message.pleaseCorrectInput", new Object[0]), arrayList);
            return;
        }
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (String string : this.selectedTransportPanel.getWarnings()) {
            arrayList2.add("<p style=\"margin-top:0; margin-bottom:5px; font-size:10px;\"><b style=\"font-size:11px;\">" + (arrayList2.size() + 1) + ". " + this.resourceMap.getString("message.warningAboutTransport", new Object[0]) + " " + this.selectedTransport.getTitle() + "</b><br>" + string + "</p>");
        }
        for (String string : this.selectedExportPanel.getWarnings()) {
            arrayList2.add("<p style=\"margin-top:0; margin-bottom:5px; font-size:10px;\"><b style=\"font-size:11px;\">" + (arrayList2.size() + 1) + ". " + this.resourceMap.getString("message.warningAboutStandard", new Object[0]) + " " + this.selectedExport.getTitle() + "</b><br>" + string + "</p>");
        }
        if (!arrayList2.isEmpty()) {
            if (!this.warningPanel.isVisible()) {
                this.printWarnings(arrayList2);
                return;
            }
            this.printWarnings(arrayList2);
            if (!this.warningAcceptBox.isSelected()) {
                ImmoToolUtils.showMessageInfoDialog((String)this.resourceMap.getString("message.pleaseCheckWarnings", new Object[0]));
                return;
            }
        }
        this.status = 2;
        this.setVisible(false);
    }

    public int getStatus() {
        return this.status;
    }

    public final void load(AgencyExportInterface agencyExportInterface) {
        Object object;
        int n;
        String string;
        this.interfaceActiveBox.setSelected(agencyExportInterface == null || agencyExportInterface.isActive());
        this.interfaceNameField.setText(agencyExportInterface != null ? agencyExportInterface.getTitle() : "");
        this.interfaceLimitBox.setSelected(agencyExportInterface == null || agencyExportInterface.getLimit() <= 0L);
        this.interfaceLimitField.setEnabled(!this.interfaceLimitBox.isSelected());
        this.interfaceLimitField.setValue(this.interfaceLimitField.isEnabled() && agencyExportInterface != null ? Long.valueOf(agencyExportInterface.getLimit()) : null);
        String string2 = string = agencyExportInterface != null ? agencyExportInterface.getAddressPublishing() : null;
        if ("never".equals(string)) {
            this.interfacePublishAdressField.setSelectedIndex(1);
        } else if ("always".equals(string)) {
            this.interfacePublishAdressField.setSelectedIndex(2);
        } else {
            this.interfacePublishAdressField.setSelectedIndex(0);
        }
        this.interfaceStandardField.setSelectedIndex(0);
        if (agencyExportInterface != null) {
            for (n = 1; n < this.interfaceStandardField.getItemCount(); ++n) {
                object = (ExportItem)this.interfaceStandardField.getItemAt(n);
                if (!((ExportItem)object).getItem().getName().equals(agencyExportInterface.getExport().getName())) continue;
                this.interfaceStandardField.setSelectedIndex(n);
                break;
            }
        }
        this.selectExport(agencyExportInterface != null ? agencyExportInterface.getExport() : null);
        this.interfaceTransportField.setSelectedIndex(0);
        if (agencyExportInterface != null) {
            for (n = 1; n < this.interfaceTransportField.getItemCount(); ++n) {
                object = (TransportItem)this.interfaceTransportField.getItemAt(n);
                if (!((TransportItem)object).getItem().getName().equals(agencyExportInterface.getTransport().getName())) continue;
                this.interfaceTransportField.setSelectedIndex(n);
                break;
            }
        }
        this.selectTransport(agencyExportInterface != null ? agencyExportInterface.getTransport() : null);
        this.publishTableModel.clear();
        this.removedPublishings.clear();
        if (agencyExportInterface != null && agencyExportInterface.getId() > 0L) {
            try {
                AgencyExportList agencyExportList = AgencyExportList.loadExportList(agencyExportInterface.getId(), "published");
                if (agencyExportList != null && !(object = agencyExportList.getEstateIds()).isEmpty()) {
                    AgencyEstate.Row[] rowArray = AgencyEstate.loadEstateRows(object.toArray(new Long[object.size()]), null, null);
                    ArrayList<Long> arrayList = new ArrayList<Long>();
                    for (AgencyEstate.Row row : rowArray) {
                        this.publishTableModel.addEstate(row);
                        arrayList.add(row.id);
                    }
                    Iterator<Long> iterator = object.iterator();
                    while (iterator.hasNext()) {
                        Long l = (Long)iterator.next();
                        if (arrayList.contains(l)) continue;
                        this.publishTableModel.addEstate(l, null, null);
                    }
                }
            }
            catch (Exception exception) {
                LOGGER.error((Object)"Can't load publishings!");
                LOGGER.error((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
            }
        }
        this.publishTable.packAll();
        this.publishTableHeader.setTitle(this.resourceMap.getString("label.interfacePublishings", new Object[0]) + " / " + this.resourceMap.getString("message.resultCount", new Object[]{this.publishTable.getRowCount()}));
        this.validationHandler.init();
    }

    private void printWarnings(List<String> list) {
        if (list == null || list.isEmpty()) {
            this.warningPanel.setVisible(false);
        } else {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("<html><head></head><body style=\"font-family:sans-serif;\">");
            for (String string : list) {
                stringBuilder.append(string);
            }
            stringBuilder.append("</body></html>");
            this.warningText.setContentType("text/html");
            this.warningText.setText(stringBuilder.toString());
            this.warningText.setCaretPosition(0);
            this.warningPanel.setVisible(true);
        }
    }

    public void save(AgencyExportInterface agencyExportInterface) {
        agencyExportInterface.setActive(this.interfaceActiveBox.isSelected());
        agencyExportInterface.setTitle(this.interfaceNameField.getText().trim());
        agencyExportInterface.setLimit(!this.interfaceLimitBox.isSelected() ? (Long)this.interfaceLimitField.getValue() : 0L);
        agencyExportInterface.setExport(this.selectedExport);
        agencyExportInterface.setTransport(this.selectedTransport);
        if (this.interfacePublishAdressField.getSelectedIndex() == 1) {
            agencyExportInterface.setAddressPublishing("never");
        } else if (this.interfacePublishAdressField.getSelectedIndex() == 2) {
            agencyExportInterface.setAddressPublishing("always");
        } else {
            agencyExportInterface.setAddressPublishing("default");
        }
        if (this.selectedExportPanel != null) {
            this.selectedExportPanel.save(agencyExportInterface.getExport());
        }
        if (this.selectedExportImagePanel != null) {
            this.selectedExportImagePanel.save(agencyExportInterface.getExport());
        }
        if (this.selectedTransportPanel != null) {
            this.selectedTransportPanel.save(agencyExportInterface.getTransport());
        }
        if (!this.removedPublishings.isEmpty() && agencyExportInterface.getId() > 0L) {
            try {
                AgencyExportList agencyExportList = AgencyExportList.loadExportList(agencyExportInterface.getId(), "published");
                if (agencyExportList != null) {
                    for (Long l : this.removedPublishings) {
                        if (agencyExportList.getEstateValueMap().containsKey(l)) {
                            agencyExportList.getEstateValueMap().remove(l);
                        }
                        if (!agencyExportList.getEstateNrMap().containsKey(l)) continue;
                        agencyExportList.getEstateNrMap().remove(l);
                    }
                    AgencyExportList.storeExportList(agencyExportList);
                }
            }
            catch (Exception exception) {
                LOGGER.error((Object)"Can't load publishings!");
                LOGGER.error((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
            }
        }
    }

    private void selectExport(AbstractExport abstractExport) {
        JScrollPane jScrollPane;
        this.selectedExport = abstractExport;
        this.selectedExportPanel = null;
        this.selectedExportImagePanel = null;
        JXTitledSeparator jXTitledSeparator = null;
        JXTitledSeparator jXTitledSeparator2 = null;
        if (this.selectedExport == null) {
            jXTitledSeparator = ImmoToolUtils.createHead2Separator((String)this.resourceMap.getString("message.noStandardSelected", new Object[0]));
            jXTitledSeparator2 = ImmoToolUtils.createHead2Separator((String)this.resourceMap.getString("message.noStandardSelected", new Object[0]));
        } else {
            jXTitledSeparator = ImmoToolUtils.createHead2Separator((String)this.resourceMap.getString("message.selectedStandard", new Object[]{this.selectedExport.getTitle()}));
            this.selectedExportPanel = this.exportPanels.get(this.selectedExport.getName());
            this.selectedExportPanel.load(this.selectedExport);
            jXTitledSeparator2 = ImmoToolUtils.createHead2Separator((String)this.resourceMap.getString("message.selectedImageOptions", new Object[]{this.selectedExport.getTitle()}));
            this.selectedExportImagePanel = new ImageExportPanel();
            this.selectedExportImagePanel.load(this.selectedExport);
        }
        jXTitledSeparator.setBorder(BorderFactory.createEmptyBorder(0, 0, 10, 0));
        jXTitledSeparator2.setBorder(BorderFactory.createEmptyBorder(0, 0, 10, 0));
        JPanel jPanel = (JPanel)this.tabPanel.getComponentAt(1);
        jPanel.removeAll();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)jXTitledSeparator, "North");
        if (this.selectedExportPanel != null) {
            jScrollPane = new JScrollPane(this.selectedExportPanel);
            jScrollPane.setBorder(Borders.EMPTY);
            jPanel.add((Component)jScrollPane, "Center");
        }
        jPanel.revalidate();
        jPanel.repaint();
        jPanel = (JPanel)this.tabPanel.getComponentAt(2);
        jPanel.removeAll();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)jXTitledSeparator2, "North");
        if (this.selectedExportImagePanel != null) {
            jScrollPane = new JScrollPane(this.selectedExportImagePanel);
            jScrollPane.setBorder(Borders.EMPTY);
            jPanel.add((Component)jScrollPane, "Center");
        }
        jPanel.revalidate();
        jPanel.repaint();
    }

    private void selectTransport(AbstractTransport abstractTransport) {
        this.selectedTransport = abstractTransport;
        this.selectedTransportPanel = null;
        JXTitledSeparator jXTitledSeparator = null;
        if (this.selectedTransport == null) {
            jXTitledSeparator = ImmoToolUtils.createHead2Separator((String)this.resourceMap.getString("message.noTransportSelected", new Object[0]));
        } else {
            jXTitledSeparator = ImmoToolUtils.createHead2Separator((String)this.resourceMap.getString("message.selectedTransport", new Object[]{this.selectedTransport.getTitle()}));
            this.selectedTransportPanel = this.transportPanels.get(this.selectedTransport.getName());
            this.selectedTransportPanel.load(this.selectedTransport);
        }
        jXTitledSeparator.setBorder(BorderFactory.createEmptyBorder(0, 0, 10, 0));
        JPanel jPanel = (JPanel)this.tabPanel.getComponentAt(0);
        jPanel.removeAll();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)jXTitledSeparator, "North");
        if (this.selectedTransportPanel != null) {
            JScrollPane jScrollPane = new JScrollPane(this.selectedTransportPanel);
            jScrollPane.setBorder(Borders.EMPTY);
            jPanel.add((Component)jScrollPane, "Center");
        }
        jPanel.revalidate();
        jPanel.repaint();
    }

    private void setLimitEnabled(boolean bl) {
        this.interfaceLimitBox.setSelected(!bl);
        this.interfaceLimitField.setEnabled(bl);
        this.validationHandler.validate((JComponent)this.interfaceLimitField);
    }

    private void initComponents() {
        this.bgPanel = new JXPanel();
        this.infoTitle = ImmoToolUtils.createHead1Separator((String)"");
        this.infoLabel = new JXLabel();
        this.formTitle = ImmoToolUtils.createHead2Separator((String)"");
        this.formPanel = new JXPanel();
        this.tabPanel = new JTabbedPane();
        this.setupTransportPanel = new JPanel();
        this.setupStandardPanel = new JPanel();
        this.setupImagePanel = new JPanel();
        this.publishTablePanel = new JPanel();
        this.warningPanel = new JPanel();
        this.warningScroller = new JScrollPane();
        this.warningText = new JTextPane();
        this.warningAcceptBox = new JCheckBox();
        this.helpButton = new JButton();
        this.submitButton = new JButton();
        this.closeButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setName("Form");
        this.bgPanel.setName("bgPanel");
        this.infoTitle.setName("infoTitle");
        this.infoLabel.setIconTextGap(10);
        this.infoLabel.setLineWrap(true);
        this.infoLabel.setName("infoLabel");
        this.formTitle.setName("formTitle");
        this.formPanel.setName("formPanel");
        this.formPanel.setOpaque(false);
        GroupLayout groupLayout = new GroupLayout((Container)this.formPanel);
        this.formPanel.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 586, Short.MAX_VALUE));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 54, Short.MAX_VALUE));
        this.tabPanel.setName("tabPanel");
        this.setupTransportPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.setupTransportPanel.setName("setupTransportPanel");
        GroupLayout groupLayout2 = new GroupLayout(this.setupTransportPanel);
        this.setupTransportPanel.setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 561, Short.MAX_VALUE));
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 242, Short.MAX_VALUE));
        ResourceMap resourceMap = Application.getInstance().getContext().getResourceMap(AgencyExportInterfaceDialog.class);
        this.tabPanel.addTab(resourceMap.getString("setupTransportPanel.TabConstraints.tabTitle", new Object[0]), this.setupTransportPanel);
        this.setupStandardPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.setupStandardPanel.setName("setupStandardPanel");
        GroupLayout groupLayout3 = new GroupLayout(this.setupStandardPanel);
        this.setupStandardPanel.setLayout(groupLayout3);
        groupLayout3.setHorizontalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 561, Short.MAX_VALUE));
        groupLayout3.setVerticalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 242, Short.MAX_VALUE));
        this.tabPanel.addTab(resourceMap.getString("setupStandardPanel.TabConstraints.tabTitle", new Object[0]), this.setupStandardPanel);
        this.setupImagePanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.setupImagePanel.setName("setupImagePanel");
        GroupLayout groupLayout4 = new GroupLayout(this.setupImagePanel);
        this.setupImagePanel.setLayout(groupLayout4);
        groupLayout4.setHorizontalGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 561, Short.MAX_VALUE));
        groupLayout4.setVerticalGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 242, Short.MAX_VALUE));
        this.tabPanel.addTab(resourceMap.getString("setupImagePanel.TabConstraints.tabTitle", new Object[0]), this.setupImagePanel);
        this.publishTablePanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.publishTablePanel.setName("publishTablePanel");
        GroupLayout groupLayout5 = new GroupLayout(this.publishTablePanel);
        this.publishTablePanel.setLayout(groupLayout5);
        groupLayout5.setHorizontalGroup(groupLayout5.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 561, Short.MAX_VALUE));
        groupLayout5.setVerticalGroup(groupLayout5.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 242, Short.MAX_VALUE));
        this.tabPanel.addTab(resourceMap.getString("publishTablePanel.TabConstraints.tabTitle", new Object[0]), this.publishTablePanel);
        this.warningPanel.setName("warningPanel");
        this.warningScroller.setBorder(BorderFactory.createLineBorder(resourceMap.getColor("warningScroller.border.lineColor"), 2));
        this.warningScroller.setName("warningScroller");
        this.warningText.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        this.warningText.setEditable(false);
        this.warningText.setName("warningText");
        this.warningScroller.setViewportView(this.warningText);
        this.warningAcceptBox.setName("warningAcceptBox");
        GroupLayout groupLayout6 = new GroupLayout(this.warningPanel);
        this.warningPanel.setLayout(groupLayout6);
        groupLayout6.setHorizontalGroup(groupLayout6.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.warningAcceptBox, -1, 586, Short.MAX_VALUE).addComponent(this.warningScroller, GroupLayout.Alignment.TRAILING, -1, 586, Short.MAX_VALUE));
        groupLayout6.setVerticalGroup(groupLayout6.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout6.createSequentialGroup().addComponent(this.warningScroller, -1, 86, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.warningAcceptBox)));
        this.helpButton.setText("doHelp");
        this.helpButton.setName("helpButton");
        this.submitButton.setText("doSubmit");
        this.submitButton.setName("submitButton");
        this.closeButton.setText("doClose");
        this.closeButton.setName("closeButton");
        GroupLayout groupLayout7 = new GroupLayout((Container)this.bgPanel);
        this.bgPanel.setLayout((LayoutManager)groupLayout7);
        groupLayout7.setHorizontalGroup(groupLayout7.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout7.createSequentialGroup().addContainerGap().addGroup(groupLayout7.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.tabPanel, GroupLayout.Alignment.LEADING, -1, 586, Short.MAX_VALUE).addComponent((Component)this.formPanel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent((Component)this.formTitle, GroupLayout.Alignment.LEADING, -1, 586, Short.MAX_VALUE).addComponent((Component)this.infoLabel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent((Component)this.infoTitle, GroupLayout.Alignment.LEADING, -1, 586, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.LEADING, groupLayout7.createSequentialGroup().addComponent(this.helpButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 304, Short.MAX_VALUE).addComponent(this.submitButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.closeButton)).addComponent(this.warningPanel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        groupLayout7.setVerticalGroup(groupLayout7.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout7.createSequentialGroup().addContainerGap().addComponent((Component)this.infoTitle, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.infoLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent((Component)this.formTitle, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.formPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.tabPanel, -1, 307, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.warningPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout7.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.closeButton).addComponent(this.submitButton).addComponent(this.helpButton)).addContainerGap()));
        GroupLayout groupLayout8 = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(groupLayout8);
        groupLayout8.setHorizontalGroup(groupLayout8.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.bgPanel, -1, -1, Short.MAX_VALUE));
        groupLayout8.setVerticalGroup(groupLayout8.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.bgPanel, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    private static final class PublishTableModel
    extends DefaultTableModel {
        public static final int COLUMN_ID = 0;
        public static final int COLUMN_NR = 1;
        public static final int COLUMN_TITLE = 2;
        private static final Map<Integer, String> COLUMN_NAMES = new HashMap<Integer, String>();
        private static final Map<Integer, Class> COLUMN_CLASSES;
        private ResourceMap resourceMap = ImmoToolUtils.getResourceMap(AgencyExportInterfaceDialog.class);

        public PublishTableModel() {
            this.setColumnCount(COLUMN_NAMES.size());
            this.clear();
        }

        public void addEstate(AgencyEstate.Row row) {
            this.addRow(this.buildRow(row.id, row.publicId, row.title));
        }

        public void addEstate(Long l, String string, String string2) {
            this.addRow(this.buildRow(l, string, string2));
        }

        private Object[] buildRow(Long l, String string, String string2) {
            TreeMap<Integer, Object> treeMap = new TreeMap<Integer, Object>();
            treeMap.put(0, l);
            treeMap.put(1, string);
            treeMap.put(2, string2);
            return treeMap.values().toArray(new Object[treeMap.size()]);
        }

        public void clear() {
            while (this.getRowCount() > 0) {
                this.removeRow(0);
            }
        }

        public Class getColumnClass(int n) {
            return COLUMN_CLASSES.containsKey(n) ? COLUMN_CLASSES.get(n) : null;
        }

        @Override
        public String getColumnName(int n) {
            return COLUMN_NAMES.containsKey(n) ? this.resourceMap.getString(COLUMN_NAMES.get(n), new Object[0]) : null;
        }

        public Long getEstateIdAt(int n) {
            int n2 = n;
            return (Long)this.getValueAt(n2, 0);
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        static {
            COLUMN_NAMES.put(0, "publishTable.col.id");
            COLUMN_NAMES.put(1, "publishTable.col.nr");
            COLUMN_NAMES.put(2, "publishTable.col.title");
            COLUMN_CLASSES = new HashMap<Integer, Class>();
            COLUMN_CLASSES.put(0, Long.class);
            COLUMN_CLASSES.put(1, String.class);
            COLUMN_CLASSES.put(2, String.class);
        }
    }

    private static final class TransportItem {
        private AbstractTransport transportItem = null;

        public TransportItem(AbstractTransport abstractTransport) {
            this.transportItem = abstractTransport;
        }

        public AbstractTransport getItem() {
            return this.transportItem;
        }

        public String toString() {
            return " " + this.transportItem.getTitle();
        }
    }

    private static final class ExportItem {
        private AbstractExport exportItem = null;

        public ExportItem(AbstractExport abstractExport) {
            this.exportItem = abstractExport;
        }

        public AbstractExport getItem() {
            return this.exportItem;
        }

        public String toString() {
            return " " + this.exportItem.getTitle();
        }
    }
}

