/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency;

import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.agency.AgencyExportInterface;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.table.DefaultTableModel;
import org.jdesktop.application.ResourceMap;

public class AgencyExportInterfaceTableModel
extends DefaultTableModel {
    public static final int COLUMN_ACTIVE = 0;
    public static final int COLUMN_ID = 1;
    public static final int COLUMN_TITLE = 2;
    public static final int COLUMN_TRANSFER = 3;
    public static final int COLUMN_STANDARD = 4;
    public static final int COLUMN_LIMIT = 5;
    public static final int COLUMN_INCREMENTAL = 6;
    private static final Map<Integer, String> COLUMN_NAMES = new HashMap<Integer, String>();
    private static final Map<Integer, Class> COLUMN_CLASSES;
    private final ResourceMap resourceMap;

    public AgencyExportInterfaceTableModel() {
        this.setColumnCount(COLUMN_NAMES.size());
        this.resourceMap = ImmoToolUtils.getResourceMap(AgencyExportInterfaceTableModel.class);
    }

    public void addExportInterface(AgencyExportInterface agencyExportInterface) {
        this.addRow(this.buildRow(agencyExportInterface));
    }

    private Object[] buildRow(AgencyExportInterface agencyExportInterface) {
        TreeMap<Integer, Object> treeMap = new TreeMap<Integer, Object>();
        treeMap.put(0, agencyExportInterface.isActive());
        treeMap.put(1, agencyExportInterface.getId());
        treeMap.put(2, agencyExportInterface.getTitle());
        treeMap.put(3, agencyExportInterface.getTransport() != null ? agencyExportInterface.getTransport().getTitle() : null);
        treeMap.put(4, agencyExportInterface.getExport() != null ? agencyExportInterface.getExport().getTitle() : null);
        treeMap.put(6, agencyExportInterface.getExport() != null && agencyExportInterface.getExport().isIncremental());
        treeMap.put(5, agencyExportInterface.getLimit() > 0L ? agencyExportInterface.getLimit() : 0L);
        return treeMap.values().toArray(new Object[treeMap.size()]);
    }

    public void clear() {
        while (this.getRowCount() > 0) {
            this.removeRow(0);
        }
    }

    public Class getColumnClass(int n) {
        return COLUMN_CLASSES.containsKey(n) ? COLUMN_CLASSES.get(n) : null;
    }

    @Override
    public String getColumnName(int n) {
        return COLUMN_NAMES.containsKey(n) ? this.resourceMap.getString(COLUMN_NAMES.get(n), new Object[0]) : null;
    }

    public Long getExportInterfaceIdAt(int n) {
        return (Long)this.getValueAt(n, 1);
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return n2 == 0;
    }

    public boolean isRowActive(int n) {
        return (Boolean)this.getValueAt(n, 0);
    }

    static {
        COLUMN_NAMES.put(0, "col.active");
        COLUMN_NAMES.put(1, "col.id");
        COLUMN_NAMES.put(2, "col.title");
        COLUMN_NAMES.put(3, "col.transfer");
        COLUMN_NAMES.put(4, "col.standard");
        COLUMN_NAMES.put(6, "col.incremental");
        COLUMN_NAMES.put(5, "col.limit");
        COLUMN_CLASSES = new HashMap<Integer, Class>();
        COLUMN_CLASSES.put(0, Boolean.class);
        COLUMN_CLASSES.put(1, Long.class);
        COLUMN_CLASSES.put(2, String.class);
        COLUMN_CLASSES.put(3, String.class);
        COLUMN_CLASSES.put(4, String.class);
        COLUMN_CLASSES.put(6, Boolean.class);
        COLUMN_CLASSES.put(5, Long.class);
    }
}

