/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency;

import com.openindex.openestate.tool.ImmoToolDbException;
import com.openindex.openestate.tool.ImmoToolDbUtils;
import com.openindex.openestate.tool.ImmoToolException;
import com.openindex.openestate.tool.agency.AgencyEstate;
import com.openindex.openestate.tool.agency.AgencyExportInterface;
import com.openindex.openestate.tool.agency.AgencyExportSummary;
import com.openindex.openestate.tool.agency.AgencyPluginUtils;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.log4j.Logger;
import org.xmldb.api.base.Collection;

public class AgencyExportList {
    private static final Logger LOGGER = Logger.getLogger(AgencyExportList.class);
    public static final String KEY_ESTATE_ID = "estate.id";
    public static final String LIST_CHANGED = "changed";
    public static final String LIST_PUBLISHED = "published";
    public static final String CHANGE_DELETE = "delete";
    public static final String CHANGE_UPDATE = "update";
    private Map<Long, String> estataValueMap = new HashMap<Long, String>();
    private Map<Long, String> estateNrMap = new HashMap<Long, String>();
    private long interfaceId = 0L;
    private String name = null;

    protected AgencyExportList() {
    }

    public static AgencyExportList buildExportList(long l, String string) throws ImmoToolException {
        AgencyExportList agencyExportList = new AgencyExportList();
        agencyExportList.setInterfaceId(l);
        agencyExportList.setName(string);
        return agencyExportList;
    }

    public Set<Long> getEstateIds() {
        return this.estataValueMap.keySet();
    }

    public String getEstatePublicId(long l) {
        return this.estateNrMap.containsKey(l) ? this.estateNrMap.get(l) : null;
    }

    public String getEstateValue(long l) {
        return this.estataValueMap.containsKey(l) ? this.estataValueMap.get(l) : null;
    }

    public Map<Long, String> getEstateNrMap() {
        return this.estateNrMap;
    }

    public Map<Long, String> getEstateValueMap() {
        return this.estataValueMap;
    }

    public long getInterfaceId() {
        return this.interfaceId;
    }

    public String getName() {
        return this.name;
    }

    public boolean hasEstateId(Long l) {
        return this.estataValueMap.containsKey(l);
    }

    public void load(Properties properties) throws ImmoToolException {
        if (properties == null) {
            return;
        }
        this.estateNrMap.clear();
        this.estataValueMap.clear();
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            Long l;
            String string = (String)enumeration.nextElement();
            if (string.startsWith("nr.")) {
                l = Long.valueOf(string.substring(3));
                this.estateNrMap.put(l, properties.getProperty(string));
                continue;
            }
            if (string.startsWith("id.")) {
                l = Long.valueOf(string.substring(3));
                this.estataValueMap.put(l, properties.getProperty(string));
                continue;
            }
            l = Long.valueOf(string);
            this.estataValueMap.put(l, properties.getProperty(string));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AgencyExportList loadExportList(long l, String string) throws ImmoToolDbException {
        Collection collection = null;
        try {
            collection = AgencyPluginUtils.openPluginCollection("/exports");
            AgencyExportList agencyExportList = AgencyExportList.loadExportList(l, string, collection);
            return agencyExportList;
        }
        finally {
            ImmoToolDbUtils.close((Collection)collection);
        }
    }

    public static AgencyExportList loadExportList(long l, String string, Collection collection) throws ImmoToolDbException {
        try {
            String string2 = "ExportInterface." + l + "." + string + ".xml";
            if (!ImmoToolDbUtils.hasResource((Collection)collection, (String)string2)) {
                return null;
            }
            Properties properties = ImmoToolDbUtils.loadProperties((Collection)collection, (String)string2);
            if (properties == null) {
                return null;
            }
            AgencyExportList agencyExportList = AgencyExportList.buildExportList(l, string);
            agencyExportList.load(properties);
            return agencyExportList;
        }
        catch (ImmoToolDbException immoToolDbException) {
            throw immoToolDbException;
        }
        catch (Exception exception) {
            throw new ImmoToolDbException(exception.getLocalizedMessage(), (Throwable)exception);
        }
    }

    public static void registerChanges(AgencyEstate agencyEstate, String string) throws ImmoToolException {
        AgencyExportList.registerChanges(agencyEstate, string, !agencyEstate.isExportAlways() ? agencyEstate.getExportIntefaces() : null);
    }

    public static void registerChanges(AgencyEstate agencyEstate, String string, Long[] longArray) throws ImmoToolException {
        if (agencyEstate == null) {
            throw new NullPointerException("empty estate!");
        }
        Long l = agencyEstate.getIdNr();
        if (l == null) {
            throw new ImmoToolException("unsaved estate!");
        }
        AgencyExportList.registerChanges(l, agencyEstate.getPublicId(), string, longArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerChanges(Long l, String string, String string2, Long[] longArray) throws ImmoToolException {
        if (!CHANGE_DELETE.equalsIgnoreCase(string2) && !CHANGE_UPDATE.equalsIgnoreCase(string2)) {
            throw new IllegalArgumentException("invalid change-mode: " + string2);
        }
        Collection collection = null;
        try {
            collection = AgencyPluginUtils.openPluginCollection("/exports");
            if (longArray == null) {
                for (AgencyExportInterface agencyExportInterface : AgencyExportInterface.loadExportInterfaces(collection)) {
                    if (!agencyExportInterface.getExport().supportsIncrementalUpdate()) continue;
                    AgencyExportList.registerChange(l, string, string2, agencyExportInterface.getId(), collection);
                }
            } else {
                HashMap<Long, Boolean> hashMap = new HashMap<Long, Boolean>();
                for (Long l2 : longArray) {
                    if (!hashMap.containsKey(l2)) {
                        AgencyExportInterface agencyExportInterface = AgencyExportInterface.loadExportInterface(l2, collection);
                        if (agencyExportInterface == null) {
                            LOGGER.error((Object)("unknown export-interface #" + l2));
                            continue;
                        }
                        hashMap.put(l2, agencyExportInterface.getExport().supportsIncrementalUpdate());
                    }
                    if (!((Boolean)hashMap.get(l2)).booleanValue()) continue;
                    AgencyExportList.registerChange(l, string, string2, l2, collection);
                }
            }
        }
        finally {
            ImmoToolDbUtils.close((Collection)collection);
        }
    }

    public static void registerChange(Long l, String string, String string2, Long l2, Collection collection) throws ImmoToolException {
        if (l2 <= 0L) {
            LOGGER.warn((Object)("invalid export-interface #" + l2));
            return;
        }
        AgencyExportList agencyExportList = AgencyExportList.loadExportList(l2, LIST_CHANGED, collection);
        if (agencyExportList == null) {
            agencyExportList = AgencyExportList.buildExportList(l2, LIST_CHANGED);
        }
        if (CHANGE_DELETE.equalsIgnoreCase(string2)) {
            AgencyExportList agencyExportList2 = AgencyExportList.loadExportList(l2, LIST_PUBLISHED, collection);
            if (agencyExportList2 == null || !agencyExportList2.getEstateIds().contains(l)) {
                if (!agencyExportList.getEstateValueMap().containsKey(l)) {
                    return;
                }
                agencyExportList.getEstateValueMap().remove(l);
                if (agencyExportList.getEstateNrMap().containsKey(l)) {
                    agencyExportList.getEstateNrMap().remove(l);
                }
            } else {
                agencyExportList.getEstateValueMap().put(l, CHANGE_DELETE);
                if (string != null && string.trim().length() > 0) {
                    agencyExportList.getEstateNrMap().put(l, string);
                }
            }
        } else {
            agencyExportList.getEstateValueMap().put(l, string2);
            if (string != null && string.trim().length() > 0) {
                agencyExportList.getEstateNrMap().put(l, string);
            }
        }
        AgencyExportList.storeExportList(agencyExportList, collection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerSummary(AgencyExportSummary agencyExportSummary) throws ImmoToolException {
        if (agencyExportSummary == null) {
            throw new NullPointerException("empty summary!");
        }
        Collection collection = null;
        try {
            collection = AgencyPluginUtils.openPluginCollection("/exports");
            AgencyExportList agencyExportList = AgencyExportList.loadExportList(agencyExportSummary.getInterfaceId(), LIST_PUBLISHED, collection);
            if (agencyExportList == null) {
                agencyExportList = AgencyExportList.buildExportList(agencyExportSummary.getInterfaceId(), LIST_PUBLISHED);
            } else if (agencyExportSummary.isFullTransfer()) {
                agencyExportList.getEstateValueMap().clear();
                agencyExportList.getEstateNrMap().clear();
            }
            for (Long l : agencyExportSummary.getUpdatedEstateIds()) {
                if (agencyExportSummary.getErrorEstateMap().containsKey(l)) continue;
                agencyExportList.getEstateValueMap().put(l, String.valueOf(agencyExportSummary.getTime().getTime()));
            }
            for (Long l : agencyExportSummary.getRemovedEstateIds()) {
                if (!agencyExportList.getEstateValueMap().containsKey(l)) continue;
                agencyExportList.getEstateValueMap().remove(l);
            }
            AgencyExportList.storeExportList(agencyExportList, collection);
        }
        finally {
            ImmoToolDbUtils.close((Collection)collection);
        }
    }

    public void save(Properties properties) throws ImmoToolException {
        if (properties == null) {
            return;
        }
        for (Long l : this.getEstateIds()) {
            properties.setProperty("id." + l.toString(), this.getEstateValue(l));
        }
        for (Long l : this.estateNrMap.keySet()) {
            properties.setProperty("nr." + l.toString(), this.estateNrMap.get(l));
        }
    }

    public void setInterfaceId(long l) {
        this.interfaceId = l;
    }

    protected void setName(String string) {
        this.name = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void storeExportList(AgencyExportList agencyExportList) throws ImmoToolDbException {
        Collection collection = null;
        try {
            collection = AgencyPluginUtils.openPluginCollection("/exports");
            AgencyExportList.storeExportList(agencyExportList, collection);
        }
        finally {
            ImmoToolDbUtils.close((Collection)collection);
        }
    }

    public static void storeExportList(AgencyExportList agencyExportList, Collection collection) throws ImmoToolDbException {
        try {
            String string = "ExportInterface." + agencyExportList.getInterfaceId() + "." + agencyExportList.getName() + ".xml";
            Properties properties = new Properties();
            agencyExportList.save(properties);
            ImmoToolDbUtils.storeProperties((Collection)collection, (Properties)properties, (String)string);
        }
        catch (ImmoToolDbException immoToolDbException) {
            throw immoToolDbException;
        }
        catch (Exception exception) {
            throw new ImmoToolDbException(exception.getLocalizedMessage(), (Throwable)exception);
        }
    }
}

