/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency;

import com.openindex.openestate.tool.ImmoToolException;
import com.openindex.openestate.tool.ImmoToolTabPanel;
import com.openindex.openestate.tool.ImmoToolTask;
import com.openindex.openestate.tool.ImmoToolTaskDialog;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.agency.AgencyExportInterface;
import com.openindex.openestate.tool.agency.AgencyExportInterfaceDialog;
import com.openindex.openestate.tool.agency.AgencyExportInterfaceTableModel;
import com.openindex.openestate.tool.agency.AgencyExportSummaryTablePanel;
import com.openindex.openestate.tool.agency.AgencyExportTaskContainer;
import com.openindex.openestate.tool.utils.DisabledTableCellRenderer;
import com.openindex.openestate.tool.utils.TabComponent;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.FileInputStream;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import javax.swing.ActionMap;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.apache.log4j.Logger;
import org.jdesktop.application.Action;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.application.Task;
import org.jdesktop.swingx.JXLabel;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.JXTitledSeparator;

public class AgencyExportPanel
extends ImmoToolTabPanel {
    private static final Logger LOGGER = Logger.getLogger(AgencyExportPanel.class);
    private ActionMap actionMap;
    private ResourceMap resourceMap;
    private JPopupMenu interfacePopupMenu;
    private AgencyExportInterfaceTableModel exportTableModel;
    private JButton closeButton;
    private JButton exportButton;
    private JXTable exportTable;
    private JScrollPane exportTableScroller;
    private JButton helpButton;
    private JXLabel infoLabel;
    private JXTitledSeparator infoTitle;
    private JButton interfaceActionButton;
    private JButton interfaceCreateButton;
    private JButton interfaceImportButton;
    private JXTitledSeparator interfaceTitle;
    private JButton refreshButton;
    private JToggleButton selectAllButton;
    private JButton showSummaryButton;

    public AgencyExportPanel() {
        this.build();
    }

    private void build() {
        this.actionMap = ImmoToolUtils.getActionMap(AgencyExportPanel.class, (Object)((Object)this));
        this.resourceMap = ImmoToolUtils.getResourceMap(AgencyExportPanel.class);
        this.initComponents();
        this.resourceMap.injectComponents((Component)((Object)this));
        this.exportTableModel = new AgencyExportInterfaceTableModel();
        this.exportTable.setModel((TableModel)this.exportTableModel);
        this.exportTable.setSortable(true);
        this.exportTable.getSelectionModel().setSelectionMode(2);
        this.exportTable.getColumn(0).setMaxWidth(40);
        this.exportTable.getColumn(0).setMinWidth(40);
        this.exportTable.getColumn(6).setCellRenderer((TableCellRenderer)new DisabledTableCellRenderer(this.exportTable.getDefaultRenderer(Boolean.class)));
        this.exportTable.packAll();
        this.exportTable.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getButton() == 1 && mouseEvent.getClickCount() == 2) {
                    int n = AgencyExportPanel.this.exportTable.getSelectedRow();
                    if (n < 0) {
                        return;
                    }
                    Task task = AgencyExportPanel.this.doInterfaceModify();
                    if (task != null) {
                        ImmoToolUtils.executeTask((Task)task);
                    }
                } else if (mouseEvent.getButton() == 3 && mouseEvent.getClickCount() == 1) {
                    int n;
                    if (AgencyExportPanel.this.exportTable.getSelectedRow() < 0 && (n = AgencyExportPanel.this.exportTable.rowAtPoint(mouseEvent.getPoint())) >= 0) {
                        AgencyExportPanel.this.exportTable.getSelectionModel().setSelectionInterval(n, n);
                    }
                    if (AgencyExportPanel.this.exportTable.getSelectedRow() < 0) {
                        return;
                    }
                    AgencyExportPanel.this.interfacePopupMenu.show((Component)AgencyExportPanel.this.exportTable, ((AgencyExportPanel)AgencyExportPanel.this).exportTable.getMousePosition().x, ((AgencyExportPanel)AgencyExportPanel.this).exportTable.getMousePosition().y);
                }
            }
        });
        this.exportTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                AgencyExportPanel.this.interfaceActionButton.setEnabled(AgencyExportPanel.this.exportTable.getSelectedRow() >= 0);
            }
        });
        ImmoToolUtils.configureTable((JXTable)this.exportTable);
        this.closeButton.setAction(this.actionMap.get(this.closeButton.getText()));
        this.exportButton.setAction(this.actionMap.get(this.exportButton.getText()));
        this.refreshButton.setAction(this.actionMap.get(this.refreshButton.getText()));
        this.helpButton.setAction(this.actionMap.get(this.helpButton.getText()));
        this.showSummaryButton.setAction(this.actionMap.get(this.showSummaryButton.getText()));
        this.selectAllButton.setAction(this.actionMap.get(this.selectAllButton.getText()));
        this.interfaceCreateButton.setAction(this.actionMap.get(this.interfaceCreateButton.getText()));
        this.interfaceImportButton.setAction(this.actionMap.get(this.interfaceImportButton.getText()));
        this.interfaceActionButton.setAction(this.actionMap.get(this.interfaceActionButton.getText()));
        this.interfaceActionButton.setEnabled(false);
        this.interfacePopupMenu = new JPopupMenu();
        this.interfacePopupMenu.add(new JMenuItem(this.actionMap.get("doInterfaceModify")));
        this.interfacePopupMenu.add(new JMenuItem(this.actionMap.get("doInterfaceRemove")));
        this.interfacePopupMenu.addSeparator();
        this.interfacePopupMenu.add(new JMenuItem(this.actionMap.get("doInterfaceEnable")));
        this.interfacePopupMenu.add(new JMenuItem(this.actionMap.get("doInterfaceDisable")));
    }

    public AgencyExportInterfaceTableModel getExportTableModel() {
        return this.exportTableModel;
    }

    public static String getInstanceTabTitle() {
        return ImmoToolUtils.getResourceMap(AgencyExportPanel.class).getString("tabTitle", new Object[0]);
    }

    public String getTabInfo() {
        return this.resourceMap.getString("tabInfo", new Object[0]);
    }

    public String getTabTitle() {
        return AgencyExportPanel.getInstanceTabTitle();
    }

    public void refresh() throws ImmoToolException {
        this.selectAllButton.setSelected(false);
        this.exportTable.editingStopped(new ChangeEvent(this.exportTable));
        this.exportTable.getSelectionModel().clearSelection();
        this.exportTableModel.clear();
        try {
            for (AgencyExportInterface agencyExportInterface : AgencyExportInterface.loadExportInterfaces()) {
                this.exportTableModel.addExportInterface(agencyExportInterface);
            }
            this.exportTable.packAll();
        }
        catch (Exception exception) {
            LOGGER.error((Object)"could not load export-interfaces!");
            LOGGER.error((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
            throw new ImmoToolException(exception.getLocalizedMessage(), (Throwable)exception);
        }
        this.interfaceTitle.setTitle(this.resourceMap.getString("interfaceTitle.title", new Object[0]) + " / " + this.resourceMap.getString("message.resultCount", new Object[]{NumberFormat.getIntegerInstance().format(this.exportTable.getRowCount())}));
    }

    public void refreshTab() {
        ImmoToolUtils.executeTask((Task)this.doRefresh());
    }

    private void initComponents() {
        this.exportButton = new JButton();
        this.showSummaryButton = new JButton();
        this.helpButton = new JButton();
        this.closeButton = new JButton();
        this.infoLabel = new JXLabel();
        this.interfaceTitle = ImmoToolUtils.createHead2Separator((String)"");
        this.refreshButton = new JButton();
        this.interfaceCreateButton = new JButton();
        this.interfaceImportButton = new JButton();
        this.interfaceActionButton = new JButton();
        this.exportTableScroller = new JScrollPane();
        this.exportTable = new JXTable();
        this.infoTitle = ImmoToolUtils.createHead1Separator((String)"");
        this.selectAllButton = new JToggleButton();
        this.setName("Form");
        this.exportButton.setText("doExport");
        this.exportButton.setName("exportButton");
        this.showSummaryButton.setText("doShowSummary");
        this.showSummaryButton.setName("showSummaryButton");
        this.helpButton.setText("doHelp");
        this.helpButton.setName("helpButton");
        this.closeButton.setText("doClose");
        this.closeButton.setName("closeButton");
        this.infoLabel.setText("infoLabel");
        this.infoLabel.setIconTextGap(10);
        this.infoLabel.setLineWrap(true);
        this.infoLabel.setName("infoLabel");
        this.interfaceTitle.setName("interfaceTitle");
        this.interfaceTitle.setTitle("interfaceTitle");
        this.refreshButton.setText("doRefresh");
        this.refreshButton.setName("refreshButton");
        this.interfaceCreateButton.setText("doInterfaceCreate");
        this.interfaceCreateButton.setName("interfaceCreateButton");
        this.interfaceImportButton.setText("doInterfaceImport");
        this.interfaceImportButton.setName("interfaceImportButton");
        this.interfaceActionButton.setText("doInterfaceAction");
        this.interfaceActionButton.setName("interfaceActionButton");
        this.exportTableScroller.setName("exportTableScroller");
        this.exportTable.setModel((TableModel)new DefaultTableModel(new Object[0][], new String[0]));
        this.exportTable.setName("exportTable");
        this.exportTableScroller.setViewportView((Component)this.exportTable);
        this.infoTitle.setName("infoTitle");
        this.infoTitle.setTitle("infoTitle");
        this.selectAllButton.setText("doSelectAll");
        this.selectAllButton.setName("selectAllButton");
        GroupLayout groupLayout = new GroupLayout((Container)((Object)this));
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.exportTableScroller, GroupLayout.Alignment.LEADING, -1, 882, Short.MAX_VALUE).addComponent((Component)this.infoLabel, -1, -1, Short.MAX_VALUE).addGroup(groupLayout.createSequentialGroup().addComponent((Component)this.infoTitle, -1, 424, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.exportButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.showSummaryButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.helpButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.closeButton)).addGroup(groupLayout.createSequentialGroup().addComponent((Component)this.interfaceTitle, -1, 140, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.refreshButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.interfaceCreateButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.interfaceImportButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.interfaceActionButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.selectAllButton))).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.closeButton).addComponent(this.helpButton).addComponent(this.showSummaryButton).addComponent(this.exportButton)).addComponent((Component)this.infoTitle, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.infoLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.selectAllButton).addComponent(this.interfaceCreateButton).addComponent(this.interfaceImportButton).addComponent(this.refreshButton).addComponent(this.interfaceActionButton)).addComponent((Component)this.interfaceTitle, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.exportTableScroller, -1, 361, Short.MAX_VALUE).addContainerGap()));
    }

    @Action
    public void doClose() {
        ImmoToolUtils.removePanel((String)this.getTabTitle());
    }

    @Action
    public Task doExport() {
        boolean bl = false;
        for (int i = 0; i < this.exportTableModel.getRowCount(); ++i) {
            if (!this.exportTableModel.isRowActive(i)) continue;
            bl = true;
            break;
        }
        if (!bl) {
            ImmoToolUtils.showMessageErrorDialog((String)this.resourceMap.getString("error.noInterfaceSelected", new Object[0]));
            return null;
        }
        this.exportButton.setEnabled(false);
        return new ImmoToolTask<AgencyExportTaskContainer>(){

            protected AgencyExportTaskContainer executeTask() throws Exception {
                AgencyExportTaskContainer agencyExportTaskContainer = new AgencyExportTaskContainer();
                for (int i = 0; i < AgencyExportPanel.this.exportTableModel.getRowCount(); ++i) {
                    if (!AgencyExportPanel.this.exportTableModel.isRowActive(i)) continue;
                    long l = AgencyExportPanel.this.exportTableModel.getExportInterfaceIdAt(i);
                    AgencyExportInterface agencyExportInterface = AgencyExportInterface.loadExportInterface(l);
                    if (agencyExportInterface == null) {
                        LOGGER.warn((Object)("Can't load export-interface #" + l + "!"));
                        continue;
                    }
                    agencyExportTaskContainer.addExport(agencyExportInterface);
                }
                return agencyExportTaskContainer;
            }

            protected void finished() {
                super.finished();
                AgencyExportPanel.this.exportButton.setEnabled(true);
            }

            protected void succeeded(AgencyExportTaskContainer agencyExportTaskContainer) {
                super.succeeded((Object)agencyExportTaskContainer);
                ImmoToolTaskDialog.execute((ImmoToolTask)agencyExportTaskContainer);
            }
        };
    }

    @Action
    public void doHelp() {
        ImmoToolUtils.showHelpDialog((String)"agency.export");
    }

    @Action
    public void doInterfaceAction() {
        this.interfacePopupMenu.show(this.interfaceActionButton, 0, this.interfaceActionButton.getSize().height);
    }

    @Action
    public Task doInterfaceCreate() {
        AgencyExportInterfaceDialog agencyExportInterfaceDialog = new AgencyExportInterfaceDialog();
        agencyExportInterfaceDialog.setVisible(true);
        if (agencyExportInterfaceDialog.getStatus() != 2) {
            return null;
        }
        final AgencyExportInterface agencyExportInterface = new AgencyExportInterface();
        agencyExportInterfaceDialog.save(agencyExportInterface);
        return new ImmoToolTask<Boolean>(){

            protected Boolean executeTask() throws Exception {
                Long l;
                int n;
                AgencyExportInterface.storeExportInterface(agencyExportInterface);
                HashMap<Long, Boolean> hashMap = new HashMap<Long, Boolean>();
                for (n = 0; n < AgencyExportPanel.this.exportTableModel.getRowCount(); ++n) {
                    l = AgencyExportPanel.this.exportTableModel.getExportInterfaceIdAt(n);
                    boolean bl = AgencyExportPanel.this.exportTableModel.isRowActive(n);
                    hashMap.put(l, bl);
                }
                AgencyExportPanel.this.refresh();
                for (n = 0; n < AgencyExportPanel.this.exportTableModel.getRowCount(); ++n) {
                    l = AgencyExportPanel.this.exportTableModel.getExportInterfaceIdAt(n);
                    if (!hashMap.containsKey(l)) continue;
                    AgencyExportPanel.this.exportTableModel.setValueAt(hashMap.get(l), n, 0);
                }
                return Boolean.TRUE;
            }

            protected void failed(Throwable throwable) {
                super.failed(throwable);
                ImmoToolUtils.showMessageErrorDialog((String)AgencyExportPanel.this.resourceMap.getString("error.cantCreateInterface", new Object[0]), (Throwable)throwable);
            }

            protected void succeeded(Boolean bl) {
                super.succeeded((Object)bl);
                this.setMessage(AgencyExportPanel.this.resourceMap.getString("message.interfaceCreated", new Object[0]));
            }
        };
    }

    @Action
    public void doInterfaceDisable() {
        if (this.exportTable.getSelectedRowCount() < 1) {
            return;
        }
        final ArrayList<Long> arrayList = new ArrayList<Long>();
        for (int n : this.exportTable.getSelectedRows()) {
            int n2 = this.exportTable.convertRowIndexToModel(n);
            arrayList.add(this.exportTableModel.getExportInterfaceIdAt(n2));
        }
        ImmoToolTaskDialog.execute((ImmoToolTask)new ImmoToolTask<Boolean>(this.resourceMap.getString("doInterfaceDisable.Action.text", new Object[0])){

            protected Boolean executeTask() throws Exception {
                for (Long l : arrayList) {
                    this.setMessage("#" + l);
                    AgencyExportInterface agencyExportInterface = AgencyExportInterface.loadExportInterface(l);
                    agencyExportInterface.setActive(false);
                    AgencyExportInterface.storeExportInterface(agencyExportInterface);
                }
                for (int i = 0; i < AgencyExportPanel.this.exportTableModel.getRowCount(); ++i) {
                    Long l;
                    l = AgencyExportPanel.this.exportTableModel.getExportInterfaceIdAt(i);
                    if (!arrayList.contains(l)) continue;
                    AgencyExportPanel.this.exportTableModel.setValueAt(false, i, 0);
                }
                return true;
            }

            protected void failed(Throwable throwable) {
                super.failed(throwable);
                ImmoToolUtils.showMessageErrorDialog((String)AgencyExportPanel.this.resourceMap.getString("error.cantSaveInterface", new Object[0]), (Throwable)throwable);
            }

            protected void succeeded(Boolean bl) {
                super.succeeded((Object)bl);
            }
        });
    }

    @Action
    public void doInterfaceEnable() {
        if (this.exportTable.getSelectedRowCount() < 1) {
            return;
        }
        final ArrayList<Long> arrayList = new ArrayList<Long>();
        for (int n : this.exportTable.getSelectedRows()) {
            int n2 = this.exportTable.convertRowIndexToModel(n);
            arrayList.add(this.exportTableModel.getExportInterfaceIdAt(n2));
        }
        ImmoToolTaskDialog.execute((ImmoToolTask)new ImmoToolTask<Boolean>(this.resourceMap.getString("doInterfaceEnable.Action.text", new Object[0])){

            protected Boolean executeTask() throws Exception {
                for (Long l : arrayList) {
                    this.setMessage("#" + l);
                    AgencyExportInterface agencyExportInterface = AgencyExportInterface.loadExportInterface(l);
                    agencyExportInterface.setActive(true);
                    AgencyExportInterface.storeExportInterface(agencyExportInterface);
                }
                for (int i = 0; i < AgencyExportPanel.this.exportTableModel.getRowCount(); ++i) {
                    Long l;
                    l = AgencyExportPanel.this.exportTableModel.getExportInterfaceIdAt(i);
                    if (!arrayList.contains(l)) continue;
                    AgencyExportPanel.this.exportTableModel.setValueAt(true, i, 0);
                }
                return true;
            }

            protected void failed(Throwable throwable) {
                super.failed(throwable);
                ImmoToolUtils.showMessageErrorDialog((String)AgencyExportPanel.this.resourceMap.getString("error.cantSaveInterface", new Object[0]), (Throwable)throwable);
            }

            protected void succeeded(Boolean bl) {
                super.succeeded((Object)bl);
            }
        });
    }

    @Action
    public Task doInterfaceImport() {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setDialogTitle(this.resourceMap.getString("message.selectInterfaceFile", new Object[0]));
        jFileChooser.setApproveButtonText(this.resourceMap.getString("message.importInterface", new Object[0]));
        jFileChooser.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory() || file.getName().toLowerCase().endsWith(".xml") || file.getName().toLowerCase().endsWith(".ini") || file.getName().toLowerCase().endsWith(".properties");
            }

            @Override
            public String getDescription() {
                return AgencyExportPanel.this.resourceMap.getString("message.importInterfaceFiles", new Object[]{"*.xml, *.ini, *.properties"});
            }
        });
        int n = jFileChooser.showOpenDialog((Component)((Object)this));
        if (n != 0) {
            return null;
        }
        this.interfaceCreateButton.setEnabled(false);
        this.interfaceImportButton.setEnabled(false);
        final File file = jFileChooser.getSelectedFile();
        return new ImmoToolTask<Boolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected Boolean executeTask() throws Exception {
                if (!file.isFile()) {
                    throw new Exception(AgencyExportPanel.this.resourceMap.getString("error.invalidInterfaceFile", new Object[0]));
                }
                Properties properties = new Properties();
                FileInputStream fileInputStream = null;
                try {
                    fileInputStream = new FileInputStream(file);
                    if (file.getName().toLowerCase().endsWith(".xml")) {
                        properties.loadFromXML(fileInputStream);
                    } else {
                        properties.load(fileInputStream);
                    }
                }
                finally {
                    if (fileInputStream != null) {
                        fileInputStream.close();
                    }
                }
                AgencyExportInterface agencyExportInterface = new AgencyExportInterface();
                agencyExportInterface.load(properties);
                if (agencyExportInterface.getTitle() == null || agencyExportInterface.getTitle().trim().length() == 0 || agencyExportInterface.getExport() == null || agencyExportInterface.getTransport() == null) {
                    throw new Exception(AgencyExportPanel.this.resourceMap.getString("error.incompleteInterfaceFile", new Object[0]));
                }
                agencyExportInterface.setId(0L);
                AgencyExportInterface.storeExportInterface(agencyExportInterface);
                return true;
            }

            protected void failed(Throwable throwable) {
                super.failed(throwable);
                ImmoToolUtils.showMessageErrorDialog((String)AgencyExportPanel.this.resourceMap.getString("error.cantImportInterface", new Object[0]), (Throwable)throwable);
            }

            protected void finished() {
                super.finished();
                AgencyExportPanel.this.interfaceCreateButton.setEnabled(true);
                AgencyExportPanel.this.interfaceImportButton.setEnabled(true);
            }

            protected void succeeded(Boolean bl) {
                super.succeeded((Object)bl);
                ImmoToolUtils.executeTask((Task)AgencyExportPanel.this.doRefresh());
                ImmoToolUtils.showMessageInfoDialog((String)AgencyExportPanel.this.resourceMap.getString("message.interfaceImported", new Object[0]));
            }
        };
    }

    @Action
    public Task doInterfaceModify() {
        if (this.exportTable.getSelectedRowCount() < 1) {
            return null;
        }
        int n = this.exportTable.convertRowIndexToModel(this.exportTable.getSelectedRow());
        final long l = this.exportTableModel.getExportInterfaceIdAt(n);
        return new ImmoToolTask<AgencyExportInterface>(){

            protected AgencyExportInterface executeTask() throws Exception {
                AgencyExportInterface agencyExportInterface = AgencyExportInterface.loadExportInterface(l);
                if (agencyExportInterface == null) {
                    throw new Exception("export-interface #" + l + " not found!");
                }
                return agencyExportInterface;
            }

            protected void failed(Throwable throwable) {
                super.failed(throwable);
                ImmoToolUtils.showMessageErrorDialog((String)AgencyExportPanel.this.resourceMap.getString("error.cantLoadInterface", new Object[0]), (Throwable)throwable);
            }

            protected void succeeded(AgencyExportInterface agencyExportInterface) {
                super.succeeded((Object)agencyExportInterface);
                final AgencyExportInterface agencyExportInterface2 = agencyExportInterface;
                AgencyExportInterfaceDialog agencyExportInterfaceDialog = new AgencyExportInterfaceDialog();
                agencyExportInterfaceDialog.load(agencyExportInterface2);
                agencyExportInterfaceDialog.setVisible(true);
                if (agencyExportInterfaceDialog.getStatus() != 2) {
                    return;
                }
                agencyExportInterfaceDialog.save(agencyExportInterface2);
                ImmoToolUtils.executeTask((Task)new ImmoToolTask<Boolean>(){

                    protected Boolean executeTask() throws Exception {
                        Long l;
                        int n;
                        AgencyExportInterface.storeExportInterface(agencyExportInterface2);
                        HashMap<Long, Boolean> hashMap = new HashMap<Long, Boolean>();
                        for (n = 0; n < AgencyExportPanel.this.exportTableModel.getRowCount(); ++n) {
                            l = AgencyExportPanel.this.exportTableModel.getExportInterfaceIdAt(n);
                            boolean bl = AgencyExportPanel.this.exportTableModel.isRowActive(n);
                            hashMap.put(l, bl);
                        }
                        AgencyExportPanel.this.refresh();
                        for (n = 0; n < AgencyExportPanel.this.exportTableModel.getRowCount(); ++n) {
                            l = AgencyExportPanel.this.exportTableModel.getExportInterfaceIdAt(n);
                            if (!hashMap.containsKey(l) || l.longValue() == agencyExportInterface2.getId()) continue;
                            AgencyExportPanel.this.exportTableModel.setValueAt(hashMap.get(l), n, 0);
                        }
                        return true;
                    }

                    protected void failed(Throwable throwable) {
                        super.failed(throwable);
                        ImmoToolUtils.showMessageErrorDialog((String)AgencyExportPanel.this.resourceMap.getString("error.cantSaveInterface", new Object[0]), (Throwable)throwable);
                    }

                    protected void succeeded(Boolean bl) {
                        super.succeeded((Object)bl);
                    }
                });
            }
        };
    }

    @Action
    public void doInterfaceRemove() {
        if (this.exportTable.getSelectedRowCount() < 1) {
            return;
        }
        boolean bl = ImmoToolUtils.showQuestionDialog((String)this.resourceMap.getString("question.reallyRemoveInterfaces", new Object[]{this.exportTable.getSelectedRowCount()}));
        if (!bl) {
            return;
        }
        final ArrayList<Long> arrayList = new ArrayList<Long>();
        final HashMap<Long, Boolean> hashMap = new HashMap<Long, Boolean>();
        for (int n : this.exportTable.getSelectedRows()) {
            int n2 = this.exportTable.convertRowIndexToModel(n);
            Long l = this.exportTableModel.getExportInterfaceIdAt(n2);
            hashMap.put(l, this.exportTableModel.isRowActive(n2));
            arrayList.add(l);
        }
        ImmoToolTaskDialog.execute((ImmoToolTask)new ImmoToolTask<Boolean>(this.resourceMap.getString("doInterfaceRemove.Action.text", new Object[0])){

            protected Boolean executeTask() throws Exception {
                for (Long l : arrayList) {
                    this.setMessage("#" + l);
                    AgencyExportInterface.removeExportInterface(l);
                    AgencyExportPanel.this.refresh();
                }
                for (int i = 0; i < AgencyExportPanel.this.exportTableModel.getRowCount(); ++i) {
                    Long l;
                    l = AgencyExportPanel.this.exportTableModel.getExportInterfaceIdAt(i);
                    if (!hashMap.containsKey(l)) continue;
                    AgencyExportPanel.this.exportTableModel.setValueAt(hashMap.get(l), i, 0);
                }
                return true;
            }

            protected void failed(Throwable throwable) {
                super.failed(throwable);
                ImmoToolUtils.showMessageErrorDialog((String)AgencyExportPanel.this.resourceMap.getString("error.cantRemoveInterface", new Object[0]), (Throwable)throwable);
            }

            protected void succeeded(Boolean bl) {
                super.succeeded((Object)bl);
                this.setMessage(AgencyExportPanel.this.resourceMap.getString("message.interfaceRemoved", new Object[0]));
            }
        });
    }

    @Action
    public Task doRefresh() {
        return new ImmoToolTask<Boolean>(){

            protected Boolean executeTask() throws Exception {
                AgencyExportPanel.this.refresh();
                return true;
            }
        };
    }

    @Action
    public void doSelectAll() {
        boolean bl = this.selectAllButton.isSelected();
        for (int i = 0; i < this.exportTableModel.getRowCount(); ++i) {
            this.exportTableModel.setValueAt(bl, i, 0);
        }
    }

    @Action
    public Task doShowSummary() {
        String string = AgencyExportSummaryTablePanel.getInstanceTabTitle();
        if (ImmoToolUtils.selectPanel((String)string)) {
            return null;
        }
        return new ImmoToolTask<AgencyExportSummaryTablePanel>(){

            protected AgencyExportSummaryTablePanel executeTask() throws Exception {
                AgencyExportSummaryTablePanel agencyExportSummaryTablePanel = new AgencyExportSummaryTablePanel();
                agencyExportSummaryTablePanel.refresh();
                return agencyExportSummaryTablePanel;
            }

            protected void failed(Throwable throwable) {
                super.failed(throwable);
                ImmoToolUtils.showMessageErrorDialog((String)AgencyExportPanel.this.resourceMap.getString("error.cantLoadHistory", new Object[0]), (Throwable)throwable);
            }

            protected void succeeded(AgencyExportSummaryTablePanel agencyExportSummaryTablePanel) {
                super.succeeded((Object)agencyExportSummaryTablePanel);
                ImmoToolUtils.showPanel((TabComponent)agencyExportSummaryTablePanel);
            }
        };
    }
}

