/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency;

import com.openindex.openestate.impl.OpenEstateUtils;
import com.openindex.openestate.impl.xml.OpenImmoUtils;
import com.openindex.openestate.impl.xml.openimmo.OpenimmoFeedback;
import com.openindex.openestate.tool.ImmoToolApp;
import com.openindex.openestate.tool.ImmoToolDbException;
import com.openindex.openestate.tool.ImmoToolDbUtils;
import com.openindex.openestate.tool.ImmoToolException;
import com.openindex.openestate.tool.agency.AgencyEstate;
import com.openindex.openestate.tool.agency.AgencyExportInterface;
import com.openindex.openestate.tool.agency.AgencyExportList;
import com.openindex.openestate.tool.agency.AgencyPluginUtils;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.xml.bind.JAXBException;
import org.apache.commons.lang.SystemUtils;
import org.apache.log4j.Logger;
import org.w3c.dom.Node;
import org.xmldb.api.base.Collection;
import org.xmldb.api.modules.XMLResource;

public class AgencyExportSummary {
    private static final Logger LOGGER = Logger.getLogger(AgencyExportSummary.class);
    public static final String KEY_INTERFACE_ID = "interface.id";
    public static final String KEY_INTERFACE_LIMIT = "interface.limit";
    public static final String KEY_INTERFACE_NAME = "interface.name";
    @Deprecated
    public static final String KEY_ESTATE_ID = "estate.id";
    public static final String KEY_ESTATE_UPDATED = "estate.updated";
    public static final String KEY_ESTATE_REMOVED = "estate.removed";
    public static final String KEY_ESTATE_ERROR = "estate.error";
    public static final String KEY_FULLTRANSFER = "fulltransfer";
    public static final String KEY_ID = "id";
    public static final String KEY_MESSAGE = "message";
    public static final String KEY_SUCCESSFUL = "successful";
    public static final String KEY_TIME = "time";
    public static final String KEY_FORMAT = "format";
    public static final String KEY_TRANSPORT = "transport";
    private List<Long> estateIdsUpdated = new ArrayList<Long>();
    private List<Long> estateIdsRemoved = new ArrayList<Long>();
    private Map<Long, String> estateNrsRemoved = new HashMap<Long, String>();
    private Map<Long, String> estateErrorMap = new TreeMap<Long, String>();
    private boolean fullTransfer = true;
    private long id = 0L;
    private long interfaceId = 0L;
    private long interfaceLimit = 0L;
    private String interfaceName = "";
    private String message = "";
    private boolean successful = true;
    private Date time = null;
    private String format = "";
    private String transport = "";

    public static AgencyExportSummary buildEmptySummary(AgencyExportInterface agencyExportInterface) throws ImmoToolException {
        AgencyExportSummary agencyExportSummary = new AgencyExportSummary();
        agencyExportSummary.setFormat(agencyExportInterface.getExport().getName());
        agencyExportSummary.setFullTransfer(!agencyExportInterface.getExport().isIncremental());
        agencyExportSummary.setInterfaceId(agencyExportInterface.getId());
        agencyExportSummary.setInterfaceLimit(agencyExportInterface.getLimit());
        agencyExportSummary.setInterfaceName(agencyExportInterface.getTitle());
        agencyExportSummary.setTime(new Date());
        agencyExportSummary.setTransport(agencyExportInterface.getTransport().getName());
        return agencyExportSummary;
    }

    public static AgencyExportSummary buildSummary(long l) throws ImmoToolException {
        AgencyExportInterface agencyExportInterface = AgencyExportInterface.loadExportInterface(l);
        if (agencyExportInterface == null) {
            throw new ImmoToolException("unknown export-interface #" + l);
        }
        return AgencyExportSummary.buildSummary(agencyExportInterface);
    }

    public static AgencyExportSummary buildSummary(AgencyExportInterface agencyExportInterface) throws ImmoToolException {
        Collection collection = null;
        try {
            Long l4;
            collection = AgencyPluginUtils.openPluginCollection("/exports");
            long l2 = agencyExportInterface.getLimit();
            AgencyExportSummary agencyExportSummary = AgencyExportSummary.buildEmptySummary(agencyExportInterface);
            long l3 = 0L;
            AgencyExportList agencyExportList = null;
            AgencyExportList agencyExportList2 = null;
            if (agencyExportInterface.getExport().isIncremental() && (agencyExportList = AgencyExportList.loadExportList(agencyExportInterface.getId(), "published", collection)) != null) {
                l3 = agencyExportList.getEstateIds().size();
                agencyExportList2 = AgencyExportList.loadExportList(agencyExportInterface.getId(), "changed", collection);
                if (agencyExportList2 != null) {
                    for (Long l4 : agencyExportList2.getEstateIds()) {
                        String string = agencyExportList2.getEstateValue(l4);
                        if (!string.equalsIgnoreCase("delete")) continue;
                        agencyExportSummary.getRemovedEstateIds().add(l4);
                        String string2 = agencyExportList2.getEstatePublicId(l4);
                        if (string2 == null || string2.trim().length() <= 0) continue;
                        agencyExportSummary.getRemovedEstatePublicIds().put(l4, string2.trim());
                    }
                }
            }
            String string = "declare namespace util=\"http://exist-db.org/xquery/util\";" + SystemUtils.LINE_SEPARATOR + "declare namespace xmldb=\"http://exist-db.org/xquery/xmldb\";" + SystemUtils.LINE_SEPARATOR + "declare namespace openestate=\"http://www.openestate.org/1.0/\";" + SystemUtils.LINE_SEPARATOR + "for $x in xmldb:xcollection('" + "ImmoTool/OpenEstate-Agency" + "/estates" + "')/openestate:" + "Estate" + SystemUtils.LINE_SEPARATOR + "  let $type := local-name($x/*[3])" + SystemUtils.LINE_SEPARATOR + "  let $action := local-name($x/*[3]/openestate:Action/*[1])" + SystemUtils.LINE_SEPARATOR + "  let $file := util:document-name($x)" + SystemUtils.LINE_SEPARATOR + "  let $enabled := $x/openestate:" + "CustomValues" + "/openestate:" + "CustomValue" + "[@" + "Key" + "='" + "export.enabled" + "']/openestate:" + "Boolean" + "/text()" + SystemUtils.LINE_SEPARATOR + "  let $always := $x/openestate:" + "CustomValues" + "/openestate:" + "CustomValue" + "[@" + "Key" + "='" + "export.always" + "']/openestate:" + "Boolean" + "/text()" + SystemUtils.LINE_SEPARATOR + "  let $status := $x/openestate:" + "CustomValues" + "/openestate:" + "CustomValue" + "[@" + "Key" + "='" + "status" + "']/openestate:" + "String" + "/text()" + SystemUtils.LINE_SEPARATOR + "  return" + SystemUtils.LINE_SEPARATOR + "<estate file=\"{$file}\" always=\"{$always}\" enabled=\"{$enabled}\" status=\"{$status}\" type=\"{$type}\" action=\"{$action}\">{" + SystemUtils.LINE_SEPARATOR + "for $y in $x/openestate:" + "CustomValues" + "/openestate:" + "CustomValue" + SystemUtils.LINE_SEPARATOR + "  where starts-with( $y/@" + "Key" + ", '" + "export.interface" + ".' )" + SystemUtils.LINE_SEPARATOR + "  return <interfaceId>{$y/openestate:" + "Integer" + "/text()}</interfaceId>" + SystemUtils.LINE_SEPARATOR + "}</estate>";
            l4 = ImmoToolDbUtils.executeXQuery((Collection)collection, (String)string);
            for (long i = 0L; i < l4.getSize() && (l2 <= 0L || agencyExportInterface.getExport().isIncremental() || (long)agencyExportSummary.getUpdatedEstateIds().size() < l2); ++i) {
                String string3;
                boolean bl;
                XMLResource xMLResource = (XMLResource)l4.getResource(i);
                Node node = xMLResource.getContentAsDOM();
                String string4 = node.getAttributes().getNamedItem("file").getNodeValue();
                String[] stringArray = string4.split("\\.");
                long l5 = Long.valueOf(stringArray[stringArray.length - 2]);
                String string5 = node.getAttributes().getNamedItem("status").getNodeValue();
                String string6 = OpenEstateUtils.makeUnCamelCase((String)node.getAttributes().getNamedItem("type").getNodeValue());
                String string7 = OpenEstateUtils.makeUnCamelCase((String)node.getAttributes().getNamedItem("action").getNodeValue());
                String string8 = node.getAttributes().getNamedItem("enabled").getNodeValue();
                boolean bl2 = Boolean.valueOf(string8.trim().length() > 0 ? string8 : "true");
                if (string6 == null || string6.trim().length() == 0 || string7 == null || string7.trim().length() == 0) {
                    LOGGER.warn((Object)("Invalid specification for estate #" + l5));
                    continue;
                }
                if (!agencyExportInterface.getExport().supportsEstateType(string6, string7)) {
                    LOGGER.info((Object)("Can't export estate #" + l5));
                    LOGGER.info((Object)("> specified type   : " + string6));
                    LOGGER.info((Object)("> specified action : " + string7));
                    bl2 = false;
                }
                if (!(bl = Boolean.valueOf((string3 = node.getAttributes().getNamedItem("always").getNodeValue()).trim().length() > 0 ? string3 : "true").booleanValue())) {
                    for (int j = 0; j < node.getChildNodes().getLength(); ++j) {
                        long l6;
                        Node node2 = node.getChildNodes().item(j);
                        if (!node2.getNodeName().equals("interfaceId") || (l6 = Long.valueOf(node2.getFirstChild().getNodeValue()).longValue()) != agencyExportInterface.getId()) continue;
                        bl = true;
                        break;
                    }
                }
                if (!agencyExportInterface.getExport().isIncremental()) {
                    if (!bl || !bl2 || !"VERMITTLUNG".equalsIgnoreCase(string5) || agencyExportSummary.getUpdatedEstateIds().contains(l5)) continue;
                    agencyExportSummary.getUpdatedEstateIds().add(l5);
                    continue;
                }
                if (!bl2 || !bl) {
                    if (agencyExportList == null || !agencyExportList.hasEstateId(l5) || agencyExportSummary.getRemovedEstateIds().contains(l5)) continue;
                    agencyExportSummary.getRemovedEstateIds().add(l5);
                    continue;
                }
                if (agencyExportList != null && agencyExportList.hasEstateId(l5) && !"VERMITTLUNG".equalsIgnoreCase(string5)) {
                    if (agencyExportSummary.getRemovedEstateIds().contains(l5)) continue;
                    agencyExportSummary.getRemovedEstateIds().add(l5);
                    continue;
                }
                if (agencyExportList2 != null && agencyExportList2.hasEstateId(l5) && agencyExportList2.getEstateValue(l5).equalsIgnoreCase("delete")) {
                    if (agencyExportSummary.getRemovedEstateIds().contains(l5)) continue;
                    agencyExportSummary.getRemovedEstateIds().add(l5);
                    continue;
                }
                if (agencyExportList2 != null && agencyExportList2.hasEstateId(l5) && agencyExportList2.getEstateValue(l5).equalsIgnoreCase("update") && "VERMITTLUNG".equalsIgnoreCase(string5)) {
                    if (agencyExportSummary.getUpdatedEstateIds().contains(l5) || agencyExportSummary.getRemovedEstateIds().contains(l5)) continue;
                    agencyExportSummary.getUpdatedEstateIds().add(l5);
                    continue;
                }
                if (agencyExportList != null && !agencyExportList.hasEstateId(l5) && "VERMITTLUNG".equalsIgnoreCase(string5)) {
                    if (agencyExportSummary.getUpdatedEstateIds().contains(l5) || agencyExportSummary.getRemovedEstateIds().contains(l5)) continue;
                    agencyExportSummary.getUpdatedEstateIds().add(l5);
                    continue;
                }
                if (agencyExportList2 != null || !"VERMITTLUNG".equalsIgnoreCase(string5) || agencyExportSummary.getUpdatedEstateIds().contains(l5) || agencyExportSummary.getRemovedEstateIds().contains(l5)) continue;
                agencyExportSummary.getUpdatedEstateIds().add(l5);
            }
            if (l2 > 0L && agencyExportInterface.getExport().isIncremental()) {
                AgencyExportSummary.doIncrementalLimitedUpdate(agencyExportInterface, agencyExportSummary, agencyExportList, l3);
            }
            AgencyExportSummary agencyExportSummary2 = agencyExportSummary;
            return agencyExportSummary2;
        }
        catch (ImmoToolException immoToolException) {
            throw immoToolException;
        }
        catch (Exception exception) {
            throw new ImmoToolException("Can't load estates into export-summary: " + exception.getLocalizedMessage(), (Throwable)exception);
        }
        finally {
            ImmoToolDbUtils.close((Collection)collection);
        }
    }

    public static AgencyExportSummary buildSummary(long l, List<AgencyEstate> list) throws ImmoToolException {
        AgencyExportInterface agencyExportInterface = AgencyExportInterface.loadExportInterface(l);
        if (agencyExportInterface == null) {
            throw new ImmoToolException("unknown export-interface #" + l);
        }
        return AgencyExportSummary.buildSummary(agencyExportInterface, list);
    }

    public static AgencyExportSummary buildSummary(AgencyExportInterface agencyExportInterface, List<AgencyEstate> list) throws ImmoToolException {
        Collection collection = null;
        try {
            collection = AgencyPluginUtils.openPluginCollection("/exports");
            AgencyExportSummary agencyExportSummary = AgencyExportSummary.buildEmptySummary(agencyExportInterface);
            long l = 0L;
            AgencyExportList agencyExportList = null;
            if (agencyExportInterface.getExport().isIncremental() && (agencyExportList = AgencyExportList.loadExportList(agencyExportInterface.getId(), "published", collection)) != null) {
                l = agencyExportList.getEstateIds().size();
            }
            long l2 = agencyExportInterface.getLimit();
            for (AgencyEstate agencyEstate : list) {
                if (l2 > 0L && !agencyExportInterface.getExport().isIncremental() && (long)agencyExportSummary.getUpdatedEstateIds().size() >= l2) break;
                Long l3 = agencyEstate.getIdNr();
                if (l3 == null || !agencyEstate.isExportEnabled() || agencyEstate.getType() == null || agencyEstate.getAction() == null || !agencyExportInterface.getExport().supportsEstateType(agencyEstate.getType().getName(), agencyEstate.getAction())) continue;
                List<Long> list2 = Arrays.asList(agencyEstate.getExportIntefaces());
                if (!agencyEstate.isExportAlways() && !list2.contains(agencyExportInterface.getId()) || !agencyEstate.isExportAlways()) continue;
                if (agencyExportInterface.getExport().isIncremental()) {
                    if (!"VERMITTLUNG".equalsIgnoreCase(agencyEstate.getStatus()) && !agencyExportSummary.getRemovedEstateIds().contains(l3)) {
                        agencyExportSummary.getRemovedEstateIds().add(l3);
                        continue;
                    }
                    if (!"VERMITTLUNG".equalsIgnoreCase(agencyEstate.getStatus()) || agencyExportSummary.getUpdatedEstateIds().contains(l3)) continue;
                    agencyExportSummary.getUpdatedEstateIds().add(l3);
                    continue;
                }
                if (!"VERMITTLUNG".equalsIgnoreCase(agencyEstate.getStatus()) || agencyExportSummary.getUpdatedEstateIds().contains(agencyEstate.getIdNr())) continue;
                agencyExportSummary.getUpdatedEstateIds().add(l3);
            }
            if (l2 > 0L && agencyExportInterface.getExport().isIncremental()) {
                AgencyExportSummary.doIncrementalLimitedUpdate(agencyExportInterface, agencyExportSummary, agencyExportList, l);
            }
            AgencyExportSummary agencyExportSummary2 = agencyExportSummary;
            return agencyExportSummary2;
        }
        catch (ImmoToolException immoToolException) {
            throw immoToolException;
        }
        catch (Exception exception) {
            throw new ImmoToolException("Can't load estates into export-summary: " + exception.getLocalizedMessage(), (Throwable)exception);
        }
        finally {
            ImmoToolDbUtils.close((Collection)collection);
        }
    }

    private static void doIncrementalLimitedUpdate(AgencyExportInterface agencyExportInterface, AgencyExportSummary agencyExportSummary, AgencyExportList agencyExportList, long l) {
        Object object;
        long l2 = agencyExportInterface.getLimit();
        long l3 = l - (long)agencyExportSummary.getRemovedEstateIds().size();
        ArrayList<Long> arrayList = new ArrayList<Long>();
        if (agencyExportList == null) {
            arrayList.addAll(agencyExportSummary.getUpdatedEstateIds());
        } else {
            object = agencyExportSummary.getUpdatedEstateIds().iterator();
            while (object.hasNext()) {
                long l4 = object.next();
                if (agencyExportList.getEstateIds().contains(l4)) continue;
                arrayList.add(l4);
            }
        }
        if ((l3 += (long)arrayList.size()) > l2) {
            while (l3 > l2 && arrayList.size() > 0) {
                object = (Long)arrayList.remove(0);
                agencyExportSummary.getUpdatedEstateIds().remove(object);
                arrayList.trimToSize();
                --l3;
            }
        }
        if (l3 > l2) {
            while (l3 > l2 && agencyExportSummary.getUpdatedEstateIds().size() > 0) {
                object = agencyExportSummary.getUpdatedEstateIds().remove(0);
                agencyExportSummary.getUpdatedEstateIds().remove(object);
                agencyExportSummary.getRemovedEstateIds().add((Long)object);
                --l3;
            }
        }
        if (l3 > l2 && agencyExportList != null) {
            while (l3 > l2 && agencyExportList.getEstateIds().size() > 0) {
                object = agencyExportList.getEstateIds().iterator().next();
                agencyExportSummary.getRemovedEstateIds().add((Long)object);
                agencyExportList.getEstateValueMap().remove(object);
                --l3;
            }
        }
    }

    public Set<Long> getErrorEstateIds() {
        return this.estateErrorMap.keySet();
    }

    public Map<Long, String> getErrorEstateMap() {
        return this.estateErrorMap;
    }

    public String getFormat() {
        return this.format;
    }

    public long getId() {
        return this.id;
    }

    public long getInterfaceId() {
        return this.interfaceId;
    }

    public long getInterfaceLimit() {
        return this.interfaceLimit;
    }

    public String getInterfaceName() {
        return this.interfaceName;
    }

    public String getMessage() {
        return this.message;
    }

    public List<Long> getRemovedEstateIds() {
        return this.estateIdsRemoved;
    }

    public Map<Long, String> getRemovedEstatePublicIds() {
        return this.estateNrsRemoved;
    }

    public Date getTime() {
        return this.time != null ? (Date)this.time.clone() : null;
    }

    public String getTransport() {
        return this.transport;
    }

    public List<Long> getUpdatedEstateIds() {
        return this.estateIdsUpdated;
    }

    public boolean isFullTransfer() {
        return this.fullTransfer;
    }

    public boolean isSuccessful() {
        return this.successful;
    }

    public void load(Properties properties) throws ImmoToolException {
        if (properties == null) {
            return;
        }
        this.setFormat(properties.getProperty(KEY_FORMAT, ""));
        this.setFullTransfer(Boolean.valueOf(properties.getProperty(KEY_FULLTRANSFER, "true")));
        this.setId(Long.valueOf(properties.getProperty(KEY_ID, "0")));
        this.setInterfaceId(Long.valueOf(properties.getProperty(KEY_INTERFACE_ID, "0")));
        this.setInterfaceLimit(Long.valueOf(properties.getProperty(KEY_INTERFACE_LIMIT, "0")));
        this.setInterfaceName(properties.getProperty(KEY_INTERFACE_NAME, ""));
        this.setMessage(properties.getProperty(KEY_MESSAGE, ""));
        this.setSuccessful(Boolean.valueOf(properties.getProperty(KEY_SUCCESSFUL, "true")));
        this.setTransport(properties.getProperty(KEY_TRANSPORT, ""));
        Date date = new Date();
        date.setTime(Long.valueOf(properties.getProperty(KEY_TIME, "0")));
        this.setTime(date);
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            try {
                String[] stringArray;
                String string = (String)enumeration.nextElement();
                if (string.startsWith("estate.id.") || string.startsWith("estate.updated.")) {
                    stringArray = Long.valueOf(properties.getProperty(string));
                    if (this.getUpdatedEstateIds().contains(stringArray)) continue;
                    this.getUpdatedEstateIds().add((Long)stringArray);
                    continue;
                }
                if (string.startsWith("estate.removed.")) {
                    stringArray = Long.valueOf(properties.getProperty(string));
                    if (this.getRemovedEstateIds().contains(stringArray)) continue;
                    this.getRemovedEstateIds().add((Long)stringArray);
                    continue;
                }
                if (!string.startsWith("estate.error.")) continue;
                stringArray = string.split("\\.");
                Long l = Long.valueOf(stringArray[stringArray.length - 1]);
                if (this.getErrorEstateMap().containsKey(l)) continue;
                this.getErrorEstateMap().put(l, properties.getProperty(string));
            }
            catch (Exception exception) {
                LOGGER.warn((Object)"problem while parsing summary!");
                LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AgencyExportSummary loadExportSummary(long l) throws ImmoToolDbException {
        Collection collection = null;
        try {
            collection = AgencyPluginUtils.openPluginCollection("/exports/summaries");
            AgencyExportSummary agencyExportSummary = AgencyExportSummary.loadExportSummary(l, collection);
            return agencyExportSummary;
        }
        finally {
            ImmoToolDbUtils.close((Collection)collection);
        }
    }

    public static AgencyExportSummary loadExportSummary(long l, Collection collection) throws ImmoToolDbException {
        try {
            AgencyExportSummary agencyExportSummary = new AgencyExportSummary();
            String string = l + ".xml";
            Properties properties = ImmoToolDbUtils.loadProperties((Collection)collection, (String)string);
            if (properties == null) {
                throw new ImmoToolDbException("properties for export-interface not found!");
            }
            agencyExportSummary.load(properties);
            return agencyExportSummary;
        }
        catch (ImmoToolDbException immoToolDbException) {
            throw immoToolDbException;
        }
        catch (Exception exception) {
            throw new ImmoToolDbException(exception.getLocalizedMessage(), (Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Long[] loadExportSummaryIds() throws ImmoToolDbException {
        Collection collection = null;
        try {
            collection = AgencyPluginUtils.openPluginCollection("/exports/summaries");
            Long[] longArray = AgencyExportSummary.loadExportSummaryIds(collection);
            return longArray;
        }
        finally {
            ImmoToolDbUtils.close((Collection)collection);
        }
    }

    public static Long[] loadExportSummaryIds(Collection collection) throws ImmoToolDbException {
        try {
            TreeSet<Long> treeSet = new TreeSet<Long>();
            for (String string : collection.listResources()) {
                String[] stringArray = string.split("\\.");
                try {
                    treeSet.add(Long.valueOf(stringArray[0]));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return treeSet.toArray(new Long[treeSet.size()]);
        }
        catch (Exception exception) {
            throw new ImmoToolDbException(exception.getLocalizedMessage(), (Throwable)exception);
        }
    }

    public static Object readResponse(String string, Reader reader) throws ImmoToolException {
        return null;
    }

    public static OpenimmoFeedback readResponseForOpenImmo(Reader reader) throws IOException, JAXBException {
        return (OpenimmoFeedback)OpenImmoUtils.unmarshallWithoutNamespace((Reader)reader);
    }

    public void save(Properties properties) throws ImmoToolException {
        int n;
        if (properties == null) {
            return;
        }
        properties.setProperty(KEY_FORMAT, this.getFormat() != null ? this.getFormat() : "");
        properties.setProperty(KEY_FULLTRANSFER, Boolean.valueOf(this.isFullTransfer()).toString());
        properties.setProperty(KEY_ID, String.valueOf(this.getId()));
        properties.setProperty(KEY_INTERFACE_ID, String.valueOf(this.getInterfaceId()));
        properties.setProperty(KEY_INTERFACE_LIMIT, String.valueOf(this.getInterfaceLimit()));
        properties.setProperty(KEY_INTERFACE_NAME, this.getInterfaceName() != null ? this.getInterfaceName() : "");
        properties.setProperty(KEY_MESSAGE, this.getMessage() != null ? this.getMessage() : "");
        properties.setProperty(KEY_SUCCESSFUL, Boolean.valueOf(this.isSuccessful()).toString());
        properties.setProperty(KEY_TRANSPORT, this.getTransport() != null ? this.getTransport() : "");
        Date date = this.getTime();
        properties.setProperty(KEY_TIME, date != null ? String.valueOf(date.getTime()) : "0");
        for (n = 0; n < this.getUpdatedEstateIds().size(); ++n) {
            properties.setProperty("estate.updated." + (n + 1), this.getUpdatedEstateIds().get(n).toString());
        }
        for (n = 0; n < this.getRemovedEstateIds().size(); ++n) {
            properties.setProperty("estate.removed." + (n + 1), this.getRemovedEstateIds().get(n).toString());
        }
        for (Long l : this.getErrorEstateMap().keySet()) {
            properties.setProperty("estate.error." + l, this.getErrorEstateMap().get(l));
        }
    }

    public void setFormat(String string) {
        this.format = string;
    }

    public void setFullTransfer(boolean bl) {
        this.fullTransfer = bl;
    }

    public void setId(long l) {
        this.id = l;
    }

    public void setInterfaceId(long l) {
        this.interfaceId = l;
    }

    public void setInterfaceLimit(long l) {
        this.interfaceLimit = l;
    }

    public void setInterfaceName(String string) {
        this.interfaceName = string;
    }

    public void setMessage(String string) {
        this.message = string;
    }

    public void setSuccessful(boolean bl) {
        this.successful = bl;
    }

    public void setTime(Date date) {
        this.time = date != null ? (Date)date.clone() : null;
    }

    public void setTransport(String string) {
        this.transport = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void storeExportSummary(AgencyExportSummary agencyExportSummary) throws ImmoToolDbException {
        Collection collection = null;
        try {
            collection = AgencyPluginUtils.openPluginCollection("/exports/summaries");
            AgencyExportSummary.storeExportSummary(agencyExportSummary, collection);
        }
        finally {
            ImmoToolDbUtils.close((Collection)collection);
        }
    }

    public static void storeExportSummary(AgencyExportSummary agencyExportSummary, Collection collection) throws ImmoToolDbException {
        try {
            if (agencyExportSummary.getId() <= 0L) {
                long l = ImmoToolApp.getApplication().getDatabase().getNextSequence("OpenEstate-Agency.ExportSummary");
                agencyExportSummary.setId(l);
            }
            String string = agencyExportSummary.getId() + ".xml";
            Properties properties = new Properties();
            agencyExportSummary.save(properties);
            ImmoToolDbUtils.storeProperties((Collection)collection, (Properties)properties, (String)string);
        }
        catch (ImmoToolDbException immoToolDbException) {
            throw immoToolDbException;
        }
        catch (Exception exception) {
            throw new ImmoToolDbException(exception.getLocalizedMessage(), (Throwable)exception);
        }
    }
}

