/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency;

import com.openindex.openestate.tool.ImmoToolApp;
import com.openindex.openestate.tool.ImmoToolException;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.agency.AgencyEstate;
import com.openindex.openestate.tool.agency.AgencyExportInterface;
import com.openindex.openestate.tool.agency.AgencyExportSummary;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextPane;
import javax.swing.LayoutStyle;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.TreePath;
import org.apache.commons.lang.SystemUtils;
import org.apache.log4j.Logger;
import org.jdesktop.application.Action;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.swingx.JXPanel;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.JXTitledSeparator;
import org.jdesktop.swingx.JXTreeTable;
import org.jdesktop.swingx.treetable.AbstractMutableTreeTableNode;
import org.jdesktop.swingx.treetable.AbstractTreeTableModel;
import org.jdesktop.swingx.treetable.MutableTreeTableNode;
import org.jdesktop.swingx.treetable.TreeTableModel;

public class AgencyExportSummaryDialog
extends JDialog {
    private static final Logger LOGGER = Logger.getLogger(AgencyExportSummaryDialog.class);
    public static final int OPENED = 0;
    public static final int CANCELLED = 1;
    public static final int APPROVED = 2;
    private ActionMap actionMap = null;
    private ResourceMap resourceMap = null;
    private int status = 0;
    private TableModel exportTableModel;
    private Map<Long, AgencyExportSummary> exportSummaries;
    private List<String> exportWarnings;
    private JButton cancelButton;
    private JScrollPane exportScroller;
    private JXTreeTable exportTable;
    private JButton helpButton;
    private JButton submitButton;
    private JXTitledSeparator titleLabel;
    private JPanel warningPanel;
    private JScrollPane warningScroller;
    private JTextPane warningText;

    public AgencyExportSummaryDialog() {
        this((Frame)ImmoToolApp.getApplication().getMainFrame(), true);
    }

    public AgencyExportSummaryDialog(Dialog dialog, boolean bl) {
        super(dialog, bl);
        this.build();
        this.setLocationRelativeTo(dialog);
    }

    public AgencyExportSummaryDialog(Frame frame, boolean bl) {
        super(frame, bl);
        this.build();
        this.setLocationRelativeTo(frame);
    }

    private void build() {
        this.actionMap = ImmoToolUtils.getActionMap(AgencyExportSummaryDialog.class, (Object)this);
        this.resourceMap = ImmoToolUtils.getResourceMap(AgencyExportSummaryDialog.class);
        this.setContentPane((Container)new JXPanel());
        this.initComponents();
        this.resourceMap.injectComponents((Component)this);
        this.exportWarnings = new ArrayList<String>();
        this.exportSummaries = new HashMap<Long, AgencyExportSummary>();
        this.exportTableModel = new TableModel();
        this.exportTable.setRootVisible(false);
        this.exportTable.setRolloverEnabled(true);
        this.exportTable.setShowGrid(true);
        this.exportTable.setRowMargin(1);
        this.exportTable.setColumnMargin(1);
        this.exportTable.setDefaultEditor(TableValue.class, (TableCellEditor)new TableNodeEditor());
        this.exportTable.setDefaultRenderer(TableValue.class, (TableCellRenderer)new TableNodeRenderer());
        this.exportTable.getSelectionModel().setSelectionMode(0);
        this.exportTable.setDoubleBuffered(true);
        ImmoToolUtils.configureTable((JXTable)this.exportTable);
        this.submitButton.setAction(this.actionMap.get(this.submitButton.getText()));
        this.cancelButton.setAction(this.actionMap.get(this.cancelButton.getText()));
        this.helpButton.setAction(this.actionMap.get(this.helpButton.getText()));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                AgencyExportSummaryDialog.this.doCancel();
            }
        });
        if (SystemUtils.IS_OS_MAC_OSX) {
            this.cancelButton.setOpaque(false);
            this.submitButton.setOpaque(false);
            this.helpButton.setOpaque(false);
        }
        this.warningPanel.setVisible(false);
        this.warningPanel.setOpaque(false);
        ImmoToolUtils.configureDialog((JDialog)this, (JXPanel)((JXPanel)this.getContentPane()));
    }

    public void addExport(AgencyExportSummary agencyExportSummary, AgencyExportInterface agencyExportInterface) throws ImmoToolException {
        AgencyEstate.Row[] rowArray;
        Object object;
        this.exportSummaries.put(agencyExportSummary.getInterfaceId(), agencyExportSummary);
        TableNode tableNode = this.exportTableModel.getRootNode();
        TableNode tableNode2 = new TableNode(AgencyExportInterface.loadExportInterface(agencyExportSummary.getInterfaceId()));
        Boolean bl = !agencyExportInterface.getExport().isIncremental() ? Boolean.valueOf(true) : null;
        TableNode tableNode3 = agencyExportSummary.getUpdatedEstateIds().isEmpty() ? new TableNode(3, this.resourceMap.getString("message.noUpdates", new Object[0]), null) : new TableNode(3, this.resourceMap.getString("message.countUpdates", new Object[]{agencyExportSummary.getUpdatedEstateIds().size()}), bl);
        List<Long> list = agencyExportSummary.getUpdatedEstateIds();
        if (!list.isEmpty() && (object = AgencyEstate.loadEstateRows(list.toArray(new Long[list.size()]), null, null)) != null && ((AgencyEstate.Row[])object).length > 0) {
            rowArray = object;
            int n = rowArray.length;
            for (int i = 0; i < n; ++i) {
                AgencyEstate.Row row = rowArray[i];
                tableNode3.add((MutableTreeTableNode)new TableNode(row, !agencyExportInterface.getExport().isIncremental()));
            }
        }
        tableNode2.add((MutableTreeTableNode)tableNode3);
        if (agencyExportInterface.getExport().isIncremental()) {
            list = agencyExportSummary.getRemovedEstateIds();
            Object object2 = object = list.isEmpty() ? new TableNode(3, this.resourceMap.getString("message.noDeletes", new Object[0])) : new TableNode(3, this.resourceMap.getString("message.countDeletes", new Object[]{list.size()}));
            if (!list.isEmpty() && (rowArray = AgencyEstate.loadEstateRows(list.toArray(new Long[list.size()]), null, null)) != null) {
                for (Long l : list) {
                    boolean bl2 = false;
                    for (AgencyEstate.Row row : rowArray) {
                        if (row.id != l) continue;
                        bl2 = true;
                        object.add((MutableTreeTableNode)new TableNode(row, false));
                        break;
                    }
                    if (bl2) continue;
                    AgencyEstate.Row row = new AgencyEstate.Row();
                    row.id = l;
                    row.title = this.resourceMap.getString("message.estateIsLocallyDeleted", new Object[0]);
                    object.add((MutableTreeTableNode)new TableNode(row, false));
                }
            }
            tableNode2.add((MutableTreeTableNode)object);
        }
        tableNode.add((MutableTreeTableNode)tableNode2);
        if (!agencyExportInterface.getExport().isIncremental() && agencyExportInterface.getExport().isFullTransportWarningShown()) {
            int n = this.exportWarnings.size() + 1;
            this.exportWarnings.add("<p style=\"margin-top:0; margin-bottom:5px; font-size:10px;\"><b style=\"font-size:11px;\">" + n + ". " + this.resourceMap.getString("message.exportWarning", new Object[0]) + " '" + agencyExportInterface.getTitle() + "' / " + agencyExportInterface.getExport().getTitle() + "</b><br>" + this.resourceMap.getString("message.exportWarning.fullTransfer", new Object[0]) + "</p>");
        }
    }

    public void addExportInterface(AgencyExportInterface agencyExportInterface) throws ImmoToolException {
        this.addExport(AgencyExportSummary.buildSummary(agencyExportInterface), agencyExportInterface);
    }

    public void addExportSummary(AgencyExportSummary agencyExportSummary) throws ImmoToolException {
        this.addExport(agencyExportSummary, AgencyExportInterface.loadExportInterface(agencyExportSummary.getInterfaceId()));
    }

    @Action
    public void doCancel() {
        this.status = 1;
        this.setVisible(false);
    }

    @Action
    public void doHelp() {
        ImmoToolUtils.showHelpDialog((String)"agency.export.send", (boolean)true);
    }

    @Action
    public void doSubmit() {
        ArrayList<String> arrayList = new ArrayList<String>();
        TableNode tableNode = this.exportTableModel.getRootNode();
        for (int i = 0; i < tableNode.getChildCount(); ++i) {
            TableNode tableNode2 = (TableNode)tableNode.getChildAt(i);
            AgencyExportInterface object = (AgencyExportInterface)tableNode2.getValue();
            AgencyExportSummary agencyExportSummary = this.exportSummaries.get(object.getId());
            ArrayList<Long> arrayList2 = new ArrayList<Long>();
            arrayList2.addAll(agencyExportSummary.getUpdatedEstateIds());
            ArrayList<Long> arrayList3 = new ArrayList<Long>();
            arrayList3.addAll(agencyExportSummary.getRemovedEstateIds());
            agencyExportSummary.getUpdatedEstateIds().clear();
            agencyExportSummary.getRemovedEstateIds().clear();
            for (int j = 0; j < tableNode2.getChildCount(); ++j) {
                TableNode tableNode3 = (TableNode)tableNode2.getChildAt(j);
                if (tableNode3.getType() != 3) continue;
                for (int k = 0; k < tableNode3.getChildCount(); ++k) {
                    TableNode tableNode4 = (TableNode)tableNode3.getChildAt(k);
                    if (tableNode4.getType() != 4) continue;
                    Object object2 = tableNode4.getValue();
                    Long l = null;
                    if (!(object2 instanceof AgencyEstate.Row)) {
                        LOGGER.warn((Object)"invalid estate-value!");
                        LOGGER.warn((Object)("> " + object2));
                        continue;
                    }
                    l = ((AgencyEstate.Row)tableNode4.getValue()).id;
                    boolean bl = ((TableValue)tableNode4.getValueAt(1)).isActive();
                    if (!Boolean.TRUE.equals(bl)) continue;
                    if (arrayList2.contains(l)) {
                        agencyExportSummary.getUpdatedEstateIds().add(l);
                        continue;
                    }
                    if (arrayList3.contains(l)) {
                        agencyExportSummary.getRemovedEstateIds().add(l);
                        continue;
                    }
                    LOGGER.warn((Object)("unknown export-mode for estate #" + l));
                }
            }
            if (agencyExportSummary.getUpdatedEstateIds().isEmpty() && agencyExportSummary.getRemovedEstateIds().isEmpty()) {
                arrayList.add("<b>" + object.getTitle() + "</b><br>" + this.resourceMap.getString("error.noEstatesToExport", new Object[0]));
            }
            if (agencyExportSummary.getInterfaceLimit() <= 0L || agencyExportSummary.getInterfaceLimit() >= (long)agencyExportSummary.getUpdatedEstateIds().size()) continue;
            arrayList.add("<b>" + object.getTitle() + "</b><br>" + this.resourceMap.getString("error.exportLimitReached", new Object[0]));
        }
        if (!arrayList.isEmpty()) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("<html>");
            stringBuilder.append("<b>").append(this.resourceMap.getString("error.problemOccured", new Object[0])).append("</b>");
            stringBuilder.append("<ul>");
            for (String string : arrayList) {
                stringBuilder.append("<li>").append(string).append("</li>");
            }
            stringBuilder.append("</ul>");
            stringBuilder.append(this.resourceMap.getString("question.ignoreProblemsAndContinue", new Object[0]));
            stringBuilder.append("</html>");
            if (!ImmoToolUtils.showQuestionDialog((String)stringBuilder.toString(), (Component)this)) {
                return;
            }
        }
        this.status = 2;
        this.setVisible(false);
    }

    public void finishTable() {
        this.exportTable.setEnabled(false);
        this.exportTable.setTreeTableModel((TreeTableModel)this.exportTableModel);
        this.exportTable.packAll();
        this.exportTable.expandAll();
        this.exportTable.setEnabled(true);
        if (!this.exportWarnings.isEmpty()) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("<html><head></head><body style=\"font-family:sans-serif;\">");
            for (String string : this.exportWarnings) {
                stringBuilder.append(string);
            }
            stringBuilder.append("</body></html>");
            this.warningText.setContentType("text/html");
            this.warningText.setText(stringBuilder.toString());
            this.warningText.setCaretPosition(0);
            this.warningPanel.setVisible(true);
        }
    }

    public int getStatus() {
        return this.status;
    }

    public AgencyExportSummary getSummary(long l) {
        return this.exportSummaries.containsKey(l) ? this.exportSummaries.get(l) : null;
    }

    private void initComponents() {
        this.titleLabel = ImmoToolUtils.createHead1Separator((String)"");
        this.exportScroller = new JScrollPane();
        this.exportTable = new TreeTable();
        this.warningPanel = new JPanel();
        this.warningScroller = new JScrollPane();
        this.warningText = new JTextPane();
        this.helpButton = new JButton();
        this.submitButton = new JButton();
        this.cancelButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setName("Form");
        this.titleLabel.setName("titleLabel");
        this.titleLabel.setTitle("titleLabel");
        this.exportScroller.setName("exportScroller");
        this.exportTable.setName("exportTable");
        this.exportScroller.setViewportView((Component)this.exportTable);
        this.warningPanel.setName("warningPanel");
        this.warningScroller.setBorder(BorderFactory.createLineBorder(new Color(255, 0, 0), 2));
        this.warningScroller.setName("warningScroller");
        this.warningText.setBackground(new Color(255, 254, 225));
        this.warningText.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        this.warningText.setEditable(false);
        this.warningText.setName("warningText");
        this.warningScroller.setViewportView(this.warningText);
        GroupLayout groupLayout = new GroupLayout(this.warningPanel);
        this.warningPanel.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.warningScroller, -1, 672, Short.MAX_VALUE));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.warningScroller, GroupLayout.Alignment.TRAILING, -1, 97, Short.MAX_VALUE));
        this.helpButton.setText("doHelp");
        this.helpButton.setName("helpButton");
        this.submitButton.setText("doSubmit");
        this.submitButton.setName("submitButton");
        this.cancelButton.setText("doCancel");
        this.cancelButton.setName("cancelButton");
        GroupLayout groupLayout2 = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout2.createSequentialGroup().addContainerGap().addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.exportScroller, GroupLayout.Alignment.LEADING, -1, 672, Short.MAX_VALUE).addComponent(this.warningPanel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent((Component)this.titleLabel, GroupLayout.Alignment.LEADING, -1, 672, Short.MAX_VALUE).addGroup(groupLayout2.createSequentialGroup().addComponent(this.helpButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 382, Short.MAX_VALUE).addComponent(this.submitButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelButton))).addContainerGap()));
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addComponent((Component)this.titleLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.exportScroller, -1, 321, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.warningPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cancelButton).addComponent(this.submitButton).addComponent(this.helpButton)).addContainerGap()));
        this.pack();
    }

    private static final class TableValue {
        private boolean active;
        private boolean enabled;

        public TableValue(boolean bl, boolean bl2) {
            this.active = bl;
            this.enabled = bl2;
        }

        public boolean isActive() {
            return this.active;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setActive(boolean bl) {
            this.active = bl;
        }

        public void setEnabled(boolean bl) {
            this.enabled = bl;
        }
    }

    private static final class TableNodeRenderer
    implements TableCellRenderer {
        private JLabel label = new JLabel();
        private JCheckBox box = new JCheckBox();

        private TableNodeRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            JComponent jComponent = null;
            if (object == null) {
                jComponent = this.label;
                this.label.setText("");
            } else {
                jComponent = this.box;
                this.box.setSelected(((TableValue)object).isActive());
                this.box.setEnabled(((TableValue)object).isEnabled());
                this.box.setHorizontalAlignment(0);
            }
            jComponent.setOpaque(true);
            jComponent.setBackground(bl ? jTable.getSelectionBackground() : (n % 2 != 0 ? ImmoToolUtils.TABLE_HIGHLIGHT_COLOR : Color.WHITE));
            jComponent.setForeground(bl ? jTable.getSelectionForeground() : jComponent.getForeground());
            return jComponent;
        }
    }

    private static final class TableNodeEditor
    implements TableCellEditor {
        private List<CellEditorListener> listeners = new ArrayList<CellEditorListener>();
        private JComponent component = null;
        private TableValue componentValue = null;

        private TableNodeEditor() {
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            if (jTable.getSelectedRow() != n) {
                jTable.getSelectionModel().setSelectionInterval(n, n);
            }
            bl = true;
            this.component = null;
            if (object == null) {
                this.component = new JLabel("");
                this.componentValue = null;
            } else {
                JXTreeTable jXTreeTable;
                TreePath treePath;
                TableNode tableNode;
                this.componentValue = (TableValue)object;
                JCheckBox jCheckBox = new JCheckBox();
                jCheckBox.setSelected(this.componentValue.isActive());
                jCheckBox.setEnabled(this.componentValue.isEnabled());
                jCheckBox.setHorizontalAlignment(0);
                if (jTable instanceof JXTreeTable && (tableNode = (TableNode)((Object)(treePath = (jXTreeTable = (JXTreeTable)jTable).getPathForRow(n)).getLastPathComponent())).getType() == 3 && tableNode.getValueAt(1) != null) {
                    jCheckBox.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            JCheckBox jCheckBox = (JCheckBox)actionEvent.getSource();
                            for (int i = 0; i < tableNode.getChildCount(); ++i) {
                                ((TableValue)tableNode.getChildAt(i).getValueAt(1)).setActive(jCheckBox.isSelected());
                            }
                            jXTreeTable.repaint();
                        }
                    });
                }
                this.component = jCheckBox;
            }
            this.component.setOpaque(true);
            this.component.setBackground(bl ? jTable.getSelectionBackground() : (n % 2 != 0 ? ImmoToolUtils.TABLE_HIGHLIGHT_COLOR : Color.WHITE));
            this.component.setForeground(bl ? jTable.getSelectionForeground() : this.component.getForeground());
            return this.component;
        }

        @Override
        public Object getCellEditorValue() {
            if (this.component instanceof JCheckBox) {
                this.componentValue.setActive(((JCheckBox)this.component).isSelected());
                return this.componentValue;
            }
            return null;
        }

        @Override
        public boolean isCellEditable(EventObject eventObject) {
            return true;
        }

        @Override
        public boolean shouldSelectCell(EventObject eventObject) {
            return false;
        }

        @Override
        public boolean stopCellEditing() {
            for (CellEditorListener cellEditorListener : this.listeners.toArray(new CellEditorListener[this.listeners.size()])) {
                cellEditorListener.editingStopped(new ChangeEvent(this));
            }
            return true;
        }

        @Override
        public void cancelCellEditing() {
            for (CellEditorListener cellEditorListener : this.listeners.toArray(new CellEditorListener[this.listeners.size()])) {
                cellEditorListener.editingStopped(new ChangeEvent(this));
            }
        }

        @Override
        public void addCellEditorListener(CellEditorListener cellEditorListener) {
            this.listeners.add(cellEditorListener);
        }

        @Override
        public void removeCellEditorListener(CellEditorListener cellEditorListener) {
            this.listeners.remove(cellEditorListener);
        }
    }

    private class TableNode
    extends AbstractMutableTreeTableNode {
        public static final int ROOT = 0;
        public static final int EXPORT = 1;
        public static final int EXPORT_INFO = 2;
        public static final int EXPORT_CONTAINER = 3;
        public static final int EXPORT_ESTATE = 4;
        private int nodeType = 0;
        private Object nodeValue = null;
        private TableValue nodeActive = null;

        public TableNode() {
            this(0, null, null);
        }

        public TableNode(AgencyExportInterface agencyExportInterface) {
            this(1, agencyExportInterface);
            String string = agencyExportInterface.getLimit() > 0L ? agencyExportSummaryDialog.resourceMap.getString("message.exportIsLimited", new Object[]{agencyExportInterface.getLimit()}) : agencyExportSummaryDialog.resourceMap.getString("message.exportIsUnlimited", new Object[0]);
            this.add((MutableTreeTableNode)agencyExportSummaryDialog.new TableNode(2, string));
            if (!agencyExportInterface.getExport().isIncremental()) {
                this.add((MutableTreeTableNode)agencyExportSummaryDialog.new TableNode(2, agencyExportSummaryDialog.resourceMap.getString("message.unchangedEstatesAreDeleted", new Object[0])));
            }
        }

        public TableNode(AgencyEstate.Row row, boolean bl) {
            this(4, row, bl);
        }

        public TableNode(int n, Object object) {
            this(n, object, null);
        }

        public TableNode(int n, Object object, Boolean bl) {
            this.nodeType = n;
            this.nodeValue = object;
            this.nodeActive = bl != null ? new TableValue(true, bl) : null;
        }

        public int getType() {
            return this.nodeType;
        }

        public Object getValue() {
            return this.nodeValue;
        }

        public Object getValueAt(int n) {
            if (this.nodeType == 0) {
                switch (n) {
                    case 0: {
                        return "";
                    }
                    case 1: {
                        return null;
                    }
                }
                return null;
            }
            if (this.nodeType == 1) {
                AgencyExportInterface agencyExportInterface = (AgencyExportInterface)this.nodeValue;
                switch (n) {
                    case 0: {
                        String string = agencyExportInterface.getExport().isIncremental() ? "message.incrementalUpdate" : "message.fullUpdate";
                        return "<html><b>" + agencyExportInterface.getTitle() + "</b> (" + AgencyExportSummaryDialog.this.resourceMap.getString(string, new Object[0]) + ")</html>";
                    }
                    case 1: {
                        return null;
                    }
                }
                return null;
            }
            if (this.nodeType == 2) {
                String string = (String)this.nodeValue;
                switch (n) {
                    case 0: {
                        return "<html><i>" + string + "</i></html>";
                    }
                    case 1: {
                        return null;
                    }
                }
                return null;
            }
            if (this.nodeType == 3) {
                String string = (String)this.nodeValue;
                switch (n) {
                    case 0: {
                        return "<html>" + string + "</html>";
                    }
                    case 1: {
                        return this.nodeActive;
                    }
                }
                return null;
            }
            if (this.nodeType == 4) {
                if (this.nodeValue instanceof AgencyEstate.Row) {
                    AgencyEstate.Row row = (AgencyEstate.Row)this.nodeValue;
                    switch (n) {
                        case 0: {
                            String string = String.valueOf(row.id);
                            if (row.publicId != null && row.publicId.trim().length() > 0) {
                                string = string + " / " + row.publicId.trim();
                            }
                            return "<html>" + AgencyExportSummaryDialog.this.resourceMap.getString("message.estate", new Object[]{string}) + "</html>";
                        }
                        case 1: {
                            return this.nodeActive;
                        }
                    }
                    return null;
                }
                return null;
            }
            return null;
        }

        public int getColumnCount() {
            return 3;
        }

        public boolean isEditable(int n) {
            return n == 1 && (this.nodeType == 4 || this.nodeType == 3);
        }
    }

    private class TableModel
    extends AbstractTreeTableModel {
        public static final int COL_NAME = 0;
        public static final int COL_ACTION = 1;
        private Map<Integer, Class> CLASSES;
        private Map<Integer, String> TITLES;
        private TableNode rootNode;

        public TableModel() {
            super((Object)new TableNode());
            this.rootNode = null;
            this.rootNode = (TableNode)((Object)this.getRoot());
            this.CLASSES = new HashMap<Integer, Class>();
            this.CLASSES.put(0, String.class);
            this.CLASSES.put(1, TableValue.class);
            this.TITLES = new HashMap<Integer, String>();
            this.TITLES.put(0, "exportTableCol.name");
            this.TITLES.put(1, "exportTableCol.export");
        }

        public Class getColumnClass(int n) {
            return this.CLASSES.get(n);
        }

        public int getColumnCount() {
            return this.CLASSES.size();
        }

        public String getColumnName(int n) {
            return AgencyExportSummaryDialog.this.resourceMap.getString(this.TITLES.get(n), new Object[0]);
        }

        public TableNode getRootNode() {
            return this.rootNode;
        }

        public Object getValueAt(Object object, int n) {
            TableNode tableNode = (TableNode)((Object)object);
            return tableNode.getValueAt(n);
        }

        public Object getChild(Object object, int n) {
            TableNode tableNode = (TableNode)((Object)object);
            return tableNode.getChildAt(n);
        }

        public int getChildCount(Object object) {
            TableNode tableNode = (TableNode)((Object)object);
            return tableNode.getChildCount();
        }

        public int getIndexOfChild(Object object, Object object2) {
            TableNode tableNode = (TableNode)((Object)object);
            for (int i = 0; i < tableNode.getChildCount(); ++i) {
                if (tableNode.getChildAt(i) != object2) continue;
                return i;
            }
            return -1;
        }

        public boolean isCellEditable(Object object, int n) {
            TableNode tableNode = (TableNode)((Object)object);
            return tableNode.isEditable(n);
        }
    }

    private static final class TreeTable
    extends JXTreeTable {
        private TreeTable() {
        }

        public String getToolTipText(MouseEvent mouseEvent) {
            int n = this.rowAtPoint(mouseEvent.getPoint());
            TreePath treePath = this.getPathForRow(n);
            if (treePath == null) {
                return null;
            }
            TableNode tableNode = (TableNode)((Object)treePath.getLastPathComponent());
            if (tableNode.getType() != 4) {
                return null;
            }
            AgencyEstate.Row row = (AgencyEstate.Row)tableNode.getValue();
            return row.writeToolTip();
        }
    }
}

