/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency;

import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.agency.AgencyExportSummary;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.table.DefaultTableModel;
import org.jdesktop.application.ResourceMap;

public class AgencyExportSummaryTableModel
extends DefaultTableModel {
    public static final int COLUMN_ID = 0;
    public static final int COLUMN_TIME = 1;
    public static final int COLUMN_TITLE = 2;
    public static final int COLUMN_MODE = 3;
    public static final int COLUMN_COUNT_CHANGES = 4;
    public static final int COLUMN_COUNT_DELETES = 5;
    public static final int COLUMN_COUNT_ERRORS = 6;
    public static final int COLUMN_IS_SUCCESSFUL = 7;
    private static final Map<Integer, String> COLUMN_NAMES = new HashMap<Integer, String>();
    private static final Map<Integer, Class> COLUMN_CLASSES;
    private final ResourceMap resourceMap = ImmoToolUtils.getResourceMap(AgencyExportSummaryTableModel.class);

    public AgencyExportSummaryTableModel() {
        this.setColumnCount(COLUMN_NAMES.size());
    }

    public void addExportSummary(AgencyExportSummary agencyExportSummary) {
        this.addRow(this.buildRow(agencyExportSummary));
    }

    private Object[] buildRow(AgencyExportSummary agencyExportSummary) {
        TreeMap<Integer, Object> treeMap = new TreeMap<Integer, Object>();
        treeMap.put(0, agencyExportSummary.getId());
        treeMap.put(1, agencyExportSummary.getTime());
        treeMap.put(2, agencyExportSummary.getInterfaceName());
        treeMap.put(3, this.resourceMap.getString(agencyExportSummary.isFullTransfer() ? "mode.full" : "mode.incremental", new Object[0]));
        treeMap.put(7, agencyExportSummary.isSuccessful());
        treeMap.put(4, agencyExportSummary.getUpdatedEstateIds().size());
        treeMap.put(5, agencyExportSummary.getRemovedEstateIds().size());
        treeMap.put(6, agencyExportSummary.getErrorEstateIds().size());
        return treeMap.values().toArray(new Object[treeMap.size()]);
    }

    public void clear() {
        while (this.getRowCount() > 0) {
            this.removeRow(0);
        }
    }

    public Class getColumnClass(int n) {
        return COLUMN_CLASSES.containsKey(n) ? COLUMN_CLASSES.get(n) : null;
    }

    @Override
    public String getColumnName(int n) {
        return COLUMN_NAMES.containsKey(n) ? this.resourceMap.getString(COLUMN_NAMES.get(n), new Object[0]) : null;
    }

    public Long getExportSummaryIdAt(int n) {
        return (Long)this.getValueAt(n, 0);
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return false;
    }

    static {
        COLUMN_NAMES.put(0, "col.id");
        COLUMN_NAMES.put(1, "col.timestamp");
        COLUMN_NAMES.put(2, "col.interface");
        COLUMN_NAMES.put(3, "col.mode");
        COLUMN_NAMES.put(4, "col.countChanges");
        COLUMN_NAMES.put(5, "col.countRemoves");
        COLUMN_NAMES.put(6, "col.countErrors");
        COLUMN_NAMES.put(7, "col.isTransported");
        COLUMN_CLASSES = new HashMap<Integer, Class>();
        COLUMN_CLASSES.put(0, Long.class);
        COLUMN_CLASSES.put(1, Date.class);
        COLUMN_CLASSES.put(2, String.class);
        COLUMN_CLASSES.put(3, String.class);
        COLUMN_CLASSES.put(4, Long.class);
        COLUMN_CLASSES.put(5, Long.class);
        COLUMN_CLASSES.put(6, Long.class);
        COLUMN_CLASSES.put(7, Boolean.class);
    }
}

