/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency;

import com.openindex.openestate.tool.ImmoToolDbUtils;
import com.openindex.openestate.tool.ImmoToolException;
import com.openindex.openestate.tool.ImmoToolTabPanel;
import com.openindex.openestate.tool.ImmoToolTask;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.agency.AgencyExportSummary;
import com.openindex.openestate.tool.agency.AgencyExportSummaryTableModel;
import com.openindex.openestate.tool.agency.AgencyExportSummaryViewPanel;
import com.openindex.openestate.tool.agency.AgencyPluginUtils;
import com.openindex.openestate.tool.utils.QuickTableExport;
import com.openindex.openestate.tool.utils.TabComponent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.DateFormat;
import java.util.Date;
import javax.swing.ActionMap;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.apache.log4j.Logger;
import org.jdesktop.application.Action;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationActionMap;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.application.Task;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.JXTitledSeparator;
import org.xmldb.api.base.Collection;

public class AgencyExportSummaryTablePanel
extends ImmoToolTabPanel {
    private static final Logger LOGGER = Logger.getLogger(AgencyExportSummaryTablePanel.class);
    private static final DateFormat DATE_FORMAT = DateFormat.getDateTimeInstance(2, 3);
    private ActionMap actionMap;
    private ResourceMap resourceMap;
    private JPopupMenu interfacePopupMenu;
    private AgencyExportSummaryTableModel exportTableModel;
    private JButton closeButton;
    private JXTable exportTable;
    private JScrollPane exportTableScroller;
    private JButton helpButton;
    private JXTitledSeparator infoTitle;
    private JButton refreshButton;
    private JButton viewButton;

    public AgencyExportSummaryTablePanel() {
        this.build();
    }

    private void build() {
        this.actionMap = ImmoToolUtils.getActionMap(AgencyExportSummaryTablePanel.class, (Object)((Object)this));
        this.resourceMap = ImmoToolUtils.getResourceMap(AgencyExportSummaryTablePanel.class);
        this.initComponents();
        this.resourceMap.injectComponents((Component)((Object)this));
        this.exportTableModel = new AgencyExportSummaryTableModel();
        this.exportTable.setModel((TableModel)this.exportTableModel);
        this.exportTable.setSortable(true);
        this.exportTable.setColumnControlVisible(true);
        this.exportTable.getSelectionModel().setSelectionMode(0);
        this.exportTable.removeColumn(this.exportTable.getColumn(0));
        this.exportTable.setColumnControl((JComponent)QuickTableExport.createColumnControl((JXTable)this.exportTable));
        ImmoToolUtils.configureTable((JXTable)this.exportTable);
        this.exportTable.setDefaultRenderer(Date.class, (TableCellRenderer)new DefaultTableCellRenderer(){
            JLabel label = null;

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                if (this.label == null) {
                    this.label = new JLabel();
                }
                this.label.setText(object != null ? DATE_FORMAT.format(object) : AgencyExportSummaryTablePanel.this.resourceMap.getString("label.unknown", new Object[0]));
                this.label.setOpaque(true);
                this.label.setBackground(bl ? jTable.getSelectionBackground() : (n % 2 != 0 ? ImmoToolUtils.TABLE_HIGHLIGHT_COLOR : Color.WHITE));
                this.label.setForeground(bl ? jTable.getSelectionForeground() : Color.BLACK);
                return this.label;
            }
        });
        this.exportTable.packAll();
        this.exportTable.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getButton() == 1 && mouseEvent.getClickCount() == 2) {
                    int n = AgencyExportSummaryTablePanel.this.exportTable.getSelectedRow();
                    if (n < 0) {
                        return;
                    }
                    ImmoToolUtils.executeTask((Task)AgencyExportSummaryTablePanel.this.doView());
                } else if (mouseEvent.getButton() == 3 && mouseEvent.getClickCount() == 1) {
                    int n = AgencyExportSummaryTablePanel.this.exportTable.rowAtPoint(mouseEvent.getPoint());
                    if (n >= 0 && n != AgencyExportSummaryTablePanel.this.exportTable.getSelectedRow() && n >= 0) {
                        AgencyExportSummaryTablePanel.this.exportTable.getSelectionModel().setSelectionInterval(n, n);
                    }
                    if (n < 0) {
                        n = AgencyExportSummaryTablePanel.this.exportTable.getSelectedRow();
                    }
                    if (n < 0) {
                        return;
                    }
                    AgencyExportSummaryTablePanel.this.interfacePopupMenu.show((Component)AgencyExportSummaryTablePanel.this.exportTable, ((AgencyExportSummaryTablePanel)AgencyExportSummaryTablePanel.this).exportTable.getMousePosition().x, ((AgencyExportSummaryTablePanel)AgencyExportSummaryTablePanel.this).exportTable.getMousePosition().y);
                }
            }
        });
        this.exportTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                AgencyExportSummaryTablePanel.this.viewButton.setEnabled(AgencyExportSummaryTablePanel.this.exportTable.getSelectedRow() >= 0);
            }
        });
        this.viewButton.setEnabled(false);
        this.interfacePopupMenu = new JPopupMenu();
        this.interfacePopupMenu.add(new JMenuItem(this.actionMap.get("doInterfaceModify")));
        this.interfacePopupMenu.add(new JMenuItem(this.actionMap.get("doInterfaceRemove")));
    }

    @Action
    public void doClose() {
        ImmoToolUtils.removePanel((String)this.getTabTitle());
    }

    @Action
    public void doHelp() {
        ImmoToolUtils.showHelpDialog((String)"agency.export");
    }

    @Action
    public Task doRefresh() {
        this.setActionsButtonsEnabled(false);
        return new ImmoToolTask<Boolean>(){

            protected Boolean executeTask() throws Exception {
                AgencyExportSummaryTablePanel.this.refresh();
                return true;
            }

            protected void finished() {
                super.finished();
                AgencyExportSummaryTablePanel.this.setActionsButtonsEnabled(true);
            }
        };
    }

    @Action
    public Task doView() {
        if (this.exportTable.getSelectedRowCount() < 1) {
            return null;
        }
        int n = this.exportTable.convertRowIndexToModel(this.exportTable.getSelectedRow());
        final Long l = this.exportTableModel.getExportSummaryIdAt(n);
        if (l == null) {
            return null;
        }
        String string = AgencyExportSummaryViewPanel.getInstanceTabTitle(l);
        if (ImmoToolUtils.selectPanel((String)string)) {
            return null;
        }
        this.setActionsButtonsEnabled(false);
        return new ImmoToolTask<AgencyExportSummaryViewPanel>(){

            protected AgencyExportSummaryViewPanel executeTask() throws Exception {
                AgencyExportSummary agencyExportSummary = AgencyExportSummary.loadExportSummary(l);
                if (agencyExportSummary == null) {
                    throw new Exception(AgencyExportSummaryTablePanel.this.resourceMap.getString("error.cantFindSummary", new Object[]{l}));
                }
                AgencyExportSummaryViewPanel agencyExportSummaryViewPanel = new AgencyExportSummaryViewPanel();
                agencyExportSummaryViewPanel.load(agencyExportSummary);
                return agencyExportSummaryViewPanel;
            }

            protected void failed(Throwable throwable) {
                super.failed(throwable);
                ImmoToolUtils.showMessageErrorDialog((String)AgencyExportSummaryTablePanel.this.resourceMap.getString("error.cantOpenSummary", new Object[0]), (Throwable)throwable);
            }

            protected void finished() {
                super.finished();
                AgencyExportSummaryTablePanel.this.setActionsButtonsEnabled(true);
            }

            protected void succeeded(AgencyExportSummaryViewPanel agencyExportSummaryViewPanel) {
                super.succeeded((Object)agencyExportSummaryViewPanel);
                ImmoToolUtils.showPanel((TabComponent)agencyExportSummaryViewPanel);
            }
        };
    }

    public AgencyExportSummaryTableModel getExportTableModel() {
        return this.exportTableModel;
    }

    public static String getInstanceTabTitle() {
        return ImmoToolUtils.getResourceMap(AgencyExportSummaryTablePanel.class).getString("title", new Object[0]);
    }

    public String getTabTitle() {
        return AgencyExportSummaryTablePanel.getInstanceTabTitle();
    }

    public void refresh() throws ImmoToolException {
        this.exportTable.editingStopped(new ChangeEvent(this.exportTable));
        this.exportTable.getSelectionModel().clearSelection();
        this.exportTable.setVisible(false);
        this.exportTableModel.clear();
        Collection collection = null;
        try {
            collection = AgencyPluginUtils.openPluginCollection("/exports/summaries");
            for (Long l : AgencyExportSummary.loadExportSummaryIds(collection)) {
                this.exportTableModel.addExportSummary(AgencyExportSummary.loadExportSummary(l, collection));
            }
            this.exportTable.packAll();
        }
        catch (Exception exception) {
            try {
                LOGGER.error((Object)"could not load export-interfaces!");
                LOGGER.error((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
                throw new ImmoToolException(exception.getLocalizedMessage(), (Throwable)exception);
            }
            catch (Throwable throwable) {
                ImmoToolDbUtils.close((Collection)collection);
                this.exportTable.setVisible(true);
                this.infoTitle.setTitle(this.resourceMap.getString("infoTitle.title", new Object[0]) + " / " + this.resourceMap.getString("message.resultCount", new Object[]{this.exportTable.getRowCount()}));
                throw throwable;
            }
        }
        ImmoToolDbUtils.close((Collection)collection);
        this.exportTable.setVisible(true);
        this.infoTitle.setTitle(this.resourceMap.getString("infoTitle.title", new Object[0]) + " / " + this.resourceMap.getString("message.resultCount", new Object[]{this.exportTable.getRowCount()}));
    }

    public void refreshTab() {
        ImmoToolUtils.executeTask((Task)this.doRefresh());
    }

    private void setActionsButtonsEnabled(boolean bl) {
        this.refreshButton.setEnabled(bl);
        this.viewButton.setEnabled(bl);
    }

    private void initComponents() {
        this.infoTitle = ImmoToolUtils.createHead1Separator((String)"");
        this.refreshButton = new JButton();
        this.viewButton = new JButton();
        this.helpButton = new JButton();
        this.closeButton = new JButton();
        this.exportTableScroller = new JScrollPane();
        this.exportTable = new JXTable();
        this.setName("Form");
        this.infoTitle.setName("infoTitle");
        ApplicationActionMap applicationActionMap = Application.getInstance().getContext().getActionMap(AgencyExportSummaryTablePanel.class, (Object)this);
        this.refreshButton.setAction(applicationActionMap.get("doRefresh"));
        this.refreshButton.setName("refreshButton");
        this.viewButton.setAction(applicationActionMap.get("doView"));
        this.viewButton.setName("viewButton");
        this.helpButton.setAction(applicationActionMap.get("doHelp"));
        this.helpButton.setName("helpButton");
        this.closeButton.setAction(applicationActionMap.get("doClose"));
        this.closeButton.setName("closeButton");
        this.exportTableScroller.setName("exportTableScroller");
        this.exportTable.setName("exportTable");
        this.exportTableScroller.setViewportView((Component)this.exportTable);
        GroupLayout groupLayout = new GroupLayout((Container)((Object)this));
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.exportTableScroller, GroupLayout.Alignment.LEADING, -1, 777, Short.MAX_VALUE).addGroup(groupLayout.createSequentialGroup().addComponent((Component)this.infoTitle, -1, 527, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.refreshButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.viewButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.helpButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.closeButton))).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.closeButton).addComponent(this.helpButton).addComponent(this.viewButton).addComponent(this.refreshButton)).addComponent((Component)this.infoTitle, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.exportTableScroller, -1, 430, Short.MAX_VALUE).addContainerGap()));
        ResourceMap resourceMap = Application.getInstance().getContext().getResourceMap(AgencyExportSummaryTablePanel.class);
        resourceMap.injectComponents((Component)((Object)this));
    }
}

