/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.openindex.openestate.tool.ImmoToolTabPanel;
import com.openindex.openestate.tool.ImmoToolTask;
import com.openindex.openestate.tool.ImmoToolTaskDialog;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.agency.AgencyExportInterface;
import com.openindex.openestate.tool.agency.AgencyExportSummary;
import com.openindex.openestate.tool.agency.AgencyExportTaskContainer;
import com.openindex.openestate.tool.utils.QuickTableExport;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.text.DateFormat;
import java.util.Date;
import java.util.TreeSet;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import org.jdesktop.application.Action;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationActionMap;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.application.Task;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.JXTitledSeparator;

public class AgencyExportSummaryViewPanel
extends ImmoToolTabPanel {
    private ResourceMap resourceMap = null;
    private AgencyExportSummary summary;
    private JTextField interfaceNameField;
    private JTextField interfaceLimitField;
    private JTextField interfaceModeField;
    private JTextField messageField;
    private JTextField timeField;
    private JTextField formatField;
    private JTextField transportField;
    private JButton closeButton;
    private JXTable detailsTable;
    private JScrollPane detailsTableScroller;
    private JXTitledSeparator detailsTitle;
    private JButton executeButton;
    private JButton helpButton;
    private JXTitledSeparator infoTitle;
    private JPanel summaryPanel;

    public AgencyExportSummaryViewPanel() {
        this.build();
    }

    private void build() {
        this.resourceMap = ImmoToolUtils.getResourceMap(AgencyExportSummaryViewPanel.class);
        this.initComponents();
        this.buildSummaryForm(this.summaryPanel);
        this.resourceMap.injectComponents((Component)((Object)this));
        this.detailsTable.getColumn(0).setHeaderValue(this.resourceMap.getString("col.estateId", new Object[0]));
        this.detailsTable.getColumn(1).setHeaderValue(this.resourceMap.getString("col.message", new Object[0]));
        this.detailsTable.setColumnControl((JComponent)QuickTableExport.createColumnControl((JXTable)this.detailsTable));
        ImmoToolUtils.configureTable((JXTable)this.detailsTable);
    }

    private void buildSummaryForm(JPanel jPanel) {
        this.interfaceModeField = new JTextField();
        this.interfaceModeField.setName("interfaceModeField");
        this.interfaceModeField.setEditable(false);
        this.interfaceNameField = new JTextField();
        this.interfaceNameField.setName("interfaceNameField");
        this.interfaceNameField.setEditable(false);
        this.interfaceLimitField = new JTextField();
        this.interfaceLimitField.setName("interfaceLimitField");
        this.interfaceLimitField.setEditable(false);
        this.messageField = new JTextField();
        this.messageField.setName("messageField");
        this.messageField.setEditable(false);
        this.timeField = new JTextField();
        this.timeField.setName("timeField");
        this.timeField.setEditable(false);
        this.formatField = new JTextField();
        this.formatField.setName("formatField");
        this.formatField.setEditable(false);
        this.transportField = new JTextField();
        this.transportField.setName("transportField");
        this.transportField.setEditable(false);
        DefaultFormBuilder defaultFormBuilder = ImmoToolUtils.createFormBuilder((String)"right:[40dlu,pref], 3dlu, 30dlu:grow, 3dlu, right:pref, 3dlu, 75dlu");
        defaultFormBuilder.append(this.resourceMap.getString("label.interface", new Object[0]), (Component)this.interfaceNameField);
        defaultFormBuilder.append(this.resourceMap.getString("label.format", new Object[0]), (Component)this.formatField);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(this.resourceMap.getString("label.limit", new Object[0]), (Component)this.interfaceLimitField);
        defaultFormBuilder.append(this.resourceMap.getString("label.transport", new Object[0]), (Component)this.transportField);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(this.resourceMap.getString("label.timestamp", new Object[0]), (Component)this.timeField);
        defaultFormBuilder.append(this.resourceMap.getString("label.mode", new Object[0]), (Component)this.interfaceModeField);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(this.resourceMap.getString("label.message", new Object[0]), (Component)this.messageField, 5);
        defaultFormBuilder.nextLine();
        jPanel.removeAll();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)defaultFormBuilder.getPanel(), "Center");
        jPanel.revalidate();
        jPanel.repaint();
    }

    @Action
    public void doClose() {
        ImmoToolUtils.removePanel((String)this.getTabTitle());
    }

    @Action
    public Task doExecute() {
        this.executeButton.setEnabled(false);
        return new ImmoToolTask<AgencyExportTaskContainer>(){

            protected AgencyExportTaskContainer executeTask() throws Exception {
                AgencyExportTaskContainer agencyExportTaskContainer = new AgencyExportTaskContainer();
                AgencyExportInterface agencyExportInterface = AgencyExportInterface.loadExportInterface(AgencyExportSummaryViewPanel.this.summary.getInterfaceId());
                if (agencyExportInterface == null) {
                    this.setMessage(AgencyExportSummaryViewPanel.this.resourceMap.getString("error.exportInterfaceDoesNotExistAnymore", new Object[]{AgencyExportSummaryViewPanel.this.summary.getInterfaceId()}));
                    throw new Exception(AgencyExportSummaryViewPanel.this.resourceMap.getString("error.exportInterfaceDoesNotExistAnymore", new Object[]{AgencyExportSummaryViewPanel.this.summary.getInterfaceId()}));
                }
                AgencyExportSummary agencyExportSummary = null;
                if (!agencyExportInterface.getExport().isIncremental()) {
                    agencyExportSummary = AgencyExportSummary.buildSummary(agencyExportInterface);
                } else {
                    agencyExportSummary = new AgencyExportSummary();
                    agencyExportSummary.setFormat(agencyExportInterface.getExport().getName());
                    agencyExportSummary.setFullTransfer(!agencyExportInterface.getExport().isIncremental());
                    agencyExportSummary.setInterfaceId(agencyExportInterface.getId());
                    agencyExportSummary.setInterfaceLimit(agencyExportInterface.getLimit());
                    agencyExportSummary.setInterfaceName(agencyExportInterface.getTitle());
                    agencyExportSummary.setTime(new Date());
                    agencyExportSummary.setTransport(agencyExportInterface.getTransport().getName());
                    agencyExportSummary.getUpdatedEstateIds().addAll(AgencyExportSummaryViewPanel.this.summary.getUpdatedEstateIds());
                    agencyExportSummary.getRemovedEstateIds().addAll(AgencyExportSummaryViewPanel.this.summary.getRemovedEstateIds());
                    agencyExportSummary.getRemovedEstatePublicIds().putAll(AgencyExportSummaryViewPanel.this.summary.getRemovedEstatePublicIds());
                }
                agencyExportTaskContainer.addExport(agencyExportInterface, agencyExportSummary);
                return agencyExportTaskContainer;
            }

            protected void finished() {
                super.finished();
                AgencyExportSummaryViewPanel.this.executeButton.setEnabled(true);
            }

            protected void succeeded(AgencyExportTaskContainer agencyExportTaskContainer) {
                super.succeeded((Object)agencyExportTaskContainer);
                ImmoToolTaskDialog.execute((ImmoToolTask)agencyExportTaskContainer);
            }
        };
    }

    @Action
    public void doHelp() {
        ImmoToolUtils.showHelpDialog((String)"agency.export");
    }

    public static String getInstanceTabTitle(AgencyExportSummary agencyExportSummary) {
        return AgencyExportSummaryViewPanel.getInstanceTabTitle(agencyExportSummary != null ? agencyExportSummary.getId() : 0L);
    }

    public static String getInstanceTabTitle(long l) {
        return ImmoToolUtils.getResourceMap(AgencyExportSummaryViewPanel.class).getString("title", new Object[]{l});
    }

    public String getTabTitle() {
        return AgencyExportSummaryViewPanel.getInstanceTabTitle(this.summary);
    }

    public void load(AgencyExportSummary agencyExportSummary) {
        String string;
        this.summary = agencyExportSummary;
        this.interfaceModeField.setText(this.resourceMap.getString(this.summary.isFullTransfer() ? "label.transfer.full" : "label.transfer.incremental", new Object[0]));
        this.interfaceNameField.setText(this.summary.getInterfaceName());
        this.interfaceLimitField.setText(this.summary.getInterfaceLimit() > 0L ? this.resourceMap.getString("label.limit.maximum", new Object[]{this.summary.getInterfaceLimit()}) : this.resourceMap.getString("label.limit.unlimited", new Object[0]));
        this.formatField.setText(this.summary.getFormat());
        this.transportField.setText(this.summary.getTransport());
        this.timeField.setText(this.summary.getTime() != null ? DateFormat.getDateTimeInstance(2, 3).format(this.summary.getTime()) : "unbekannt");
        String string2 = string = this.summary.isSuccessful() ? this.resourceMap.getString("label.transport.successful", new Object[0]) : this.resourceMap.getString("label.transport.error", new Object[0]);
        if (this.summary.getMessage() != null && this.summary.getMessage().trim().length() > 0) {
            string = string + ": " + this.summary.getMessage().trim();
        }
        this.messageField.setText(string);
        DefaultTableModel defaultTableModel = (DefaultTableModel)this.detailsTable.getModel();
        while (defaultTableModel.getRowCount() > 0) {
            defaultTableModel.removeRow(0);
        }
        for (Long l : new TreeSet<Long>(this.summary.getUpdatedEstateIds())) {
            defaultTableModel.addRow(new Object[]{l, this.resourceMap.getString("label.update", new Object[0])});
            if (!this.summary.getErrorEstateMap().containsKey(l)) continue;
            defaultTableModel.addRow(new Object[]{l, this.resourceMap.getString("label.error", new Object[]{this.summary.getErrorEstateMap().get(l)})});
        }
        for (Long l : new TreeSet<Long>(this.summary.getRemovedEstateIds())) {
            defaultTableModel.addRow(new Object[]{l, this.resourceMap.getString("label.delete", new Object[0])});
            if (!this.summary.getErrorEstateMap().containsKey(l)) continue;
            defaultTableModel.addRow(new Object[]{l, this.resourceMap.getString("label.error", new Object[]{this.summary.getErrorEstateMap().get(l)})});
        }
        this.detailsTable.packAll();
        this.detailsTitle.setTitle(this.resourceMap.getString("detailsTitle.title", new Object[0]) + " / " + this.resourceMap.getString("message.resultCount", new Object[]{this.detailsTable.getRowCount()}));
    }

    private void initComponents() {
        this.infoTitle = ImmoToolUtils.createHead1Separator((String)"");
        this.executeButton = new JButton();
        this.helpButton = new JButton();
        this.closeButton = new JButton();
        this.summaryPanel = new JPanel();
        this.detailsTitle = ImmoToolUtils.createHead1Separator((String)"");
        this.detailsTableScroller = new JScrollPane();
        this.detailsTable = new JXTable();
        this.setName("Form");
        this.infoTitle.setName("infoTitle");
        ApplicationActionMap applicationActionMap = Application.getInstance().getContext().getActionMap(AgencyExportSummaryViewPanel.class, (Object)this);
        this.executeButton.setAction(applicationActionMap.get("doExecute"));
        this.executeButton.setName("executeButton");
        this.helpButton.setAction(applicationActionMap.get("doHelp"));
        this.helpButton.setName("helpButton");
        this.closeButton.setAction(applicationActionMap.get("doClose"));
        this.closeButton.setName("closeButton");
        this.summaryPanel.setName("summaryPanel");
        GroupLayout groupLayout = new GroupLayout(this.summaryPanel);
        this.summaryPanel.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 699, Short.MAX_VALUE));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 127, Short.MAX_VALUE));
        this.detailsTitle.setName("detailsTitle");
        this.detailsTableScroller.setName("detailsTableScroller");
        this.detailsTable.setModel((TableModel)new DefaultTableModel(new Object[0][], new String[]{"col.estateId", "col.message"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{Long.class, String.class};
                this.canEdit = new boolean[]{false, false};
            }

            public Class getColumnClass(int n) {
                return this.types[n];
            }

            @Override
            public boolean isCellEditable(int n, int n2) {
                return this.canEdit[n2];
            }
        });
        this.detailsTable.setColumnControlVisible(true);
        this.detailsTable.setName("detailsTable");
        this.detailsTableScroller.setViewportView((Component)this.detailsTable);
        GroupLayout groupLayout2 = new GroupLayout((Container)((Object)this));
        this.setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout2.createSequentialGroup().addContainerGap().addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.summaryPanel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addGroup(groupLayout2.createSequentialGroup().addComponent((Component)this.infoTitle, -1, 510, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.executeButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.helpButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.closeButton)).addComponent((Component)this.detailsTitle, GroupLayout.Alignment.LEADING, -1, 699, Short.MAX_VALUE).addComponent(this.detailsTableScroller, GroupLayout.Alignment.LEADING, -1, 699, Short.MAX_VALUE)).addContainerGap()));
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.closeButton).addComponent(this.helpButton).addComponent(this.executeButton)).addComponent((Component)this.infoTitle, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.summaryPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent((Component)this.detailsTitle, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.detailsTableScroller, -1, 289, Short.MAX_VALUE).addContainerGap()));
        ResourceMap resourceMap = Application.getInstance().getContext().getResourceMap(AgencyExportSummaryViewPanel.class);
        resourceMap.injectComponents((Component)((Object)this));
    }
}

