/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency;

import com.openindex.openestate.tool.ImmoToolTask;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.agency.AgencyExportInterface;
import com.openindex.openestate.tool.agency.AgencyExportList;
import com.openindex.openestate.tool.agency.AgencyExportSummary;
import com.openindex.openestate.tool.agency.export.AbstractTransport;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.application.TaskEvent;
import org.jdesktop.application.TaskListener;

public class AgencyExportTask
extends ImmoToolTask<AgencyExportSummary> {
    private static final Logger LOGGER = Logger.getLogger(AgencyExportTask.class);
    private AgencyExportInterface exportInterface = null;
    private AgencyExportSummary exportSummary = null;
    private ResourceMap resourceMap = null;
    private boolean storeSummaryAndProtocols;

    public AgencyExportTask(AgencyExportInterface agencyExportInterface, AgencyExportSummary agencyExportSummary) {
        this(agencyExportInterface, agencyExportSummary, true);
    }

    public AgencyExportTask(AgencyExportInterface agencyExportInterface, AgencyExportSummary agencyExportSummary, boolean bl) {
        this.exportInterface = agencyExportInterface;
        this.exportSummary = agencyExportSummary;
        this.resourceMap = ImmoToolUtils.getResourceMap(AgencyExportTask.class);
        this.storeSummaryAndProtocols = bl;
        this.setTitle(this.resourceMap.getString("title", new Object[]{agencyExportInterface.getTitle()}));
        final AbstractTransport abstractTransport = agencyExportInterface.getTransport();
        this.addTaskListener((TaskListener)new TaskListener<AgencyExportSummary, Void>(){

            public void doInBackground(TaskEvent taskEvent) {
            }

            public void process(TaskEvent taskEvent) {
            }

            public void succeeded(TaskEvent taskEvent) {
            }

            public void failed(TaskEvent taskEvent) {
            }

            public void cancelled(TaskEvent taskEvent) {
                LOGGER.info((Object)"Task was cancelled, the transport will be cancelled...");
                abstractTransport.cancelTransport();
            }

            public void interrupted(TaskEvent taskEvent) {
                LOGGER.info((Object)"Task was interrupted, the transport will be cancelled...");
                abstractTransport.cancelTransport();
            }

            public void finished(TaskEvent taskEvent) {
            }
        });
    }

    protected void cancelled() {
        super.cancelled();
        this.exportSummary.setSuccessful(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AgencyExportSummary executeTask() throws Exception {
        Object object;
        if (this.exportInterface == null) {
            throw new Exception(this.resourceMap.getString("error.noInterfaceProvided", new Object[0]));
        }
        if (this.exportSummary == null) {
            throw new Exception(this.resourceMap.getString("error.noSummaryProvided", new Object[0]));
        }
        ImmoToolTask.Callback callback = this.createCallback();
        int n = 0;
        int n2 = 9;
        File file = null;
        File file2 = null;
        this.setProgress(n, 0, n2);
        try {
            this.setProgress(++n, 0, n2);
            this.checkCancelled();
            this.setMessage(this.resourceMap.getString("message.doStartExport", new Object[]{this.exportInterface.getExport().getName()}));
            file2 = this.exportInterface.getExport().doExport(this.exportSummary, callback);
            if (file2 == null) {
                throw new Exception(this.resourceMap.getString("error.noWorkingDirectoryProvided", new Object[0]));
            }
            if (!file2.isDirectory()) {
                throw new Exception(this.resourceMap.getString("error.invalidWorkingDirectoryProvided", new Object[0]));
            }
            this.setProgress(++n, 0, n2);
            this.checkCancelled();
            if (this.exportInterface.isZippedExport()) {
                this.setMessage(this.resourceMap.getString("message.doCompressArchive", new Object[0]));
                file = new File(file2.getParentFile().getAbsolutePath() + File.separator + this.exportInterface.getZipFileName());
                object = null;
                ZipOutputStream zipOutputStream = null;
                try {
                    object = new FileOutputStream(file);
                    zipOutputStream = new ZipOutputStream((OutputStream)object);
                    for (File file3 : file2.listFiles()) {
                        ImmoToolUtils.loadFileIntoZipStream((File)file3, (ZipOutputStream)zipOutputStream, (String)"");
                    }
                    zipOutputStream.flush();
                }
                finally {
                    if (zipOutputStream != null) {
                        zipOutputStream.close();
                    }
                    if (object != null) {
                        ((FileOutputStream)object).close();
                    }
                }
            }
            this.setProgress(++n, 0, n2);
            this.checkCancelled();
            this.setMessage(this.resourceMap.getString("message.doStartTransport", new Object[]{this.exportInterface.getTransport().getName()}));
            try {
                this.exportInterface.getTransport().doTransport(file != null ? file : file2, this.exportInterface.getExport(), this.exportSummary, callback);
            }
            catch (Exception exception) {
                LOGGER.info((Object)"Transport will be cancelled...");
                this.exportInterface.getTransport().cancelTransport();
                throw exception;
            }
            this.setProgress(++n, 0, n2);
            this.checkCancelled();
            if (this.storeSummaryAndProtocols) {
                this.setMessage(this.resourceMap.getString("message.doSaveSummary", new Object[0]));
            }
            this.exportSummary.setId(0L);
            this.exportSummary.setTime(new Date());
            this.exportSummary.setFullTransfer(!this.exportInterface.getExport().isIncremental());
            this.exportSummary.setFormat(this.exportInterface.getExport().getTitle());
            this.exportSummary.setTransport(this.exportInterface.getTransport().getTitle());
            this.setProgress(++n, 0, n2);
            this.checkCancelled();
            this.exportInterface.getExport().doFinishExport(this.exportSummary, this.exportInterface.getTransport().getResponseProtocols(), callback);
            this.setProgress(++n, 0, n2);
            if (this.storeSummaryAndProtocols) {
                this.checkCancelled();
                if (this.exportInterface.getExport().supportsIncrementalUpdate()) {
                    this.setMessage(this.resourceMap.getString("message.doSaveProtocols", new Object[0]));
                    AgencyExportList.registerSummary(this.exportSummary);
                    object = AgencyExportList.loadExportList(this.exportInterface.getId(), "changed");
                    if (object != null) {
                        ((AgencyExportList)object).getEstateNrMap().clear();
                        ((AgencyExportList)object).getEstateValueMap().clear();
                        AgencyExportList.storeExportList((AgencyExportList)object);
                    }
                }
            }
            this.setProgress(++n, 0, n2);
            if (this.storeSummaryAndProtocols) {
                this.checkCancelled();
                AgencyExportSummary.storeExportSummary(this.getExportSummary());
            }
            object = this.exportSummary;
        }
        catch (Throwable throwable) {
            this.setProgress(++n, 0, n2);
            this.setMessage(this.resourceMap.getString("message.doDeleteTempFiles", new Object[0]));
            FileUtils.deleteQuietly(file2);
            FileUtils.deleteQuietly(file);
            this.setProgress(n2, 0, n2);
            throw throwable;
        }
        this.setProgress(++n, 0, n2);
        this.setMessage(this.resourceMap.getString("message.doDeleteTempFiles", new Object[0]));
        FileUtils.deleteQuietly((File)file2);
        FileUtils.deleteQuietly((File)file);
        this.setProgress(n2, 0, n2);
        return object;
    }

    protected void failed(Throwable throwable) {
        super.failed(throwable);
        this.exportSummary.setSuccessful(false);
    }

    protected AgencyExportInterface getExportInterface() {
        return this.exportInterface;
    }

    protected AgencyExportSummary getExportSummary() {
        return this.exportSummary;
    }

    protected void succeeded(AgencyExportSummary agencyExportSummary) {
        super.succeeded((Object)agencyExportSummary);
        this.exportSummary.setSuccessful(true);
    }
}

