/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency;

import com.openindex.openestate.tool.ImmoToolApp;
import com.openindex.openestate.tool.ImmoToolTaskContainer;
import com.openindex.openestate.tool.ImmoToolTaskDialog;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.agency.AgencyExportInterface;
import com.openindex.openestate.tool.agency.AgencyExportSummary;
import com.openindex.openestate.tool.agency.AgencyExportSummaryDialog;
import com.openindex.openestate.tool.agency.AgencyExportTask;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.util.Map;
import java.util.TreeMap;
import org.apache.log4j.Logger;
import org.jdesktop.application.ResourceMap;

public class AgencyExportTaskContainer
extends ImmoToolTaskContainer {
    private static final Logger LOGGER = Logger.getLogger(AgencyExportTaskContainer.class);
    private final ResourceMap resourceMap = ImmoToolUtils.getResourceMap(AgencyExportTaskContainer.class);
    private final Map<Long, AgencyExportInterface> exportInterfaces = new TreeMap<Long, AgencyExportInterface>();
    private final Map<Long, AgencyExportSummary> exportSummaries = new TreeMap<Long, AgencyExportSummary>();

    public AgencyExportTaskContainer() {
        this.setTitle(this.resourceMap.getString("message.exportIsExecuted", new Object[0]));
        this.setCancelOnFail(false);
    }

    public void addExport(AgencyExportInterface agencyExportInterface) {
        this.exportInterfaces.put(agencyExportInterface.getId(), agencyExportInterface);
    }

    public void addExport(AgencyExportInterface agencyExportInterface, AgencyExportSummary agencyExportSummary) {
        this.exportInterfaces.put(agencyExportInterface.getId(), agencyExportInterface);
        this.exportSummaries.put(agencyExportInterface.getId(), agencyExportSummary);
    }

    protected Boolean executeTask() throws Exception {
        Object object;
        this.setMessage(this.resourceMap.getString("message.doPrepareExport", new Object[0]));
        ImmoToolTaskDialog immoToolTaskDialog = this.getTaskDialog();
        AgencyExportSummaryDialog agencyExportSummaryDialog = immoToolTaskDialog != null ? new AgencyExportSummaryDialog((Dialog)immoToolTaskDialog, true) : new AgencyExportSummaryDialog((Frame)ImmoToolApp.getApplication().getFrameView().getFrame(), true);
        for (Long l : this.exportInterfaces.keySet()) {
            object = this.exportInterfaces.get(l);
            if (this.exportSummaries.containsKey(l)) {
                agencyExportSummaryDialog.addExport(this.exportSummaries.get(l), (AgencyExportInterface)object);
                continue;
            }
            agencyExportSummaryDialog.addExportInterface((AgencyExportInterface)object);
        }
        agencyExportSummaryDialog.finishTable();
        agencyExportSummaryDialog.setVisible(true);
        if (agencyExportSummaryDialog.getStatus() != 2) {
            return null;
        }
        for (Long l : this.exportInterfaces.keySet()) {
            object = agencyExportSummaryDialog.getSummary(l);
            if (object == null) {
                LOGGER.warn((Object)("Can't load summary for export-interface #" + l));
                continue;
            }
            this.exportSummaries.put(l, (AgencyExportSummary)object);
        }
        if (this.exportSummaries.isEmpty()) {
            return false;
        }
        this.setMessage(this.resourceMap.getString("message.doStartExport", new Object[0]));
        for (Long l : this.exportSummaries.keySet()) {
            object = this.exportSummaries.get(l);
            AgencyExportInterface agencyExportInterface = this.exportInterfaces.get(l);
            AgencyExportTask agencyExportTask = new AgencyExportTask(agencyExportInterface, (AgencyExportSummary)object);
            this.add(agencyExportTask);
        }
        return super.executeTask();
    }

    protected void succeeded(Boolean bl) {
        super.succeeded((Object)bl);
        this.setMessage("");
        this.setMessage("");
        if (!Boolean.TRUE.equals(bl)) {
            if (bl == null) {
                this.setMessage(this.resourceMap.getString("message.exportCanceled", new Object[0]));
            } else if (this.exportSummaries.isEmpty()) {
                this.setMessage(this.resourceMap.getString("message.nothingWasExported", new Object[0]));
            }
            return;
        }
        boolean bl2 = false;
        int n = 0;
        for (Long l : this.exportSummaries.keySet()) {
            AgencyExportSummary agencyExportSummary = this.exportSummaries.get(l);
            AgencyExportInterface agencyExportInterface = this.exportInterfaces.get(l);
            boolean bl3 = bl2 = bl2 || !agencyExportSummary.isSuccessful() || !agencyExportSummary.getErrorEstateMap().isEmpty();
            if (n > 0) {
                this.setMessage("");
            }
            this.setMessage("--------------------------------------------");
            this.setMessage(" " + this.resourceMap.getString("message.exportProtocol", new Object[]{agencyExportInterface.getTitle()}));
            this.setMessage("--------------------------------------------");
            if (agencyExportSummary.isFullTransfer()) {
                this.setMessage(this.resourceMap.getString("message.exportProtocol.isFull", new Object[0]));
                this.setMessage(this.resourceMap.getString("message.exportProtocol.updateCount", new Object[]{agencyExportSummary.getUpdatedEstateIds().size()}));
                if (!agencyExportSummary.getErrorEstateMap().isEmpty()) {
                    this.setMessage(this.resourceMap.getString("message.exportProtocol.errorCount", new Object[]{agencyExportSummary.getErrorEstateMap().size()}));
                }
            } else {
                this.setMessage(this.resourceMap.getString("message.exportProtocol.isIncremental", new Object[0]));
                this.setMessage(this.resourceMap.getString("message.exportProtocol.updateCount", new Object[]{agencyExportSummary.getUpdatedEstateIds().size()}));
                this.setMessage(this.resourceMap.getString("message.exportProtocol.removeCount", new Object[]{agencyExportSummary.getRemovedEstateIds().size()}));
                if (!agencyExportSummary.getErrorEstateMap().isEmpty()) {
                    this.setMessage(this.resourceMap.getString("message.exportProtocol.errorCount", new Object[]{agencyExportSummary.getErrorEstateMap().size()}));
                }
            }
            if (!agencyExportSummary.getUpdatedEstateIds().isEmpty()) {
                for (Long l2 : agencyExportSummary.getUpdatedEstateIds()) {
                    if (agencyExportSummary.getErrorEstateMap().containsKey(l2)) continue;
                    this.setMessage("> " + this.resourceMap.getString("message.exportProtocol.estateUpdated", new Object[]{l2}));
                }
            }
            if (!agencyExportSummary.getRemovedEstateIds().isEmpty()) {
                for (Long l2 : agencyExportSummary.getRemovedEstateIds()) {
                    this.setMessage("> " + this.resourceMap.getString("message.exportProtocol.estateRemoved", new Object[]{l2}));
                }
            }
            if (!agencyExportSummary.isSuccessful()) {
                this.setMessage("> PROBLEM");
            }
            if (!agencyExportSummary.getErrorEstateMap().isEmpty()) {
                for (Long l2 : agencyExportSummary.getErrorEstateMap().keySet()) {
                    this.setMessage("> " + this.resourceMap.getString("message.exportProtocol.estateNotExportable", new Object[]{l2}));
                    for (String string : agencyExportSummary.getErrorEstateMap().get(l2).split(";")) {
                        if (string.trim().length() <= 0) continue;
                        this.setMessage("  " + string.trim());
                    }
                }
            }
            ++n;
        }
        this.setMessage("");
        this.setMessage(this.resourceMap.getString("message.exportProtocol.exportFinished", new Object[0]));
        ImmoToolTaskDialog immoToolTaskDialog = this.getTaskDialog();
        if (immoToolTaskDialog != null && bl2) {
            immoToolTaskDialog.setAutoCloseSelected(false);
        }
        if (immoToolTaskDialog != null && !immoToolTaskDialog.isAutoCloseSelected()) {
            ImmoToolUtils.showMessageInfoDialog((String)this.writeHtmlSummary(), (Component)immoToolTaskDialog);
        } else {
            ImmoToolUtils.showMessageInfoDialog((String)this.writeHtmlSummary(), (Component)ImmoToolApp.getApplication().getFrameView().getFrame());
        }
    }

    public String writeHtmlSummary() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<html>");
        stringBuilder.append("<b>").append(this.resourceMap.getString("message.exportFinished", new Object[0])).append("</b>");
        stringBuilder.append("<ul>");
        for (Long l : this.exportSummaries.keySet()) {
            AgencyExportSummary agencyExportSummary = this.exportSummaries.get(l);
            AgencyExportInterface agencyExportInterface = this.exportInterfaces.get(l);
            stringBuilder.append("<li>");
            stringBuilder.append("<b>").append(agencyExportInterface.getTitle()).append("</b><br>");
            stringBuilder.append(this.resourceMap.getString("message.exportFinished.updateCount", new Object[]{agencyExportSummary.getUpdatedEstateIds().size()}));
            stringBuilder.append("<br>");
            if (!agencyExportSummary.getRemovedEstateIds().isEmpty()) {
                stringBuilder.append(this.resourceMap.getString("message.exportFinished.removeCount", new Object[]{agencyExportSummary.getRemovedEstateIds().size()}));
                stringBuilder.append("<br>");
            }
            if (!agencyExportSummary.getErrorEstateMap().isEmpty()) {
                stringBuilder.append("<b style=\"color:red;\">");
                stringBuilder.append(this.resourceMap.getString("message.exportFinished.errorCount", new Object[]{agencyExportSummary.getErrorEstateMap().size()}));
                stringBuilder.append("</b><br>");
            }
            if (!agencyExportSummary.isSuccessful()) {
                stringBuilder.append("<b style=\"color:red;\">=&gt; ");
                stringBuilder.append(this.resourceMap.getString("message.exportFinished.problem", new Object[0]));
                stringBuilder.append("</b><br>");
                stringBuilder.append(agencyExportSummary.getMessage());
            }
            stringBuilder.append("</li>");
        }
        stringBuilder.append("</ul>");
        stringBuilder.append("</html>");
        return stringBuilder.toString();
    }
}

