/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency;

import com.openindex.openestate.tool.ImmoToolDbException;
import com.openindex.openestate.tool.ImmoToolException;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.agency.AgencySetupPdfFormPanel;
import com.openindex.openestate.tool.agency.utils.PdfBuilder;
import com.openindex.openestate.tool.agency.utils.PdfSetup;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.ComboBoxEditor;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.ListCellRenderer;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import org.apache.commons.lang.SystemUtils;
import org.apache.log4j.Logger;
import org.jdesktop.application.Action;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationActionMap;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.swingx.JXPanel;
import org.jdesktop.swingx.JXTitledSeparator;

public class AgencyExposeDialog
extends JDialog {
    private static final Logger LOGGER = Logger.getLogger(AgencyExposeDialog.class);
    public static final int UNDEFINED = 0;
    public static final int CLOSED = 1;
    public static final int APPROVED_TO_SAVE = 2;
    public static final int APPROVED_TO_VIEW = 3;
    private ResourceMap resourceMap;
    private JPopupMenu addSetupMenu;
    private Map<PdfSetup, AgencySetupPdfFormPanel> setupForms;
    private List<Long> removedSetupIds;
    private int status = 0;
    private JButton cancelButton;
    private JButton saveButton;
    private JCheckBox saveChangesBox;
    private JButton setupAddButton;
    private JComboBox setupBox;
    private JLabel setupLabel;
    private JPanel setupPanel;
    private JButton setupRemoveButton;
    private JXTitledSeparator setupTitleLabel;
    private JXTitledSeparator titleLabel;
    private JButton viewButton;

    public AgencyExposeDialog(Frame frame) {
        super(frame, true);
        this.build();
        this.setLocationRelativeTo(frame);
    }

    public AgencyExposeDialog(Dialog dialog) {
        super(dialog, true);
        this.build();
        this.setLocationRelativeTo(dialog);
    }

    private void build() {
        this.setupForms = new HashMap<PdfSetup, AgencySetupPdfFormPanel>();
        this.resourceMap = ImmoToolUtils.getResourceMap(AgencyExposeDialog.class);
        this.removedSetupIds = new ArrayList<Long>();
        this.setContentPane((Container)new JXPanel());
        this.initComponents();
        this.setupPanel.setLayout(new BorderLayout());
        this.setupPanel.setOpaque(false);
        this.saveChangesBox.setOpaque(false);
        this.setupBox.setRenderer(new PdfSetupRenderer());
        this.setupBox.setEditor(new PdfSetupEditor());
        this.setupBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!AgencyExposeDialog.this.setupBox.isEnabled()) {
                    return;
                }
                AgencyExposeDialog.this.showSetupForm((PdfSetup)AgencyExposeDialog.this.setupBox.getSelectedItem());
            }
        });
        this.addSetupMenu = new JPopupMenu();
        Map<String, PdfBuilder> map = PdfBuilder.listAvailableBuilders();
        for (Map.Entry<String, PdfBuilder> entry : map.entrySet()) {
            final String string = entry.getKey();
            PdfBuilder pdfBuilder = entry.getValue();
            final String string2 = pdfBuilder.getTitle();
            JMenuItem jMenuItem = new JMenuItem(string2);
            this.addSetupMenu.add(jMenuItem);
            jMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    PdfSetup pdfSetup = new PdfSetup(string);
                    pdfSetup.setName(string2);
                    AgencyExposeDialog.this.setupBox.addItem(pdfSetup);
                    AgencyExposeDialog.this.setupBox.setEnabled(true);
                    AgencyExposeDialog.this.setupBox.setSelectedIndex(AgencyExposeDialog.this.setupBox.getItemCount() - 1);
                    AgencyExposeDialog.this.updateButtons(true);
                    AgencyExposeDialog.this.showSetupForm(pdfSetup);
                }
            });
        }
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                AgencyExposeDialog.this.doCancel();
            }
        });
        if (SystemUtils.IS_OS_MAC_OSX) {
            this.cancelButton.setOpaque(false);
            this.saveButton.setOpaque(false);
            this.setupAddButton.setOpaque(false);
            this.setupRemoveButton.setOpaque(false);
        }
        this.resourceMap.injectComponents((Component)this);
        ImmoToolUtils.configureDialog((JDialog)this, (JXPanel)((JXPanel)this.getContentPane()));
    }

    public PdfSetup[] getModifiedPdfSetups() throws ImmoToolException {
        ArrayList<PdfSetup> arrayList = new ArrayList<PdfSetup>();
        for (int i = 0; i < this.setupBox.getItemCount(); ++i) {
            PdfSetup pdfSetup = (PdfSetup)this.setupBox.getItemAt(i);
            if (this.setupForms.containsKey(pdfSetup)) {
                this.setupForms.get(pdfSetup).save(pdfSetup, true);
            }
            arrayList.add(pdfSetup);
        }
        return arrayList.toArray(new PdfSetup[arrayList.size()]);
    }

    public Long[] getRemovedPdfSetupIds() {
        return this.removedSetupIds.toArray(new Long[this.removedSetupIds.size()]);
    }

    public PdfSetup getSelectedPdfSetup() throws ImmoToolException {
        PdfSetup pdfSetup = (PdfSetup)this.setupBox.getSelectedItem();
        if (this.setupForms.containsKey(pdfSetup)) {
            this.setupForms.get(pdfSetup).save(pdfSetup, false);
        }
        return pdfSetup;
    }

    public int getStatus() {
        return this.status;
    }

    public boolean isChangesAreSaved() {
        return this.saveChangesBox.isSelected();
    }

    public void load() throws ImmoToolDbException {
        this.removedSetupIds.clear();
        this.setupBox.setEnabled(false);
        this.setupBox.removeAllItems();
        this.setupBox.setSelectedIndex(-1);
        TreeMap<String, PdfSetup> treeMap = new TreeMap<String, PdfSetup>();
        for (PdfSetup pdfSetup : PdfSetup.loadSetups()) {
            String string;
            String string2 = string = pdfSetup.getName().toLowerCase().trim();
            int n = 0;
            while (treeMap.containsKey(string2)) {
                string2 = string + "_" + ++n;
            }
            treeMap.put(string2, pdfSetup);
        }
        for (PdfSetup pdfSetup : treeMap.values()) {
            this.setupBox.addItem(pdfSetup);
        }
        this.setupBox.setEnabled(true);
        this.setupBox.setSelectedIndex(this.setupBox.getItemCount() > 0 ? 0 : -1);
    }

    private void showSetupForm(PdfSetup pdfSetup) {
        AgencySetupPdfFormPanel agencySetupPdfFormPanel = null;
        if (pdfSetup != null) {
            if (this.setupForms.containsKey(pdfSetup)) {
                agencySetupPdfFormPanel = this.setupForms.get(pdfSetup);
            } else {
                try {
                    agencySetupPdfFormPanel = pdfSetup.createBuilder().createSetupPanel();
                    agencySetupPdfFormPanel.load(pdfSetup);
                    this.setupForms.put(pdfSetup, agencySetupPdfFormPanel);
                }
                catch (Exception exception) {
                    LOGGER.error((Object)"Can't load expos\u00e9 form!");
                    LOGGER.error((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
                }
            }
        }
        this.setupPanel.removeAll();
        if (agencySetupPdfFormPanel != null) {
            this.setupPanel.add((Component)((Object)agencySetupPdfFormPanel), "Center");
        }
        this.setupPanel.revalidate();
        this.setupPanel.repaint();
    }

    private void updateButtons(boolean bl) {
        this.setupBox.setEnabled(bl && this.setupBox.getItemCount() > 0);
        this.setupAddButton.setEnabled(bl);
        this.setupRemoveButton.setEnabled(bl && this.setupBox.getItemCount() > 0 && this.setupBox.getSelectedIndex() >= 0);
        this.saveButton.setEnabled(bl && this.setupBox.getItemCount() > 0 && this.setupBox.getSelectedIndex() >= 0);
        this.viewButton.setEnabled(bl && this.setupBox.getItemCount() > 0 && this.setupBox.getSelectedIndex() >= 0);
    }

    private void initComponents() {
        this.titleLabel = ImmoToolUtils.createHead1Separator((String)"");
        this.setupLabel = new JLabel();
        this.setupBox = new JComboBox();
        this.setupAddButton = new JButton();
        this.setupRemoveButton = new JButton();
        this.setupTitleLabel = new JXTitledSeparator();
        this.setupPanel = new JPanel();
        this.saveChangesBox = new JCheckBox();
        this.saveButton = new JButton();
        this.viewButton = new JButton();
        this.cancelButton = new JButton();
        this.setName("dialog");
        this.titleLabel.setName("titleLabel");
        this.setupLabel.setName("setupLabel");
        this.setupBox.setEditable(true);
        this.setupBox.setName("setupBox");
        ApplicationActionMap applicationActionMap = Application.getInstance().getContext().getActionMap(AgencyExposeDialog.class, (Object)this);
        this.setupAddButton.setAction(applicationActionMap.get("doSetupAdd"));
        this.setupAddButton.setName("setupAddButton");
        this.setupRemoveButton.setAction(applicationActionMap.get("doSetupRemove"));
        this.setupRemoveButton.setName("setupRemoveButton");
        this.setupTitleLabel.setName("setupTitleLabel");
        this.setupPanel.setName("setupPanel");
        GroupLayout groupLayout = new GroupLayout(this.setupPanel);
        this.setupPanel.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 519, Short.MAX_VALUE));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 392, Short.MAX_VALUE));
        this.saveChangesBox.setName("saveChangesBox");
        this.saveButton.setAction(applicationActionMap.get("doPdfSave"));
        this.saveButton.setName("saveButton");
        this.viewButton.setAction(applicationActionMap.get("doPdfView"));
        this.viewButton.setName("viewButton");
        this.cancelButton.setAction(applicationActionMap.get("doCancel"));
        this.cancelButton.setName("cancelButton");
        GroupLayout groupLayout2 = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.setupPanel, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent((Component)this.titleLabel, -1, 519, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, groupLayout2.createSequentialGroup().addComponent(this.saveButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.viewButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelButton)).addGroup(groupLayout2.createSequentialGroup().addGap(12, 12, 12).addComponent(this.setupLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.saveChangesBox).addGroup(groupLayout2.createSequentialGroup().addComponent(this.setupBox, 0, 394, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.setupAddButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.setupRemoveButton)))).addComponent((Component)this.setupTitleLabel, -1, 519, Short.MAX_VALUE)).addContainerGap()));
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addComponent((Component)this.titleLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.setupLabel).addComponent(this.setupBox, -2, -1, -2).addComponent(this.setupRemoveButton).addComponent(this.setupAddButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.saveChangesBox).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent((Component)this.setupTitleLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.setupPanel, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cancelButton).addComponent(this.viewButton).addComponent(this.saveButton)).addContainerGap()));
        this.pack();
    }

    @Action
    public void doCancel() {
        this.status = 1;
        this.setVisible(false);
    }

    @Action
    public void doPdfSave() {
        this.status = 2;
        this.setVisible(false);
    }

    @Action
    public void doPdfView() {
        this.status = 3;
        this.setVisible(false);
    }

    @Action
    public void doSetupAdd() {
        this.addSetupMenu.show(this.setupAddButton, 0, this.setupAddButton.getSize().height);
    }

    @Action
    public void doSetupRemove() {
        if (this.setupBox.getSelectedIndex() < 0) {
            return;
        }
        int n = this.setupBox.getSelectedIndex();
        PdfSetup pdfSetup = (PdfSetup)this.setupBox.getItemAt(n);
        if (pdfSetup != null && pdfSetup.getId() != null && pdfSetup.getId() > 0L) {
            this.removedSetupIds.add(pdfSetup.getId());
        }
        this.setupBox.setEnabled(false);
        this.setupBox.removeItemAt(n);
        this.setupBox.setEnabled(true);
        while (n > 0 && n >= this.setupBox.getItemCount()) {
            --n;
        }
        this.setupBox.setSelectedIndex(n < this.setupBox.getItemCount() ? n : -1);
        this.updateButtons(true);
    }

    private static class PdfSetupRenderer
    extends JLabel
    implements ListCellRenderer {
        public PdfSetupRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            this.setBackground(bl ? jList.getSelectionBackground() : jList.getBackground());
            this.setForeground(bl ? jList.getSelectionForeground() : jList.getForeground());
            if (object instanceof PdfSetup) {
                PdfSetup pdfSetup = (PdfSetup)object;
                this.setText(pdfSetup.getName() != null && pdfSetup.getName().trim().length() > 0 ? pdfSetup.getName().trim() : "???");
            } else {
                this.setText("");
            }
            return this;
        }
    }

    private class PdfSetupEditor
    extends JTextField
    implements ComboBoxEditor {
        private PdfSetup currentSetup = null;
        private String currentName = null;

        public PdfSetupEditor() {
            this.addCaretListener(new CaretListener(){

                @Override
                public void caretUpdate(CaretEvent caretEvent) {
                    String string = PdfSetupEditor.this.getText().trim();
                    if (!string.equals(PdfSetupEditor.this.currentName)) {
                        PdfSetupEditor.this.currentSetup = (PdfSetup)PdfSetupEditor.this.getItem();
                    }
                }
            });
        }

        @Override
        public Component getEditorComponent() {
            return this;
        }

        @Override
        public void setItem(Object object) {
            if (object instanceof PdfSetup) {
                this.currentSetup = (PdfSetup)object;
                this.currentName = this.currentSetup.getName();
                this.setText(this.currentName);
            } else {
                this.currentSetup = null;
                this.currentName = null;
                this.setText("");
            }
        }

        @Override
        public Object getItem() {
            if (this.currentSetup == null) {
                return null;
            }
            this.currentName = this.getText().trim();
            this.currentSetup.setName(this.currentName);
            return this.currentSetup;
        }
    }
}

