/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency;

import com.openindex.openestate.tool.ImmoToolDbException;
import com.openindex.openestate.tool.ImmoToolTask;
import com.openindex.openestate.tool.ImmoToolTaskContainer;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.agency.AgencyEstate;
import com.openindex.openestate.tool.agency.AgencyExposeDialog;
import com.openindex.openestate.tool.agency.utils.PdfSetup;
import java.awt.Frame;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.ArrayUtils;

public class AgencyExposeTask
extends ImmoToolTaskContainer {
    private static File lastSaveLocation = null;
    protected final Frame parentFrame;
    private final Long[] estateIds;
    private final AgencyEstate[] estates;
    private boolean savedToFile = false;
    private boolean openedExternally = false;

    public AgencyExposeTask(Long[] longArray, Frame frame) {
        this.estates = null;
        this.estateIds = (Long[])ArrayUtils.clone((Object[])longArray);
        this.parentFrame = frame;
    }

    public AgencyExposeTask(AgencyEstate[] agencyEstateArray, Frame frame) {
        this.estateIds = null;
        this.estates = (AgencyEstate[])ArrayUtils.clone((Object[])agencyEstateArray);
        this.parentFrame = frame;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Boolean executeTask() throws Exception {
        Object object;
        AgencyExposeDialog agencyExposeDialog = new AgencyExposeDialog(this.parentFrame);
        agencyExposeDialog.load();
        agencyExposeDialog.setVisible(true);
        this.savedToFile = false;
        this.openedExternally = false;
        int n = agencyExposeDialog.getStatus();
        if ((n == 1 || n == 2 || n == 3) && agencyExposeDialog.isChangesAreSaved()) {
            for (PdfSetup object22 : agencyExposeDialog.getModifiedPdfSetups()) {
                this.setMessage("Setup #" + object22.getId() + " was saved (" + object22.getName() + ")");
            }
            for (Long l : agencyExposeDialog.getRemovedPdfSetupIds()) {
                this.setMessage("Remove setup #" + l);
                PdfSetup.removeSetup(l);
            }
        }
        if (n == 2) {
            int n2;
            Object object2;
            Object object3;
            this.savedToFile = true;
            object = this.getEstates();
            if (object.isEmpty()) {
                this.setMessage("Nothing to export!");
                return false;
            }
            PdfSetup pdfSetup = agencyExposeDialog.getSelectedPdfSetup();
            JFileChooser jFileChooser = new JFileChooser();
            if (object.size() > 1) {
                jFileChooser.setFileSelectionMode(1);
                if (lastSaveLocation != null) {
                    jFileChooser.setSelectedFile(lastSaveLocation);
                }
            } else {
                jFileChooser.setFileSelectionMode(0);
                jFileChooser.setFileFilter(new FileFilter(){

                    @Override
                    public boolean accept(File file) {
                        return file.isDirectory() || file.getName().toLowerCase().endsWith(".pdf");
                    }

                    @Override
                    public String getDescription() {
                        return "*.pdf";
                    }
                });
                AgencyEstate agencyEstate = (AgencyEstate)((Object)object.get(0));
                object3 = agencyEstate.getPublicId();
                if (object3 == null || ((String)object3).trim().length() == 0) {
                    object3 = "ID_" + agencyEstate.getIdNr();
                }
                object2 = pdfSetup.getName() + "_" + (String)object3;
                object2 = ((String)object2).replaceAll("[^\\w\\-\\.]", "_");
                while (((String)object2).contains("__")) {
                    object2 = ((String)object2).replace("__", "_");
                }
                if (lastSaveLocation != null) {
                    jFileChooser.setSelectedFile(new File(lastSaveLocation.getAbsolutePath() + File.separator + (String)object2 + ".pdf"));
                } else {
                    jFileChooser.setSelectedFile(new File((String)object2 + ".pdf"));
                }
            }
            if ((n2 = jFileChooser.showSaveDialog(this.parentFrame)) != 0) {
                return false;
            }
            if (object.size() > 1) {
                AgencyExposeTask.setLastSaveLocation(jFileChooser.getSelectedFile());
            } else {
                AgencyExposeTask.setLastSaveLocation(jFileChooser.getSelectedFile().getParentFile());
            }
            object3 = object.iterator();
            while (object3.hasNext()) {
                Object object4;
                object2 = (AgencyEstate)((Object)object3.next());
                File file = null;
                if (object.size() == 1) {
                    file = jFileChooser.getSelectedFile();
                } else {
                    object4 = object2.getPublicId();
                    if (object4 == null || ((String)object4).trim().length() == 0) {
                        object4 = "ID_" + ((AgencyEstate)((Object)object2)).getIdNr();
                    }
                    String string = pdfSetup.getName() + "_" + (String)object4;
                    string = string.replaceAll("[^\\w\\-\\.]", "_");
                    while (string.contains("__")) {
                        string = string.replace("__", "_");
                    }
                    File file2 = jFileChooser.getSelectedFile();
                    file = new File(file2.getAbsolutePath() + File.separator + string + ".pdf");
                }
                object4 = null;
                try {
                    this.setMessage("Writing " + file.getAbsolutePath());
                    object4 = new FileOutputStream(file);
                    pdfSetup.createBuilder().generatePdf((AgencyEstate)((Object)object2), (OutputStream)object4);
                    ((OutputStream)object4).flush();
                }
                finally {
                    IOUtils.closeQuietly((OutputStream)object4);
                }
            }
        } else if (n == 3) {
            this.openedExternally = true;
            object = this.getEstates();
            if (object.isEmpty()) {
                this.setMessage("Nothing to export!");
                return false;
            }
            PdfSetup pdfSetup = agencyExposeDialog.getSelectedPdfSetup();
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                AgencyEstate agencyEstate = (AgencyEstate)((Object)iterator.next());
                final File file = File.createTempFile("temp.", ".pdf");
                file.deleteOnExit();
                FileOutputStream fileOutputStream = null;
                try {
                    this.setMessage("Writing " + file.getAbsolutePath());
                    fileOutputStream = new FileOutputStream(file);
                    pdfSetup.createBuilder().generatePdf(agencyEstate, fileOutputStream);
                    fileOutputStream.flush();
                    this.add((ImmoToolTask)new ImmoToolTask<Boolean>(){

                        protected Boolean executeTask() throws Exception {
                            ImmoToolUtils.openPDF((File)file);
                            return true;
                        }
                    });
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(fileOutputStream);
                    throw throwable;
                }
                IOUtils.closeQuietly((OutputStream)fileOutputStream);
            }
        } else {
            return false;
        }
        return super.executeTask();
    }

    private List<AgencyEstate> getEstates() throws ImmoToolDbException {
        ArrayList<AgencyEstate> arrayList = new ArrayList<AgencyEstate>();
        if (this.estates != null) {
            arrayList.addAll(Arrays.asList(this.estates));
        } else if (this.estateIds != null) {
            for (Long l : this.estateIds) {
                AgencyEstate agencyEstate = AgencyEstate.loadEstate(l);
                if (agencyEstate == null) continue;
                arrayList.add(agencyEstate);
            }
        }
        return arrayList;
    }

    public final boolean isOpenedExternally() {
        return this.openedExternally;
    }

    public final boolean isSavedToFile() {
        return this.savedToFile;
    }

    public static synchronized void setLastSaveLocation(File file) {
        lastSaveLocation = file;
    }
}

