/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency;

import com.openindex.openestate.impl.utils.OpenEstateLocaleComboBox;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.agency.AgencyEstate;
import com.openindex.openestate.tool.agency.AgencyPlugin;
import com.openindex.openestate.tool.utils.NonEmptyComboBoxRule;
import com.openindex.openestate.tool.utils.ValidationHandler;
import com.openindex.openestate.tool.utils.ValidationRule;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.LayoutStyle;
import javax.swing.ListCellRenderer;
import org.apache.commons.lang.SystemUtils;
import org.jdesktop.application.Action;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationActionMap;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.swingx.JXPanel;
import org.jdesktop.swingx.JXTitledSeparator;

public class AgencyImportDialog
extends JDialog {
    public static final int OPENED = 0;
    public static final int CANCELLED = 1;
    public static final int APPROVED = 2;
    public static final int FORMAT_OPENESTATE = 0;
    public static final int FORMAT_OPENIMMO = 1;
    public static final int FORMAT_IMMOXML = 2;
    public static final int FORMAT_IS24_XML = 3;
    public static final int FORMAT_IS24_CSV = 4;
    public static final int FORMAT_IDX_CSV = 5;
    public static final int FORMAT_IMMOBILIARE = 6;
    public static final int FORMAT_KYERO = 7;
    private int format;
    private int status = 0;
    private ResourceMap resourceMap = null;
    private ValidationHandler validationHandler = null;
    private JButton cancelButton;
    private JCheckBox csvHashBox;
    private JComboBox deleteMethodBox;
    private JXTitledSeparator deleteMethodLabel;
    private JCheckBox ignoreUpdateBox;
    private JComboBox languageBox;
    private JXTitledSeparator languageLabel;
    private JXTitledSeparator optionsLabel;
    private JComboBox statusBox;
    private JXTitledSeparator statusLabel;
    private JButton submitButton;
    private JXTitledSeparator titleLabel;

    public AgencyImportDialog(Dialog dialog, int n) {
        super(dialog, true);
        this.build();
        this.setFormat(n);
        this.setLocationRelativeTo(dialog);
    }

    public AgencyImportDialog(Frame frame, int n) {
        super(frame, true);
        this.build();
        this.setFormat(n);
        this.setLocationRelativeTo(frame);
    }

    private void build() {
        this.resourceMap = ImmoToolUtils.getResourceMap(AgencyImportDialog.class);
        this.validationHandler = ImmoToolUtils.createValidationHandler();
        this.setContentPane((Container)new JXPanel());
        this.initComponents();
        this.ignoreUpdateBox.setOpaque(false);
        this.csvHashBox.setOpaque(false);
        this.statusBox.setModel(new DefaultComboBoxModel());
        this.statusBox.setRenderer(new StatusRenderer());
        this.statusBox.addItem(null);
        for (String string : AgencyEstate.getStatusList()) {
            this.statusBox.addItem(string);
        }
        this.deleteMethodBox.setModel(new DefaultComboBoxModel());
        this.deleteMethodBox.setRenderer(new DeleteMethodRenderer());
        this.deleteMethodBox.addItem(null);
        this.deleteMethodBox.addItem(0);
        this.deleteMethodBox.addItem(1);
        this.deleteMethodBox.addItem(2);
        this.deleteMethodBox.setSelectedIndex(1);
        this.validationHandler.putRule((JComponent)this.statusBox, (ValidationRule)new NonEmptyComboBoxRule(this.statusBox));
        this.validationHandler.putRule((JComponent)this.languageBox, (ValidationRule)new NonEmptyComboBoxRule(this.languageBox));
        this.validationHandler.putRule((JComponent)this.deleteMethodBox, (ValidationRule)new NonEmptyComboBoxRule(this.deleteMethodBox));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                AgencyImportDialog.this.doCancel();
            }
        });
        this.resourceMap.injectComponents((Component)this);
        if (SystemUtils.IS_OS_MAC_OSX) {
            this.cancelButton.setOpaque(false);
            this.submitButton.setOpaque(false);
        }
        ImmoToolUtils.configureDialog((JDialog)this, (JXPanel)((JXPanel)this.getContentPane()));
    }

    @Action
    public void doCancel() {
        this.status = 1;
        this.setVisible(false);
    }

    @Action
    public void doSubmit() {
        if (!this.validationHandler.isValid()) {
            ImmoToolUtils.showMessageErrorDialog((String)this.resourceMap.getString("error.invalidInput", new Object[0]));
            return;
        }
        this.status = 2;
        this.setVisible(false);
    }

    public int getFormat() {
        return this.format;
    }

    public ResourceMap getResourceMap() {
        return this.resourceMap;
    }

    public Integer getSelectedDeleteMethod() {
        return (Integer)this.deleteMethodBox.getSelectedItem();
    }

    public Locale getSelectedLocale() {
        return (Locale)this.languageBox.getSelectedItem();
    }

    public String getSelectedStatus() {
        return (String)(this.statusBox.getSelectedIndex() <= 0 ? null : this.statusBox.getSelectedItem());
    }

    public int getStatus() {
        return this.status;
    }

    public boolean isCsvHashingSelected() {
        return this.csvHashBox.isEnabled() && this.csvHashBox.isSelected();
    }

    public boolean isIgnoreUpdateSelected() {
        return this.ignoreUpdateBox.isEnabled() && this.ignoreUpdateBox.isSelected();
    }

    private void setCsvHashBoxVisible(boolean bl) {
        this.csvHashBox.setEnabled(bl);
        this.csvHashBox.setVisible(bl);
    }

    private void setDeleteSelectionVisible(boolean bl) {
        this.deleteMethodLabel.setVisible(bl);
        this.deleteMethodBox.setEnabled(bl);
        this.deleteMethodBox.setVisible(bl);
    }

    private void setLanguageSelectionVisible(boolean bl) {
        this.languageBox.setEnabled(bl);
        this.languageBox.setVisible(bl);
        this.languageLabel.setVisible(bl);
    }

    public final void setFormat(int n) {
        this.format = n;
        switch (n) {
            case 2: {
                this.setCsvHashBoxVisible(false);
                this.setDeleteSelectionVisible(true);
                this.setLanguageSelectionVisible(true);
                break;
            }
            case 6: {
                this.setCsvHashBoxVisible(false);
                this.setDeleteSelectionVisible(true);
                this.setLanguageSelectionVisible(true);
                break;
            }
            case 5: {
                this.setCsvHashBoxVisible(true);
                this.setDeleteSelectionVisible(true);
                this.setLanguageSelectionVisible(true);
                break;
            }
            case 4: {
                this.setCsvHashBoxVisible(true);
                this.setDeleteSelectionVisible(true);
                this.setLanguageSelectionVisible(true);
                break;
            }
            case 3: {
                this.setCsvHashBoxVisible(false);
                this.setDeleteSelectionVisible(true);
                this.setLanguageSelectionVisible(true);
                break;
            }
            case 7: {
                this.setCsvHashBoxVisible(false);
                this.setDeleteSelectionVisible(true);
                this.setLanguageSelectionVisible(false);
                break;
            }
            case 0: {
                this.setCsvHashBoxVisible(false);
                this.setDeleteSelectionVisible(true);
                this.setLanguageSelectionVisible(false);
                break;
            }
            case 1: {
                this.setCsvHashBoxVisible(false);
                this.setDeleteSelectionVisible(true);
                this.setLanguageSelectionVisible(true);
                break;
            }
            default: {
                this.setCsvHashBoxVisible(false);
                this.setDeleteSelectionVisible(true);
                this.setLanguageSelectionVisible(false);
            }
        }
    }

    private void initComponents() {
        this.titleLabel = ImmoToolUtils.createHead1Separator((String)"");
        this.statusLabel = ImmoToolUtils.createHead2Separator((String)"");
        this.statusBox = new JComboBox();
        this.languageLabel = ImmoToolUtils.createHead2Separator((String)"");
        this.languageBox = new OpenEstateLocaleComboBox(true, AgencyPlugin.getLocales());
        this.deleteMethodLabel = new JXTitledSeparator();
        this.deleteMethodBox = new JComboBox();
        this.optionsLabel = ImmoToolUtils.createHead2Separator((String)"");
        this.ignoreUpdateBox = new JCheckBox();
        this.csvHashBox = new JCheckBox();
        this.submitButton = new JButton();
        this.cancelButton = new JButton();
        this.setDefaultCloseOperation(0);
        this.setName("Form");
        this.titleLabel.setName("titleLabel");
        this.statusLabel.setName("statusLabel");
        this.statusBox.setName("statusBox");
        this.languageLabel.setName("languageLabel");
        this.languageBox.setName("languageBox");
        this.deleteMethodLabel.setName("deleteMethodLabel");
        this.deleteMethodBox.setName("deleteMethodBox");
        this.optionsLabel.setName("optionsLabel");
        this.ignoreUpdateBox.setName("ignoreUpdateBox");
        this.csvHashBox.setName("csvHashBox");
        ApplicationActionMap applicationActionMap = Application.getInstance().getContext().getActionMap(AgencyImportDialog.class, (Object)this);
        this.submitButton.setAction(applicationActionMap.get("doSubmit"));
        this.submitButton.setName("submitButton");
        this.cancelButton.setAction(applicationActionMap.get("doCancel"));
        this.cancelButton.setName("cancelButton");
        GroupLayout groupLayout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(GroupLayout.Alignment.LEADING, groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.titleLabel, -1, 463, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addComponent(this.submitButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelButton)).addGroup(groupLayout.createSequentialGroup().addGap(12, 12, 12).addComponent(this.statusBox, 0, 451, Short.MAX_VALUE)).addComponent((Component)this.statusLabel, -1, 463, Short.MAX_VALUE).addGroup(groupLayout.createSequentialGroup().addGap(12, 12, 12).addComponent(this.languageBox, 0, 451, Short.MAX_VALUE)).addComponent((Component)this.languageLabel, -1, 463, Short.MAX_VALUE).addComponent((Component)this.deleteMethodLabel, -1, 463, Short.MAX_VALUE))).addGroup(GroupLayout.Alignment.LEADING, groupLayout.createSequentialGroup().addGap(24, 24, 24).addComponent(this.deleteMethodBox, 0, 451, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.LEADING, groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.optionsLabel, -1, 463, Short.MAX_VALUE).addGroup(groupLayout.createSequentialGroup().addGap(12, 12, 12).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.csvHashBox, GroupLayout.Alignment.TRAILING, -1, 451, Short.MAX_VALUE).addComponent(this.ignoreUpdateBox, -1, 451, Short.MAX_VALUE)))))).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent((Component)this.titleLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent((Component)this.statusLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.statusBox, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent((Component)this.languageLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.languageBox, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent((Component)this.deleteMethodLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.deleteMethodBox, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent((Component)this.optionsLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.ignoreUpdateBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.csvHashBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 105, Short.MAX_VALUE).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cancelButton).addComponent(this.submitButton)).addContainerGap()));
        this.pack();
    }

    private final class StatusRenderer
    extends JLabel
    implements ListCellRenderer {
        public StatusRenderer() {
            this.setOpaque(true);
            this.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            this.setBackground(bl ? jList.getSelectionBackground() : jList.getBackground());
            this.setForeground(bl ? jList.getSelectionForeground() : jList.getForeground());
            if (object instanceof String) {
                String string = (String)object;
                this.setText(AgencyEstate.writeStatus(string));
            } else {
                this.setText("[ " + AgencyImportDialog.this.resourceMap.getString("label.noStatusSelected", new Object[0]) + " ]");
            }
            return this;
        }
    }

    private final class DeleteMethodRenderer
    extends JLabel
    implements ListCellRenderer {
        public DeleteMethodRenderer() {
            this.setOpaque(true);
            this.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            this.setBackground(bl ? jList.getSelectionBackground() : jList.getBackground());
            this.setForeground(bl ? jList.getSelectionForeground() : jList.getForeground());
            if (object instanceof Integer) {
                switch ((Integer)object) {
                    case 0: {
                        this.setText(AgencyImportDialog.this.resourceMap.getString("label.deleteMethod.nothing", new Object[0]));
                        break;
                    }
                    case 1: {
                        this.setText(AgencyImportDialog.this.resourceMap.getString("label.deleteMethod.explicitly", new Object[0]));
                        break;
                    }
                    case 2: {
                        this.setText(AgencyImportDialog.this.resourceMap.getString("label.deleteMethod.unmodified", new Object[0]));
                        break;
                    }
                    default: {
                        this.setText("???");
                        break;
                    }
                }
            } else {
                this.setText("[ " + AgencyImportDialog.this.resourceMap.getString("label.noDeleteMethodSelected", new Object[0]) + " ]");
            }
            return this;
        }
    }
}

