/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency;

import com.openindex.openestate.impl.AgencyImpl;
import com.openindex.openestate.impl.AgentContactImpl;
import com.openindex.openestate.impl.EstateAttachmentImpl;
import com.openindex.openestate.impl.EstateImpl;
import com.openindex.openestate.impl.OpenEstateUtils;
import com.openindex.openestate.impl.TransferAgencyImpl;
import com.openindex.openestate.impl.TransferImpl;
import com.openindex.openestate.tool.ImmoToolApp;
import com.openindex.openestate.tool.ImmoToolDbException;
import com.openindex.openestate.tool.ImmoToolDbUtils;
import com.openindex.openestate.tool.ImmoToolTask;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.agency.AgencyContact;
import com.openindex.openestate.tool.agency.AgencyEstate;
import com.openindex.openestate.tool.agency.AgencyExportList;
import com.openindex.openestate.tool.agency.AgencyImportDialog;
import com.openindex.openestate.tool.agency.AgencyPlugin;
import com.openindex.openestate.tool.agency.AgencyPluginUtils;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Window;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.imageio.ImageIO;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.jdesktop.application.ResourceMap;
import org.xmldb.api.base.Collection;

public abstract class AgencyImportTask
extends ImmoToolTask<ImportResult> {
    private static final Logger LOGGER = Logger.getLogger(AgencyImportTask.class);
    public static final String KEY_IMPORT_HASH = "import.hash";
    public static final int DELETE_NOTHING = 0;
    public static final int DELETE_EXPLICITLY = 1;
    public static final int DELETE_UNMODIFIED = 2;
    private final ResourceMap resourceMap;
    private final Map<Long, String> importContacts;
    private File importFile;
    private File importZipFile = null;

    public AgencyImportTask(File file) {
        this.importFile = file;
        this.importContacts = new HashMap<Long, String>();
        this.resourceMap = ImmoToolUtils.getResourceMap(AgencyImportTask.class);
        this.setTitle(this.resourceMap.getString("title", new Object[0]));
    }

    protected boolean deleteEstate(AgencyEstate agencyEstate) {
        try {
            if (agencyEstate.isExportEnabled() && "VERMITTLUNG".equalsIgnoreCase(agencyEstate.getStatus())) {
                AgencyExportList.registerChanges(agencyEstate, "delete");
            }
            AgencyEstate.removeEstate(agencyEstate.getIdNr());
            return true;
        }
        catch (Exception exception) {
            LOGGER.warn((Object)("Can't delete estate #" + agencyEstate.getIdNr()));
            LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
            return false;
        }
    }

    protected void finished() {
        super.finished();
        if (this.importZipFile != null) {
            File file = ImmoToolApp.getApplication().getProject().getTempDirectory();
            if ((file = new File(file.getAbsolutePath() + File.separator + "import")).exists()) {
                FileUtils.deleteQuietly((File)file);
            }
        }
    }

    public Map<Long, String> getImportContacts() {
        return this.importContacts;
    }

    public File getImportFile() {
        return this.importFile;
    }

    protected ImportResult importAgency(AgencyImpl agencyImpl, String string, int n, boolean bl) throws ImmoToolDbException {
        Object object;
        String string2;
        if (agencyImpl == null) {
            throw new IllegalArgumentException("invalid agency!");
        }
        if (string == null || string.trim().length() <= 0) {
            throw new IllegalArgumentException("invalid estate-status!");
        }
        ArrayList<Object> arrayList = null;
        if (2 == n) {
            arrayList = new ArrayList<Object>();
        }
        this.setMessage(this.resourceMap.getString("message.doInit", new Object[0]));
        this.init();
        long l = 0L;
        HashMap<Object, String> hashMap = new HashMap<Object, String>();
        for (Object object2 : agencyImpl.getContacts().values()) {
            try {
                this.checkCancelled();
            }
            catch (Exception exception) {
                throw new RuntimeException("Interrupted.", exception);
            }
            this.setMessage(this.resourceMap.getString("message.doHandleContact", new Object[]{++l}));
            try {
                Object object3 = object2.getId();
                string2 = this.importContact((AgentContactImpl)object2, string);
                if (string2 == null || string2.trim().length() == 0) {
                    throw new Exception("no contact-id defined!");
                }
                if (object3 == null || ((String)object3).trim().length() <= 0) continue;
                hashMap.put(object3, string2);
            }
            catch (Exception exception) {
                this.setMessage(this.resourceMap.getString("error.cantSaveContact", new Object[]{exception.getLocalizedMessage()}));
                LOGGER.error((Object)"cant save contact!");
                LOGGER.error((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
            }
        }
        l = 0L;
        ImportResult importResult = new ImportResult();
        importResult.setTotalCount(agencyImpl.getEstates().size());
        for (Object object3 : agencyImpl.getEstates().values()) {
            try {
                this.checkCancelled();
            }
            catch (Exception exception) {
                throw new RuntimeException("Interrupted.", exception);
            }
            this.setMessage(this.resourceMap.getString("message.doHandleEstate", new Object[]{++l}));
            try {
                string2 = object3.getContactId();
                if (string2 != null && hashMap.containsKey(string2)) {
                    object3.setContactId((String)hashMap.get(string2));
                } else {
                    object3.setContactId(null);
                }
                AgencyEstate object4 = this.lookupEstateByImportHash((EstateImpl)object3);
                if (object4 != null) {
                    LOGGER.info((Object)("Ignore already existing property #" + object4.getIdNr()));
                    if (arrayList != null) {
                        arrayList.add(object4.getIdNr());
                    }
                    importResult.setIgnoreCount(importResult.getIgnoreCount() + 1);
                    continue;
                }
                object = this.importEstate((EstateImpl)object3, string, bl, importResult);
                if (object == null || (Long)object <= 0L || arrayList == null || arrayList.contains(object)) continue;
                arrayList.add(object);
            }
            catch (Exception exception) {
                this.setMessage(this.resourceMap.getString("error.cantSaveEstate", new Object[]{exception.getLocalizedMessage()}));
                LOGGER.error((Object)"cant save estate!");
                LOGGER.error((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
            }
        }
        if (n == 2 && arrayList != null) {
            for (Long l2 : AgencyEstate.loadEstateIds()) {
                if (arrayList.contains(l2)) continue;
                this.setMessage(this.resourceMap.getString("message.doDelete.unchanged", new Object[]{l2}));
                object = AgencyEstate.loadEstate(l2);
                if (object == null || !this.deleteEstate((AgencyEstate)((Object)object))) continue;
                importResult.setDeleteUnmodifiedCount(importResult.getDeleteUnmodifiedCount() + 1);
            }
        }
        return importResult;
    }

    protected String importContact(AgentContactImpl agentContactImpl, String string) throws ImmoToolDbException {
        if (agentContactImpl == null) {
            throw new NullPointerException("invalid contact!");
        }
        long l = agentContactImpl.calculateHash();
        if (this.importContacts.containsKey(l)) {
            return this.importContacts.get(l);
        }
        AgencyContact agencyContact = new AgencyContact(agentContactImpl);
        agencyContact.setId(null);
        String string2 = agencyContact.store();
        l = agentContactImpl.calculateHash();
        if (!this.importContacts.containsKey(l)) {
            this.importContacts.put(l, string2);
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Long importEstate(EstateImpl estateImpl, String string, boolean bl, ImportResult importResult) throws ImmoToolDbException {
        Object object;
        Object object2;
        boolean bl2 = false;
        if (estateImpl == null) {
            throw new NullPointerException("invalid estate!");
        }
        AgencyEstate agencyEstate = estateImpl instanceof AgencyEstate ? (AgencyEstate)estateImpl : new AgencyEstate(estateImpl);
        agencyEstate.setId(null);
        String string2 = agencyEstate.getNrIntern();
        if (string2 != null && string2.trim().length() > 0) {
            this.setMessage("> " + this.resourceMap.getString("message.doHandleEstate.checkImportId", new Object[]{string2}));
            object2 = AgencyEstate.loadEstateByNrIntern(string2);
            if (object2 != null) {
                this.setMessage("> " + this.resourceMap.getString("message.doHandleEstate.updateEstate", new Object[]{((AgencyEstate)((Object)object2)).getIdNr()}));
                bl2 = true;
                agencyEstate.setId(object2.getId());
            }
        }
        if (agencyEstate.getId() == null && (object2 = agencyEstate.getPublicId()) != null && ((String)object2).trim().length() > 0) {
            this.setMessage("> " + this.resourceMap.getString("message.doHandleEstate.checkImportNr", new Object[]{object2}));
            object = AgencyEstate.loadEstateByPublicId((String)object2);
            if (object != null) {
                this.setMessage("> " + this.resourceMap.getString("message.doHandleEstate.updateEstate", new Object[]{((AgencyEstate)((Object)object)).getIdNr()}));
                bl2 = true;
                agencyEstate.setId(object.getId());
            }
        }
        if (bl2 && bl) {
            this.setMessage("> " + this.resourceMap.getString("message.doHandleEstate.ignoreEstate", new Object[]{agencyEstate.getIdNr()}));
            importResult.setIgnoreCount(importResult.getIgnoreCount() + 1);
            return agencyEstate.getIdNr();
        }
        if (string != null && string.trim().length() > 0) {
            agencyEstate.setStatus(string);
        }
        agencyEstate.setExportAlways(true);
        agencyEstate.setExportEnabled(true);
        if (agencyEstate.getLanguages().isEmpty()) {
            object2 = agencyEstate.getTitleLanguages();
            agencyEstate.getLanguages().addAll(Arrays.asList(object2));
        }
        int n = agencyEstate.getAttachments().size();
        object = agencyEstate.getAttachments().toArray(new EstateAttachmentImpl[n]);
        agencyEstate.getAttachments().clear();
        Long l = agencyEstate.store();
        if (l == null || l < 1L) {
            throw new ImmoToolDbException("estate was not saved!");
        }
        int n2 = 0;
        for (Object object3 : object) {
            FileOutputStream fileOutputStream;
            FileInputStream fileInputStream;
            InputStream inputStream;
            File file;
            block39: {
                block38: {
                    try {
                        this.checkCancelled();
                    }
                    catch (Exception exception) {
                        throw new RuntimeException("Interrupted.", exception);
                    }
                    file = null;
                    inputStream = null;
                    fileInputStream = null;
                    fileOutputStream = null;
                    inputStream = this.readAttachment((EstateAttachmentImpl)object3, ++n2);
                    if (inputStream != null) break block38;
                    IOUtils.closeQuietly((InputStream)inputStream);
                    IOUtils.closeQuietly(fileInputStream);
                    IOUtils.closeQuietly(fileOutputStream);
                    FileUtils.deleteQuietly(file);
                    continue;
                }
                try {
                    String string3;
                    Object object4;
                    Object object5 = null;
                    try {
                        object5 = ImageIO.read(inputStream);
                    }
                    catch (IOException iOException) {
                        LOGGER.warn((Object)"Can't read attached image!");
                        LOGGER.warn((Object)("> " + iOException.getLocalizedMessage()), (Throwable)iOException);
                    }
                    if (object5 != null) {
                        int n3 = AgencyPlugin.getImgMaxWidth();
                        int n4 = AgencyPlugin.getImgMaxHeight();
                        if (((BufferedImage)object5).getHeight(null) > n4 || ((BufferedImage)object5).getWidth(null) > n3) {
                            object4 = ImmoToolUtils.scaleImageAndKeepRatio((BufferedImage)object5, (int)n3, (int)n4);
                            ((Image)object5).flush();
                            object5 = object4;
                        }
                        object4 = AgencyPlugin.getImgDefaultFormat();
                        String string4 = null;
                        if ("JPG".equalsIgnoreCase((String)object4)) {
                            string4 = "image/jpeg";
                        } else if ("PNG".equalsIgnoreCase((String)object4)) {
                            string4 = "image/png";
                        } else {
                            object4 = "JPG";
                            string4 = "image/jpeg";
                        }
                        file = File.createTempFile("import.", ".temp");
                        fileOutputStream = new FileOutputStream(file);
                        ImageIO.write((RenderedImage)object5, (String)object4, fileOutputStream);
                        fileOutputStream.flush();
                        ((Image)object5).flush();
                        fileInputStream = new FileInputStream(file);
                        String string5 = AgencyEstate.storeAttachment(l, fileInputStream, System.currentTimeMillis() + "." + ((String)object4).toLowerCase(), string4);
                        object3.setFile(string5);
                        object3.setMimeType(string4);
                        agencyEstate.getAttachments().add(object3);
                        break block39;
                    }
                    String string6 = null;
                    if (object3.isName()) {
                        String string7 = object3.getFileAsName();
                        if (string7.contains(".")) {
                            string6 = string7.substring(string7.lastIndexOf(".")).trim();
                        }
                    } else if (object3.isUrl() && (string3 = object3.getFileAsUrl().getFile()).contains(".")) {
                        string6 = string3.substring(string3.lastIndexOf(".")).trim();
                    }
                    if (string6 == null || string6.length() == 0) {
                        string6 = ".bin";
                    }
                    String string8 = "application/octet-stream";
                    if (object3.getMimeType() != null && object3.getMimeType().trim().length() > 0) {
                        string8 = object3.getMimeType();
                    }
                    object4 = AgencyEstate.storeAttachment(l, inputStream, System.currentTimeMillis() + "." + string6.toLowerCase(), string8);
                    object3.setFile((String)object4);
                    object3.setMimeType(string8);
                    agencyEstate.getAttachments().add(object3);
                }
                catch (Exception exception) {
                    try {
                        LOGGER.error((Object)"could not import estate-attachment!");
                        LOGGER.error((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(inputStream);
                        IOUtils.closeQuietly(fileInputStream);
                        IOUtils.closeQuietly(fileOutputStream);
                        FileUtils.deleteQuietly(file);
                        throw throwable;
                    }
                    IOUtils.closeQuietly((InputStream)inputStream);
                    IOUtils.closeQuietly(fileInputStream);
                    IOUtils.closeQuietly(fileOutputStream);
                    FileUtils.deleteQuietly(file);
                    continue;
                }
            }
            IOUtils.closeQuietly((InputStream)inputStream);
            IOUtils.closeQuietly((InputStream)fileInputStream);
            IOUtils.closeQuietly((OutputStream)fileOutputStream);
            FileUtils.deleteQuietly((File)file);
        }
        if (bl2) {
            AgencyEstate.removeUnusedAttachments(agencyEstate);
        }
        if (!agencyEstate.getAttachments().isEmpty()) {
            agencyEstate.store();
        }
        if (agencyEstate.isExportEnabled() && "VERMITTLUNG".equalsIgnoreCase(agencyEstate.getStatus())) {
            try {
                AgencyExportList.registerChanges(agencyEstate, "update");
            }
            catch (Exception exception) {
                LOGGER.error((Object)"could not register estate for export!");
                LOGGER.error((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
            }
        }
        if (l == null || l < 1L) {
            LOGGER.warn((Object)"Can't import property!");
            importResult.setErrorCount(importResult.getErrorCount() + 1);
        } else {
            importResult.setUpdateCount(importResult.getUpdateCount() + 1);
        }
        return l;
    }

    protected ImportResult importTransfer(TransferImpl transferImpl, String string, int n, boolean bl) throws ImmoToolDbException {
        if (transferImpl == null) {
            throw new IllegalArgumentException("invalid transfer!");
        }
        if (transferImpl.getAgencies().isEmpty()) {
            throw new IllegalArgumentException("empty transfer!");
        }
        if (string == null || string.trim().length() <= 0) {
            throw new IllegalArgumentException("invalid estate-status!");
        }
        ArrayList<Object> arrayList = n == 2 ? new ArrayList<Object>() : null;
        this.setMessage(this.resourceMap.getString("message.doInit", new Object[0]));
        this.init();
        long l = 0L;
        long l2 = 0L;
        ImportResult importResult = new ImportResult();
        for (TransferAgencyImpl transferAgencyImpl : transferImpl.getAgencies()) {
            Object object;
            HashMap<String, String> hashMap = new HashMap<String, String>();
            for (AgentContactImpl agentContactImpl : transferAgencyImpl.getContacts().values()) {
                try {
                    this.checkCancelled();
                }
                catch (Exception exception) {
                    throw new RuntimeException("Interrupted.", exception);
                }
                this.setMessage(this.resourceMap.getString("message.doHandleContact", new Object[]{++l2}));
                try {
                    String string2 = agentContactImpl.getId();
                    String string3 = this.importContact(agentContactImpl, string);
                    if (string3 == null || string3.trim().length() == 0) {
                        throw new Exception("no contact-id defined!");
                    }
                    if (string2 == null || string2.trim().length() <= 0) continue;
                    hashMap.put(string2, string3);
                }
                catch (Exception exception) {
                    this.setMessage(this.resourceMap.getString("error.cantSaveContact", new Object[]{exception.getLocalizedMessage()}));
                    LOGGER.error((Object)"cant save contact!");
                    LOGGER.error((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
                }
            }
            importResult.setTotalCount(importResult.getTotalCount() + transferAgencyImpl.getEstateIdsToRemove().size() + transferAgencyImpl.getEstatesToSave().size());
            for (EstateImpl estateImpl : transferAgencyImpl.getEstatesToSave()) {
                try {
                    this.checkCancelled();
                }
                catch (Exception exception) {
                    throw new RuntimeException("Interrupted.", exception);
                }
                this.setMessage(this.resourceMap.getString("message.doHandleEstate", new Object[]{++l}));
                try {
                    String string3 = estateImpl.getContactId();
                    if (string3 != null && hashMap.containsKey(string3)) {
                        estateImpl.setContactId((String)hashMap.get(string3));
                    } else {
                        estateImpl.setContactId(null);
                    }
                    AgencyEstate agencyEstate = this.lookupEstateByImportHash(estateImpl);
                    if (agencyEstate != null) {
                        LOGGER.info((Object)("Ignore already existing property #" + agencyEstate.getIdNr()));
                        if (arrayList != null) {
                            arrayList.add(agencyEstate.getIdNr());
                        }
                        importResult.setIgnoreCount(importResult.getIgnoreCount() + 1);
                        continue;
                    }
                    object = this.importEstate(estateImpl, string, bl, importResult);
                    if (object == null || (Long)object <= 0L || arrayList == null || arrayList.contains(object)) continue;
                    arrayList.add(object);
                }
                catch (Exception exception) {
                    this.setMessage(this.resourceMap.getString("error.cantSaveEstate", new Object[]{exception.getLocalizedMessage()}));
                    LOGGER.error((Object)"cant save estate!");
                    LOGGER.error((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
                }
            }
            if (1 == n) {
                for (String string4 : transferAgencyImpl.getEstateIdsToRemove()) {
                    AgencyEstate agencyEstate = AgencyEstate.loadEstateByNrIntern(string4);
                    if (agencyEstate == null) {
                        LOGGER.warn((Object)"Can't find estate for explicit delete!");
                        LOGGER.warn((Object)("> nr: " + string4));
                        continue;
                    }
                    this.setMessage(this.resourceMap.getString("message.doDelete.explicitly", new Object[]{agencyEstate.getIdNr()}));
                    if (!this.deleteEstate(agencyEstate)) continue;
                    importResult.setDeleteExplicitCount(importResult.getDeleteExplicitCount() + 1);
                }
            }
            if (n != 2 || arrayList == null) continue;
            for (Iterator<Object> iterator : AgencyEstate.loadEstateIds()) {
                if (arrayList.contains(iterator)) continue;
                this.setMessage(this.resourceMap.getString("message.doDelete.unchanged", new Object[]{iterator}));
                object = AgencyEstate.loadEstate((Long)((Object)iterator));
                if (object == null || !this.deleteEstate((AgencyEstate)((Object)object))) continue;
                importResult.setDeleteUnmodifiedCount(importResult.getDeleteUnmodifiedCount() + 1);
            }
        }
        return importResult;
    }

    private void init() throws ImmoToolDbException {
        this.importContacts.clear();
        Collection collection = null;
        try {
            collection = AgencyPluginUtils.openPluginCollection("/contacts");
            for (String string : collection.listResources()) {
                this.checkCancelled();
                try {
                    String[] stringArray = string.split("\\.");
                    Long l = Long.valueOf(stringArray[stringArray.length - 2]);
                    AgencyContact agencyContact = AgencyContact.loadContact(l);
                    long l2 = agencyContact.calculateHash();
                    if (this.importContacts.containsKey(l2)) continue;
                    this.importContacts.put(l2, agencyContact.getId());
                }
                catch (Exception exception) {
                    LOGGER.warn((Object)exception.getLocalizedMessage(), (Throwable)exception);
                }
            }
        }
        catch (ImmoToolDbException immoToolDbException) {
            throw immoToolDbException;
        }
        catch (Exception exception) {
            throw new ImmoToolDbException(exception.getLocalizedMessage(), (Throwable)exception);
        }
        finally {
            ImmoToolDbUtils.close((Collection)collection);
        }
    }

    protected void logDefaultSettings(String string, int n, Locale locale) {
        ResourceMap resourceMap = ImmoToolUtils.getResourceMap(AgencyImportDialog.class);
        if (locale != null) {
            this.logSetting(resourceMap.getString("languageLabel.title", new Object[0]), locale.getDisplayLanguage(Locale.getDefault()) + " (" + locale.getLanguage() + ")");
        }
        if (string != null) {
            this.logSetting(resourceMap.getString("statusLabel.title", new Object[0]), AgencyEstate.writeStatus(string));
        }
        switch (n) {
            case 0: {
                this.logSetting(resourceMap.getString("deleteMethodLabel.title", new Object[0]), resourceMap.getString("label.deleteMethod.nothing", new Object[0]));
                break;
            }
            case 1: {
                this.logSetting(resourceMap.getString("deleteMethodLabel.title", new Object[0]), resourceMap.getString("label.deleteMethod.explicitly", new Object[0]));
                break;
            }
            case 2: {
                this.logSetting(resourceMap.getString("deleteMethodLabel.title", new Object[0]), resourceMap.getString("label.deleteMethod.unmodified", new Object[0]));
                break;
            }
        }
    }

    protected void logDialogSettings(AgencyImportDialog agencyImportDialog) {
        this.logDefaultSettings(agencyImportDialog.getSelectedStatus(), agencyImportDialog.getSelectedDeleteMethod(), agencyImportDialog.getSelectedLocale());
        if (agencyImportDialog.isIgnoreUpdateSelected()) {
            this.logSetting(agencyImportDialog.getResourceMap().getString("updateBox.text", new Object[0]), null);
        }
        if (agencyImportDialog.isCsvHashingSelected()) {
            this.logSetting(agencyImportDialog.getResourceMap().getString("csvHashBox.text", new Object[0]), null);
        }
    }

    protected void logSetting(String string, String string2) {
        this.setMessage("> " + string);
        if (string2 != null) {
            this.setMessage("  " + string2);
        }
    }

    protected File lookupAttachmentFile(EstateAttachmentImpl estateAttachmentImpl, File file) {
        return new File(file.getAbsolutePath() + File.separator + estateAttachmentImpl.getFileAsName());
    }

    protected AgencyEstate lookupEstateByImportHash(EstateImpl estateImpl) throws ImmoToolDbException {
        if (!estateImpl.getCustomValues().hasCustomValue(KEY_IMPORT_HASH)) {
            return null;
        }
        String string = estateImpl.getCustomValues().getCustomValue(KEY_IMPORT_HASH).getString();
        if (string == null || string.trim().length() <= 0) {
            return null;
        }
        return AgencyEstate.loadEstateByCustomValue(KEY_IMPORT_HASH, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File openImportFile(String[] stringArray) throws DocumentException, IOException {
        block10: {
            Object object;
            File file = this.getImportFile();
            for (String object2 : stringArray) {
                if (!file.getName().toLowerCase().endsWith(object2.toLowerCase())) continue;
                this.importZipFile = null;
                return file;
            }
            if (!file.getName().toLowerCase().endsWith(".zip")) break block10;
            this.importFile = null;
            this.importZipFile = file;
            Object object3 = ImmoToolApp.getApplication().getProject().getTempDirectory();
            if (!((File)(object3 = new File(((File)object3).getAbsolutePath() + File.separator + "import"))).exists() && !((File)object3).mkdirs()) {
                throw new IOException("could not create temp-dir: " + ((File)object3).getAbsolutePath());
            }
            ZipInputStream zipInputStream = null;
            try {
                object = null;
                zipInputStream = new ZipInputStream(new BufferedInputStream(new FileInputStream(file)));
                block3: while ((object = zipInputStream.getNextEntry()) != null) {
                    File file2 = new File(((File)object3).getAbsolutePath() + File.separator + ((ZipEntry)object).getName());
                    if (((ZipEntry)object).isDirectory()) {
                        if (file2.mkdirs()) continue;
                        throw new IOException("could not create zip-dir: " + file2.getAbsolutePath());
                    }
                    ImmoToolUtils.writeStreamToFile((InputStream)zipInputStream, (File)file2);
                    if (this.importFile != null) continue;
                    String[] stringArray2 = stringArray;
                    int n = stringArray2.length;
                    for (int i = 0; i < n; ++i) {
                        String string = stringArray2[i];
                        if (!file2.getName().toLowerCase().endsWith(string.toLowerCase())) continue;
                        this.importFile = file2;
                        continue block3;
                    }
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(zipInputStream);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)zipInputStream);
            if (this.importFile == null) {
                FileUtils.deleteQuietly((File)object3);
                object = new StringBuilder();
                for (String string : stringArray) {
                    if (((StringBuilder)object).length() > 0) {
                        ((StringBuilder)object).append(", ");
                    }
                    ((StringBuilder)object).append(string);
                }
                throw new IOException(this.resourceMap.getString("error.noImportableFileInZipArchive", new Object[]{((StringBuilder)object).toString()}));
            }
            return this.importFile;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Document openImportFileAsDocument() throws DocumentException, IOException {
        File file = this.openImportFile(new String[]{".xml"});
        if (file == null) {
            return null;
        }
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            Document document = OpenEstateUtils.loadDocument((InputStream)fileInputStream);
            return document;
        }
        finally {
            if (fileInputStream != null) {
                fileInputStream.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected InputStream readAttachment(EstateAttachmentImpl estateAttachmentImpl, int n) throws IOException, URISyntaxException {
        if (estateAttachmentImpl.isBase64()) {
            this.setMessage("> " + this.resourceMap.getString("message.doHandleEstate.attachment", new Object[]{n}) + " (base64)");
            return new ByteArrayInputStream(estateAttachmentImpl.getFileAsBase64());
        }
        if (estateAttachmentImpl.isUrl()) {
            this.setMessage("> " + this.resourceMap.getString("message.doHandleEstate.attachment", new Object[]{n}) + " (url)");
            URL uRL = estateAttachmentImpl.getFileAsUrl();
            String string = uRL.getProtocol().toLowerCase();
            if ("http".equals(string) || "https".equals(string)) {
                FileInputStream fileInputStream;
                FileOutputStream fileOutputStream = null;
                try {
                    HttpClient httpClient = ImmoToolUtils.createHttpClient();
                    HttpResponse httpResponse = httpClient.execute((HttpUriRequest)new HttpGet(ImmoToolUtils.toIdnUrl((URL)uRL).toURI()));
                    HttpEntity httpEntity = httpResponse.getEntity();
                    File file = File.createTempFile("import.", ".temp");
                    fileOutputStream = new FileOutputStream(file);
                    IOUtils.copy((InputStream)httpEntity.getContent(), (OutputStream)fileOutputStream);
                    fileOutputStream.flush();
                    ((OutputStream)fileOutputStream).close();
                    EntityUtils.consume((HttpEntity)httpEntity);
                    fileInputStream = new FileInputStream(file);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(fileOutputStream);
                    throw throwable;
                }
                IOUtils.closeQuietly((OutputStream)fileOutputStream);
                return fileInputStream;
            }
            return uRL.openStream();
        }
        if (estateAttachmentImpl.isName()) {
            this.setMessage("> " + this.resourceMap.getString("message.doHandleEstate.attachment", new Object[]{n}) + " (file)");
            File file = this.lookupAttachmentFile(estateAttachmentImpl, this.getImportFile().getParentFile());
            return file.isFile() ? new FileInputStream(file) : null;
        }
        return null;
    }

    protected AgencyImportDialog showImportDialog(Window window, int n) {
        this.setMessage(this.resourceMap.getString("message.doSetupImport", new Object[0]));
        AgencyImportDialog agencyImportDialog = window instanceof Dialog ? new AgencyImportDialog((Dialog)window, n) : new AgencyImportDialog((Frame)window, n);
        agencyImportDialog.setVisible(true);
        agencyImportDialog.dispose();
        if (agencyImportDialog.getStatus() != 2) {
            return null;
        }
        return agencyImportDialog;
    }

    public static class ImportResult {
        private int totalCount = 0;
        private int updateCount = 0;
        private int ignoreCount = 0;
        private int errorCount = 0;
        private int deleteExplicitCount = 0;
        private int deleteUnmodifiedCount = 0;

        public int getDeleteExplicitCount() {
            return this.deleteExplicitCount;
        }

        public int getDeleteUnmodifiedCount() {
            return this.deleteUnmodifiedCount;
        }

        public int getErrorCount() {
            return this.errorCount;
        }

        public int getIgnoreCount() {
            return this.ignoreCount;
        }

        public int getTotalCount() {
            return this.totalCount;
        }

        public int getUpdateCount() {
            return this.updateCount;
        }

        public void setDeleteExplicitCount(int n) {
            this.deleteExplicitCount = n;
        }

        public void setDeleteUnmodifiedCount(int n) {
            this.deleteUnmodifiedCount = n;
        }

        public void setErrorCount(int n) {
            this.errorCount = n;
        }

        public void setIgnoreCount(int n) {
            this.ignoreCount = n;
        }

        public void setTotalCount(int n) {
            this.totalCount = n;
        }

        public void setUpdateCount(int n) {
            this.updateCount = n;
        }

        public String writeSummary() {
            NumberFormat numberFormat = NumberFormat.getIntegerInstance();
            ResourceMap resourceMap = ImmoToolUtils.getResourceMap(AgencyImportTask.class);
            String string = resourceMap.getString("summary.title", new Object[0]);
            string = string + "<ul style=\"margin-left:15px;\">";
            string = string + "<li>" + resourceMap.getString("summary.total", new Object[]{numberFormat.format(this.totalCount)}) + "</li>";
            string = string + "<li>" + resourceMap.getString("summary.updates", new Object[]{numberFormat.format(this.updateCount)}) + "</li>";
            if (this.ignoreCount > 0) {
                string = string + "<li>" + resourceMap.getString("summary.ignores", new Object[]{numberFormat.format(this.ignoreCount)}) + "</li>";
            }
            string = string + "<li>" + resourceMap.getString("summary.explicitDeletes", new Object[]{numberFormat.format(this.deleteExplicitCount)}) + "</li>";
            if (this.errorCount > 0) {
                string = string + "<li>" + resourceMap.getString("summary.errors", new Object[]{numberFormat.format(this.errorCount)}) + "</li>";
            }
            if (this.deleteUnmodifiedCount > 0) {
                string = string + "<li>" + resourceMap.getString("summary.unmodifiedDeletes", new Object[]{numberFormat.format(this.deleteUnmodifiedCount)}) + "</li>";
            }
            string = string + "</ul>";
            return "<html>" + string + "</html>";
        }
    }
}

