/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency;

import com.openindex.openestate.impl.SerializableXmlElement;
import com.openindex.openestate.impl.TransferImpl;
import com.openindex.openestate.impl.xml.IS24XmlUtils;
import com.openindex.openestate.impl.xml.ImmoXmlUtils;
import com.openindex.openestate.impl.xml.OpenImmoUtils;
import com.openindex.openestate.impl.xml.immoxml.Immoxml;
import com.openindex.openestate.impl.xml.is24.ImmobilienTransferTyp;
import com.openindex.openestate.impl.xml.openimmo.Openimmo;
import com.openindex.openestate.tool.ImmoToolApp;
import com.openindex.openestate.tool.ImmoToolTask;
import com.openindex.openestate.tool.ImmoToolTaskDialog;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.agency.AgencyImportDialog;
import com.openindex.openestate.tool.agency.AgencyImportTask;
import com.openindex.openestate.tool.agency.export.IS24CsvExport;
import com.openindex.openestate.tool.agency.export.IS24XmlExport;
import com.openindex.openestate.tool.agency.export.ImmoXmlExport;
import com.openindex.openestate.tool.agency.export.OpenImmoXmlExport;
import com.openindex.openestate.tool.agency.utils.IS24CsvReader;
import com.openindex.openestate.tool.agency.utils.IS24XmlReader;
import com.openindex.openestate.tool.agency.utils.ImmoXmlReader;
import com.openindex.openestate.tool.agency.utils.OpenImmoReader;
import com.openindex.openestate.tool.utils.SimpleFtpd;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.net.ServerSocket;
import java.net.Socket;
import java.text.DecimalFormat;
import javax.swing.ActionMap;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.NumberFormatter;
import javax.xml.bind.JAXBElement;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.SystemUtils;
import org.apache.log4j.Logger;
import org.fife.ui.rtextarea.RTextArea;
import org.jdesktop.application.Action;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.application.Task;
import org.jdesktop.swingx.JXBusyLabel;
import org.jdesktop.swingx.JXPanel;
import org.jdesktop.swingx.JXTitledSeparator;

public class AgencyImportViaLocalFtpDialog
extends JDialog {
    private static final Logger LOGGER = Logger.getLogger(AgencyImportViaLocalFtpDialog.class);
    public static final int OPENED = 0;
    public static final int CANCELLED = 1;
    public static final int APPROVED = 2;
    public static final int OPENIMMO = 0;
    public static final int IMMOXML = 1;
    public static final int IS24_CSV = 2;
    public static final int IS24_XML = 3;
    private int status = 0;
    private ActionMap actionMap = null;
    private ResourceMap resourceMap = null;
    private ImmoToolTask ftpTask = null;
    private File ftpDir = null;
    private JComboBox formatBox;
    private JLabel formatLabel;
    private JXBusyLabel ftpBusyLabel;
    private JTextArea ftpLogArea;
    private JXTitledSeparator ftpLogLabel;
    private JScrollPane ftpLogScroller;
    private JXTitledSeparator ftpServerLabel;
    private JButton ftpStartButton;
    private JButton ftpStopButton;
    private JButton helpButton;
    private JButton importCancelButton;
    private JButton importStartButton;
    private JLabel infoLabel;
    private JFormattedTextField portNrField;
    private JLabel portNrLabel;
    private JXTitledSeparator titleLabel;

    public AgencyImportViaLocalFtpDialog() throws Exception {
        this((Frame)ImmoToolApp.getApplication().getMainFrame(), true);
    }

    public AgencyImportViaLocalFtpDialog(Frame frame, boolean bl) throws Exception {
        super(frame, bl);
        this.build();
    }

    private void build() throws Exception {
        this.actionMap = ImmoToolUtils.getActionMap(AgencyImportViaLocalFtpDialog.class, (Object)this);
        this.resourceMap = ImmoToolUtils.getResourceMap(AgencyImportViaLocalFtpDialog.class);
        this.setContentPane((Container)new JXPanel());
        this.initComponents();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                AgencyImportViaLocalFtpDialog.this.doImportCancel();
            }
        });
        this.ftpBusyLabel.setText(this.resourceMap.getString("message.ftpServerIsInactive", new Object[0]));
        this.ftpDir = new File(ImmoToolApp.getApplication().getProject().getTempDirectory().getAbsolutePath() + File.separator + "ftp");
        if (this.ftpDir.exists()) {
            FileUtils.deleteQuietly((File)this.ftpDir);
        }
        if (!this.ftpDir.exists() && !this.ftpDir.mkdirs()) {
            throw new Exception(this.resourceMap.getString("error.cantCreateFtpDirectory", new Object[0]));
        }
        this.formatBox.addItem(new OpenImmoXmlExport().getTitle());
        this.formatBox.addItem(new ImmoXmlExport().getTitle());
        this.formatBox.addItem(new IS24CsvExport().getTitle());
        this.formatBox.addItem(new IS24XmlExport().getTitle());
        this.formatBox.setSelectedIndex(0);
        this.ftpStartButton.setAction(this.actionMap.get(this.ftpStartButton.getText()));
        this.ftpStopButton.setAction(this.actionMap.get(this.ftpStopButton.getText()));
        this.ftpStopButton.setEnabled(false);
        this.helpButton.setAction(this.actionMap.get(this.helpButton.getText()));
        this.importStartButton.setAction(this.actionMap.get(this.importStartButton.getText()));
        this.importCancelButton.setAction(this.actionMap.get(this.importCancelButton.getText()));
        this.resourceMap.injectComponents((Component)this);
        ImmoToolUtils.configureDialog((JDialog)this, (JXPanel)((JXPanel)this.getContentPane()));
        if (SystemUtils.IS_OS_MAC_OSX) {
            this.ftpStartButton.setOpaque(false);
            this.ftpStopButton.setOpaque(false);
            this.helpButton.setOpaque(false);
            this.importStartButton.setOpaque(false);
            this.importCancelButton.setOpaque(false);
        }
    }

    @Action
    public void doFtpStart() {
        boolean bl;
        final long l = Long.valueOf(this.portNrField.getValue().toString());
        if (l < 1L || l > 65535L) {
            ImmoToolUtils.showMessageErrorDialog((String)this.resourceMap.getString("error.invalidPortNr", new Object[0]));
            return;
        }
        if (l < 1000L && !(bl = ImmoToolUtils.showQuestionDialog((String)this.resourceMap.getString("question.useLowPortNr", new Object[0])))) {
            return;
        }
        this.ftpTask = new ImmoToolTask<Boolean>(){
            private ServerSocket ftpSocket = null;
            private int fileCountBeforeStart = -1;

            protected Boolean executeTask() throws Exception {
                this.fileCountBeforeStart = AgencyImportViaLocalFtpDialog.this.ftpDir.listFiles().length;
                int n = 0;
                this.setMessage(AgencyImportViaLocalFtpDialog.this.resourceMap.getString("message.doStartFtpServer", new Object[0]));
                this.ftpSocket = new ServerSocket((int)l);
                this.setMessage("> " + AgencyImportViaLocalFtpDialog.this.resourceMap.getString("message.doWaitForConnection", new Object[]{l}));
                while (true) {
                    Socket socket = this.ftpSocket.accept();
                    this.setMessage(AgencyImportViaLocalFtpDialog.this.resourceMap.getString("message.incomingConnection", new Object[]{n + 1}));
                    this.setMessage("> " + AgencyImportViaLocalFtpDialog.this.resourceMap.getString("message.incomingConnection.by", new Object[]{socket.getInetAddress().toString()}));
                    new SimpleFtpd(AgencyImportViaLocalFtpDialog.this.ftpDir, socket, n).start();
                    ++n;
                }
            }

            protected void failed(Throwable throwable) {
                super.failed(throwable);
                ImmoToolUtils.showMessageErrorDialog((String)AgencyImportViaLocalFtpDialog.this.resourceMap.getString("error.cantRunFtpServer", new Object[0]), (Throwable)throwable);
            }

            protected void finished() {
                super.finished();
                this.setMessage(AgencyImportViaLocalFtpDialog.this.resourceMap.getString("message.doStopFtpServer", new Object[0]));
                try {
                    if (this.ftpSocket != null && !this.ftpSocket.isClosed()) {
                        this.setMessage("> " + AgencyImportViaLocalFtpDialog.this.resourceMap.getString("message.doStopFtpServer.closeSocket", new Object[0]));
                        this.ftpSocket.close();
                    }
                }
                catch (Exception exception) {
                    LOGGER.warn((Object)"could not ftp-close socket!");
                    LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
                    this.setMessage("> " + AgencyImportViaLocalFtpDialog.this.resourceMap.getString("error.cantCloseFtpServer", new Object[]{exception.getLocalizedMessage()}));
                }
                AgencyImportViaLocalFtpDialog.this.ftpBusyLabel.setEnabled(false);
                AgencyImportViaLocalFtpDialog.this.ftpBusyLabel.setBusy(false);
                AgencyImportViaLocalFtpDialog.this.ftpBusyLabel.setText(AgencyImportViaLocalFtpDialog.this.resourceMap.getString("message.ftpServerIsInactive", new Object[0]));
                AgencyImportViaLocalFtpDialog.this.ftpStartButton.setEnabled(true);
                AgencyImportViaLocalFtpDialog.this.ftpStopButton.setEnabled(false);
                AgencyImportViaLocalFtpDialog.this.importStartButton.setEnabled(true);
                AgencyImportViaLocalFtpDialog.this.importCancelButton.setEnabled(true);
                AgencyImportViaLocalFtpDialog.this.ftpTask = null;
                int n = AgencyImportViaLocalFtpDialog.this.ftpDir.listFiles().length;
                int n2 = n - this.fileCountBeforeStart;
                if (n2 <= 0) {
                    ImmoToolUtils.showMessageInfoDialog((String)AgencyImportViaLocalFtpDialog.this.resourceMap.getString("message.noFilesReceived", new Object[0]));
                    return;
                }
                boolean bl = ImmoToolUtils.showQuestionDialog((String)AgencyImportViaLocalFtpDialog.this.resourceMap.getString("question.importReceivedFiles", new Object[]{AgencyImportViaLocalFtpDialog.this.ftpDir.listFiles().length}));
                if (bl) {
                    AgencyImportViaLocalFtpDialog.this.doImportStart();
                }
            }

            protected void setMessage(String string) {
                super.setMessage(string);
                AgencyImportViaLocalFtpDialog.this.ftpLogArea.append(string);
                AgencyImportViaLocalFtpDialog.this.ftpLogArea.append(SystemUtils.LINE_SEPARATOR);
            }
        };
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (AgencyImportViaLocalFtpDialog.this.ftpTask != null) {
                    AgencyImportViaLocalFtpDialog.this.ftpBusyLabel.setBusy(true);
                    AgencyImportViaLocalFtpDialog.this.ftpBusyLabel.setEnabled(true);
                    AgencyImportViaLocalFtpDialog.this.ftpBusyLabel.setText(AgencyImportViaLocalFtpDialog.this.resourceMap.getString("message.ftpServerIsBusy", new Object[0]));
                    AgencyImportViaLocalFtpDialog.this.ftpStartButton.setEnabled(false);
                    AgencyImportViaLocalFtpDialog.this.ftpStopButton.setEnabled(true);
                    AgencyImportViaLocalFtpDialog.this.ftpLogArea.setText("");
                    AgencyImportViaLocalFtpDialog.this.importStartButton.setEnabled(false);
                    AgencyImportViaLocalFtpDialog.this.importCancelButton.setEnabled(false);
                    ImmoToolUtils.executeTask((Task)AgencyImportViaLocalFtpDialog.this.ftpTask);
                }
            }
        });
    }

    @Action
    public void doFtpStop() {
        if (this.ftpTask != null) {
            this.ftpTask.cancel(true);
        }
    }

    @Action
    public void doImportCancel() {
        if (this.ftpDir.listFiles().length > 0 && !ImmoToolUtils.showQuestionDialog((String)this.resourceMap.getString("question.quitAndIgnoreReceivedFiles", new Object[0]))) {
            return;
        }
        FileUtils.deleteQuietly((File)this.ftpDir);
        this.status = 1;
        this.setVisible(false);
    }

    @Action
    public void doImportStart() {
        if (this.ftpDir.listFiles().length <= 0) {
            ImmoToolUtils.showMessageErrorDialog((String)this.resourceMap.getString("error.noFilesTransferred", new Object[0]));
            return;
        }
        int n = 0;
        final ImmoToolTaskDialog immoToolTaskDialog = new ImmoToolTaskDialog();
        for (File file : this.ftpDir.listFiles()) {
            if (!file.isFile() || !file.getName().toLowerCase().endsWith(".zip") && !file.getName().toLowerCase().endsWith(".xml") && !file.getName().toLowerCase().endsWith(".csv") && !file.getName().toLowerCase().endsWith(".txt")) continue;
            ++n;
            immoToolTaskDialog.addTask((ImmoToolTask)new AgencyImportTask(file){
                {
                    super(file);
                    this.setTitle("Importing file...");
                }

                protected AgencyImportTask.ImportResult executeTask() throws Exception {
                    TransferImpl transferImpl = null;
                    AgencyImportDialog agencyImportDialog = null;
                    if (AgencyImportViaLocalFtpDialog.this.formatBox.getSelectedIndex() == 0) {
                        this.setMessage(AgencyImportViaLocalFtpDialog.this.resourceMap.getString("message.doLoadFile", new Object[]{AgencyImportViaLocalFtpDialog.this.formatBox.getSelectedItem().toString()}) + ": " + this.getImportFile().getPath());
                        Openimmo openimmo = (Openimmo)OpenImmoUtils.unmarshallWithoutNamespace((File)this.getImportFile());
                        agencyImportDialog = this.showImportDialog((Window)immoToolTaskDialog, 1);
                        if (agencyImportDialog == null) {
                            return null;
                        }
                        this.logDialogSettings(agencyImportDialog);
                        this.setMessage(AgencyImportViaLocalFtpDialog.this.resourceMap.getString("message.doConvertFile", new Object[0]));
                        transferImpl = new OpenImmoReader(agencyImportDialog).readTransfer(openimmo);
                    } else if (AgencyImportViaLocalFtpDialog.this.formatBox.getSelectedIndex() == 1) {
                        this.setMessage(AgencyImportViaLocalFtpDialog.this.resourceMap.getString("message.doLoadFile", new Object[]{AgencyImportViaLocalFtpDialog.this.formatBox.getSelectedItem().toString()}) + ": " + this.getImportFile().getPath());
                        Immoxml immoxml = (Immoxml)ImmoXmlUtils.createUnmarshaller().unmarshal(this.getImportFile());
                        agencyImportDialog = this.showImportDialog((Window)immoToolTaskDialog, 2);
                        if (agencyImportDialog == null) {
                            return null;
                        }
                        this.logDialogSettings(agencyImportDialog);
                        this.setMessage(AgencyImportViaLocalFtpDialog.this.resourceMap.getString("message.doConvertFile", new Object[0]));
                        transferImpl = new ImmoXmlReader(agencyImportDialog).readTransfer(immoxml);
                    } else if (AgencyImportViaLocalFtpDialog.this.formatBox.getSelectedIndex() == 2) {
                        this.setMessage(AgencyImportViaLocalFtpDialog.this.resourceMap.getString("message.doLoadFile", new Object[]{AgencyImportViaLocalFtpDialog.this.formatBox.getSelectedItem().toString()}) + ": " + this.getImportFile().getPath());
                        agencyImportDialog = this.showImportDialog((Window)immoToolTaskDialog, 4);
                        if (agencyImportDialog == null) {
                            return null;
                        }
                        this.logDialogSettings(agencyImportDialog);
                        this.setMessage(AgencyImportViaLocalFtpDialog.this.resourceMap.getString("message.doConvertFile", new Object[0]));
                        transferImpl = new TransferImpl();
                        new IS24CsvReader(agencyImportDialog).read(this.getImportFile(), (SerializableXmlElement)transferImpl);
                    } else if (AgencyImportViaLocalFtpDialog.this.formatBox.getSelectedIndex() == 3) {
                        this.setMessage(AgencyImportViaLocalFtpDialog.this.resourceMap.getString("message.doLoadFile", new Object[]{AgencyImportViaLocalFtpDialog.this.formatBox.getSelectedItem().toString()}) + ": " + this.getImportFile().getPath());
                        JAXBElement jAXBElement = (JAXBElement)IS24XmlUtils.createUnmarshaller().unmarshal(this.getImportFile());
                        ImmobilienTransferTyp immobilienTransferTyp = (ImmobilienTransferTyp)jAXBElement.getValue();
                        agencyImportDialog = this.showImportDialog((Window)immoToolTaskDialog, 3);
                        this.logDialogSettings(agencyImportDialog);
                        this.setMessage(AgencyImportViaLocalFtpDialog.this.resourceMap.getString("message.doConvertFile", new Object[0]));
                        transferImpl = new IS24XmlReader(agencyImportDialog).readTransfer(immobilienTransferTyp);
                    } else {
                        throw new Exception(AgencyImportViaLocalFtpDialog.this.resourceMap.getString("error.invalidExportFormat", new Object[0]));
                    }
                    if (transferImpl == null) {
                        throw new Exception(AgencyImportViaLocalFtpDialog.this.resourceMap.getString("error.cantReadImportFile", new Object[0]));
                    }
                    this.setMessage(AgencyImportViaLocalFtpDialog.this.resourceMap.getString("message.doStartImport", new Object[0]));
                    return this.importTransfer(transferImpl, agencyImportDialog.getSelectedStatus(), agencyImportDialog.getSelectedDeleteMethod(), agencyImportDialog.isIgnoreUpdateSelected());
                }

                protected void failed(Throwable throwable) {
                    super.failed(throwable);
                    ImmoToolUtils.showMessageErrorDialog((String)AgencyImportViaLocalFtpDialog.this.resourceMap.getString("error.cantExecuteImport", new Object[0]), (Throwable)throwable);
                }

                protected void succeeded(AgencyImportTask.ImportResult importResult) {
                    super.succeeded((Object)importResult);
                    if (importResult == null || importResult.getTotalCount() <= 0) {
                        ImmoToolUtils.showMessageInfoDialog((String)AgencyImportViaLocalFtpDialog.this.resourceMap.getString("message.nothingImported", new Object[0]));
                    } else {
                        ImmoToolUtils.showMessageInfoDialog((String)importResult.writeSummary());
                    }
                }
            });
        }
        if (n <= 0) {
            ImmoToolUtils.showMessageErrorDialog((String)this.resourceMap.getString("error.noFilesToImport", new Object[0]));
            return;
        }
        this.status = 2;
        this.setVisible(false);
        immoToolTaskDialog.execute();
    }

    @Action
    public void doShowHelp() {
        ImmoToolUtils.showHelpDialog((String)"agency.import.ftp", (boolean)true);
    }

    public int getStatus() {
        return this.status;
    }

    private void initComponents() {
        this.titleLabel = ImmoToolUtils.createHead1Separator((String)"");
        this.infoLabel = new JLabel();
        this.ftpServerLabel = ImmoToolUtils.createHead2Separator((String)"");
        this.formatLabel = new JLabel();
        this.formatBox = new JComboBox();
        this.portNrLabel = new JLabel();
        this.portNrField = new JFormattedTextField();
        this.ftpStartButton = new JButton();
        this.ftpStopButton = new JButton();
        this.ftpLogLabel = ImmoToolUtils.createHead2Separator((String)"");
        this.ftpBusyLabel = new JXBusyLabel();
        this.ftpLogScroller = new JScrollPane();
        this.ftpLogArea = new RTextArea();
        this.helpButton = new JButton();
        this.importStartButton = new JButton();
        this.importCancelButton = new JButton();
        this.setDefaultCloseOperation(0);
        this.setName("Form");
        this.titleLabel.setName("titleLabel");
        this.titleLabel.setTitle("titleLabel");
        this.infoLabel.setText("infoLabel");
        this.infoLabel.setIconTextGap(10);
        this.infoLabel.setName("infoLabel");
        this.ftpServerLabel.setName("ftpServerLabel");
        this.ftpServerLabel.setTitle("ftpServerLabel");
        this.formatLabel.setText("formatLabel");
        this.formatLabel.setName("formatLabel");
        this.formatBox.setName("formatBox");
        this.portNrLabel.setText("portNrLabel");
        this.portNrLabel.setName("portNrLabel");
        this.portNrField.setFormatterFactory(new DefaultFormatterFactory(new NumberFormatter(new DecimalFormat("#0"))));
        this.portNrField.setName("portNrField");
        this.portNrField.setValue(2121L);
        this.ftpStartButton.setText("doFtpStart");
        this.ftpStartButton.setName("ftpStartButton");
        this.ftpStopButton.setText("doFtpStop");
        this.ftpStopButton.setName("ftpStopButton");
        this.ftpLogLabel.setName("ftpLogLabel");
        this.ftpLogLabel.setTitle("ftpLogLabel");
        this.ftpBusyLabel.setText("ftpBusyLabel");
        this.ftpBusyLabel.setEnabled(false);
        this.ftpBusyLabel.setIconTextGap(10);
        this.ftpBusyLabel.setName("ftpBusyLabel");
        this.ftpLogScroller.setName("ftpLogScroller");
        this.ftpLogArea.setColumns(20);
        this.ftpLogArea.setEditable(false);
        this.ftpLogArea.setRows(5);
        this.ftpLogArea.setName("ftpLogArea");
        this.ftpLogScroller.setViewportView(this.ftpLogArea);
        this.helpButton.setText("doShowHelp");
        this.helpButton.setName("helpButton");
        this.importStartButton.setText("doImportStart");
        this.importStartButton.setName("importStartButton");
        this.importCancelButton.setText("doImportCancel");
        this.importCancelButton.setName("importCancelButton");
        GroupLayout groupLayout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.infoLabel, GroupLayout.Alignment.LEADING, -1, 794, Short.MAX_VALUE).addComponent(this.ftpLogScroller, -1, 794, Short.MAX_VALUE).addGroup(groupLayout.createSequentialGroup().addComponent(this.formatLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.formatBox, 0, 291, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.portNrLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.portNrField, -2, 65, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.ftpStartButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.ftpStopButton)).addComponent((Component)this.titleLabel, GroupLayout.Alignment.LEADING, -1, 794, Short.MAX_VALUE).addComponent((Component)this.ftpServerLabel, GroupLayout.Alignment.LEADING, -1, 794, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.LEADING, groupLayout.createSequentialGroup().addComponent(this.helpButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 386, Short.MAX_VALUE).addComponent(this.importStartButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.importCancelButton)).addComponent((Component)this.ftpLogLabel, GroupLayout.Alignment.LEADING, -1, 794, Short.MAX_VALUE).addComponent((Component)this.ftpBusyLabel, GroupLayout.Alignment.LEADING, -1, 794, Short.MAX_VALUE)).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent((Component)this.titleLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.infoLabel).addGap(12, 12, 12).addComponent((Component)this.ftpServerLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.portNrField, -2, -1, -2).addComponent(this.ftpStopButton).addComponent(this.ftpStartButton).addComponent(this.portNrLabel).addComponent(this.formatLabel).addComponent(this.formatBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent((Component)this.ftpLogLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.ftpBusyLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.ftpLogScroller, -1, 298, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.helpButton).addComponent(this.importCancelButton).addComponent(this.importStartButton)).addContainerGap()));
        this.pack();
    }
}

