/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency;

import com.openindex.openestate.impl.AgencyImpl;
import com.openindex.openestate.impl.EstateAttachmentImpl;
import com.openindex.openestate.impl.OpenEstateType;
import com.openindex.openestate.impl.OpenEstateUtils;
import com.openindex.openestate.impl.SerializableXmlElement;
import com.openindex.openestate.impl.TransferImpl;
import com.openindex.openestate.impl.csv.idx.IDXCSVSchema;
import com.openindex.openestate.impl.xml.IS24XmlUtils;
import com.openindex.openestate.impl.xml.ImmoXmlUtils;
import com.openindex.openestate.impl.xml.ImmobiliareUtils;
import com.openindex.openestate.impl.xml.KyeroUtils;
import com.openindex.openestate.impl.xml.OpenImmoUtils;
import com.openindex.openestate.impl.xml.immobiliare.Feed;
import com.openindex.openestate.impl.xml.immoxml.Immoxml;
import com.openindex.openestate.impl.xml.is24.ImmobilienTransferTyp;
import com.openindex.openestate.impl.xml.kyero.Root;
import com.openindex.openestate.impl.xml.openimmo.Openimmo;
import com.openindex.openestate.tool.ImmoToolApp;
import com.openindex.openestate.tool.ImmoToolDb;
import com.openindex.openestate.tool.ImmoToolDbException;
import com.openindex.openestate.tool.ImmoToolDbUtils;
import com.openindex.openestate.tool.ImmoToolException;
import com.openindex.openestate.tool.ImmoToolPlugin;
import com.openindex.openestate.tool.ImmoToolProject;
import com.openindex.openestate.tool.ImmoToolSetupPanel;
import com.openindex.openestate.tool.ImmoToolTask;
import com.openindex.openestate.tool.ImmoToolTaskDialog;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.agency.AgencyAgent;
import com.openindex.openestate.tool.agency.AgencyContact;
import com.openindex.openestate.tool.agency.AgencyContactTablePanel;
import com.openindex.openestate.tool.agency.AgencyEstate;
import com.openindex.openestate.tool.agency.AgencyEstateExportCsvTask;
import com.openindex.openestate.tool.agency.AgencyEstateExportDialog;
import com.openindex.openestate.tool.agency.AgencyEstateExportFields;
import com.openindex.openestate.tool.agency.AgencyEstateExportXlsTask;
import com.openindex.openestate.tool.agency.AgencyEstateTablePanel;
import com.openindex.openestate.tool.agency.AgencyExportInterface;
import com.openindex.openestate.tool.agency.AgencyExportList;
import com.openindex.openestate.tool.agency.AgencyExportPanel;
import com.openindex.openestate.tool.agency.AgencyExportSummary;
import com.openindex.openestate.tool.agency.AgencyImportDialog;
import com.openindex.openestate.tool.agency.AgencyImportTask;
import com.openindex.openestate.tool.agency.AgencyImportViaLocalFtpDialog;
import com.openindex.openestate.tool.agency.AgencyPluginUtils;
import com.openindex.openestate.tool.agency.AgencyProfilePanel;
import com.openindex.openestate.tool.agency.AgencySetupGeneralPanel;
import com.openindex.openestate.tool.agency.AgencySetupGeoPanel;
import com.openindex.openestate.tool.agency.AgencySetupLanguagePanel;
import com.openindex.openestate.tool.agency.utils.GeoDb;
import com.openindex.openestate.tool.agency.utils.IDXCsvReader;
import com.openindex.openestate.tool.agency.utils.IS24CsvReader;
import com.openindex.openestate.tool.agency.utils.IS24XmlReader;
import com.openindex.openestate.tool.agency.utils.ImmoXmlReader;
import com.openindex.openestate.tool.agency.utils.ImmobiliareReader;
import com.openindex.openestate.tool.agency.utils.KyeroReader;
import com.openindex.openestate.tool.agency.utils.OpenImmoReader;
import com.openindex.openestate.tool.agency.utils.PdfSetup;
import com.openindex.openestate.tool.utils.JOptionFileChooser;
import com.openindex.openestate.tool.utils.TabComponent;
import java.awt.Component;
import java.awt.Window;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import javax.help.HelpSet;
import javax.help.HelpSetException;
import javax.imageio.ImageIO;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.filechooser.FileFilter;
import javax.xml.bind.JAXBElement;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.SystemUtils;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.jdesktop.application.Action;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.application.Task;
import org.jdesktop.swingx.JXTaskPane;
import org.xmldb.api.base.Collection;
import org.xmldb.api.modules.XMLResource;

public final class AgencyPlugin
extends ImmoToolPlugin {
    private static final Logger LOGGER = Logger.getLogger(AgencyPlugin.class);
    public static final String PLUGIN_NAME = "OpenEstate-Agency";
    public static final String PLUGIN_URL = "http://media.openestate.org/Plugins/OpenEstate-Tool-Agency.xml";
    public static final String PLUGIN_DB_PATH = "ImmoTool/OpenEstate-Agency";
    public static final String PLUGIN_RES_PATH = "/com/openindex/openestate/tool/agency/resources/";
    public static final String DB_COLLECTION_CONTACTS = "/contacts";
    public static final String DB_COLLECTION_ESTATES = "/estates";
    public static final String DB_COLLECTION_ESTATE_FILES = "/estates/files";
    public static final String DB_COLLECTION_EXPORTS = "/exports";
    public static final String DB_COLLECTION_EXPORT_SUMMARIES = "/exports/summaries";
    public static final String DB_COLLECTION_PDF = "/pdf";
    public static final String DB_COLLECTION_GEO = "/geo";
    public static final String DB_RESOURCE_AGENT = "Agent.xml";
    public static final String DB_RESOURCE_AGENT_LOGO = "AgentLogo.png";
    public static final String DB_SEQUENCE_AGENT = "OpenEstate-Agency.Agent";
    public static final String DB_SEQUENCE_CONTACT = "OpenEstate-Agency.AgentContact";
    public static final String DB_SEQUENCE_ESTATE = "OpenEstate-Agency.Estate";
    public static final String DB_SEQUENCE_EXPORT_INTERFACE = "OpenEstate-Agency.ExportInterface";
    public static final String DB_SEQUENCE_EXPORT_SUMMARY = "OpenEstate-Agency.ExportSummary";
    public static final String DB_SEQUENCE_PDF_SETUP = "OpenEstate-Agency.PdfSetup";
    public static final String KEY_IMG_MAXHEIGHT = "Agency.Img.MaxHeight";
    public static final String KEY_IMG_MAXWIDTH = "Agency.Img.MaxWidth";
    public static final String KEY_IMG_DEFAULT_FORMAT = "Agency.Img.DefaultFormat";
    public static final String KEY_IMG_FORCE_FORMAT = "Agency.Img.ForceFormat";
    public static final String KEY_LOCALES = "Agency.Locales";
    public static final String KEY_LAST_IMPORT_LOCATION = "Agency.LastImportLocation";
    private static final String PRESERVE_ESTATE_ID = "agency.preserveEstateId";
    private static File lastImageLocation = null;
    private static File lastExportLocation = null;

    public HelpSet createHelpSet() throws HelpSetException {
        URL uRL = ((Object)((Object)this)).getClass().getResource("/com/openindex/openestate/tool/agency/resources/help/help.hs");
        return new HelpSet(null, uRL);
    }

    public JMenu createMenu() {
        JMenu jMenu = new JMenu(this.getResourceMap().getString("Title", new Object[0]));
        jMenu.add(new JMenuItem(this.getActionMap().get("doShowAgencyProfile")));
        jMenu.add(new JMenuItem(this.getActionMap().get("doShowAgencyEstates")));
        jMenu.add(new JMenuItem(this.getActionMap().get("doShowAgencyExport")));
        jMenu.add(new JMenuItem(this.getActionMap().get("doShowAgencyContacts")));
        jMenu.addSeparator();
        JMenu jMenu2 = new JMenu();
        jMenu2.setName("importMenu");
        this.getResourceMap().injectComponent((Component)jMenu2);
        jMenu2.add(new JMenuItem(this.getActionMap().get("doImportIDXCsv")));
        jMenu2.add(new JMenuItem(this.getActionMap().get("doImportImmobiliare")));
        jMenu2.add(new JMenuItem(this.getActionMap().get("doImportImmoXml")));
        jMenu2.add(new JMenuItem(this.getActionMap().get("doImportIS24Csv")));
        jMenu2.add(new JMenuItem(this.getActionMap().get("doImportIS24Xml")));
        jMenu2.add(new JMenuItem(this.getActionMap().get("doImportKyero")));
        jMenu2.add(new JMenuItem(this.getActionMap().get("doImportOpenEstateXml")));
        jMenu2.add(new JMenuItem(this.getActionMap().get("doImportOpenImmoXml")));
        jMenu2.addSeparator();
        jMenu2.add(new JMenuItem(this.getActionMap().get("doImportViaLocalFtp")));
        jMenu.add(jMenu2);
        jMenu.add(new JMenuItem(this.getActionMap().get("doTableExport")));
        return jMenu;
    }

    public List<ImmoToolSetupPanel> createSetupPanels() {
        List list = super.createSetupPanels();
        list.add(new AgencySetupGeneralPanel());
        list.add(new AgencySetupLanguagePanel());
        list.add(new AgencySetupGeoPanel());
        return list;
    }

    public JXTaskPane createTaskPane() {
        JXTaskPane jXTaskPane = new JXTaskPane();
        jXTaskPane.setTitle(this.getResourceMap().getString("Title", new Object[0]));
        jXTaskPane.add(this.getActionMap().get("doShowAgencyProfile"));
        jXTaskPane.add(this.getActionMap().get("doShowAgencyEstates"));
        jXTaskPane.add(this.getActionMap().get("doShowAgencyExport"));
        jXTaskPane.add(this.getActionMap().get("doShowAgencyContacts"));
        return jXTaskPane;
    }

    public void destroy() {
        GeoDb.clearCaches();
    }

    @Action
    public void doImportIDXCsv() {
        int n;
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setApproveButtonText(this.getResourceMap().getString("label.importFile", new Object[0]));
        jFileChooser.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory() || file.getName().toLowerCase().endsWith(".csv") || file.getName().toLowerCase().endsWith(".txt") || file.getName().toLowerCase().endsWith(".zip");
            }

            @Override
            public String getDescription() {
                return "IDX-CSV (*.txt, *.csv, *.zip)";
            }
        });
        File file = AgencyPlugin.getLastImportLocation();
        if (file != null) {
            jFileChooser.setSelectedFile(new File(file.getAbsolutePath() + File.separator + "."));
        }
        if ((n = jFileChooser.showOpenDialog(ImmoToolApp.getApplication().getMainFrame())) != 0) {
            return;
        }
        AgencyPlugin.setLastImportLocation(jFileChooser.getSelectedFile().getParentFile());
        final ResourceMap resourceMap = this.getResourceMap();
        ImmoToolTaskDialog.execute((ImmoToolTask)new AgencyImportTask(jFileChooser.getSelectedFile()){
            {
                super(file);
                this.setTitle("Import IDX-CSV...");
            }

            protected AgencyImportTask.ImportResult executeTask() throws Exception {
                this.setMessage(resourceMap.getString("message.doLoad", new Object[]{this.getImportFile().getPath()}));
                File file = this.openImportFile(new String[]{".txt", ".csv"});
                if (file == null) {
                    throw new Exception(resourceMap.getString("error.cantFindImportFile", new Object[0]));
                }
                AgencyImportDialog agencyImportDialog = this.showImportDialog((Window)this.getTaskDialog(), 5);
                if (agencyImportDialog == null) {
                    return null;
                }
                this.logDialogSettings(agencyImportDialog);
                this.setMessage(resourceMap.getString("message.doConvert", new Object[0]));
                TransferImpl transferImpl = new TransferImpl();
                new IDXCsvReader(agencyImportDialog).read(file, (SerializableXmlElement)transferImpl);
                this.setMessage(resourceMap.getString("message.doImport", new Object[0]));
                return this.importTransfer(transferImpl, agencyImportDialog.getSelectedStatus(), agencyImportDialog.getSelectedDeleteMethod(), agencyImportDialog.isIgnoreUpdateSelected());
            }

            protected void failed(Throwable throwable) {
                super.failed(throwable);
                ImmoToolUtils.showMessageErrorDialog((String)resourceMap.getString("error.importFailed", new Object[0]), (Throwable)throwable);
            }

            @Override
            protected File lookupAttachmentFile(EstateAttachmentImpl estateAttachmentImpl, File file) {
                try {
                    String string = estateAttachmentImpl.getFileAsName();
                    File file2 = new File(file.getAbsolutePath() + File.separator + string);
                    if (file2.isFile()) {
                        return file2;
                    }
                    String string2 = null;
                    if (IDXCSVSchema.isDocument((String)string)) {
                        string2 = "doc";
                    } else if (IDXCSVSchema.isImage((String)string)) {
                        string2 = "images";
                    } else if (IDXCSVSchema.isMovie((String)string)) {
                        string2 = "movies";
                    } else {
                        return null;
                    }
                    file2 = new File(file.getAbsolutePath() + File.separator + string2 + File.separator + string);
                    if (file2.isFile()) {
                        return file2;
                    }
                    file2 = new File(file.getParentFile().getAbsolutePath() + File.separator + string2 + File.separator + string);
                    if (file2.isFile()) {
                        return file2;
                    }
                    return null;
                }
                catch (Exception exception) {
                    LOGGER.warn((Object)"Can't lookup attached file!");
                    LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
                    return null;
                }
            }

            protected void succeeded(AgencyImportTask.ImportResult importResult) {
                super.succeeded((Object)importResult);
                this.getTaskDialog().setAutoCloseSelected(false);
                ImmoToolUtils.showMessageInfoDialog((String)(importResult == null || importResult.getTotalCount() < 1 ? resourceMap.getString("message.nothingImported", new Object[0]) : importResult.writeSummary()), (Component)this.getTaskDialog());
            }
        });
    }

    @Action
    public void doImportImmobiliare() {
        int n;
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setApproveButtonText(this.getResourceMap().getString("label.importFile", new Object[0]));
        jFileChooser.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory() || file.getName().toLowerCase().endsWith(".xml") || file.getName().toLowerCase().endsWith(".zip");
            }

            @Override
            public String getDescription() {
                return "Immobiliare-XML (*.xml, *.zip)";
            }
        });
        File file = AgencyPlugin.getLastImportLocation();
        if (file != null) {
            jFileChooser.setSelectedFile(new File(file.getAbsolutePath() + File.separator + "."));
        }
        if ((n = jFileChooser.showOpenDialog(ImmoToolApp.getApplication().getMainFrame())) != 0) {
            return;
        }
        AgencyPlugin.setLastImportLocation(jFileChooser.getSelectedFile().getParentFile());
        final ResourceMap resourceMap = this.getResourceMap();
        ImmoToolTaskDialog.execute((ImmoToolTask)new AgencyImportTask(jFileChooser.getSelectedFile()){
            {
                super(file);
                this.setTitle("Import Immobiliare-XML...");
            }

            protected AgencyImportTask.ImportResult executeTask() throws Exception {
                this.setMessage(resourceMap.getString("message.doLoad", new Object[]{this.getImportFile().getPath()}));
                File file = this.openImportFile(new String[]{".xml"});
                if (file == null) {
                    throw new Exception(resourceMap.getString("error.cantFindImportFile", new Object[0]));
                }
                Feed feed = (Feed)ImmobiliareUtils.createUnmarshaller().unmarshal(file);
                AgencyImportDialog agencyImportDialog = this.showImportDialog((Window)this.getTaskDialog(), 2);
                if (agencyImportDialog == null) {
                    return null;
                }
                this.logDialogSettings(agencyImportDialog);
                this.setMessage(resourceMap.getString("message.doConvert", new Object[0]));
                TransferImpl transferImpl = new ImmobiliareReader(agencyImportDialog).readTransfer(feed);
                this.setMessage(resourceMap.getString("message.doImport", new Object[0]));
                return this.importTransfer(transferImpl, agencyImportDialog.getSelectedStatus(), agencyImportDialog.getSelectedDeleteMethod(), agencyImportDialog.isIgnoreUpdateSelected());
            }

            protected void failed(Throwable throwable) {
                super.failed(throwable);
                ImmoToolUtils.showMessageErrorDialog((String)resourceMap.getString("error.importFailed", new Object[0]), (Throwable)throwable);
            }

            protected void succeeded(AgencyImportTask.ImportResult importResult) {
                super.succeeded((Object)importResult);
                this.getTaskDialog().setAutoCloseSelected(false);
                ImmoToolUtils.showMessageInfoDialog((String)(importResult == null || importResult.getTotalCount() < 1 ? resourceMap.getString("message.nothingImported", new Object[0]) : importResult.writeSummary()), (Component)this.getTaskDialog());
            }
        });
    }

    @Action
    public void doImportImmoXml() {
        int n;
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setApproveButtonText(this.getResourceMap().getString("label.importFile", new Object[0]));
        jFileChooser.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory() || file.getName().toLowerCase().endsWith(".xml") || file.getName().toLowerCase().endsWith(".zip");
            }

            @Override
            public String getDescription() {
                return "ImmoXML (*.xml, *.zip)";
            }
        });
        File file = AgencyPlugin.getLastImportLocation();
        if (file != null) {
            jFileChooser.setSelectedFile(new File(file.getAbsolutePath() + File.separator + "."));
        }
        if ((n = jFileChooser.showOpenDialog(ImmoToolApp.getApplication().getMainFrame())) != 0) {
            return;
        }
        AgencyPlugin.setLastImportLocation(jFileChooser.getSelectedFile().getParentFile());
        final ResourceMap resourceMap = this.getResourceMap();
        ImmoToolTaskDialog.execute((ImmoToolTask)new AgencyImportTask(jFileChooser.getSelectedFile()){
            {
                super(file);
                this.setTitle("Import ImmoXML...");
            }

            protected AgencyImportTask.ImportResult executeTask() throws Exception {
                this.setMessage(resourceMap.getString("message.doLoad", new Object[]{this.getImportFile().getPath()}));
                File file = this.openImportFile(new String[]{".xml"});
                if (file == null) {
                    throw new Exception(resourceMap.getString("error.cantFindImportFile", new Object[0]));
                }
                Immoxml immoxml = (Immoxml)ImmoXmlUtils.createUnmarshaller().unmarshal(file);
                AgencyImportDialog agencyImportDialog = this.showImportDialog((Window)this.getTaskDialog(), 2);
                if (agencyImportDialog == null) {
                    return null;
                }
                this.logDialogSettings(agencyImportDialog);
                this.setMessage(resourceMap.getString("message.doConvert", new Object[0]));
                TransferImpl transferImpl = new ImmoXmlReader(agencyImportDialog).readTransfer(immoxml);
                this.setMessage(resourceMap.getString("message.doImport", new Object[0]));
                return this.importTransfer(transferImpl, agencyImportDialog.getSelectedStatus(), agencyImportDialog.getSelectedDeleteMethod(), agencyImportDialog.isIgnoreUpdateSelected());
            }

            protected void failed(Throwable throwable) {
                super.failed(throwable);
                ImmoToolUtils.showMessageErrorDialog((String)resourceMap.getString("error.importFailed", new Object[0]), (Throwable)throwable);
            }

            protected void succeeded(AgencyImportTask.ImportResult importResult) {
                super.succeeded((Object)importResult);
                this.getTaskDialog().setAutoCloseSelected(false);
                ImmoToolUtils.showMessageInfoDialog((String)(importResult == null || importResult.getTotalCount() < 1 ? resourceMap.getString("message.nothingImported", new Object[0]) : importResult.writeSummary()), (Component)this.getTaskDialog());
            }
        });
    }

    @Action
    public void doImportIS24Csv() {
        int n;
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setApproveButtonText(this.getResourceMap().getString("label.importFile", new Object[0]));
        jFileChooser.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory() || file.getName().toLowerCase().endsWith(".csv") || file.getName().toLowerCase().endsWith(".txt") || file.getName().toLowerCase().endsWith(".zip");
            }

            @Override
            public String getDescription() {
                return "IS24-CSV (*.txt, *.csv, *.zip)";
            }
        });
        File file = AgencyPlugin.getLastImportLocation();
        if (file != null) {
            jFileChooser.setSelectedFile(new File(file.getAbsolutePath() + File.separator + "."));
        }
        if ((n = jFileChooser.showOpenDialog(ImmoToolApp.getApplication().getMainFrame())) != 0) {
            return;
        }
        AgencyPlugin.setLastImportLocation(jFileChooser.getSelectedFile().getParentFile());
        final ResourceMap resourceMap = this.getResourceMap();
        ImmoToolTaskDialog.execute((ImmoToolTask)new AgencyImportTask(jFileChooser.getSelectedFile()){
            {
                super(file);
                this.setTitle("Import IS24-CSV...");
            }

            protected AgencyImportTask.ImportResult executeTask() throws Exception {
                this.setMessage(resourceMap.getString("message.doLoad", new Object[]{this.getImportFile().getPath()}));
                File file = this.openImportFile(new String[]{".txt", ".csv"});
                if (file == null) {
                    throw new Exception(resourceMap.getString("error.cantFindImportFile", new Object[0]));
                }
                AgencyImportDialog agencyImportDialog = this.showImportDialog((Window)this.getTaskDialog(), 4);
                if (agencyImportDialog == null) {
                    return null;
                }
                this.logDialogSettings(agencyImportDialog);
                this.setMessage(resourceMap.getString("message.doConvert", new Object[0]));
                TransferImpl transferImpl = new TransferImpl();
                new IS24CsvReader(agencyImportDialog).read(file, (SerializableXmlElement)transferImpl);
                this.setMessage(resourceMap.getString("message.doImport", new Object[0]));
                return this.importTransfer(transferImpl, agencyImportDialog.getSelectedStatus(), agencyImportDialog.getSelectedDeleteMethod(), agencyImportDialog.isIgnoreUpdateSelected());
            }

            protected void failed(Throwable throwable) {
                super.failed(throwable);
                ImmoToolUtils.showMessageErrorDialog((String)resourceMap.getString("error.importFailed", new Object[0]), (Throwable)throwable);
            }

            protected void succeeded(AgencyImportTask.ImportResult importResult) {
                super.succeeded((Object)importResult);
                this.getTaskDialog().setAutoCloseSelected(false);
                ImmoToolUtils.showMessageInfoDialog((String)(importResult == null || importResult.getTotalCount() < 1 ? resourceMap.getString("message.nothingImported", new Object[0]) : importResult.writeSummary()), (Component)this.getTaskDialog());
            }
        });
    }

    @Action
    public void doImportIS24Xml() {
        int n;
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setApproveButtonText(this.getResourceMap().getString("label.importFile", new Object[0]));
        jFileChooser.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory() || file.getName().toLowerCase().endsWith(".xml") || file.getName().toLowerCase().endsWith(".zip");
            }

            @Override
            public String getDescription() {
                return "IS24-XML (*.xml, *.zip)";
            }
        });
        File file = AgencyPlugin.getLastImportLocation();
        if (file != null) {
            jFileChooser.setSelectedFile(new File(file.getAbsolutePath() + File.separator + "."));
        }
        if ((n = jFileChooser.showOpenDialog(ImmoToolApp.getApplication().getMainFrame())) != 0) {
            return;
        }
        AgencyPlugin.setLastImportLocation(jFileChooser.getSelectedFile().getParentFile());
        final ResourceMap resourceMap = this.getResourceMap();
        ImmoToolTaskDialog.execute((ImmoToolTask)new AgencyImportTask(jFileChooser.getSelectedFile()){
            {
                super(file);
                this.setTitle("Import IS24-XML...");
            }

            protected AgencyImportTask.ImportResult executeTask() throws Exception {
                this.setMessage(resourceMap.getString("message.doLoad", new Object[]{this.getImportFile().getPath()}));
                File file = this.openImportFile(new String[]{".xml"});
                if (file == null) {
                    throw new Exception(resourceMap.getString("error.cantFindImportFile", new Object[0]));
                }
                JAXBElement jAXBElement = (JAXBElement)IS24XmlUtils.createUnmarshaller().unmarshal(file);
                AgencyImportDialog agencyImportDialog = this.showImportDialog((Window)this.getTaskDialog(), 3);
                if (agencyImportDialog == null) {
                    return null;
                }
                this.logDialogSettings(agencyImportDialog);
                this.setMessage(resourceMap.getString("message.doConvert", new Object[0]));
                TransferImpl transferImpl = new IS24XmlReader(agencyImportDialog).readTransfer((ImmobilienTransferTyp)jAXBElement.getValue());
                this.setMessage(resourceMap.getString("message.doImport", new Object[0]));
                return this.importTransfer(transferImpl, agencyImportDialog.getSelectedStatus(), agencyImportDialog.getSelectedDeleteMethod(), agencyImportDialog.isIgnoreUpdateSelected());
            }

            protected void failed(Throwable throwable) {
                super.failed(throwable);
                ImmoToolUtils.showMessageErrorDialog((String)resourceMap.getString("error.importFailed", new Object[0]), (Throwable)throwable);
            }

            protected void succeeded(AgencyImportTask.ImportResult importResult) {
                super.succeeded((Object)importResult);
                this.getTaskDialog().setAutoCloseSelected(false);
                ImmoToolUtils.showMessageInfoDialog((String)(importResult == null || importResult.getTotalCount() < 1 ? resourceMap.getString("message.nothingImported", new Object[0]) : importResult.writeSummary()), (Component)this.getTaskDialog());
            }
        });
    }

    @Action
    public void doImportKyero() {
        int n;
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setApproveButtonText(this.getResourceMap().getString("label.importFile", new Object[0]));
        jFileChooser.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory() || file.getName().toLowerCase().endsWith(".xml") || file.getName().toLowerCase().endsWith(".zip");
            }

            @Override
            public String getDescription() {
                return "Kyero-XML (*.xml, *.zip)";
            }
        });
        File file = AgencyPlugin.getLastImportLocation();
        if (file != null) {
            jFileChooser.setSelectedFile(new File(file.getAbsolutePath() + File.separator + "."));
        }
        if ((n = jFileChooser.showOpenDialog(ImmoToolApp.getApplication().getMainFrame())) != 0) {
            return;
        }
        AgencyPlugin.setLastImportLocation(jFileChooser.getSelectedFile().getParentFile());
        final ResourceMap resourceMap = this.getResourceMap();
        ImmoToolTaskDialog.execute((ImmoToolTask)new AgencyImportTask(jFileChooser.getSelectedFile()){
            {
                super(file);
                this.setTitle("Import Kyero-XML...");
            }

            protected AgencyImportTask.ImportResult executeTask() throws Exception {
                this.setMessage(resourceMap.getString("message.doLoad", new Object[]{this.getImportFile().getPath()}));
                File file = this.openImportFile(new String[]{".xml"});
                if (file == null) {
                    throw new Exception(resourceMap.getString("error.cantFindImportFile", new Object[0]));
                }
                Root root = (Root)KyeroUtils.createUnmarshaller().unmarshal(file);
                AgencyImportDialog agencyImportDialog = this.showImportDialog((Window)this.getTaskDialog(), 7);
                if (agencyImportDialog == null) {
                    return null;
                }
                this.logDialogSettings(agencyImportDialog);
                this.setMessage(resourceMap.getString("message.doConvert", new Object[0]));
                TransferImpl transferImpl = new KyeroReader(agencyImportDialog).readTransfer(root);
                this.setMessage(resourceMap.getString("message.doImport", new Object[0]));
                return this.importTransfer(transferImpl, agencyImportDialog.getSelectedStatus(), agencyImportDialog.getSelectedDeleteMethod(), agencyImportDialog.isIgnoreUpdateSelected());
            }

            protected void failed(Throwable throwable) {
                super.failed(throwable);
                ImmoToolUtils.showMessageErrorDialog((String)resourceMap.getString("error.importFailed", new Object[0]), (Throwable)throwable);
            }

            protected void succeeded(AgencyImportTask.ImportResult importResult) {
                super.succeeded((Object)importResult);
                this.getTaskDialog().setAutoCloseSelected(false);
                ImmoToolUtils.showMessageInfoDialog((String)(importResult == null || importResult.getTotalCount() < 1 ? resourceMap.getString("message.nothingImported", new Object[0]) : importResult.writeSummary()), (Component)this.getTaskDialog());
            }
        });
    }

    @Action
    public void doImportOpenEstateXml() {
        int n;
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setApproveButtonText(this.getResourceMap().getString("label.importFile", new Object[0]));
        jFileChooser.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory() || file.getName().toLowerCase().endsWith(".xml") || file.getName().toLowerCase().endsWith(".zip");
            }

            @Override
            public String getDescription() {
                return "OpenEstate-XML (*.xml, *.zip)";
            }
        });
        File file = AgencyPlugin.getLastImportLocation();
        if (file != null) {
            jFileChooser.setSelectedFile(new File(file.getAbsolutePath() + File.separator + "."));
        }
        if ((n = jFileChooser.showOpenDialog(ImmoToolApp.getApplication().getMainFrame())) != 0) {
            return;
        }
        AgencyPlugin.setLastImportLocation(jFileChooser.getSelectedFile().getParentFile());
        final ResourceMap resourceMap = this.getResourceMap();
        ImmoToolTaskDialog.execute((ImmoToolTask)new AgencyImportTask(jFileChooser.getSelectedFile()){
            {
                super(file);
                this.setTitle("Import OpenEstate-XML...");
            }

            protected AgencyImportTask.ImportResult executeTask() throws Exception {
                this.setMessage(resourceMap.getString("message.doLoad", new Object[]{this.getImportFile().getPath()}));
                Document document = this.openImportFileAsDocument();
                if (document == null) {
                    throw new Exception(resourceMap.getString("error.cantFindImportFile", new Object[0]));
                }
                String string = document.getRootElement().getName();
                if ("Agency".equals(string)) {
                    AgencyImportDialog agencyImportDialog = this.showImportDialog((Window)this.getTaskDialog(), 0);
                    if (agencyImportDialog == null) {
                        return null;
                    }
                    this.logDialogSettings(agencyImportDialog);
                    this.setMessage(resourceMap.getString("message.doConvert", new Object[0]) + " (agency)");
                    AgencyImpl agencyImpl = new AgencyImpl(document);
                    this.setMessage(resourceMap.getString("message.doImport", new Object[0]));
                    return this.importAgency(agencyImpl, agencyImportDialog.getSelectedStatus(), agencyImportDialog.getSelectedDeleteMethod(), agencyImportDialog.isIgnoreUpdateSelected());
                }
                if ("Transfer".equals(string)) {
                    AgencyImportDialog agencyImportDialog = this.showImportDialog((Window)this.getTaskDialog(), 0);
                    if (agencyImportDialog == null) {
                        return null;
                    }
                    this.logDialogSettings(agencyImportDialog);
                    this.setMessage(resourceMap.getString("message.doConvert", new Object[0]) + " (transfer)");
                    TransferImpl transferImpl = new TransferImpl(document);
                    this.setMessage(resourceMap.getString("message.doImport", new Object[0]));
                    return this.importTransfer(transferImpl, agencyImportDialog.getSelectedStatus(), agencyImportDialog.getSelectedDeleteMethod(), agencyImportDialog.isIgnoreUpdateSelected());
                }
                throw new Exception("unsupported xml-element on root: " + string);
            }

            protected void failed(Throwable throwable) {
                super.failed(throwable);
                ImmoToolUtils.showMessageErrorDialog((String)resourceMap.getString("error.importFailed", new Object[0]), (Throwable)throwable);
            }

            protected void succeeded(AgencyImportTask.ImportResult importResult) {
                super.succeeded((Object)importResult);
                this.getTaskDialog().setAutoCloseSelected(false);
                ImmoToolUtils.showMessageInfoDialog((String)(importResult == null || importResult.getTotalCount() < 1 ? resourceMap.getString("message.nothingImported", new Object[0]) : importResult.writeSummary()), (Component)this.getTaskDialog());
            }
        });
    }

    @Action
    public void doImportOpenImmoXml() {
        int n;
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setApproveButtonText(this.getResourceMap().getString("label.importFile", new Object[0]));
        jFileChooser.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory() || file.getName().toLowerCase().endsWith(".xml") || file.getName().toLowerCase().endsWith(".zip");
            }

            @Override
            public String getDescription() {
                return "OpenImmo-XML (*.xml, *.zip)";
            }
        });
        File file = AgencyPlugin.getLastImportLocation();
        if (file != null) {
            jFileChooser.setSelectedFile(new File(file.getAbsolutePath() + File.separator + "."));
        }
        if ((n = jFileChooser.showOpenDialog(ImmoToolApp.getApplication().getMainFrame())) != 0) {
            return;
        }
        AgencyPlugin.setLastImportLocation(jFileChooser.getSelectedFile().getParentFile());
        final ResourceMap resourceMap = this.getResourceMap();
        ImmoToolTaskDialog.execute((ImmoToolTask)new AgencyImportTask(jFileChooser.getSelectedFile()){
            {
                super(file);
                this.setTitle("Import OpenImmo-XML...");
            }

            protected AgencyImportTask.ImportResult executeTask() throws Exception {
                this.setMessage(resourceMap.getString("message.doLoad", new Object[]{this.getImportFile().getPath()}));
                File file = this.openImportFile(new String[]{".xml"});
                if (file == null) {
                    throw new Exception(resourceMap.getString("error.cantFindImportFile", new Object[0]));
                }
                Openimmo openimmo = (Openimmo)OpenImmoUtils.unmarshallWithoutNamespace((File)file);
                AgencyImportDialog agencyImportDialog = this.showImportDialog((Window)this.getTaskDialog(), 1);
                if (agencyImportDialog == null) {
                    return null;
                }
                this.logDialogSettings(agencyImportDialog);
                this.setMessage(resourceMap.getString("message.doConvert", new Object[0]));
                TransferImpl transferImpl = new OpenImmoReader(agencyImportDialog).readTransfer(openimmo);
                this.setMessage(resourceMap.getString("message.doImport", new Object[0]));
                return this.importTransfer(transferImpl, agencyImportDialog.getSelectedStatus(), agencyImportDialog.getSelectedDeleteMethod(), agencyImportDialog.isIgnoreUpdateSelected());
            }

            protected void failed(Throwable throwable) {
                super.failed(throwable);
                ImmoToolUtils.showMessageErrorDialog((String)resourceMap.getString("error.importFailed", new Object[0]), (Throwable)throwable);
            }

            protected void succeeded(AgencyImportTask.ImportResult importResult) {
                super.succeeded((Object)importResult);
                this.getTaskDialog().setAutoCloseSelected(false);
                ImmoToolUtils.showMessageInfoDialog((String)(importResult == null || importResult.getTotalCount() < 1 ? resourceMap.getString("message.nothingImported", new Object[0]) : importResult.writeSummary()), (Component)this.getTaskDialog());
            }
        });
    }

    @Action
    public void doImportViaLocalFtp() {
        try {
            AgencyImportViaLocalFtpDialog agencyImportViaLocalFtpDialog = new AgencyImportViaLocalFtpDialog();
            agencyImportViaLocalFtpDialog.setVisible(true);
        }
        catch (Exception exception) {
            LOGGER.error((Object)"could not open ftp-import-dialog!");
            LOGGER.error((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
            ImmoToolUtils.showMessageErrorDialog((String)this.getResourceMap().getString("error.cantOpenDialog", new Object[0]), (Throwable)exception);
        }
    }

    @Action
    public Task doShowAgencyContacts() {
        String string = AgencyContactTablePanel.getInstanceTabTitle();
        if (ImmoToolUtils.selectPanel((String)string)) {
            return null;
        }
        AgencyContactTablePanel agencyContactTablePanel = new AgencyContactTablePanel();
        ImmoToolUtils.showPanel((TabComponent)agencyContactTablePanel);
        return agencyContactTablePanel.doSearch();
    }

    @Action
    public Task doShowAgencyEstates() {
        String string = AgencyEstateTablePanel.getInstanceTabTitle();
        if (ImmoToolUtils.selectPanel((String)string)) {
            return null;
        }
        final AgencyEstateTablePanel agencyEstateTablePanel = new AgencyEstateTablePanel();
        final ResourceMap resourceMap = this.getResourceMap();
        return new ImmoToolTask<AgencyEstateTablePanel>(){

            protected AgencyEstateTablePanel executeTask() throws Exception {
                agencyEstateTablePanel.loadPanel();
                return agencyEstateTablePanel;
            }

            protected void failed(Throwable throwable) {
                super.failed(throwable);
                ImmoToolUtils.showMessageErrorDialog((String)resourceMap.getString("error.cantOpenEstateTable", new Object[0]), (Throwable)throwable);
            }

            protected void succeeded(AgencyEstateTablePanel agencyEstateTablePanel2) {
                super.succeeded((Object)agencyEstateTablePanel2);
                ImmoToolUtils.showPanel((TabComponent)agencyEstateTablePanel2);
                ImmoToolUtils.executeTask((Task)agencyEstateTablePanel2.doSearch());
            }
        };
    }

    @Action
    public Task doShowAgencyExport() {
        String string = AgencyExportPanel.getInstanceTabTitle();
        if (ImmoToolUtils.selectPanel((String)string)) {
            return null;
        }
        final AgencyExportPanel agencyExportPanel = new AgencyExportPanel();
        final ResourceMap resourceMap = this.getResourceMap();
        return new ImmoToolTask<TabComponent>(){

            protected TabComponent executeTask() throws Exception {
                agencyExportPanel.refresh();
                return agencyExportPanel;
            }

            protected void failed(Throwable throwable) {
                super.failed(throwable);
                ImmoToolUtils.showMessageErrorDialog((String)resourceMap.getString("error.cantOpenExportTable", new Object[0]), (Throwable)throwable);
            }

            protected void succeeded(TabComponent tabComponent) {
                super.succeeded((Object)tabComponent);
                ImmoToolUtils.showPanel((TabComponent)tabComponent);
            }
        };
    }

    @Action
    public Task doShowAgencyProfile() {
        String string = AgencyProfilePanel.getInstanceTabTitle();
        if (ImmoToolUtils.selectPanel((String)string)) {
            return null;
        }
        final ResourceMap resourceMap = this.getResourceMap();
        return new ImmoToolTask<TabComponent>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected TabComponent executeTask() throws Exception {
                AgencyProfilePanel agencyProfilePanel;
                Collection collection = null;
                try {
                    AgencyProfilePanel agencyProfilePanel2 = new AgencyProfilePanel();
                    collection = AgencyPluginUtils.openPluginCollection("");
                    agencyProfilePanel2.loadAgent(AgencyAgent.loadAgent(collection), AgencyAgent.loadLogo(collection));
                    agencyProfilePanel = agencyProfilePanel2;
                }
                catch (Throwable throwable) {
                    ImmoToolDbUtils.close(collection);
                    throw throwable;
                }
                ImmoToolDbUtils.close((Collection)collection);
                return agencyProfilePanel;
            }

            protected void failed(Throwable throwable) {
                super.failed(throwable);
                ImmoToolUtils.showMessageErrorDialog((String)resourceMap.getString("error.cantOpenProfile", new Object[0]), (Throwable)throwable);
            }

            protected void succeeded(TabComponent tabComponent) {
                super.succeeded((Object)tabComponent);
                ImmoToolUtils.showPanel((TabComponent)tabComponent);
            }
        };
    }

    @Action
    public Task doTableExport() {
        AgencyEstateExportFields agencyEstateExportFields;
        block9: {
            File file = AgencyPlugin.getLastExportLocation();
            agencyEstateExportFields = null;
            try {
                AgencyEstateExportDialog agencyEstateExportDialog = new AgencyEstateExportDialog();
                agencyEstateExportDialog.setVisible(true);
                if (agencyEstateExportDialog.getStatus() != 2) {
                    return null;
                }
                final boolean bl = agencyEstateExportDialog.isCsvExportSelected();
                final boolean bl2 = agencyEstateExportDialog.isXlsExportSelected();
                Charset charset = agencyEstateExportDialog.getSelectedCharset();
                String string = agencyEstateExportDialog.getSelectedEstateAction();
                String string2 = agencyEstateExportDialog.getSelectedEstateStatus();
                OpenEstateType openEstateType = agencyEstateExportDialog.getSelectedEstateType();
                Locale locale = agencyEstateExportDialog.getSelectedLanguage();
                if (!bl && !bl2) {
                    throw new Exception("invalid export-mode!");
                }
                JFileChooser jFileChooser = new JFileChooser();
                jFileChooser.setDialogTitle(this.getResourceMap().getString("question.exportTableLocation", new Object[0]));
                jFileChooser.setApproveButtonText(this.getResourceMap().getString("label.exportFile", new Object[0]));
                String string3 = this.getResourceMap().getString(bl ? "label.exportFile.csv" : "label.exportFile.xls", new Object[]{System.currentTimeMillis()});
                if (file == null) {
                    jFileChooser.setSelectedFile(new File(string3));
                } else {
                    jFileChooser.setSelectedFile(new File(file.getAbsolutePath() + File.separator + string3));
                }
                jFileChooser.setFileFilter(new FileFilter(){

                    @Override
                    public boolean accept(File file) {
                        return file.isDirectory() || bl && file.getName().toLowerCase().endsWith(".csv") || bl2 && file.getName().toLowerCase().endsWith(".xls");
                    }

                    @Override
                    public String getDescription() {
                        if (bl) {
                            return AgencyPlugin.this.getResourceMap().getString("label.exportFile.csvFiles", new Object[]{"*.csv"});
                        }
                        if (bl2) {
                            return AgencyPlugin.this.getResourceMap().getString("label.exportFile.xlsFiles", new Object[]{"*.xls"});
                        }
                        return null;
                    }
                });
                int n = jFileChooser.showSaveDialog(null);
                if (n != 0) {
                    return null;
                }
                final ResourceMap resourceMap = this.getResourceMap();
                File file2 = jFileChooser.getSelectedFile();
                AgencyPlugin.setLastExportLocation(file2.getParentFile());
                if (bl) {
                    agencyEstateExportFields = new AgencyEstateExportCsvTask(file2, charset, openEstateType, string, string2, locale){

                        protected void failed(Throwable throwable) {
                            super.failed(throwable);
                            ImmoToolUtils.showMessageErrorDialog((String)resourceMap.getString("error.exportFailed", new Object[0]), (Throwable)throwable);
                        }

                        protected void succeeded(Long l) {
                            super.succeeded((Object)l);
                            ImmoToolUtils.showMessageInfoDialog((String)resourceMap.getString("message.successfulExported", new Object[]{l}), (Component)ImmoToolApp.getApplication().getMainFrame());
                        }
                    };
                    break block9;
                }
                if (bl2) {
                    agencyEstateExportFields = new AgencyEstateExportXlsTask(file2, charset, openEstateType, string, string2, locale){

                        protected void failed(Throwable throwable) {
                            super.failed(throwable);
                            ImmoToolUtils.showMessageErrorDialog((String)resourceMap.getString("error.exportFailed", new Object[0]), (Throwable)throwable);
                        }

                        protected void succeeded(Long l) {
                            super.succeeded((Object)l);
                            ImmoToolUtils.showMessageInfoDialog((String)resourceMap.getString("message.successfulExported", new Object[]{l}), (Component)ImmoToolApp.getApplication().getMainFrame());
                        }
                    };
                    break block9;
                }
                throw new Exception("Can't create export task!");
            }
            catch (Exception exception) {
                LOGGER.error((Object)"export-error!");
                LOGGER.error((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
                ImmoToolUtils.showMessageErrorDialog((String)this.getResourceMap().getString("error.exportSetupFailed", new Object[0]), (Throwable)exception);
            }
        }
        return agencyEstateExportFields;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void exportDatabase(File file, ImmoToolDb immoToolDb, ImmoToolProject immoToolProject, JOptionFileChooser jOptionFileChooser, ImmoToolTask.Callback callback) throws ImmoToolException {
        Object object;
        Object object2;
        Collection collection;
        File file2 = new File(file.getAbsolutePath() + File.separator + "OpenEstate-Tool-Agency");
        if (!file2.exists() && !file2.mkdir()) {
            throw new ImmoToolException("Can't create directory: " + file2.getAbsolutePath());
        }
        File file3 = new File(file2.getAbsolutePath() + File.separator + "exposes");
        if (!file3.exists() && !file3.mkdir()) {
            throw new ImmoToolException("Can't create directory: " + file3.getAbsolutePath());
        }
        File file4 = new File(file2.getAbsolutePath() + File.separator + "exports");
        if (!file4.exists() && !file4.mkdir()) {
            throw new ImmoToolException("Can't create directory: " + file4.getAbsolutePath());
        }
        File file5 = new File(file2.getAbsolutePath() + File.separator + "export_history");
        if (!file5.exists() && !file5.mkdir()) {
            throw new ImmoToolException("Can't create directory: " + file5.getAbsolutePath());
        }
        File file6 = new File(file2.getAbsolutePath() + File.separator + "export_changes");
        if (!file6.exists() && !file6.mkdir()) {
            throw new ImmoToolException("Can't create directory: " + file6.getAbsolutePath());
        }
        File file7 = new File(file2.getAbsolutePath() + File.separator + "export_publishings");
        if (!file7.exists() && !file7.mkdir()) {
            throw new ImmoToolException("Can't create directory: " + file7.getAbsolutePath());
        }
        File file8 = new File(file2.getAbsolutePath() + File.separator + "contacts");
        if (!file8.exists() && !file8.mkdir()) {
            throw new ImmoToolException("Can't create directory: " + file8.getAbsolutePath());
        }
        File file9 = new File(file2.getAbsolutePath() + File.separator + "estates");
        if (!file9.exists() && !file9.mkdir()) {
            throw new ImmoToolException("Can't create directory: " + file9.getAbsolutePath());
        }
        File file10 = new File(file2.getAbsolutePath() + File.separator + "estate_files");
        if (!file10.exists() && !file10.mkdir()) {
            throw new ImmoToolException("Can't create directory: " + file10.getAbsolutePath());
        }
        File file11 = new File(file2.getAbsolutePath() + File.separator + "geodata");
        if (!file11.exists() && !file11.mkdir()) {
            throw new ImmoToolException("Can't create directory: " + file11.getAbsolutePath());
        }
        DateFormat dateFormat = DateFormat.getDateTimeInstance(2, 2);
        String string = "exported at " + dateFormat.format(new Date());
        boolean bl = ((JCheckBox)jOptionFileChooser.getOptionComponent(PRESERVE_ESTATE_ID)).isSelected();
        Collection collection2 = null;
        FileWriter fileWriter = null;
        FileOutputStream fileOutputStream = null;
        try {
            if (callback != null) {
                callback.setMessage("> /Agent.xml");
            }
            collection2 = AgencyPluginUtils.openPluginCollection(immoToolDb, "");
            collection = AgencyAgent.loadAgent(collection2);
            fileWriter = new FileWriter(new File(file.getAbsolutePath() + File.separator + DB_RESOURCE_AGENT));
            OpenEstateUtils.serializeToXML((SerializableXmlElement)collection, (Writer)fileWriter, (boolean)false);
            InputStream inputStream = AgencyAgent.loadLogoAsStream(collection2);
            if (inputStream != null) {
                fileOutputStream = new FileOutputStream(new File(file.getAbsolutePath() + File.separator + DB_RESOURCE_AGENT_LOGO));
                IOUtils.copy((InputStream)inputStream, (OutputStream)fileOutputStream);
            }
        }
        catch (Exception exception) {
            try {
                if (callback != null) {
                    callback.setMessage("> Can't save agent!");
                    callback.setMessage("> " + exception.getLocalizedMessage());
                }
                throw new ImmoToolException("Can't save agent!", (Throwable)exception);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fileWriter);
                IOUtils.closeQuietly(fileOutputStream);
                ImmoToolDbUtils.close((Collection)collection2);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Writer)fileWriter);
        IOUtils.closeQuietly(fileOutputStream);
        ImmoToolDbUtils.close((Collection)collection2);
        try {
            collection2 = AgencyPluginUtils.openPluginCollection(DB_COLLECTION_GEO);
            for (String object4 : collection2.listResources()) {
                if (callback != null) {
                    callback.setMessage("> /geo/" + object4);
                }
                try {
                    XMLResource xMLResource = ImmoToolDbUtils.loadXMLResource((Collection)collection2, (String)object4);
                    fileWriter = new FileWriter(new File(file11.getAbsolutePath() + File.separator + object4));
                    fileWriter.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                    fileWriter.write(SystemUtils.LINE_SEPARATOR);
                    fileWriter.write((String)xMLResource.getContent());
                    fileWriter.flush();
                }
                catch (Exception exception) {
                    if (callback != null) {
                        callback.setMessage("> Can't save geodata from '" + object4 + "'");
                        callback.setMessage("> " + exception.getLocalizedMessage());
                    }
                    throw new Exception("Can't save geodata from '" + object4 + "'", exception);
                }
            }
        }
        catch (Exception exception) {
            if (callback != null) {
                callback.setMessage("> Can't save geodata!");
                callback.setMessage("> " + exception.getLocalizedMessage());
            }
            throw new ImmoToolException("Can't save geodata!", (Throwable)exception);
        }
        finally {
            ImmoToolDbUtils.close((Collection)collection2);
        }
        try {
            collection2 = AgencyPluginUtils.openPluginCollection(DB_COLLECTION_PDF);
            for (PdfSetup pdfSetup : PdfSetup.loadSetups(collection2)) {
                InputStream inputStream;
                InputStream inputStream2 = null;
                fileOutputStream = null;
                try {
                    if (callback != null) {
                        callback.setMessage("> /pdf/Pdf." + pdfSetup.getId() + ".xml");
                    }
                    object2 = new Properties();
                    pdfSetup.save((Properties)object2);
                    fileOutputStream = new FileOutputStream(new File(file3.getAbsolutePath() + File.separator + pdfSetup.getId() + ".xml"));
                    ((Properties)object2).storeToXML(fileOutputStream, string);
                    fileOutputStream.flush();
                    fileOutputStream.close();
                    inputStream = PdfSetup.loadTemplateAsStream(pdfSetup.getId(), collection2);
                    if (inputStream != null) {
                        fileOutputStream = new FileOutputStream(new File(file3.getAbsolutePath() + File.separator + pdfSetup.getId() + ".pdf"));
                        if (callback != null) {
                            callback.setMessage("> /pdf/Pdf." + pdfSetup.getId() + ".pdf");
                        }
                        IOUtils.copy((InputStream)inputStream, (OutputStream)fileOutputStream);
                        fileOutputStream.flush();
                        fileOutputStream.close();
                    }
                }
                catch (Exception exception) {
                    try {
                        if (callback != null) {
                            callback.setMessage("> Can't save expose setup #" + pdfSetup.getId());
                            callback.setMessage("> " + exception.getLocalizedMessage());
                        }
                        throw new Exception("Can't save expose setup #" + pdfSetup.getId(), exception);
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(inputStream2);
                        IOUtils.closeQuietly((OutputStream)fileOutputStream);
                        throw throwable;
                    }
                }
                IOUtils.closeQuietly((InputStream)inputStream);
                IOUtils.closeQuietly((OutputStream)fileOutputStream);
            }
        }
        catch (Exception exception) {
            if (callback != null) {
                callback.setMessage("> Can't save expose setups!");
                callback.setMessage("> ERROR: " + exception.getLocalizedMessage());
            }
            throw new ImmoToolException("Can't save expose setups!", (Throwable)exception);
        }
        finally {
            ImmoToolDbUtils.close((Collection)collection2);
        }
        try {
            collection2 = AgencyPluginUtils.openPluginCollection(DB_COLLECTION_EXPORTS);
            for (AgencyExportInterface agencyExportInterface : AgencyExportInterface.loadExportInterfaces(collection2)) {
                void var26_57;
                void var26_55;
                FileOutputStream fileOutputStream2;
                OutputStream outputStream = null;
                try {
                    if (callback != null) {
                        callback.setMessage("> /exports/ExportInterface." + agencyExportInterface.getId() + ".xml");
                    }
                    object2 = new Properties();
                    agencyExportInterface.save((Properties)object2);
                    fileOutputStream2 = new FileOutputStream(new File(file4.getAbsolutePath() + File.separator + agencyExportInterface.getId() + ".xml"));
                    ((Properties)object2).storeToXML(fileOutputStream2, string);
                    fileOutputStream2.flush();
                    fileOutputStream2.close();
                }
                catch (Exception exception) {
                    try {
                        if (callback != null) {
                            callback.setMessage("> Can't save export interface #" + agencyExportInterface.getId());
                            callback.setMessage("> " + exception.getLocalizedMessage());
                        }
                        throw new Exception("Can't save export interface #" + agencyExportInterface.getId(), exception);
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(outputStream);
                        throw throwable;
                    }
                }
                IOUtils.closeQuietly((OutputStream)fileOutputStream2);
                try {
                    object2 = AgencyExportList.loadExportList(agencyExportInterface.getId(), "published", collection2);
                    if (object2 != null) {
                        object = new Properties();
                        ((AgencyExportList)object2).save((Properties)object);
                        FileOutputStream fileOutputStream3 = new FileOutputStream(new File(file7.getAbsolutePath() + File.separator + agencyExportInterface.getId() + ".xml"));
                        ((Properties)object).storeToXML(fileOutputStream3, string);
                        fileOutputStream3.flush();
                        fileOutputStream3.close();
                    }
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly((OutputStream)fileOutputStream2);
                    throw throwable;
                }
                IOUtils.closeQuietly((OutputStream)var26_55);
                try {
                    object2 = AgencyExportList.loadExportList(agencyExportInterface.getId(), "changed", collection2);
                    if (object2 != null) {
                        object = new Properties();
                        ((AgencyExportList)object2).save((Properties)object);
                        FileOutputStream fileOutputStream4 = new FileOutputStream(new File(file6.getAbsolutePath() + File.separator + agencyExportInterface.getId() + ".xml"));
                        ((Properties)object).storeToXML(fileOutputStream4, string);
                        fileOutputStream4.flush();
                        fileOutputStream4.close();
                    }
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly((OutputStream)var26_55);
                    throw throwable;
                }
                IOUtils.closeQuietly((OutputStream)var26_57);
            }
        }
        catch (Exception exception) {
            if (callback != null) {
                callback.setMessage("> Can't save export interfaces!");
                callback.setMessage("> " + exception.getLocalizedMessage());
            }
            throw new ImmoToolException("Can't save export interfaces!", (Throwable)exception);
        }
        finally {
            ImmoToolDbUtils.close((Collection)collection2);
        }
        try {
            collection2 = AgencyPluginUtils.openPluginCollection(DB_COLLECTION_EXPORT_SUMMARIES);
            for (Long l : AgencyExportSummary.loadExportSummaryIds(collection2)) {
                OutputStream outputStream = null;
                try {
                    if (callback != null) {
                        callback.setMessage("> /exports/summaries/" + l + ".xml");
                    }
                    if ((object2 = AgencyExportSummary.loadExportSummary(l, collection2)) == null) continue;
                    object = new Properties();
                    ((AgencyExportSummary)object2).save((Properties)object);
                    FileOutputStream fileOutputStream5 = new FileOutputStream(new File(file5.getAbsolutePath() + File.separator + ((AgencyExportSummary)object2).getId() + ".xml"));
                    ((Properties)object).storeToXML(fileOutputStream5, string);
                    fileOutputStream5.flush();
                    fileOutputStream5.close();
                    IOUtils.closeQuietly((OutputStream)fileOutputStream5);
                }
                catch (Exception exception) {
                    if (callback != null) {
                        callback.setMessage("> Can't save export history #" + l);
                        callback.setMessage("> " + exception.getLocalizedMessage());
                    }
                    throw new Exception("Can't save export history #" + l, exception);
                }
                finally {
                    IOUtils.closeQuietly(outputStream);
                }
            }
        }
        catch (Exception exception) {
            if (callback != null) {
                callback.setMessage("> Can't save export histories!");
                callback.setMessage("> " + exception.getLocalizedMessage());
            }
            throw new ImmoToolException("Can't save export histories!", (Throwable)exception);
        }
        finally {
            ImmoToolDbUtils.close((Collection)collection2);
        }
        try {
            collection2 = AgencyPluginUtils.openPluginCollection(DB_COLLECTION_CONTACTS);
            for (String string2 : collection2.listResources()) {
                Long l = 0L;
                try {
                    Long l2;
                    if (!string2.startsWith("AgentContact.") || !string2.endsWith(".xml")) continue;
                    if (callback != null) {
                        callback.setMessage("> /contacts/" + (String)string2);
                    }
                    if ((object = AgencyContact.loadContact(l2 = Long.valueOf((object2 = string2.split("\\."))[((String[])object2).length - 2]), collection2)) == null) continue;
                    fileWriter = new FileWriter(new File(file8.getAbsolutePath() + File.separator + ((AgencyContact)((Object)object)).getIdNr() + ".xml"));
                    OpenEstateUtils.serializeToXML((SerializableXmlElement)object, (Writer)fileWriter, (boolean)false);
                }
                catch (Exception exception) {
                    if (callback != null) {
                        callback.setMessage("> Can't save contact '" + (String)string2 + "'!");
                        callback.setMessage("> " + exception.getLocalizedMessage());
                    }
                    throw new Exception("Can't save contact '" + (String)string2 + "'!", exception);
                }
                finally {
                    IOUtils.closeQuietly((Writer)fileWriter);
                }
            }
        }
        catch (Exception exception) {
            if (callback != null) {
                callback.setMessage("> Can't save contacts!");
                callback.setMessage("> " + exception.getLocalizedMessage());
            }
            throw new ImmoToolException("Can't save contacts!", (Throwable)exception);
        }
        finally {
            ImmoToolDbUtils.close((Collection)collection2);
        }
        collection = null;
        try {
            void var25_45;
            collection2 = AgencyPluginUtils.openPluginCollection(DB_COLLECTION_ESTATES);
            collection = AgencyPluginUtils.openPluginCollection(DB_COLLECTION_ESTATE_FILES);
            String[] stringArray = collection2.listResources();
            int n = stringArray.length;
            boolean bl2 = false;
            while (var25_45 < n) {
                block123: {
                    String string3 = stringArray[var25_45];
                    if (string3.startsWith("Estate.") && string3.endsWith(".xml")) {
                        String string4;
                        String string5;
                        Object object3;
                        Object object4;
                        object2 = new ArrayList();
                        object = null;
                        try {
                            if (callback != null) {
                                callback.setMessage("> /estates/" + string3);
                            }
                            if ((object = AgencyEstate.loadEstate((Long)(object4 = Long.valueOf((object3 = string3.split("\\."))[((String[])object3).length - 2])), collection2)) == null) break block123;
                            if (object.getLanguages().isEmpty()) {
                                object.getLanguages().addAll(Arrays.asList(object.getTitleLanguages()));
                            }
                            if (bl) {
                                string5 = String.valueOf(object4);
                                string4 = object.getPublicId();
                                if (!StringUtils.isBlank((String)string4)) {
                                    string5 = string5 + "/" + string4.trim();
                                }
                                if (!object2.contains(string5)) {
                                    object.setPublicId(string5);
                                    object2.add(string5);
                                }
                            } else {
                                string5 = object.getPublicId();
                                if (!StringUtils.isBlank((String)string5) && !object2.contains(string5)) {
                                    object2.add(string5);
                                } else {
                                    object.setPublicId(null);
                                }
                            }
                            fileWriter = new FileWriter(new File(file9.getAbsolutePath() + File.separator + ((AgencyEstate)((Object)object)).getIdNr() + ".xml"));
                            OpenEstateUtils.serializeToXML((SerializableXmlElement)object, (Writer)fileWriter, (boolean)false);
                        }
                        catch (Exception exception) {
                            if (callback != null) {
                                callback.setMessage("> Can't save estate '" + string3 + "'!");
                                callback.setMessage("> " + exception.getLocalizedMessage());
                            }
                            throw new Exception("Can't save estate '" + string3 + "'!", exception);
                        }
                        object3 = null;
                        object4 = object.getAttachments().iterator();
                        while (object4.hasNext()) {
                            string5 = (EstateAttachmentImpl)object4.next();
                            if (!string5.isName() || (string4 = string5.getFileAsName()) == null) continue;
                            if (callback != null) {
                                callback.setMessage("> /estates/files/" + ((AgencyEstate)((Object)object)).getIdNr() + "/" + string4);
                            }
                            if (object3 == null && !((File)(object3 = new File(file10.getAbsolutePath() + File.separator + ((AgencyEstate)((Object)object)).getIdNr()))).exists() && !((File)object3).mkdir()) {
                                throw new Exception("Can't create directory: " + ((File)object3).getAbsolutePath());
                            }
                            try {
                                File file12 = new File(((File)object3).getAbsolutePath() + File.separator + string4);
                                AgencyEstate.loadAttachmentIntoFile(file12, ((AgencyEstate)((Object)object)).getIdNr(), string4, collection);
                            }
                            catch (Exception exception) {
                                if (callback != null) {
                                    callback.setMessage("> Can't save attachment '" + string4 + "' for estate #" + ((AgencyEstate)((Object)object)).getIdNr());
                                    callback.setMessage("> " + exception.getLocalizedMessage());
                                }
                                throw new Exception("Can't save attachment '" + string4 + "' for estate #" + ((AgencyEstate)((Object)object)).getIdNr(), exception);
                            }
                        }
                    }
                }
                ++var25_45;
            }
        }
        catch (Exception exception) {
            if (callback != null) {
                callback.setMessage("> Can't save estates!");
                callback.setMessage("> " + exception.getLocalizedMessage());
            }
            throw new ImmoToolException("Can't save estates!", (Throwable)exception);
        }
        finally {
            ImmoToolDbUtils.close((Collection)collection);
            ImmoToolDbUtils.close((Collection)collection2);
        }
    }

    public Map<String, JOptionFileChooser.OptionField> getExportDatabaseSettings() {
        HashMap<String, JOptionFileChooser.OptionField> hashMap = new HashMap<String, JOptionFileChooser.OptionField>();
        JCheckBox jCheckBox = new JCheckBox();
        jCheckBox.setName("preserveEstateIdBox");
        this.getResourceMap().injectComponent((Component)jCheckBox);
        hashMap.put(PRESERVE_ESTATE_ID, new JOptionFileChooser.OptionField(null, (JComponent)jCheckBox));
        return hashMap;
    }

    public BufferedImage getIcon() {
        try {
            return ImageIO.read(((Object)((Object)this)).getClass().getResourceAsStream(this.getResourceMap().getString("Plugin.Icon", new Object[0])));
        }
        catch (Exception exception) {
            LOGGER.error((Object)"could not load plugin-icon!");
            LOGGER.error((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
            return null;
        }
    }

    public static String getImgDefaultFormat() {
        return ImmoToolApp.getApplication().getProject().getProperty(KEY_IMG_DEFAULT_FORMAT, "JPG");
    }

    public static int getImgMaxHeight() {
        return ImmoToolApp.getApplication().getProject().getPropertyAsInteger(KEY_IMG_MAXHEIGHT, Integer.valueOf(600));
    }

    public static int getImgMaxWidth() {
        return ImmoToolApp.getApplication().getProject().getPropertyAsInteger(KEY_IMG_MAXWIDTH, Integer.valueOf(800));
    }

    public static AgencyPlugin getInstance() {
        return (AgencyPlugin)ImmoToolApp.getApplication().getProject().getPlugin(PLUGIN_NAME);
    }

    public static File getLastExportLocation() {
        return lastExportLocation;
    }

    public static File getLastImageLocation() {
        return lastImageLocation;
    }

    public static File getLastImportLocation() {
        String string = ImmoToolApp.getApplicationProperties().getProperty(KEY_LAST_IMPORT_LOCATION, "");
        if (string == null || string.trim().length() == 0) {
            return null;
        }
        File file = new File(string);
        return file.isDirectory() ? file : null;
    }

    public static Locale[] getLocales() {
        ArrayList<Locale> arrayList = new ArrayList<Locale>();
        for (String string : ImmoToolApp.getApplication().getProject().getProperty(KEY_LOCALES, "de").trim().split(",")) {
            arrayList.add(OpenEstateUtils.buildLocale((String)string));
        }
        return arrayList.toArray(new Locale[arrayList.size()]);
    }

    public final URI getURI() {
        try {
            return new URL(PLUGIN_URL).toURI();
        }
        catch (Exception exception) {
            throw new RuntimeException("could not load plugin-url: " + exception.getLocalizedMessage(), exception);
        }
    }

    public final String getName() {
        return PLUGIN_NAME;
    }

    public boolean hasOptions() {
        return false;
    }

    public void init(Object ... objectArray) {
    }

    public void initDatabase(ImmoToolDb immoToolDb, ImmoToolProject immoToolProject, ImmoToolTask.Callback callback) throws ImmoToolException {
        super.initDatabase(immoToolDb, immoToolProject, callback);
        Collection collection = null;
        try {
            Object object;
            ImmoToolApp immoToolApp = ImmoToolApp.getApplication();
            collection = AgencyPluginUtils.openPluginCollection(immoToolDb, "");
            if (collection == null) {
                collection = immoToolDb.createCollection(PLUGIN_DB_PATH);
            }
            Collection collection2 = null;
            collection2 = AgencyPluginUtils.openPluginCollection(immoToolDb, DB_COLLECTION_CONTACTS);
            if (collection2 == null) {
                collection2 = immoToolDb.createCollection("ImmoTool/OpenEstate-Agency/contacts");
            }
            collection2.close();
            collection2 = AgencyPluginUtils.openPluginCollection(immoToolDb, DB_COLLECTION_ESTATES);
            if (collection2 == null) {
                collection2 = immoToolDb.createCollection("ImmoTool/OpenEstate-Agency/estates");
            }
            collection2.close();
            collection2 = AgencyPluginUtils.openPluginCollection(immoToolDb, DB_COLLECTION_ESTATE_FILES);
            if (collection2 == null) {
                collection2 = immoToolDb.createCollection("ImmoTool/OpenEstate-Agency/estates/files");
            }
            collection2.close();
            collection2 = AgencyPluginUtils.openPluginCollection(immoToolDb, DB_COLLECTION_EXPORTS);
            if (collection2 == null) {
                collection2 = immoToolDb.createCollection("ImmoTool/OpenEstate-Agency/exports");
            }
            collection2.close();
            collection2 = AgencyPluginUtils.openPluginCollection(immoToolDb, DB_COLLECTION_EXPORT_SUMMARIES);
            if (collection2 == null) {
                collection2 = immoToolDb.createCollection("ImmoTool/OpenEstate-Agency/exports/summaries");
            }
            collection2.close();
            collection2 = AgencyPluginUtils.openPluginCollection(immoToolDb, DB_COLLECTION_PDF);
            if (collection2 == null) {
                collection2 = immoToolDb.createCollection("ImmoTool/OpenEstate-Agency/pdf");
                object = new PdfSetup("expose.detailed");
                ((PdfSetup)object).setId(immoToolDb.getNextSequence(DB_SEQUENCE_PDF_SETUP));
                Long l = PdfSetup.storeSetup((PdfSetup)object, collection2);
                if (l <= 0L) {
                    LOGGER.warn((Object)"could not create default-pdf-setup!");
                }
                object = new PdfSetup("expose.short");
                ((PdfSetup)object).setId(immoToolDb.getNextSequence(DB_SEQUENCE_PDF_SETUP));
                l = PdfSetup.storeSetup((PdfSetup)object, collection2);
                if (l <= 0L) {
                    LOGGER.warn((Object)"could not create default-pdf-setup!");
                }
            }
            collection2.close();
            collection2 = AgencyPluginUtils.openPluginCollection(immoToolDb, DB_COLLECTION_GEO);
            if (collection2 == null) {
                collection2 = immoToolDb.createCollection("ImmoTool/OpenEstate-Agency/geo");
            }
            collection2.close();
            if (!ImmoToolDbUtils.hasResource((Collection)collection, (String)DB_RESOURCE_AGENT)) {
                AgencyAgent.createDefaultAgent(immoToolDb, collection, immoToolProject);
            }
            if (immoToolProject.getAdress() == null) {
                object = AgencyAgent.loadAgent();
                immoToolProject.setAdress(object.getCompany());
            }
            if (ImmoToolDbUtils.hasResource((Collection)collection, (String)DB_RESOURCE_AGENT_LOGO)) {
                try {
                    immoToolApp.getFrameView().setProjectCompanyLogo(AgencyAgent.loadLogo(collection));
                }
                catch (Exception exception) {
                    LOGGER.warn((Object)"could not load agency-logo!");
                    LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
                }
            }
        }
        catch (Exception exception) {
            throw new ImmoToolDbException("db-init-error: " + exception.getLocalizedMessage(), (Throwable)exception);
        }
    }

    public static boolean isImgFormatForced() {
        return ImmoToolApp.getApplication().getProject().getPropertyAsBoolean(KEY_IMG_FORCE_FORMAT, Boolean.valueOf(false));
    }

    public void load() {
        super.load();
        GeoDb.clearCaches();
    }

    public void openOptions() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void rebuildDatabase(ImmoToolDb immoToolDb, ImmoToolProject immoToolProject, ImmoToolTask.Callback callback) {
        String[] stringArray;
        Collection collection;
        Object object;
        Object object2;
        Collection collection2 = null;
        try {
            if (callback != null) {
                callback.setMessage("> /Agent.xml");
            }
            collection2 = AgencyPluginUtils.openPluginCollection(immoToolDb, "");
            object2 = AgencyAgent.loadAgent(collection2);
            AgencyAgent.storeAgent((AgencyAgent)((Object)object2), collection2);
        }
        catch (Exception exception) {
            block75: {
                try {
                    LOGGER.warn((Object)"Can't rebuild agency!");
                    LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
                    if (callback == null) break block75;
                    callback.setMessage("> ERROR: " + exception.getLocalizedMessage());
                }
                catch (Throwable throwable) {
                    ImmoToolDbUtils.close(collection2);
                    throw throwable;
                }
            }
            ImmoToolDbUtils.close((Collection)collection2);
        }
        ImmoToolDbUtils.close((Collection)collection2);
        try {
            collection2 = AgencyPluginUtils.openPluginCollection(DB_COLLECTION_PDF);
            for (PdfSetup pdfSetup : PdfSetup.loadSetups(collection2)) {
                try {
                    if (callback != null) {
                        callback.setMessage("> /pdf/Pdf." + pdfSetup.getId() + ".xml");
                    }
                    PdfSetup.storeSetup(pdfSetup, collection2);
                }
                catch (Exception exception) {
                    LOGGER.warn((Object)("Can't rebuild pdf-setup #" + pdfSetup.getId()));
                    LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
                    if (callback == null) continue;
                    callback.setMessage("> ERROR: " + exception.getLocalizedMessage());
                }
            }
        }
        catch (Exception exception) {
            LOGGER.warn((Object)"Can't rebuild pdf-setups!");
            LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
            if (callback != null) {
                callback.setMessage("> ERROR: " + exception.getLocalizedMessage());
            }
        }
        finally {
            ImmoToolDbUtils.close((Collection)collection2);
        }
        try {
            collection2 = AgencyPluginUtils.openPluginCollection(DB_COLLECTION_EXPORTS);
            for (AgencyExportInterface agencyExportInterface : AgencyExportInterface.loadExportInterfaces(collection2)) {
                try {
                    if (callback != null) {
                        callback.setMessage("> /exports/ExportInterface." + agencyExportInterface.getId() + ".xml");
                    }
                    AgencyExportInterface.storeExportInterface(agencyExportInterface, collection2);
                }
                catch (Exception exception) {
                    LOGGER.warn((Object)("Can't rebuild export-interface #" + agencyExportInterface.getId()));
                    LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
                    if (callback == null) continue;
                    callback.setMessage("> ERROR: " + exception.getLocalizedMessage());
                }
            }
        }
        catch (Exception exception) {
            LOGGER.warn((Object)"Can't rebuild export-interfaces!");
            LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
            if (callback != null) {
                callback.setMessage("> ERROR: " + exception.getLocalizedMessage());
            }
        }
        finally {
            ImmoToolDbUtils.close((Collection)collection2);
        }
        try {
            collection2 = AgencyPluginUtils.openPluginCollection(DB_COLLECTION_EXPORT_SUMMARIES);
            for (Long l : AgencyExportSummary.loadExportSummaryIds(collection2)) {
                try {
                    if (callback != null) {
                        callback.setMessage("> /exports/summaries/" + l + ".xml");
                    }
                    if ((object = AgencyExportSummary.loadExportSummary(l, collection2)) == null) continue;
                    AgencyExportSummary.storeExportSummary((AgencyExportSummary)object, collection2);
                }
                catch (Exception exception) {
                    LOGGER.warn((Object)("Can't rebuild export-summary #" + l));
                    LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
                    if (callback == null) continue;
                    callback.setMessage("> ERROR: " + exception.getLocalizedMessage());
                }
            }
        }
        catch (Exception exception) {
            LOGGER.warn((Object)"Can't rebuild export-summaries!");
            LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
            if (callback != null) {
                callback.setMessage("> ERROR: " + exception.getLocalizedMessage());
            }
        }
        finally {
            ImmoToolDbUtils.close((Collection)collection2);
        }
        object2 = new ArrayList();
        try {
            void var8_23;
            collection2 = AgencyPluginUtils.openPluginCollection(DB_COLLECTION_CONTACTS);
            collection = collection2.listResources();
            int n = ((String[])collection).length;
            boolean bl = false;
            while (var8_23 < n) {
                block79: {
                    object = collection[var8_23];
                    Long l = 0L;
                    try {
                        String[] stringArray2;
                        if (!((String)object).startsWith("AgentContact.") || !((String)object).endsWith(".xml")) break block79;
                        if (callback != null) {
                            callback.setMessage("> /contacts/" + (String)object);
                        }
                        if ((stringArray = AgencyContact.loadContact(l = Long.valueOf((stringArray2 = ((String)object).split("\\."))[stringArray2.length - 2]), collection2)) != null) {
                            object2.add(l);
                            AgencyContact.storeContact((AgencyContact)stringArray, collection2);
                        }
                    }
                    catch (Exception exception) {
                        LOGGER.warn((Object)("Can't rebuild contact #" + l));
                        LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
                        if (callback == null) break block79;
                        callback.setMessage("> ERROR: " + exception.getLocalizedMessage());
                    }
                }
                ++var8_23;
            }
        }
        catch (Exception exception) {
            LOGGER.warn((Object)"Can't rebuild contacts!");
            LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
            if (callback != null) {
                callback.setMessage("> ERROR: " + exception.getLocalizedMessage());
            }
        }
        finally {
            ImmoToolDbUtils.close((Collection)collection2);
        }
        collection = null;
        try {
            String string = AgencyPlugin.getImgDefaultFormat();
            collection2 = AgencyPluginUtils.openPluginCollection(DB_COLLECTION_ESTATES);
            collection = AgencyPluginUtils.openPluginCollection(DB_COLLECTION_ESTATE_FILES);
            String[] stringArray3 = collection2.listResources();
            int n = stringArray3.length;
            int n2 = 0;
            while (n2 < n) {
                block81: {
                    String string2 = stringArray3[n2];
                    if (string2.startsWith("Estate.") && string2.endsWith(".xml")) {
                        Long l;
                        AgencyEstate agencyEstate;
                        if (callback != null) {
                            callback.setMessage("> /estates/" + string2);
                        }
                        if ((agencyEstate = AgencyEstate.loadEstate(l = Long.valueOf((stringArray = string2.split("\\."))[stringArray.length - 2]), collection2)) != null) {
                            if (AgencyPlugin.isImgFormatForced()) {
                                ArrayList<EstateAttachmentImpl> arrayList = new ArrayList<EstateAttachmentImpl>();
                                for (EstateAttachmentImpl estateAttachmentImpl : agencyEstate.getAttachments()) {
                                    File file = null;
                                    File file2 = null;
                                    FileInputStream fileInputStream = null;
                                    try {
                                        BufferedImage bufferedImage;
                                        boolean bl;
                                        if (!estateAttachmentImpl.isName() || estateAttachmentImpl.getFileAsName() == null || !(bl = estateAttachmentImpl.getMimeType().equalsIgnoreCase("image/jpeg") || estateAttachmentImpl.getMimeType().equalsIgnoreCase("image/png"))) continue;
                                        if ("jpg".equalsIgnoreCase(string) && !estateAttachmentImpl.getMimeType().equalsIgnoreCase("image/jpeg")) {
                                            estateAttachmentImpl.setMimeType("image/jpeg");
                                        } else {
                                            if (!"png".equalsIgnoreCase(string) || estateAttachmentImpl.getMimeType().equalsIgnoreCase("image/png")) continue;
                                            estateAttachmentImpl.setMimeType("image/png");
                                        }
                                        file = AgencyEstate.loadAttachmentAsTempFile(l, estateAttachmentImpl.getFileAsName(), collection);
                                        if (file == null) {
                                            arrayList.add(estateAttachmentImpl);
                                            IOUtils.closeQuietly(fileInputStream);
                                            FileUtils.deleteQuietly(file2);
                                            FileUtils.deleteQuietly((File)file);
                                            continue;
                                        }
                                        if (callback != null) {
                                            callback.setMessage("> /estates/files/" + l + "/" + estateAttachmentImpl.getFileAsName());
                                        }
                                        if ((bufferedImage = ImageIO.read(file)) == null) {
                                            throw new Exception("Can't read attached file as image '/estates/files/" + l + "/" + estateAttachmentImpl.getFileAsName() + "'");
                                        }
                                        file2 = File.createTempFile("img", "." + string.toLowerCase());
                                        ImageIO.write((RenderedImage)bufferedImage, string, file2);
                                        bufferedImage.flush();
                                        estateAttachmentImpl.setFile(System.currentTimeMillis() + "." + string.toLowerCase());
                                        fileInputStream = new FileInputStream(file2);
                                        AgencyEstate.storeAttachment(l, fileInputStream, estateAttachmentImpl.getFileAsName(), estateAttachmentImpl.getMimeType(), collection);
                                        ((InputStream)fileInputStream).close();
                                        IOUtils.closeQuietly((InputStream)fileInputStream);
                                    }
                                    catch (Exception exception) {
                                        LOGGER.warn((Object)"Can't convert attachment!");
                                        LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
                                        if (callback == null) continue;
                                        callback.setMessage("> ERROR: " + exception.getLocalizedMessage());
                                        continue;
                                    }
                                    finally {
                                        IOUtils.closeQuietly(fileInputStream);
                                        FileUtils.deleteQuietly(file2);
                                        FileUtils.deleteQuietly(file);
                                        continue;
                                    }
                                    FileUtils.deleteQuietly((File)file2);
                                    FileUtils.deleteQuietly((File)file);
                                }
                                for (EstateAttachmentImpl estateAttachmentImpl : arrayList) {
                                    agencyEstate.getAttachments().remove(estateAttachmentImpl);
                                }
                            }
                            try {
                                AgencyEstate.storeEstate(agencyEstate, collection2);
                                AgencyEstate.removeUnusedAttachments(agencyEstate);
                            }
                            catch (Exception exception) {
                                LOGGER.warn((Object)("Can't rebuild estate #" + l));
                                LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
                                if (callback == null) break block81;
                                callback.setMessage("> ERROR: " + exception.getLocalizedMessage());
                            }
                        }
                    }
                }
                ++n2;
            }
            return;
        }
        catch (Exception exception) {
            LOGGER.warn((Object)"Can't rebuild estates!");
            LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
            if (callback == null) return;
            callback.setMessage("> ERROR: " + exception.getLocalizedMessage());
            return;
        }
        finally {
            ImmoToolDbUtils.close((Collection)collection);
            ImmoToolDbUtils.close((Collection)collection2);
        }
    }

    public static void setImgDefaultFormat(String string) {
        ImmoToolApp.getApplication().getProject().setProperty(KEY_IMG_DEFAULT_FORMAT, string != null ? string : "JPG");
    }

    public static void setImgFormatForced(Boolean bl) {
        ImmoToolApp.getApplication().getProject().setProperty(KEY_IMG_FORCE_FORMAT, bl != null ? bl.toString() : Boolean.FALSE.toString());
    }

    public static void setImgMaxHeight(Integer n) {
        if (n != null && AgencyPlugin.getImgMaxHeight() != n) {
            ImmoToolApp.getApplication().getProject().setProperty(KEY_IMG_MAXHEIGHT, (Number)n);
        }
    }

    public static void setImgMaxWidth(Integer n) {
        if (n != null && AgencyPlugin.getImgMaxWidth() != n) {
            ImmoToolApp.getApplication().getProject().setProperty(KEY_IMG_MAXWIDTH, (Number)n);
        }
    }

    public static synchronized void setLastExportLocation(File file) {
        lastExportLocation = file;
    }

    public static synchronized void setLastImageLocation(File file) {
        lastImageLocation = file;
    }

    public static void setLastImportLocation(File file) {
        ImmoToolApp.getApplicationProperties().setProperty(KEY_LAST_IMPORT_LOCATION, file != null && file.isDirectory() ? file.getAbsolutePath() : "");
    }

    public static void setLocales(Locale[] localeArray) {
        if (localeArray == null || localeArray.length == 0) {
            ImmoToolApp.getApplication().getProject().setProperty(KEY_LOCALES, "de");
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (Locale locale : localeArray) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(",");
            }
            stringBuilder.append(locale.getLanguage());
        }
        ImmoToolApp.getApplication().getProject().setProperty(KEY_LOCALES, stringBuilder.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(ImmoToolProject immoToolProject, ImmoToolDb immoToolDb, String string, String string2) throws ImmoToolException {
        super.update(immoToolProject, immoToolDb, string, string2);
        Collection collection = null;
        Collection collection2 = null;
        try {
            collection = AgencyPluginUtils.openPluginCollection(immoToolDb, DB_COLLECTION_PDF);
            if (collection == null) {
                collection = immoToolDb.createCollection("ImmoTool/OpenEstate-Agency/pdf");
            }
            boolean bl = false;
            for (String string3 : collection.listResources()) {
                if (!string3.startsWith("Pdf.") || !string3.endsWith(".xml")) continue;
                bl = true;
                break;
            }
            if (!bl) {
                PdfSetup pdfSetup;
                PdfSetup pdfSetup2 = new PdfSetup("expose.detailed");
                Long l = PdfSetup.storeSetup(pdfSetup2, collection);
                if (l <= 0L) {
                    LOGGER.warn((Object)"could not create default-pdf-setup!");
                }
                if ((l = PdfSetup.storeSetup(pdfSetup = new PdfSetup("expose.short"), collection)) <= 0L) {
                    LOGGER.warn((Object)"could not create default-pdf-setup!");
                }
            }
        }
        catch (Exception exception) {
            LOGGER.warn((Object)"could not save pdf-template!");
            LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
        }
        finally {
            ImmoToolDbUtils.close((Collection)collection);
            ImmoToolDbUtils.close(collection2);
        }
    }
}

