/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency;

import com.openindex.openestate.impl.OpenEstateUtils;
import com.openindex.openestate.tool.ImmoToolApp;
import com.openindex.openestate.tool.ImmoToolDb;
import com.openindex.openestate.tool.ImmoToolDbException;
import com.openindex.openestate.tool.ImmoToolDbUtils;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.agency.AgencyContact;
import com.openindex.openestate.tool.agency.AgencyEstate;
import com.openindex.openestate.tool.agency.export.AbstractExport;
import com.openindex.openestate.tool.agency.export.AbstractTransport;
import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import javax.swing.JLabel;
import javax.swing.JList;
import org.apache.commons.lang.StringEscapeUtils;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.ResourceSet;
import org.xmldb.api.modules.XMLResource;

public class AgencyPluginUtils {
    private static Map<String, AbstractExport> EXPORTS = null;
    private static Map<String, AbstractTransport> TRANSPORTS = null;

    public static AbstractExport getExport(String string) {
        return EXPORTS.containsKey(string) ? EXPORTS.get(string) : null;
    }

    public static Set<String> getExportNames() {
        return EXPORTS.keySet();
    }

    @Deprecated
    public static Component getListCellRendererComponent(JList jList, AgencyEstate.Row row, int n, boolean bl, boolean bl2) {
        JLabel jLabel = new JLabel();
        AgencyPluginUtils.prepareListCellRenderer(jLabel, jList, row, n, bl, bl2);
        return jLabel;
    }

    @Deprecated
    public static Component getListCellRendererComponent(JList jList, AgencyContact.Row row, int n, boolean bl, boolean bl2) {
        JLabel jLabel = new JLabel();
        AgencyPluginUtils.prepareListCellRenderer(jLabel, jList, row, n, bl, bl2);
        return jLabel;
    }

    public static AbstractTransport getTransport(String string) {
        return TRANSPORTS.containsKey(string) ? TRANSPORTS.get(string) : null;
    }

    public static Set<String> getTransportNames() {
        return TRANSPORTS.keySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] listAvailableEstateActions() throws ImmoToolDbException {
        Collection collection = null;
        try {
            collection = AgencyPluginUtils.openPluginCollection("/estates");
            String[] stringArray = AgencyPluginUtils.listAvailableEstateActions(collection);
            return stringArray;
        }
        finally {
            ImmoToolDbUtils.close((Collection)collection);
        }
    }

    public static String[] listAvailableEstateActions(Collection collection) throws ImmoToolDbException {
        try {
            String string = "declare namespace openestate=\"http://www.openestate.org/1.0/\";\ndeclare namespace xmldb=\"http://exist-db.org/xquery/xmldb\";\nfor $x in xmldb:xcollection( 'ImmoTool/OpenEstate-Agency/estates' )/openestate:Estate\nreturn <result>{local-name($x/*/openestate:Action/*[1])}</result>";
            ResourceSet resourceSet = ImmoToolDbUtils.executeXQuery((Collection)collection, (String)string);
            if (resourceSet.getSize() <= 0L) {
                return new String[0];
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            for (long i = 0L; i < resourceSet.getSize(); ++i) {
                XMLResource xMLResource = (XMLResource)resourceSet.getResource(i);
                String string2 = OpenEstateUtils.makeUnCamelCase((String)xMLResource.getContentAsDOM().getFirstChild().getNodeValue());
                if (arrayList.contains(string2)) continue;
                arrayList.add(string2);
            }
            return arrayList.toArray(new String[arrayList.size()]);
        }
        catch (ImmoToolDbException immoToolDbException) {
            throw immoToolDbException;
        }
        catch (Exception exception) {
            throw new ImmoToolDbException(exception.getLocalizedMessage(), (Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] listAvailableEstateTypes() throws ImmoToolDbException {
        Collection collection = null;
        try {
            collection = AgencyPluginUtils.openPluginCollection("/estates");
            String[] stringArray = AgencyPluginUtils.listAvailableEstateTypes(collection);
            return stringArray;
        }
        finally {
            ImmoToolDbUtils.close((Collection)collection);
        }
    }

    public static String[] listAvailableEstateTypes(Collection collection) throws ImmoToolDbException {
        try {
            String string = "declare namespace openestate=\"http://www.openestate.org/1.0/\";\ndeclare namespace xmldb=\"http://exist-db.org/xquery/xmldb\";\nfor $x in xmldb:xcollection( 'ImmoTool/OpenEstate-Agency/estates' )/openestate:Estate\nreturn <result>{local-name($x/*/openestate:Action/..)}</result>";
            ResourceSet resourceSet = ImmoToolDbUtils.executeXQuery((Collection)collection, (String)string);
            if (resourceSet.getSize() <= 0L) {
                return new String[0];
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            for (long i = 0L; i < resourceSet.getSize(); ++i) {
                XMLResource xMLResource = (XMLResource)resourceSet.getResource(i);
                String string2 = OpenEstateUtils.makeUnCamelCase((String)xMLResource.getContentAsDOM().getFirstChild().getNodeValue());
                if (arrayList.contains(string2)) continue;
                arrayList.add(string2);
            }
            return arrayList.toArray(new String[arrayList.size()]);
        }
        catch (ImmoToolDbException immoToolDbException) {
            throw immoToolDbException;
        }
        catch (Exception exception) {
            throw new ImmoToolDbException(exception.getLocalizedMessage(), (Throwable)exception);
        }
    }

    public static Collection openPluginCollection(String string) throws ImmoToolDbException {
        return AgencyPluginUtils.openPluginCollection(ImmoToolApp.getApplication().getDatabase(), string);
    }

    public static Collection openPluginCollection(ImmoToolDb immoToolDb, String string) throws ImmoToolDbException {
        return immoToolDb.openCollection("ImmoTool/OpenEstate-Agency" + string);
    }

    public static void prepareListCellRenderer(JLabel jLabel, JList jList, AgencyEstate.Row row, int n, boolean bl, boolean bl2) {
        String string = ImmoToolUtils.getResourceMap(AgencyPluginUtils.class).getString("label.selectEstate", new Object[0]);
        AgencyPluginUtils.prepareListCellRenderer(jLabel, jList, row, n, bl, bl2, string);
    }

    public static void prepareListCellRenderer(JLabel jLabel, JList jList, AgencyEstate.Row row, int n, boolean bl, boolean bl2, String string) {
        jLabel.setOpaque(true);
        jLabel.setBackground(bl ? jList.getSelectionBackground() : (n % 2 == 0 ? Color.WHITE : ImmoToolUtils.TABLE_HIGHLIGHT_COLOR));
        jLabel.setForeground(bl ? jList.getSelectionForeground() : Color.BLACK);
        if (row == null) {
            jLabel.setText("<html><div style=\"margin:3px;\">[ " + string + " ]</div></html>");
        } else {
            String string2;
            String string3;
            String string4 = string3 = row.publicId != null ? row.publicId.trim() : "";
            if (string3.length() > 0) {
                string3 = " / " + StringEscapeUtils.escapeHtml((String)row.publicId);
            }
            String string5 = string2 = row.title != null ? row.title.trim() : "";
            if (string2.length() > 50) {
                string2 = string2.substring(0, 50) + "...";
            }
            jLabel.setText("<html><div style=\"margin:3px;\"><b>#" + row.id + string3 + "</b> | " + row.writeType() + " / " + row.writeAction() + "<br>" + "<font size=\"-1\"><i>" + StringEscapeUtils.escapeHtml((String)string2) + "</i></font>" + "</div></html>");
        }
    }

    public static void prepareListCellRenderer(JLabel jLabel, JList jList, AgencyContact.Row row, int n, boolean bl, boolean bl2) {
        String string = ImmoToolUtils.getResourceMap(AgencyPluginUtils.class).getString("label.selectContact", new Object[0]);
        AgencyPluginUtils.prepareListCellRenderer(jLabel, jList, row, n, bl, bl2, string);
    }

    public static void prepareListCellRenderer(JLabel jLabel, JList jList, AgencyContact.Row row, int n, boolean bl, boolean bl2, String string) {
        jLabel.setOpaque(true);
        jLabel.setBackground(bl ? jList.getSelectionBackground() : (n % 2 == 0 ? Color.WHITE : ImmoToolUtils.TABLE_HIGHLIGHT_COLOR));
        jLabel.setForeground(bl ? jList.getSelectionForeground() : Color.BLACK);
        if (row == null) {
            jLabel.setText("<html><div style=\"margin:3px;\">[ " + string + " ]</div></html>");
        } else {
            jLabel.setText("<html><div style=\"margin:3px;\"><b>#" + row.id + "</b> | " + StringEscapeUtils.escapeHtml((String)row.writePerson()) + "<br>" + "<font size=\"-1\"><i>" + StringEscapeUtils.escapeHtml((String)(row.writeAdressLine1().trim() + ", " + row.writeAdressLine2WithCountry().trim())) + "</i></font>" + "</div></html>");
        }
    }

    static {
        EXPORTS = AbstractExport.listAvailableExports();
        TRANSPORTS = AbstractTransport.listAvailableTransports();
    }
}

