/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.factories.Borders;
import com.openindex.openestate.impl.OpenEstateUtils;
import com.openindex.openestate.impl.SimpleAdressImpl;
import com.openindex.openestate.tool.ImmoToolDbException;
import com.openindex.openestate.tool.ImmoToolDbUtils;
import com.openindex.openestate.tool.ImmoToolTabPanel;
import com.openindex.openestate.tool.ImmoToolTask;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.agency.AgencyAgent;
import com.openindex.openestate.tool.agency.AgencyPlugin;
import com.openindex.openestate.tool.agency.AgencyPluginUtils;
import com.openindex.openestate.tool.utils.CountryObject;
import com.openindex.openestate.tool.utils.JAdressPanel;
import com.openindex.openestate.tool.utils.JImageFileChooser;
import com.openindex.openestate.tool.utils.ModificationHandler;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.print.Printable;
import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import javax.imageio.ImageIO;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.apache.commons.lang.SystemUtils;
import org.apache.log4j.Logger;
import org.fife.ui.rtextarea.RTextArea;
import org.jdesktop.application.Action;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.application.Task;
import org.jdesktop.swingx.JXImageView;
import org.jdesktop.swingx.JXTitledSeparator;
import org.xmldb.api.base.Collection;

public class AgencyProfilePanel
extends ImmoToolTabPanel {
    private static final Logger LOGGER = Logger.getLogger(AgencyProfilePanel.class);
    private ActionMap actionMap = null;
    private ResourceMap resourceMap = null;
    private AgencyAgent agent = null;
    private JPanel companyPanel;
    private JPanel detailsPanel;
    private JPanel logoPanel;
    private JAdressPanel companyAdressPanel;
    private JXImageView companyLogoViewer;
    private JButton companyLogoRemoveButton;
    private JButton companyLogoUpdateButton;
    private JXTitledSeparator companyPermissionTitle;
    private Map<Locale, RTextArea> detailsAgbFields;
    private JTabbedPane detailAgbTabPanel;
    private JTextField detailsAufsichtField;
    private RTextArea detailsGewerbeField;
    private JTextField detailsHandelsRegisterField;
    private JTextField detailsUstIdField;
    private JTextField detailsVertretungField;
    private ModificationHandler modifications;
    private boolean companyLogoModified = false;
    private File updatedLogoFile = null;
    private JButton closeButton;
    private JButton helpButton;
    private JButton submitButton;
    private JTabbedPane tabPanel;
    private JXTitledSeparator titleLabel;

    public AgencyProfilePanel() throws ImmoToolDbException {
        this.build();
    }

    private void build() {
        this.modifications = new ModificationHandler();
        this.actionMap = ImmoToolUtils.getActionMap(AgencyProfilePanel.class, (Object)((Object)this));
        this.resourceMap = ImmoToolUtils.getResourceMap(AgencyProfilePanel.class);
        this.initComponents();
        this.resourceMap.injectComponents((Component)((Object)this));
        this.companyPanel = this.buildCompanyPanel();
        this.resourceMap.injectComponents((Component)this.companyPanel);
        JScrollPane jScrollPane = new JScrollPane(this.companyPanel);
        jScrollPane.setBorder(Borders.EMPTY);
        this.tabPanel.add(this.resourceMap.getString("label.company", new Object[0]), jScrollPane);
        this.detailsPanel = this.buildDetailsPanel();
        this.resourceMap.injectComponents((Component)this.detailsPanel);
        JScrollPane jScrollPane2 = new JScrollPane(this.detailsPanel);
        jScrollPane2.setBorder(Borders.EMPTY);
        this.tabPanel.add(this.resourceMap.getString("label.details", new Object[0]), jScrollPane2);
        this.logoPanel = this.buildLogoPanel();
        this.resourceMap.injectComponents((Component)this.logoPanel);
        JScrollPane jScrollPane3 = new JScrollPane(this.logoPanel);
        jScrollPane3.setBorder(Borders.EMPTY);
        this.tabPanel.add(this.resourceMap.getString("label.logo", new Object[0]), jScrollPane3);
        this.submitButton.setAction(this.actionMap.get("doSubmit"));
        this.helpButton.setAction(this.actionMap.get("doHelp"));
        this.closeButton.setAction(this.actionMap.get("doClose"));
        this.companyLogoRemoveButton.setAction(this.actionMap.get("doLogoRemove"));
        this.companyLogoUpdateButton.setAction(this.actionMap.get("doLogoUpdate"));
        if (SystemUtils.IS_OS_MAC_OSX) {
            this.tabPanel.setTabPlacement(1);
        }
    }

    private JPanel buildCompanyPanel() {
        this.companyAdressPanel = new JAdressPanel(){

            protected void init() {
                this.registerValidation(this.adressStreetField);
                this.registerValidation(this.adressStreetNrField);
                this.registerValidation(this.adressCityField);
                this.registerValidation(this.adressPostalCodeField);
                this.registerValidation(this.personFirstNameField);
                this.registerValidation(this.personLastNameField);
                this.registerValidation(this.personMailField);
                this.registerValidation(this.personPhoneField);
                this.registerValidation(this.companyNameField);
                this.registerValidation(this.companyPhoneField);
                this.adressCountryField.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        CountryObject countryObject = (CountryObject)adressCountryField.getSelectedItem();
                        if (countryObject != null && "de".equalsIgnoreCase(countryObject.getCode())) {
                            AgencyProfilePanel.this.companyPermissionTitle.setTitle(AgencyProfilePanel.this.resourceMap.getString("label.details.gewerbe34c", new Object[0]));
                        } else {
                            AgencyProfilePanel.this.companyPermissionTitle.setTitle(AgencyProfilePanel.this.resourceMap.getString("label.details.gewerbe", new Object[0]));
                        }
                    }
                });
            }
        };
        DefaultFormBuilder defaultFormBuilder = ImmoToolUtils.createFormBuilder((String)"pref:grow");
        defaultFormBuilder.border(Borders.DIALOG);
        defaultFormBuilder.append((Component)this.companyAdressPanel);
        defaultFormBuilder.nextLine();
        return defaultFormBuilder.getPanel();
    }

    private JPanel buildDetailsPanel() {
        this.detailsAufsichtField = new JTextField();
        this.detailsAufsichtField.setName("detailsAufsichtField");
        this.detailsHandelsRegisterField = new JTextField();
        this.detailsHandelsRegisterField.setName("detailsHandelsRegisterField");
        this.detailsUstIdField = new JTextField();
        this.detailsUstIdField.setName("detailsUstIdField");
        this.detailsVertretungField = new JTextField();
        this.detailsVertretungField.setName("detailsVertretungField");
        this.detailAgbTabPanel = new JTabbedPane();
        this.detailAgbTabPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, 15, 10, 15), this.detailAgbTabPanel.getBorder()));
        this.detailsAgbFields = new HashMap<Locale, RTextArea>();
        TreeMap<String, Locale> treeMap = new TreeMap<String, Locale>();
        for (Locale serializable2 : AgencyPlugin.getLocales()) {
            treeMap.put(serializable2.getDisplayLanguage(), serializable2);
        }
        for (Locale locale : treeMap.values()) {
            final RTextArea rTextArea = new RTextArea();
            rTextArea.setName("detailsAgbField");
            rTextArea.setLineWrap(true);
            rTextArea.setWrapStyleWord(true);
            JScrollPane jScrollPane = new JScrollPane((Component)rTextArea);
            jScrollPane.getVerticalScrollBar().setUnitIncrement(20);
            jScrollPane.setPreferredSize(new Dimension(50, 50));
            this.detailsAgbFields.put(locale, rTextArea);
            this.detailAgbTabPanel.addTab(locale.getDisplayLanguage(), OpenEstateUtils.getFlagIcon((Locale)locale), jScrollPane);
            JMenuItem jMenuItem = new JMenuItem("Print");
            jMenuItem.setName("printItem");
            jMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    try {
                        ImmoToolUtils.print((Printable)rTextArea);
                    }
                    catch (Exception exception) {
                        LOGGER.error((Object)"Printing failed!");
                        LOGGER.error((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
                        ImmoToolUtils.showMessageErrorDialog((String)"Printing failed!", (Throwable)exception);
                    }
                }
            });
            this.resourceMap.injectComponent((Component)jMenuItem);
            rTextArea.getPopupMenu().add(jMenuItem);
        }
        this.companyPermissionTitle = ImmoToolUtils.createHead2Separator((String)this.resourceMap.getString("label.details.gewerbe", new Object[0]));
        this.detailsGewerbeField = new RTextArea();
        this.detailsGewerbeField.setName("detailsGewerbeField");
        this.detailsGewerbeField.setLineWrap(true);
        this.detailsGewerbeField.setWrapStyleWord(true);
        this.detailsGewerbeField.setPreferredSize(new Dimension(75, 75));
        JMenuItem jMenuItem = new JMenuItem("Print");
        jMenuItem.setName("printItem");
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    ImmoToolUtils.print((Printable)AgencyProfilePanel.this.detailsGewerbeField);
                }
                catch (Exception exception) {
                    LOGGER.error((Object)"Printing failed!");
                    LOGGER.error((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
                    ImmoToolUtils.showMessageErrorDialog((String)"Printing failed!", (Throwable)exception);
                }
            }
        });
        this.resourceMap.injectComponent((Component)jMenuItem);
        this.detailsGewerbeField.getPopupMenu().add(jMenuItem);
        DefaultFormBuilder defaultFormBuilder = ImmoToolUtils.createFormBuilder((String)"right:pref, 3dlu, 30dlu:grow");
        defaultFormBuilder.border(BorderFactory.createEmptyBorder(10, 15, 5, 15));
        defaultFormBuilder.append((Component)ImmoToolUtils.createHead2Separator((String)this.resourceMap.getString("label.details.impressum", new Object[0])), 3);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(this.resourceMap.getString("label.details.aufsicht", new Object[0]), (Component)this.detailsAufsichtField);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(this.resourceMap.getString("label.details.handelsregister", new Object[0]), (Component)this.detailsHandelsRegisterField);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(this.resourceMap.getString("label.details.ustId", new Object[0]), (Component)this.detailsUstIdField);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(this.resourceMap.getString("label.details.vertretung", new Object[0]), (Component)this.detailsVertretungField);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append((Component)new JLabel(" "), 3);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append((Component)this.companyPermissionTitle, 3);
        defaultFormBuilder.nextLine();
        JScrollPane jScrollPane = new JScrollPane((Component)this.detailsGewerbeField);
        jScrollPane.setPreferredSize(new Dimension(jScrollPane.getPreferredSize().width, 75));
        defaultFormBuilder.append((Component)jScrollPane, 3);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append((Component)new JLabel(" "), 3);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append((Component)ImmoToolUtils.createHead2Separator((String)this.resourceMap.getString("label.details.terms", new Object[0])), 3);
        defaultFormBuilder.nextLine();
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setOpaque(false);
        jPanel.add((Component)defaultFormBuilder.getPanel(), "North");
        jPanel.add((Component)this.detailAgbTabPanel, "Center");
        return jPanel;
    }

    private JPanel buildLogoPanel() {
        this.companyLogoViewer = new JXImageView();
        this.companyLogoViewer.setName("companyLogoViewer");
        this.companyLogoRemoveButton = new JButton();
        this.companyLogoRemoveButton.setName("companyLogoRemoveButton");
        this.companyLogoUpdateButton = new JButton();
        this.companyLogoUpdateButton.setName("companyLogoUpdateButton");
        this.companyLogoUpdateButton.setEnabled(false);
        DefaultFormBuilder defaultFormBuilder = ImmoToolUtils.createFormBuilder((String)"pref:grow, 3dlu, pref");
        defaultFormBuilder.border(Borders.DIALOG);
        defaultFormBuilder.append((Component)ImmoToolUtils.createHead2Separator((String)this.resourceMap.getString("label.logo.selected", new Object[0])));
        defaultFormBuilder.append((Component)ImmoToolUtils.buildButtonBar((JButton[])new JButton[]{this.companyLogoUpdateButton, this.companyLogoRemoveButton}));
        defaultFormBuilder.nextLine();
        JScrollPane jScrollPane = new JScrollPane((Component)this.companyLogoViewer);
        jScrollPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, 15, 10, 15), jScrollPane.getBorder()));
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)defaultFormBuilder.getPanel(), "North");
        jPanel.add((Component)jScrollPane, "Center");
        jPanel.revalidate();
        jPanel.repaint();
        return jPanel;
    }

    @Action
    public void doClose() {
        ImmoToolUtils.removePanel((String)this.getTabTitle());
    }

    @Action
    public void doHelp() {
        ImmoToolUtils.showHelpDialog((String)"agency.profile");
    }

    @Action
    public void doLogoRemove() {
        this.updatedLogoFile = null;
        this.companyLogoViewer.setImage((Image)null);
        this.companyLogoModified = true;
    }

    @Action
    public Task doLogoUpdate() {
        int n;
        File file = AgencyPlugin.getLastImageLocation();
        JImageFileChooser jImageFileChooser = new JImageFileChooser();
        jImageFileChooser.setDialogTitle(this.resourceMap.getString("message.selectLogoFile", new Object[0]));
        jImageFileChooser.setApproveButtonText(this.resourceMap.getString("message.selectLogoFile.use", new Object[0]));
        jImageFileChooser.setImageReadingFilter();
        jImageFileChooser.setMultiSelectionEnabled(false);
        if (file != null) {
            jImageFileChooser.setSelectedFile(new File(file.getAbsolutePath() + File.separator + "."));
        }
        if ((n = jImageFileChooser.showOpenDialog((Component)((Object)this))) != 0) {
            return null;
        }
        final File file2 = jImageFileChooser.getSelectedFile();
        AgencyPlugin.setLastImageLocation(file2.getParentFile());
        return new ImmoToolTask<Image>(this.resourceMap.getString("doLogoUpdate.Action.text", new Object[0])){

            protected Image executeTask() throws Exception {
                BufferedImage bufferedImage = ImageIO.read(file2);
                int n = AgencyPlugin.getImgMaxWidth();
                int n2 = AgencyPlugin.getImgMaxHeight();
                if (bufferedImage.getHeight(null) > n2 || bufferedImage.getWidth(null) > n) {
                    BufferedImage bufferedImage2 = ImmoToolUtils.scaleImageAndKeepRatio((BufferedImage)bufferedImage, (int)n, (int)n2);
                    bufferedImage.flush();
                    bufferedImage = bufferedImage2;
                }
                return bufferedImage;
            }

            protected void failed(Throwable throwable) {
                super.failed(throwable);
                ImmoToolUtils.showMessageErrorDialog((String)AgencyProfilePanel.this.resourceMap.getString("error.cantLoadLogo", new Object[0]), (Throwable)throwable);
            }

            protected void succeeded(Image image) {
                super.succeeded((Object)image);
                AgencyProfilePanel.this.updatedLogoFile = file2;
                AgencyProfilePanel.this.companyLogoViewer.setImage(image);
                AgencyProfilePanel.this.companyLogoModified = true;
            }
        };
    }

    @Action
    public Task doSubmit() {
        if (!this.companyAdressPanel.isValidInput()) {
            ImmoToolUtils.showMessageErrorDialog((String)this.resourceMap.getString("error.invalidCompanyInput", new Object[0]));
            return null;
        }
        final AgencyProfilePanel agencyProfilePanel = this;
        return new ImmoToolTask<Boolean>(this.resourceMap.getString("doSubmit.Action.text", new Object[0])){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected Boolean executeTask() throws Exception {
                Collection collection = null;
                try {
                    collection = AgencyPluginUtils.openPluginCollection("");
                    this.setMessage(AgencyProfilePanel.this.resourceMap.getString("message.doSaveInput", new Object[0]));
                    AgencyProfilePanel.this.companyAdressPanel.saveAdress((SimpleAdressImpl)AgencyProfilePanel.this.agent.getCompany());
                    AgencyProfilePanel.this.agent.setAufsichtsBehoerde(AgencyProfilePanel.this.detailsAufsichtField.getText().trim());
                    AgencyProfilePanel.this.agent.setGewerbeErlaubnis(AgencyProfilePanel.this.detailsGewerbeField.getText().trim());
                    AgencyProfilePanel.this.agent.setHandelsRegister(AgencyProfilePanel.this.detailsHandelsRegisterField.getText().trim());
                    AgencyProfilePanel.this.agent.setUstId(AgencyProfilePanel.this.detailsUstIdField.getText().trim());
                    AgencyProfilePanel.this.agent.setVertretung(AgencyProfilePanel.this.detailsVertretungField.getText().trim());
                    for (Locale locale : AgencyProfilePanel.this.detailsAgbFields.keySet()) {
                        String string = ((RTextArea)AgencyProfilePanel.this.detailsAgbFields.get(locale)).getText().trim();
                        AgencyProfilePanel.this.agent.setTerms(string, locale.getLanguage());
                    }
                    this.setMessage(AgencyProfilePanel.this.resourceMap.getString("message.doSaveAgent", new Object[0]));
                    AgencyAgent.storeAgent(AgencyProfilePanel.this.agent, collection);
                    if (AgencyProfilePanel.this.companyLogoModified) {
                        this.setMessage(AgencyProfilePanel.this.resourceMap.getString("message.doSaveAgentLogo", new Object[0]));
                        AgencyAgent.storeLogo(AgencyProfilePanel.this.updatedLogoFile, collection);
                    }
                    Boolean bl = true;
                    return bl;
                }
                finally {
                    ImmoToolDbUtils.close((Collection)collection);
                }
            }

            protected void failed(Throwable throwable) {
                super.failed(throwable);
                ImmoToolUtils.showMessageErrorDialog((String)AgencyProfilePanel.this.resourceMap.getString("error.cantSaveAgent", new Object[0]), (Throwable)throwable);
            }

            protected void succeeded(Boolean bl) {
                super.succeeded((Object)bl);
                AgencyProfilePanel.this.refreshTab();
                ImmoToolUtils.showMessageInfoDialog((String)AgencyProfilePanel.this.resourceMap.getString("message.agentSaved", new Object[0]), (Component)((Object)agencyProfilePanel));
            }
        };
    }

    public static String getInstanceTabTitle() {
        return ImmoToolUtils.getResourceMap(AgencyProfilePanel.class).getString("tabTitle", new Object[0]);
    }

    public String getTabInfo() {
        return this.resourceMap.getString("tabInfo", new Object[0]);
    }

    public String getTabTitle() {
        return AgencyProfilePanel.getInstanceTabTitle();
    }

    public boolean isTabModified() {
        return this.modifications.isModified() || this.companyAdressPanel.isModifiedInput() || this.companyLogoModified;
    }

    public void loadAgent(AgencyAgent agencyAgent, Image image) {
        this.companyLogoModified = false;
        this.modifications.clear();
        this.agent = agencyAgent;
        this.companyAdressPanel.loadAdress((SimpleAdressImpl)this.agent.getCompany());
        this.companyAdressPanel.validateInputs();
        this.companyLogoViewer.setImage(image != null ? image : null);
        this.detailsAufsichtField.setText(this.agent.getAufsichtsBehoerde());
        this.detailsGewerbeField.setText(this.agent.getGewerbeErlaubnis());
        this.detailsHandelsRegisterField.setText(this.agent.getHandelsRegister());
        this.detailsUstIdField.setText(this.agent.getUstId());
        this.detailsVertretungField.setText(this.agent.getVertretung());
        Iterator<Locale> iterator = this.detailsAgbFields.keySet().iterator();
        while (iterator.hasNext()) {
            String string;
            Locale locale;
            this.detailsAgbFields.get(locale).setText((string = this.agent.getTerms((locale = iterator.next()).getLanguage())) != null ? string.trim() : "");
            this.detailsAgbFields.get(locale).setCaretPosition(0);
            this.modifications.putValue((JComponent)this.detailsAgbFields.get(locale));
        }
        this.modifications.putValue((JComponent)this.detailsAufsichtField);
        this.modifications.putValue((JComponent)this.detailsGewerbeField);
        this.modifications.putValue((JComponent)this.detailsHandelsRegisterField);
        this.modifications.putValue((JComponent)this.detailsUstIdField);
        this.modifications.putValue((JComponent)this.detailsVertretungField);
    }

    public void refreshTab() {
        ImmoToolTask<Boolean> immoToolTask = new ImmoToolTask<Boolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected Boolean executeTask() throws Exception {
                Collection collection = null;
                try {
                    collection = AgencyPluginUtils.openPluginCollection("");
                    AgencyProfilePanel.this.loadAgent(AgencyAgent.loadAgent(collection), AgencyAgent.loadLogo(collection));
                    Boolean bl = true;
                    return bl;
                }
                finally {
                    ImmoToolDbUtils.close((Collection)collection);
                }
            }

            protected void failed(Throwable throwable) {
                super.failed(throwable);
                ImmoToolUtils.showMessageErrorDialog((String)AgencyProfilePanel.this.resourceMap.getString("error.cantRefreshAgent", new Object[0]), (Throwable)throwable);
            }

            protected void finished() {
                AgencyProfilePanel.this.setButtonsEnabled(true);
            }
        };
        this.setButtonsEnabled(false);
        ImmoToolUtils.executeTask((Task)immoToolTask);
    }

    public ImmoToolTask saveModifications() {
        return (ImmoToolTask)this.doSubmit();
    }

    private void setButtonsEnabled(boolean bl) {
        this.submitButton.setEnabled(bl);
        this.closeButton.setEnabled(bl);
    }

    private void initComponents() {
        this.titleLabel = ImmoToolUtils.createHead1Separator((String)"");
        this.submitButton = new JButton();
        this.helpButton = new JButton();
        this.closeButton = new JButton();
        this.tabPanel = new JTabbedPane();
        this.titleLabel.setName("titleLabel");
        this.titleLabel.setTitle("titleLabel");
        this.submitButton.setText("doSubmit");
        this.submitButton.setName("submitButton");
        this.helpButton.setText("doHelp");
        this.helpButton.setName("helpButton");
        this.closeButton.setText("doClose");
        this.closeButton.setName("closeButton");
        this.tabPanel.setTabPlacement(2);
        this.tabPanel.setName("tabPanel");
        GroupLayout groupLayout = new GroupLayout((Container)((Object)this));
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.tabPanel, GroupLayout.Alignment.LEADING, -1, 845, Short.MAX_VALUE).addGroup(groupLayout.createSequentialGroup().addComponent((Component)this.titleLabel, -1, 545, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.submitButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.helpButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.closeButton))).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.closeButton).addComponent(this.helpButton).addComponent(this.submitButton)).addComponent((Component)this.titleLabel, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.tabPanel, -1, 411, Short.MAX_VALUE).addContainerGap()));
    }
}

