/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.openindex.openestate.tool.ImmoToolException;
import com.openindex.openestate.tool.ImmoToolSetupPanel;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.agency.AgencyPlugin;
import com.openindex.openestate.tool.utils.FormatterRule;
import com.openindex.openestate.tool.utils.RegexFormatter;
import com.openindex.openestate.tool.utils.ValidationHandler;
import com.openindex.openestate.tool.utils.ValidationRule;
import java.awt.Component;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.apache.commons.lang.SystemUtils;
import org.jdesktop.application.ResourceMap;

public class AgencySetupGeneralPanel
extends ImmoToolSetupPanel {
    private ResourceMap resourceMap = ImmoToolUtils.getResourceMap(AgencySetupGeneralPanel.class);
    private ValidationHandler validationHandler = ImmoToolUtils.createValidationHandler();
    private JFormattedTextField imgMaxHeightField = null;
    private JFormattedTextField imgMaxWidthField = null;
    private JComboBox imgFormatBox = null;
    private JCheckBox imgForceFormatBox = null;

    public AgencySetupGeneralPanel() {
        this.buildForm();
        this.resourceMap.injectComponents((Component)((Object)this));
        if (SystemUtils.IS_OS_MAC_OSX) {
            // empty if block
        }
    }

    private void buildForm() {
        this.imgMaxHeightField = new JFormattedTextField((JFormattedTextField.AbstractFormatter)new RegexFormatter("\\d{1,4}"));
        this.imgMaxHeightField.setName("imgMaxHeightField");
        this.imgMaxWidthField = new JFormattedTextField((JFormattedTextField.AbstractFormatter)new RegexFormatter("\\d{1,4}"));
        this.imgMaxWidthField.setName("imgMaxWidthField");
        this.imgFormatBox = new JComboBox();
        this.imgFormatBox.setName("imgFormatBox");
        this.imgFormatBox.setRenderer(new ImageFormatRenderer());
        this.imgFormatBox.addItem("JPG");
        this.imgFormatBox.addItem("PNG");
        this.imgForceFormatBox = new JCheckBox();
        this.imgForceFormatBox.setName("imgForceFormatBox");
        this.imgForceFormatBox.setOpaque(false);
        this.validationHandler.putRule((JComponent)this.imgMaxHeightField, (ValidationRule)new FormatterRule(this.imgMaxHeightField));
        this.validationHandler.putRule((JComponent)this.imgMaxWidthField, (ValidationRule)new FormatterRule(this.imgMaxHeightField));
        DefaultFormBuilder defaultFormBuilder = ImmoToolUtils.createFormBuilder((String)"right:[40dlu,pref], 3dlu, 30dlu:grow, 3dlu, right:pref, 3dlu, 30dlu:grow", (JPanel)((Object)this));
        defaultFormBuilder.append((Component)ImmoToolUtils.createHead2Separator((String)this.resourceMap.getString("label.imgMax", new Object[0])), 7);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append((Component)new JLabel(this.resourceMap.getString("info.imgMax", new Object[0])), 7);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(this.resourceMap.getString("label.imgMaxWidthField", new Object[0]), (Component)this.imgMaxWidthField);
        defaultFormBuilder.append(this.resourceMap.getString("label.imgMaxHeightField", new Object[0]), (Component)this.imgMaxHeightField);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append((Component)new JLabel(" "), 7);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append((Component)ImmoToolUtils.createHead2Separator((String)this.resourceMap.getString("label.imgFormat", new Object[0])), 7);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append((Component)new JLabel(this.resourceMap.getString("info.imgFormat", new Object[0])), 7);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(this.resourceMap.getString("label.imgFormatBox", new Object[0]), (Component)this.imgFormatBox);
        defaultFormBuilder.append((Component)this.imgForceFormatBox, 3);
        defaultFormBuilder.nextLine();
        this.revalidate();
        this.repaint();
    }

    public void doLoad() throws ImmoToolException {
        this.imgMaxWidthField.setValue(AgencyPlugin.getImgMaxWidth());
        this.imgMaxHeightField.setValue(AgencyPlugin.getImgMaxHeight());
        this.imgFormatBox.setSelectedItem(AgencyPlugin.getImgDefaultFormat());
        this.imgForceFormatBox.setSelected(AgencyPlugin.isImgFormatForced());
        this.validationHandler.init();
    }

    public void doSave() throws ImmoToolException {
        AgencyPlugin.setImgMaxHeight(Integer.valueOf(this.imgMaxHeightField.getText()));
        AgencyPlugin.setImgMaxWidth(Integer.valueOf(this.imgMaxWidthField.getText()));
        AgencyPlugin.setImgDefaultFormat((String)this.imgFormatBox.getSelectedItem());
        AgencyPlugin.setImgFormatForced(this.imgForceFormatBox.isSelected());
    }

    public boolean doValidate() {
        this.validationHandler.validate();
        return this.validationHandler.isValid();
    }

    public String getTitle() {
        return this.resourceMap.getString("panelTitle", new Object[0]);
    }

    private static class ImageFormatRenderer
    extends JLabel
    implements ListCellRenderer {
        public ImageFormatRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            this.setBackground(bl ? jList.getSelectionBackground() : jList.getBackground());
            this.setForeground(bl ? jList.getSelectionForeground() : jList.getForeground());
            if (object instanceof String) {
                String string = (String)object;
                this.setText(" " + string);
            } else {
                this.setText("");
            }
            return this;
        }
    }
}

