/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.openindex.openestate.impl.GeoImpl;
import com.openindex.openestate.impl.OpenEstateUtils;
import com.openindex.openestate.tool.ImmoToolException;
import com.openindex.openestate.tool.ImmoToolSetupPanel;
import com.openindex.openestate.tool.ImmoToolTask;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.agency.utils.GeoDb;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.apache.commons.lang.SystemUtils;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.jdesktop.application.Action;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.application.Task;
import org.jdesktop.swingx.JXTable;

public class AgencySetupGeoPanel
extends ImmoToolSetupPanel {
    private static final Logger LOGGER = Logger.getLogger(AgencySetupGeoPanel.class);
    private static final int COLUMN_GEODB = 0;
    private static final int COLUMN_PROVIDER = 1;
    private static final int COLUMN_BUILDTIME = 2;
    private ActionMap actionMap = null;
    private ResourceMap resourceMap = null;
    private JXTable geoDbTable;
    private GeoTableModel geoDbTableModel;
    private JButton importGeoDbButton = null;
    private JButton removeGeoDbButton = null;
    private Map<String, GeoDb> importedGeoDbs = null;

    public AgencySetupGeoPanel() {
        this.build();
    }

    private void build() {
        this.setName("AgencySetupGeoPanel");
        this.actionMap = ImmoToolUtils.getActionMap((Object)((Object)this));
        this.resourceMap = ImmoToolUtils.getResourceMap(AgencySetupGeoPanel.class);
        this.importedGeoDbs = new HashMap<String, GeoDb>();
        this.buildForm();
        this.resourceMap.injectComponents((Component)((Object)this));
        if (SystemUtils.IS_OS_MAC_OSX) {
            // empty if block
        }
    }

    private void buildForm() {
        this.importGeoDbButton = new JButton();
        this.importGeoDbButton.setName("importGeoDbButton");
        this.importGeoDbButton.setAction(this.actionMap.get("doImportGeoDb"));
        this.removeGeoDbButton = new JButton();
        this.removeGeoDbButton.setName("removeGeoDbButton");
        this.removeGeoDbButton.setAction(this.actionMap.get("doRemoveGeoDb"));
        JPanel jPanel = new JPanel(new FlowLayout());
        jPanel.setOpaque(false);
        jPanel.add(this.importGeoDbButton);
        jPanel.add(this.removeGeoDbButton);
        this.geoDbTableModel = new GeoTableModel();
        this.geoDbTable = new JXTable();
        ImmoToolUtils.configureTable((JXTable)this.geoDbTable);
        this.geoDbTable.setModel((TableModel)this.geoDbTableModel);
        this.geoDbTable.setColumnControlVisible(false);
        this.geoDbTable.setDefaultRenderer(GeoDb.class, (TableCellRenderer)new GeoDbRenderer());
        this.geoDbTable.setDefaultRenderer(Date.class, (TableCellRenderer)new DateRenderer());
        this.geoDbTable.setEditable(true);
        this.geoDbTable.setSortable(false);
        this.geoDbTable.getSelectionModel().setSelectionMode(0);
        JScrollPane jScrollPane = new JScrollPane((Component)this.geoDbTable);
        jScrollPane.setBorder(BorderFactory.createLineBorder(Color.GRAY, 1));
        DefaultFormBuilder defaultFormBuilder = ImmoToolUtils.createFormBuilder((String)"pref:grow, 3dlu, pref");
        defaultFormBuilder.append((Component)ImmoToolUtils.createHead2Separator((String)this.resourceMap.getString("title.geodb", new Object[0])));
        defaultFormBuilder.append((Component)jPanel);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append((Component)new JLabel(this.resourceMap.getString("label.geodb", new Object[0])), 3);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append((Component)new JLabel(" "), 3);
        defaultFormBuilder.nextLine();
        this.setLayout(new BorderLayout());
        this.add(defaultFormBuilder.getPanel(), "North");
        this.add(jScrollPane, "Center");
    }

    @Action
    public Task doImportGeoDb() {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setDialogTitle(this.resourceMap.getString("label.importGeoDbFile", new Object[0]));
        jFileChooser.setApproveButtonText(this.resourceMap.getString("label.importGeoDbFile.select", new Object[0]));
        jFileChooser.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory() || file.getName().toLowerCase().endsWith(".xml");
            }

            @Override
            public String getDescription() {
                return AgencySetupGeoPanel.this.resourceMap.getString("label.importGeoDbFile.filter", new Object[]{"*.xml"});
            }
        });
        int n = jFileChooser.showSaveDialog((Component)((Object)this));
        if (n != 0) {
            return null;
        }
        final File file = jFileChooser.getSelectedFile();
        AgencySetupGeoPanel agencySetupGeoPanel = this;
        return new ImmoToolTask<File>((JPanel)((Object)agencySetupGeoPanel)){
            private GeoDb geoDb;
            private int overwriteTableRow = -1;
            final /* synthetic */ JPanel val$panel;
            {
                this.val$panel = jPanel;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected File executeTask() throws Exception {
                Object object;
                GeoImpl geoImpl = new GeoImpl();
                FileInputStream fileInputStream = null;
                try {
                    fileInputStream = new FileInputStream(file);
                    object = OpenEstateUtils.loadDocument((InputStream)fileInputStream);
                    geoImpl.readFromXmlNonRecursive((Document)object);
                }
                finally {
                    if (fileInputStream != null) {
                        fileInputStream.close();
                    }
                }
                if (geoImpl.getName() == null || geoImpl.getProvider() == null) {
                    throw new Exception("Can't read geo.xml!");
                }
                this.geoDb = new GeoDb();
                this.geoDb.setBuildTime(geoImpl.getBuildTime());
                this.geoDb.setName(geoImpl.getName());
                this.geoDb.setProvider(geoImpl.getProvider());
                this.overwriteTableRow = AgencySetupGeoPanel.this.hasGeoDb(this.geoDb.getName());
                if (this.overwriteTableRow >= 0 && !ImmoToolUtils.showQuestionDialog((String)(object = AgencySetupGeoPanel.this.resourceMap.getString("question.overwriteGeoDbFile", new Object[]{this.geoDb.getName()})), (Component)this.val$panel)) {
                    return null;
                }
                try {
                    fileInputStream = new FileInputStream(file);
                    object = File.createTempFile("geo", ".xml");
                    ((File)object).deleteOnExit();
                    ImmoToolUtils.writeStreamToFile((InputStream)fileInputStream, (File)object);
                    Object object2 = object;
                    return object2;
                }
                finally {
                    if (fileInputStream != null) {
                        fileInputStream.close();
                    }
                }
            }

            protected void failed(Throwable throwable) {
                super.failed(throwable);
                ImmoToolUtils.showMessageErrorDialog((String)("<html><b>" + AgencySetupGeoPanel.this.resourceMap.getString("label.importGeoDbFile.error", new Object[0]) + "</b>" + "<br>" + throwable.getLocalizedMessage() + "</html>"), (Component)this.val$panel);
            }

            protected void succeeded(File file2) {
                super.succeeded((Object)file2);
                if (file2 != null) {
                    AgencySetupGeoPanel.this.importedGeoDbs.put(file2.getAbsolutePath(), this.geoDb);
                    if (this.overwriteTableRow < 0) {
                        AgencySetupGeoPanel.this.geoDbTableModel.addGeoDb(this.geoDb);
                    } else {
                        AgencySetupGeoPanel.this.geoDbTableModel.setValueAt(this.geoDb, this.overwriteTableRow, 0);
                        AgencySetupGeoPanel.this.geoDbTableModel.setValueAt(this.geoDb.getBuildTime(), this.overwriteTableRow, 2);
                        AgencySetupGeoPanel.this.geoDbTableModel.setValueAt(this.geoDb.getProvider(), this.overwriteTableRow, 1);
                    }
                    AgencySetupGeoPanel.this.geoDbTable.packAll();
                }
            }
        };
    }

    public void doLoad() throws ImmoToolException {
        this.importedGeoDbs.clear();
        this.geoDbTableModel.clear();
        for (GeoDb geoDb : GeoDb.loadGeoDbs()) {
            this.geoDbTableModel.addGeoDb(geoDb);
        }
        this.geoDbTable.packAll();
    }

    @Action
    public void doRemoveGeoDb() {
        int n = this.geoDbTable.getSelectedRow();
        if (n < 0) {
            return;
        }
        String string = this.geoDbTableModel.getGeoDbAt(n).getName();
        String string2 = null;
        for (String string3 : this.importedGeoDbs.keySet()) {
            GeoDb geoDb = this.importedGeoDbs.get(string3);
            if (!geoDb.getName().equals(string)) continue;
            string2 = string3;
            File file = new File(string3);
            if (!file.isFile() || file.delete()) break;
            LOGGER.warn((Object)("Can't delete: " + file.getAbsolutePath()));
            break;
        }
        if (string2 != null) {
            this.importedGeoDbs.remove(string2);
        }
        this.geoDbTableModel.removeRow(n);
        this.geoDbTable.packAll();
    }

    public void doSave() throws ImmoToolException {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : this.importedGeoDbs.keySet()) {
            LOGGER.debug((Object)"save geoDb");
            GeoDb geoDb = this.importedGeoDbs.get(string);
            LOGGER.debug((Object)("> " + geoDb.getName()));
            File object = new File(string);
            LOGGER.debug((Object)("> " + object.getAbsolutePath()));
            if (!object.isFile()) continue;
            GeoDb.storeGeoDb(geoDb.getName(), object);
            arrayList.add(geoDb.getName());
        }
        for (GeoDb geoDb : GeoDb.loadGeoDbs()) {
            if (this.hasGeoDb(geoDb.getName()) >= 0) continue;
            LOGGER.debug((Object)"remove geoDb");
            LOGGER.debug((Object)("> " + geoDb.getName()));
            GeoDb.removeGeoDb(geoDb.getName());
        }
        GeoDb.clearCaches();
    }

    public boolean doValidate() {
        return true;
    }

    public String getTitle() {
        return this.resourceMap.getString("panelTitle", new Object[0]);
    }

    private int hasGeoDb(String string) {
        for (int i = 0; i < this.geoDbTableModel.getRowCount(); ++i) {
            GeoDb geoDb = this.geoDbTableModel.getGeoDbAt(i);
            if (!geoDb.getName().equals(string)) continue;
            return i;
        }
        return -1;
    }

    private static class DateRenderer
    extends JLabel
    implements TableCellRenderer {
        private DateFormat dateFormat = null;

        public DateRenderer() {
            this.setOpaque(true);
            this.dateFormat = DateFormat.getDateTimeInstance(2, 3);
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.setBackground(bl ? jTable.getSelectionBackground() : jTable.getBackground());
            this.setForeground(bl ? jTable.getSelectionForeground() : jTable.getForeground());
            if (object instanceof Date) {
                Date date = (Date)object;
                this.setText(this.dateFormat.format(date));
            } else {
                this.setText("");
                this.setIcon(null);
            }
            return this;
        }
    }

    private static class GeoDbRenderer
    extends JLabel
    implements TableCellRenderer {
        public GeoDbRenderer() {
            this.setOpaque(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.setBackground(bl ? jTable.getSelectionBackground() : jTable.getBackground());
            this.setForeground(bl ? jTable.getSelectionForeground() : jTable.getForeground());
            if (object instanceof GeoDb) {
                GeoDb geoDb = (GeoDb)object;
                this.setText(geoDb.getName());
            } else {
                this.setText("");
                this.setIcon(null);
            }
            return this;
        }
    }

    private class GeoTableModel
    extends DefaultTableModel {
        private Map<Integer, String> COLUMN_NAMES = new HashMap<Integer, String>();
        private Map<Integer, Class> COLUMN_CLASSES;

        public GeoTableModel() {
            this.COLUMN_NAMES.put(0, "col.name");
            this.COLUMN_NAMES.put(1, "col.provider");
            this.COLUMN_NAMES.put(2, "col.buildTime");
            this.COLUMN_CLASSES = new HashMap<Integer, Class>();
            this.COLUMN_CLASSES.put(0, GeoDb.class);
            this.COLUMN_CLASSES.put(1, String.class);
            this.COLUMN_CLASSES.put(2, Date.class);
            this.setColumnCount(this.COLUMN_NAMES.size());
        }

        public void addGeoDb(GeoDb geoDb) {
            this.addRow(this.buildRow(geoDb));
        }

        private Object[] buildRow(GeoDb geoDb) {
            TreeMap<Integer, Object> treeMap = new TreeMap<Integer, Object>();
            treeMap.put(0, geoDb);
            treeMap.put(1, geoDb.getProvider());
            treeMap.put(2, geoDb.getBuildTime());
            return treeMap.values().toArray(new Object[treeMap.size()]);
        }

        public void clear() {
            while (this.getRowCount() > 0) {
                this.removeRow(0);
            }
        }

        public Class getColumnClass(int n) {
            return this.COLUMN_CLASSES.containsKey(n) ? this.COLUMN_CLASSES.get(n) : null;
        }

        @Override
        public String getColumnName(int n) {
            return this.COLUMN_NAMES.containsKey(n) ? AgencySetupGeoPanel.this.resourceMap.getString(this.COLUMN_NAMES.get(n), new Object[0]) : null;
        }

        public GeoDb getGeoDbAt(int n) {
            int n2 = n;
            return (GeoDb)this.getValueAt(n2, 0);
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }
    }
}

