/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.openindex.openestate.impl.OpenEstateTranslator;
import com.openindex.openestate.impl.OpenEstateUtils;
import com.openindex.openestate.tool.ImmoToolException;
import com.openindex.openestate.tool.ImmoToolSetupPanel;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.agency.AgencyPlugin;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.apache.commons.lang.SystemUtils;
import org.apache.log4j.Logger;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.swingx.JXTable;

public class AgencySetupLanguagePanel
extends ImmoToolSetupPanel {
    private static final Logger LOGGER = Logger.getLogger(AgencySetupLanguagePanel.class);
    private static final int COLUMN_ENABLED = 0;
    private static final int COLUMN_LANGUAGE = 1;
    private final Map<String, ImageIcon> flags = new HashMap<String, ImageIcon>();
    private ResourceMap resourceMap = null;
    private JXTable languageTable;
    private LanguageTableModel languageTableModel;

    public AgencySetupLanguagePanel() {
        this.setName("AgencySetupLanguagePanel");
        this.resourceMap = ImmoToolUtils.getResourceMap(AgencySetupLanguagePanel.class);
        this.buildForm();
        this.resourceMap.injectComponents((Component)((Object)this));
        if (SystemUtils.IS_OS_MAC_OSX) {
            // empty if block
        }
    }

    private void buildForm() {
        this.languageTableModel = new LanguageTableModel();
        this.languageTable = new JXTable();
        ImmoToolUtils.configureTable((JXTable)this.languageTable);
        this.languageTable.setModel((TableModel)this.languageTableModel);
        this.languageTable.setColumnControlVisible(false);
        this.languageTable.setDefaultRenderer(Locale.class, (TableCellRenderer)new LocaleRenderer());
        this.languageTable.setEditable(true);
        this.languageTable.setSortable(false);
        this.languageTable.getSelectionModel().setSelectionMode(0);
        this.languageTable.getColumn(0).setMaxWidth(100);
        this.languageTable.getColumn(0).setMinWidth(50);
        this.languageTable.getColumn(0).setWidth(75);
        JScrollPane jScrollPane = new JScrollPane((Component)this.languageTable);
        jScrollPane.setBorder(BorderFactory.createLineBorder(Color.GRAY, 1));
        try {
            for (OpenEstateTranslator openEstateTranslator : OpenEstateUtils.loadTranslatorsByLanguage().values()) {
                this.languageTableModel.addLocale(openEstateTranslator.getLocale(), Boolean.FALSE);
            }
        }
        catch (Exception exception) {
            LOGGER.error((Object)"could not build language-table!");
            LOGGER.error((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
        }
        DefaultFormBuilder defaultFormBuilder = ImmoToolUtils.createFormBuilder((String)"right:[40dlu,pref], 3dlu, 30dlu:grow");
        defaultFormBuilder.append((Component)ImmoToolUtils.createHead2Separator((String)this.resourceMap.getString("title.languages", new Object[0])), 3);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append((Component)new JLabel(this.resourceMap.getString("label.languages", new Object[0])), 3);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append((Component)new JLabel(" "), 3);
        defaultFormBuilder.nextLine();
        this.setLayout(new BorderLayout());
        this.add(defaultFormBuilder.getPanel(), "North");
        this.add(jScrollPane, "Center");
    }

    public void doLoad() throws ImmoToolException {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Locale locale : AgencyPlugin.getLocales()) {
            arrayList.add(locale.toString());
        }
        for (int i = 0; i < this.languageTableModel.getRowCount(); ++i) {
            Locale locale = (Locale)this.languageTableModel.getValueAt(i, 1);
            if (arrayList.contains(locale.toString())) {
                this.languageTableModel.setValueAt(Boolean.TRUE, i, 0);
                continue;
            }
            this.languageTableModel.setValueAt(Boolean.FALSE, i, 0);
        }
        this.languageTable.packAll();
    }

    public void doSave() throws ImmoToolException {
        Locale[] localeArray = this.getSelection();
        if (localeArray.length <= 0) {
            return;
        }
        AgencyPlugin.setLocales(localeArray);
    }

    public boolean doValidate() {
        for (int i = 0; i < this.languageTableModel.getRowCount(); ++i) {
            Boolean bl = (Boolean)this.languageTableModel.getValueAt(i, 0);
            if (!Boolean.TRUE.equals(bl)) continue;
            return true;
        }
        return false;
    }

    public Locale[] getSelection() throws ImmoToolException {
        ArrayList<Locale> arrayList = new ArrayList<Locale>();
        for (int i = 0; i < this.languageTableModel.getRowCount(); ++i) {
            Boolean bl = (Boolean)this.languageTableModel.getValueAt(i, 0);
            if (!Boolean.TRUE.equals(bl)) continue;
            arrayList.add((Locale)this.languageTableModel.getValueAt(i, 1));
        }
        return !arrayList.isEmpty() ? arrayList.toArray(new Locale[arrayList.size()]) : new Locale[]{};
    }

    public String getTitle() {
        return this.resourceMap.getString("panelTitle", new Object[0]);
    }

    private class LocaleRenderer
    extends JLabel
    implements TableCellRenderer {
        public LocaleRenderer() {
            this.setOpaque(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.setBackground(bl ? jTable.getSelectionBackground() : jTable.getBackground());
            this.setForeground(bl ? jTable.getSelectionForeground() : jTable.getForeground());
            if (object instanceof Locale) {
                Locale locale = (Locale)object;
                if (!AgencySetupLanguagePanel.this.flags.containsKey(locale.toString())) {
                    AgencySetupLanguagePanel.this.flags.put(locale.toString(), OpenEstateUtils.getFlagIcon((Locale)locale));
                }
                this.setIcon((Icon)AgencySetupLanguagePanel.this.flags.get(locale.toString()));
                this.setText(locale.getDisplayLanguage() + " / " + locale.getDisplayLanguage(locale));
            } else {
                this.setText("");
                this.setIcon(null);
            }
            return this;
        }
    }

    private class LanguageTableModel
    extends DefaultTableModel {
        private Map<Integer, String> COLUMN_NAMES = new HashMap<Integer, String>();
        private Map<Integer, Class> COLUMN_CLASSES;

        public LanguageTableModel() {
            this.COLUMN_NAMES.put(0, "col.enabled");
            this.COLUMN_NAMES.put(1, "col.language");
            this.COLUMN_CLASSES = new HashMap<Integer, Class>();
            this.COLUMN_CLASSES.put(0, Boolean.class);
            this.COLUMN_CLASSES.put(1, Locale.class);
            this.setColumnCount(this.COLUMN_NAMES.size());
        }

        public void addLocale(Locale locale, Boolean bl) {
            this.addRow(this.buildRow(locale, bl));
        }

        private Object[] buildRow(Locale locale, Boolean bl) {
            TreeMap<Integer, Serializable> treeMap = new TreeMap<Integer, Serializable>();
            treeMap.put(0, bl);
            treeMap.put(1, locale);
            return treeMap.values().toArray(new Object[treeMap.size()]);
        }

        public void clear() {
            while (this.getRowCount() > 0) {
                this.removeRow(0);
            }
        }

        public Class getColumnClass(int n) {
            return this.COLUMN_CLASSES.containsKey(n) ? this.COLUMN_CLASSES.get(n) : null;
        }

        @Override
        public String getColumnName(int n) {
            return this.COLUMN_NAMES.containsKey(n) ? AgencySetupLanguagePanel.this.resourceMap.getString(this.COLUMN_NAMES.get(n), new Object[0]) : null;
        }

        public Locale getLocaleAt(int n) {
            int n2 = n;
            return (Locale)this.getValueAt(n2, 1);
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 == 0;
        }

        public boolean isEnabledAt(int n) {
            int n2 = n;
            return Boolean.TRUE.equals(this.getValueAt(n2, 0));
        }
    }
}

