/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.openindex.openestate.tool.ImmoToolException;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.agency.AgencySetupPdfFormPanel;
import com.openindex.openestate.tool.agency.utils.PdfExposeDetailedBuilder;
import com.openindex.openestate.tool.agency.utils.PdfSetup;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.ActionMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.apache.log4j.Logger;
import org.jdesktop.application.Action;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.swingx.JXTable;

public class AgencySetupPdfFormDetailedPanel
extends AgencySetupPdfFormPanel {
    private static final Logger LOGGER = Logger.getLogger(AgencySetupPdfFormDetailedPanel.class);
    public static final int COLUMN_ENABLED = 0;
    public static final int COLUMN_AREA = 1;
    private static final Map<Integer, String> COLUMN_NAMES = new HashMap<Integer, String>();
    private static final Map<Integer, Class> COLUMN_CLASSES;
    private ResourceMap resourceMap;
    private ActionMap actionMap;
    private JCheckBox pdfNumberedHeadlinesBox;
    private JCheckBox pdfTermsVisibleBox;
    private JSpinner pdfTermsSizeField;
    private JComboBox pdfPublishAdressBox;
    private JComboBox pdfImageGalleryBox;
    private JCheckBox pdfImageSeparatePanoramasBox;
    private JCheckBox pdfImageSeparatePlansBox;
    private JXTable pdfAreaTable;
    private AreaTableModel pdfAreaTableModel;
    private JButton pdfAreaUpButton;
    private JButton pdfAreaDownButton;

    public AgencySetupPdfFormDetailedPanel() {
        if (this.resourceMap == null) {
            this.resourceMap = ImmoToolUtils.getResourceMap(AgencySetupPdfFormDetailedPanel.class);
        }
        this.resourceMap.injectComponents((Component)((Object)this));
        this.actionMap = ImmoToolUtils.getActionMap(AgencySetupPdfFormDetailedPanel.class, (Object)((Object)this));
        this.pdfAreaUpButton.setAction(this.actionMap.get("doMoveAreaUp"));
        this.pdfAreaUpButton.setEnabled(false);
        this.pdfAreaDownButton.setAction(this.actionMap.get("doMoveAreaDown"));
        this.pdfAreaDownButton.setEnabled(false);
    }

    @Override
    protected void buildTabContentFields(DefaultFormBuilder defaultFormBuilder) {
        super.buildTabContentFields(defaultFormBuilder);
        this.pdfAreaUpButton = new JButton();
        this.pdfAreaDownButton = new JButton();
        JPanel jPanel = new JPanel(new FlowLayout(2, 0, 0));
        jPanel.add(this.pdfAreaUpButton);
        jPanel.add(new JLabel(" "));
        jPanel.add(this.pdfAreaDownButton);
        JPanel jPanel2 = new JPanel(new BorderLayout(5, 0));
        jPanel2.add((Component)ImmoToolUtils.createHead2Separator((String)this.resourceMap.getString("contentAreas", new Object[0])), "Center");
        jPanel2.add((Component)jPanel, "East");
        this.pdfAreaTableModel = new AreaTableModel();
        for (PdfExposeDetailedBuilder.Area area : PdfExposeDetailedBuilder.Area.values()) {
            this.pdfAreaTableModel.addArea(area, true);
        }
        this.pdfAreaTable = new JXTable();
        this.pdfAreaTable.setModel((TableModel)this.pdfAreaTableModel);
        this.pdfAreaTable.setSortable(false);
        this.pdfAreaTable.getTableHeader().setReorderingAllowed(false);
        this.pdfAreaTable.getSelectionModel().setSelectionMode(0);
        this.pdfAreaTable.getColumn(1).setCellRenderer(new AreaTableRenderer());
        ImmoToolUtils.configureTable((JXTable)this.pdfAreaTable);
        this.pdfAreaTable.packAll();
        this.pdfAreaTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!AgencySetupPdfFormDetailedPanel.this.pdfAreaTable.isEnabled() || listSelectionEvent.getValueIsAdjusting()) {
                    return;
                }
                if (AgencySetupPdfFormDetailedPanel.this.pdfAreaTable.getSelectedRowCount() < 1) {
                    AgencySetupPdfFormDetailedPanel.this.pdfAreaUpButton.setEnabled(false);
                    AgencySetupPdfFormDetailedPanel.this.pdfAreaDownButton.setEnabled(false);
                } else {
                    int n = AgencySetupPdfFormDetailedPanel.this.pdfAreaTable.getSelectedRow();
                    AgencySetupPdfFormDetailedPanel.this.pdfAreaUpButton.setEnabled(n > 0);
                    AgencySetupPdfFormDetailedPanel.this.pdfAreaDownButton.setEnabled(n + 1 < AgencySetupPdfFormDetailedPanel.this.pdfAreaTable.getRowCount());
                }
            }
        });
        JScrollPane jScrollPane = new JScrollPane((Component)this.pdfAreaTable);
        jScrollPane.setPreferredSize(new Dimension(jScrollPane.getPreferredSize().width, 100));
        defaultFormBuilder.append((Component)jPanel2, 3);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append((Component)jScrollPane, 3);
        defaultFormBuilder.nextLine();
    }

    @Override
    protected void buildTabGeneralFields(DefaultFormBuilder defaultFormBuilder) {
        super.buildTabGeneralFields(defaultFormBuilder);
        if (this.resourceMap == null) {
            this.resourceMap = ImmoToolUtils.getResourceMap(AgencySetupPdfFormDetailedPanel.class);
        }
        this.pdfPublishAdressBox = new JComboBox();
        this.pdfPublishAdressBox.setName("pdfPublishAdressBox");
        this.pdfPublishAdressBox.setOpaque(false);
        this.pdfPublishAdressBox.setRenderer(new AddressPublishingRenderer());
        this.pdfPublishAdressBox.addItem(0);
        this.pdfPublishAdressBox.addItem(1);
        this.pdfPublishAdressBox.addItem(2);
        this.pdfPublishAdressBox.setSelectedItem(0);
        this.pdfNumberedHeadlinesBox = new JCheckBox();
        this.pdfNumberedHeadlinesBox.setName("pdfNumberedHeadlinesBox");
        this.pdfNumberedHeadlinesBox.setOpaque(false);
        this.pdfTermsSizeField = new JSpinner(new SpinnerNumberModel(10, 1, 30, 1));
        this.pdfTermsSizeField.setName("pdfTermsSizeField");
        this.pdfTermsVisibleBox = new JCheckBox();
        this.pdfTermsVisibleBox.setName("pdfTermsVisibleBox");
        this.pdfTermsVisibleBox.setOpaque(false);
        this.pdfTermsVisibleBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AgencySetupPdfFormDetailedPanel.this.pdfTermsSizeField.setEnabled(AgencySetupPdfFormDetailedPanel.this.pdfTermsVisibleBox.isSelected());
            }
        });
        this.pdfImageGalleryBox = new JComboBox();
        this.pdfImageGalleryBox.setName("pdfImageGalleryBox");
        this.pdfImageGalleryBox.setRenderer(new GalleryRenderer());
        this.pdfImageGalleryBox.addItem(5);
        this.pdfImageGalleryBox.addItem(1);
        this.pdfImageGalleryBox.addItem(6);
        this.pdfImageGalleryBox.addItem(2);
        this.pdfImageGalleryBox.addItem(3);
        this.pdfImageGalleryBox.addItem(4);
        this.pdfImageGalleryBox.addItem(-1);
        this.pdfImageGalleryBox.setSelectedItem(2);
        this.pdfImageSeparatePlansBox = new JCheckBox();
        this.pdfImageSeparatePlansBox.setName("pdfImageSeparatePlansBox");
        this.pdfImageSeparatePlansBox.setOpaque(false);
        this.pdfImageSeparatePanoramasBox = new JCheckBox();
        this.pdfImageSeparatePanoramasBox.setName("pdfImageSeparatePanoramasBox");
        this.pdfImageSeparatePanoramasBox.setOpaque(false);
        JPanel jPanel = null;
        jPanel = new JPanel(new FlowLayout(0, 0, 0));
        jPanel.add(this.pdfTermsVisibleBox);
        jPanel.add(this.pdfTermsSizeField);
        jPanel.add(new JLabel(" pt"));
        defaultFormBuilder.append(this.resourceMap.getString("label.adress", new Object[0]), (Component)this.pdfPublishAdressBox, 3);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(this.resourceMap.getString("label.gallery", new Object[0]), (Component)this.pdfImageGalleryBox, 3);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(this.resourceMap.getString("label.options", new Object[0]), (Component)this.pdfImageSeparatePlansBox, 3);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append("", (Component)this.pdfImageSeparatePanoramasBox, 3);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append("", (Component)jPanel, 3);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append("", (Component)this.pdfNumberedHeadlinesBox, 3);
        defaultFormBuilder.nextLine();
    }

    @Action
    public void doMoveAreaDown() {
        if (this.pdfAreaTable.getSelectedRowCount() < 1) {
            return;
        }
        int n = this.pdfAreaTable.getSelectedRow();
        if (n + 1 < this.pdfAreaTable.getRowCount()) {
            this.pdfAreaTableModel.moveRow(n, n, n + 1);
            this.pdfAreaTable.getSelectionModel().setSelectionInterval(n + 1, n + 1);
        }
    }

    @Action
    public void doMoveAreaUp() {
        if (this.pdfAreaTable.getSelectedRowCount() < 1) {
            return;
        }
        int n = this.pdfAreaTable.getSelectedRow();
        if (n > 0) {
            this.pdfAreaTableModel.moveRow(n, n, n - 1);
            this.pdfAreaTable.getSelectionModel().setSelectionInterval(n - 1, n - 1);
        }
    }

    @Override
    public void load(PdfSetup pdfSetup) throws ImmoToolException {
        Object object;
        super.load(pdfSetup);
        if (this.pdfPublishAdressBox != null) {
            this.pdfPublishAdressBox.setSelectedItem(pdfSetup.getAddressPublishing());
        }
        if (this.pdfNumberedHeadlinesBox != null) {
            this.pdfNumberedHeadlinesBox.setSelected(pdfSetup.isNumberedHeadlines());
        }
        if (this.pdfTermsVisibleBox != null) {
            this.pdfTermsVisibleBox.setSelected(pdfSetup.isTermsVisible());
        }
        if (this.pdfTermsSizeField != null) {
            object = pdfSetup.getTermsTextSize();
            this.pdfTermsSizeField.setValue(pdfSetup.isTermsVisible() && object != null ? object.intValue() : 10);
            this.pdfTermsSizeField.setEnabled(pdfSetup.isTermsVisible());
        }
        if (this.pdfImageGalleryBox != null) {
            object = pdfSetup.getImageGallery();
            if (object == null || object.intValue() == 0 || object.intValue() < -1) {
                this.pdfImageGalleryBox.setSelectedItem(2);
            } else {
                this.pdfImageGalleryBox.setSelectedItem(object);
            }
        }
        if (this.pdfImageSeparatePlansBox != null) {
            this.pdfImageSeparatePlansBox.setSelected(Boolean.TRUE.equals(pdfSetup.getImageSeparatedPlans()));
        }
        if (this.pdfImageSeparatePanoramasBox != null) {
            this.pdfImageSeparatePanoramasBox.setSelected(Boolean.TRUE.equals(pdfSetup.getImageSeparatedPanoramas()));
        }
        this.pdfAreaTableModel.clear();
        object = pdfSetup.getAreas();
        if (object == null) {
            for (PdfExposeDetailedBuilder.Area area : PdfExposeDetailedBuilder.Area.values()) {
                this.pdfAreaTableModel.addArea(area, true);
            }
        } else {
            ArrayList<PdfExposeDetailedBuilder.Area> arrayList = new ArrayList<PdfExposeDetailedBuilder.Area>();
            arrayList.addAll(Arrays.asList(PdfExposeDetailedBuilder.Area.values()));
            for (String string : object) {
                PdfExposeDetailedBuilder.Area area = null;
                try {
                    area = PdfExposeDetailedBuilder.Area.valueOf(string);
                }
                catch (Exception exception) {
                    LOGGER.warn((Object)"Unknown pdf area!");
                    LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
                    continue;
                }
                arrayList.remove((Object)area);
                this.pdfAreaTableModel.addArea(area, true);
            }
            for (PdfExposeDetailedBuilder.Area area : arrayList) {
                this.pdfAreaTableModel.addArea(area, false);
            }
        }
    }

    @Override
    public void save(PdfSetup pdfSetup, boolean bl) throws ImmoToolException {
        pdfSetup.setAddressPublishing(this.pdfPublishAdressBox != null ? (Integer)this.pdfPublishAdressBox.getSelectedItem() : 0);
        pdfSetup.setTermsVisible(this.pdfTermsVisibleBox != null && this.pdfTermsVisibleBox.isSelected());
        pdfSetup.setTermsTextSize(this.pdfTermsSizeField != null ? Integer.valueOf(((Number)this.pdfTermsSizeField.getValue()).intValue()) : null);
        pdfSetup.setNumberedHeadlines(this.pdfNumberedHeadlinesBox != null ? this.pdfNumberedHeadlinesBox.isSelected() : false);
        pdfSetup.setImageGallery(this.pdfImageGalleryBox != null ? (Integer)this.pdfImageGalleryBox.getSelectedItem() : null);
        pdfSetup.setImageSeparatedPlans(this.pdfImageSeparatePlansBox != null ? Boolean.valueOf(this.pdfImageSeparatePlansBox.isSelected()) : null);
        pdfSetup.setImageSeparatedPanoramas(this.pdfImageSeparatePanoramasBox != null ? Boolean.valueOf(this.pdfImageSeparatePanoramasBox.isSelected()) : null);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < this.pdfAreaTable.getRowCount(); ++i) {
            Boolean bl2 = (Boolean)this.pdfAreaTable.getValueAt(i, 0);
            if (!Boolean.TRUE.equals(bl2)) continue;
            arrayList.add(this.pdfAreaTable.getValueAt(i, 1).toString());
        }
        pdfSetup.setAreas(arrayList.toArray(new String[arrayList.size()]));
        super.save(pdfSetup, bl);
    }

    static {
        COLUMN_NAMES.put(0, "contentArea.col.enabled");
        COLUMN_NAMES.put(1, "contentArea.col.name");
        COLUMN_CLASSES = new HashMap<Integer, Class>();
        COLUMN_CLASSES.put(0, Boolean.class);
        COLUMN_CLASSES.put(1, PdfExposeDetailedBuilder.Area.class);
    }

    private class GalleryRenderer
    extends JLabel
    implements ListCellRenderer {
        public GalleryRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            this.setBackground(bl ? jList.getSelectionBackground() : jList.getBackground());
            this.setForeground(bl ? jList.getSelectionForeground() : jList.getForeground());
            if (object instanceof Integer) {
                Integer n2 = (Integer)object;
                switch (n2) {
                    case 5: {
                        this.setText(AgencySetupPdfFormDetailedPanel.this.resourceMap.getString("label.gallery.oneImagePerSite", new Object[0]));
                        break;
                    }
                    case 1: {
                        this.setText(AgencySetupPdfFormDetailedPanel.this.resourceMap.getString("label.gallery.oneImagePerRow", new Object[0]));
                        break;
                    }
                    case 6: {
                        this.setText(AgencySetupPdfFormDetailedPanel.this.resourceMap.getString("label.gallery.imagesPerSite", new Object[]{2}));
                        break;
                    }
                    case 2: {
                        this.setText(AgencySetupPdfFormDetailedPanel.this.resourceMap.getString("label.gallery.imagesPerRow", new Object[]{2}));
                        break;
                    }
                    case 3: {
                        this.setText(AgencySetupPdfFormDetailedPanel.this.resourceMap.getString("label.gallery.imagesPerRow", new Object[]{3}));
                        break;
                    }
                    case 4: {
                        this.setText(AgencySetupPdfFormDetailedPanel.this.resourceMap.getString("label.gallery.imagesPerRow", new Object[]{4}));
                        break;
                    }
                    case -1: {
                        this.setText(AgencySetupPdfFormDetailedPanel.this.resourceMap.getString("label.gallery.noImages", new Object[0]));
                        break;
                    }
                    default: {
                        this.setText("???");
                        break;
                    }
                }
            } else {
                this.setText("???");
            }
            return this;
        }
    }

    private class AreaTableRenderer
    extends JLabel
    implements TableCellRenderer {
        public AreaTableRenderer() {
            this.setOpaque(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.setBackground(bl ? jTable.getSelectionBackground() : jTable.getBackground());
            this.setForeground(bl ? jTable.getSelectionForeground() : jTable.getForeground());
            if (object instanceof PdfExposeDetailedBuilder.Area) {
                PdfExposeDetailedBuilder.Area area = (PdfExposeDetailedBuilder.Area)((Object)object);
                this.setText(AgencySetupPdfFormDetailedPanel.this.resourceMap.getString("contentArea.type." + area.name().toLowerCase(), new Object[0]));
            } else {
                this.setText("");
            }
            return this;
        }
    }

    private class AreaTableModel
    extends DefaultTableModel {
        public AreaTableModel() {
            this.setColumnCount(COLUMN_NAMES.size());
        }

        public void addArea(PdfExposeDetailedBuilder.Area area, boolean bl) {
            this.addRow(this.buildRow(area, bl));
        }

        private Object[] buildRow(PdfExposeDetailedBuilder.Area area, boolean bl) {
            TreeMap<Integer, Object> treeMap = new TreeMap<Integer, Object>();
            treeMap.put(1, (Object)area);
            treeMap.put(0, bl);
            return treeMap.values().toArray(new Object[treeMap.size()]);
        }

        public void clear() {
            while (this.getRowCount() > 0) {
                this.removeRow(0);
            }
        }

        public Class getColumnClass(int n) {
            return COLUMN_CLASSES.containsKey(n) ? (Class)COLUMN_CLASSES.get(n) : null;
        }

        @Override
        public String getColumnName(int n) {
            return COLUMN_NAMES.containsKey(n) ? AgencySetupPdfFormDetailedPanel.this.resourceMap.getString((String)COLUMN_NAMES.get(n), new Object[0]) : null;
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 == 0;
        }
    }

    private class AddressPublishingRenderer
    extends JLabel
    implements ListCellRenderer {
        public AddressPublishingRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            this.setBackground(bl ? jList.getSelectionBackground() : jList.getBackground());
            this.setForeground(bl ? jList.getSelectionForeground() : jList.getForeground());
            if (object instanceof Integer) {
                Integer n2 = (Integer)object;
                switch (n2) {
                    case 0: {
                        this.setText(AgencySetupPdfFormDetailedPanel.this.resourceMap.getString("label.adress.default", new Object[0]));
                        break;
                    }
                    case 1: {
                        this.setText(AgencySetupPdfFormDetailedPanel.this.resourceMap.getString("label.adress.never", new Object[0]));
                        break;
                    }
                    case 2: {
                        this.setText(AgencySetupPdfFormDetailedPanel.this.resourceMap.getString("label.adress.always", new Object[0]));
                        break;
                    }
                    default: {
                        this.setText("???");
                        break;
                    }
                }
            } else {
                this.setText("???");
            }
            return this;
        }
    }
}

