/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.factories.Borders;
import com.openindex.openestate.impl.utils.OpenEstateLocaleComboBox;
import com.openindex.openestate.tool.ImmoToolException;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.agency.AgencyPlugin;
import com.openindex.openestate.tool.agency.utils.PdfSetup;
import com.openindex.openestate.tool.utils.JColorChooseButton;
import com.openindex.openestate.tool.utils.NonEmptyComboBoxRule;
import com.openindex.openestate.tool.utils.ValidationHandler;
import com.openindex.openestate.tool.utils.ValidationRule;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.Serializable;
import java.util.Locale;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.filechooser.FileFilter;
import org.apache.commons.lang.SystemUtils;
import org.apache.log4j.Logger;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.swingx.JXPanel;

public abstract class AgencySetupPdfFormPanel
extends JXPanel {
    private static final Logger LOGGER = Logger.getLogger(AgencySetupPdfFormPanel.class);
    private ResourceMap resourceMap;
    private ValidationHandler validationHandler;
    private JTabbedPane tabPanel;
    private JComboBox pdfFormatBox = null;
    private JComboBox pdfResolutionBox = null;
    private OpenEstateLocaleComboBox pdfLocaleBox = null;
    private JCheckBox pdfTemplateBox = null;
    private JTextField pdfTemplateField = null;
    private JButton pdfTemplateButton = null;
    private JCheckBox pdfFooterVisibleBox = null;
    private JComboBox pdfFooterAlignmentBox = null;
    private JColorChooseButton pdfFooterTextFgColorButton = null;
    private JCheckBox pdfHeaderVisibleBox = null;
    private JCheckBox pdfHeaderLogoVisibleBox = null;
    private JCheckBox pdfHeaderTextBox = null;
    private JColorChooseButton pdfHeaderTextFgColorButton = null;
    private JTextField pdfHeaderTextLine1Field = null;
    private JTextField pdfHeaderTextLine2Field = null;
    private JTextField pdfHeaderTextLine3Field = null;
    private JColorChooseButton pdfBorderColorButton = null;
    private JColorChooseButton pdfBodyHeadBgColorButton = null;
    private JColorChooseButton pdfBodyHeadFgColorButton = null;
    private JColorChooseButton pdfBodyTextBgColorButton = null;
    private JColorChooseButton pdfBodyTextFgColorButton = null;
    private JComboBox pdfBodyTextAlignmentBox = null;
    private JCheckBox pdfEncryptionBox = null;
    private JTextField pdfEncryptionPasswordField = null;
    private JCheckBox pdfEncryptionAllowAccessibilityBox = null;
    private JCheckBox pdfEncryptionAllowCopyingBox = null;
    private JCheckBox pdfEncryptionAllowPrintingBox = null;

    protected AgencySetupPdfFormPanel() {
        this.build();
    }

    private void build() {
        this.resourceMap = ImmoToolUtils.getResourceMap(AgencySetupPdfFormPanel.class);
        this.validationHandler = ImmoToolUtils.createValidationHandler();
        this.tabPanel = new JTabbedPane();
        this.tabPanel.setOpaque(false);
        this.buildTabs(this.tabPanel);
        this.setLayout(new BorderLayout());
        this.add(this.tabPanel, "Center");
        final AgencySetupPdfFormPanel agencySetupPdfFormPanel = this;
        if (this.pdfTemplateBox != null) {
            this.pdfTemplateBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    AgencySetupPdfFormPanel.this.setTemplateEnabled(AgencySetupPdfFormPanel.this.pdfTemplateBox.isSelected());
                }
            });
        }
        if (this.pdfHeaderVisibleBox != null) {
            this.pdfHeaderVisibleBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    AgencySetupPdfFormPanel.this.setHeaderEnabled(AgencySetupPdfFormPanel.this.pdfHeaderVisibleBox.isSelected());
                }
            });
        }
        if (this.pdfHeaderTextBox != null) {
            this.pdfHeaderTextBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    AgencySetupPdfFormPanel.this.setHeaderTextEnabled(AgencySetupPdfFormPanel.this.pdfHeaderTextBox.isSelected());
                }
            });
        }
        if (this.pdfFooterVisibleBox != null) {
            this.pdfFooterVisibleBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    AgencySetupPdfFormPanel.this.setFooterEnabled(AgencySetupPdfFormPanel.this.pdfFooterVisibleBox.isSelected());
                }
            });
        }
        if (this.pdfTemplateButton != null) {
            this.pdfTemplateButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    JFileChooser jFileChooser = new JFileChooser();
                    jFileChooser.setDialogTitle(AgencySetupPdfFormPanel.this.resourceMap.getString("label.selectPdfTemplate", new Object[0]));
                    jFileChooser.setApproveButtonText(AgencySetupPdfFormPanel.this.resourceMap.getString("label.selectPdfTemplate.use", new Object[0]));
                    jFileChooser.setFileFilter(new FileFilter(){

                        @Override
                        public boolean accept(File file) {
                            return file.isDirectory() || file.getName().toLowerCase().endsWith(".pdf");
                        }

                        @Override
                        public String getDescription() {
                            return AgencySetupPdfFormPanel.this.resourceMap.getString("label.selectPdfTemplate.files", new Object[]{"*.pdf"});
                        }
                    });
                    int n = jFileChooser.showOpenDialog((Component)((Object)agencySetupPdfFormPanel));
                    if (n != 0) {
                        return;
                    }
                    AgencySetupPdfFormPanel.this.pdfTemplateField.setText(jFileChooser.getSelectedFile().getAbsolutePath());
                }
            });
        }
        this.resourceMap.injectComponents((Component)((Object)this));
        this.setTemplateSelected(false);
        this.setHeaderSelected(true);
        this.setHeaderTextSelected(false);
        this.setFooterSelected(true);
        if (SystemUtils.IS_OS_MAC_OSX) {
            if (this.pdfTemplateButton != null) {
                this.pdfTemplateButton.setOpaque(false);
            }
            if (this.pdfBorderColorButton != null) {
                this.pdfBorderColorButton.setOpaque(false);
            }
            if (this.pdfBodyHeadBgColorButton != null) {
                this.pdfBodyHeadBgColorButton.setOpaque(false);
            }
            if (this.pdfBodyHeadFgColorButton != null) {
                this.pdfBodyHeadFgColorButton.setOpaque(false);
            }
            if (this.pdfBodyTextBgColorButton != null) {
                this.pdfBodyTextBgColorButton.setOpaque(false);
            }
            if (this.pdfBodyTextFgColorButton != null) {
                this.pdfBodyTextFgColorButton.setOpaque(false);
            }
            if (this.pdfFooterTextFgColorButton != null) {
                this.pdfFooterTextFgColorButton.setOpaque(false);
            }
            if (this.pdfHeaderTextFgColorButton != null) {
                this.pdfHeaderTextFgColorButton.setOpaque(false);
            }
        }
    }

    protected void buildTabs(JTabbedPane jTabbedPane) {
        JScrollPane jScrollPane = null;
        jScrollPane = this.buildTabGeneral();
        if (jScrollPane != null) {
            jTabbedPane.addTab(this.resourceMap.getString("title.general", new Object[0]), jScrollPane);
        }
        if ((jScrollPane = this.buildTabHeaderAndFooter()) != null) {
            jTabbedPane.addTab(this.resourceMap.getString("title.headerAndFooter", new Object[0]), jScrollPane);
        }
        if ((jScrollPane = this.buildTabContent()) != null) {
            jTabbedPane.addTab(this.resourceMap.getString("title.content", new Object[0]), jScrollPane);
        }
        if ((jScrollPane = this.buildTabEncryption()) != null) {
            jTabbedPane.addTab(this.resourceMap.getString("title.encryption", new Object[0]), jScrollPane);
        }
    }

    protected JScrollPane buildTabContent() {
        DefaultFormBuilder defaultFormBuilder = ImmoToolUtils.createFormBuilder((String)"right:[40dlu,pref], 3dlu, 30dlu:grow");
        defaultFormBuilder.border(Borders.DIALOG);
        this.buildTabContentFields(defaultFormBuilder);
        JPanel jPanel = defaultFormBuilder.getPanel();
        JScrollPane jScrollPane = new JScrollPane(jPanel);
        jScrollPane.getVerticalScrollBar().setUnitIncrement(20);
        jScrollPane.setBorder(Borders.EMPTY);
        return jScrollPane;
    }

    protected void buildTabContentFields(DefaultFormBuilder defaultFormBuilder) {
        this.pdfBorderColorButton = new JColorChooseButton();
        this.pdfBorderColorButton.setName("pdfBorderColorButton");
        this.pdfBodyHeadBgColorButton = new JColorChooseButton();
        this.pdfBodyHeadBgColorButton.setName("pdfBodyHeadBgColorButton");
        this.pdfBodyHeadFgColorButton = new JColorChooseButton();
        this.pdfBodyHeadFgColorButton.setName("pdfBodyHeadFgColorButton");
        this.pdfBodyTextBgColorButton = new JColorChooseButton();
        this.pdfBodyTextBgColorButton.setName("pdfBodyTextBgColorButton");
        this.pdfBodyTextFgColorButton = new JColorChooseButton();
        this.pdfBodyTextFgColorButton.setName("pdfBodyTextFgColorButton");
        this.pdfBodyTextAlignmentBox = new JComboBox();
        this.pdfBodyTextAlignmentBox.setName("pdfBodyTextAlignmentBox");
        this.pdfBodyTextAlignmentBox.setRenderer(new AlignRenderer());
        this.pdfBodyTextAlignmentBox.addItem(0);
        this.pdfBodyTextAlignmentBox.addItem(1);
        this.pdfBodyTextAlignmentBox.addItem(2);
        this.pdfBodyTextAlignmentBox.addItem(3);
        defaultFormBuilder.append((Component)ImmoToolUtils.createHead2Separator((String)this.resourceMap.getString("title.content", new Object[0])), 3);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(this.resourceMap.getString("label.alignment", new Object[0]), (Component)this.pdfBodyTextAlignmentBox);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(this.resourceMap.getString("label.colors", new Object[0]), (Component)this.pdfBodyTextFgColorButton);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append("", (Component)this.pdfBodyTextBgColorButton);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append("", (Component)this.pdfBodyHeadFgColorButton);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append("", (Component)this.pdfBodyHeadBgColorButton);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append("", (Component)this.pdfBorderColorButton);
        defaultFormBuilder.nextLine();
    }

    protected JScrollPane buildTabEncryption() {
        DefaultFormBuilder defaultFormBuilder = ImmoToolUtils.createFormBuilder((String)"right:[40dlu,pref], 3dlu, 30dlu:grow");
        defaultFormBuilder.border(Borders.DIALOG);
        this.buildTabEncryptionFields(defaultFormBuilder);
        JPanel jPanel = defaultFormBuilder.getPanel();
        JScrollPane jScrollPane = new JScrollPane(jPanel);
        jScrollPane.getVerticalScrollBar().setUnitIncrement(20);
        jScrollPane.setBorder(Borders.EMPTY);
        return jScrollPane;
    }

    protected void buildTabEncryptionFields(DefaultFormBuilder defaultFormBuilder) {
        this.pdfEncryptionBox = new JCheckBox();
        this.pdfEncryptionBox.setName("pdfEncryptionBox");
        this.pdfEncryptionBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (AgencySetupPdfFormPanel.this.pdfEncryptionAllowPrintingBox != null) {
                    AgencySetupPdfFormPanel.this.pdfEncryptionAllowPrintingBox.setEnabled(AgencySetupPdfFormPanel.this.pdfEncryptionBox.isSelected());
                }
                if (AgencySetupPdfFormPanel.this.pdfEncryptionAllowAccessibilityBox != null) {
                    AgencySetupPdfFormPanel.this.pdfEncryptionAllowAccessibilityBox.setEnabled(AgencySetupPdfFormPanel.this.pdfEncryptionBox.isSelected());
                }
                if (AgencySetupPdfFormPanel.this.pdfEncryptionAllowCopyingBox != null) {
                    AgencySetupPdfFormPanel.this.pdfEncryptionAllowCopyingBox.setEnabled(AgencySetupPdfFormPanel.this.pdfEncryptionBox.isSelected());
                }
                if (AgencySetupPdfFormPanel.this.pdfEncryptionPasswordField != null) {
                    AgencySetupPdfFormPanel.this.pdfEncryptionPasswordField.setEnabled(AgencySetupPdfFormPanel.this.pdfEncryptionBox.isSelected());
                }
            }
        });
        this.pdfEncryptionAllowPrintingBox = new JCheckBox();
        this.pdfEncryptionAllowPrintingBox.setName("pdfEncryptionAllowPrintingBox");
        this.pdfEncryptionAllowPrintingBox.setSelected(true);
        this.pdfEncryptionAllowCopyingBox = new JCheckBox();
        this.pdfEncryptionAllowCopyingBox.setName("pdfEncryptionAllowCopyingBox");
        this.pdfEncryptionAllowCopyingBox.setSelected(true);
        this.pdfEncryptionAllowCopyingBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AgencySetupPdfFormPanel.this.pdfEncryptionAllowAccessibilityBox.setEnabled(!AgencySetupPdfFormPanel.this.pdfEncryptionAllowCopyingBox.isSelected());
                if (AgencySetupPdfFormPanel.this.pdfEncryptionAllowCopyingBox.isSelected()) {
                    AgencySetupPdfFormPanel.this.pdfEncryptionAllowAccessibilityBox.setSelected(true);
                }
            }
        });
        this.pdfEncryptionAllowAccessibilityBox = new JCheckBox();
        this.pdfEncryptionAllowAccessibilityBox.setName("pdfEncryptionAllowAccessibilityBox");
        this.pdfEncryptionAllowAccessibilityBox.setSelected(true);
        this.pdfEncryptionPasswordField = new JTextField();
        this.pdfEncryptionPasswordField.setName("pdfEncryptionPasswordField");
        defaultFormBuilder.append((Component)ImmoToolUtils.createHead2Separator((String)this.resourceMap.getString("title.encryptionAndPassword", new Object[0])), 3);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append((Component)this.pdfEncryptionBox, 3);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(this.resourceMap.getString("label.password", new Object[0]), (Component)this.pdfEncryptionPasswordField);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(this.resourceMap.getString("label.permissions", new Object[0]), (Component)this.pdfEncryptionAllowPrintingBox);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append("", (Component)this.pdfEncryptionAllowCopyingBox);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append("", (Component)this.pdfEncryptionAllowAccessibilityBox);
        defaultFormBuilder.nextLine();
    }

    protected JScrollPane buildTabGeneral() {
        DefaultFormBuilder defaultFormBuilder = ImmoToolUtils.createFormBuilder((String)"right:[40dlu,pref], 3dlu, 30dlu:grow, 3dlu, pref");
        defaultFormBuilder.border(Borders.DIALOG);
        this.buildTabGeneralFields(defaultFormBuilder);
        if (this.isPdfTemplateSelectable()) {
            this.pdfTemplateBox = new JCheckBox();
            this.pdfTemplateBox.setName("pdfTemplateBox");
            this.pdfTemplateBox.setOpaque(false);
            this.pdfTemplateButton = new JButton();
            this.pdfTemplateButton.setName("pdfTemplateButton");
            this.pdfTemplateField = new JTextField();
            this.pdfTemplateField.setName("pdfTemplateField");
            this.pdfTemplateField.setEditable(false);
            defaultFormBuilder.append((Component)ImmoToolUtils.createHead2Separator((String)this.resourceMap.getString("title.general.template", new Object[0])), 5);
            defaultFormBuilder.nextLine();
            defaultFormBuilder.append(this.resourceMap.getString("label.pdfTemplate", new Object[0]), (Component)this.pdfTemplateBox, 3);
            defaultFormBuilder.nextLine();
            defaultFormBuilder.append("", (Component)this.pdfTemplateField);
            defaultFormBuilder.append((Component)this.pdfTemplateButton);
            defaultFormBuilder.nextLine();
        }
        JPanel jPanel = defaultFormBuilder.getPanel();
        JScrollPane jScrollPane = new JScrollPane(jPanel);
        jScrollPane.getVerticalScrollBar().setUnitIncrement(20);
        jScrollPane.setBorder(Borders.EMPTY);
        return jScrollPane;
    }

    protected void buildTabGeneralFields(DefaultFormBuilder defaultFormBuilder) {
        this.pdfLocaleBox = new OpenEstateLocaleComboBox(true, AgencyPlugin.getLocales());
        this.pdfLocaleBox.setName("pdfLocaleBox");
        this.pdfResolutionBox = new JComboBox();
        this.pdfResolutionBox.setName("pdfResolutionBox");
        this.pdfResolutionBox.setRenderer(new ResolutionRenderer());
        this.pdfResolutionBox.addItem(null);
        this.pdfResolutionBox.addItem(72);
        this.pdfResolutionBox.addItem(144);
        this.pdfResolutionBox.addItem(300);
        this.pdfResolutionBox.addItem(600);
        this.pdfResolutionBox.setSelectedItem(null);
        if (this.isPdfFormatSelectable()) {
            this.pdfFormatBox = new JComboBox();
            this.pdfFormatBox.setName("pdfFormatBox");
            this.pdfFormatBox.setRenderer(new FormatRenderer());
            this.pdfFormatBox.setOpaque(false);
            this.pdfFormatBox.addItem(Boolean.FALSE);
            this.pdfFormatBox.addItem(Boolean.TRUE);
        }
        this.validationHandler.putRule((JComponent)this.pdfLocaleBox, (ValidationRule)new NonEmptyComboBoxRule((JComboBox)this.pdfLocaleBox));
        defaultFormBuilder.append((Component)ImmoToolUtils.createHead2Separator((String)this.resourceMap.getString("title.general.options", new Object[0])), 5);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(this.resourceMap.getString("label.locale", new Object[0]), (Component)this.pdfLocaleBox, 3);
        defaultFormBuilder.nextLine();
        if (this.isPdfFormatSelectable()) {
            defaultFormBuilder.append(this.resourceMap.getString("label.format", new Object[0]), (Component)this.pdfFormatBox, 3);
            defaultFormBuilder.nextLine();
        }
        defaultFormBuilder.append(this.resourceMap.getString("label.resolution", new Object[0]), (Component)this.pdfResolutionBox, 3);
        defaultFormBuilder.nextLine();
    }

    protected JScrollPane buildTabHeaderAndFooter() {
        DefaultFormBuilder defaultFormBuilder = ImmoToolUtils.createFormBuilder((String)"right:[40dlu,pref], 3dlu, 30dlu:grow, 3dlu, pref");
        defaultFormBuilder.border(Borders.DIALOG);
        this.buildTabHeaderAndFooterFields(defaultFormBuilder);
        JPanel jPanel = defaultFormBuilder.getPanel();
        JScrollPane jScrollPane = new JScrollPane(jPanel);
        jScrollPane.getVerticalScrollBar().setUnitIncrement(20);
        jScrollPane.setBorder(Borders.EMPTY);
        return jScrollPane;
    }

    protected void buildTabHeaderAndFooterFields(DefaultFormBuilder defaultFormBuilder) {
        this.pdfFooterTextFgColorButton = new JColorChooseButton();
        this.pdfFooterTextFgColorButton.setName("pdfFooterTextFgColorButton");
        this.pdfFooterVisibleBox = new JCheckBox();
        this.pdfFooterVisibleBox.setName("pdfFooterVisibleBox");
        this.pdfFooterVisibleBox.setOpaque(false);
        this.pdfFooterAlignmentBox = new JComboBox();
        this.pdfFooterAlignmentBox.setName("pdfFooterAlignmentBox");
        this.pdfFooterAlignmentBox.setRenderer(new AlignRenderer());
        this.pdfFooterAlignmentBox.addItem(0);
        this.pdfFooterAlignmentBox.addItem(1);
        this.pdfFooterAlignmentBox.addItem(2);
        this.pdfHeaderLogoVisibleBox = new JCheckBox();
        this.pdfHeaderLogoVisibleBox.setName("pdfHeaderLogoVisibleBox");
        this.pdfHeaderLogoVisibleBox.setOpaque(false);
        this.pdfHeaderTextBox = new JCheckBox();
        this.pdfHeaderTextBox.setName("pdfHeaderTextBox");
        this.pdfHeaderTextBox.setOpaque(false);
        this.pdfHeaderTextFgColorButton = new JColorChooseButton();
        this.pdfHeaderTextFgColorButton.setName("pdfHeaderTextFgColorButton");
        this.pdfHeaderTextLine1Field = new JTextField();
        this.pdfHeaderTextLine1Field.setName("pdfHeaderTextLine1Field");
        this.pdfHeaderTextLine2Field = new JTextField();
        this.pdfHeaderTextLine2Field.setName("pdfHeaderTextLine2Field");
        this.pdfHeaderTextLine3Field = new JTextField();
        this.pdfHeaderTextLine3Field.setName("pdfHeaderTextLine3Field");
        this.pdfHeaderVisibleBox = new JCheckBox();
        this.pdfHeaderVisibleBox.setName("pdfHeaderVisibleBox");
        this.pdfHeaderVisibleBox.setOpaque(false);
        defaultFormBuilder.append((Component)ImmoToolUtils.createHead2Separator((String)this.resourceMap.getString("title.headerAndFooter.header", new Object[0])), 5);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(this.resourceMap.getString("label.options", new Object[0]), (Component)this.pdfHeaderVisibleBox, 3);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append("", (Component)this.pdfHeaderLogoVisibleBox, 3);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append("", (Component)this.pdfHeaderTextBox, 3);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(this.resourceMap.getString("label.textLine", new Object[]{"1"}), (Component)this.pdfHeaderTextLine1Field, 3);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(this.resourceMap.getString("label.textLine", new Object[]{"2"}), (Component)this.pdfHeaderTextLine2Field, 3);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(this.resourceMap.getString("label.textLine", new Object[]{"3"}), (Component)this.pdfHeaderTextLine3Field, 3);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(this.resourceMap.getString("label.colors", new Object[0]), (Component)this.pdfHeaderTextFgColorButton, 3);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append((Component)ImmoToolUtils.createHead2Separator((String)this.resourceMap.getString("title.headerAndFooter.footer", new Object[0])), 5);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(this.resourceMap.getString("label.options", new Object[0]), (Component)this.pdfFooterVisibleBox, 3);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(this.resourceMap.getString("label.alignment", new Object[0]), (Component)this.pdfFooterAlignmentBox, 3);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(this.resourceMap.getString("label.colors", new Object[0]), (Component)this.pdfFooterTextFgColorButton, 3);
        defaultFormBuilder.nextLine();
    }

    public ValidationHandler getValidationHandler() {
        return this.validationHandler;
    }

    protected boolean isPdfFormatSelectable() {
        return true;
    }

    protected boolean isPdfTemplateSelectable() {
        return true;
    }

    public boolean isValidInput() {
        this.validationHandler.validate();
        return this.validationHandler.isValid();
    }

    public void load(PdfSetup pdfSetup) throws ImmoToolException {
        if (this.pdfFormatBox != null) {
            this.pdfFormatBox.setSelectedItem(pdfSetup.isLandscapeFormat());
        }
        if (this.pdfBodyHeadBgColorButton != null) {
            this.pdfBodyHeadBgColorButton.setColor(pdfSetup.getBodyHeadBackground());
        }
        if (this.pdfBodyHeadFgColorButton != null) {
            this.pdfBodyHeadFgColorButton.setColor(pdfSetup.getBodyHeadForeground());
        }
        if (this.pdfBodyTextBgColorButton != null) {
            this.pdfBodyTextBgColorButton.setColor(pdfSetup.getBodyTextBackground());
        }
        if (this.pdfBodyTextFgColorButton != null) {
            this.pdfBodyTextFgColorButton.setColor(pdfSetup.getBodyTextForeground());
        }
        if (this.pdfBorderColorButton != null) {
            this.pdfBorderColorButton.setColor(pdfSetup.getBorderColor());
        }
        if (this.pdfFooterTextFgColorButton != null) {
            this.pdfFooterTextFgColorButton.setColor(pdfSetup.getFooterTextForeground());
        }
        if (this.pdfHeaderTextFgColorButton != null) {
            this.pdfHeaderTextFgColorButton.setColor(pdfSetup.getHeaderTextForeground());
        }
        if (this.pdfResolutionBox != null) {
            this.pdfResolutionBox.setSelectedItem(pdfSetup.getImageResolution());
        }
        if (this.pdfLocaleBox != null) {
            String string = pdfSetup.getLocale();
            this.pdfLocaleBox.setSelectedIndex(0);
            for (int i = 1; i < this.pdfLocaleBox.getItemCount(); ++i) {
                Locale locale = this.pdfLocaleBox.getLocaleAt(i);
                if (!locale.getLanguage().equals(string)) continue;
                this.pdfLocaleBox.setSelectedIndex(i);
                break;
            }
        }
        this.setFooterSelected(pdfSetup.isFooterVisible());
        if (this.pdfFooterAlignmentBox != null) {
            this.pdfFooterAlignmentBox.setSelectedItem(pdfSetup.getFooterAlignment());
        }
        if (this.pdfBodyTextAlignmentBox != null) {
            this.pdfBodyTextAlignmentBox.setSelectedItem(pdfSetup.getBodyTextAlignment());
        }
        this.setTemplateSelected(pdfSetup.isTemplateUsed());
        this.setHeaderSelected(pdfSetup.isHeaderVisible());
        if (this.pdfHeaderLogoVisibleBox != null) {
            this.pdfHeaderLogoVisibleBox.setSelected(pdfSetup.isHeaderLogoVisible());
        }
        this.setHeaderTextSelected(pdfSetup.isHeaderTextCustom());
        if (this.pdfHeaderTextLine1Field != null) {
            this.pdfHeaderTextLine1Field.setText(pdfSetup.getHeaderTextCustomLine1());
        }
        if (this.pdfHeaderTextLine2Field != null) {
            this.pdfHeaderTextLine2Field.setText(pdfSetup.getHeaderTextCustomLine2());
        }
        if (this.pdfHeaderTextLine3Field != null) {
            this.pdfHeaderTextLine3Field.setText(pdfSetup.getHeaderTextCustomLine3());
        }
        if (this.pdfEncryptionBox != null && this.pdfEncryptionPasswordField != null) {
            this.pdfEncryptionBox.setSelected(pdfSetup.isEncryptionEnabled());
            this.pdfEncryptionPasswordField.setEnabled(pdfSetup.isEncryptionEnabled());
            this.pdfEncryptionPasswordField.setText(pdfSetup.getEncryptionPassword());
            if (this.pdfEncryptionAllowPrintingBox != null) {
                this.pdfEncryptionAllowPrintingBox.setEnabled(pdfSetup.isEncryptionEnabled());
                this.pdfEncryptionAllowPrintingBox.setSelected(pdfSetup.isEncryptionPrintingAllowed());
            }
            if (this.pdfEncryptionAllowCopyingBox != null) {
                this.pdfEncryptionAllowCopyingBox.setEnabled(pdfSetup.isEncryptionEnabled());
                this.pdfEncryptionAllowCopyingBox.setSelected(pdfSetup.isEncryptionCopyingAllowed());
            }
            if (this.pdfEncryptionAllowAccessibilityBox != null) {
                this.pdfEncryptionAllowAccessibilityBox.setEnabled(pdfSetup.isEncryptionEnabled() && !pdfSetup.isEncryptionCopyingAllowed());
                this.pdfEncryptionAllowAccessibilityBox.setSelected(pdfSetup.isEncryptionCopyingAllowed() || pdfSetup.isEncryptionAccessibilityAllowed());
            }
        }
        this.validationHandler.init();
    }

    public void save(PdfSetup pdfSetup, boolean bl) throws ImmoToolException {
        Object object;
        Serializable serializable;
        if (this.pdfFormatBox != null) {
            pdfSetup.setLandscapeFormat(Boolean.TRUE.equals(this.pdfFormatBox.getSelectedItem()));
        }
        if (this.pdfBodyHeadBgColorButton != null) {
            pdfSetup.setBodyHeadBackground(this.pdfBodyHeadBgColorButton.getColor());
        }
        if (this.pdfBodyHeadFgColorButton != null) {
            pdfSetup.setBodyHeadForeground(this.pdfBodyHeadFgColorButton.getColor());
        }
        if (this.pdfBodyTextBgColorButton != null) {
            pdfSetup.setBodyTextBackground(this.pdfBodyTextBgColorButton.getColor());
        }
        if (this.pdfBodyTextFgColorButton != null) {
            pdfSetup.setBodyTextForeground(this.pdfBodyTextFgColorButton.getColor());
        }
        if (this.pdfBorderColorButton != null) {
            pdfSetup.setBorderColor(this.pdfBorderColorButton.getColor());
        }
        if (this.pdfResolutionBox != null) {
            pdfSetup.setImageResolution((Integer)this.pdfResolutionBox.getSelectedItem());
        }
        if (this.pdfEncryptionBox != null && this.pdfEncryptionPasswordField != null) {
            pdfSetup.setEncryptionEnabled(this.pdfEncryptionBox.isSelected());
            pdfSetup.setEncryptionPassword(this.pdfEncryptionPasswordField.getText());
            if (this.pdfEncryptionAllowPrintingBox != null) {
                pdfSetup.setEncryptionPrintingAllowed(this.pdfEncryptionAllowPrintingBox.isSelected());
            }
            if (this.pdfEncryptionAllowCopyingBox != null) {
                pdfSetup.setEncryptionCopyingAllowed(this.pdfEncryptionAllowCopyingBox.isSelected());
            }
            if (this.pdfEncryptionAllowAccessibilityBox != null) {
                pdfSetup.setEncryptionAccessibilityAllowed(this.pdfEncryptionAllowAccessibilityBox.isSelected());
            }
        }
        if (this.pdfLocaleBox != null) {
            serializable = this.pdfLocaleBox.getSelectedLocale();
            pdfSetup.setLocale(((Locale)serializable).getLanguage());
        }
        if (this.pdfBodyTextAlignmentBox != null) {
            pdfSetup.setBodyTextAlignment((Integer)this.pdfBodyTextAlignmentBox.getSelectedItem());
        }
        if (this.pdfFooterVisibleBox != null) {
            pdfSetup.setFooterVisible(this.pdfFooterVisibleBox.isSelected());
            if (this.pdfFooterVisibleBox.isSelected()) {
                if (this.pdfFooterTextFgColorButton != null) {
                    pdfSetup.setFooterTextForeground(this.pdfFooterTextFgColorButton.getColor());
                }
                if (this.pdfFooterAlignmentBox != null) {
                    pdfSetup.setFooterAlignment((Integer)this.pdfFooterAlignmentBox.getSelectedItem());
                }
            } else {
                pdfSetup.setFooterTextForeground(null);
                pdfSetup.setFooterAlignment(null);
            }
        }
        if (this.pdfHeaderVisibleBox != null) {
            pdfSetup.setHeaderVisible(this.pdfHeaderVisibleBox.isSelected());
            if (this.pdfHeaderLogoVisibleBox != null) {
                pdfSetup.setHeaderLogoVisible(this.pdfHeaderLogoVisibleBox.isSelected());
            }
            if (this.pdfHeaderTextFgColorButton != null) {
                if (this.pdfHeaderVisibleBox.isSelected()) {
                    pdfSetup.setHeaderTextForeground(this.pdfHeaderTextFgColorButton.getColor());
                } else {
                    pdfSetup.setHeaderTextForeground(null);
                }
            }
            if (this.pdfHeaderTextBox != null) {
                pdfSetup.setHeaderTextCustom(this.pdfHeaderTextBox.isEnabled() && this.pdfHeaderTextBox.isSelected());
                if (this.pdfHeaderTextBox.isEnabled() && this.pdfHeaderTextBox.isSelected()) {
                    if (this.pdfHeaderTextLine1Field != null) {
                        pdfSetup.setHeaderTextCustomLine1(this.pdfHeaderTextLine1Field.getText().trim());
                    }
                    if (this.pdfHeaderTextLine2Field != null) {
                        pdfSetup.setHeaderTextCustomLine2(this.pdfHeaderTextLine2Field.getText().trim());
                    }
                    if (this.pdfHeaderTextLine3Field != null) {
                        pdfSetup.setHeaderTextCustomLine3(this.pdfHeaderTextLine3Field.getText().trim());
                    }
                } else {
                    pdfSetup.setHeaderTextCustomLine1(null);
                    pdfSetup.setHeaderTextCustomLine2(null);
                    pdfSetup.setHeaderTextCustomLine3(null);
                }
            }
        }
        if (this.pdfTemplateBox != null) {
            pdfSetup.setTemplateUsed(this.pdfTemplateBox.isSelected());
            Serializable serializable2 = serializable = this.pdfTemplateField != null ? this.pdfTemplateField.getText().trim() : null;
            if (!bl && pdfSetup.isTemplateUsed() && serializable != null && ((String)((Object)serializable)).trim().length() > 0) {
                object = new File((String)((Object)serializable));
                if (!((File)object).isFile()) {
                    LOGGER.warn((Object)"Temporary PDF template is not a file!");
                    LOGGER.warn((Object)("> " + ((File)object).getAbsolutePath()));
                } else {
                    pdfSetup.setTemporaryTemplate(new File((String)((Object)serializable)));
                }
            }
        }
        if (bl) {
            serializable = PdfSetup.storeSetup(pdfSetup);
            if (serializable == null) {
                throw new ImmoToolException("nothing was saved!");
            }
            Object object2 = object = this.pdfTemplateField != null ? this.pdfTemplateField.getText().trim() : null;
            if (pdfSetup.isTemplateUsed() && object != null && ((String)object).trim().length() > 0) {
                try {
                    File file = new File((String)object);
                    if (!file.isFile()) {
                        throw new Exception("Invalid PDF template: " + file.getAbsolutePath());
                    }
                    PdfSetup.storeTemplate((Long)serializable, file);
                }
                catch (Exception exception) {
                    LOGGER.error((Object)"Can't import PDF template!");
                    LOGGER.error((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
                    ImmoToolUtils.showMessageErrorDialog((String)"Can't import PDF template!", (Throwable)exception);
                    pdfSetup.setTemplateUsed(false);
                    PdfSetup.storeSetup(pdfSetup);
                }
            }
        }
    }

    private void setFooterEnabled(boolean bl) {
        if (this.pdfFooterAlignmentBox != null) {
            this.pdfFooterAlignmentBox.setEnabled(bl);
        }
        if (this.pdfFooterTextFgColorButton != null) {
            this.pdfFooterTextFgColorButton.setEnabled(bl);
        }
    }

    private void setFooterSelected(boolean bl) {
        if (this.pdfFooterVisibleBox != null) {
            this.pdfFooterVisibleBox.setSelected(bl);
        }
        this.setFooterEnabled(bl);
    }

    private void setHeaderEnabled(boolean bl) {
        if (this.pdfHeaderLogoVisibleBox != null) {
            this.pdfHeaderLogoVisibleBox.setEnabled(bl);
        }
        if (this.pdfHeaderTextFgColorButton != null) {
            this.pdfHeaderTextFgColorButton.setEnabled(bl);
        }
        if (this.pdfHeaderTextBox != null) {
            this.pdfHeaderTextBox.setEnabled(bl);
        }
        this.setHeaderTextEnabled(bl);
    }

    private void setHeaderSelected(boolean bl) {
        if (this.pdfHeaderVisibleBox != null) {
            this.pdfHeaderVisibleBox.setSelected(bl);
        }
        this.setHeaderEnabled(bl);
        this.setHeaderTextSelected(bl && this.pdfHeaderTextBox != null && this.pdfHeaderTextBox.isSelected());
    }

    private void setHeaderTextEnabled(boolean bl) {
        if (this.pdfHeaderTextLine1Field != null) {
            this.pdfHeaderTextLine1Field.setEnabled(bl);
            this.pdfHeaderTextLine1Field.setEditable(bl);
        }
        if (this.pdfHeaderTextLine2Field != null) {
            this.pdfHeaderTextLine2Field.setEnabled(bl);
            this.pdfHeaderTextLine2Field.setEditable(bl);
        }
        if (this.pdfHeaderTextLine3Field != null) {
            this.pdfHeaderTextLine3Field.setEnabled(bl);
            this.pdfHeaderTextLine3Field.setEditable(bl);
        }
    }

    private void setHeaderTextSelected(boolean bl) {
        if (this.pdfHeaderTextBox != null) {
            this.pdfHeaderTextBox.setSelected(bl);
        }
        this.setHeaderTextEnabled(bl);
    }

    private void setTemplateEnabled(boolean bl) {
        if (this.pdfTemplateButton != null) {
            this.pdfTemplateButton.setEnabled(bl);
        }
        if (this.pdfTemplateField != null) {
            this.pdfTemplateField.setEnabled(bl);
        }
    }

    private void setTemplateSelected(boolean bl) {
        if (this.pdfTemplateBox != null) {
            this.pdfTemplateBox.setSelected(bl);
        }
        this.setTemplateEnabled(bl);
    }

    private class ResolutionRenderer
    extends JLabel
    implements ListCellRenderer {
        public ResolutionRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            this.setBackground(bl ? jList.getSelectionBackground() : jList.getBackground());
            this.setForeground(bl ? jList.getSelectionForeground() : jList.getForeground());
            if (object instanceof Integer) {
                this.setText(AgencySetupPdfFormPanel.this.resourceMap.getString("label.resolution." + object.toString(), new Object[0]));
            } else {
                this.setText(AgencySetupPdfFormPanel.this.resourceMap.getString("label.resolution.none", new Object[0]));
            }
            return this;
        }
    }

    private class FormatRenderer
    extends JLabel
    implements ListCellRenderer {
        public FormatRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            this.setBackground(bl ? jList.getSelectionBackground() : jList.getBackground());
            this.setForeground(bl ? jList.getSelectionForeground() : jList.getForeground());
            if (object instanceof Boolean) {
                if (Boolean.TRUE.equals(object)) {
                    this.setText(AgencySetupPdfFormPanel.this.resourceMap.getString("label.format.landscape", new Object[0]));
                } else {
                    this.setText(AgencySetupPdfFormPanel.this.resourceMap.getString("label.format.portrait", new Object[0]));
                }
            } else {
                this.setText("???");
            }
            return this;
        }
    }

    private class AlignRenderer
    extends JLabel
    implements ListCellRenderer {
        private ImageIcon leftIcon;
        private ImageIcon centerIcon;
        private ImageIcon rightIcon;
        private ImageIcon blockIcon;

        public AlignRenderer() {
            this.setOpaque(true);
            this.setIconTextGap(5);
            try {
                this.leftIcon = new ImageIcon(ImageIO.read(AlignRenderer.class.getResource("/com/openindex/openestate/tool/resources/icons/16x16/text_left.png")));
                this.centerIcon = new ImageIcon(ImageIO.read(AlignRenderer.class.getResource("/com/openindex/openestate/tool/resources/icons/16x16/text_center.png")));
                this.rightIcon = new ImageIcon(ImageIO.read(AlignRenderer.class.getResource("/com/openindex/openestate/tool/resources/icons/16x16/text_right.png")));
                this.blockIcon = new ImageIcon(ImageIO.read(AlignRenderer.class.getResource("/com/openindex/openestate/tool/resources/icons/16x16/text_block.png")));
            }
            catch (Exception exception) {
                LOGGER.warn((Object)"Can't load alignment icons!");
                LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
            }
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            this.setBackground(bl ? jList.getSelectionBackground() : jList.getBackground());
            this.setForeground(bl ? jList.getSelectionForeground() : jList.getForeground());
            if (object instanceof Integer) {
                switch ((Integer)object) {
                    case 1: {
                        this.setIcon(this.centerIcon);
                        this.setText(AgencySetupPdfFormPanel.this.resourceMap.getString("label.alignment.center", new Object[0]));
                        break;
                    }
                    case 3: {
                        this.setIcon(this.blockIcon);
                        this.setText(AgencySetupPdfFormPanel.this.resourceMap.getString("label.alignment.justify", new Object[0]));
                        break;
                    }
                    case 0: {
                        this.setIcon(this.leftIcon);
                        this.setText(AgencySetupPdfFormPanel.this.resourceMap.getString("label.alignment.left", new Object[0]));
                        break;
                    }
                    case 2: {
                        this.setIcon(this.rightIcon);
                        this.setText(AgencySetupPdfFormPanel.this.resourceMap.getString("label.alignment.right", new Object[0]));
                        break;
                    }
                    default: {
                        this.setIcon(null);
                        this.setText("???");
                        break;
                    }
                }
            } else {
                this.setIcon(null);
                this.setText("???");
            }
            return this;
        }
    }
}

