/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.openindex.openestate.tool.ImmoToolException;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.agency.AgencySetupPdfFormPanel;
import com.openindex.openestate.tool.agency.utils.PdfSetup;
import com.openindex.openestate.tool.utils.JSelectButton;
import java.awt.Component;
import java.util.Arrays;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.jdesktop.application.ResourceMap;

public class AgencySetupPdfFormShortPanel
extends AgencySetupPdfFormPanel {
    private ResourceMap resourceMap;
    private JComboBox pdfPublishAdressBox;
    private JComboBox pdfImageGalleryBox;
    private JSelectButton pdfContactBox;

    public AgencySetupPdfFormShortPanel() {
        if (this.resourceMap == null) {
            this.resourceMap = ImmoToolUtils.getResourceMap(AgencySetupPdfFormShortPanel.class);
        }
        this.resourceMap.injectComponents((Component)((Object)this));
    }

    @Override
    protected void buildTabGeneralFields(DefaultFormBuilder defaultFormBuilder) {
        super.buildTabGeneralFields(defaultFormBuilder);
        if (this.resourceMap == null) {
            this.resourceMap = ImmoToolUtils.getResourceMap(AgencySetupPdfFormShortPanel.class);
        }
        this.pdfPublishAdressBox = new JComboBox();
        this.pdfPublishAdressBox.setName("pdfPublishAdressBox");
        this.pdfPublishAdressBox.setOpaque(false);
        this.pdfPublishAdressBox.setRenderer(new AddressPublishingRenderer());
        this.pdfPublishAdressBox.addItem(0);
        this.pdfPublishAdressBox.addItem(1);
        this.pdfPublishAdressBox.addItem(2);
        this.pdfPublishAdressBox.setSelectedItem(0);
        this.pdfImageGalleryBox = new JComboBox();
        this.pdfImageGalleryBox.setName("pdfImageGalleryBox");
        this.pdfImageGalleryBox.setOpaque(false);
        this.pdfImageGalleryBox.setRenderer(new GalleryRenderer());
        this.pdfImageGalleryBox.addItem(1);
        this.pdfImageGalleryBox.addItem(2);
        this.pdfImageGalleryBox.addItem(5);
        this.pdfImageGalleryBox.addItem(3);
        this.pdfImageGalleryBox.addItem(4);
        this.pdfImageGalleryBox.addItem(6);
        this.pdfImageGalleryBox.addItem(7);
        this.pdfImageGalleryBox.addItem(8);
        this.pdfImageGalleryBox.addItem(-1);
        this.pdfImageGalleryBox.setSelectedItem(5);
        this.pdfContactBox = new JSelectButton(1);
        this.pdfContactBox.setName("pdfContactBox");
        this.pdfContactBox.setEmptyText(this.resourceMap.getString("label.noContact", new Object[0]));
        this.pdfContactBox.addOption(String.valueOf(0), this.resourceMap.getString("label.contact.name", new Object[0]));
        this.pdfContactBox.addOption(String.valueOf(1), this.resourceMap.getString("label.contact.phone", new Object[0]));
        this.pdfContactBox.addOption(String.valueOf(2), this.resourceMap.getString("label.contact.fax", new Object[0]));
        this.pdfContactBox.addOption(String.valueOf(3), this.resourceMap.getString("label.contact.mail", new Object[0]));
        defaultFormBuilder.append(this.resourceMap.getString("label.adress", new Object[0]), (Component)this.pdfPublishAdressBox, 3);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(this.resourceMap.getString("label.gallery", new Object[0]), (Component)this.pdfImageGalleryBox, 3);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(this.resourceMap.getString("label.contact", new Object[0]), (Component)this.pdfContactBox, 3);
        defaultFormBuilder.nextLine();
    }

    @Override
    public void load(PdfSetup pdfSetup) throws ImmoToolException {
        super.load(pdfSetup);
        if (this.pdfPublishAdressBox != null) {
            this.pdfPublishAdressBox.setSelectedItem(pdfSetup.getAddressPublishing());
        }
        if (this.pdfImageGalleryBox != null) {
            Integer n = pdfSetup.getImageGallery();
            if (n == null || n == 0 || n < -1) {
                this.pdfImageGalleryBox.setSelectedItem(5);
            } else {
                this.pdfImageGalleryBox.setSelectedItem(n);
            }
        }
        if (this.pdfContactBox != null) {
            this.pdfContactBox.setSelected(String.valueOf(2), pdfSetup.isContactPublished(2));
            this.pdfContactBox.setSelected(String.valueOf(3), pdfSetup.isContactPublished(3));
            this.pdfContactBox.setSelected(String.valueOf(0), pdfSetup.isContactPublished(0));
            this.pdfContactBox.setSelected(String.valueOf(1), pdfSetup.isContactPublished(1));
            this.pdfContactBox.updateText();
        }
    }

    @Override
    public void save(PdfSetup pdfSetup, boolean bl) throws ImmoToolException {
        pdfSetup.setAddressPublishing(this.pdfPublishAdressBox != null ? (Integer)this.pdfPublishAdressBox.getSelectedItem() : 0);
        pdfSetup.setImageGallery(this.pdfImageGalleryBox != null ? (Integer)this.pdfImageGalleryBox.getSelectedItem() : null);
        pdfSetup.getContactPublishings().clear();
        if (this.pdfContactBox != null) {
            List<String> list = Arrays.asList(this.pdfContactBox.getSelectedKeys());
            if (list.contains(String.valueOf(2))) {
                pdfSetup.getContactPublishings().add(2);
            }
            if (list.contains(String.valueOf(3))) {
                pdfSetup.getContactPublishings().add(3);
            }
            if (list.contains(String.valueOf(0))) {
                pdfSetup.getContactPublishings().add(0);
            }
            if (list.contains(String.valueOf(1))) {
                pdfSetup.getContactPublishings().add(1);
            }
        }
        super.save(pdfSetup, bl);
    }

    private class GalleryRenderer
    extends JLabel
    implements ListCellRenderer {
        public GalleryRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            this.setBackground(bl ? jList.getSelectionBackground() : jList.getBackground());
            this.setForeground(bl ? jList.getSelectionForeground() : jList.getForeground());
            if (object instanceof Integer) {
                Integer n2 = (Integer)object;
                switch (n2) {
                    case 1: {
                        this.setText(AgencySetupPdfFormShortPanel.this.resourceMap.getString("label.gallery.image", new Object[]{"1x1"}));
                        break;
                    }
                    case 2: {
                        this.setText(AgencySetupPdfFormShortPanel.this.resourceMap.getString("label.gallery.plan", new Object[]{"1x1"}));
                        break;
                    }
                    case 5: {
                        this.setText(AgencySetupPdfFormShortPanel.this.resourceMap.getString("label.gallery.images", new Object[]{"2x1"}));
                        break;
                    }
                    case 3: {
                        this.setText(AgencySetupPdfFormShortPanel.this.resourceMap.getString("label.gallery.imageAndPlan", new Object[]{"2x1"}));
                        break;
                    }
                    case 4: {
                        this.setText(AgencySetupPdfFormShortPanel.this.resourceMap.getString("label.gallery.planAndImage", new Object[]{"2x1"}));
                        break;
                    }
                    case 6: {
                        this.setText(AgencySetupPdfFormShortPanel.this.resourceMap.getString("label.gallery.images", new Object[]{"3x1"}));
                        break;
                    }
                    case 7: {
                        this.setText(AgencySetupPdfFormShortPanel.this.resourceMap.getString("label.gallery.images", new Object[]{"2x2"}));
                        break;
                    }
                    case 8: {
                        this.setText(AgencySetupPdfFormShortPanel.this.resourceMap.getString("label.gallery.images", new Object[]{"3x2"}));
                        break;
                    }
                    case -1: {
                        this.setText(AgencySetupPdfFormShortPanel.this.resourceMap.getString("label.gallery.noImages", new Object[0]));
                        break;
                    }
                    default: {
                        this.setText("???");
                        break;
                    }
                }
            } else {
                this.setText("???");
            }
            return this;
        }
    }

    private class AddressPublishingRenderer
    extends JLabel
    implements ListCellRenderer {
        public AddressPublishingRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            this.setBackground(bl ? jList.getSelectionBackground() : jList.getBackground());
            this.setForeground(bl ? jList.getSelectionForeground() : jList.getForeground());
            if (object instanceof Integer) {
                Integer n2 = (Integer)object;
                switch (n2) {
                    case 0: {
                        this.setText(AgencySetupPdfFormShortPanel.this.resourceMap.getString("label.adress.default", new Object[0]));
                        break;
                    }
                    case 1: {
                        this.setText(AgencySetupPdfFormShortPanel.this.resourceMap.getString("label.adress.never", new Object[0]));
                        break;
                    }
                    case 2: {
                        this.setText(AgencySetupPdfFormShortPanel.this.resourceMap.getString("label.adress.always", new Object[0]));
                        break;
                    }
                    default: {
                        this.setText("???");
                        break;
                    }
                }
            } else {
                this.setText("???");
            }
            return this;
        }
    }
}

