/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency.export;

import com.openindex.openestate.impl.AgentImpl;
import com.openindex.openestate.impl.EstateAttachmentImpl;
import com.openindex.openestate.impl.EstateImpl;
import com.openindex.openestate.impl.OpenEstateUtils;
import com.openindex.openestate.impl.TransferAgencyImpl;
import com.openindex.openestate.impl.TransferImpl;
import com.openindex.openestate.tool.ImmoToolApp;
import com.openindex.openestate.tool.ImmoToolDbException;
import com.openindex.openestate.tool.ImmoToolDbUtils;
import com.openindex.openestate.tool.ImmoToolTask;
import com.openindex.openestate.tool.ImmoToolTaskCancelledException;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.agency.AgencyAgent;
import com.openindex.openestate.tool.agency.AgencyContact;
import com.openindex.openestate.tool.agency.AgencyEstate;
import com.openindex.openestate.tool.agency.AgencyExportException;
import com.openindex.openestate.tool.agency.AgencyExportSummary;
import com.openindex.openestate.tool.agency.AgencyPluginUtils;
import com.openindex.openestate.tool.agency.export.AbstractExportPanel;
import com.openindex.openestate.tool.agency.export.FtpTransport;
import com.openindex.openestate.tool.utils.Service;
import eu.medsea.mimeutil.MimeType;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.TreeSet;
import javax.imageio.ImageIO;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.log4j.Logger;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.XMLDBException;
import org.xmldb.api.modules.BinaryResource;

public abstract class AbstractExport {
    private static final Logger LOGGER = Logger.getLogger(AbstractExport.class);
    private final DateFormat DATEFORMAT = new SimpleDateFormat("yyyy-MM-dd_HH-mm");
    public static final String KEY_INCREMENTAL = "export.incremental";
    public static final String KEY_LANGUAGE = "export.language";
    public static final String KEY_ZIPPED = "export.zipped";
    public static final String KEY_ID_PREFIX = "export.id_prefix";
    public static final String KEY_IMAGE_ALL = "export.image.all";
    public static final String KEY_IMAGE_COUNT = "export.image.count";
    public static final String KEY_IMAGE_SCALE = "export.image.scale";
    public static final String KEY_IMAGE_SCALE_WIDTH = "export.image.scale.width";
    public static final String KEY_IMAGE_SCALE_HEIGHT = "export.image.scale.height";
    public static final String KEY_IMAGE_WATERMARK = "export.image.watermark";
    public static final String KEY_IMAGE_WATERMARK_ALPHA = "export.image.watermark.alpha";
    public static final String KEY_IMAGE_WATERMARK_POSITION = "export.image.watermark.position";
    public static final String KEY_IMAGE_WATERMARK_WIDTH = "export.image.watermark.width";
    public static final String KEY_IMAGE_WATERMARK_HEIGHT = "export.image.watermark.height";
    public static final String KEY_MIME_TYPES = "export.mimetypes";
    public static final String KEY_VIDEO_COUNT = "export.video.count";
    public static final String KEY_UNPUBLISHED_ADDRESS_HIDDEN = "export.unpublishedAddressHidden";
    public static final String KEY_ENERGY_CERTIFICATE_APPENDED_TO_DESCRIPTION = "export.energyCertificateAppendedToDescription";
    public static final String KEY_IMAGEMODE = "export.imagemode";
    public static final String IMAGEMODE_DISABLED = "disabled";
    public static final String IMAGEMODE_FILE = "file";
    public static final String IMAGEMODE_BASE64 = "base64";
    @Deprecated
    private static final int OLD_IMAGEMODE_FILE = 0;
    @Deprecated
    private static final int OLD_IMAGEMODE_BASE64 = 1;
    public static final String POSITION_TOP_LEFT = "top.left";
    public static final String POSITION_TOP_CENTER = "top.center";
    public static final String POSITION_TOP_RIGHT = "top.right";
    public static final String POSITION_CENTER_LEFT = "center.left";
    public static final String POSITION_CENTER_CENTER = "center.center";
    public static final String POSITION_CENTER_RIGHT = "center.right";
    public static final String POSITION_BOTTOM_LEFT = "bottom.left";
    public static final String POSITION_BOTTOM_CENTER = "bottom.center";
    public static final String POSITION_BOTTOM_RIGHT = "bottom.right";
    private boolean incremental;
    private boolean fullTransferWarningShown;
    private boolean zipped;
    private boolean energyCertificateAppendedToDescription = false;
    private Locale locale;
    private String idPrefix;
    private File exportDirectory;
    private boolean allImagesExported;
    private boolean scaleImages;
    private Integer scaleImageWidth;
    private Integer scaleImageHeight;
    private boolean watermark;
    private String watermarkPosition;
    private Integer watermarkWidth;
    private Integer watermarkHeight;
    private Integer watermarkAlpha;
    private Integer imageCount;
    private Integer videoCount;
    private List<String> mimeTypes;
    private String imageMode = "file";
    private String addressPublishing = "default";
    private boolean unpublishedAddressHidden = false;
    private BufferedImage watermarkBaseLogo;

    public AbstractExport() {
        this.build();
    }

    private void build() {
        this.zipped = false;
        this.incremental = false;
        this.fullTransferWarningShown = true;
        this.exportDirectory = null;
        this.locale = null;
        this.allImagesExported = false;
        this.scaleImages = false;
        this.watermarkPosition = null;
        this.watermarkWidth = null;
        this.watermarkHeight = null;
        this.watermarkAlpha = null;
        this.mimeTypes = new ArrayList<String>();
        List<String> list = this.getRequiredMimeTypes();
        if (list != null) {
            this.mimeTypes.addAll(list);
        } else {
            for (String string : new String[]{"image/jpeg", "image/png"}) {
                if (StringUtils.isBlank((String)string)) continue;
                this.mimeTypes.add(new MimeType(string).toString());
            }
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected TransferImpl buildTransfer(AgencyExportSummary agencyExportSummary) throws AgencyExportException {
        TransferImpl transferImpl;
        this.initWatermarkLogo();
        Collection collection = null;
        Collection collection2 = null;
        try {
            String string;
            Object object;
            TransferAgencyImpl transferAgencyImpl = new TransferAgencyImpl();
            transferAgencyImpl.setAgent((AgentImpl)this.loadAgent());
            transferAgencyImpl.setRemoveUnmodifiedEstates(agencyExportSummary.isFullTransfer());
            transferAgencyImpl.getCustomValues().getValueMap().clear();
            TransferImpl transferImpl2 = new TransferImpl();
            transferImpl2.getAgencies().add(transferAgencyImpl);
            transferImpl2.setSenderSoftwareMail("dev@openestate.org");
            transferImpl2.setSenderSoftwareName(ImmoToolApp.getApplicationTitle());
            transferImpl2.setSenderSoftwareVersion(ImmoToolApp.getApplicationVersion());
            ArrayList<Long> arrayList = new ArrayList<Long>();
            for (Long l : agencyExportSummary.getUpdatedEstateIds()) {
                collection = this.loadEstateCollection();
                object = this.loadEstate(l, collection);
                ImmoToolDbUtils.close((Collection)collection);
                collection = null;
                if (object == null) {
                    LOGGER.warn((Object)("estate #" + l + " not found!"));
                    agencyExportSummary.getErrorEstateMap().put(l, "Property not found!");
                    continue;
                }
                if (!this.getEstateForUpdate((AgencyEstate)((Object)object))) {
                    LOGGER.warn((Object)("estate #" + l + " was denied!"));
                    agencyExportSummary.getErrorEstateMap().put(l, "Unsupported property!");
                    continue;
                }
                if ("always".equals(this.addressPublishing)) {
                    object.getAdress().setAdressPublished(true);
                } else if ("never".equals(this.addressPublishing)) {
                    object.getAdress().setAdressPublished(false);
                }
                if (this.unpublishedAddressHidden && !object.getAdress().isAdressPublished().booleanValue()) {
                    object.getAdress().setStreet(null);
                    object.getAdress().setStreet2(null);
                    object.getAdress().setStreetNr(null);
                }
                transferAgencyImpl.getEstatesToSave().add(object);
                string = object.getContactId();
                if (!StringUtils.isBlank((String)string)) {
                    try {
                        AgencyContact agencyContact;
                        String[] stringArray = string.split("\\.");
                        Long l2 = Long.valueOf(stringArray[stringArray.length - 1]);
                        if (!arrayList.contains(l2) && (agencyContact = this.loadAgentContact(l2)) != null) {
                            if (agencyContact.getCustomValues() != null) {
                                agencyContact.getCustomValues().getValueMap().clear();
                            }
                            transferAgencyImpl.getContacts().put(agencyContact.getId(), agencyContact);
                            arrayList.add(l2);
                        }
                    }
                    catch (Exception exception) {
                        LOGGER.warn((Object)("> invalid contact #" + string));
                        LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
                    }
                }
                if ((collection2 = AgencyPluginUtils.openPluginCollection("/estates/files/" + l.toString())) == null) continue;
                this.handleAttachments(l, (EstateImpl)object, collection2);
                ImmoToolDbUtils.close((Collection)collection2);
            }
            if (!agencyExportSummary.isFullTransfer()) {
                for (Long l : agencyExportSummary.getRemovedEstateIds()) {
                    if (l == null) continue;
                    object = this.getEstateIdForRemoval(l, agencyExportSummary);
                    string = this.getIdPrefix();
                    if (!StringUtils.isBlank((String)string)) {
                        object = string.trim() + "-" + (String)object;
                    }
                    transferAgencyImpl.getEstateIdsToRemove().add(object);
                }
            }
            transferImpl = transferImpl2;
        }
        catch (AgencyExportException agencyExportException) {
            try {
                LOGGER.warn((Object)agencyExportException.getLocalizedMessage(), (Throwable)((Object)agencyExportException));
                throw agencyExportException;
                catch (Exception exception) {
                    LOGGER.warn((Object)exception.getLocalizedMessage(), (Throwable)exception);
                    throw new AgencyExportException(exception);
                }
            }
            catch (Throwable throwable) {
                ImmoToolDbUtils.close(collection2);
                ImmoToolDbUtils.close(collection);
                throw throwable;
            }
        }
        ImmoToolDbUtils.close(collection2);
        ImmoToolDbUtils.close((Collection)collection);
        return transferImpl;
    }

    protected boolean canExportAttachment(long l, EstateAttachmentImpl estateAttachmentImpl) {
        if (IMAGEMODE_DISABLED.equals(this.getImageMode())) {
            return false;
        }
        if (!this.isAllImagesExported() && !estateAttachmentImpl.isPublished()) {
            return false;
        }
        return this.getMimeTypes().contains(estateAttachmentImpl.getMimeType());
    }

    protected boolean canTransportAttachment(long l, EstateAttachmentImpl estateAttachmentImpl) {
        return true;
    }

    public final BufferedImage convertImage(BinaryResource binaryResource) throws XMLDBException, IOException {
        return this.convertImage(new ByteArrayInputStream((byte[])binaryResource.getContent()));
    }

    public BufferedImage convertImage(InputStream inputStream) throws XMLDBException, IOException {
        BufferedImage bufferedImage = ImageIO.read(inputStream);
        BufferedImage bufferedImage2 = null;
        if (this.isScaleImages()) {
            int n;
            int n2 = this.getScaleImageWidth() != null ? this.getScaleImageWidth() : 0;
            int n3 = n = this.getScaleImageHeight() != null ? this.getScaleImageHeight() : 0;
            if (n2 > 0 && n > 0 && (bufferedImage.getWidth() > n2 || bufferedImage.getHeight() > n)) {
                BufferedImage bufferedImage3 = ImmoToolUtils.scaleImageAndKeepRatio((BufferedImage)bufferedImage, (int)n2, (int)n, (int)1);
                bufferedImage.flush();
                bufferedImage = bufferedImage3;
            }
        }
        bufferedImage2 = new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), 1);
        Graphics2D graphics2D = (Graphics2D)bufferedImage2.getGraphics();
        graphics2D.setColor(Color.WHITE);
        graphics2D.fillRect(0, 0, bufferedImage2.getWidth(), bufferedImage2.getHeight());
        graphics2D.drawImage((Image)bufferedImage, 0, 0, null);
        bufferedImage.flush();
        if (this.isWatermark() && this.watermarkBaseLogo != null) {
            BufferedImage bufferedImage4 = null;
            int n = 0;
            int n4 = 0;
            if (this.getWatermarkHeight() != null && this.getWatermarkWidth() != null && this.getWatermarkHeight() > 0 && this.getWatermarkWidth() > 0) {
                n = bufferedImage2.getWidth() > this.getWatermarkWidth() ? this.getWatermarkWidth().intValue() : bufferedImage2.getWidth();
                n4 = bufferedImage2.getHeight() > this.getWatermarkHeight() ? this.getWatermarkHeight().intValue() : bufferedImage2.getHeight();
            } else {
                n = (int)((double)bufferedImage2.getWidth() * 0.5);
                n4 = (int)((double)bufferedImage2.getHeight() * 0.5);
            }
            bufferedImage4 = this.watermarkBaseLogo.getWidth() <= n && this.watermarkBaseLogo.getHeight() <= n4 ? this.watermarkBaseLogo : ImmoToolUtils.scaleImageAndKeepRatio((BufferedImage)this.watermarkBaseLogo, (int)n, (int)n4, (int)2);
            int n5 = 0;
            int n6 = 0;
            if (POSITION_TOP_LEFT.equals(this.getWatermarkPosition())) {
                n5 = 0;
                n6 = 0;
            } else if (POSITION_TOP_CENTER.equals(this.getWatermarkPosition())) {
                n5 = (bufferedImage2.getWidth() - bufferedImage4.getWidth()) / 2;
                n6 = 0;
            } else if (POSITION_TOP_RIGHT.equals(this.getWatermarkPosition())) {
                n5 = bufferedImage2.getWidth() - bufferedImage4.getWidth();
                n6 = 0;
            } else if (POSITION_CENTER_LEFT.equals(this.getWatermarkPosition())) {
                n5 = 0;
                n6 = (bufferedImage2.getHeight() - bufferedImage4.getHeight()) / 2;
            } else if (POSITION_CENTER_CENTER.equals(this.getWatermarkPosition())) {
                n5 = (bufferedImage2.getWidth() - bufferedImage4.getWidth()) / 2;
                n6 = (bufferedImage2.getHeight() - bufferedImage4.getHeight()) / 2;
            } else if (POSITION_CENTER_RIGHT.equals(this.getWatermarkPosition())) {
                n5 = bufferedImage2.getWidth() - bufferedImage4.getWidth();
                n6 = (bufferedImage2.getHeight() - bufferedImage4.getHeight()) / 2;
            } else if (POSITION_BOTTOM_LEFT.equals(this.getWatermarkPosition())) {
                n5 = 0;
                n6 = bufferedImage2.getHeight() - bufferedImage4.getHeight();
            } else if (POSITION_BOTTOM_CENTER.equals(this.getWatermarkPosition())) {
                n5 = (bufferedImage2.getWidth() - bufferedImage4.getWidth()) / 2;
                n6 = bufferedImage2.getHeight() - bufferedImage4.getHeight();
            } else if (POSITION_BOTTOM_RIGHT.equals(this.getWatermarkPosition())) {
                n5 = bufferedImage2.getWidth() - bufferedImage4.getWidth();
                n6 = bufferedImage2.getHeight() - bufferedImage4.getHeight();
            }
            if (this.getWatermarkAlpha() != null && this.getWatermarkAlpha() < 100) {
                graphics2D.setComposite(AlphaComposite.getInstance(3, this.getWatermarkAlpha().floatValue() / 100.0f));
            }
            graphics2D.drawImage((Image)bufferedImage4, n5, n6, null);
            bufferedImage4.flush();
        }
        return bufferedImage2;
    }

    public abstract AbstractExportPanel createSetupPanel();

    public abstract File doExport(AgencyExportSummary var1, ImmoToolTask.Callback var2) throws AgencyExportException, ImmoToolTaskCancelledException;

    public void doFinishExport(AgencyExportSummary agencyExportSummary, String[] stringArray, ImmoToolTask.Callback callback) throws ImmoToolTaskCancelledException {
    }

    public void doFinishFtpTransport(FtpTransport ftpTransport, AgencyExportSummary agencyExportSummary, File file, FTPClient fTPClient, String string, ImmoToolTask.Callback callback) throws AgencyExportException, ImmoToolTaskCancelledException {
    }

    public void doPrepareFtpTransport(FtpTransport ftpTransport, AgencyExportSummary agencyExportSummary, File file, FTPClient fTPClient, String string, ImmoToolTask.Callback callback) throws AgencyExportException, ImmoToolTaskCancelledException {
    }

    public String getAddressPublishing() {
        return this.addressPublishing;
    }

    public File getAttachmentDirectory(EstateAttachmentImpl estateAttachmentImpl, File file) throws AgencyExportException {
        return this.getExportDirectory();
    }

    protected boolean getEstateForUpdate(AgencyEstate agencyEstate) {
        String string = this.getIdPrefix();
        if (!StringUtils.isBlank((String)string)) {
            if (!StringUtils.isBlank((String)agencyEstate.getId())) {
                agencyEstate.setId(string.trim() + "-" + agencyEstate.getId());
            }
            if (!StringUtils.isBlank((String)agencyEstate.getPublicId())) {
                agencyEstate.setPublicId(string.trim() + "-" + agencyEstate.getPublicId());
            }
        }
        if (!this.isAllImagesExported() && !agencyEstate.getAttachments().isEmpty()) {
            for (int i = agencyEstate.getAttachments().size() - 1; i >= 0; --i) {
                if (((EstateAttachmentImpl)agencyEstate.getAttachments().get(i)).isPublished()) continue;
                agencyEstate.getAttachments().remove(i);
            }
        }
        return true;
    }

    protected String getEstateIdForRemoval(Long l, AgencyExportSummary agencyExportSummary) {
        return "Estate." + l.toString();
    }

    public File getExportDirectory() throws AgencyExportException {
        try {
            if (this.exportDirectory == null) {
                File file = ImmoToolApp.getApplication().getProject().getTempDirectory();
                this.exportDirectory = new File(file.getAbsolutePath() + File.separator + System.currentTimeMillis());
                if (!this.exportDirectory.exists() && !this.exportDirectory.mkdir()) {
                    throw new Exception("could not create export-directory!");
                }
            }
            return this.exportDirectory;
        }
        catch (Exception exception) {
            this.exportDirectory = null;
            throw new AgencyExportException(exception);
        }
    }

    public String getIdPrefix() {
        return this.idPrefix;
    }

    public Integer getImageCount() {
        return this.imageCount;
    }

    public String getImageMode() {
        return this.imageMode;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public List<String> getMimeTypes() {
        return this.mimeTypes;
    }

    public abstract String getName();

    public static String[] getPositions() {
        return new String[]{POSITION_TOP_LEFT, POSITION_TOP_CENTER, POSITION_TOP_RIGHT, POSITION_CENTER_LEFT, POSITION_CENTER_CENTER, POSITION_CENTER_RIGHT, POSITION_BOTTOM_LEFT, POSITION_BOTTOM_CENTER, POSITION_BOTTOM_RIGHT};
    }

    public List<String> getRequiredMimeTypes() {
        return null;
    }

    public Integer getScaleImageHeight() {
        return this.scaleImageHeight;
    }

    public Integer getScaleImageWidth() {
        return this.scaleImageWidth;
    }

    public abstract String getTitle();

    public Integer getVideoCount() {
        return this.videoCount;
    }

    public Integer getWatermarkAlpha() {
        return this.watermarkAlpha;
    }

    public Integer getWatermarkHeight() {
        return this.watermarkHeight;
    }

    public String getWatermarkPosition() {
        return this.watermarkPosition;
    }

    public Integer getWatermarkWidth() {
        return this.watermarkWidth;
    }

    public String getZipFileName() {
        return this.isZipped() ? "transfer-" + this.DATEFORMAT.format(new Date()) + ".zip" : null;
    }

    protected void handleAttachments(long l, EstateImpl estateImpl, Collection collection) throws AgencyExportException {
        this.handleAttachmentsAsFiles(l, estateImpl, collection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected void handleAttachmentsAsBase64(long var1_1, EstateImpl var3_2, Collection var4_3) throws AgencyExportException {
        var5_4 = this.getImageCount() != null ? this.getImageCount() : -1;
        var6_5 = this.getVideoCount() != null ? this.getVideoCount() : -1;
        var7_6 = 0;
        var8_7 = 0;
        var9_8 = new ArrayList<EstateAttachmentImpl>();
        for (EstateAttachmentImpl var11_10 : var3_2.getAttachments()) {
            block15: {
                block14: {
                    block13: {
                        if (var11_10 == null || !var11_10.isName() || !this.canExportAttachment(var1_1, var11_10)) {
                            var9_8.add(var11_10);
                            continue;
                        }
                        var12_11 = var11_10.getMimeType();
                        if (var12_11 != null && var12_11.toLowerCase().startsWith("image/") && var5_4 > -1) {
                            if (var7_6 >= var5_4) {
                                var9_8.add(var11_10);
                                continue;
                            }
                            ++var7_6;
                        }
                        if (var12_11 != null && var12_11.toLowerCase().startsWith("video/") && var6_5 > -1) {
                            if (var8_7 >= var6_5) {
                                var9_8.add(var11_10);
                                continue;
                            }
                            ++var8_7;
                        }
                        if (!this.canTransportAttachment(var1_1, var11_10)) continue;
                        var13_12 = var11_10.getFileAsName();
                        var14_13 = null;
                        var15_14 = null;
                        var16_15 = null;
                        var14_13 = this.loadEstateAttachment(var1_1, var13_12, var4_3);
                        if (var14_13 != null) break block13;
                        AbstractExport.LOGGER.warn((Object)"Can't load attachment!");
                        AbstractExport.LOGGER.warn((Object)("> estate #" + var1_1));
                        AbstractExport.LOGGER.warn((Object)("> attachment " + var13_12));
                        var9_8.add(var11_10);
                        IOUtils.closeQuietly((InputStream)var16_15);
                        FileUtils.deleteQuietly((File)var14_13);
                        FileUtils.deleteQuietly((File)var15_14);
                        continue;
                    }
                    var17_16 = ImageIO.getImageWritersByMIMEType(var12_11).hasNext();
                    if (!var17_16) ** GOTO lbl69
                    var16_15 = new FileInputStream(var14_13);
                    var18_18 = this.convertImage(var16_15);
                    if (var18_18 != null) break block14;
                    AbstractExport.LOGGER.warn((Object)"Can't convert attached image!");
                    AbstractExport.LOGGER.warn((Object)("> estate #" + var1_1));
                    AbstractExport.LOGGER.warn((Object)("> attachment " + var13_12));
                    var9_8.add(var11_10);
                    IOUtils.closeQuietly((InputStream)var16_15);
                    FileUtils.deleteQuietly((File)var14_13);
                    FileUtils.deleteQuietly((File)var15_14);
                    continue;
                }
                try {
                    var15_14 = File.createTempFile("temp.", ".img");
                    ImageIO.write((RenderedImage)var18_18, "jpg", var15_14);
                    var11_10.setMimeType("image/jpeg");
                    var11_10.setFile(FileUtils.readFileToByteArray((File)var15_14));
                    break block15;
lbl69:
                    // 1 sources

                    var11_10.setFile(FileUtils.readFileToByteArray((File)var14_13));
                }
                catch (Exception var17_17) {
                    try {
                        var9_8.add(var11_10);
                        AbstractExport.LOGGER.warn((Object)"Can't store attachment!");
                        AbstractExport.LOGGER.warn((Object)("> name: " + var13_12));
                        AbstractExport.LOGGER.warn((Object)("> type: " + var12_11));
                        AbstractExport.LOGGER.warn((Object)("> " + var17_17.getLocalizedMessage()), (Throwable)var17_17);
                    }
                    catch (Throwable var19_19) {
                        IOUtils.closeQuietly(var16_15);
                        FileUtils.deleteQuietly((File)var14_13);
                        FileUtils.deleteQuietly(var15_14);
                        throw var19_19;
                    }
                    IOUtils.closeQuietly((InputStream)var16_15);
                    FileUtils.deleteQuietly((File)var14_13);
                    FileUtils.deleteQuietly((File)var15_14);
                    continue;
                }
            }
            IOUtils.closeQuietly((InputStream)var16_15);
            FileUtils.deleteQuietly((File)var14_13);
            FileUtils.deleteQuietly(var15_14);
        }
        for (EstateAttachmentImpl var11_10 : var9_8) {
            var3_2.getAttachments().remove(var11_10);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected void handleAttachmentsAsFiles(long var1_1, EstateImpl var3_2, Collection var4_3) throws AgencyExportException {
        var5_4 = this.getImageCount() != null ? this.getImageCount() : -1;
        var6_5 = this.getVideoCount() != null ? this.getVideoCount() : -1;
        var7_6 = 0;
        var8_7 = 0;
        var9_8 = new ArrayList<EstateAttachmentImpl>();
        for (EstateAttachmentImpl var11_10 : var3_2.getAttachments()) {
            block21: {
                block20: {
                    block19: {
                        block18: {
                            block17: {
                                if (var11_10 == null || !var11_10.isName() || !this.canExportAttachment(var1_1, var11_10)) {
                                    var9_8.add(var11_10);
                                    continue;
                                }
                                var12_11 = var11_10.getMimeType();
                                if (var12_11 != null && var12_11.toLowerCase().startsWith("image/") && var5_4 > -1) {
                                    if (var7_6 >= var5_4) {
                                        var9_8.add(var11_10);
                                        continue;
                                    }
                                    ++var7_6;
                                }
                                if (var12_11 != null && var12_11.toLowerCase().startsWith("video/") && var6_5 > -1) {
                                    if (var8_7 >= var6_5) {
                                        var9_8.add(var11_10);
                                        continue;
                                    }
                                    ++var8_7;
                                }
                                if (!this.canTransportAttachment(var1_1, var11_10)) continue;
                                var13_12 = var11_10.getFileAsName();
                                var14_13 = null;
                                var15_14 = null;
                                var14_13 = this.loadEstateAttachment(var1_1, var13_12, var4_3);
                                if (var14_13 != null) break block17;
                                AbstractExport.LOGGER.warn((Object)"Can't load attachment!");
                                AbstractExport.LOGGER.warn((Object)("> estate #" + var1_1));
                                AbstractExport.LOGGER.warn((Object)("> attachment " + var13_12));
                                var9_8.add(var11_10);
                                IOUtils.closeQuietly((InputStream)var15_14);
                                FileUtils.deleteQuietly((File)var14_13);
                                continue;
                            }
                            var16_15 = this.getAttachmentDirectory(var11_10, var14_13);
                            if (var16_15 != null) break block18;
                            AbstractExport.LOGGER.warn((Object)"Can't find a usable attachment directory!");
                            AbstractExport.LOGGER.warn((Object)("> estate #" + var1_1));
                            AbstractExport.LOGGER.warn((Object)("> attachment " + var13_12));
                            var9_8.add(var11_10);
                            IOUtils.closeQuietly((InputStream)var15_14);
                            FileUtils.deleteQuietly((File)var14_13);
                            continue;
                        }
                        if (var16_15.exists() || var16_15.mkdirs()) break block19;
                        AbstractExport.LOGGER.warn((Object)"Can't create attachment directory!");
                        AbstractExport.LOGGER.warn((Object)("> " + var16_15.getAbsolutePath()));
                        AbstractExport.LOGGER.warn((Object)("> estate #" + var1_1));
                        AbstractExport.LOGGER.warn((Object)("> attachment " + var13_12));
                        var9_8.add(var11_10);
                        IOUtils.closeQuietly((InputStream)var15_14);
                        FileUtils.deleteQuietly((File)var14_13);
                        continue;
                    }
                    var17_17 = ImageIO.getImageWritersByMIMEType(var12_11).hasNext();
                    if (!var17_17) ** GOTO lbl98
                    var15_14 = new FileInputStream(var14_13);
                    var18_18 = this.convertImage(var15_14);
                    if (var18_18 != null) break block20;
                    AbstractExport.LOGGER.warn((Object)"Can't convert attached image!");
                    AbstractExport.LOGGER.warn((Object)("> estate #" + var1_1));
                    AbstractExport.LOGGER.warn((Object)("> attachment " + var13_12));
                    var9_8.add(var11_10);
                    IOUtils.closeQuietly((InputStream)var15_14);
                    FileUtils.deleteQuietly((File)var14_13);
                    continue;
                }
                try {
                    var19_19 = System.currentTimeMillis() + ".jpg";
                    var20_20 = 0;
                    var21_22 = new File(var16_15.getAbsolutePath() + File.separator + var19_19);
                    while (var21_22.exists()) {
                        ++var20_20;
                        var19_19 = System.currentTimeMillis() + ".jpg";
                        var21_22 = new File(var16_15.getAbsolutePath() + File.separator + var19_19);
                    }
                    var11_10.setFile(var19_19);
                    var11_10.setMimeType("image/jpeg");
                    ImageIO.write((RenderedImage)var18_18, "jpg", var21_22);
                    var18_18.flush();
                    break block21;
lbl98:
                    // 1 sources

                    var18_18 = var11_10.getFileAsName();
                    var19_19 = var18_18.substring(var18_18.lastIndexOf("."));
                    var20_21 = System.currentTimeMillis() + var19_19;
                    var21_23 = 0;
                    var22_24 = new File(var16_15.getAbsolutePath() + File.separator + var20_21);
                    while (var22_24.exists()) {
                        ++var21_23;
                        var20_21 = System.currentTimeMillis() + var19_19;
                        var22_24 = new File(var16_15.getAbsolutePath() + File.separator + var20_21);
                    }
                    FileUtils.copyFile((File)var14_13, (File)var22_24);
                    var11_10.setFile(var20_21);
                }
                catch (Exception var16_16) {
                    try {
                        var9_8.add(var11_10);
                        AbstractExport.LOGGER.warn((Object)"Can't store attachment!");
                        AbstractExport.LOGGER.warn((Object)("> name: " + var13_12));
                        AbstractExport.LOGGER.warn((Object)("> type: " + var12_11));
                        AbstractExport.LOGGER.warn((Object)("> " + var16_16.getLocalizedMessage()), (Throwable)var16_16);
                    }
                    catch (Throwable var23_25) {
                        IOUtils.closeQuietly(var15_14);
                        FileUtils.deleteQuietly((File)var14_13);
                        throw var23_25;
                    }
                    IOUtils.closeQuietly((InputStream)var15_14);
                    FileUtils.deleteQuietly((File)var14_13);
                    continue;
                }
            }
            IOUtils.closeQuietly((InputStream)var15_14);
            FileUtils.deleteQuietly((File)var14_13);
        }
        for (EstateAttachmentImpl var11_10 : var9_8) {
            var3_2.getAttachments().remove(var11_10);
        }
    }

    protected void handleErrors(AgencyExportSummary agencyExportSummary, Map<String, String> map) {
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String string = entry.getKey();
            String string2 = entry.getValue();
            try {
                String[] stringArray = string.split("\\.");
                Long l = Long.valueOf(stringArray[stringArray.length - 1]);
                agencyExportSummary.getErrorEstateMap().put(l, string2);
                LOGGER.warn((Object)("could not export estate #" + l + "!"));
                LOGGER.warn((Object)("> " + string2));
            }
            catch (Exception exception) {
                LOGGER.warn((Object)"problem while parsing errors");
                LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
            }
        }
    }

    protected void initWatermarkLogo() {
        this.watermarkBaseLogo = null;
        if (this.isWatermark()) {
            try {
                this.watermarkBaseLogo = AgencyAgent.loadLogo();
            }
            catch (Exception exception) {
                this.watermarkBaseLogo = null;
                LOGGER.error((Object)"could not load agent-logo for watermarking!");
                LOGGER.error((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
            }
        }
    }

    public boolean isAllImagesExported() {
        return this.allImagesExported;
    }

    public boolean isEnergyCertificateAppendedToDescription() {
        return this.energyCertificateAppendedToDescription;
    }

    public boolean isFullTransportWarningShown() {
        return this.fullTransferWarningShown;
    }

    public boolean isImageModeBase64() {
        return IMAGEMODE_BASE64.equalsIgnoreCase(this.getImageMode());
    }

    public boolean isImageModeDisabled() {
        return IMAGEMODE_DISABLED.equalsIgnoreCase(this.getImageMode());
    }

    public boolean isImageModeFile() {
        return IMAGEMODE_FILE.equalsIgnoreCase(this.getImageMode());
    }

    public boolean isIncremental() {
        return this.supportsIncrementalUpdate() && this.incremental;
    }

    public boolean isScaleImages() {
        return this.scaleImages;
    }

    public boolean isUnpublishedAddressHidden() {
        return this.unpublishedAddressHidden;
    }

    public boolean isWatermark() {
        return this.watermark;
    }

    public boolean isZipped() {
        return this.zipped;
    }

    public static Map<String, AbstractExport> listAvailableExports() {
        HashMap<String, AbstractExport> hashMap = new HashMap<String, AbstractExport>();
        Iterator iterator = Service.providers(AbstractExport.class);
        while (iterator.hasNext()) {
            AbstractExport abstractExport = (AbstractExport)iterator.next();
            hashMap.put(abstractExport.getName(), abstractExport);
        }
        return hashMap;
    }

    public void load(Properties properties) {
        this.setAllImagesExported(ImmoToolUtils.getPropertyAsBoolean((String)KEY_IMAGE_ALL, (Boolean)false, (Properties)properties));
        this.setEnergyCertificateAppendedToDescription(ImmoToolUtils.getPropertyAsBoolean((String)KEY_ENERGY_CERTIFICATE_APPENDED_TO_DESCRIPTION, (Boolean)false, (Properties)properties));
        this.setIdPrefix(properties.getProperty(KEY_ID_PREFIX, ""));
        this.setImageCount(ImmoToolUtils.getPropertyAsInteger((String)KEY_IMAGE_COUNT, null, (Properties)properties));
        this.setScaleImages(ImmoToolUtils.getPropertyAsBoolean((String)KEY_IMAGE_SCALE, (Boolean)false, (Properties)properties));
        this.setScaleImageHeight(ImmoToolUtils.getPropertyAsInteger((String)KEY_IMAGE_SCALE_HEIGHT, null, (Properties)properties));
        this.setScaleImageWidth(ImmoToolUtils.getPropertyAsInteger((String)KEY_IMAGE_SCALE_WIDTH, null, (Properties)properties));
        this.setUnpublishedAddressHidden(ImmoToolUtils.getPropertyAsBoolean((String)KEY_UNPUBLISHED_ADDRESS_HIDDEN, (Boolean)false, (Properties)properties));
        this.setVideoCount(ImmoToolUtils.getPropertyAsInteger((String)KEY_VIDEO_COUNT, null, (Properties)properties));
        this.setWatermark(ImmoToolUtils.getPropertyAsBoolean((String)KEY_IMAGE_WATERMARK, (Boolean)false, (Properties)properties));
        this.setWatermarkAlpha(ImmoToolUtils.getPropertyAsInteger((String)KEY_IMAGE_WATERMARK_ALPHA, null, (Properties)properties));
        this.setWatermarkHeight(ImmoToolUtils.getPropertyAsInteger((String)KEY_IMAGE_WATERMARK_HEIGHT, null, (Properties)properties));
        this.setWatermarkWidth(ImmoToolUtils.getPropertyAsInteger((String)KEY_IMAGE_WATERMARK_WIDTH, null, (Properties)properties));
        this.setWatermarkPosition(properties.getProperty(KEY_IMAGE_WATERMARK_POSITION));
        this.setZipped(ImmoToolUtils.getPropertyAsBoolean((String)KEY_ZIPPED, (Boolean)this.isZipped(), (Properties)properties));
        String string = properties.getProperty(KEY_LANGUAGE, this.getLocale() != null ? this.getLocale().toString() : null);
        this.setLanguage(string != null ? OpenEstateUtils.buildLocale((String)string) : null);
        this.mimeTypes.clear();
        List<String> list = this.getRequiredMimeTypes();
        if (list != null) {
            this.mimeTypes.addAll(list);
        } else {
            String[] stringArray;
            String string2 = "image/jpeg,image/png";
            for (String string3 : stringArray = properties.getProperty(KEY_MIME_TYPES, string2).split(",")) {
                if (StringUtils.isBlank((String)string3)) continue;
                this.mimeTypes.add(new MimeType(string3).toString());
            }
        }
    }

    protected AgencyAgent loadAgent() throws ImmoToolDbException {
        return AgencyAgent.loadAgent();
    }

    protected AgencyContact loadAgentContact(long l) throws ImmoToolDbException {
        return AgencyContact.loadContact(l);
    }

    protected AgencyEstate loadEstate(Long l, Collection collection) throws ImmoToolDbException {
        return AgencyEstate.loadEstate(l, collection);
    }

    protected File loadEstateAttachment(long l, String string, Collection collection) throws ImmoToolDbException {
        return AgencyEstate.loadAttachmentAsTempFile(l, string, collection);
    }

    protected Collection loadEstateCollection() throws ImmoToolDbException {
        return AgencyPluginUtils.openPluginCollection("/estates");
    }

    protected Long[] loadEstateIds(Collection collection) throws ImmoToolDbException {
        try {
            TreeSet<Long> treeSet = new TreeSet<Long>();
            for (String string : collection.listResources()) {
                if (!string.startsWith("Estate.")) continue;
                String[] stringArray = string.split("\\.");
                treeSet.add(Long.valueOf(stringArray[1]));
            }
            return treeSet.toArray(new Long[treeSet.size()]);
        }
        catch (Exception exception) {
            throw new ImmoToolDbException(exception.getLocalizedMessage(), (Throwable)exception);
        }
    }

    public void save(Properties properties) {
        properties.setProperty(KEY_ENERGY_CERTIFICATE_APPENDED_TO_DESCRIPTION, String.valueOf(this.isEnergyCertificateAppendedToDescription()));
        properties.setProperty(KEY_ID_PREFIX, this.getIdPrefix() != null ? this.getIdPrefix() : "");
        properties.setProperty(KEY_IMAGE_ALL, String.valueOf(this.isAllImagesExported()));
        properties.setProperty(KEY_IMAGE_SCALE, String.valueOf(this.isScaleImages()));
        properties.setProperty(KEY_IMAGE_SCALE_HEIGHT, this.isScaleImages() && this.getScaleImageHeight() != null ? this.getScaleImageHeight().toString() : "0");
        properties.setProperty(KEY_IMAGE_SCALE_WIDTH, this.isScaleImages() && this.getScaleImageWidth() != null ? this.getScaleImageWidth().toString() : "0");
        properties.setProperty(KEY_IMAGE_WATERMARK, String.valueOf(this.isWatermark()));
        properties.setProperty(KEY_IMAGE_WATERMARK_ALPHA, this.isWatermark() && this.getWatermarkAlpha() != null ? this.getWatermarkAlpha().toString() : "0");
        properties.setProperty(KEY_IMAGE_WATERMARK_HEIGHT, this.isWatermark() && this.getWatermarkHeight() != null ? this.getWatermarkHeight().toString() : "0");
        properties.setProperty(KEY_IMAGE_WATERMARK_WIDTH, this.isWatermark() && this.getWatermarkWidth() != null ? this.getWatermarkWidth().toString() : "0");
        properties.setProperty(KEY_IMAGE_WATERMARK_POSITION, this.isWatermark() && this.getWatermarkPosition() != null ? this.getWatermarkPosition() : "");
        properties.setProperty(KEY_LANGUAGE, this.getLocale() != null ? this.getLocale().toString() : Locale.getDefault().toString());
        properties.setProperty(KEY_UNPUBLISHED_ADDRESS_HIDDEN, String.valueOf(this.isUnpublishedAddressHidden()));
        properties.setProperty(KEY_ZIPPED, String.valueOf(this.isZipped()));
        if (this.getImageCount() != null) {
            properties.setProperty(KEY_IMAGE_COUNT, this.getImageCount().toString());
        } else {
            properties.remove(KEY_IMAGE_COUNT);
        }
        if (this.getVideoCount() != null) {
            properties.setProperty(KEY_VIDEO_COUNT, this.getVideoCount().toString());
        } else {
            properties.remove(KEY_VIDEO_COUNT);
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : this.getMimeTypes()) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(",");
            }
            stringBuilder.append(string);
        }
        properties.setProperty(KEY_MIME_TYPES, stringBuilder.toString());
    }

    public void setAddressPublishing(String string) {
        this.addressPublishing = string;
    }

    public void setAllImagesExported(boolean bl) {
        this.allImagesExported = bl;
    }

    public void setEnergyCertificateAppendedToDescription(boolean bl) {
        this.energyCertificateAppendedToDescription = bl;
    }

    protected void setFullTransportWarningShown(boolean bl) {
        this.fullTransferWarningShown = bl;
    }

    public void setIdPrefix(String string) {
        this.idPrefix = string != null ? string.trim() : "";
    }

    public void setImageCount(Integer n) {
        this.imageCount = n;
    }

    public void setImageMode(String string) {
        this.imageMode = String.valueOf(1).equals(string) ? IMAGEMODE_BASE64 : (String.valueOf(0).equals(string) ? IMAGEMODE_FILE : (string != null ? string : IMAGEMODE_DISABLED));
    }

    public void setIncremental(boolean bl) {
        this.incremental = this.supportsIncrementalUpdate() && bl;
    }

    public void setLanguage(Locale locale) {
        this.locale = locale;
    }

    public void setScaleImageHeight(Integer n) {
        this.scaleImageHeight = n;
    }

    public void setScaleImageWidth(Integer n) {
        this.scaleImageWidth = n;
    }

    public void setScaleImages(boolean bl) {
        this.scaleImages = bl;
    }

    public void setUnpublishedAddressHidden(boolean bl) {
        this.unpublishedAddressHidden = bl;
    }

    public void setVideoCount(Integer n) {
        this.videoCount = n;
    }

    public void setWatermark(boolean bl) {
        this.watermark = bl;
    }

    public void setWatermarkAlpha(Integer n) {
        this.watermarkAlpha = n != null && n > 0 && n <= 100 ? n : null;
    }

    public void setWatermarkHeight(Integer n) {
        this.watermarkHeight = n != null && n > 0 ? n : null;
    }

    public void setWatermarkPosition(String string) {
        if (string == null) {
            this.watermarkPosition = null;
            return;
        }
        for (String string2 : AbstractExport.getPositions()) {
            if (!string2.equalsIgnoreCase(string.trim())) continue;
            this.watermarkPosition = string2;
            return;
        }
        this.watermarkPosition = null;
    }

    public void setWatermarkWidth(Integer n) {
        this.watermarkWidth = n != null && n > 0 ? n : null;
    }

    public void setZipped(boolean bl) {
        this.zipped = bl;
    }

    public boolean supportsEstateType(String string, String string2) {
        return true;
    }

    public abstract boolean supportsIncrementalUpdate();
}

