/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency.export;

import com.openindex.openestate.impl.EstateImpl;
import com.openindex.openestate.impl.SerializableXmlElement;
import com.openindex.openestate.impl.TransferImpl;
import com.openindex.openestate.tool.ImmoToolTask;
import com.openindex.openestate.tool.ImmoToolTaskCancelledException;
import com.openindex.openestate.tool.agency.AgencyExportException;
import com.openindex.openestate.tool.agency.AgencyExportSummary;
import com.openindex.openestate.tool.agency.export.AbstractExport;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.xmldb.api.base.Collection;

public abstract class AbstractXmlExport
extends AbstractExport {
    private final SimpleDateFormat DATEFORMAT = new SimpleDateFormat("yyyy-MM-dd_HH-mm");
    public static final String KEY_LINEBREAK = "export.linebreak";
    public static final String LINEBREAK_HTML = "html";
    public static final String LINEBREAK_XHTML = "xhtml";
    public static final String LINEBREAK_NATIVE = "native";
    private String lineBreak = "xhtml";

    protected void buildFileList(File file, String string, StringBuilder stringBuilder) {
        if (file == null || !file.exists()) {
            return;
        }
        if (file.isDirectory()) {
            for (File file2 : file.listFiles()) {
                this.buildFileList(file2, string + file.getName() + "/", stringBuilder);
            }
            stringBuilder.append(string).append(file.getName()).append("/\n");
        } else {
            stringBuilder.append(string).append(file.getName()).append("\n");
        }
    }

    public Object doConvert(AgencyExportSummary agencyExportSummary, SerializableXmlElement serializableXmlElement, boolean bl, Map<String, String> map) {
        return serializableXmlElement;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public File doExport(AgencyExportSummary agencyExportSummary, ImmoToolTask.Callback callback) throws AgencyExportException, ImmoToolTaskCancelledException {
        File file;
        FileWriter fileWriter = null;
        try {
            File file2 = this.getExportDirectory();
            if (file2 == null || !file2.exists() && !file2.mkdirs()) {
                throw new Exception("could not create temp-directory!");
            }
            callback.checkCancelled();
            TransferImpl transferImpl = this.buildTransfer(agencyExportSummary);
            HashMap<String, String> hashMap = new HashMap<String, String>();
            Object object = this.doConvert(agencyExportSummary, (SerializableXmlElement)transferImpl, !agencyExportSummary.isFullTransfer(), hashMap);
            callback.checkCancelled();
            if (!hashMap.isEmpty()) {
                this.handleErrors(agencyExportSummary, hashMap);
            }
            callback.checkCancelled();
            File file3 = new File(file2.getAbsolutePath() + File.separator + this.getXmlFileName());
            fileWriter = new FileWriter(file3);
            this.doWrite(object, fileWriter);
            fileWriter.flush();
            file = file2;
        }
        catch (AgencyExportException agencyExportException) {
            try {
                throw agencyExportException;
                catch (ImmoToolTaskCancelledException immoToolTaskCancelledException) {
                    throw immoToolTaskCancelledException;
                }
                catch (Exception exception) {
                    throw new AgencyExportException(exception);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fileWriter);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Writer)fileWriter);
        return file;
    }

    protected abstract void doWrite(Object var1, Writer var2) throws IOException;

    public String getLineBreak() {
        return this.lineBreak;
    }

    public String getXmlFileName() {
        return "transfer-" + this.DATEFORMAT.format(new Date()) + ".xml";
    }

    @Override
    protected void handleAttachments(long l, EstateImpl estateImpl, Collection collection) throws AgencyExportException {
        if (this.isImageModeBase64()) {
            this.handleAttachmentsAsBase64(l, estateImpl, collection);
        } else if (this.isImageModeFile()) {
            this.handleAttachmentsAsFiles(l, estateImpl, collection);
        } else {
            if (this.isImageModeDisabled()) {
                return;
            }
            throw new AgencyExportException("invalid attachment-type!");
        }
    }

    public void setLineBreak(String string) {
        this.lineBreak = string;
    }
}

