/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency.export;

import com.openindex.openestate.tool.ImmoToolTask;
import com.openindex.openestate.tool.ImmoToolTaskCancelledException;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.agency.AgencyExportException;
import com.openindex.openestate.tool.agency.AgencyExportSummary;
import com.openindex.openestate.tool.agency.export.AbstractExport;
import com.openindex.openestate.tool.agency.export.AbstractTransport;
import com.openindex.openestate.tool.agency.export.AbstractTransportPanel;
import com.openindex.openestate.tool.agency.export.FtpTransportPanel;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.IDN;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.io.CopyStreamEvent;
import org.apache.commons.net.io.CopyStreamListener;
import org.apache.log4j.Logger;
import org.jdesktop.application.ResourceMap;

public class FtpTransport
extends AbstractTransport {
    private static final Logger LOGGER = Logger.getLogger(FtpTransport.class);
    public static final String NAME = "ftp";
    public static final String KEY_FTP_HOST = "transport.ftp.host";
    public static final String KEY_FTP_PORT = "transport.ftp.port";
    public static final String KEY_FTP_USER = "transport.ftp.user";
    public static final String KEY_FTP_PASS = "transport.ftp.pass";
    public static final String KEY_FTP_PATH = "transport.ftp.path";
    public static final String KEY_FTP_ANONYMOUS = "transport.ftp.anonymous";
    public static final String KEY_FTP_PASSIVE = "transport.ftp.passive";
    private ResourceMap resourceMap = ImmoToolUtils.getResourceMap(FtpTransport.class);
    private String ftpHost = "";
    private int ftpPort = 21;
    private String ftpUser = "";
    private String ftpPass = "";
    private String ftpPath = "/";
    private boolean ftpAnonymous = false;
    private boolean ftpPassive = true;
    private FTPClient currentFtpClient = null;

    @Override
    public synchronized void cancelTransport() {
        this.doCancel(this.currentFtpClient);
    }

    @Override
    public AbstractTransportPanel createSetupPanel() {
        return new FtpTransportPanel();
    }

    private void doCancel(FTPClient fTPClient) {
        try {
            if (fTPClient != null && fTPClient.isConnected()) {
                fTPClient.disconnect();
            }
        }
        catch (Exception exception) {
            LOGGER.warn((Object)"Can't disconnect from ftp server!");
            LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
        }
    }

    private FTPClient doConnect() throws IOException {
        String string = null;
        try {
            string = IDN.toASCII(this.getFtpHost());
        }
        catch (Exception exception) {
            string = this.getFtpHost();
            LOGGER.warn((Object)"Can't parse international host-name!");
            LOGGER.warn((Object)("> Falling back to: " + string));
            LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
        }
        FTPClient fTPClient = ImmoToolUtils.openFtpClient((String)string, (int)this.getFtpPort(), (boolean)this.isFtpPassive());
        if (!this.isFtpAnonymous()) {
            if (!fTPClient.login(this.getFtpUser(), this.getFtpPass())) {
                throw new IOException("Login failed!");
            }
            fTPClient.sendNoOp();
        }
        return fTPClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doSend(File file, String string, int n, ImmoToolTask.Callback callback) throws AgencyExportException, ImmoToolTaskCancelledException {
        block24: {
            block25: {
                if (!file.isFile()) break block25;
                String string2 = string;
                if (!string2.endsWith("/")) {
                    string2 = string2 + "/";
                }
                string2 = string2 + file.getName();
                FileInputStream fileInputStream = null;
                try {
                    callback.checkCancelled();
                    fileInputStream = new FileInputStream(file);
                    this.currentFtpClient.sendNoOp();
                    if (!this.currentFtpClient.setFileType(2)) {
                        LOGGER.warn((Object)"Can't change file-type!");
                    }
                    if (!this.currentFtpClient.storeFile(file.getName(), (InputStream)fileInputStream)) {
                        throw new AgencyExportException("Can't store file: " + string2);
                    }
                    this.currentFtpClient.sendNoOp();
                }
                catch (IOException iOException) {
                    block23: {
                        try {
                            LOGGER.error((Object)("Can't store file '" + file.getName() + "' into remote folder '" + string2 + "'!"));
                            LOGGER.error((Object)("> " + iOException.getLocalizedMessage()), (Throwable)iOException);
                            if (n < 3) {
                                callback.checkCancelled();
                                this.doCancel(this.currentFtpClient);
                                LOGGER.info((Object)("Trying to reconnect, attempt #" + ++n));
                                try {
                                    LOGGER.info((Object)"> Waiting for 15 seconds...");
                                    Thread.sleep(15000L);
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                try {
                                    callback.checkCancelled();
                                    LOGGER.info((Object)"> Reconnecting...");
                                    this.currentFtpClient = this.doConnect();
                                    if (!StringUtils.isBlank((String)string) && !this.currentFtpClient.changeWorkingDirectory(string)) {
                                        throw new AgencyExportException("Can't change working directory: " + string);
                                    }
                                    this.currentFtpClient.sendNoOp();
                                    this.doSend(file, string, n, callback);
                                    break block23;
                                }
                                catch (IOException iOException2) {
                                    LOGGER.info((Object)("> Reconnecting failed: " + iOException2.getLocalizedMessage()));
                                    throw new AgencyExportException("Can't reconnect to FTP server after a crashed transfer!", iOException2);
                                }
                            }
                            throw new AgencyExportException("Can't send '" + file.getName() + "' into remote folder '" + string2 + "'!", iOException);
                        }
                        catch (Throwable throwable) {
                            IOUtils.closeQuietly(fileInputStream);
                            throw throwable;
                        }
                    }
                    IOUtils.closeQuietly((InputStream)fileInputStream);
                    break block24;
                }
                IOUtils.closeQuietly((InputStream)fileInputStream);
                break block24;
            }
            if (file.isDirectory()) {
                String string3 = string;
                if (!string3.endsWith("/")) {
                    string3 = string3 + "/";
                }
                string3 = string3 + file.getName();
                try {
                    callback.checkCancelled();
                    String[] stringArray = this.currentFtpClient.listNames();
                    if (stringArray == null) {
                        stringArray = new String[]{};
                    }
                    this.currentFtpClient.sendNoOp();
                    List<String> list = Arrays.asList(stringArray);
                    if (!list.contains(file.getName())) {
                        if (!this.currentFtpClient.makeDirectory(file.getName())) {
                            throw new AgencyExportException("Can't make directory: " + string3);
                        }
                        this.currentFtpClient.sendNoOp();
                    }
                    callback.checkCancelled();
                    if (!this.currentFtpClient.changeWorkingDirectory(file.getName())) {
                        throw new AgencyExportException("Can't change working directory: " + string3);
                    }
                    this.currentFtpClient.sendNoOp();
                    for (File file2 : file.listFiles()) {
                        callback.checkCancelled();
                        this.doSend(file2, string3 + "/", 0, callback);
                    }
                    if (!this.currentFtpClient.changeToParentDirectory()) {
                        throw new AgencyExportException("Can't change to parent directory of " + string3);
                    }
                    break block24;
                }
                catch (IOException iOException) {
                    throw new AgencyExportException("Can't send folder '" + file.getName() + "'!", iOException);
                }
            }
            throw new AgencyExportException("Invalid source file '" + file.getAbsolutePath() + "'!");
        }
    }

    @Override
    public synchronized void doTransport(File file, AbstractExport abstractExport, AgencyExportSummary agencyExportSummary, final ImmoToolTask.Callback callback) throws AgencyExportException, ImmoToolTaskCancelledException {
        if (this.currentFtpClient != null) {
            this.cancelTransport();
        }
        this.currentFtpClient = null;
        final long l = file.isDirectory() ? FileUtils.sizeOfDirectory((File)file) : file.length();
        try {
            callback.checkCancelled();
            this.currentFtpClient = this.doConnect();
            this.currentFtpClient.setCopyStreamListener(new CopyStreamListener(){
                private int currentPercentage = -1;
                private long totalBytesExported = 0L;

                public void bytesTransferred(CopyStreamEvent copyStreamEvent) {
                }

                public void bytesTransferred(long l3, int n, long l2) {
                    this.totalBytesExported += (long)n;
                    int n2 = (int)((double)this.totalBytesExported / (double)l * 100.0);
                    if (n2 <= 100 && n2 > this.currentPercentage) {
                        this.currentPercentage = n2;
                        if (this.currentPercentage % 5 == 0) {
                            callback.setMessage("> " + this.currentPercentage + " % (" + ImmoToolUtils.getHumanReadableByteCount((long)this.totalBytesExported) + " / " + ImmoToolUtils.getHumanReadableByteCount((long)l) + ")");
                        }
                    }
                    try {
                        callback.checkCancelled();
                    }
                    catch (ImmoToolTaskCancelledException immoToolTaskCancelledException) {
                        throw new RuntimeException("Transfer was cancelled by user!", immoToolTaskCancelledException);
                    }
                }
            });
            String string = this.getFtpPath();
            string = string == null ? "" : string.trim();
            if (!StringUtils.isBlank((String)string)) {
                if (!this.currentFtpClient.changeWorkingDirectory(string)) {
                    throw new AgencyExportException("Can't change working directory: " + string);
                }
                this.currentFtpClient.sendNoOp();
            }
            callback.checkCancelled();
            abstractExport.doPrepareFtpTransport(this, agencyExportSummary, file, this.currentFtpClient, string, callback);
            if (file.isDirectory()) {
                for (File file2 : file.listFiles()) {
                    this.doSend(file2, string, 0, callback);
                }
            } else if (file.isFile()) {
                this.doSend(file, string, 0, callback);
            } else {
                throw new AgencyExportException("Invalid transfer file: " + file.getAbsolutePath());
            }
            abstractExport.doFinishFtpTransport(this, agencyExportSummary, file, this.currentFtpClient, string, callback);
        }
        catch (IOException iOException) {
            throw new AgencyExportException("FTP transport failed!", iOException);
        }
        finally {
            try {
                if (this.currentFtpClient != null && this.currentFtpClient.isConnected()) {
                    this.currentFtpClient.disconnect();
                }
            }
            catch (Exception exception) {
                LOGGER.warn((Object)"error on disconnection!");
                LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
            }
        }
    }

    public String getFtpHost() {
        return this.ftpHost;
    }

    public String getFtpPass() {
        return this.ftpPass;
    }

    public String getFtpPath() {
        return this.ftpPath;
    }

    public int getFtpPort() {
        return this.ftpPort;
    }

    public String getFtpUser() {
        return this.ftpUser;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getTitle() {
        return this.resourceMap.getString("title", new Object[0]);
    }

    public boolean isFtpAnonymous() {
        return this.ftpAnonymous;
    }

    public boolean isFtpPassive() {
        return this.ftpPassive;
    }

    @Override
    public void load(Properties properties) {
        super.load(properties);
        this.setFtpHost(properties.getProperty(KEY_FTP_HOST, "").trim());
        this.setFtpPort(Integer.valueOf(properties.getProperty(KEY_FTP_PORT, "21")));
        this.setFtpPath(properties.getProperty(KEY_FTP_PATH, "/").trim());
        this.setFtpPassive(Boolean.valueOf(properties.getProperty(KEY_FTP_PASSIVE, "false")));
        this.setFtpAnonymous(Boolean.valueOf(properties.getProperty(KEY_FTP_ANONYMOUS, "false")));
        this.setFtpUser(!this.isFtpAnonymous() ? properties.getProperty(KEY_FTP_USER, "").trim() : "");
        this.setFtpPass(!this.isFtpAnonymous() ? properties.getProperty(KEY_FTP_PASS, "").trim() : "");
    }

    @Override
    public void save(Properties properties) {
        super.save(properties);
        properties.setProperty(KEY_FTP_HOST, this.getFtpHost());
        properties.setProperty(KEY_FTP_PORT, String.valueOf(this.getFtpPort()));
        properties.setProperty(KEY_FTP_PATH, this.getFtpPath());
        properties.setProperty(KEY_FTP_PASSIVE, String.valueOf(this.isFtpPassive()));
        properties.setProperty(KEY_FTP_ANONYMOUS, String.valueOf(this.isFtpAnonymous()));
        properties.setProperty(KEY_FTP_USER, !this.isFtpAnonymous() ? this.getFtpUser() : "");
        properties.setProperty(KEY_FTP_PASS, !this.isFtpAnonymous() ? this.getFtpPass() : "");
    }

    public void setFtpAnonymous(boolean bl) {
        this.ftpAnonymous = bl;
    }

    public void setFtpHost(String string) {
        this.ftpHost = string;
    }

    public void setFtpPass(String string) {
        this.ftpPass = string;
    }

    public void setFtpPassive(boolean bl) {
        this.ftpPassive = bl;
    }

    public void setFtpPath(String string) {
        this.ftpPath = string;
    }

    public void setFtpPort(int n) {
        this.ftpPort = n;
    }

    public void setFtpUser(String string) {
        this.ftpUser = string;
    }
}

