/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency.export;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.openindex.openestate.tool.ImmoToolTask;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.agency.export.AbstractTransport;
import com.openindex.openestate.tool.agency.export.AbstractTransportPanel;
import com.openindex.openestate.tool.agency.export.FtpTransport;
import com.openindex.openestate.tool.utils.FormatterRule;
import com.openindex.openestate.tool.utils.ValidationHandler;
import com.openindex.openestate.tool.utils.ValidationRule;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.IDN;
import java.text.NumberFormat;
import java.util.List;
import javax.swing.ActionMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.log4j.Logger;
import org.jdesktop.application.Action;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.application.Task;
import org.jdesktop.swingx.JXBusyLabel;

public class FtpTransportPanel
extends AbstractTransportPanel {
    private static final Logger LOGGER = Logger.getLogger(FtpTransportPanel.class);
    private ActionMap actionMap;
    private ResourceMap resourceMap;
    private ValidationHandler validationHandler;
    private JTextField ftpHostField;
    private JFormattedTextField ftpPortField;
    private JTextField ftpUserField;
    private JPasswordField ftpPassField;
    private JTextField ftpPathField;
    private JCheckBox ftpAnonymousModeBox;
    private JCheckBox ftpPassiveModeBox;
    private JButton ftpTestButton;
    private JXBusyLabel ftpTestLabel;
    private Task ftpTask = null;

    public FtpTransportPanel() {
        this.build();
    }

    private void build() {
        this.actionMap = ImmoToolUtils.getActionMap(FtpTransportPanel.class, (Object)this);
        this.resourceMap = ImmoToolUtils.getResourceMap(FtpTransportPanel.class);
        this.validationHandler = ImmoToolUtils.createValidationHandler();
        this.buildForm();
        this.resourceMap.injectComponents((Component)this);
        this.validationHandler.init();
        this.ftpTestButton.setAction(this.actionMap.get(this.ftpTestButton.getText()));
        this.ftpAnonymousModeBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FtpTransportPanel.this.ftpUserField.setEnabled(!FtpTransportPanel.this.ftpAnonymousModeBox.isSelected());
                FtpTransportPanel.this.ftpPassField.setEnabled(!FtpTransportPanel.this.ftpAnonymousModeBox.isSelected());
                FtpTransportPanel.this.validationHandler.validate((JComponent)FtpTransportPanel.this.ftpUserField);
                FtpTransportPanel.this.validationHandler.validate((JComponent)FtpTransportPanel.this.ftpPassField);
            }
        });
    }

    private void buildForm() {
        this.ftpHostField = new JTextField();
        this.ftpHostField.setName("ftpHostField");
        this.ftpPortField = new JFormattedTextField(NumberFormat.getIntegerInstance());
        this.ftpPortField.setName("ftpPortField");
        this.ftpPortField.setValue(21L);
        this.ftpUserField = new JTextField();
        this.ftpUserField.setName("ftpUserField");
        this.ftpPassField = new JPasswordField();
        this.ftpPassField.setName("ftpPassField");
        this.ftpPathField = new JTextField();
        this.ftpPathField.setName("ftpPathField");
        this.ftpAnonymousModeBox = new JCheckBox();
        this.ftpAnonymousModeBox.setName("ftpAnonymousModeBox");
        this.ftpPassiveModeBox = new JCheckBox();
        this.ftpPassiveModeBox.setName("ftpPassiveModeBox");
        this.ftpTestButton = new JButton("doFtpTest");
        this.ftpTestButton.setName("ftpTestButton");
        this.ftpTestLabel = new JXBusyLabel();
        this.ftpTestLabel.setName("ftpTestLabel");
        this.ftpTestLabel.setVisible(false);
        this.validationHandler.putRule((JComponent)this.ftpHostField, ValidationHandler.NOT_BLANK);
        this.validationHandler.putRule((JComponent)this.ftpPortField, (ValidationRule)new FormatterRule(this.ftpPortField));
        this.validationHandler.putRule((JComponent)this.ftpUserField, ValidationHandler.NOT_BLANK);
        this.validationHandler.putRule((JComponent)this.ftpPassField, ValidationHandler.NOT_BLANK);
        DefaultFormBuilder defaultFormBuilder = ImmoToolUtils.createFormBuilder((String)"right:50dlu, 3dlu, 30dlu:grow, 3dlu,right:pref, 3dlu, 30dlu", (JPanel)this);
        defaultFormBuilder.append(this.resourceMap.getString("label.ftpHostField", new Object[0]), (Component)this.ftpHostField);
        defaultFormBuilder.append(this.resourceMap.getString("label.ftpPortField", new Object[0]), (Component)this.ftpPortField);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(this.resourceMap.getString("label.ftpAnonymousModeBox", new Object[0]), (Component)this.ftpAnonymousModeBox, 5);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(this.resourceMap.getString("label.ftpUserField", new Object[0]), (Component)this.ftpUserField, 5);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(this.resourceMap.getString("label.ftpPassField", new Object[0]), (Component)this.ftpPassField, 5);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(this.resourceMap.getString("label.ftpPathField", new Object[0]), (Component)this.ftpPathField, 5);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(this.resourceMap.getString("label.ftpPassiveModeBox", new Object[0]), (Component)this.ftpPassiveModeBox);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append((Component)new JLabel(" "), 7);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append((Component)ImmoToolUtils.createHead2Separator((String)this.resourceMap.getString("label.ftpTest", new Object[0])), 7);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append((Component)this.ftpTestButton);
        defaultFormBuilder.append((Component)this.ftpTestLabel, 5);
        defaultFormBuilder.nextLine();
        this.revalidate();
        this.repaint();
    }

    @Action
    public void doFtpTest() {
        this.validationHandler.validate();
        if (!this.validationHandler.isValid()) {
            ImmoToolUtils.showMessageErrorDialog((String)this.resourceMap.getString("error.invalidFtpSetup", new Object[0]));
            return;
        }
        if (this.ftpTask == null) {
            this.ftpTestButton.setText(this.resourceMap.getString("label.cancel", new Object[0]));
            this.ftpTestLabel.setBusy(true);
            this.ftpTestLabel.setText(this.resourceMap.getString("message.doTestFtp", new Object[0]));
            this.ftpTestLabel.setVisible(true);
            this.ftpTask = new ImmoToolTask<Boolean>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                protected Boolean executeTask() throws Exception {
                    FTPClient fTPClient = null;
                    try {
                        String string;
                        String string2 = IDN.toASCII(FtpTransportPanel.this.ftpHostField.getText().trim());
                        int n = ((Number)FtpTransportPanel.this.ftpPortField.getValue()).intValue();
                        try {
                            this.setMessage(FtpTransportPanel.this.resourceMap.getString("message.doTestFtp.msg", new Object[]{string2 + ":" + n}));
                            fTPClient = ImmoToolUtils.openFtpClient((String)string2, (int)n, (boolean)FtpTransportPanel.this.ftpPassiveModeBox.isSelected());
                        }
                        catch (Exception exception) {
                            throw new Exception(FtpTransportPanel.this.resourceMap.getString("error.ftpConnectionDenied", new Object[0]), exception);
                        }
                        boolean bl = false;
                        if (!FtpTransportPanel.this.ftpAnonymousModeBox.isSelected()) {
                            try {
                                String string3 = FtpTransportPanel.this.ftpUserField.getText().trim();
                                string = String.valueOf(FtpTransportPanel.this.ftpPassField.getPassword());
                                bl = fTPClient.login(string3, string);
                                if (!bl) {
                                    LOGGER.warn((Object)("FTP-access-denied for " + string3 + "@" + string2 + ":" + n));
                                }
                                fTPClient.sendNoOp();
                            }
                            catch (Exception exception) {
                                throw new Exception("internal login-error: " + exception.getLocalizedMessage(), exception);
                            }
                            if (!bl) {
                                throw new Exception(FtpTransportPanel.this.resourceMap.getString("error.ftpLoginDenied", new Object[0]));
                            }
                        }
                        if (!fTPClient.setFileType(2)) {
                            LOGGER.warn((Object)"Can't change file-type!");
                        }
                        boolean bl2 = false;
                        string = FtpTransportPanel.this.ftpPathField.getText().trim();
                        if (string.length() == 0) {
                            string = "/";
                        }
                        try {
                            bl2 = fTPClient.changeWorkingDirectory(string);
                            fTPClient.sendNoOp();
                        }
                        catch (Exception exception) {
                            throw new Exception("internal path-error: " + exception.getLocalizedMessage(), exception);
                        }
                        if (!bl2) {
                            throw new Exception(FtpTransportPanel.this.resourceMap.getString("error.ftpPathNotFound", new Object[0]));
                        }
                        Boolean bl3 = true;
                        return bl3;
                    }
                    finally {
                        try {
                            if (fTPClient != null && fTPClient.isConnected()) {
                                fTPClient.disconnect();
                            }
                        }
                        catch (Exception exception) {
                            LOGGER.error((Object)"error on disconnection!");
                            LOGGER.error((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
                        }
                    }
                }

                protected void cancelled() {
                    super.cancelled();
                    FtpTransportPanel.this.ftpTestLabel.setText(FtpTransportPanel.this.resourceMap.getString("message.doTestFtp.cancelled", new Object[0]));
                }

                protected void failed(Throwable throwable) {
                    super.failed(throwable);
                    FtpTransportPanel.this.ftpTestLabel.setText(FtpTransportPanel.this.resourceMap.getString("error.ftpTestError", new Object[]{throwable.getLocalizedMessage()}));
                }

                protected void finished() {
                    super.finished();
                    FtpTransportPanel.this.ftpTestButton.setText(FtpTransportPanel.this.resourceMap.getString("doFtpTest.Action.text", new Object[0]));
                    FtpTransportPanel.this.ftpTestLabel.setBusy(false);
                    FtpTransportPanel.this.ftpTask = null;
                }

                protected void succeeded(Boolean bl) {
                    super.succeeded((Object)bl);
                    FtpTransportPanel.this.ftpTestLabel.setText(FtpTransportPanel.this.resourceMap.getString("message.doTestFtp.success", new Object[0]));
                }
            };
            ImmoToolUtils.executeTask((Task)this.ftpTask);
        } else if (!this.ftpTask.isDone()) {
            this.ftpTask.cancel(true);
        }
    }

    @Override
    public List<String> getWarnings() {
        return super.getWarnings();
    }

    @Override
    public boolean isValidInput() {
        this.validationHandler.validate();
        return this.validationHandler.isValid();
    }

    @Override
    public void load(AbstractTransport abstractTransport) {
        if (abstractTransport == null) {
            this.ftpHostField.setText("");
            this.ftpPortField.setValue("");
            this.ftpUserField.setText("");
            this.ftpPassField.setText("");
            this.ftpPathField.setText("");
            this.ftpAnonymousModeBox.setSelected(false);
            this.ftpPassiveModeBox.setSelected(false);
        } else if (abstractTransport instanceof FtpTransport) {
            FtpTransport ftpTransport = (FtpTransport)abstractTransport;
            this.ftpHostField.setText(ftpTransport.getFtpHost());
            this.ftpPortField.setValue(ftpTransport.getFtpPort());
            this.ftpUserField.setText(ftpTransport.getFtpUser());
            this.ftpPassField.setText(ftpTransport.getFtpPass());
            this.ftpPathField.setText(ftpTransport.getFtpPath());
            this.ftpAnonymousModeBox.setSelected(ftpTransport.isFtpAnonymous());
            this.ftpPassiveModeBox.setSelected(ftpTransport.isFtpPassive());
        } else {
            throw new IllegalArgumentException("invalid transport-class: " + abstractTransport.getClass().getName());
        }
        this.validationHandler.init();
    }

    @Override
    public void save(AbstractTransport abstractTransport) {
        if (this.ftpTask != null && !this.ftpTask.isDone()) {
            this.ftpTask.cancel(true);
        }
        if (!(abstractTransport instanceof FtpTransport)) {
            throw new IllegalArgumentException("invalid transport-class: " + abstractTransport.getClass().getName());
        }
        FtpTransport ftpTransport = (FtpTransport)abstractTransport;
        ftpTransport.setFtpHost(this.ftpHostField.getText().trim());
        ftpTransport.setFtpPort(((Number)this.ftpPortField.getValue()).intValue());
        ftpTransport.setFtpUser(!this.ftpAnonymousModeBox.isSelected() ? this.ftpUserField.getText().trim() : "");
        ftpTransport.setFtpPass(!this.ftpAnonymousModeBox.isSelected() ? String.valueOf(this.ftpPassField.getPassword()).trim() : "");
        ftpTransport.setFtpPath(this.ftpPathField.getText().trim());
        ftpTransport.setFtpAnonymous(this.ftpAnonymousModeBox.isSelected());
        ftpTransport.setFtpPassive(this.ftpPassiveModeBox.isSelected());
    }
}

