/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency.export;

import com.openindex.openestate.tool.ImmoToolApp;
import com.openindex.openestate.tool.ImmoToolTask;
import com.openindex.openestate.tool.ImmoToolTaskCancelledException;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.agency.AgencyExportException;
import com.openindex.openestate.tool.agency.AgencyExportSummary;
import com.openindex.openestate.tool.agency.export.AbstractExport;
import com.openindex.openestate.tool.agency.export.AbstractTransport;
import com.openindex.openestate.tool.agency.export.AbstractTransportPanel;
import com.openindex.openestate.tool.agency.export.HttpTransportPanel;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.SystemUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.FileEntity;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;
import org.jdesktop.application.ResourceMap;

public class HttpTransport
extends AbstractTransport {
    private static final Logger LOGGER = Logger.getLogger(HttpTransport.class);
    public static final Base64 BASE64 = new Base64();
    public static final Charset US_ASCII = Charset.forName("US-ASCII");
    public static final String NAME = "http";
    public static final String KEY_HTTP_MODE = "transport.http";
    public static final String KEY_HTTP_URL = "transport.http.url";
    public static final String KEY_HTTP_ANONYMOUS = "transport.http.anonymous";
    public static final String KEY_HTTP_USER = "transport.http.user";
    public static final String KEY_HTTP_PASS = "transport.http.pass";
    public static final String KEY_HTTP_POST_MULTIPART = "transport.http.post.multipart";
    public static final String KEY_HTTP_POST_MULTIPART_KEY = "transport.http.post.multipart.key";
    public static final String MODE_POST = "post";
    public static final String MODE_PUT = "put";
    private ResourceMap resourceMap = ImmoToolUtils.getResourceMap(HttpTransport.class);
    private URL httpUrl = null;
    private String httpUser = "";
    private String httpPass = "";
    private boolean httpAnonymous = false;
    private String httpMode = "post";
    private boolean httpPostMulitpart = false;
    private String httpPostMulitpartKey = "upload";
    private List<String> reponseProtocols = new ArrayList<String>();

    @Override
    public AbstractTransportPanel createSetupPanel() {
        return new HttpTransportPanel();
    }

    protected void doSend(HttpClient httpClient, URL uRL, File file) throws IOException, URISyntaxException {
        if (file.isDirectory()) {
            for (File file2 : file.listFiles()) {
                this.doSend(httpClient, uRL, file2);
            }
        } else if (file.isFile()) {
            StringBuilder stringBuilder = new StringBuilder();
            StringBuilder stringBuilder2 = new StringBuilder();
            String string = this.getHttpMode();
            int n = -1;
            if (MODE_PUT.equalsIgnoreCase(string)) {
                n = this.doSendAsPut(httpClient, uRL, file, stringBuilder, stringBuilder2);
            } else if (MODE_POST.equalsIgnoreCase(string)) {
                n = this.isHttpPostMulitpart() ? this.doSendAsPostMultipart(httpClient, uRL, file, stringBuilder, stringBuilder2) : this.doSendAsPost(httpClient, uRL, file, stringBuilder, stringBuilder2);
            }
            if (n < 200 || n >= 300) {
                throw new IOException(this.resourceMap.getString("error.serverSendErrorResponse", new Object[]{n}) + " " + stringBuilder.toString());
            }
            if (stringBuilder2.length() > 0) {
                this.reponseProtocols.add(stringBuilder2.toString().trim());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int doSendAsPost(HttpClient httpClient, URL uRL, File file, StringBuilder stringBuilder, StringBuilder stringBuilder2) throws IOException, URISyntaxException {
        HttpPost httpPost = new HttpPost(uRL.toURI());
        httpPost.setHeader("User-Agent", ImmoToolApp.getApplicationTitle().replaceAll("\\s", "-") + "/" + ImmoToolApp.getApplicationVersion());
        String string = HttpURLConnection.guessContentTypeFromName(file.getName());
        ContentType contentType = ContentType.create((String)(string != null ? string : "application/octet-stream"));
        FileEntity fileEntity = new FileEntity(file, contentType);
        fileEntity.setContentType(contentType.getMimeType());
        httpPost.setEntity((HttpEntity)fileEntity);
        HttpResponse httpResponse = httpClient.execute((HttpUriRequest)httpPost);
        String string2 = httpResponse.getStatusLine().getReasonPhrase();
        if (!StringUtils.isEmpty((String)string2)) {
            stringBuilder.append(string2);
        }
        HttpEntity httpEntity = httpResponse.getEntity();
        BufferedReader bufferedReader = null;
        try {
            if (httpEntity != null && httpEntity.getContentType().getValue().toLowerCase().startsWith("text/")) {
                bufferedReader = new BufferedReader(new InputStreamReader(httpEntity.getContent()));
                String string3 = null;
                while ((string3 = bufferedReader.readLine()) != null) {
                    LOGGER.debug((Object)("RESPONSE > " + string3));
                    stringBuilder2.append(string3).append(SystemUtils.LINE_SEPARATOR);
                }
            }
            EntityUtils.consume((HttpEntity)httpEntity);
        }
        catch (Exception exception) {
            LOGGER.warn((Object)("Can't read http-response: " + exception.getLocalizedMessage()));
        }
        finally {
            IOUtils.closeQuietly(bufferedReader);
        }
        return httpResponse.getStatusLine().getStatusCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int doSendAsPostMultipart(HttpClient httpClient, URL uRL, File file, StringBuilder stringBuilder, StringBuilder stringBuilder2) throws IOException, URISyntaxException {
        HttpPost httpPost = new HttpPost(uRL.toURI());
        httpPost.setHeader("User-Agent", ImmoToolApp.getApplicationTitle().replaceAll("\\s", "-") + "/" + ImmoToolApp.getApplicationVersion());
        String string = HttpURLConnection.guessContentTypeFromName(file.getName());
        MultipartEntity multipartEntity = new MultipartEntity(HttpMultipartMode.BROWSER_COMPATIBLE);
        FileBody fileBody = new FileBody(file, string != null ? string : "application/octet-stream");
        multipartEntity.addPart(this.getHttpPostMulitpartKey(), (ContentBody)fileBody);
        httpPost.setEntity((HttpEntity)multipartEntity);
        HttpResponse httpResponse = httpClient.execute((HttpUriRequest)httpPost);
        String string2 = httpResponse.getStatusLine().getReasonPhrase();
        if (!StringUtils.isEmpty((String)string2)) {
            stringBuilder.append(string2);
        }
        HttpEntity httpEntity = httpResponse.getEntity();
        BufferedReader bufferedReader = null;
        try {
            if (httpEntity != null && httpEntity.getContentType().getValue().toLowerCase().startsWith("text/")) {
                bufferedReader = new BufferedReader(new InputStreamReader(httpEntity.getContent()));
                String string3 = null;
                while ((string3 = bufferedReader.readLine()) != null) {
                    LOGGER.debug((Object)("RESPONSE > " + string3));
                    stringBuilder2.append(string3).append(SystemUtils.LINE_SEPARATOR);
                }
            }
            EntityUtils.consume((HttpEntity)httpEntity);
        }
        catch (Exception exception) {
            LOGGER.warn((Object)("Can't read http-response: " + exception.getLocalizedMessage()));
        }
        finally {
            IOUtils.closeQuietly(bufferedReader);
        }
        return httpResponse.getStatusLine().getStatusCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int doSendAsPut(HttpClient httpClient, URL uRL, File file, StringBuilder stringBuilder, StringBuilder stringBuilder2) throws IOException, URISyntaxException {
        String string = uRL.toURI().toString();
        if (!string.endsWith("/")) {
            string = string + "/";
        }
        string = string + "/";
        HttpPut httpPut = new HttpPut(string + file.getName());
        httpPut.setHeader("User-Agent", ImmoToolApp.getApplicationTitle().replaceAll("\\s", "-") + "/" + ImmoToolApp.getApplicationVersion());
        String string2 = HttpURLConnection.guessContentTypeFromName(file.getName());
        ContentType contentType = ContentType.create((String)(string2 != null ? string2 : "application/octet-stream"));
        FileEntity fileEntity = new FileEntity(file, contentType);
        fileEntity.setContentType(contentType.getMimeType());
        httpPut.setEntity((HttpEntity)fileEntity);
        HttpResponse httpResponse = httpClient.execute((HttpUriRequest)httpPut);
        String string3 = httpResponse.getStatusLine().getReasonPhrase();
        if (!StringUtils.isEmpty((String)string3)) {
            stringBuilder.append(string3);
        }
        HttpEntity httpEntity = httpResponse.getEntity();
        BufferedReader bufferedReader = null;
        try {
            if (httpEntity != null && httpEntity.getContentType().getValue().toLowerCase().startsWith("text/")) {
                bufferedReader = new BufferedReader(new InputStreamReader(httpEntity.getContent()));
                String string4 = null;
                while ((string4 = bufferedReader.readLine()) != null) {
                    LOGGER.debug((Object)("RESPONSE > " + string4));
                    stringBuilder2.append(string4).append(SystemUtils.LINE_SEPARATOR);
                }
            }
            EntityUtils.consume((HttpEntity)httpEntity);
        }
        catch (Exception exception) {
            LOGGER.warn((Object)("Can't read http-response: " + exception.getLocalizedMessage()));
        }
        finally {
            IOUtils.closeQuietly(bufferedReader);
        }
        return httpResponse.getStatusLine().getStatusCode();
    }

    @Override
    public synchronized void doTransport(File file, AbstractExport abstractExport, AgencyExportSummary agencyExportSummary, ImmoToolTask.Callback callback) throws AgencyExportException, ImmoToolTaskCancelledException {
        block9: {
            try {
                callback.checkCancelled();
                URL uRL = this.getHttpUrl();
                if (uRL == null) {
                    throw new NullPointerException("empty url!");
                }
                if (!uRL.getProtocol().equalsIgnoreCase(NAME) && !uRL.getProtocol().equalsIgnoreCase("https")) {
                    throw new AgencyExportException("Unsupported URL '" + uRL.toString() + "'!");
                }
                callback.checkCancelled();
                HttpClient httpClient = null;
                httpClient = this.isHttpAnonymous() ? ImmoToolUtils.createHttpClient() : ImmoToolUtils.createHttpClient((String)this.getHttpUser().trim(), (String)this.getHttpPass().trim());
                callback.checkCancelled();
                uRL = ImmoToolUtils.toIdnUrl((URL)uRL);
                if (file.isDirectory()) {
                    for (File file2 : file.listFiles()) {
                        callback.checkCancelled();
                        this.doSend(httpClient, uRL, file2);
                    }
                    break block9;
                }
                if (file.isFile()) {
                    callback.checkCancelled();
                    this.doSend(httpClient, uRL, file);
                    break block9;
                }
                throw new AgencyExportException("Invalid source file '" + file.getAbsolutePath() + "'!");
            }
            catch (MalformedURLException malformedURLException) {
                throw new AgencyExportException("Can't create URL '" + this.getHttpUrl() + "'!", malformedURLException);
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new AgencyExportException("URL is not formatted strictly according to to RFC2396 '" + this.getHttpUrl() + "'!", uRISyntaxException);
            }
            catch (Exception exception) {
                throw new AgencyExportException("Can't send file to '" + this.getHttpUrl() + "'!", exception);
            }
        }
    }

    public String getHttpMode() {
        return this.httpMode;
    }

    public String getHttpPostMulitpartKey() {
        return this.httpPostMulitpartKey;
    }

    public String getHttpPass() {
        return this.httpPass;
    }

    public URL getHttpUrl() {
        return this.httpUrl;
    }

    public String getHttpUser() {
        return this.httpUser;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String[] getResponseProtocols() {
        return this.reponseProtocols.toArray(new String[this.reponseProtocols.size()]);
    }

    @Override
    public String getTitle() {
        return this.resourceMap.getString("title", new Object[0]);
    }

    public boolean isHttpAnonymous() {
        return this.httpAnonymous;
    }

    public boolean isHttpPostMulitpart() {
        return this.httpPostMulitpart;
    }

    @Override
    public void load(Properties properties) {
        super.load(properties);
        this.setHttpAnonymous(Boolean.valueOf(properties.getProperty(KEY_HTTP_ANONYMOUS, "false")));
        this.setHttpUser(!this.isHttpAnonymous() ? properties.getProperty(KEY_HTTP_USER, "") : "");
        this.setHttpPass(!this.isHttpAnonymous() ? properties.getProperty(KEY_HTTP_PASS, "") : "");
        this.setHttpMode(properties.getProperty(KEY_HTTP_MODE, MODE_POST));
        this.setHttpPostMulitpart(Boolean.valueOf(properties.getProperty(KEY_HTTP_POST_MULTIPART, "false")));
        this.setHttpPostMulitpartKey(this.isHttpPostMulitpart() ? properties.getProperty(KEY_HTTP_POST_MULTIPART_KEY, "") : "");
        String string = properties.getProperty(KEY_HTTP_URL, "").trim();
        try {
            this.setHttpUrl(!StringUtils.isBlank((String)string) ? new URL(string) : null);
        }
        catch (Exception exception) {
            this.setHttpUrl(null);
            LOGGER.warn((Object)"invalid http-url!");
            LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
        }
    }

    @Override
    public void save(Properties properties) {
        super.save(properties);
        properties.setProperty(KEY_HTTP_URL, this.getHttpUrl() != null ? this.getHttpUrl().toString() : "");
        properties.setProperty(KEY_HTTP_ANONYMOUS, String.valueOf(this.isHttpAnonymous()));
        if (!this.isHttpAnonymous()) {
            properties.setProperty(KEY_HTTP_USER, this.getHttpUser());
            properties.setProperty(KEY_HTTP_PASS, this.getHttpPass());
        } else {
            properties.remove(KEY_HTTP_USER);
            properties.remove(KEY_HTTP_PASS);
        }
        properties.setProperty(KEY_HTTP_MODE, this.getHttpMode());
        if (MODE_POST.equals(this.getHttpMode())) {
            properties.setProperty(KEY_HTTP_POST_MULTIPART, String.valueOf(this.isHttpPostMulitpart()));
            if (this.isHttpPostMulitpart()) {
                properties.setProperty(KEY_HTTP_POST_MULTIPART_KEY, this.getHttpPostMulitpartKey());
            } else {
                properties.remove(KEY_HTTP_POST_MULTIPART_KEY);
            }
        } else {
            properties.remove(KEY_HTTP_POST_MULTIPART);
            properties.remove(KEY_HTTP_POST_MULTIPART_KEY);
        }
    }

    public void setHttpAnonymous(boolean bl) {
        this.httpAnonymous = bl;
    }

    public void setHttpMode(String string) {
        this.httpMode = !StringUtils.isBlank((String)string) ? string.trim() : MODE_POST;
    }

    public void setHttpPostMulitpart(boolean bl) {
        this.httpPostMulitpart = bl;
    }

    public void setHttpPostMulitpartKey(String string) {
        this.httpPostMulitpartKey = !StringUtils.isBlank((String)string) ? string.trim() : "upload";
    }

    public void setHttpPass(String string) {
        this.httpPass = string != null ? string.trim() : "";
    }

    public void setHttpUrl(URL uRL) {
        this.httpUrl = uRL;
    }

    public void setHttpUser(String string) {
        this.httpUser = string != null ? string.trim() : "";
    }
}

