/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency.export;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.openindex.openestate.tool.ImmoToolTask;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.agency.export.AbstractTransport;
import com.openindex.openestate.tool.agency.export.AbstractTransportPanel;
import com.openindex.openestate.tool.agency.export.HttpTransport;
import com.openindex.openestate.tool.utils.ValidationHandler;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.List;
import javax.swing.ActionMap;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;
import org.jdesktop.application.Action;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.application.Task;
import org.jdesktop.swingx.JXBusyLabel;

public class HttpTransportPanel
extends AbstractTransportPanel {
    private static final Logger LOGGER = Logger.getLogger(HttpTransportPanel.class);
    private ActionMap actionMap;
    private ResourceMap resourceMap;
    private ValidationHandler validationHandler;
    private JTextField httpUrlField;
    private JTextField httpUserField;
    private JPasswordField httpPassField;
    private JCheckBox httpAnonymousModeBox;
    private JRadioButton httpPutModeBox;
    private JRadioButton httpPostModeBox;
    private JRadioButton httpPostMultipartModeBox;
    private ButtonGroup httpModeGroup;
    private JTextField httpMultipartKeyField;
    private JButton httpTestButton;
    private JXBusyLabel httpTestLabel;
    private Task httpTask = null;

    public HttpTransportPanel() {
        this.build();
    }

    private void build() {
        this.actionMap = ImmoToolUtils.getActionMap(HttpTransportPanel.class, (Object)this);
        this.resourceMap = ImmoToolUtils.getResourceMap(HttpTransportPanel.class);
        this.validationHandler = ImmoToolUtils.createValidationHandler();
        this.buildForm();
        this.resourceMap.injectComponents((Component)this);
        this.validationHandler.init();
        this.httpTestButton.setAction(this.actionMap.get(this.httpTestButton.getText()));
        this.httpAnonymousModeBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HttpTransportPanel.this.httpUserField.setEnabled(!HttpTransportPanel.this.httpAnonymousModeBox.isSelected());
                HttpTransportPanel.this.httpPassField.setEnabled(!HttpTransportPanel.this.httpAnonymousModeBox.isSelected());
                HttpTransportPanel.this.validationHandler.validate((JComponent)HttpTransportPanel.this.httpUserField);
                HttpTransportPanel.this.validationHandler.validate((JComponent)HttpTransportPanel.this.httpPassField);
            }
        });
        this.httpPutModeBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HttpTransportPanel.this.httpMultipartKeyField.setEnabled(HttpTransportPanel.this.httpPostMultipartModeBox.isSelected());
                HttpTransportPanel.this.validationHandler.validate((JComponent)HttpTransportPanel.this.httpMultipartKeyField);
            }
        });
        this.httpPostModeBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HttpTransportPanel.this.httpMultipartKeyField.setEnabled(HttpTransportPanel.this.httpPostMultipartModeBox.isSelected());
                HttpTransportPanel.this.validationHandler.validate((JComponent)HttpTransportPanel.this.httpMultipartKeyField);
            }
        });
        this.httpPostMultipartModeBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HttpTransportPanel.this.httpMultipartKeyField.setEnabled(HttpTransportPanel.this.httpPostMultipartModeBox.isSelected());
                HttpTransportPanel.this.validationHandler.validate((JComponent)HttpTransportPanel.this.httpMultipartKeyField);
            }
        });
    }

    private void buildForm() {
        this.httpUrlField = new JTextField();
        this.httpUrlField.setName("httpUrlField");
        this.httpUserField = new JTextField();
        this.httpUserField.setName("httpUserField");
        this.httpPassField = new JPasswordField();
        this.httpPassField.setName("httpPassField");
        this.httpAnonymousModeBox = new JCheckBox();
        this.httpAnonymousModeBox.setName("httpAnonymousModeBox");
        this.httpPutModeBox = new JRadioButton();
        this.httpPutModeBox.setName("httpPutModeBox");
        this.httpPostModeBox = new JRadioButton();
        this.httpPostModeBox.setName("httpPostModeBox");
        this.httpPostMultipartModeBox = new JRadioButton();
        this.httpPostMultipartModeBox.setName("httpPostMultipartModeBox");
        this.httpModeGroup = new ButtonGroup();
        this.httpModeGroup.add(this.httpPutModeBox);
        this.httpModeGroup.add(this.httpPostModeBox);
        this.httpModeGroup.add(this.httpPostMultipartModeBox);
        this.httpMultipartKeyField = new JTextField();
        this.httpMultipartKeyField.setName("httpMultipartKeyField");
        this.httpMultipartKeyField.setEnabled(false);
        this.httpTestButton = new JButton("doHttpTest");
        this.httpTestButton.setName("httpTestButton ");
        this.httpTestLabel = new JXBusyLabel();
        this.httpTestLabel.setName("httpTestLabel");
        this.httpTestLabel.setVisible(false);
        this.validationHandler.putRule((JComponent)this.httpUrlField, ValidationHandler.URL);
        this.validationHandler.putRule((JComponent)this.httpUserField, ValidationHandler.NOT_BLANK);
        this.validationHandler.putRule((JComponent)this.httpPassField, ValidationHandler.NOT_BLANK);
        this.validationHandler.putRule((JComponent)this.httpMultipartKeyField, ValidationHandler.NOT_BLANK);
        DefaultFormBuilder defaultFormBuilder = ImmoToolUtils.createFormBuilder((String)"right:50dlu, 3dlu, 30dlu:grow", (JPanel)this);
        defaultFormBuilder.append(this.resourceMap.getString("label.httpUrlField", new Object[0]), (Component)this.httpUrlField);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(this.resourceMap.getString("label.httpAnonymousModeBox", new Object[0]), (Component)this.httpAnonymousModeBox);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(this.resourceMap.getString("label.httpUserField", new Object[0]), (Component)this.httpUserField);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(this.resourceMap.getString("label.httpPassField", new Object[0]), (Component)this.httpPassField);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(this.resourceMap.getString("label.httpPutModeBox", new Object[0]), (Component)this.httpPutModeBox);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(this.resourceMap.getString("label.httpPostModeBox", new Object[0]), (Component)this.httpPostModeBox);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(this.resourceMap.getString("label.httpPostMultipartModeBox", new Object[0]), (Component)this.httpPostMultipartModeBox);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(this.resourceMap.getString("label.httpMultipartKeyField", new Object[0]), (Component)this.httpMultipartKeyField);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append((Component)new JLabel(" "), 3);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append((Component)ImmoToolUtils.createHead2Separator((String)this.resourceMap.getString("label.httpTest", new Object[0])), 3);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append((Component)this.httpTestButton);
        defaultFormBuilder.append((Component)this.httpTestLabel);
        defaultFormBuilder.nextLine();
        this.revalidate();
        this.repaint();
    }

    @Action
    public void doHttpTest() {
        this.validationHandler.validate();
        if (!this.validationHandler.isValid()) {
            ImmoToolUtils.showMessageErrorDialog((String)this.resourceMap.getString("error.invalidHttpSetup", new Object[0]));
            return;
        }
        if (this.httpTask == null) {
            this.httpTestButton.setText(this.resourceMap.getString("label.cancel", new Object[0]));
            this.httpTestLabel.setBusy(true);
            this.httpTestLabel.setText(this.resourceMap.getString("message.doTestHttp", new Object[0]));
            this.httpTestLabel.setVisible(true);
            this.httpTask = new ImmoToolTask<Boolean>(){
                private int responseCode = -1;
                private String responseMsg = "";

                protected Boolean executeTask() throws Exception {
                    URL uRL = new URL(HttpTransportPanel.this.httpUrlField.getText().trim());
                    this.setMessage(HttpTransportPanel.this.resourceMap.getString("message.doTestHttp.msg", new Object[]{uRL}));
                    if (!uRL.getProtocol().equalsIgnoreCase("http") && !uRL.getProtocol().equalsIgnoreCase("https")) {
                        throw new Exception(HttpTransportPanel.this.resourceMap.getString("error.invalidHttpUrl", new Object[0]));
                    }
                    HttpClient httpClient = null;
                    try {
                        httpClient = HttpTransportPanel.this.httpAnonymousModeBox.isSelected() ? ImmoToolUtils.createHttpClient() : ImmoToolUtils.createHttpClient((String)HttpTransportPanel.this.httpUserField.getText().trim(), (String)String.valueOf(HttpTransportPanel.this.httpPassField.getPassword()).trim());
                    }
                    catch (Exception exception) {
                        throw new Exception(HttpTransportPanel.this.resourceMap.getString("error.cantCreateHttpClient", new Object[]{exception.getLocalizedMessage()}), exception);
                    }
                    HttpResponse httpResponse = null;
                    try {
                        httpResponse = httpClient.execute((HttpUriRequest)new HttpGet(ImmoToolUtils.toIdnUrl((URL)uRL).toURI()));
                        if (httpResponse == null) {
                            throw new Exception(HttpTransportPanel.this.resourceMap.getString("error.noResponseReceived", new Object[0]));
                        }
                        this.responseCode = httpResponse.getStatusLine().getStatusCode();
                        this.responseMsg = httpResponse.getStatusLine().getReasonPhrase();
                    }
                    catch (Exception exception) {
                        throw new Exception(HttpTransportPanel.this.resourceMap.getString("error.cantExecuteGetRequest", new Object[]{exception.getLocalizedMessage()}), exception);
                    }
                    try {
                        HttpEntity httpEntity = httpResponse.getEntity();
                        EntityUtils.consume((HttpEntity)httpEntity);
                    }
                    catch (Exception exception) {
                        LOGGER.warn((Object)"Can't consume reponse entity!");
                        LOGGER.warn((Object)("> " + exception.getLocalizedMessage()));
                    }
                    return true;
                }

                protected void cancelled() {
                    super.cancelled();
                    HttpTransportPanel.this.httpTestLabel.setText(HttpTransportPanel.this.resourceMap.getString("message.doTestHttp.cancelled", new Object[0]));
                }

                protected void failed(Throwable throwable) {
                    super.failed(throwable);
                    if (this.responseCode > -1) {
                        LOGGER.error((Object)("http-error (" + this.responseCode + ")!"));
                        LOGGER.error((Object)("> " + this.responseMsg));
                    }
                    HttpTransportPanel.this.httpTestLabel.setText(HttpTransportPanel.this.resourceMap.getString("error.httpTestError", new Object[]{throwable.getLocalizedMessage()}));
                }

                protected void finished() {
                    super.finished();
                    HttpTransportPanel.this.httpTestButton.setText(HttpTransportPanel.this.resourceMap.getString("doHttpTest.Action.text", new Object[0]));
                    HttpTransportPanel.this.httpTestLabel.setBusy(false);
                    HttpTransportPanel.this.httpTask = null;
                }

                protected void succeeded(Boolean bl) {
                    super.succeeded((Object)bl);
                    HttpTransportPanel.this.httpTestLabel.setText(HttpTransportPanel.this.resourceMap.getString("message.doTestHttp.success", new Object[0]));
                }
            };
            ImmoToolUtils.executeTask((Task)this.httpTask);
        } else if (!this.httpTask.isDone()) {
            this.httpTask.cancel(true);
        }
    }

    @Override
    public List<String> getWarnings() {
        return super.getWarnings();
    }

    @Override
    public boolean isValidInput() {
        this.validationHandler.validate();
        return this.validationHandler.isValid();
    }

    @Override
    public void load(AbstractTransport abstractTransport) {
        if (abstractTransport == null) {
            this.httpModeGroup.getSelection().setSelected(false);
            this.httpUrlField.setText("");
            this.httpUserField.setText("");
            this.httpUserField.setEnabled(true);
            this.httpPassField.setText("");
            this.httpPassField.setEnabled(true);
            this.httpAnonymousModeBox.setSelected(false);
            this.httpPutModeBox.setSelected(false);
            this.httpPostModeBox.setSelected(false);
            this.httpPostMultipartModeBox.setSelected(false);
            this.httpMultipartKeyField.setText("");
            this.httpMultipartKeyField.setEnabled(false);
        } else if (abstractTransport instanceof HttpTransport) {
            HttpTransport httpTransport = (HttpTransport)abstractTransport;
            this.httpUrlField.setText(httpTransport.getHttpUrl() != null ? httpTransport.getHttpUrl().toString() : "");
            this.httpUserField.setText(httpTransport.getHttpUser());
            this.httpUserField.setEnabled(!httpTransport.isHttpAnonymous());
            this.httpPassField.setText(httpTransport.getHttpPass());
            this.httpPassField.setEnabled(!httpTransport.isHttpAnonymous());
            this.httpAnonymousModeBox.setSelected(httpTransport.isHttpAnonymous());
            if ("put".equalsIgnoreCase(httpTransport.getHttpMode())) {
                this.httpPutModeBox.setSelected(true);
            } else if ("post".equalsIgnoreCase(httpTransport.getHttpMode())) {
                this.httpPostModeBox.setSelected(true);
                this.httpPostMultipartModeBox.setSelected(httpTransport.isHttpPostMulitpart());
                this.httpMultipartKeyField.setText(httpTransport.getHttpPostMulitpartKey());
                this.httpMultipartKeyField.setEnabled(httpTransport.isHttpPostMulitpart());
            }
        } else {
            throw new IllegalArgumentException("invalid transport-class: " + abstractTransport.getClass().getName());
        }
        this.validationHandler.init();
    }

    @Override
    public void save(AbstractTransport abstractTransport) {
        if (this.httpTask != null && !this.httpTask.isDone()) {
            this.httpTask.cancel(true);
        }
        if (abstractTransport instanceof HttpTransport) {
            HttpTransport httpTransport = (HttpTransport)abstractTransport;
            try {
                httpTransport.setHttpUrl(new URL(this.httpUrlField.getText().trim()));
            }
            catch (Exception exception) {
                LOGGER.warn((Object)"invalid http-url!");
                LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
            }
            httpTransport.setHttpUser(!this.httpAnonymousModeBox.isSelected() ? this.httpUserField.getText().trim() : "");
            httpTransport.setHttpPass(!this.httpAnonymousModeBox.isSelected() ? String.valueOf(this.httpPassField.getPassword()).trim() : "");
            httpTransport.setHttpAnonymous(this.httpAnonymousModeBox.isSelected());
            if (this.httpPutModeBox.isSelected()) {
                httpTransport.setHttpMode("put");
            } else if (this.httpPostModeBox.isSelected() || this.httpPostMultipartModeBox.isSelected()) {
                httpTransport.setHttpMode("post");
                httpTransport.setHttpPostMulitpart(this.httpPostMultipartModeBox.isSelected());
                httpTransport.setHttpPostMulitpartKey(httpTransport.isHttpPostMulitpart() ? this.httpMultipartKeyField.getText() : "");
            } else {
                httpTransport.setHttpMode(null);
            }
        } else {
            throw new IllegalArgumentException("invalid transport-class: " + abstractTransport.getClass().getName());
        }
    }
}

