/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency.export;

import com.openindex.openestate.impl.EstateAttachmentImpl;
import com.openindex.openestate.impl.TransferAgencyImpl;
import com.openindex.openestate.impl.TransferImpl;
import com.openindex.openestate.impl.csv.idx.IDXCSVSchema;
import com.openindex.openestate.tool.ImmoToolTask;
import com.openindex.openestate.tool.ImmoToolTaskCancelledException;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.agency.AgencyEstate;
import com.openindex.openestate.tool.agency.AgencyExportException;
import com.openindex.openestate.tool.agency.AgencyExportSummary;
import com.openindex.openestate.tool.agency.export.AbstractCsvExport;
import com.openindex.openestate.tool.agency.export.AbstractExportPanel;
import com.openindex.openestate.tool.agency.export.IDXCsvExportPanel;
import com.openindex.openestate.tool.agency.utils.IDXCsvWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Locale;
import java.util.Properties;
import org.apache.commons.io.IOUtils;

public class IDXCsvExport
extends AbstractCsvExport {
    public static final String NAME = "idx_csv";
    public static final String KEY_AGENT_ID = "export.idx_csv.agent_id";
    public static final String KEY_PUBLIC_ID_USED = "export.idx_csv.public_id_used";
    private String agentId = "";
    private boolean publicIdUsed;
    private long currentEstateId = -1L;
    private int currentEstateImgCount = 0;
    private int currentEstateMovCount = 0;
    private int currentEstateDocCount = 0;

    public IDXCsvExport() {
        this.setIncremental(false);
        this.setZipped(false);
        this.setLanguage(Locale.GERMAN);
        this.setPublicIdUsed(false);
        this.getMimeTypes().clear();
        this.getMimeTypes().add("image/gif");
        this.getMimeTypes().add("image/jpeg");
    }

    @Override
    protected synchronized boolean canExportAttachment(long l, EstateAttachmentImpl estateAttachmentImpl) {
        String string;
        if (!super.canExportAttachment(l, estateAttachmentImpl)) {
            return false;
        }
        if (this.currentEstateId != l) {
            this.currentEstateId = l;
            this.currentEstateImgCount = 0;
            this.currentEstateMovCount = 0;
            this.currentEstateDocCount = 0;
        }
        if (IDXCSVSchema.isImage((String)(string = estateAttachmentImpl.getFileAsName()))) {
            if (this.currentEstateImgCount > 12) {
                return false;
            }
            ++this.currentEstateImgCount;
            return true;
        }
        if (IDXCSVSchema.isMovie((String)string)) {
            if (this.currentEstateMovCount > 0) {
                return false;
            }
            ++this.currentEstateMovCount;
            return true;
        }
        if (IDXCSVSchema.isDocument((String)string)) {
            if (this.currentEstateDocCount > 0) {
                return false;
            }
            ++this.currentEstateDocCount;
            return true;
        }
        return false;
    }

    @Override
    public AbstractExportPanel createSetupPanel() {
        return new IDXCsvExportPanel();
    }

    @Override
    public File doExport(AgencyExportSummary agencyExportSummary, ImmoToolTask.Callback callback) throws AgencyExportException, ImmoToolTaskCancelledException {
        File file;
        OutputStreamWriter outputStreamWriter = null;
        try {
            File file2 = this.getExportDirectory();
            if (file2 == null || !file2.exists() && !file2.mkdirs()) {
                throw new AgencyExportException("Can't create temp directory!");
            }
            callback.checkCancelled();
            File file3 = new File(file2.getAbsolutePath() + File.separator + "data");
            File file4 = new File(file2.getAbsolutePath() + File.separator + "images");
            File file5 = new File(file2.getAbsolutePath() + File.separator + "movies");
            File file6 = new File(file2.getAbsolutePath() + File.separator + "doc");
            if (!file3.mkdir()) {
                throw new AgencyExportException("Can't create 'data' directory!");
            }
            if (!file4.mkdir()) {
                throw new AgencyExportException("Can't create 'images' directory!");
            }
            if (!file5.mkdir()) {
                throw new AgencyExportException("Can't create 'movies' directory!");
            }
            if (!file6.mkdir()) {
                throw new AgencyExportException("Can't create 'doc' directory!");
            }
            callback.checkCancelled();
            TransferImpl transferImpl = this.buildTransfer(agencyExportSummary);
            ((TransferAgencyImpl)transferImpl.getAgencies().get(0)).getAgent().setId(this.getAgentId());
            callback.checkCancelled();
            File file7 = new File(file3.getAbsolutePath() + File.separator + "unload.txt");
            outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(file7), "ISO-8859-1");
            IDXCsvWriter iDXCsvWriter = new IDXCsvWriter();
            iDXCsvWriter.setEnergyCertificateAppendedToDescription(this.isEnergyCertificateAppendedToDescription());
            iDXCsvWriter.write(outputStreamWriter, transferImpl);
            ((Writer)outputStreamWriter).flush();
            callback.checkCancelled();
            if (!iDXCsvWriter.getErrorMap().isEmpty()) {
                this.handleErrors(agencyExportSummary, iDXCsvWriter.getErrorMap());
            }
            file = file2;
        }
        catch (IOException iOException) {
            try {
                throw new AgencyExportException("Can't write IDX-CSV file!", iOException);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(outputStreamWriter);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Writer)outputStreamWriter);
        return file;
    }

    public String getAgentId() {
        return this.agentId;
    }

    @Override
    public File getAttachmentDirectory(EstateAttachmentImpl estateAttachmentImpl, File file) throws AgencyExportException {
        String string = estateAttachmentImpl.getFileAsName();
        if (IDXCSVSchema.isImage((String)string)) {
            return new File(this.getExportDirectory().getAbsolutePath() + File.separator + "images");
        }
        if (IDXCSVSchema.isMovie((String)string)) {
            return new File(this.getExportDirectory().getAbsolutePath() + File.separator + "movies");
        }
        if (IDXCSVSchema.isDocument((String)string)) {
            return new File(this.getExportDirectory().getAbsolutePath() + File.separator + "doc");
        }
        return null;
    }

    @Override
    protected boolean getEstateForUpdate(AgencyEstate agencyEstate) {
        boolean bl = super.getEstateForUpdate(agencyEstate);
        if (!bl) {
            return false;
        }
        if (this.isPublicIdUsed()) {
            agencyEstate.setId(agencyEstate.getPublicId());
        }
        return true;
    }

    @Override
    protected String getEstateIdForRemoval(Long l, AgencyExportSummary agencyExportSummary) {
        return this.isPublicIdUsed() && agencyExportSummary.getRemovedEstatePublicIds().containsKey(l) ? agencyExportSummary.getRemovedEstatePublicIds().get(l) : super.getEstateIdForRemoval(l, agencyExportSummary);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getTitle() {
        return "IDX-CSV (v3.01)";
    }

    public boolean isPublicIdUsed() {
        return this.publicIdUsed;
    }

    @Override
    public void load(Properties properties) {
        super.load(properties);
        this.setAgentId(properties.getProperty(KEY_AGENT_ID, ""));
        this.setImageMode(properties.getProperty("export.imagemode", "file"));
        this.setIncremental(false);
        this.setPublicIdUsed(ImmoToolUtils.getPropertyAsBoolean((String)KEY_PUBLIC_ID_USED, (Boolean)false, (Properties)properties));
    }

    @Override
    public void save(Properties properties) {
        super.save(properties);
        properties.setProperty(KEY_AGENT_ID, this.getAgentId());
        properties.setProperty("export.imagemode", this.getImageMode());
        properties.setProperty("export.incremental", Boolean.FALSE.toString());
        properties.setProperty(KEY_PUBLIC_ID_USED, Boolean.valueOf(this.isPublicIdUsed()).toString());
    }

    public void setAgentId(String string) {
        this.agentId = string != null ? string.trim() : "";
    }

    public void setPublicIdUsed(boolean bl) {
        this.publicIdUsed = bl;
    }

    @Override
    public boolean supportsIncrementalUpdate() {
        return false;
    }
}

