/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency.export;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.openindex.openestate.impl.utils.OpenEstateLocaleComboBox;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.agency.AgencyPlugin;
import com.openindex.openestate.tool.agency.export.AbstractExport;
import com.openindex.openestate.tool.agency.export.AbstractExportPanel;
import com.openindex.openestate.tool.agency.export.IDXCsvExport;
import com.openindex.openestate.tool.utils.JMimeTypeButton;
import com.openindex.openestate.tool.utils.NonEmptyComboBoxRule;
import com.openindex.openestate.tool.utils.ValidationHandler;
import com.openindex.openestate.tool.utils.ValidationRule;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.activation.MimeTypeParseException;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.apache.log4j.Logger;
import org.jdesktop.application.ResourceMap;

public class IDXCsvExportPanel
extends AbstractExportPanel {
    private static final Logger LOGGER = Logger.getLogger(IDXCsvExportPanel.class);
    private ResourceMap resourceMap;
    private ValidationHandler validationHandler;
    private JTextField agentIdField;
    private JComboBox imageTypeBox;
    private JMimeTypeButton exportMimeTypesButton;
    private JCheckBox zipExportBox;
    private JCheckBox publicIdBox;
    private JCheckBox energyCertificateBox;
    private OpenEstateLocaleComboBox exportLocaleBox;

    public IDXCsvExportPanel() {
        this.build();
    }

    private void build() {
        this.resourceMap = ImmoToolUtils.getResourceMap(IDXCsvExportPanel.class);
        this.validationHandler = ImmoToolUtils.createValidationHandler();
        this.buildForm();
        this.imageTypeBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                IDXCsvExportPanel.this.exportMimeTypesButton.setEnabled(IDXCsvExportPanel.this.imageTypeBox.getSelectedIndex() > 0);
            }
        });
        this.resourceMap.injectComponents((Component)this);
        this.load(null);
        this.validationHandler.init();
    }

    private void buildForm() {
        this.zipExportBox = new JCheckBox();
        this.zipExportBox.setName("zipExportBox");
        this.publicIdBox = new JCheckBox();
        this.publicIdBox.setName("publicIdBox");
        this.energyCertificateBox = new JCheckBox();
        this.energyCertificateBox.setName("energyCertificateBox");
        this.agentIdField = new JTextField();
        this.agentIdField.setName("agentIdField");
        this.exportLocaleBox = new OpenEstateLocaleComboBox(true, AgencyPlugin.getLocales());
        this.exportLocaleBox.setName("exportLocaleBox");
        this.validationHandler.putRule((JComponent)this.agentIdField, ValidationHandler.NOT_BLANK);
        this.validationHandler.putRule((JComponent)this.exportLocaleBox, (ValidationRule)new NonEmptyComboBoxRule((JComboBox)this.exportLocaleBox));
        this.imageTypeBox = new JComboBox(new DefaultComboBoxModel());
        this.imageTypeBox.setName("imageTypeBox");
        this.imageTypeBox.setPrototypeDisplayValue("XXXXXXXXXXXXXXXXXXXX");
        ((DefaultComboBoxModel)this.imageTypeBox.getModel()).addElement(this.resourceMap.getString("label.imageType.disabled", new Object[0]));
        ((DefaultComboBoxModel)this.imageTypeBox.getModel()).addElement(this.resourceMap.getString("label.imageType.file", new Object[0]));
        this.exportMimeTypesButton = new JMimeTypeButton();
        this.exportMimeTypesButton.setName("exportMimeTypesButton");
        this.exportMimeTypesButton.setHorizontalAlignment(2);
        try {
            this.exportMimeTypesButton.addApplicationTypes(new String[]{"application/msword", "application/pdf", "application/rtf"});
            this.exportMimeTypesButton.addImageTypes(new String[]{"image/gif", "image/jpeg"});
            this.exportMimeTypesButton.addVideoTypes(new String[]{"video/avi", "video/mp4", "video/mpeg", "video/msvideo", "video/quicktime", "video/vnd.rn-realvideo", "video/x-flv", "video/x-msvideo", "video/x-ms-wmv"});
        }
        catch (MimeTypeParseException mimeTypeParseException) {
            LOGGER.error((Object)"Can't parse MIME types!");
            LOGGER.error((Object)("> " + mimeTypeParseException.getLocalizedMessage()));
        }
        DefaultFormBuilder defaultFormBuilder = ImmoToolUtils.createFormBuilder((String)"right:pref, 3dlu, 50dlu:grow, 3dlu, right:pref, 3dlu, 50dlu", (JPanel)this);
        defaultFormBuilder.append(this.resourceMap.getString("label.agentId", new Object[0]), (Component)this.agentIdField);
        defaultFormBuilder.append((Component)this.exportLocaleBox, 3);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(this.resourceMap.getString("label.imageType", new Object[0]), (Component)this.imageTypeBox);
        defaultFormBuilder.append((Component)this.exportMimeTypesButton, 3);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(this.resourceMap.getString("label.options", new Object[0]), (Component)this.zipExportBox, 5);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append("", (Component)this.publicIdBox, 5);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append("", (Component)this.energyCertificateBox, 5);
        defaultFormBuilder.nextLine();
        this.revalidate();
        this.repaint();
    }

    @Override
    public List<String> getWarnings() {
        List<String> list = super.getWarnings();
        list.add(this.resourceMap.getString("warning.fullTransfer", new Object[0]));
        if (this.publicIdBox.isSelected()) {
            list.add(this.resourceMap.getString("warning.publicIdExport", new Object[0]));
        }
        return list;
    }

    @Override
    public boolean isValidInput() {
        this.validationHandler.validate();
        return this.validationHandler.isValid();
    }

    @Override
    public final void load(AbstractExport abstractExport) {
        if (abstractExport == null) {
            this.zipExportBox.setSelected(false);
            this.publicIdBox.setSelected(false);
            this.energyCertificateBox.setSelected(false);
            this.exportLocaleBox.setSelectedIndex(-1);
            this.agentIdField.setText("");
            this.imageTypeBox.setSelectedIndex(-1);
            this.exportMimeTypesButton.clearSelection();
            this.exportMimeTypesButton.setEnabled(false);
        } else if (abstractExport instanceof IDXCsvExport) {
            IDXCsvExport iDXCsvExport = (IDXCsvExport)abstractExport;
            this.zipExportBox.setSelected(iDXCsvExport.isZipped());
            this.publicIdBox.setSelected(iDXCsvExport.isPublicIdUsed());
            this.energyCertificateBox.setSelected(iDXCsvExport.isEnergyCertificateAppendedToDescription());
            this.agentIdField.setText(iDXCsvExport.getAgentId());
            this.exportLocaleBox.setSelectedLocale(abstractExport.getLocale());
            this.imageTypeBox.setSelectedIndex(iDXCsvExport.isImageModeFile() ? 1 : 0);
            this.exportMimeTypesButton.clearSelection();
            this.exportMimeTypesButton.setEnabled(this.imageTypeBox.getSelectedIndex() > 0);
            if (this.exportMimeTypesButton.isEnabled()) {
                for (JMimeTypeButton.Item item : this.exportMimeTypesButton.getMimeTypeItems()) {
                    String string = item.getMimeType().toString();
                    item.setSelected(abstractExport.getMimeTypes().contains(string));
                }
            }
        } else {
            throw new IllegalArgumentException("invalid export-class: " + abstractExport.getClass().getName());
        }
        this.validationHandler.init();
    }

    @Override
    public void save(AbstractExport abstractExport) {
        if (abstractExport instanceof IDXCsvExport) {
            IDXCsvExport iDXCsvExport = (IDXCsvExport)abstractExport;
            iDXCsvExport.setZipped(this.zipExportBox.isSelected());
            iDXCsvExport.setPublicIdUsed(this.publicIdBox.isSelected());
            iDXCsvExport.setEnergyCertificateAppendedToDescription(this.energyCertificateBox.isSelected());
            iDXCsvExport.setAgentId(this.agentIdField.getText().trim());
            iDXCsvExport.setLanguage(this.exportLocaleBox.getSelectedLocale());
            if (this.imageTypeBox.getSelectedIndex() == 1) {
                iDXCsvExport.setImageMode("file");
            } else {
                iDXCsvExport.setImageMode("disabled");
            }
            abstractExport.getMimeTypes().clear();
            if (this.imageTypeBox.getSelectedIndex() > 0) {
                for (JMimeTypeButton.Item item : this.exportMimeTypesButton.getMimeTypeItems()) {
                    if (!item.isSelected()) continue;
                    abstractExport.getMimeTypes().add(item.getMimeType().toString());
                }
            }
        } else {
            throw new IllegalArgumentException("invalid export-class: " + abstractExport.getClass().getName());
        }
    }
}

