/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency.export;

import com.openindex.openestate.impl.TransferAgencyImpl;
import com.openindex.openestate.impl.TransferImpl;
import com.openindex.openestate.tool.ImmoToolTask;
import com.openindex.openestate.tool.ImmoToolTaskCancelledException;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.agency.AgencyEstate;
import com.openindex.openestate.tool.agency.AgencyExportException;
import com.openindex.openestate.tool.agency.AgencyExportSummary;
import com.openindex.openestate.tool.agency.export.AbstractCsvExport;
import com.openindex.openestate.tool.agency.export.AbstractExportPanel;
import com.openindex.openestate.tool.agency.export.IS24CsvExportPanel;
import com.openindex.openestate.tool.agency.utils.IS24CsvWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Properties;
import org.apache.commons.io.IOUtils;

public class IS24CsvExport
extends AbstractCsvExport {
    public static final String NAME = "is24_csv";
    public static final String KEY_AGENT_ID = "export.is24_csv.agent_id";
    public static final String KEY_PUBLIC_ID_USED = "export.is24_csv.public_id_used";
    private String agentId = "";
    private boolean publicIdUsed;

    public IS24CsvExport() {
        this.setIncremental(true);
        this.setZipped(true);
        this.setLanguage(Locale.GERMAN);
        this.setPublicIdUsed(false);
    }

    @Override
    public AbstractExportPanel createSetupPanel() {
        return new IS24CsvExportPanel();
    }

    @Override
    public File doExport(AgencyExportSummary agencyExportSummary, ImmoToolTask.Callback callback) throws AgencyExportException, ImmoToolTaskCancelledException {
        File file;
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd_HH-mm");
        OutputStreamWriter outputStreamWriter = null;
        try {
            File file2 = this.getExportDirectory();
            if (file2 == null || !file2.exists() && !file2.mkdirs()) {
                throw new AgencyExportException("Can't create temp directory!");
            }
            callback.checkCancelled();
            TransferImpl transferImpl = this.buildTransfer(agencyExportSummary);
            ((TransferAgencyImpl)transferImpl.getAgencies().get(0)).getAgent().setId(this.getAgentId());
            callback.checkCancelled();
            File file3 = new File(file2.getAbsolutePath() + File.separator + "transfer-" + simpleDateFormat.format(new Date()) + ".csv");
            outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(file3), "CP1252");
            IS24CsvWriter iS24CsvWriter = new IS24CsvWriter();
            iS24CsvWriter.setEnergyCertificateAppendedToDescription(this.isEnergyCertificateAppendedToDescription());
            iS24CsvWriter.write(outputStreamWriter, transferImpl);
            ((Writer)outputStreamWriter).flush();
            callback.checkCancelled();
            if (!iS24CsvWriter.getErrorMap().isEmpty()) {
                this.handleErrors(agencyExportSummary, iS24CsvWriter.getErrorMap());
            }
            file = file2;
        }
        catch (IOException iOException) {
            try {
                throw new AgencyExportException("Can't write IS24-CSV file!", iOException);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(outputStreamWriter);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Writer)outputStreamWriter);
        return file;
    }

    public String getAgentId() {
        return this.agentId;
    }

    @Override
    protected boolean getEstateForUpdate(AgencyEstate agencyEstate) {
        boolean bl = super.getEstateForUpdate(agencyEstate);
        if (!bl) {
            return false;
        }
        if (this.isPublicIdUsed()) {
            agencyEstate.setId(agencyEstate.getPublicId());
        }
        return true;
    }

    @Override
    protected String getEstateIdForRemoval(Long l, AgencyExportSummary agencyExportSummary) {
        return this.isPublicIdUsed() && agencyExportSummary.getRemovedEstatePublicIds().containsKey(l) ? agencyExportSummary.getRemovedEstatePublicIds().get(l) : super.getEstateIdForRemoval(l, agencyExportSummary);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getTitle() {
        return "IS24-CSV (v1.4.0.4)";
    }

    @Override
    public String getZipFileName() {
        String string = super.getZipFileName();
        char c = this.isIncremental() ? (char)'t' : 'v';
        return string.substring(0, string.lastIndexOf(".")) + "_st_Z7P_im" + c + ".zip";
    }

    public boolean isPublicIdUsed() {
        return this.publicIdUsed;
    }

    @Override
    public void load(Properties properties) {
        super.load(properties);
        this.setAgentId(properties.getProperty(KEY_AGENT_ID, ""));
        this.setImageMode(properties.getProperty("export.imagemode", "file"));
        this.setIncremental(ImmoToolUtils.getPropertyAsBoolean((String)"export.incremental", (Boolean)false, (Properties)properties));
        this.setPublicIdUsed(ImmoToolUtils.getPropertyAsBoolean((String)KEY_PUBLIC_ID_USED, (Boolean)false, (Properties)properties));
    }

    @Override
    public void save(Properties properties) {
        super.save(properties);
        properties.setProperty(KEY_AGENT_ID, this.getAgentId());
        properties.setProperty("export.imagemode", this.getImageMode());
        properties.setProperty("export.incremental", Boolean.valueOf(this.isIncremental()).toString());
        properties.setProperty(KEY_PUBLIC_ID_USED, Boolean.valueOf(this.isPublicIdUsed()).toString());
    }

    public void setAgentId(String string) {
        this.agentId = string != null ? string.trim() : "";
    }

    @Override
    public void setLanguage(Locale locale) {
        super.setLanguage(locale != null ? locale : Locale.GERMAN);
    }

    public void setPublicIdUsed(boolean bl) {
        this.publicIdUsed = bl;
    }

    @Override
    public final boolean supportsIncrementalUpdate() {
        return true;
    }
}

