/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency.export;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.openindex.openestate.impl.utils.OpenEstateLocaleComboBox;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.agency.AgencyPlugin;
import com.openindex.openestate.tool.agency.export.AbstractExport;
import com.openindex.openestate.tool.agency.export.AbstractExportPanel;
import com.openindex.openestate.tool.agency.export.IS24CsvExport;
import com.openindex.openestate.tool.utils.JMimeTypeButton;
import com.openindex.openestate.tool.utils.NonEmptyComboBoxRule;
import com.openindex.openestate.tool.utils.ValidationHandler;
import com.openindex.openestate.tool.utils.ValidationRule;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.activation.MimeTypeParseException;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.apache.log4j.Logger;
import org.jdesktop.application.ResourceMap;

public class IS24CsvExportPanel
extends AbstractExportPanel {
    private static final Logger LOGGER = Logger.getLogger(IS24CsvExportPanel.class);
    private ResourceMap resourceMap;
    private ValidationHandler validationHandler;
    private JTextField agentIdField;
    private JTextField estateIdPrefixField;
    private JComboBox exportModeBox;
    private JComboBox imageTypeBox;
    private JMimeTypeButton exportMimeTypesButton;
    private JCheckBox zipExportBox;
    private JCheckBox publicIdBox;
    private JCheckBox energyCertificateBox;
    private OpenEstateLocaleComboBox exportLocaleBox;

    public IS24CsvExportPanel() {
        this.build();
    }

    private void build() {
        this.resourceMap = ImmoToolUtils.getResourceMap(IS24CsvExportPanel.class);
        this.validationHandler = ImmoToolUtils.createValidationHandler();
        this.buildForm();
        this.imageTypeBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                IS24CsvExportPanel.this.exportMimeTypesButton.setEnabled(IS24CsvExportPanel.this.imageTypeBox.getSelectedIndex() > 0);
            }
        });
        this.resourceMap.injectComponents((Component)this);
        this.load(null);
        this.validationHandler.init();
    }

    private void buildForm() {
        this.zipExportBox = new JCheckBox();
        this.zipExportBox.setName("zipExportBox");
        this.publicIdBox = new JCheckBox();
        this.publicIdBox.setName("publicIdBox");
        this.energyCertificateBox = new JCheckBox();
        this.energyCertificateBox.setName("energyCertificateBox");
        this.agentIdField = new JTextField();
        this.agentIdField.setName("agentIdField");
        this.estateIdPrefixField = new JTextField();
        this.estateIdPrefixField.setName("estateIdPrefixField");
        this.exportLocaleBox = new OpenEstateLocaleComboBox(true, AgencyPlugin.getLocales());
        this.exportLocaleBox.setName("exportLocaleBox");
        this.exportModeBox = new JComboBox(new DefaultComboBoxModel());
        this.exportModeBox.setName("exportModeBox");
        this.exportModeBox.setPrototypeDisplayValue("XXXXXXXXXXXXXXXXXXXX");
        ((DefaultComboBoxModel)this.exportModeBox.getModel()).addElement(this.resourceMap.getString("label.exportMode.incremental", new Object[0]));
        ((DefaultComboBoxModel)this.exportModeBox.getModel()).addElement(this.resourceMap.getString("label.exportMode.full", new Object[0]));
        this.validationHandler.putRule((JComponent)this.agentIdField, ValidationHandler.NOT_BLANK);
        this.validationHandler.putRule((JComponent)this.exportLocaleBox, (ValidationRule)new NonEmptyComboBoxRule((JComboBox)this.exportLocaleBox));
        this.imageTypeBox = new JComboBox(new DefaultComboBoxModel());
        this.imageTypeBox.setName("imageTypeBox");
        this.imageTypeBox.setPrototypeDisplayValue("XXXXXXXXXXXXXXXXXXXX");
        ((DefaultComboBoxModel)this.imageTypeBox.getModel()).addElement(this.resourceMap.getString("label.imageType.disabled", new Object[0]));
        ((DefaultComboBoxModel)this.imageTypeBox.getModel()).addElement(this.resourceMap.getString("label.imageType.file", new Object[0]));
        this.exportMimeTypesButton = new JMimeTypeButton();
        this.exportMimeTypesButton.setName("exportMimeTypesButton");
        this.exportMimeTypesButton.setHorizontalAlignment(2);
        try {
            this.exportMimeTypesButton.addApplicationTypes(new String[]{"application/pdf"});
            this.exportMimeTypesButton.addImageTypes(new String[]{"image/bmp", "image/gif", "image/jpeg", "image/png"});
            this.exportMimeTypesButton.addVideoTypes(new String[]{"video/avi", "video/mpeg", "video/msvideo", "video/quicktime", "video/x-ms-wmv", "video/x-msvideo"});
        }
        catch (MimeTypeParseException mimeTypeParseException) {
            LOGGER.error((Object)"Can't parse MIME types!");
            LOGGER.error((Object)("> " + mimeTypeParseException.getLocalizedMessage()));
        }
        DefaultFormBuilder defaultFormBuilder = ImmoToolUtils.createFormBuilder((String)"right:pref, 3dlu, 50dlu:grow, 3dlu, right:pref, 3dlu, 50dlu", (JPanel)this);
        defaultFormBuilder.append(this.resourceMap.getString("label.agentId", new Object[0]), (Component)this.agentIdField);
        defaultFormBuilder.append((Component)this.exportLocaleBox, 3);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(this.resourceMap.getString("label.imageType", new Object[0]), (Component)this.imageTypeBox);
        defaultFormBuilder.append((Component)this.exportMimeTypesButton, 3);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(this.resourceMap.getString("label.exportMode", new Object[0]), (Component)this.exportModeBox);
        defaultFormBuilder.append(this.resourceMap.getString("label.estateIdPrefix", new Object[0]), (Component)this.estateIdPrefixField);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(this.resourceMap.getString("label.options", new Object[0]), (Component)this.zipExportBox, 5);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append("", (Component)this.publicIdBox, 5);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append("", (Component)this.energyCertificateBox, 5);
        defaultFormBuilder.nextLine();
        this.revalidate();
        this.repaint();
    }

    @Override
    public List<String> getWarnings() {
        List<String> list = super.getWarnings();
        if (this.exportModeBox.getSelectedIndex() != 0) {
            list.add(this.resourceMap.getString("warning.fullTransfer", new Object[0]));
        }
        if (this.publicIdBox.isSelected()) {
            list.add(this.resourceMap.getString("warning.publicIdExport", new Object[0]));
        }
        return list;
    }

    @Override
    public boolean isValidInput() {
        this.validationHandler.validate();
        return this.validationHandler.isValid();
    }

    @Override
    public final void load(AbstractExport abstractExport) {
        if (abstractExport == null) {
            this.zipExportBox.setSelected(true);
            this.publicIdBox.setSelected(false);
            this.energyCertificateBox.setSelected(false);
            this.exportModeBox.setSelectedIndex(-1);
            this.exportLocaleBox.setSelectedIndex(-1);
            this.agentIdField.setText("");
            this.estateIdPrefixField.setText("");
            this.imageTypeBox.setSelectedIndex(-1);
            this.exportMimeTypesButton.clearSelection();
            this.exportMimeTypesButton.setEnabled(false);
        } else if (abstractExport instanceof IS24CsvExport) {
            IS24CsvExport iS24CsvExport = (IS24CsvExport)abstractExport;
            this.zipExportBox.setSelected(iS24CsvExport.isZipped());
            this.publicIdBox.setSelected(iS24CsvExport.isPublicIdUsed());
            this.energyCertificateBox.setSelected(iS24CsvExport.isEnergyCertificateAppendedToDescription());
            this.agentIdField.setText(iS24CsvExport.getAgentId());
            this.estateIdPrefixField.setText(iS24CsvExport.getIdPrefix());
            this.exportLocaleBox.setSelectedLocale(abstractExport.getLocale());
            this.exportModeBox.setSelectedIndex(iS24CsvExport.isIncremental() ? 0 : 1);
            this.imageTypeBox.setSelectedIndex(iS24CsvExport.isImageModeFile() ? 1 : 0);
            this.exportMimeTypesButton.clearSelection();
            this.exportMimeTypesButton.setEnabled(this.imageTypeBox.getSelectedIndex() > 0);
            if (this.exportMimeTypesButton.isEnabled()) {
                for (JMimeTypeButton.Item item : this.exportMimeTypesButton.getMimeTypeItems()) {
                    String string = item.getMimeType().toString();
                    item.setSelected(abstractExport.getMimeTypes().contains(string));
                }
            }
        } else {
            throw new IllegalArgumentException("invalid export-class: " + abstractExport.getClass().getName());
        }
        this.validationHandler.init();
    }

    @Override
    public void save(AbstractExport abstractExport) {
        if (abstractExport instanceof IS24CsvExport) {
            IS24CsvExport iS24CsvExport = (IS24CsvExport)abstractExport;
            iS24CsvExport.setZipped(this.zipExportBox.isSelected());
            iS24CsvExport.setPublicIdUsed(this.publicIdBox.isSelected());
            iS24CsvExport.setEnergyCertificateAppendedToDescription(this.energyCertificateBox.isSelected());
            iS24CsvExport.setAgentId(this.agentIdField.getText().trim());
            iS24CsvExport.setIdPrefix(this.estateIdPrefixField.getText().trim());
            iS24CsvExport.setIncremental(this.exportModeBox.getSelectedIndex() == 0);
            iS24CsvExport.setLanguage(this.exportLocaleBox.getSelectedLocale());
            if (this.imageTypeBox.getSelectedIndex() == 1) {
                iS24CsvExport.setImageMode("file");
            } else {
                iS24CsvExport.setImageMode("disabled");
            }
            abstractExport.getMimeTypes().clear();
            if (this.imageTypeBox.getSelectedIndex() > 0) {
                for (JMimeTypeButton.Item item : this.exportMimeTypesButton.getMimeTypeItems()) {
                    if (!item.isSelected()) continue;
                    abstractExport.getMimeTypes().add(item.getMimeType().toString());
                }
            }
        } else {
            throw new IllegalArgumentException("invalid export-class: " + abstractExport.getClass().getName());
        }
    }
}

