/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency.export;

import com.openindex.openestate.impl.SerializableXmlElement;
import com.openindex.openestate.impl.xml.IS24XmlUtils;
import com.openindex.openestate.impl.xml.is24.IS24ImmobilienTransfer;
import com.openindex.openestate.impl.xml.is24.ImmobilienTransferTyp;
import com.openindex.openestate.tool.ImmoToolApp;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.agency.AgencyEstate;
import com.openindex.openestate.tool.agency.AgencyExportSummary;
import com.openindex.openestate.tool.agency.export.AbstractExportPanel;
import com.openindex.openestate.tool.agency.export.AbstractXmlExport;
import com.openindex.openestate.tool.agency.export.IS24XmlExportPanel;
import com.openindex.openestate.tool.agency.utils.IS24XmlWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.IOExceptionWithCause;
import org.apache.commons.lang.SystemUtils;
import org.apache.log4j.Logger;

public class IS24XmlExport
extends AbstractXmlExport {
    private static final Logger LOGGER = Logger.getLogger(IS24XmlExport.class);
    public static final String KEY_AGENT_ID = "export.is24_xml.agent_id";
    public static final String KEY_TECHN_MAIL = "export.is24_xml.techn_mail";
    public static final String KEY_PUBLIC_ID_USED = "export.is24_xml.public_id_used";
    @Deprecated
    private static final String KEY_PUBLIC_ID_USED_OLD = "export.is24_csv.public_id_used";
    public static final String NAME = "is24_xml";
    private String agentId = "";
    private String technMail = "";
    private boolean publicIdUsed;

    public IS24XmlExport() {
        this.setIncremental(true);
        this.setZipped(true);
        this.setLanguage(Locale.GERMAN);
        this.setPublicIdUsed(false);
    }

    @Override
    public AbstractExportPanel createSetupPanel() {
        return new IS24XmlExportPanel();
    }

    @Override
    public Object doConvert(AgencyExportSummary agencyExportSummary, SerializableXmlElement serializableXmlElement, boolean bl, Map<String, String> map) {
        IS24XmlWriter iS24XmlWriter = new IS24XmlWriter();
        if ("xhtml".equals(this.getLineBreak())) {
            iS24XmlWriter.setXmlLineSeparator("<br/>");
        } else if ("html".equals(this.getLineBreak())) {
            iS24XmlWriter.setXmlLineSeparator("<br>");
        } else if ("native".equals(this.getLineBreak())) {
            iS24XmlWriter.setXmlLineSeparator(SystemUtils.LINE_SEPARATOR);
        }
        iS24XmlWriter.setEnergyCertificateAppendedToDescription(this.isEnergyCertificateAppendedToDescription());
        IS24ImmobilienTransfer iS24ImmobilienTransfer = iS24XmlWriter.write(serializableXmlElement);
        ImmobilienTransferTyp immobilienTransferTyp = (ImmobilienTransferTyp)iS24ImmobilienTransfer.getValue();
        map.putAll(iS24XmlWriter.getErrorMap());
        String string = this.getTechnMail();
        if (string == null || string.trim().length() == 0) {
            try {
                string = ImmoToolApp.getApplication().getProject().getAdress().getCompanyMail();
                if (string == null) {
                    string = "";
                }
            }
            catch (Exception exception) {
                string = "";
                LOGGER.warn((Object)"could not load 'techn_mail'!");
                LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
            }
        }
        immobilienTransferTyp.setEmailBeiFehler(string.trim());
        String string2 = this.getAgentId();
        if (string2 != null && string2.trim().length() > 0) {
            immobilienTransferTyp.getAnbieter().setScoutKundenID(string2);
        }
        return iS24ImmobilienTransfer;
    }

    @Override
    protected void doWrite(Object object, Writer writer) throws IOException {
        try {
            IS24XmlUtils.createMarshaller().marshal(object, writer);
        }
        catch (Exception exception) {
            LOGGER.error((Object)"Can't write IS24-XML!");
            LOGGER.error((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
            throw new IOExceptionWithCause("Can't write IS24-XML!", (Throwable)exception);
        }
    }

    public String getAgentId() {
        return this.agentId;
    }

    @Override
    protected boolean getEstateForUpdate(AgencyEstate agencyEstate) {
        boolean bl = super.getEstateForUpdate(agencyEstate);
        if (!bl) {
            return false;
        }
        if (this.isPublicIdUsed()) {
            agencyEstate.setId(agencyEstate.getPublicId());
        }
        return true;
    }

    @Override
    protected String getEstateIdForRemoval(Long l, AgencyExportSummary agencyExportSummary) {
        return this.isPublicIdUsed() && agencyExportSummary.getRemovedEstatePublicIds().containsKey(l) ? agencyExportSummary.getRemovedEstatePublicIds().get(l) : super.getEstateIdForRemoval(l, agencyExportSummary);
    }

    @Override
    public String getName() {
        return NAME;
    }

    public String getTechnMail() {
        return this.technMail;
    }

    @Override
    public String getTitle() {
        return "IS24-XML (rev 189438)";
    }

    @Override
    public String getXmlFileName() {
        String string = super.getXmlFileName();
        char c = this.isIncremental() ? (char)'t' : 'v';
        return string.substring(0, string.lastIndexOf(".")) + "_st_Z7P_im" + c + ".xml";
    }

    @Override
    public String getZipFileName() {
        String string = super.getZipFileName();
        char c = this.isIncremental() ? (char)'t' : 'v';
        return string.substring(0, string.lastIndexOf(".")) + "_st_Z7P_im" + c + ".zip";
    }

    public boolean isPublicIdUsed() {
        return this.publicIdUsed;
    }

    @Override
    public void load(Properties properties) {
        super.load(properties);
        this.setAgentId(properties.getProperty(KEY_AGENT_ID, ""));
        this.setImageMode(properties.getProperty("export.imagemode", "file"));
        this.setIncremental(ImmoToolUtils.getPropertyAsBoolean((String)"export.incremental", (Boolean)false, (Properties)properties));
        this.setLineBreak(properties.getProperty("export.linebreak", "xhtml"));
        this.setPublicIdUsed(ImmoToolUtils.getPropertyAsBoolean((String)KEY_PUBLIC_ID_USED, (Boolean)ImmoToolUtils.getPropertyAsBoolean((String)KEY_PUBLIC_ID_USED_OLD, (Boolean)false, (Properties)properties), (Properties)properties));
        this.setTechnMail(properties.getProperty(KEY_TECHN_MAIL, ""));
    }

    @Override
    public void save(Properties properties) {
        super.save(properties);
        properties.setProperty(KEY_AGENT_ID, this.getAgentId());
        properties.setProperty("export.imagemode", this.getImageMode());
        properties.setProperty("export.incremental", Boolean.valueOf(this.isIncremental()).toString());
        properties.setProperty("export.linebreak", this.getLineBreak());
        properties.setProperty(KEY_PUBLIC_ID_USED, Boolean.valueOf(this.isPublicIdUsed()).toString());
        properties.setProperty(KEY_TECHN_MAIL, this.getTechnMail());
    }

    public void setAgentId(String string) {
        this.agentId = string != null ? string.trim() : "";
    }

    @Override
    public void setLanguage(Locale locale) {
        super.setLanguage(locale != null ? locale : Locale.GERMAN);
    }

    public void setPublicIdUsed(boolean bl) {
        this.publicIdUsed = bl;
    }

    public void setTechnMail(String string) {
        this.technMail = string != null ? string.trim() : "";
    }

    @Override
    public final boolean supportsIncrementalUpdate() {
        return true;
    }
}

