/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency.export;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.openindex.openestate.impl.utils.OpenEstateLocaleComboBox;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.agency.AgencyPlugin;
import com.openindex.openestate.tool.agency.export.AbstractExport;
import com.openindex.openestate.tool.agency.export.AbstractExportPanel;
import com.openindex.openestate.tool.agency.export.IS24XmlExport;
import com.openindex.openestate.tool.utils.JMimeTypeButton;
import com.openindex.openestate.tool.utils.NonEmptyComboBoxRule;
import com.openindex.openestate.tool.utils.ValidationHandler;
import com.openindex.openestate.tool.utils.ValidationRule;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.activation.MimeTypeParseException;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.apache.log4j.Logger;
import org.jdesktop.application.ResourceMap;

public class IS24XmlExportPanel
extends AbstractExportPanel {
    private static final Logger LOGGER = Logger.getLogger(IS24XmlExportPanel.class);
    private ResourceMap resourceMap;
    private ValidationHandler validationHandler;
    private JTextField agentIdField;
    private JTextField estateIdPrefixField;
    private JTextField technMailField;
    private JComboBox exportModeBox;
    private JComboBox exportLineBreakBox;
    private JComboBox imageTypeBox;
    private JMimeTypeButton exportMimeTypesButton;
    private JCheckBox zipExportBox;
    private JCheckBox publicIdBox;
    private JCheckBox energyCertificateBox;
    private OpenEstateLocaleComboBox exportLocaleBox;

    public IS24XmlExportPanel() {
        this.build();
    }

    private void build() {
        this.resourceMap = ImmoToolUtils.getResourceMap(IS24XmlExportPanel.class);
        this.validationHandler = ImmoToolUtils.createValidationHandler();
        this.buildForm();
        this.imageTypeBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                IS24XmlExportPanel.this.exportMimeTypesButton.setEnabled(IS24XmlExportPanel.this.imageTypeBox.getSelectedIndex() > 0);
            }
        });
        this.resourceMap.injectComponents((Component)this);
        this.load(null);
        this.validationHandler.init();
    }

    private void buildForm() {
        this.zipExportBox = new JCheckBox();
        this.zipExportBox.setName("zipExportBox");
        this.publicIdBox = new JCheckBox();
        this.publicIdBox.setName("publicIdBox");
        this.energyCertificateBox = new JCheckBox();
        this.energyCertificateBox.setName("energyCertificateBox");
        this.agentIdField = new JTextField();
        this.agentIdField.setName("agentIdField");
        this.estateIdPrefixField = new JTextField();
        this.estateIdPrefixField.setName("estateIdPrefixField");
        this.technMailField = new JTextField();
        this.technMailField.setName("technMailField");
        this.exportLocaleBox = new OpenEstateLocaleComboBox(true, AgencyPlugin.getLocales());
        this.exportLocaleBox.setName("exportLocaleBox");
        this.exportModeBox = new JComboBox(new DefaultComboBoxModel());
        this.exportModeBox.setName("exportModeBox");
        this.exportModeBox.setPrototypeDisplayValue("XXXXXXXXXXXXXXXXXXXX");
        ((DefaultComboBoxModel)this.exportModeBox.getModel()).addElement(this.resourceMap.getString("label.exportMode.incremental", new Object[0]));
        ((DefaultComboBoxModel)this.exportModeBox.getModel()).addElement(this.resourceMap.getString("label.exportMode.full", new Object[0]));
        this.exportLineBreakBox = new JComboBox(new DefaultComboBoxModel());
        this.exportLineBreakBox.setName("exportLineBreakBox");
        this.exportLineBreakBox.setPrototypeDisplayValue("XXXXXXXXXXXXXXXXXXXX");
        ((DefaultComboBoxModel)this.exportLineBreakBox.getModel()).addElement(this.resourceMap.getString("label.exportLineBreak.xhtml", new Object[0]));
        ((DefaultComboBoxModel)this.exportLineBreakBox.getModel()).addElement(this.resourceMap.getString("label.exportLineBreak.html", new Object[0]));
        ((DefaultComboBoxModel)this.exportLineBreakBox.getModel()).addElement(this.resourceMap.getString("label.exportLineBreak.native", new Object[0]));
        this.imageTypeBox = new JComboBox(new DefaultComboBoxModel());
        this.imageTypeBox.setName("imageTypeBox");
        this.imageTypeBox.setPrototypeDisplayValue("XXXXXXXXXXXXXXXXXXXX");
        ((DefaultComboBoxModel)this.imageTypeBox.getModel()).addElement(this.resourceMap.getString("label.imageType.disabled", new Object[0]));
        ((DefaultComboBoxModel)this.imageTypeBox.getModel()).addElement(this.resourceMap.getString("label.imageType.file", new Object[0]));
        this.exportMimeTypesButton = new JMimeTypeButton();
        this.exportMimeTypesButton.setName("exportMimeTypesButton");
        this.exportMimeTypesButton.setHorizontalAlignment(2);
        try {
            this.exportMimeTypesButton.addApplicationTypes(new String[]{"application/pdf"});
            this.exportMimeTypesButton.addImageTypes();
            this.exportMimeTypesButton.addVideoTypes();
        }
        catch (MimeTypeParseException mimeTypeParseException) {
            LOGGER.error((Object)"Can't parse MIME types!");
            LOGGER.error((Object)("> " + mimeTypeParseException.getLocalizedMessage()));
        }
        this.validationHandler.putRule((JComponent)this.agentIdField, ValidationHandler.NOT_BLANK);
        this.validationHandler.putRule((JComponent)this.technMailField, ValidationHandler.EMAIL);
        this.validationHandler.putRule((JComponent)this.exportLocaleBox, (ValidationRule)new NonEmptyComboBoxRule((JComboBox)this.exportLocaleBox));
        DefaultFormBuilder defaultFormBuilder = ImmoToolUtils.createFormBuilder((String)"right:pref, 3dlu, 50dlu:grow, 3dlu, right:pref, 3dlu, 50dlu", (JPanel)this);
        defaultFormBuilder.append(this.resourceMap.getString("label.agentId", new Object[0]), (Component)this.agentIdField);
        defaultFormBuilder.append((Component)this.exportLocaleBox, 3);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(this.resourceMap.getString("label.technMail", new Object[0]), (Component)this.technMailField);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(this.resourceMap.getString("label.imageType", new Object[0]), (Component)this.imageTypeBox);
        defaultFormBuilder.append((Component)this.exportMimeTypesButton, 3);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(this.resourceMap.getString("label.exportMode", new Object[0]), (Component)this.exportModeBox);
        defaultFormBuilder.append(this.resourceMap.getString("label.estateIdPrefix", new Object[0]), (Component)this.estateIdPrefixField);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(this.resourceMap.getString("label.exportLineBreak", new Object[0]), (Component)this.exportLineBreakBox);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(this.resourceMap.getString("label.options", new Object[0]), (Component)this.zipExportBox, 5);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append("", (Component)this.publicIdBox, 5);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append("", (Component)this.energyCertificateBox, 5);
        defaultFormBuilder.nextLine();
        this.revalidate();
        this.repaint();
    }

    @Override
    public List<String> getWarnings() {
        List<String> list = super.getWarnings();
        if (this.exportModeBox.getSelectedIndex() != 0) {
            list.add(this.resourceMap.getString("warning.fullTransfer", new Object[0]));
        }
        if (this.publicIdBox.isSelected()) {
            list.add(this.resourceMap.getString("warning.publicIdExport", new Object[0]));
        }
        return list;
    }

    @Override
    public boolean isValidInput() {
        this.validationHandler.validate();
        return this.validationHandler.isValid();
    }

    @Override
    public final void load(AbstractExport abstractExport) {
        if (abstractExport == null) {
            this.exportModeBox.setSelectedIndex(-1);
            this.exportLineBreakBox.setSelectedIndex(-1);
            this.exportLocaleBox.setSelectedIndex(-1);
            this.imageTypeBox.setSelectedIndex(-1);
            this.zipExportBox.setSelected(true);
            this.publicIdBox.setSelected(false);
            this.energyCertificateBox.setSelected(false);
            this.agentIdField.setText("");
            this.estateIdPrefixField.setText("");
            this.technMailField.setText("");
            this.exportMimeTypesButton.clearSelection();
            this.exportMimeTypesButton.setEnabled(false);
        } else if (abstractExport instanceof IS24XmlExport) {
            IS24XmlExport iS24XmlExport = (IS24XmlExport)abstractExport;
            this.zipExportBox.setSelected(iS24XmlExport.isZipped());
            this.publicIdBox.setSelected(iS24XmlExport.isPublicIdUsed());
            this.energyCertificateBox.setSelected(iS24XmlExport.isEnergyCertificateAppendedToDescription());
            this.agentIdField.setText(iS24XmlExport.getAgentId());
            this.estateIdPrefixField.setText(iS24XmlExport.getIdPrefix());
            this.technMailField.setText(iS24XmlExport.getTechnMail());
            this.exportLocaleBox.setSelectedLocale(abstractExport.getLocale());
            this.exportModeBox.setSelectedIndex(iS24XmlExport.isIncremental() ? 0 : 1);
            this.imageTypeBox.setSelectedIndex(iS24XmlExport.isImageModeFile() ? 1 : 0);
            this.exportMimeTypesButton.clearSelection();
            this.exportMimeTypesButton.setEnabled(this.imageTypeBox.getSelectedIndex() > 0);
            if (this.exportMimeTypesButton.isEnabled()) {
                for (JMimeTypeButton.Item item : this.exportMimeTypesButton.getMimeTypeItems()) {
                    String string = item.getMimeType().toString();
                    item.setSelected(abstractExport.getMimeTypes().contains(string));
                }
            }
            if ("native".equals(iS24XmlExport.getLineBreak())) {
                this.exportLineBreakBox.setSelectedIndex(2);
            } else if ("html".equals(iS24XmlExport.getLineBreak())) {
                this.exportLineBreakBox.setSelectedIndex(1);
            } else {
                this.exportLineBreakBox.setSelectedIndex(0);
            }
        } else {
            throw new IllegalArgumentException("invalid export-class: " + abstractExport.getClass().getName());
        }
        this.validationHandler.init();
    }

    @Override
    public void save(AbstractExport abstractExport) {
        if (abstractExport instanceof IS24XmlExport) {
            IS24XmlExport iS24XmlExport = (IS24XmlExport)abstractExport;
            iS24XmlExport.setZipped(this.zipExportBox.isSelected());
            iS24XmlExport.setPublicIdUsed(this.publicIdBox.isSelected());
            iS24XmlExport.setEnergyCertificateAppendedToDescription(this.energyCertificateBox.isSelected());
            iS24XmlExport.setAgentId(this.agentIdField.getText().trim());
            iS24XmlExport.setIdPrefix(this.estateIdPrefixField.getText().trim());
            iS24XmlExport.setTechnMail(this.technMailField.getText().trim());
            iS24XmlExport.setIncremental(this.exportModeBox.getSelectedIndex() == 0);
            iS24XmlExport.setLanguage(this.exportLocaleBox.getSelectedLocale());
            if (this.exportLineBreakBox.getSelectedIndex() == 2) {
                iS24XmlExport.setLineBreak("native");
            } else if (this.exportLineBreakBox.getSelectedIndex() == 1) {
                iS24XmlExport.setLineBreak("html");
            } else {
                iS24XmlExport.setLineBreak("xhtml");
            }
            if (this.imageTypeBox.getSelectedIndex() == 1) {
                iS24XmlExport.setImageMode("file");
            } else {
                iS24XmlExport.setImageMode("disabled");
            }
            abstractExport.getMimeTypes().clear();
            if (this.imageTypeBox.getSelectedIndex() > 0) {
                for (JMimeTypeButton.Item item : this.exportMimeTypesButton.getMimeTypeItems()) {
                    if (!item.isSelected()) continue;
                    abstractExport.getMimeTypes().add(item.getMimeType().toString());
                }
            }
        } else {
            throw new IllegalArgumentException("invalid export-class: " + abstractExport.getClass().getName());
        }
    }
}

