/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency.export;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.agency.export.AbstractExport;
import com.openindex.openestate.tool.agency.export.AbstractExportPanel;
import com.openindex.openestate.tool.utils.NonEmptyComboBoxRule;
import com.openindex.openestate.tool.utils.ValidationHandler;
import com.openindex.openestate.tool.utils.ValidationRule;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.SpinnerNumberModel;
import org.apache.commons.lang.StringUtils;
import org.jdesktop.application.ResourceMap;

public class ImageExportPanel
extends AbstractExportPanel {
    private ResourceMap resourceMap;
    private ValidationHandler validationHandler;
    private JCheckBox exportUnpublishedImagesBox;
    private JCheckBox exportScaledImagesBox;
    private JTextField exportScaledImageWidthField;
    private JTextField exportScaledImageHeightField;
    private JCheckBox exportWatermarkImagesBox;
    private JTextField exportWatermarkImageWidthField;
    private JTextField exportWatermarkImageHeightField;
    private JSlider exportWatermarkAlphaSlider;
    private JComboBox exportWatermarkPositionBox;
    private JCheckBox exportImageCountBox;
    private JCheckBox exportVideoCountBox;
    private JSpinner exportImageCountSpinner;
    private JSpinner exportVideoCountSpinner;

    public ImageExportPanel() {
        this.build();
    }

    private void build() {
        this.resourceMap = ImmoToolUtils.getResourceMap(ImageExportPanel.class);
        this.validationHandler = ImmoToolUtils.createValidationHandler();
        this.buildForm();
        this.resourceMap.injectComponents((Component)this);
        this.exportScaledImagesBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ImageExportPanel.this.exportScaledImageWidthField.setEnabled(ImageExportPanel.this.exportScaledImagesBox.isSelected());
                ImageExportPanel.this.exportScaledImageHeightField.setEnabled(ImageExportPanel.this.exportScaledImagesBox.isSelected());
                ImageExportPanel.this.validationHandler.validate((JComponent)ImageExportPanel.this.exportScaledImageWidthField);
                ImageExportPanel.this.validationHandler.validate((JComponent)ImageExportPanel.this.exportScaledImageHeightField);
            }
        });
        this.exportWatermarkImagesBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ImageExportPanel.this.exportWatermarkImageWidthField.setEnabled(ImageExportPanel.this.exportWatermarkImagesBox.isSelected());
                ImageExportPanel.this.exportWatermarkImageHeightField.setEnabled(ImageExportPanel.this.exportWatermarkImagesBox.isSelected());
                ImageExportPanel.this.exportWatermarkAlphaSlider.setEnabled(ImageExportPanel.this.exportWatermarkImagesBox.isSelected());
                ImageExportPanel.this.exportWatermarkPositionBox.setEnabled(ImageExportPanel.this.exportWatermarkImagesBox.isSelected());
                ImageExportPanel.this.validationHandler.validate((JComponent)ImageExportPanel.this.exportWatermarkImageWidthField);
                ImageExportPanel.this.validationHandler.validate((JComponent)ImageExportPanel.this.exportWatermarkImageHeightField);
            }
        });
        this.exportImageCountBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ImageExportPanel.this.exportImageCountSpinner.setEnabled(ImageExportPanel.this.exportImageCountBox.isSelected());
            }
        });
        this.exportVideoCountBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ImageExportPanel.this.exportVideoCountSpinner.setEnabled(ImageExportPanel.this.exportVideoCountBox.isSelected());
            }
        });
    }

    private void buildForm() {
        this.exportUnpublishedImagesBox = new JCheckBox();
        this.exportUnpublishedImagesBox.setName("exportUnpublishedImagesBox");
        this.exportScaledImagesBox = new JCheckBox();
        this.exportScaledImagesBox.setName("exportScaledImagesBox");
        this.exportScaledImageWidthField = new JTextField();
        this.exportScaledImageWidthField.setEnabled(false);
        this.exportScaledImageWidthField.setName("exportScaledImageWidthField");
        this.exportScaledImageHeightField = new JTextField();
        this.exportScaledImageHeightField.setEnabled(false);
        this.exportScaledImageHeightField.setName("exportScaledImageHeightField");
        this.exportWatermarkImagesBox = new JCheckBox();
        this.exportWatermarkImagesBox.setName("exportWatermarkImagesBox");
        this.exportWatermarkImageWidthField = new JTextField();
        this.exportWatermarkImageWidthField.setEnabled(false);
        this.exportWatermarkImageWidthField.setName("exportWatermarkImageWidthField");
        this.exportWatermarkImageHeightField = new JTextField();
        this.exportWatermarkImageHeightField.setEnabled(false);
        this.exportWatermarkImageHeightField.setName("exportWatermarkImageHeightField");
        this.exportWatermarkAlphaSlider = new JSlider(0, 0, 100, 100);
        this.exportWatermarkAlphaSlider.setName("exportWatermarkAlphaSlider");
        this.exportWatermarkAlphaSlider.setMajorTickSpacing(20);
        this.exportWatermarkAlphaSlider.setMinorTickSpacing(10);
        this.exportWatermarkAlphaSlider.setPaintTicks(true);
        this.exportWatermarkAlphaSlider.setPaintLabels(true);
        this.exportWatermarkAlphaSlider.setFont(new JLabel().getFont().deriveFont(8.0f));
        this.exportWatermarkPositionBox = new JComboBox();
        this.exportWatermarkPositionBox.setName("exportWatermarkPositionBox");
        this.exportWatermarkPositionBox.setRenderer(new PositionRenderer());
        this.exportWatermarkPositionBox.setPrototypeDisplayValue("XXXXXXXXXXXXXXXXXXXX");
        this.exportWatermarkPositionBox.addItem(null);
        for (String string : AbstractExport.getPositions()) {
            this.exportWatermarkPositionBox.addItem(string);
        }
        this.exportImageCountBox = new JCheckBox();
        this.exportImageCountBox.setName("exportImageCountBox");
        this.exportVideoCountBox = new JCheckBox();
        this.exportVideoCountBox.setName("exportVideoCountBox");
        this.exportImageCountSpinner = new JSpinner(new SpinnerNumberModel(10, 0, 999, 1));
        this.exportImageCountSpinner.setName("exportImageCountSpinner");
        this.exportImageCountSpinner.setEnabled(false);
        this.exportVideoCountSpinner = new JSpinner(new SpinnerNumberModel(5, 0, 999, 1));
        this.exportVideoCountSpinner.setName("exportVideoCountSpinner");
        this.exportVideoCountSpinner.setEnabled(false);
        ValidationRule validationRule = new ValidationRule(){

            public boolean isValid(Object object) {
                String string;
                String string2 = string = object != null ? object.toString() : "";
                if (StringUtils.isEmpty((String)string)) {
                    return false;
                }
                try {
                    Integer n = Integer.valueOf(object.toString());
                    return n > 0;
                }
                catch (Exception exception) {
                    return false;
                }
            }
        };
        this.validationHandler.putRule((JComponent)this.exportScaledImageWidthField, validationRule);
        this.validationHandler.putRule((JComponent)this.exportScaledImageHeightField, validationRule);
        this.validationHandler.putRule((JComponent)this.exportWatermarkImageWidthField, validationRule);
        this.validationHandler.putRule((JComponent)this.exportWatermarkImageHeightField, validationRule);
        this.validationHandler.putRule((JComponent)this.exportWatermarkPositionBox, (ValidationRule)new NonEmptyComboBoxRule(this.exportWatermarkPositionBox));
        DefaultFormBuilder defaultFormBuilder = ImmoToolUtils.createFormBuilder((String)"right:pref, 3dlu, right:pref, 3dlu, 30dlu:grow, 3dlu, right:pref, 3dlu, 30dlu:grow", (JPanel)this);
        defaultFormBuilder.append(this.resourceMap.getString("label.options", new Object[0]), (Component)this.exportUnpublishedImagesBox, 7);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append((Component)new JLabel(" "));
        defaultFormBuilder.append((Component)this.exportImageCountBox, (Component)this.exportImageCountSpinner);
        defaultFormBuilder.append((Component)this.exportVideoCountBox, (Component)this.exportVideoCountSpinner);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(this.resourceMap.getString("label.scaling", new Object[0]), (Component)this.exportScaledImagesBox, 7);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append((Component)new JLabel(" "));
        defaultFormBuilder.append(this.resourceMap.getString("label.scaling.maxWidth", new Object[0]), (Component)this.exportScaledImageWidthField);
        defaultFormBuilder.append(this.resourceMap.getString("label.scaling.maxHeight", new Object[0]), (Component)this.exportScaledImageHeightField);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(this.resourceMap.getString("label.watermark", new Object[0]), (Component)this.exportWatermarkImagesBox, 7);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append((Component)new JLabel(" "));
        defaultFormBuilder.append(this.resourceMap.getString("label.watermark.width", new Object[0]), (Component)this.exportWatermarkImageWidthField);
        defaultFormBuilder.append(this.resourceMap.getString("label.watermark.height", new Object[0]), (Component)this.exportWatermarkImageHeightField);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append((Component)new JLabel(" "));
        defaultFormBuilder.append(this.resourceMap.getString("label.watermark.position", new Object[0]), (Component)this.exportWatermarkPositionBox);
        defaultFormBuilder.append(this.resourceMap.getString("label.watermark.alpha", new Object[0]), (Component)this.exportWatermarkAlphaSlider);
        defaultFormBuilder.nextLine();
        this.revalidate();
        this.repaint();
    }

    @Override
    public boolean isValidInput() {
        this.validationHandler.validate();
        return this.validationHandler.isValid();
    }

    @Override
    public void load(AbstractExport abstractExport) {
        this.exportUnpublishedImagesBox.setSelected(abstractExport.isAllImagesExported());
        Integer n = abstractExport.getImageCount();
        this.exportImageCountBox.setSelected(n != null && n >= 0);
        this.exportImageCountSpinner.setEnabled(this.exportImageCountBox.isSelected());
        this.exportImageCountSpinner.setValue(n != null && n >= 0 ? n : 0);
        Integer n2 = abstractExport.getVideoCount();
        this.exportVideoCountBox.setSelected(n2 != null && n2 >= 0);
        this.exportVideoCountSpinner.setEnabled(this.exportVideoCountBox.isSelected());
        this.exportVideoCountSpinner.setValue(n2 != null && n2 >= 0 ? n2 : 0);
        this.exportScaledImagesBox.setSelected(abstractExport.isScaleImages());
        this.exportScaledImageHeightField.setEnabled(abstractExport.isScaleImages());
        this.exportScaledImageHeightField.setText(abstractExport.isScaleImages() && abstractExport.getScaleImageHeight() != null ? abstractExport.getScaleImageHeight().toString() : "");
        this.exportScaledImageWidthField.setEnabled(abstractExport.isScaleImages());
        this.exportScaledImageWidthField.setText(abstractExport.isScaleImages() && abstractExport.getScaleImageWidth() != null ? abstractExport.getScaleImageWidth().toString() : "");
        this.exportWatermarkImagesBox.setSelected(abstractExport.isWatermark());
        this.exportWatermarkImageHeightField.setEnabled(abstractExport.isWatermark());
        this.exportWatermarkImageHeightField.setText(abstractExport.isWatermark() && abstractExport.getWatermarkHeight() != null ? abstractExport.getWatermarkHeight().toString() : "");
        this.exportWatermarkImageWidthField.setEnabled(abstractExport.isWatermark());
        this.exportWatermarkImageWidthField.setText(abstractExport.isWatermark() && abstractExport.getWatermarkWidth() != null ? abstractExport.getWatermarkWidth().toString() : "");
        if (abstractExport.isWatermark()) {
            this.exportWatermarkAlphaSlider.setEnabled(true);
            this.exportWatermarkAlphaSlider.setValue(abstractExport.getWatermarkAlpha() != null ? abstractExport.getWatermarkAlpha() : 100);
            this.exportWatermarkPositionBox.setEnabled(true);
            this.exportWatermarkPositionBox.setSelectedItem(abstractExport.getWatermarkPosition());
        } else {
            this.exportWatermarkAlphaSlider.setEnabled(false);
            this.exportWatermarkAlphaSlider.setValue(100);
            this.exportWatermarkPositionBox.setEnabled(false);
            this.exportWatermarkPositionBox.setSelectedIndex(0);
        }
        this.validationHandler.init();
    }

    @Override
    public void save(AbstractExport abstractExport) {
        abstractExport.setAllImagesExported(this.exportUnpublishedImagesBox.isSelected());
        Number number = (Number)this.exportImageCountSpinner.getValue();
        abstractExport.setImageCount(this.exportImageCountBox.isSelected() && number != null ? Integer.valueOf(number.intValue()) : null);
        Number number2 = (Number)this.exportVideoCountSpinner.getValue();
        abstractExport.setVideoCount(this.exportVideoCountBox.isSelected() && number2 != null ? Integer.valueOf(number2.intValue()) : null);
        abstractExport.setScaleImages(this.exportScaledImagesBox.isSelected());
        abstractExport.setScaleImageHeight(abstractExport.isScaleImages() ? Integer.valueOf(this.exportScaledImageHeightField.getText()) : 0);
        abstractExport.setScaleImageWidth(abstractExport.isScaleImages() ? Integer.valueOf(this.exportScaledImageWidthField.getText()) : 0);
        abstractExport.setWatermark(this.exportWatermarkImagesBox.isSelected());
        abstractExport.setWatermarkHeight(abstractExport.isWatermark() ? Integer.valueOf(this.exportWatermarkImageHeightField.getText()) : 0);
        abstractExport.setWatermarkWidth(abstractExport.isWatermark() ? Integer.valueOf(this.exportWatermarkImageWidthField.getText()) : 0);
        abstractExport.setWatermarkAlpha(abstractExport.isWatermark() ? this.exportWatermarkAlphaSlider.getValue() : 0);
        abstractExport.setWatermarkPosition((String)(abstractExport.isWatermark() ? this.exportWatermarkPositionBox.getSelectedItem() : null));
    }

    private class PositionRenderer
    extends JLabel
    implements ListCellRenderer {
        public PositionRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            this.setBackground(bl ? jList.getSelectionBackground() : jList.getBackground());
            this.setForeground(bl ? jList.getSelectionForeground() : jList.getForeground());
            if (object instanceof String) {
                this.setText(" " + ImageExportPanel.this.resourceMap.getString("label.watermark.position." + object.toString(), new Object[0]));
            } else {
                this.setText(" [" + ImageExportPanel.this.resourceMap.getString("label.watermark.position.undefined", new Object[0]) + "]");
            }
            return this;
        }
    }
}

