/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency.export;

import com.openindex.openestate.impl.SerializableXmlElement;
import com.openindex.openestate.impl.xml.OpenImmoAnswer;
import com.openindex.openestate.impl.xml.OpenImmoUtils;
import com.openindex.openestate.impl.xml.openimmo.Anbieter;
import com.openindex.openestate.impl.xml.openimmo.Immobilie;
import com.openindex.openestate.impl.xml.openimmo.Openimmo;
import com.openindex.openestate.impl.xml.openimmo.Sonstige;
import com.openindex.openestate.impl.xml.openimmo.UserDefinedAnyfield;
import com.openindex.openestate.tool.ImmoToolTask;
import com.openindex.openestate.tool.ImmoToolTaskCancelledException;
import com.openindex.openestate.tool.agency.AgencyExportSummary;
import com.openindex.openestate.tool.agency.export.AbstractExportPanel;
import com.openindex.openestate.tool.agency.export.ImmoNetExportPanel;
import com.openindex.openestate.tool.agency.export.OpenImmoXmlExport;
import java.io.Reader;
import java.io.StringReader;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.dom4j.DocumentException;

public class ImmoNetExport
extends OpenImmoXmlExport {
    private static final Logger LOGGER = Logger.getLogger(ImmoNetExport.class);
    private static final String ANYFIELD_IVD = "ivdrechte";
    public static final String TO_ALL = "all";
    public static final String TO_IVD = "ivd";
    public static final String KEY_RECIPIENT = "export.openimmo.immonet.recipient";
    private String recipient = "all";

    public ImmoNetExport() {
        this.setZipped(true);
        this.setIncremental(true);
        this.setLineBreak("xhtml");
        this.setLanguage(Locale.GERMAN);
        this.setPublicIdSubmitted(true);
    }

    @Override
    public AbstractExportPanel createSetupPanel() {
        return new ImmoNetExportPanel();
    }

    @Override
    public Object doConvert(AgencyExportSummary agencyExportSummary, SerializableXmlElement serializableXmlElement, boolean bl, Map<String, String> map) {
        JAXBElement jAXBElement;
        String string2;
        Openimmo openimmo = (Openimmo)super.doConvert(agencyExportSummary, serializableXmlElement, bl, map);
        if (openimmo == null) {
            return null;
        }
        if (!TO_ALL.equals(this.getRecipient())) {
            int n = TO_IVD.equals(this.getRecipient()) ? 1 : 0;
            for (Object object : openimmo.getAnbieter()) {
                for (String string2 : object.getImmobilie()) {
                    jAXBElement = new JAXBElement(new QName(ANYFIELD_IVD), Integer.class, (Object)n);
                    UserDefinedAnyfield userDefinedAnyfield = OpenImmoUtils.getFactory().createUserDefinedAnyfield();
                    userDefinedAnyfield.getContent().add(jAXBElement);
                    if (string2.getVerwaltungTechn() == null) {
                        string2.setVerwaltungTechn(OpenImmoUtils.getFactory().createVerwaltungTechn());
                    }
                    string2.getVerwaltungTechn().getUserDefinedAnyfield().add(userDefinedAnyfield);
                }
            }
        }
        for (Anbieter anbieter : openimmo.getAnbieter()) {
            for (Immobilie immobilie : anbieter.getImmobilie()) {
                string2 = immobilie.getVerwaltungTechn() != null ? immobilie.getVerwaltungTechn().getObjektnrExtern() : null;
                if (StringUtils.isEmpty((String)string2)) continue;
                immobilie.getVerwaltungTechn().setObjektnrExtern(StringUtils.abbreviate((String)string2, (int)80));
            }
        }
        for (Anbieter anbieter : openimmo.getAnbieter()) {
            for (Immobilie immobilie : anbieter.getImmobilie()) {
                if (immobilie.getObjektkategorie() == null || immobilie.getObjektkategorie().getObjektart() == null || immobilie.getObjektkategorie().getNutzungsart() == null || immobilie.getObjektkategorie().getObjektart().getSonstige().isEmpty() || !Sonstige.SonstigeTyp.GARAGEN.equals((Object)(string2 = (Sonstige)immobilie.getObjektkategorie().getObjektart().getSonstige().get(0)).getSonstigeTyp()) && !Sonstige.SonstigeTyp.PARKFLACHE.equals((Object)string2.getSonstigeTyp()) && !Sonstige.SonstigeTyp.PARKHAUS.equals((Object)string2.getSonstigeTyp()) && !Sonstige.SonstigeTyp.SONSTIGE.equals((Object)string2.getSonstigeTyp()) || Boolean.TRUE.equals((jAXBElement = immobilie.getObjektkategorie().getNutzungsart()).isANLAGE()) || Boolean.TRUE.equals(jAXBElement.isGEWERBE()) || Boolean.TRUE.equals(jAXBElement.isWAZ()) || Boolean.TRUE.equals(jAXBElement.isWOHNEN())) continue;
                LOGGER.info((Object)"Force use of <nutzungsart WOHNEN=\"true\" /> because of compatibility issues with immonet.de!");
                if (immobilie.getVerwaltungTechn() != null) {
                    if (immobilie.getVerwaltungTechn().getObjektnrIntern() != null) {
                        LOGGER.info((Object)("> for <objektnr_intern>" + immobilie.getVerwaltungTechn().getObjektnrIntern() + "</objektnr_intern>"));
                    }
                    if (immobilie.getVerwaltungTechn().getObjektnrExtern() != null) {
                        LOGGER.info((Object)("> for <objektnr_extern>" + immobilie.getVerwaltungTechn().getObjektnrExtern() + "</objektnr_extern>"));
                    }
                }
                jAXBElement.setWOHNEN(true);
            }
        }
        return openimmo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doFinishExport(AgencyExportSummary agencyExportSummary, String[] stringArray, ImmoToolTask.Callback callback) throws ImmoToolTaskCancelledException {
        super.doFinishExport(agencyExportSummary, stringArray, callback);
        if (stringArray == null || stringArray.length < 1) {
            return;
        }
        for (String string : stringArray) {
            StringReader stringReader = null;
            try {
                stringReader = new StringReader(string);
                OpenImmoAnswer openImmoAnswer = OpenImmoAnswer.read((Reader)stringReader);
                for (OpenImmoAnswer.Anbieter anbieter : openImmoAnswer.getAnbieter()) {
                    for (OpenImmoAnswer.Immobilie immobilie : anbieter.getImmobilie()) {
                        if (!immobilie.isFEHLER()) continue;
                        String string2 = immobilie.getObjektId();
                        Long l = Long.valueOf(string2.split("\\.")[1]);
                        String string3 = immobilie.getMessage();
                        if (StringUtils.isBlank((String)string3)) {
                            string3 = "";
                        }
                        if (agencyExportSummary.getErrorEstateMap().containsKey(l)) {
                            String string4 = agencyExportSummary.getErrorEstateMap().get(l).trim();
                            if (!StringUtils.isBlank((String)string3)) {
                                string4 = string4 + ";" + string3;
                            }
                            agencyExportSummary.getErrorEstateMap().put(l, string4.trim());
                            continue;
                        }
                        agencyExportSummary.getErrorEstateMap().put(l, string3.trim());
                    }
                }
            }
            catch (DocumentException documentException) {
                try {
                    LOGGER.warn((Object)"Can't read <immoanswer>!");
                    LOGGER.warn((Object)("> " + documentException.getLocalizedMessage()), (Throwable)documentException);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(stringReader);
                    throw throwable;
                }
                IOUtils.closeQuietly((Reader)stringReader);
                continue;
            }
            IOUtils.closeQuietly((Reader)stringReader);
        }
    }

    @Override
    public String getName() {
        return "immonet";
    }

    public String getRecipient() {
        return this.recipient;
    }

    @Override
    public String getTitle() {
        return "Portal: Immonet.de";
    }

    @Override
    public void load(Properties properties) {
        super.load(properties);
        this.recipient = properties.getProperty(KEY_RECIPIENT, TO_ALL);
    }

    @Override
    public void save(Properties properties) {
        super.save(properties);
        properties.setProperty(KEY_RECIPIENT, this.recipient != null ? this.recipient : TO_ALL);
    }

    @Override
    public void setLanguage(Locale locale) {
        super.setLanguage(locale != null ? locale : Locale.GERMAN);
    }

    public void setRecipient(String string) {
        this.recipient = string;
    }
}

